@extends('layouts.admin')

@section('title', 'Salon Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Salonlar</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 style="color: #10b981;">
            <i class="bi bi-building"></i> Salon Yönetimi
        </h2>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createSalonModal">
            <i class="bi bi-plus-circle"></i> Yeni Salon Ekle
        </button>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($salons->isEmpty())
        <div class="card shadow-sm">
            <div class="card-body text-center py-5">
                <i class="bi bi-building" style="font-size: 4rem; color: #10b981; opacity: 0.3;"></i>
                <h5 class="mt-3 text-muted">Henüz salon eklenmemiş</h5>
                <p class="text-muted">İlk salonunuzu oluşturmak için yukarıdaki "Yeni Salon Ekle" butonuna tıklayın.</p>
            </div>
        </div>
    @else
        <div class="row">
            @foreach($salons as $salon)
                <div class="col-md-6 mb-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); color: white;">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0 text-white"><i class="bi bi-building"></i> {{ $salon->name }}</h5>
                                <div class="btn-group">
                                    <a href="{{ route('admin.settings.salons.edit', $salon->id) }}" class="btn btn-sm btn-light">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <i class="bi bi-telephone text-primary" style="font-size: 1.2rem;"></i>
                                        <div>
                                            <small class="text-muted d-block">Telefon</small>
                                            <strong>{{ $salon->phone ?? '-' }}</strong>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <i class="bi bi-people text-primary" style="font-size: 1.2rem;"></i>
                                        <div>
                                            <small class="text-muted d-block">Kapasite</small>
                                            <strong>{{ $salon->capacity ?? 0 }} kişi</strong>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="d-flex align-items-start gap-2 mb-3">
                                        <i class="bi bi-geo-alt text-primary" style="font-size: 1.2rem; margin-top: 2px;"></i>
                                        <div>
                                            <small class="text-muted d-block">Adres</small>
                                            <strong>{{ $salon->address ?? '-' }}</strong>
                                        </div>
                                    </div>
                                </div>
                                @if($salon->city || $salon->district)
                                <div class="col-12">
                                    <div class="d-flex align-items-start gap-2 mb-3">
                                        <i class="bi bi-geo-alt-fill text-primary" style="font-size: 1.2rem; margin-top: 2px;"></i>
                                        <div>
                                            <small class="text-muted d-block">Konum</small>
                                            <strong>{{ ($salon->district ?? '') ? $salon->district . ', ' : '' }}{{ $salon->city ?? '-' }}</strong>
                                        </div>
                                    </div>
                                </div>
                                @endif
                                <div class="col-12">
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="badge {{ $salon->is_active ? 'bg-success' : 'bg-secondary' }}" style="font-size: 0.9rem;">
                                            {{ $salon->is_active ? 'Aktif' : 'Pasif' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    <!-- Yeni Salon Ekleme Modal -->
    <div class="modal fade" id="createSalonModal" tabindex="-1" aria-labelledby="createSalonModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); color: white;">
                    <h5 class="modal-title" id="createSalonModalLabel">
                        <i class="bi bi-plus-circle"></i> Yeni Salon Ekle
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('admin.settings.salons.store') }}" method="POST" id="createSalonForm">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">Salon Adı <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="phone" name="phone" value="{{ old('phone') }}" placeholder="05XX XXX XX XX" required>
                                @error('phone')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="address" class="form-label">Adres <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="address" name="address" rows="2" required>{{ old('address') }}</textarea>
                            @error('address')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="city" class="form-label">İl <span class="text-danger">*</span></label>
                                <select name="city" id="modal_salon_city" class="form-select" required>
                                    <option value="">İl Seçin</option>
                                    @php
                                        $cities = [
                                            'Adana', 'Adıyaman', 'Afyonkarahisar', 'Ağrı', 'Aksaray', 'Amasya', 'Ankara', 'Antalya',
                                            'Ardahan', 'Artvin', 'Aydın', 'Balıkesir', 'Bartın', 'Batman', 'Bayburt', 'Bilecik',
                                            'Bingöl', 'Bitlis', 'Bolu', 'Burdur', 'Bursa', 'Çanakkale', 'Çankırı', 'Çorum',
                                            'Denizli', 'Diyarbakır', 'Düzce', 'Edirne', 'Elazığ', 'Erzincan', 'Erzurum', 'Eskişehir',
                                            'Gaziantep', 'Giresun', 'Gümüşhane', 'Hakkari', 'Hatay', 'Iğdır', 'Isparta', 'İstanbul',
                                            'İzmir', 'Kahramanmaraş', 'Karabük', 'Karaman', 'Kars', 'Kastamonu', 'Kayseri', 'Kilis',
                                            'Kırıkkale', 'Kırklareli', 'Kırşehir', 'Kocaeli', 'Konya', 'Kütahya', 'Malatya', 'Manisa',
                                            'Mardin', 'Mersin', 'Muğla', 'Muş', 'Nevşehir', 'Niğde', 'Ordu', 'Osmaniye',
                                            'Rize', 'Sakarya', 'Samsun', 'Siirt', 'Sinop', 'Sivas', 'Şanlıurfa', 'Şırnak',
                                            'Tekirdağ', 'Tokat', 'Trabzon', 'Tunceli', 'Uşak', 'Van', 'Yalova', 'Yozgat', 'Zonguldak'
                                        ];
                                    @endphp
                                    @foreach($cities as $city)
                                        <option value="{{ $city }}">{{ $city }}</option>
                                    @endforeach
                                </select>
                                @error('city')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="district" class="form-label">İlçe <span class="text-danger">*</span></label>
                                <select name="district" id="modal_salon_district" class="form-select" required disabled>
                                    <option value="">Önce il seçin</option>
                                </select>
                                @error('district')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="capacity" class="form-label">Kapasite</label>
                                <input type="number" class="form-control" id="capacity" name="capacity" value="{{ old('capacity', 0) }}" min="0">
                                @error('capacity')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Durum</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" checked>
                                    <label class="form-check-label" for="is_active">Aktif</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle"></i> Salon Oluştur
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
<script>
// İl seçildiğinde ilçeleri yükle (tüm ilçeler yerelde)
document.addEventListener('DOMContentLoaded', function() {
    const citySelect = document.getElementById('modal_salon_city');
    const districtSelect = document.getElementById('modal_salon_district');
    const allDistricts = @json(\App\Helpers\DistrictHelper::getAllDistricts());
    
    if (citySelect && districtSelect) {
        citySelect.addEventListener('change', function() {
            const selectedCity = this.value;
            if (selectedCity) {
                districtSelect.disabled = false;
                districtSelect.innerHTML = '<option value="">İlçe Seçin</option>';
                const cityDistricts = allDistricts[selectedCity] || [];
                cityDistricts.forEach(district => {
                    const option = document.createElement('option');
                    option.value = district;
                    option.textContent = district;
                    districtSelect.appendChild(option);
                });
            } else {
                districtSelect.disabled = true;
                districtSelect.innerHTML = '<option value="">Önce il seçin</option>';
            }
        });
    }
    
    // Form submit sonrası modal kapatma
    document.getElementById('createSalonForm')?.addEventListener('submit', function(e) {
        // Normal form submit - sayfa yenilenecek
    });
});
</script>
@endpush

