@extends('layouts.admin')

@section('content')
<style>
    @media (max-width: 1024px) {
        .card {
            border-radius: 16px !important;
            margin-bottom: 15px !important;
        }
        
        .card-header {
            padding: 15px !important;
            font-size: 16px !important;
        }
        
        .card-body {
            padding: 15px !important;
        }
        
        .form-control, .form-select {
            padding: 12px 15px !important;
            font-size: 16px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
        }
        
        .form-label {
            font-size: 14px !important;
            font-weight: 600 !important;
            margin-bottom: 8px !important;
        }
        
        .btn {
            padding: 12px 20px !important;
            font-size: 15px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
            width: 100% !important;
            margin-bottom: 10px !important;
        }
        
        .table-responsive {
            border-radius: 12px !important;
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch;
        }
        
        .table {
            font-size: 14px !important;
        }
        
        .table th, .table td {
            padding: 12px 8px !important;
        }
        
        .badge {
            font-size: 11px !important;
            padding: 4px 8px !important;
        }
        
        .alert {
            padding: 15px !important;
            border-radius: 12px !important;
            font-size: 14px !important;
        }
    }
</style>

<div class="container-fluid">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-2">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                <i class="bi bi-scissors me-2"></i> Hizmetler
            </h2>
        </div>
        <a href="{{ route('admin.settings.services.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i>Yeni Hizmet Ekle
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header border-0 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-list-ul me-2"></i>Hizmet Listesi</h5>
        </div>
        <div class="card-body p-0">
            @if($services->count() > 0)
                <!-- Desktop Table -->
                <div class="table-responsive d-none d-md-block">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Hizmet Adı</th>
                                <th>Açıklama</th>
                                <th>Fiyat</th>
                                <th>Durum</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($services as $service)
                                <tr>
                                    <td>
                                        <div class="fw-bold text-dark" style="font-size: 16px;">{{ $service->name }}</div>
                                    </td>
                                    <td>{{ $service->description ?? '-' }}</td>
                                    <td>
                                        @if($service->price)
                                            <span class="fw-bold text-success">{{ number_format($service->price, 2, ',', '.') }} ₺</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($service->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-secondary">Pasif</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.settings.services.edit', $service->id) }}" class="btn btn-sm btn-primary">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" onclick="confirmDeleteService({{ $service->id }}, '{{ $service->name }}')">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-5">
                                        <i class="bi bi-inbox" style="font-size: 48px; display: block; margin-bottom: 16px; opacity: 0.5;"></i>
                                        <p class="mb-0">Henüz hizmet eklenmemiş.</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Mobile Cards -->
                <div class="d-md-none">
                    @forelse($services as $service)
                        <div class="card mb-3 mx-3 mt-3 border-start border-4" style="border-left-color: #ec4899;">
                            <div class="card-body">
                                <div class="d-flex align-items-start gap-3 mb-3">
                                    <div style="width: 56px; height: 56px; border-radius: 8px; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; flex-shrink: 0; box-shadow: 0 4px 16px rgba(0,0,0,0.2);">
                                        <i class="bi bi-scissors text-white" style="font-size: 24px;"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="fw-bold mb-1">{{ $service->name }}</h6>
                                        @if($service->description)
                                            <small class="text-muted d-block">{{ $service->description }}</small>
                                        @endif
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="text-muted small">Fiyat:</span>
                                    @if($service->price)
                                        <span class="fw-bold text-success">{{ number_format($service->price, 2, ',', '.') }} ₺</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="text-muted small">Durum:</span>
                                    @if($service->is_active)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-secondary">Pasif</span>
                                    @endif
                                </div>
                                
                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.settings.services.edit', $service->id) }}" class="btn btn-sm btn-primary flex-fill">
                                        <i class="bi bi-pencil"></i> Düzenle
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger" onclick="confirmDeleteService({{ $service->id }}, '{{ $service->name }}')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-5 px-3">
                            <i class="bi bi-inbox" style="font-size: 48px; display: block; margin-bottom: 16px; opacity: 0.5;"></i>
                            <p class="mb-3">Henüz hizmet eklenmemiş.</p>
                            <a href="{{ route('admin.settings.services.create') }}" class="btn btn-primary">
                                <i class="bi bi-plus-circle me-2"></i>İlk Hizmeti Ekle
                            </a>
                        </div>
                    @endforelse
                </div>
            @else
                <div class="text-center py-5 px-3">
                    <i class="bi bi-inbox" style="font-size: 48px; display: block; margin-bottom: 16px; opacity: 0.5;"></i>
                    <p class="mb-3">Henüz hizmet eklenmemiş.</p>
                    <a href="{{ route('admin.settings.services.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>İlk Hizmeti Ekle
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Silme Onay Modalı -->
<div class="modal fade" id="deleteServiceModal" tabindex="-1" aria-labelledby="deleteServiceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteServiceModalLabel">
                    <i class="bi bi-exclamation-triangle"></i> Hizmet Silme Onayı
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p id="deleteServiceMessage" class="mb-3"></p>
                <div class="alert alert-warning mb-0">
                    <i class="bi bi-info-circle"></i> Bu işlem geri alınamaz! Hizmetin tüm verileri silinecektir.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x"></i> İptal
                </button>
                <form id="deleteServiceForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="bi bi-trash"></i> Evet, Sil
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function confirmDeleteService(id, name) {
    const modalElement = document.getElementById('deleteServiceModal');
    if (!modalElement) {
        console.error('deleteServiceModal bulunamadı');
        return;
    }
    
    const modal = new bootstrap.Modal(modalElement);
    const form = document.getElementById('deleteServiceForm');
    const message = document.getElementById('deleteServiceMessage');
    
    message.textContent = `"${name}" adlı hizmeti silmek istediğinizden emin misiniz?`;
    form.action = `{{ url('admin/ayarlar/hizmetler') }}/${id}`;
    
    modal.show();
}
</script>
@endpush
@endsection

