@extends('layouts.admin')

@section('title', 'SMS Ayarları')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">SMS Ayarları</li>
@endsection

@section('content')
    <h2 class="mb-4 fw-bold" style="color: #ec4899;">
        <i class="bi bi-chat-dots me-2"></i>SMS Ayarları
    </h2>
    
    <div class="card shadow-sm">
        <div class="card-header text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
            <h5 class="mb-0"><i class="bi bi-chat-dots"></i> SMS Ayarları</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.sms.update') }}">
                @csrf
                
                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i> <strong>1sms.com.tr API Entegrasyonu</strong><br>
                    API bilgilerinizi 1sms.com.tr panelinden alabilirsiniz.
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">1SMS API Kullanıcı Adı <span class="text-danger">*</span></label>
                    <input type="text" name="sms_username" class="form-control form-control-lg" value="{{ $settings['sms_username'] ?? '' }}" placeholder="1sms.com.tr kullanıcı adınız" required>
                    <small class="text-muted">1sms.com.tr panelinden aldığınız kullanıcı adı</small>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">1SMS API Şifre <span class="text-danger">*</span></label>
                    <input type="password" name="sms_password" class="form-control form-control-lg" value="{{ $settings['sms_password'] ?? '' }}" placeholder="1sms.com.tr API şifreniz" required>
                    <small class="text-muted">1sms.com.tr panelinden aldığınız API şifresi</small>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Gönderen Başlık (Sender) <span class="text-danger">*</span></label>
                    <input type="text" name="sms_sender" class="form-control form-control-lg" value="{{ $settings['sms_sender'] ?? '' }}" placeholder="Örn: SALONAY" maxlength="11" required>
                    <small class="text-muted">Maksimum 11 karakter. SMS'lerde görünecek gönderen adı</small>
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="send_sms_confirmation" id="send_sms_confirmation" value="1" {{ ($settings['send_sms_confirmation'] ?? false) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="send_sms_confirmation">
                            Randevu Onayı SMS Gönder
                        </label>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-lg text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                    <i class="bi bi-check-circle"></i> Kaydet
                </button>
            </form>
        </div>
    </div>

    <!-- Test SMS Gönderme -->
    <div class="card shadow-sm mt-4">
        <div class="card-header text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
            <h5 class="mb-0"><i class="bi bi-send-check"></i> Test SMS Gönder</h5>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <i class="bi bi-info-circle"></i> <strong>Test SMS</strong><br>
                SMS API'nizin çalışıp çalışmadığını test etmek için bir test mesajı gönderebilirsiniz.
            </div>
            
            <form id="testSmsForm">
                @csrf
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Test Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="text" name="test_phone" id="testPhone" class="form-control form-control-lg" placeholder="05XX XXX XX XX" required>
                        <small class="text-muted">Test SMS'inin gönderileceği telefon numarası</small>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Test Mesajı</label>
                        <input type="text" name="test_message" id="testMessage" class="form-control form-control-lg" placeholder="Bu bir test SMS mesajıdır. Salonay SMS API testi." maxlength="500">
                        <small class="text-muted">Boş bırakılırsa varsayılan mesaj gönderilir</small>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-lg text-white" id="testSmsBtn" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                    <i class="bi bi-send"></i> Test SMS Gönder
                </button>
            </form>
            
            <div id="testSmsResult" class="mt-3" style="display: none;"></div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const testSmsForm = document.getElementById('testSmsForm');
    const testSmsBtn = document.getElementById('testSmsBtn');
    const testSmsResult = document.getElementById('testSmsResult');
    
    if (testSmsForm) {
        testSmsForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            if (!testSmsBtn || !testSmsResult) return;
            
            
            testSmsBtn.disabled = true;
            testSmsBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
            testSmsResult.style.display = 'none';
            
            const formData = new FormData(testSmsForm);
            
            fetch('{{ route("admin.settings.sms.test") }}', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || document.querySelector('input[name="_token"]')?.value
                }
            })
            .then(response => response.json())
            .then(data => {
                testSmsResult.style.display = 'block';
                if (data.success) {
                    testSmsResult.className = 'alert alert-success mt-3';
                    testSmsResult.innerHTML = '<i class="bi bi-check-circle me-2"></i>' + data.message;
                } else {
                    testSmsResult.className = 'alert alert-danger mt-3';
                    testSmsResult.innerHTML = '<i class="bi bi-x-circle me-2"></i>' + (data.message || 'SMS gönderilemedi.');
                }
                
                testSmsBtn.disabled = false;
                testSmsBtn.innerHTML = '<i class="bi bi-send"></i> Test SMS Gönder';
            })
            .catch(error => {
                console.error('Error:', error);
                testSmsResult.style.display = 'block';
                testSmsResult.className = 'alert alert-danger mt-3';
                testSmsResult.innerHTML = '<i class="bi bi-x-circle me-2"></i>SMS gönderilirken bir hata oluştu.';
                
                testSmsBtn.disabled = false;
                testSmsBtn.innerHTML = '<i class="bi bi-send"></i> Test SMS Gönder';
            });
        });
    }
});
</script>
@endpush

