@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-0" style="background: linear-gradient(135deg, #34d399 0%, #10b981 100%);">
                    <h4 class="mb-0 text-white"><i class="bi bi-whatsapp"></i> WhatsApp & Fatura Ayarları</h4>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show">
                            <i class="bi bi-check-circle"></i> {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    @if($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="bi bi-exclamation-circle"></i> 
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    <form action="{{ route('admin.settings.whatsapp-invoice') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- WhatsApp Ayarları -->
                        <div class="mb-4">
                            <h5 class="mb-3"><i class="bi bi-whatsapp text-success"></i> WasenderAPI Ayarları</h5>
                            
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle"></i> 
                                <strong>WasenderAPI Kullanımı:</strong> 
                                <a href="https://wasenderapi.com" target="_blank">WasenderAPI</a> hesabınızdan API token ve session ID'nizi alın.
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">WasenderAPI Token <span class="text-danger">*</span></label>
                                <input type="text" name="whatsapp_api_token" class="form-control" 
                                       value="{{ $whatsappSettings['whatsapp_api_token'] ?? '' }}" 
                                       placeholder="WasenderAPI Bearer Token">
                                <small class="form-text text-muted">
                                    WasenderAPI hesabınızdan alacağınız Bearer token'ı buraya girin.
                                </small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Session ID <span class="text-danger">*</span></label>
                                <input type="text" name="whatsapp_session_id" class="form-control" 
                                       value="{{ $whatsappSettings['whatsapp_session_id'] ?? '' }}" 
                                       placeholder="WhatsApp Session ID">
                                <small class="form-text text-muted">
                                    WasenderAPI'de oluşturduğunuz WhatsApp session ID'nizi buraya girin.
                                </small>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <!-- Fatura Ayarları -->
                        <div class="mb-4">
                            <h5 class="mb-3"><i class="bi bi-receipt"></i> Fatura Ayarları</h5>
                            
                            <div class="mb-3">
                                <label class="form-label">Fatura Logosu</label>
                                <input type="file" name="invoice_logo" class="form-control @error('invoice_logo') is-invalid @enderror" accept="image/jpeg,image/jpg,image/png,image/gif,image/webp">
                                @error('invoice_logo')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                                @if($invoiceSettings['invoice_logo'] ?? null)
                                    <div class="mt-2">
                                        <img src="{{ asset('storage/' . $invoiceSettings['invoice_logo']) }}" 
                                             alt="Logo" style="max-width: 200px; max-height: 100px; border: 1px solid #ddd; padding: 5px; border-radius: 4px;">
                                        <div class="mt-1">
                                            <small class="text-muted">Mevcut logo</small>
                                        </div>
                                    </div>
                                @endif
                                <small class="form-text text-muted">
                                    Fatura üzerinde görünecek logoyu yükleyin (JPEG, JPG, PNG, GIF, WEBP - Maksimum 2MB).
                                </small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Fatura Adresi <span class="text-danger">*</span></label>
                                <textarea name="invoice_address" class="form-control" rows="3" 
                                          placeholder="Fatura üzerinde görünecek adres">{{ $invoiceSettings['invoice_address'] ?? '' }}</textarea>
                                <small class="form-text text-muted">
                                    Fatura üzerinde görünecek şirket adresi. Salon adresi yoksa bu adres kullanılacaktır.
                                </small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Vergi Dairesi</label>
                                <input type="text" name="invoice_tax_office" class="form-control" 
                                       value="{{ $invoiceSettings['invoice_tax_office'] ?? '' }}" 
                                       placeholder="Vergi Dairesi">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Vergi Numarası</label>
                                <input type="text" name="invoice_tax_number" class="form-control" 
                                       value="{{ $invoiceSettings['invoice_tax_number'] ?? '' }}" 
                                       placeholder="Vergi Numarası">
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save"></i> Ayarları Kaydet
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
