@extends('layouts.admin')

@section('title', 'Akıllı İndirim & Kampanyalar')
@section('page-title', 'Akıllı İndirim & Kampanyalar')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-percent me-2"></i>Akıllı İndirim & Kampanyalar
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createDiscountModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni İndirim
                    </button>
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createCampaignModal" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border: none;">
                        <i class="bi bi-megaphone me-2"></i>Yeni Kampanya
                    </button>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        @forelse($discounts as $discount)
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm h-100" style="border: none; border-radius: 16px;">
                    <div class="card-header" style="background: linear-gradient(135deg, {{ $discount->campaign_type === 'campaign' ? '#3b82f6' : '#10b981' }} 0%, {{ $discount->campaign_type === 'campaign' ? '#1e40af' : '#047857' }} 100%); border-radius: 16px 16px 0 0;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0 text-white fw-bold">{{ $discount->name }}</h5>
                                <small class="text-white opacity-75">
                                    @if($discount->campaign_type === 'campaign')
                                        <i class="bi bi-megaphone"></i> Kampanya
                                    @else
                                        <i class="bi bi-percent"></i> İndirim
                                    @endif
                                </small>
                            </div>
                            <div class="d-flex flex-column align-items-end gap-1">
                                @if($discount->status === 'active' && $discount->is_active)
                                    <span class="badge bg-white text-success">Aktif</span>
                                @elseif($discount->status === 'paused')
                                    <span class="badge bg-white text-warning">Duraklatıldı</span>
                                @elseif($discount->status === 'draft')
                                    <span class="badge bg-white text-info">Taslak</span>
                                @else
                                    <span class="badge bg-white text-secondary">Pasif</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($discount->description)
                            <p class="text-muted mb-3">{{ $discount->description }}</p>
                        @endif

                        <div class="mb-3">
                            @if($discount->discount_percentage)
                                <strong class="text-primary" style="font-size: 24px;">%{{ number_format($discount->discount_percentage, 0) }}</strong>
                                <span class="text-muted">İndirim</span>
                            @elseif($discount->discount_amount)
                                <strong class="text-primary" style="font-size: 24px;">{{ number_format($discount->discount_amount, 2) }} ₺</strong>
                                <span class="text-muted">İndirim</span>
                            @endif
                        </div>
                        
                        @if($discount->campaign_type === 'campaign')
                            @if($discount->budget)
                                <div class="mb-2">
                                    <small class="text-muted">Bütçe:</small>
                                    <strong>{{ number_format($discount->budget, 2) }} ₺</strong>
                                    @if($discount->budget_used > 0)
                                        <small class="text-muted">({{ number_format($discount->budget_used, 2) }} ₺ kullanıldı)</small>
                                    @endif
                                </div>
                            @endif
                            @if($discount->max_redemptions)
                                <div class="mb-2">
                                    <small class="text-muted">Max Kullanım:</small>
                                    <strong>{{ $discount->max_redemptions }}</strong>
                                    <small class="text-muted">({{ $discount->redemptions_count }} kullanıldı)</small>
                                </div>
                            @endif
                        @endif

                        <div class="mb-3">
                            <strong>Günler:</strong>
                            <div class="mt-1">
                                @php
                                    $dayNames = [
                                        'monday' => 'Pazartesi',
                                        'tuesday' => 'Salı',
                                        'wednesday' => 'Çarşamba',
                                        'thursday' => 'Perşembe',
                                        'friday' => 'Cuma',
                                        'saturday' => 'Cumartesi',
                                        'sunday' => 'Pazar'
                                    ];
                                @endphp
                                @foreach($discount->days_of_week as $day)
                                    <span class="badge bg-info me-1">{{ $dayNames[$day] ?? $day }}</span>
                                @endforeach
                            </div>
                        </div>

                        @if($discount->start_time && $discount->end_time)
                            <div class="mb-3">
                                <strong>Saat:</strong> {{ date('H:i', strtotime($discount->start_time)) }} - {{ date('H:i', strtotime($discount->end_time)) }}
                            </div>
                        @endif

                        @if($discount->service_ids && count($discount->service_ids) > 0)
                            <div class="mb-3">
                                <strong>Hizmetler:</strong>
                                <div class="mt-1">
                                    @foreach($discount->services() as $service)
                                        <span class="badge bg-secondary me-1">{{ $service->name }}</span>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="mb-3">
                                <span class="badge bg-success">Tüm Hizmetler</span>
                            </div>
                        @endif

                        <div class="d-flex gap-2 mt-3">
                            <form action="{{ route('admin.beauty-salon.smart-discount.destroy', $discount->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu indirimi silmek istediğinize emin misiniz?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i> Sil
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card shadow-sm text-center py-5" style="border: none; border-radius: 16px;">
                    <i class="bi bi-percent" style="font-size: 64px; color: #ccc;"></i>
                    <h5 class="mt-3 text-muted">Henüz indirim veya kampanya oluşturulmamış</h5>
                    <p class="text-muted">Belirlediğiniz günlerde otomatik indirim uygulamak veya kampanya oluşturmak için yeni bir kayıt oluşturun.</p>
                    <div class="d-flex gap-2 justify-content-center mt-3">
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createDiscountModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                            <i class="bi bi-plus-circle me-2"></i>İlk İndirimi Oluştur
                        </button>
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createCampaignModal" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border: none;">
                            <i class="bi bi-megaphone me-2"></i>İlk Kampanyayı Oluştur
                        </button>
                    </div>
                </div>
            </div>
        @endforelse
    </div>
</div>

<!-- Create Discount Modal -->
<div class="modal fade" id="createDiscountModal" tabindex="-1" aria-labelledby="createDiscountModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content" style="border: none; border-radius: 16px;">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                <h5 class="modal-title text-white fw-bold" id="createDiscountModalLabel">
                    <i class="bi bi-plus-circle me-2"></i>Yeni Akıllı İndirim
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.smart-discount.store') }}" method="POST">
                @csrf
                <input type="hidden" name="campaign_type" value="discount">
                <input type="hidden" name="status" value="active">
                <div class="modal-body p-4">
                    <div class="mb-3">
                        <label class="form-label fw-bold">İndirim Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" required placeholder="Örn: Her Cuma %10 İndirim">
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Açıklama</label>
                        <textarea class="form-control" name="description" rows="2" placeholder="İndirim hakkında açıklama"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">İndirim Tipi <span class="text-danger">*</span></label>
                        <div class="btn-group w-100" role="group">
                            <input type="radio" class="btn-check" name="discount_type" id="discount_percentage" value="percentage" checked>
                            <label class="btn btn-outline-primary" for="discount_percentage">Yüzde (%)</label>
                            
                            <input type="radio" class="btn-check" name="discount_type" id="discount_amount" value="amount">
                            <label class="btn btn-outline-primary" for="discount_amount">Tutar (₺)</label>
                        </div>
                    </div>

                    <div class="mb-3" id="discount_percentage_field">
                        <label class="form-label fw-bold">İndirim Yüzdesi <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" class="form-control" name="discount_percentage" min="1" max="100" step="0.01" placeholder="10">
                            <span class="input-group-text">%</span>
                        </div>
                    </div>

                    <div class="mb-3" id="discount_amount_field" style="display: none;">
                        <label class="form-label fw-bold">İndirim Tutarı <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" class="form-control" name="discount_amount" min="0" step="0.01" placeholder="50">
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Hangi Günlerde Uygulanacak? <span class="text-danger">*</span></label>
                        <div class="row g-2">
                            @php
                                $days = [
                                    'monday' => 'Pazartesi',
                                    'tuesday' => 'Salı',
                                    'wednesday' => 'Çarşamba',
                                    'thursday' => 'Perşembe',
                                    'friday' => 'Cuma',
                                    'saturday' => 'Cumartesi',
                                    'sunday' => 'Pazar'
                                ];
                            @endphp
                            @foreach($days as $key => $day)
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="days_of_week[]" value="{{ $key }}" id="day_{{ $key }}">
                                        <label class="form-check-label" for="day_{{ $key }}">{{ $day }}</label>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Başlangıç Saati (Opsiyonel)</label>
                            <input type="time" class="form-control" name="start_time">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Bitiş Saati (Opsiyonel)</label>
                            <input type="time" class="form-control" name="end_time">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Başlangıç Tarihi (Opsiyonel)</label>
                            <input type="date" class="form-control" name="start_date">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Bitiş Tarihi (Opsiyonel)</label>
                            <input type="date" class="form-control" name="end_date">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Hangi Hizmetlere Uygulanacak?</label>
                        <select class="form-select" name="service_ids[]" multiple size="5">
                            <option value="">Tüm Hizmetler (Seçilmezse)</option>
                            @foreach($services as $service)
                                <option value="{{ $service->id }}">{{ $service->name }}</option>
                            @endforeach
                        </select>
                        <small class="text-muted">Ctrl/Cmd tuşu ile birden fazla seçim yapabilirsiniz. Hiçbir şey seçilmezse tüm hizmetlere uygulanır.</small>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" checked>
                            <label class="form-check-label" for="is_active">Aktif</label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="auto_apply" id="auto_apply" checked>
                            <label class="form-check-label" for="auto_apply">Otomatik Uygula</label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-check-circle me-2"></i>Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Create Campaign Modal -->
<div class="modal fade" id="createCampaignModal" tabindex="-1" aria-labelledby="createCampaignModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content" style="border: none; border-radius: 16px;">
            <div class="modal-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
                <h5 class="modal-title text-white fw-bold" id="createCampaignModalLabel">
                    <i class="bi bi-megaphone me-2"></i>Yeni Kampanya
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.smart-discount.store') }}" method="POST">
                @csrf
                <input type="hidden" name="campaign_type" value="campaign">
                <div class="modal-body p-4" style="max-height: 70vh; overflow-y: auto;">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Kampanya Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" required placeholder="Örn: Yılbaşı Özel Kampanyası">
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Açıklama</label>
                        <textarea class="form-control" name="description" rows="2" placeholder="Kampanya hakkında açıklama"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Durum <span class="text-danger">*</span></label>
                        <select class="form-select" name="status" required>
                            <option value="draft">Taslak</option>
                            <option value="active" selected>Aktif</option>
                            <option value="paused">Duraklatıldı</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">İndirim Tipi <span class="text-danger">*</span></label>
                        <div class="btn-group w-100" role="group">
                            <input type="radio" class="btn-check" name="campaign_discount_type" id="campaign_discount_percentage" value="percentage" checked>
                            <label class="btn btn-outline-primary" for="campaign_discount_percentage">Yüzde (%)</label>
                            
                            <input type="radio" class="btn-check" name="campaign_discount_type" id="campaign_discount_amount" value="amount">
                            <label class="btn btn-outline-primary" for="campaign_discount_amount">Tutar (₺)</label>
                        </div>
                    </div>

                    <div class="mb-3" id="campaign_discount_percentage_field">
                        <label class="form-label fw-bold">İndirim Yüzdesi</label>
                        <div class="input-group">
                            <input type="number" class="form-control" name="discount_percentage" min="0" max="100" step="0.01" placeholder="10">
                            <span class="input-group-text">%</span>
                        </div>
                    </div>

                    <div class="mb-3" id="campaign_discount_amount_field" style="display: none;">
                        <label class="form-label fw-bold">İndirim Tutarı</label>
                        <div class="input-group">
                            <input type="number" class="form-control" name="discount_amount" min="0" step="0.01" placeholder="50">
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Hangi Günlerde Uygulanacak? <span class="text-danger">*</span></label>
                        <div class="row g-2">
                            @php
                                $days = [
                                    'monday' => 'Pazartesi',
                                    'tuesday' => 'Salı',
                                    'wednesday' => 'Çarşamba',
                                    'thursday' => 'Perşembe',
                                    'friday' => 'Cuma',
                                    'saturday' => 'Cumartesi',
                                    'sunday' => 'Pazar'
                                ];
                            @endphp
                            @foreach($days as $key => $day)
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="days_of_week[]" value="{{ $key }}" id="campaign_day_{{ $key }}">
                                        <label class="form-check-label" for="campaign_day_{{ $key }}">{{ $day }}</label>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Başlangıç Saati (Opsiyonel)</label>
                            <input type="time" class="form-control" name="start_time">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Bitiş Saati (Opsiyonel)</label>
                            <input type="time" class="form-control" name="end_time">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Başlangıç Tarihi (Opsiyonel)</label>
                            <input type="date" class="form-control" name="start_date">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Bitiş Tarihi (Opsiyonel)</label>
                            <input type="date" class="form-control" name="end_date">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Hangi Hizmetlere Uygulanacak?</label>
                        <select class="form-select" name="service_ids[]" multiple size="5">
                            <option value="">Tüm Hizmetler (Seçilmezse)</option>
                            @foreach($services as $service)
                                <option value="{{ $service->id }}">{{ $service->name }}</option>
                            @endforeach
                        </select>
                        <small class="text-muted">Ctrl/Cmd tuşu ile birden fazla seçim yapabilirsiniz. Hiçbir şey seçilmezse tüm hizmetlere uygulanır.</small>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Bütçe (Opsiyonel)</label>
                            <input type="number" class="form-control" name="budget" min="0" step="0.01" placeholder="1000">
                            <small class="text-muted">Kampanya için toplam bütçe</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Maksimum Kullanım (Opsiyonel)</label>
                            <input type="number" class="form-control" name="max_redemptions" min="1" placeholder="100">
                            <small class="text-muted">Kampanyanın kaç kez kullanılabileceği</small>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_active" id="campaign_is_active" checked>
                            <label class="form-check-label" for="campaign_is_active">Aktif</label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="auto_apply" id="campaign_auto_apply" checked>
                            <label class="form-check-label" for="campaign_auto_apply">Otomatik Uygula</label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="auto_stop_on_loss" id="auto_stop_on_loss">
                            <label class="form-check-label" for="auto_stop_on_loss">Zarar Durumunda Otomatik Durdur</label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Minimum ROI % (Opsiyonel)</label>
                        <input type="number" class="form-control" name="min_roi" min="0" max="100" step="0.01" placeholder="10">
                        <small class="text-muted">Kampanyanın minimum getiri oranı</small>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border: none;">
                        <i class="bi bi-check-circle me-2"></i>Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // İndirim modalı için
    const discountPercentage = document.getElementById('discount_percentage');
    const discountAmount = document.getElementById('discount_amount');
    const discountPercentageField = document.getElementById('discount_percentage_field');
    const discountAmountField = document.getElementById('discount_amount_field');
    
    if (discountPercentage) {
        discountPercentage.addEventListener('change', function() {
            if (this.checked) {
                discountPercentageField.style.display = 'block';
                discountAmountField.style.display = 'none';
                discountPercentageField.querySelector('input').required = true;
                discountAmountField.querySelector('input').required = false;
            }
        });
    }
    
    if (discountAmount) {
        discountAmount.addEventListener('change', function() {
            if (this.checked) {
                discountPercentageField.style.display = 'none';
                discountAmountField.style.display = 'block';
                discountPercentageField.querySelector('input').required = false;
                discountAmountField.querySelector('input').required = true;
            }
        });
    }

    // Kampanya modalı için
    const campaignDiscountPercentage = document.getElementById('campaign_discount_percentage');
    const campaignDiscountAmount = document.getElementById('campaign_discount_amount');
    const campaignDiscountPercentageField = document.getElementById('campaign_discount_percentage_field');
    const campaignDiscountAmountField = document.getElementById('campaign_discount_amount_field');
    
    if (campaignDiscountPercentage) {
        campaignDiscountPercentage.addEventListener('change', function() {
            if (this.checked) {
                campaignDiscountPercentageField.style.display = 'block';
                campaignDiscountAmountField.style.display = 'none';
            }
        });
    }
    
    if (campaignDiscountAmount) {
        campaignDiscountAmount.addEventListener('change', function() {
            if (this.checked) {
                campaignDiscountPercentageField.style.display = 'none';
                campaignDiscountAmountField.style.display = 'block';
            }
        });
    }
});
</script>
@endsection

