@extends('layouts.admin')

@section('title', 'Akıllı Fiyatlandırma')
@section('page-title', 'Akıllı Fiyatlandırma')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-tags-fill me-2"></i>Akıllı Fiyatlandırma
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.smart-pricing.rules') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-sliders me-2"></i>Fiyat Kuralları
                    </a>
                    <a href="{{ route('admin.beauty-salon.smart-pricing.tests') }}" class="btn btn-info">
                        <i class="bi bi-flask me-2"></i>Fiyat Testleri
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        @forelse($pricingRules as $rule)
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm h-100" style="border: none; border-radius: 16px;">
                    <div class="card-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border-radius: 16px 16px 0 0;">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-white fw-bold">{{ $rule->name }}</h5>
                            <span class="badge bg-white text-success">Aktif</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <span class="text-muted small">Kural Tipi:</span>
                            <div>
                                @if($rule->rule_type === 'time_based')
                                    <span class="badge bg-primary">Zaman Bazlı</span>
                                @elseif($rule->rule_type === 'demand_based')
                                    <span class="badge bg-warning text-dark">Talep Bazlı</span>
                                @elseif($rule->rule_type === 'staff_based')
                                    <span class="badge bg-info">Personel Bazlı</span>
                                @else
                                    <span class="badge bg-success">Mevsimsel</span>
                                @endif
                            </div>
                        </div>

                        @if($rule->service)
                            <div class="mb-3">
                                <span class="text-muted small">Hizmet:</span>
                                <div class="fw-bold">{{ $rule->service->name }}</div>
                            </div>
                        @endif

                        <div class="mb-3">
                            <span class="text-muted small">Fiyat Ayarlaması:</span>
                            <div class="fw-bold text-primary">
                                @if($rule->price_adjustment_type === 'percentage')
                                    %{{ number_format($rule->price_adjustment_value, 2, ',', '.') }}
                                @else
                                    {{ number_format($rule->price_adjustment_value, 2, ',', '.') }} ₺
                                @endif
                            </div>
                        </div>

                        <div class="mb-3">
                            <span class="text-muted small">Öncelik:</span>
                            <div>
                                <span class="badge bg-secondary">{{ $rule->priority }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card shadow-sm text-center py-5" style="border: none; border-radius: 16px;">
                    <i class="bi bi-tags-fill" style="font-size: 64px; color: #ccc;"></i>
                    <h5 class="mt-3 text-muted">Henüz fiyatlandırma kuralı oluşturulmamış</h5>
                    <p class="text-muted">Dinamik fiyatlandırma kuralları oluşturun ve gelirinizi optimize edin.</p>
                    <a href="{{ route('admin.beauty-salon.smart-pricing.rules') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Kuralı Oluştur
                    </a>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection

