@extends('layouts.admin')

@section('title', 'Fiyatlandırma Kuralları')
@section('page-title', 'Fiyatlandırma Kuralları')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-sliders me-2"></i>Fiyatlandırma Kuralları
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createRuleModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Kural Oluştur
                    </button>
                    <a href="{{ route('admin.beauty-salon.smart-pricing.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Kural Listesi
            </h5>
        </div>
        <div class="card-body">
            @if($rules->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Kural Adı</th>
                                <th>Türü</th>
                                <th>Hizmet</th>
                                <th>Fiyat Ayarlaması</th>
                                <th>Öncelik</th>
                                <th>Durum</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($rules as $rule)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $rule->name }}</div>
                                    </td>
                                    <td>
                                        @if($rule->rule_type === 'time_based')
                                            <span class="badge bg-info">Zaman Bazlı</span>
                                        @elseif($rule->rule_type === 'demand_based')
                                            <span class="badge bg-warning text-dark">Talep Bazlı</span>
                                        @elseif($rule->rule_type === 'staff_based')
                                            <span class="badge bg-success">Personel Bazlı</span>
                                        @else
                                            <span class="badge bg-primary">Mevsimsel</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($rule->service)
                                            {{ $rule->service->name }}
                                        @else
                                            <span class="text-muted">Tüm Hizmetler</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($rule->pricing_type === 'percentage')
                                            <strong class="text-primary">%{{ number_format($rule->price_adjustment, 2) }}</strong>
                                        @elseif($rule->pricing_type === 'multiplier')
                                            <strong class="text-primary">×{{ number_format($rule->multiplier ?? 1, 2) }}</strong>
                                        @else
                                            <strong class="text-primary">{{ number_format($rule->price_adjustment, 2, ',', '.') }} ₺</strong>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ $rule->priority }}</span>
                                    </td>
                                    <td>
                                        @if($rule->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#ruleDetailModal{{ $rule->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="editRule({{ $rule->id }})">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <form action="#" method="POST" class="d-inline-block" onsubmit="return confirm('Bu kuralı silmek istediğinizden emin misiniz?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-sliders" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz fiyatlandırma kuralı oluşturulmamış.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createRuleModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Kuralı Oluştur
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Create Rule Modal -->
<div class="modal fade" id="createRuleModal" tabindex="-1" aria-labelledby="createRuleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 800px;">
        <div class="modal-content" style="border: none; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="createRuleModalLabel">
                    <i class="bi bi-sliders me-2"></i>Yeni Fiyatlandırma Kuralı
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="opacity: 1;"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.smart-pricing.rules.store') }}" method="POST" id="createRuleForm">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="alert alert-info mb-4" style="border-radius: 12px; border: none; background: #e0f2fe;">
                        <i class="bi bi-lightbulb me-2"></i><strong>Fiyatlandırma Kuralı Nedir?</strong><br>
                        <small>Fiyatlarınızı otomatik olarak ayarlayabilirsiniz. Örneğin: Hafta sonları %20 artır, boş saatlerde %10 azalt. Böylece gelirinizi maksimize edersiniz.</small>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label fw-bold">Kural Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" placeholder="Örn: Hafta Sonu Artışı" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="rule_type" class="form-label fw-bold">Kural Türü <span class="text-danger">*</span></label>
                            <select class="form-select @error('rule_type') is-invalid @enderror" id="rule_type" name="rule_type" required>
                                <option value="">Seçiniz</option>
                                <option value="time_based" {{ old('rule_type') == 'time_based' ? 'selected' : '' }}>Zaman Bazlı</option>
                                <option value="demand_based" {{ old('rule_type') == 'demand_based' ? 'selected' : '' }}>Talep Bazlı</option>
                                <option value="staff_based" {{ old('rule_type') == 'staff_based' ? 'selected' : '' }}>Personel Bazlı</option>
                                <option value="seasonal" {{ old('rule_type') == 'seasonal' ? 'selected' : '' }}>Mevsimsel</option>
                            </select>
                            @error('rule_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="service_id" class="form-label fw-bold">Hizmet</label>
                            <select class="form-select @error('service_id') is-invalid @enderror" id="service_id" name="service_id">
                                <option value="">Tüm Hizmetler</option>
                                @foreach($services as $service)
                                    <option value="{{ $service->id }}" {{ old('service_id') == $service->id ? 'selected' : '' }}>{{ $service->name }}</option>
                                @endforeach
                            </select>
                            @error('service_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="priority" class="form-label fw-bold">Öncelik <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('priority') is-invalid @enderror" id="priority" name="priority" value="{{ old('priority', 1) }}" min="1" max="100" required>
                            @error('priority')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Yüksek sayı = daha yüksek öncelik</small>
                        </div>
                        <div class="col-md-6">
                            <label for="pricing_type" class="form-label fw-bold">Fiyatlandırma Türü <span class="text-danger">*</span></label>
                            <select class="form-select @error('pricing_type') is-invalid @enderror" id="pricing_type" name="pricing_type" required>
                                <option value="">Seçiniz</option>
                                <option value="percentage" {{ old('pricing_type') == 'percentage' ? 'selected' : '' }}>Yüzde (%)</option>
                                <option value="fixed" {{ old('pricing_type') == 'fixed' ? 'selected' : '' }}>Sabit Tutar (₺)</option>
                                <option value="multiplier" {{ old('pricing_type') == 'multiplier' ? 'selected' : '' }}>Çarpan</option>
                            </select>
                            @error('pricing_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="price_adjustment" class="form-label fw-bold">Fiyat Ayarlama Değeri <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control @error('price_adjustment') is-invalid @enderror" id="price_adjustment" name="price_adjustment" value="{{ old('price_adjustment') }}" placeholder="Örn: 10 veya 50" required>
                            @error('price_adjustment')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Yüzde için: 10 = %10 artış, -10 = %10 azalış</small>
                        </div>
                        <div class="col-md-6" id="multiplier_field" style="display: none;">
                            <label for="multiplier" class="form-label fw-bold">Çarpan</label>
                            <input type="number" step="0.01" class="form-control @error('multiplier') is-invalid @enderror" id="multiplier" name="multiplier" value="{{ old('multiplier', 1.0) }}" placeholder="Örn: 1.2 = %20 artış" min="0">
                            @error('multiplier')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Kural Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.getElementById('pricing_type')?.addEventListener('change', function() {
        const type = this.value;
        const multiplierField = document.getElementById('multiplier_field');
        
        if (type === 'multiplier') {
            multiplierField.style.display = 'block';
        } else {
            multiplierField.style.display = 'none';
        }
    });

    function editRule(id) {
        alert('Kural düzenleme özelliği geliştiriliyor. Yakında eklenecektir.');
    }
</script>
@endpush
@endsection

