@extends('layouts.admin')

@section('title', 'Fiyat Testleri')
@section('page-title', 'Fiyat Testleri')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-flask me-2"></i>Fiyat Testleri
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTestModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Test Oluştur
                    </button>
                    <a href="{{ route('admin.beauty-salon.smart-pricing.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Test Listesi
            </h5>
        </div>
        <div class="card-body">
            @if($tests->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Test Adı</th>
                                <th>Hizmet</th>
                                <th>Orijinal Fiyat</th>
                                <th>Test Fiyatı</th>
                                <th>Dönem</th>
                                <th>Durum</th>
                                <th>Dönüşüm Oranı</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($tests as $test)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $test->test_name }}</div>
                                    </td>
                                    <td>
                                        @if($test->service)
                                            {{ $test->service->name }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td class="fw-bold">{{ number_format($test->control_price, 2, ',', '.') }} ₺</td>
                                    <td class="fw-bold text-primary">{{ number_format($test->test_price, 2, ',', '.') }} ₺</td>
                                    <td>
                                        <small>
                                            {{ \Carbon\Carbon::parse($test->start_date)->format('d.m.Y') }} - 
                                            {{ \Carbon\Carbon::parse($test->end_date)->format('d.m.Y') }}
                                        </small>
                                    </td>
                                    <td>
                                        @if($test->status === 'running')
                                            <span class="badge bg-success">Çalışıyor</span>
                                        @elseif($test->status === 'completed')
                                            <span class="badge bg-info">Tamamlandı</span>
                                        @elseif($test->status === 'draft')
                                            <span class="badge bg-secondary">Taslak</span>
                                        @elseif($test->status === 'cancelled')
                                            <span class="badge bg-danger">İptal</span>
                                        @else
                                            <span class="badge bg-secondary">{{ $test->status }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($test->conversion_rate_test)
                                            <span class="badge bg-primary">%{{ number_format($test->conversion_rate_test, 2) }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#testDetailModal{{ $test->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="editTest({{ $test->id }})">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <form action="#" method="POST" class="d-inline-block" onsubmit="return confirm('Bu testi silmek istediğinizden emin misiniz?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $tests->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-flask" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz fiyat testi oluşturulmamış.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTestModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Testi Oluştur
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Create Test Modal -->
<div class="modal fade" id="createTestModal" tabindex="-1" aria-labelledby="createTestModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 800px;">
        <div class="modal-content" style="border: none; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="createTestModalLabel">
                    <i class="bi bi-flask me-2"></i>Yeni Fiyat Testi
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="opacity: 1;"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.smart-pricing.tests.store') }}" method="POST" id="createTestForm">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="alert alert-info mb-4" style="border-radius: 12px; border: none; background: #e0f2fe;">
                        <i class="bi bi-lightbulb me-2"></i><strong>Fiyat Testi Nedir?</strong><br>
                        <small>Farklı fiyatları test ederek hangi fiyatın daha çok gelir getirdiğini öğrenirsiniz. Örneğin: Bir hizmeti 100₺ ve 120₺ fiyatla test edip hangisinin daha karlı olduğunu görürsünüz.</small>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="service_id" class="form-label fw-bold">Hizmet <span class="text-danger">*</span></label>
                            <select class="form-select @error('service_id') is-invalid @enderror" id="service_id" name="service_id" required>
                                <option value="">Seçiniz</option>
                                @foreach($services as $service)
                                    <option value="{{ $service->id }}" {{ old('service_id') == $service->id ? 'selected' : '' }}>{{ $service->name }} ({{ number_format($service->price, 2, ',', '.') }} ₺)</option>
                                @endforeach
                            </select>
                            @error('service_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="test_name" class="form-label fw-bold">Test Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('test_name') is-invalid @enderror" id="test_name" name="test_name" value="{{ old('test_name') }}" placeholder="Örn: Saç Kesimi Fiyat Testi" required>
                            @error('test_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="control_price" class="form-label fw-bold">Kontrol Fiyatı (₺) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control @error('control_price') is-invalid @enderror" id="control_price" name="control_price" value="{{ old('control_price') }}" placeholder="Örn: 100" min="0" required>
                            @error('control_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Mevcut fiyat (kontrol grubu)</small>
                        </div>
                        <div class="col-md-6">
                            <label for="test_price" class="form-label fw-bold">Test Fiyatı (₺) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control @error('test_price') is-invalid @enderror" id="test_price" name="test_price" value="{{ old('test_price') }}" placeholder="Örn: 120" min="0" required>
                            @error('test_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Test edilecek yeni fiyat</small>
                        </div>
                        <div class="col-md-6">
                            <label for="start_date" class="form-label fw-bold">Test Başlangıcı <span class="text-danger">*</span></label>
                            <input type="date" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date') }}" required>
                            @error('start_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="end_date" class="form-label fw-bold">Test Bitişi <span class="text-danger">*</span></label>
                            <input type="date" class="form-control @error('end_date') is-invalid @enderror" id="end_date" name="end_date" value="{{ old('end_date') }}" required>
                            @error('end_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Test Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function editTest(id) {
        alert('Test düzenleme özelliği geliştiriliyor. Yakında eklenecektir.');
    }
</script>
@endpush
@endsection

