@extends('layouts.admin')

@section('title', 'SMS Paketleri')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">SMS Paketleri</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold" style="color: #ec4899;">
            <i class="bi bi-chat-dots me-2"></i>SMS Paketleri
        </h2>
    </div>
    
    <div class="row g-4">
        @foreach($packages as $package)
        <div class="col-md-4">
            <div class="card shadow-sm h-100 border-0" style="border-radius: 15px; overflow: hidden; transition: all 0.3s;">
                <div class="card-body p-4" style="background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);">
                    <div class="text-center mb-4">
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle mb-3" style="width: 80px; height: 80px; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
                            <i class="bi bi-chat-dots-fill text-white" style="font-size: 36px;"></i>
                        </div>
                        <h4 class="fw-bold text-dark mb-2">{{ $package['name'] }}</h4>
                        <h2 class="fw-bold mb-1" style="color: #ec4899;">{{ $package['price'] }}</h2>
                        <p class="text-muted mb-0">{{ $package['sms_count'] }}</p>
                    </div>
                    
                    <div class="text-center mt-4">
                        <form action="{{ route('payment.sms.initiate') }}" method="POST">
                            @csrf
                            <input type="hidden" name="sms_count" value="{{ str_replace(' SMS', '', $package['sms_count']) }}">
                            <input type="hidden" name="price" value="{{ str_replace(['₺', ','], '', $package['price_value']) }}">
                            <button type="submit" class="btn btn-lg w-100 text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 10px; font-weight: 600;">
                                <i class="bi bi-cart-plus me-2"></i> Satın Al
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
    
    <div class="row mt-5">
        <div class="col-12">
            <div class="card shadow-sm border-0" style="border-radius: 15px;">
                <div class="card-body p-4">
                    <h5 class="fw-bold mb-3" style="color: #ec4899;"><i class="bi bi-info-circle me-2"></i> SMS Paketleri Hakkında</h5>
                    <p class="text-muted mb-0">
                        SMS paketlerinizi satın aldıktan sonra, paket otomatik olarak hesabınıza yüklenecektir.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

