@extends('layouts.admin')

@section('title', 'Personel Bonusları')
@section('page-title', 'Personel Bonusları')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-gift me-2"></i>Personel Bonusları
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createBonusModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Bonus Oluştur
                    </button>
                    <a href="{{ route('admin.beauty-salon.staff-performance.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Bonus Listesi
            </h5>
        </div>
        <div class="card-body">
            @if($bonuses->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Personel</th>
                                <th>Bonus Adı</th>
                                <th>Bonus Türü</th>
                                <th>Hedef</th>
                                <th>Bonus Tutarı</th>
                                <th>Dönem</th>
                                <th>Durum</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($bonuses as $bonus)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $bonus->staff->name ?? 'Personel' }}</div>
                                        @if($bonus->staff && $bonus->staff->email)
                                            <small class="text-muted">{{ $bonus->staff->email }}</small>
                                        @endif
                                    </td>
                                    <td class="fw-bold">{{ $bonus->bonus_name }}</td>
                                    <td>
                                        @if($bonus->bonus_type === 'target_based')
                                            <span class="badge bg-info">Hedef Bazlı</span>
                                        @elseif($bonus->bonus_type === 'performance_based')
                                            <span class="badge bg-success">Performans Bazlı</span>
                                        @else
                                            <span class="badge bg-warning text-dark">Özel</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($bonus->target_amount)
                                            {{ number_format($bonus->target_amount, 0, ',', '.') }} ₺
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td class="fw-bold text-success">{{ number_format($bonus->bonus_amount, 2, ',', '.') }} ₺</td>
                                    <td>
                                        <small>
                                            {{ \Carbon\Carbon::parse($bonus->period_start)->format('d.m.Y') }} - 
                                            {{ \Carbon\Carbon::parse($bonus->period_end)->format('d.m.Y') }}
                                        </small>
                                    </td>
                                    <td>
                                        @if($bonus->status === 'active')
                                            <span class="badge bg-success">Aktif</span>
                                        @elseif($bonus->status === 'achieved')
                                            <span class="badge bg-info">Hedefe Ulaşıldı</span>
                                        @elseif($bonus->status === 'paid')
                                            <span class="badge bg-primary">Ödendi</span>
                                        @elseif($bonus->status === 'expired')
                                            <span class="badge bg-danger">Süresi Doldu</span>
                                        @else
                                            <span class="badge bg-secondary">{{ $bonus->status }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#bonusDetailModal{{ $bonus->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="editBonus({{ $bonus->id }})">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <form action="#" method="POST" class="d-inline-block" onsubmit="return confirm('Bu bonusu silmek istediğinizden emin misiniz?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-gift" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz bonus oluşturulmamış.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createBonusModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Bonusu Oluştur
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Create Bonus Modal -->
<div class="modal fade" id="createBonusModal" tabindex="-1" aria-labelledby="createBonusModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 800px;">
        <div class="modal-content" style="border: none; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="createBonusModalLabel">
                    <i class="bi bi-gift me-2"></i>Yeni Bonus Oluştur
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="opacity: 1;"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.staff-performance.bonuses.store') }}" method="POST" id="createBonusForm">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="alert alert-info mb-4" style="border-radius: 12px; border: none; background: #e0f2fe;">
                        <i class="bi bi-lightbulb me-2"></i><strong>Bonus Nedir?</strong><br>
                        <small>Personellerinize hedef veya performansa göre ekstra ödüller verebilirsiniz. Örneğin: Bu ay 10.000₺ gelir getiren personel 500₺ bonus alır.</small>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="staff_id" class="form-label fw-bold">Personel <span class="text-danger">*</span></label>
                            <select class="form-select @error('staff_id') is-invalid @enderror" id="staff_id" name="staff_id" required>
                                <option value="">Seçiniz</option>
                                @foreach($staff as $person)
                                    <option value="{{ $person->id }}" {{ old('staff_id') == $person->id ? 'selected' : '' }}>{{ $person->name }}</option>
                                @endforeach
                            </select>
                            @error('staff_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="bonus_name" class="form-label fw-bold">Bonus Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('bonus_name') is-invalid @enderror" id="bonus_name" name="bonus_name" value="{{ old('bonus_name') }}" placeholder="Örn: Aylık Hedef Bonusu" required>
                            @error('bonus_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="bonus_type" class="form-label fw-bold">Bonus Türü <span class="text-danger">*</span></label>
                            <select class="form-select @error('bonus_type') is-invalid @enderror" id="bonus_type" name="bonus_type" required>
                                <option value="">Seçiniz</option>
                                <option value="target_based" {{ old('bonus_type') == 'target_based' ? 'selected' : '' }}>Hedef Bazlı</option>
                                <option value="performance_based" {{ old('bonus_type') == 'performance_based' ? 'selected' : '' }}>Performans Bazlı</option>
                                <option value="special" {{ old('bonus_type') == 'special' ? 'selected' : '' }}>Özel</option>
                            </select>
                            @error('bonus_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="target_amount" class="form-label fw-bold">Hedef Tutar (₺)</label>
                            <input type="number" step="0.01" class="form-control @error('target_amount') is-invalid @enderror" id="target_amount" name="target_amount" value="{{ old('target_amount') }}" placeholder="Örn: 10000" min="0">
                            @error('target_amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Bu tutara ulaşıldığında bonus verilir.</small>
                        </div>
                        <div class="col-md-6">
                            <label for="bonus_amount" class="form-label fw-bold">Bonus Tutarı (₺) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control @error('bonus_amount') is-invalid @enderror" id="bonus_amount" name="bonus_amount" value="{{ old('bonus_amount') }}" placeholder="Örn: 500" min="0" required>
                            @error('bonus_amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="period_start" class="form-label fw-bold">Dönem Başlangıcı <span class="text-danger">*</span></label>
                            <input type="date" class="form-control @error('period_start') is-invalid @enderror" id="period_start" name="period_start" value="{{ old('period_start') }}" required>
                            @error('period_start')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="period_end" class="form-label fw-bold">Dönem Bitişi <span class="text-danger">*</span></label>
                            <input type="date" class="form-control @error('period_end') is-invalid @enderror" id="period_end" name="period_end" value="{{ old('period_end') }}" required>
                            @error('period_end')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="description" class="form-label fw-bold">Açıklama</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" placeholder="Bonus hakkında açıklama...">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Bonus Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function editBonus(id) {
        alert('Bonus düzenleme özelliği geliştiriliyor. Yakında eklenecektir.');
    }
</script>
@endpush
@endsection

