@extends('layouts.admin')

@section('title', 'Personel Komisyonları')
@section('page-title', 'Personel Komisyonları')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-cash-coin me-2"></i>Personel Komisyonları
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createCommissionModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Komisyon Ayarı
                    </button>
                    <a href="{{ route('admin.beauty-salon.staff-performance.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Komisyon Ayarları
            </h5>
        </div>
        <div class="card-body">
            @if($commissions->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Personel</th>
                                <th>Komisyon Türü</th>
                                <th>Komisyon Oranı</th>
                                <th>Eşik Değerleri</th>
                                <th>Durum</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($commissions as $commission)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $commission->staff->name ?? 'Personel' }}</div>
                                        @if($commission->staff && $commission->staff->email)
                                            <small class="text-muted">{{ $commission->staff->email }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($commission->commission_type === 'percentage')
                                            <span class="badge bg-info">Yüzde</span>
                                        @elseif($commission->commission_type === 'fixed')
                                            <span class="badge bg-success">Sabit</span>
                                        @else
                                            <span class="badge bg-warning text-dark">Kademeli</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($commission->commission_type === 'percentage')
                                            <strong>%{{ number_format($commission->commission_percentage, 2) }}</strong>
                                        @elseif($commission->commission_type === 'fixed')
                                            <strong>{{ number_format($commission->commission_amount, 2, ',', '.') }} ₺</strong>
                                        @else
                                            <span class="text-muted">Kademeli Kurallar</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($commission->min_threshold || $commission->max_threshold)
                                            @if($commission->min_threshold && $commission->max_threshold)
                                                {{ number_format($commission->min_threshold, 0) }} - {{ number_format($commission->max_threshold, 0) }} ₺
                                            @elseif($commission->min_threshold)
                                                {{ number_format($commission->min_threshold, 0) }} ₺ ve üzeri
                                            @elseif($commission->max_threshold)
                                                {{ number_format($commission->max_threshold, 0) }} ₺ ve altı
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($commission->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#commissionDetailModal{{ $commission->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="editCommission({{ $commission->id }})">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <form action="#" method="POST" class="d-inline-block" onsubmit="return confirm('Bu komisyon ayarını silmek istediğinizden emin misiniz?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-cash-coin" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz komisyon ayarı oluşturulmamış.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createCommissionModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Komisyon Ayarını Oluştur
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Create Commission Modal -->
<div class="modal fade" id="createCommissionModal" tabindex="-1" aria-labelledby="createCommissionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 800px;">
        <div class="modal-content" style="border: none; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="createCommissionModalLabel">
                    <i class="bi bi-cash-coin me-2"></i>Yeni Komisyon Ayarı
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="opacity: 1;"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.staff-performance.commissions.store') }}" method="POST" id="createCommissionForm">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="alert alert-info mb-4" style="border-radius: 12px; border: none; background: #e0f2fe;">
                        <i class="bi bi-lightbulb me-2"></i><strong>Komisyon Nedir?</strong><br>
                        <small>Personellerinizin her randevu veya hizmet için kazandığı komisyon oranını belirlersiniz. Örneğin: Her randevu için %10 komisyon veya 1000₺ üzeri için %15 komisyon.</small>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="staff_id" class="form-label fw-bold">Personel <span class="text-danger">*</span></label>
                            <select class="form-select @error('staff_id') is-invalid @enderror" id="staff_id" name="staff_id" required>
                                <option value="">Seçiniz</option>
                                @foreach($staff as $person)
                                    <option value="{{ $person->id }}" {{ old('staff_id') == $person->id ? 'selected' : '' }}>{{ $person->name }}</option>
                                @endforeach
                            </select>
                            @error('staff_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="commission_type" class="form-label fw-bold">Komisyon Türü <span class="text-danger">*</span></label>
                            <select class="form-select @error('commission_type') is-invalid @enderror" id="commission_type" name="commission_type" required>
                                <option value="">Seçiniz</option>
                                <option value="percentage" {{ old('commission_type') == 'percentage' ? 'selected' : '' }}>Yüzde (%)</option>
                                <option value="fixed" {{ old('commission_type') == 'fixed' ? 'selected' : '' }}>Sabit Tutar (₺)</option>
                                <option value="tiered" {{ old('commission_type') == 'tiered' ? 'selected' : '' }}>Kademeli</option>
                            </select>
                            @error('commission_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6" id="commission_percentage_field">
                            <label for="commission_percentage" class="form-label fw-bold">Komisyon Yüzdesi (%)</label>
                            <input type="number" step="0.01" class="form-control @error('commission_percentage') is-invalid @enderror" id="commission_percentage" name="commission_percentage" value="{{ old('commission_percentage') }}" placeholder="Örn: 10" min="0" max="100">
                            @error('commission_percentage')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6" id="commission_amount_field" style="display: none;">
                            <label for="commission_amount" class="form-label fw-bold">Komisyon Tutarı (₺)</label>
                            <input type="number" step="0.01" class="form-control @error('commission_amount') is-invalid @enderror" id="commission_amount" name="commission_amount" value="{{ old('commission_amount') }}" placeholder="Örn: 50" min="0">
                            @error('commission_amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="min_threshold" class="form-label fw-bold">Minimum Eşik (₺)</label>
                            <input type="number" step="0.01" class="form-control @error('min_threshold') is-invalid @enderror" id="min_threshold" name="min_threshold" value="{{ old('min_threshold') }}" placeholder="Örn: 1000" min="0">
                            @error('min_threshold')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Bu tutarın üzerinde komisyon geçerli olur.</small>
                        </div>
                        <div class="col-md-6">
                            <label for="max_threshold" class="form-label fw-bold">Maksimum Eşik (₺)</label>
                            <input type="number" step="0.01" class="form-control @error('max_threshold') is-invalid @enderror" id="max_threshold" name="max_threshold" value="{{ old('max_threshold') }}" placeholder="Örn: 5000" min="0">
                            @error('max_threshold')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Bu tutarın altında komisyon geçerli olur.</small>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Komisyon Ayarı Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.getElementById('commission_type')?.addEventListener('change', function() {
        const type = this.value;
        const percentageField = document.getElementById('commission_percentage_field');
        const amountField = document.getElementById('commission_amount_field');
        
        if (type === 'percentage') {
            percentageField.style.display = 'block';
            amountField.style.display = 'none';
        } else if (type === 'fixed') {
            percentageField.style.display = 'none';
            amountField.style.display = 'block';
        } else {
            percentageField.style.display = 'none';
            amountField.style.display = 'none';
        }
    });

    function editCommission(id) {
        alert('Komisyon düzenleme özelliği geliştiriliyor. Yakında eklenecektir.');
    }
</script>
@endpush
@endsection

