@extends('layouts.admin')

@section('title', 'Personel Performans')
@section('page-title', 'Personel Performans')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-trophy-fill me-2"></i>Personel Performans
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.staff-performance.commissions') }}" class="btn btn-info">
                        <i class="bi bi-cash-coin me-2"></i>Komisyonlar
                    </a>
                    <a href="{{ route('admin.beauty-salon.staff-performance.bonuses') }}" class="btn btn-warning">
                        <i class="bi bi-gift me-2"></i>Bonuslar
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        @forelse($staff as $person)
            @php
                $metric = $performanceMetrics->get($person->id);
            @endphp
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm h-100" style="border: none; border-radius: 16px;">
                    <div class="card-header" style="background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%); border-radius: 16px 16px 0 0;">
                        <div class="d-flex align-items-center gap-3">
                            <div style="width: 50px; height: 50px; border-radius: 50%; background: white; display: flex; align-items: center; justify-content: center; color: #f59e0b; font-weight: bold; font-size: 20px;">
                                {{ substr($person->name, 0, 1) }}
                            </div>
                            <div class="flex-grow-1">
                                <h5 class="mb-0 text-white fw-bold">{{ $person->name }}</h5>
                                @if($person->email)
                                    <small class="text-white-50">{{ $person->email }}</small>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($metric)
                            <div class="row g-3 mb-3">
                                <div class="col-6">
                                    <div class="text-center p-2" style="background: #f0f9ff; border-radius: 8px;">
                                        <div class="fw-bold text-primary">{{ $metric->completed_appointments }}</div>
                                        <small class="text-muted">Tamamlanan</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2" style="background: #fef3c7; border-radius: 8px;">
                                        <div class="fw-bold text-warning">{{ number_format($metric->total_revenue, 0, ',', '.') }} ₺</div>
                                        <small class="text-muted">Gelir</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2" style="background: #d1fae5; border-radius: 8px;">
                                        <div class="fw-bold text-success">{{ $metric->customer_count }}</div>
                                        <small class="text-muted">Müşteri</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2" style="background: #fce7f3; border-radius: 8px;">
                                        <div class="fw-bold" style="color: #ec4899;">
                                            @if($metric->average_rating > 0)
                                                {{ number_format($metric->average_rating, 1) }} ⭐
                                            @else
                                                -
                                            @endif
                                        </div>
                                        <small class="text-muted">Ortalama Puan</small>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="text-center py-3 text-muted">
                                <i class="bi bi-info-circle"></i> Henüz performans verisi yok
                            </div>
                        @endif

                        <div class="d-flex gap-2 mt-3">
                            <a href="{{ route('admin.beauty-salon.personel.show', $person->id) }}" class="btn btn-sm btn-info flex-fill">
                                <i class="bi bi-eye"></i> Detay
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card shadow-sm text-center py-5" style="border: none; border-radius: 16px;">
                    <i class="bi bi-people" style="font-size: 64px; color: #ccc;"></i>
                    <h5 class="mt-3 text-muted">Henüz personel bulunmuyor</h5>
                    <p class="text-muted">Personel ekleyerek performans takibine başlayın.</p>
                    <a href="{{ route('admin.beauty-salon.personel.create') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Personel Ekle
                    </a>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection

