<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Giriş Yap - Salonay</title>
    @include('partials.google-ads-tag')
    <link rel="icon" type="image/png" href="{{ url('favicon.png') }}?v=3">
    <link rel="shortcut icon" href="{{ url('favicon.png') }}?v=3">
    <link rel="apple-touch-icon" href="{{ url('favicon.png') }}?v=3">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        
        body {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 40px;
            width: 100%;
            max-width: 400px;
        }
        
        @media (max-width: 576px) {
            .login-card {
                padding: 30px 20px;
            }
        }
        
        .logo-image {
            height: 80px;
            width: auto;
            object-fit: contain;
            margin-bottom: 15px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        .logo-text {
            font-family: 'LogoFont', 'Inter', sans-serif;
            font-weight: normal;
            letter-spacing: 2px;
            display: none;
        }
        
        /* Animated Text Logo */
        .animated-logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 56px;
            letter-spacing: 3px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 30%, #db2777 60%, #be185d 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradientAnim 3s ease infinite, logoFloatAnim 3s ease-in-out infinite;
            padding: 8px 16px;
            border-radius: 16px;
            overflow: hidden;
            margin: 0 auto 20px;
            text-align: center;
        }
        
        .animated-logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.8s ease;
            animation: logoShineAnim 3s ease-in-out infinite;
        }
        
        .animated-logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            animation: logoLineAnim 3s ease-in-out infinite;
        }
        
        @keyframes logoGradientAnim {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        @keyframes logoFloatAnim {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-6px);
            }
        }
        
        @keyframes logoShineAnim {
            0% {
                left: -100%;
            }
            50% {
                left: 100%;
            }
            100% {
                left: 100%;
            }
        }
        
        @keyframes logoLineAnim {
            0%, 100% {
                transform: scaleX(0);
            }
            50% {
                transform: scaleX(1);
            }
        }
        
        .animated-logo-text:hover {
            transform: scale(1.05) translateY(-3px);
            letter-spacing: 4px;
            animation-duration: 1.5s;
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            body {
                padding: 15px;
            }
            .login-card {
                padding: 30px 20px;
                border-radius: 16px;
            }
            .logo-image {
                height: 50px;
            }
            .form-control {
                font-size: 16px !important; /* Prevent zoom on iOS */
            }
        }
        
        @media (max-width: 480px) {
            .login-card {
                padding: 25px 15px;
            }
            .logo-image {
                height: 45px;
            }
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="text-center mb-4">
            <img src="{{ asset('salonayheaderlogo.png') }}" alt="Salonay" class="logo-image" style="max-height: 80px; width: auto; object-fit: contain; margin-bottom: 15px;" onerror="this.style.display='none'; document.querySelector('.animated-logo-text').style.display='block';">
            <div class="animated-logo-text" style="display: none;">Salonay</div>
            <p class="text-muted mt-2">Sisteme giriş yapın</p>
        </div>
        
        @if($errors->has('database'))
            <div class="alert alert-danger border-danger" style="background-color: #f8d7da; border: 2px solid #dc3545;">
                <div class="d-flex align-items-start">
                    <i class="bi bi-exclamation-triangle-fill me-2" style="font-size: 20px;"></i>
                    <div>
                        <strong>MySQL Servisi Çalışmıyor!</strong>
                        <p class="mb-2 mt-2">{{ $errors->first('database') }}</p>
                        <div class="mt-3">
                            <strong>Çözüm Adımları:</strong>
                            <ol class="mb-0 mt-2" style="padding-left: 20px;">
                                <li>XAMPP Control Panel'i açın</li>
                                <li>MySQL'in yanındaki <strong>Start</strong> butonuna tıklayın</li>
                                <li>MySQL'in yeşil (çalışıyor) olduğundan emin olun</li>
                                <li>Bu sayfayı yenileyin</li>
                            </ol>
                        </div>
                        <div class="mt-3">
                            <a href="http://localhost/check_db.php" target="_blank" class="btn btn-sm btn-outline-danger">
                                <i class="bi bi-database-check"></i> Veritabanı Bağlantısını Test Et
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <form method="POST" action="{{ route('login') }}">
            @csrf
            <div class="mb-3">
                <label for="login" class="form-label">Telefon veya E-posta</label>
                <input type="text" class="form-control" id="login" name="login" value="{{ old('login') }}" required autofocus placeholder="05XX XXX XX XX veya e-posta">
            </div>
            
            <div class="mb-3">
                <label for="password" class="form-label">Şifre</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            
            <div class="mb-3 form-check">
                <input type="checkbox" class="form-check-input" id="remember" name="remember">
                <label class="form-check-label" for="remember">Beni hatırla</label>
            </div>
            
            <button type="submit" class="btn w-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border: none;">
                <i class="bi bi-box-arrow-in-right"></i> Giriş Yap
            </button>
            
            <div class="text-center mt-3">
                <a href="{{ route('register') }}" class="text-decoration-none">Hesabınız yok mu? Kayıt olun</a>
            </div>
        </form>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toast bildirim fonksiyonu
        function showToast(message, type = 'error') {
            // Mevcut toast varsa kaldır
            const existingToast = document.querySelector('.auth-toast');
            if (existingToast) existingToast.remove();
            
            const colors = {
                success: { bg: 'linear-gradient(135deg, #28a745 0%, #20c997 100%)', icon: 'bi-check-circle-fill' },
                error: { bg: 'linear-gradient(135deg, #dc3545 0%, #e74c3c 100%)', icon: 'bi-x-circle-fill' },
                warning: { bg: 'linear-gradient(135deg, #ffc107 0%, #fd7e14 100%)', icon: 'bi-exclamation-triangle-fill' },
                info: { bg: 'linear-gradient(135deg, #17a2b8 0%, #007bff 100%)', icon: 'bi-info-circle-fill' }
            };
            
            const config = colors[type] || colors.error;
            
            const toast = document.createElement('div');
            toast.className = 'auth-toast';
            const isMobile = window.innerWidth <= 768;
            toast.innerHTML = `
                <div style="position: fixed; ${isMobile ? 'top: 10px; left: 10px; right: 10px;' : 'top: 20px; right: 20px;'} z-index: 9999999; animation: slideInRight 0.3s ease;">
                    <div style="background: ${config.bg}; color: white; padding: ${isMobile ? '12px 16px' : '16px 24px'}; border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.3); display: flex; align-items: center; gap: 12px; ${isMobile ? 'min-width: auto; max-width: 100%;' : 'min-width: 300px; max-width: 500px;'}">
                        <i class="bi ${config.icon}" style="font-size: ${isMobile ? '20px' : '24px'}; flex-shrink: 0;"></i>
                        <span style="font-weight: 500; flex: 1; font-size: ${isMobile ? '14px' : '16px'};">${message}</span>
                        <button onclick="this.closest('.auth-toast').remove()" style="background: none; border: none; color: white; font-size: ${isMobile ? '18px' : '20px'}; cursor: pointer; padding: 0; width: 24px; height: 24px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">&times;</button>
                    </div>
                </div>
            `;
            
            // Animasyon style ekle
            if (!document.getElementById('toastAnimationStyle')) {
                const style = document.createElement('style');
                style.id = 'toastAnimationStyle';
                style.textContent = `
                    @keyframes slideInRight {
                        from { transform: translateX(100%); opacity: 0; }
                        to { transform: translateX(0); opacity: 1; }
                    }
                    @keyframes slideOutRight {
                        from { transform: translateX(0); opacity: 1; }
                        to { transform: translateX(100%); opacity: 0; }
                    }
                `;
                document.head.appendChild(style);
            }
            
            document.body.appendChild(toast);
            
            // 5 saniye sonra otomatik kaldır
            setTimeout(() => {
                toast.style.animation = 'slideOutRight 0.3s ease';
                setTimeout(() => toast.remove(), 300);
            }, 5000);
        }
        
        // Hataları toast olarak göster
        @if($errors->any())
            @foreach($errors->all() as $error)
                showToast('{{ $error }}', 'error');
            @endforeach
        @endif
        
        // Başarı mesajlarını göster
        @if(session('success'))
            showToast('{{ session('success') }}', 'success');
        @endif
    </script>
</body>
</html>

