<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Giriş Yap - Salonay</title>
    @include('partials.google-ads-tag')
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-user-select: none;
            -webkit-tap-highlight-color: transparent;
        }
        input {
            -webkit-user-select: text;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #ffffff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-container {
            width: 100%;
            max-width: 400px;
        }
        .logo {
            text-align: center;
            margin-bottom: 40px;
        }
        .logo h1 {
            color: #667eea;
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        .logo p {
            color: #666;
            font-size: 14px;
        }
        
        /* Animated Text Logo */
        .animated-logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 48px;
            letter-spacing: 3px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 30%, #db2777 60%, #be185d 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradientAnim 3s ease infinite, logoFloatAnim 3s ease-in-out infinite;
            padding: 8px 16px;
            border-radius: 16px;
            overflow: hidden;
            margin: 0 auto 20px;
            text-align: center;
        }
        
        .animated-logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.8s ease;
            animation: logoShineAnim 3s ease-in-out infinite;
        }
        
        .animated-logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            animation: logoLineAnim 3s ease-in-out infinite;
        }
        
        @keyframes logoGradientAnim {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        @keyframes logoFloatAnim {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-6px);
            }
        }
        
        @keyframes logoShineAnim {
            0% {
                left: -100%;
            }
            50% {
                left: 100%;
            }
            100% {
                left: 100%;
            }
        }
        
        @keyframes logoLineAnim {
            0%, 100% {
                transform: scaleX(0);
            }
            50% {
                transform: scaleX(1);
            }
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }
        .form-group input {
            width: 100%;
            padding: 14px 16px;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            font-size: 16px;
            transition: border-color 0.3s;
            background: #f9f9f9;
        }
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            background: #fff;
        }
        .btn-login {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
            margin-top: 10px;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        .btn-login:active {
            transform: scale(0.98);
        }
        .btn-login:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .error-message {
            background: #fee;
            color: #c33;
            padding: 12px 16px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 14px;
            display: none;
            border-left: 4px solid #c33;
        }
        .error-message.show {
            display: block;
        }
        .loading {
            display: none;
            text-align: center;
            margin-top: 20px;
        }
        .loading.show {
            display: block;
        }
        .spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .register-link {
            text-align: center;
            margin-top: 30px;
            padding-top: 30px;
            border-top: 1px solid #e0e0e0;
        }
        .register-link p {
            color: #666;
            font-size: 14px;
            margin-bottom: 12px;
        }
        .btn-register {
            width: 100%;
            padding: 14px;
            background: #f5f5f5;
            color: #667eea;
            border: 2px solid #667eea;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: block;
            text-align: center;
        }
        .btn-register:active {
            transform: scale(0.98);
            background: #f0f0f0;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <div class="animated-logo-text">Salonay</div>
            <p>Hesabınıza giriş yapın</p>
        </div>
        
        <div class="error-message" id="errorMessage"></div>
        
        <form id="loginForm">
            <div class="form-group">
                <label>Telefon veya E-posta</label>
                <input type="text" name="login" id="login" required autocomplete="username" placeholder="05XX XXX XX XX veya email@example.com">
            </div>
            
            <div class="form-group">
                <label>Şifre</label>
                <input type="password" name="password" id="password" required autocomplete="current-password" placeholder="Şifrenizi girin">
            </div>
            
            <button type="submit" class="btn-login" id="loginBtn">Giriş Yap</button>
        </form>
        
        <div class="loading" id="loading">
            <img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 40px; height: 40px; display: block; margin: 0 auto;">
        </div>

        <div class="register-link">
            <p>Hesabınız yok mu?</p>
            <a href="/admin/mobile/register" class="btn-register">Kayıt Ol</a>
        </div>
    </div>

    <script>
        document.getElementById('loginForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const errorMsg = document.getElementById('errorMessage');
            const loginBtn = document.getElementById('loginBtn');
            const loading = document.getElementById('loading');
            
            errorMsg.classList.remove('show');
            loginBtn.disabled = true;
            loading.classList.add('show');
            
            const login = document.getElementById('login').value;
            const password = document.getElementById('password').value;
            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            
            try {
                const response = await fetch('/admin/mobile/login', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest',
                        'X-CSRF-TOKEN': csrfToken,
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        login: login,
                        password: password
                    })
                });
                
                let data;
                const contentType = response.headers.get('content-type');
                
                if (contentType && contentType.includes('application/json')) {
                    data = await response.json();
                } else {
                    const text = await response.text();
                    throw new Error('Beklenmeyen response formatı');
                }
                
                if (data.success) {
                    // Flutter bridge'e mesaj gönder
                    if (window.AuthBridge) {
                        window.AuthBridge.postMessage('login_success');
                    }
                    // Redirect
                    window.location.href = data.redirect || '/admin/';
                } else {
                    const errorText = data.errors ? (Array.isArray(data.errors) ? data.errors[0] : data.errors) : (data.message || 'Giriş başarısız. Lütfen bilgilerinizi kontrol edin.');
                    errorMsg.textContent = errorText;
                    errorMsg.classList.add('show');
                    loginBtn.disabled = false;
                    loading.classList.remove('show');
                }
            } catch (error) {
                console.error('Login error:', error);
                errorMsg.textContent = 'Bağlantı hatası. Lütfen internet bağlantınızı kontrol edin ve tekrar deneyin.';
                errorMsg.classList.add('show');
                loginBtn.disabled = false;
                loading.classList.remove('show');
            }
        });
    </script>
</body>
</html>
