<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Kayıt Ol - Salonay</title>
    @include('partials.google-ads-tag')
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-user-select: none;
            -webkit-tap-highlight-color: transparent;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: #f0f2f5;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .register-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            padding: 40px 30px;
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        .logo {
            margin-bottom: 30px;
        }
        .logo h1 {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-top: 10px;
        }
        
        /* Animated Text Logo */
        .animated-logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 48px;
            letter-spacing: 3px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 30%, #db2777 60%, #be185d 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradientAnim 3s ease infinite, logoFloatAnim 3s ease-in-out infinite;
            padding: 8px 16px;
            border-radius: 16px;
            overflow: hidden;
            margin: 0 auto 20px;
            text-align: center;
        }
        
        .animated-logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.8s ease;
            animation: logoShineAnim 3s ease-in-out infinite;
        }
        
        .animated-logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            animation: logoLineAnim 3s ease-in-out infinite;
        }
        
        @keyframes logoGradientAnim {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        @keyframes logoFloatAnim {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-6px);
            }
        }
        
        @keyframes logoShineAnim {
            0% {
                left: -100%;
            }
            50% {
                left: 100%;
            }
            100% {
                left: 100%;
            }
        }
        
        @keyframes logoLineAnim {
            0%, 100% {
                transform: scaleX(0);
            }
            50% {
                transform: scaleX(1);
            }
        }
        
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 500;
            font-size: 14px;
        }
        .form-group input {
            width: 100%;
            padding: 14px;
            border: 1px solid #ddd;
            border-radius: 10px;
            font-size: 16px;
            transition: border-color 0.3s;
            -webkit-user-select: text;
        }
        .form-group input:focus {
            outline: none;
            border-color: #007bff;
        }
        .input-group {
            display: flex;
            gap: 10px;
        }
        .input-group input {
            flex: 1;
        }
        .input-group button {
            padding: 14px 20px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            white-space: nowrap;
            min-width: 100px;
        }
        .input-group button:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .btn-register {
            width: 100%;
            padding: 16px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.2s, transform 0.2s;
            margin-top: 10px;
        }
        .btn-register:hover {
            background-color: #0056b3;
        }
        .btn-register:active {
            transform: scale(0.98);
        }
        .btn-register:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .error-message {
            background: #ffebee;
            color: #d32f2f;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            display: none;
            text-align: left;
        }
        .error-message.show {
            display: block;
        }
        .loading {
            display: none;
            text-align: center;
            margin-top: 20px;
        }
        .loading.show {
            display: block;
        }
        .spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #007bff;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .login-link {
            margin-top: 25px;
            font-size: 14px;
            color: #555;
        }
        .login-link a {
            color: #007bff;
            text-decoration: none;
            font-weight: 600;
        }
        .login-link a:hover {
            text-decoration: underline;
        }
        .otp-status {
            margin-top: 8px;
            font-size: 13px;
            min-height: 20px;
        }
        .otp-status.success {
            color: #28a745;
        }
        .otp-status.error {
            color: #d32f2f;
        }
        .consent-box {
            text-align: left;
            margin-top: 12px;
            margin-bottom: 12px;
            font-size: 13px;
            color: #444;
        }
        .consent-box label {
            display: flex;
            align-items: flex-start;
            gap: 8px;
            margin-bottom: 10px;
            line-height: 1.4;
        }
        .consent-box input[type="checkbox"] {
            margin-top: 2px;
        }
        .consent-note {
            background: #f8fafc;
            border: 1px solid #e5e7eb;
            color: #334155;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 10px;
            font-size: 12px;
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="logo">
            <div class="animated-logo-text">Salonay</div>
        </div>
        
        <div class="error-message" id="errorMessage"></div>
        
        <form id="registerForm">
            <div class="form-group">
                <label>Ad Soyad <span style="color: red;">*</span></label>
                <input type="text" name="name" id="name" required autocomplete="name" placeholder="Adınız Soyadınız">
            </div>
            
            <div class="form-group">
                <label>E-posta <span style="color: red;">*</span></label>
                <input type="email" name="email" id="email" required autocomplete="email" placeholder="ornek@email.com">
            </div>
            
            <div class="form-group">
                <label>Telefon Numarası <span style="color: red;">*</span></label>
                <div class="input-group">
                    <input type="tel" name="phone" id="phone" required autocomplete="tel" placeholder="05XX XXX XX XX">
                    <button type="button" id="sendOtpBtn" onclick="sendOtp()">Kod Gönder</button>
                </div>
                <div class="otp-status" id="otpStatus"></div>
            </div>
            
            <div class="form-group" id="otpField" style="display: none;">
                <label>Doğrulama Kodu <span style="color: red;">*</span></label>
                <input type="text" name="otp_code" id="otp_code" maxlength="6" required placeholder="6 haneli kod">
            </div>
            
            <div class="form-group">
                <label>Şifre <span style="color: red;">*</span></label>
                <input type="password" name="password" id="password" required autocomplete="new-password" placeholder="En az 8 karakter" minlength="8">
            </div>
            
            <div class="form-group">
                <label>Şifre Tekrar <span style="color: red;">*</span></label>
                <input type="password" name="password_confirmation" id="password_confirmation" required autocomplete="new-password" placeholder="Şifrenizi tekrar girin">
            </div>

            <div class="consent-note">
                Kampanya ve ücretlendirme detayları sözleşme metinlerinde yer almaktadır.
            </div>

            <div class="consent-box">
                <label>
                    <input type="checkbox" id="pricing_notice_approval" name="pricing_notice_approval" value="1" required>
                    <span><a href="{{ route('pages.kvkk') }}" target="_blank">KVKK</a>, <a href="{{ route('pages.privacy') }}" target="_blank">Gizlilik Politikası</a> ve <a href="{{ route('pages.terms') }}" target="_blank">Kullanım Şartları</a> metinlerini okudum ve kabul ediyorum.</span>
                </label>
            </div>
            
            <button type="submit" class="btn-register" id="registerBtn">Kayıt Ol</button>
        </form>
        
        <div class="loading" id="loading">
            <img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 40px; height: 40px; display: block; margin: 0 auto;">
        </div>

        <div class="login-link">
            Zaten hesabınız var mı? <a href="/admin/mobile/login">Giriş Yapın</a>
        </div>
    </div>

    <script>
        function getCsrfToken() {
            return document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        }

        function sendOtp() {
            const phone = document.getElementById('phone').value.trim();
            if (!phone) {
                alert('Lütfen telefon numaranızı giriniz.');
                return;
            }

            const sendBtn = document.getElementById('sendOtpBtn');
            const otpStatus = document.getElementById('otpStatus');
            const otpField = document.getElementById('otpField');
            
            sendBtn.disabled = true;
            sendBtn.textContent = 'Gönderiliyor...';
            otpStatus.textContent = '';
            otpStatus.className = 'otp-status';
            
            fetch('/register/send-otp', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': getCsrfToken(),
                    'User-Agent': 'SalonayMobileApp'
                },
                body: JSON.stringify({ phone: phone })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                    otpStatus.className = 'otp-status success';
                    otpField.style.display = 'block';
                    document.getElementById('otp_code').focus();
                    
                    let countdown = 60;
                    const interval = setInterval(() => {
                        countdown--;
                        sendBtn.textContent = `Tekrar Gönder (${countdown}s)`;
                        if (countdown <= 0) {
                            clearInterval(interval);
                            sendBtn.disabled = false;
                            sendBtn.textContent = 'Kod Gönder';
                        }
                    }, 1000);
                } else {
                    otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                    otpStatus.className = 'otp-status error';
                    sendBtn.disabled = false;
                    sendBtn.textContent = 'Kod Gönder';
                }
            })
            .catch(error => {
                console.error('OTP send error:', error);
                otpStatus.textContent = 'Bağlantı hatası. Lütfen tekrar deneyin.';
                otpStatus.className = 'otp-status error';
                sendBtn.disabled = false;
                sendBtn.textContent = 'Kod Gönder';
            });
        }

        // OTP kodu sadece rakam girişi
        document.getElementById('otp_code')?.addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });

        document.getElementById('registerForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const errorMsg = document.getElementById('errorMessage');
            const registerBtn = document.getElementById('registerBtn');
            const loading = document.getElementById('loading');
            
            errorMsg.classList.remove('show');
            registerBtn.disabled = true;
            loading.classList.add('show');
            
            const formData = new FormData(this);
            
            try {
                const response = await fetch('/admin/mobile/register', {
                    method: 'POST',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': getCsrfToken(),
                        'User-Agent': 'SalonayMobileApp'
                    },
                    body: JSON.stringify({
                        name: formData.get('name'),
                        email: formData.get('email'),
                        phone: formData.get('phone'),
                        password: formData.get('password'),
                        password_confirmation: formData.get('password_confirmation'),
                        otp_code: formData.get('otp_code'),
                        pricing_notice_approval: formData.get('pricing_notice_approval') ? 1 : 0
                    })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    if (window.AuthBridge) {
                        window.AuthBridge.postMessage('login_success');
                    }
                    window.location.href = data.redirect || '/admin/';
                } else {
                    const errorText = data.errors ? (Array.isArray(data.errors) ? data.errors[0] : Object.values(data.errors).flat().join(', ')) : (data.message || 'Kayıt başarısız. Lütfen bilgilerinizi kontrol edin.');
                    errorMsg.textContent = errorText;
                    errorMsg.classList.add('show');
                    registerBtn.disabled = false;
                    loading.classList.remove('show');
                }
            } catch (error) {
                console.error('Register fetch error:', error);
                errorMsg.textContent = 'Bağlantı hatası. Lütfen tekrar deneyin.';
                errorMsg.classList.add('show');
                registerBtn.disabled = false;
                loading.classList.remove('show');
            }
        });
    </script>
</body>
</html>

