<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kayıt Ol - Salonay</title>
    @include('partials.google-ads-tag')
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        
        body {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 40px;
            width: 100%;
            max-width: 400px;
        }
        
        @media (max-width: 576px) {
            .login-card {
                padding: 30px 20px;
            }
        }
        
        .logo-image {
            height: 80px;
            width: auto;
            object-fit: contain;
            margin-bottom: 15px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        .logo-text {
            font-family: 'LogoFont', 'Inter', sans-serif;
            font-weight: normal;
            letter-spacing: 2px;
            display: none;
        }
        
        /* Animated Text Logo */
        .animated-logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 56px;
            letter-spacing: 3px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 30%, #db2777 60%, #be185d 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradientAnim 3s ease infinite, logoFloatAnim 3s ease-in-out infinite;
            padding: 8px 16px;
            border-radius: 16px;
            overflow: hidden;
            margin: 0 auto 20px;
            text-align: center;
        }
        
        .animated-logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.8s ease;
            animation: logoShineAnim 3s ease-in-out infinite;
        }
        
        .animated-logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            animation: logoLineAnim 3s ease-in-out infinite;
        }
        
        @keyframes logoGradientAnim {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        @keyframes logoFloatAnim {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-6px);
            }
        }
        
        @keyframes logoShineAnim {
            0% {
                left: -100%;
            }
            50% {
                left: 100%;
            }
            100% {
                left: 100%;
            }
        }
        
        @keyframes logoLineAnim {
            0%, 100% {
                transform: scaleX(0);
            }
            50% {
                transform: scaleX(1);
            }
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            body {
                padding: 15px;
            }
            .login-card {
                padding: 30px 20px;
                border-radius: 16px;
            }
            .logo-image {
                height: 50px;
            }
            .form-control {
                font-size: 16px !important; /* Prevent zoom on iOS */
            }
        }
        
        @media (max-width: 480px) {
            .login-card {
                padding: 25px 15px;
            }
            .logo-image {
                height: 45px;
            }
        }
        
        /* Input Group Styling */
        .input-group .btn {
            z-index: 3;
        }
        
        .input-group .form-control {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
        }
        
        .input-group .btn {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0;
        }
        
        @media (max-width: 768px) {
            .input-group {
                flex-direction: column;
            }
            .input-group .form-control {
                border-radius: 0.375rem;
                margin-bottom: 10px;
            }
            .input-group .btn {
                border-radius: 0.375rem;
                width: 100% !important;
            }
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="text-center mb-4">
            <img src="{{ asset('salonayheaderlogo.png') }}" alt="Salonay" class="logo-image" style="max-height: 80px; width: auto; object-fit: contain; margin-bottom: 15px;" onerror="this.style.display='none'; document.querySelector('.animated-logo-text').style.display='block';">
            <div class="animated-logo-text" style="display: none;">Salonay</div>
            <p class="text-muted mt-2">Hesap oluşturun</p>
        </div>
        
        @if($errors->has('database'))
            <div class="alert alert-danger border-danger" style="background-color: #f8d7da; border: 2px solid #dc3545;">
                <div class="d-flex align-items-start">
                    <i class="bi bi-exclamation-triangle-fill me-2" style="font-size: 20px;"></i>
                    <div>
                        <strong>MySQL Servisi Çalışmıyor!</strong>
                        <p class="mb-2 mt-2">{{ $errors->first('database') }}</p>
                        <div class="mt-3">
                            <strong>Çözüm Adımları:</strong>
                            <ol class="mb-0 mt-2" style="padding-left: 20px;">
                                <li>XAMPP Control Panel'i açın</li>
                                <li>MySQL'in yanındaki <strong>Start</strong> butonuna tıklayın</li>
                                <li>MySQL'in yeşil (çalışıyor) olduğundan emin olun</li>
                                <li>Bu sayfayı yenileyin</li>
                            </ol>
                        </div>
                        <div class="mt-3">
                            <a href="http://localhost/check_db.php" target="_blank" class="btn btn-sm btn-outline-danger">
                                <i class="bi bi-database-check"></i> Veritabanı Bağlantısını Test Et
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <form method="POST" action="{{ route('register') }}">
            @csrf
            
            <div class="mb-3">
                <label for="name" class="form-label">Ad Soyad</label>
                <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required autofocus placeholder="Adınız Soyadınız">
            </div>
            
            <div class="mb-3">
                <label for="email" class="form-label">E-posta Adresi</label>
                <input type="email" class="form-control" id="email" name="email" value="{{ old('email') }}" required placeholder="ornek@email.com">
            </div>
            
            <div class="mb-3">
                <label for="phone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                <input type="tel" class="form-control mb-2" id="phone" name="phone" value="{{ old('phone') }}" required placeholder="05XX XXX XX XX" autocomplete="tel" style="width: 100%;">
                <button type="button" class="btn btn-primary w-100" id="sendOtpBtn" onclick="sendOtpCode()" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; font-weight: 600; padding: 0.6rem; font-size: 0.9rem;">
                    <i class="bi bi-send-fill me-2"></i>Doğrulama Kodu Gönder
                </button>
                <small class="text-muted d-block mt-2">Kayıt için telefon numaranıza SMS ile doğrulama kodu gönderilecektir.</small>
            </div>
            
            <div class="mb-3" id="otpCodeGroup" style="display: none;">
                <label for="otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="otp_code" name="otp_code" maxlength="6" placeholder="6 haneli kod" pattern="[0-9]{6}" autocomplete="one-time-code">
                <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
            </div>
            
            <div class="mb-3">
                <label for="password" class="form-label">Şifre</label>
                <input type="password" class="form-control" id="password" name="password" required placeholder="En az 6 karakter" minlength="6">
            </div>
            
            <div class="mb-3">
                <label for="password_confirmation" class="form-label">Şifre Tekrar</label>
                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required placeholder="Şifrenizi tekrar girin">
            </div>

            <div class="alert alert-light border small py-2 px-3">
                <i class="bi bi-info-circle me-1"></i>
                Kampanya ve ücretlendirme detayları sözleşme metinlerinde yer almaktadır.
            </div>

            <div class="mb-3 form-check">
                <input class="form-check-input" type="checkbox" id="pricing_notice_approval" name="pricing_notice_approval" value="1" {{ old('pricing_notice_approval') ? 'checked' : '' }} required>
                <label class="form-check-label small" for="pricing_notice_approval">
                    <a href="{{ route('pages.kvkk') }}" target="_blank">KVKK</a>,
                    <a href="{{ route('pages.privacy') }}" target="_blank">Gizlilik Politikası</a> ve
                    <a href="{{ route('pages.terms') }}" target="_blank">Kullanım Şartları</a> metinlerini okudum ve kabul ediyorum.
                </label>
            </div>
            
            <button type="submit" class="btn w-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border: none;">
                <i class="bi bi-person-plus"></i> Kayıt Ol
            </button>
            
            <div class="text-center mt-3">
                <a href="{{ route('login') }}" class="text-decoration-none">Zaten hesabınız var mı? Giriş yapın</a>
            </div>
        </form>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toast bildirim fonksiyonu
        function showToast(message, type = 'error') {
            // Mevcut toast varsa kaldır
            const existingToast = document.querySelector('.auth-toast');
            if (existingToast) existingToast.remove();
            
            const colors = {
                success: { bg: 'linear-gradient(135deg, #28a745 0%, #20c997 100%)', icon: 'bi-check-circle-fill' },
                error: { bg: 'linear-gradient(135deg, #dc3545 0%, #e74c3c 100%)', icon: 'bi-x-circle-fill' },
                warning: { bg: 'linear-gradient(135deg, #ffc107 0%, #fd7e14 100%)', icon: 'bi-exclamation-triangle-fill' },
                info: { bg: 'linear-gradient(135deg, #17a2b8 0%, #007bff 100%)', icon: 'bi-info-circle-fill' }
            };
            
            const config = colors[type] || colors.error;
            
            const toast = document.createElement('div');
            toast.className = 'auth-toast';
            const isMobile = window.innerWidth <= 768;
            toast.innerHTML = `
                <div style="position: fixed; ${isMobile ? 'top: 10px; left: 10px; right: 10px;' : 'top: 20px; right: 20px;'} z-index: 9999999; animation: slideInRight 0.3s ease;">
                    <div style="background: ${config.bg}; color: white; padding: ${isMobile ? '12px 16px' : '16px 24px'}; border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.3); display: flex; align-items: center; gap: 12px; ${isMobile ? 'min-width: auto; max-width: 100%;' : 'min-width: 300px; max-width: 500px;'}">
                        <i class="bi ${config.icon}" style="font-size: ${isMobile ? '20px' : '24px'}; flex-shrink: 0;"></i>
                        <span style="font-weight: 500; flex: 1; font-size: ${isMobile ? '14px' : '16px'};">${message}</span>
                        <button onclick="this.closest('.auth-toast').remove()" style="background: none; border: none; color: white; font-size: ${isMobile ? '18px' : '20px'}; cursor: pointer; padding: 0; width: 24px; height: 24px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">&times;</button>
                    </div>
                </div>
            `;
            
            // Animasyon style ekle
            if (!document.getElementById('toastAnimationStyle')) {
                const style = document.createElement('style');
                style.id = 'toastAnimationStyle';
                style.textContent = `
                    @keyframes slideInRight {
                        from { transform: translateX(100%); opacity: 0; }
                        to { transform: translateX(0); opacity: 1; }
                    }
                    @keyframes slideOutRight {
                        from { transform: translateX(0); opacity: 1; }
                        to { transform: translateX(100%); opacity: 0; }
                    }
                `;
                document.head.appendChild(style);
            }
            
            document.body.appendChild(toast);
            
            // 5 saniye sonra otomatik kaldır
            setTimeout(() => {
                toast.style.animation = 'slideOutRight 0.3s ease';
                setTimeout(() => toast.remove(), 300);
            }, 5000);
        }
        
        // SMS Doğrulama Kodu Gönderme
        async function sendOtpCode() {
            const phoneInput = document.getElementById('phone');
            const phone = phoneInput.value.trim().replace(/\s/g, '');
            const sendBtn = document.getElementById('sendOtpBtn');
            
            // Telefon numarası validasyonu
            if (!phone || phone.length < 10) {
                showToast('Lütfen geçerli bir telefon numarası giriniz. (Örn: 05551234567)', 'error');
                phoneInput.focus();
                return;
            }
            
            // Telefon numarası formatını düzelt (0 ile başlamalı)
            let formattedPhone = phone;
            if (!formattedPhone.startsWith('0')) {
                formattedPhone = '0' + formattedPhone;
            }
            
            // Sadece rakam kontrolü
            if (!/^0[0-9]{10}$/.test(formattedPhone)) {
                showToast('Geçersiz telefon numarası formatı. Lütfen 05XX XXX XX XX formatında giriniz.', 'error');
                phoneInput.focus();
                return;
            }
            
            sendBtn.disabled = true;
            sendBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Gönderiliyor...';
            sendBtn.style.opacity = '0.7';
            
            try {
                const response = await fetch('{{ route("register.send-otp") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        phone: formattedPhone,
                        purpose: 'registration'
                    })
                });
                
                let data;
                try {
                    data = await response.json();
                } catch (e) {
                    // JSON parse hatası
                    const text = await response.text();
                    console.error('Response text:', text);
                    throw new Error('Sunucudan geçersiz yanıt alındı.');
                }
                
                if (!response.ok) {
                    // HTTP hata kodu varsa
                    let errorMessage = data.message || data.error || `Sunucu hatası (${response.status}). Lütfen tekrar deneyin.`;
                    
                    // Validation hatalarını kontrol et
                    if (data.errors) {
                        if (data.errors.phone) {
                            errorMessage = Array.isArray(data.errors.phone) ? data.errors.phone[0] : data.errors.phone;
                        } else if (typeof data.errors === 'object') {
                            const firstError = Object.values(data.errors)[0];
                            if (Array.isArray(firstError)) {
                                errorMessage = firstError[0];
                            } else if (typeof firstError === 'string') {
                                errorMessage = firstError;
                            }
                        }
                    }
                    
                    console.error('OTP gönderme hatası (400):', {
                        status: response.status,
                        data: data,
                        errorMessage: errorMessage
                    });
                    
                    showToast(errorMessage, 'error');
                    sendBtn.disabled = false;
                    sendBtn.innerHTML = '<i class="bi bi-send-fill me-2"></i>Doğrulama Kodu Gönder';
                    sendBtn.style.opacity = '1';
                    return;
                }
                
                if (data.success) {
                    showToast('Doğrulama kodu telefonunuza gönderildi. Lütfen kontrol ediniz.', 'success');
                    document.getElementById('otpCodeGroup').style.display = 'block';
                    document.getElementById('otp_code').required = true;
                    document.getElementById('otp_code').focus();
                    
                    // 60 saniye geri sayım
                    let countdown = 60;
                    const originalHTML = sendBtn.innerHTML;
                    const countdownInterval = setInterval(() => {
                        sendBtn.innerHTML = `<i class="bi bi-clock me-2"></i>Tekrar Gönder (${countdown}s)`;
                        countdown--;
                        if (countdown < 0) {
                            clearInterval(countdownInterval);
                            sendBtn.disabled = false;
                            sendBtn.innerHTML = '<i class="bi bi-send-fill me-2"></i>Doğrulama Kodu Gönder';
                            sendBtn.style.opacity = '1';
                        }
                    }, 1000);
                } else {
                    let errorMessage = data.message || data.error || 'Kod gönderilemedi. Lütfen tekrar deneyin.';
                    
                    // Validation hatalarını kontrol et
                    if (data.errors && data.errors.phone) {
                        errorMessage = Array.isArray(data.errors.phone) ? data.errors.phone[0] : data.errors.phone;
                    }
                    
                    // SMS servisi hatası için özel mesaj
                    if (errorMessage.includes('SMS servisi') || errorMessage.includes('1SMS')) {
                        errorMessage = 'SMS servisi şu anda kullanılamıyor. Lütfen daha sonra tekrar deneyin veya destek ekibi ile iletişime geçin.';
                    }
                    
                    console.error('OTP gönderme hatası:', {
                        message: errorMessage,
                        data: data,
                        status: response.status
                    });
                    
                    showToast(errorMessage, 'error');
                    sendBtn.disabled = false;
                    sendBtn.innerHTML = '<i class="bi bi-send-fill me-2"></i>Doğrulama Kodu Gönder';
                    sendBtn.style.opacity = '1';
                }
            } catch (error) {
                console.error('Error:', error);
                let errorMessage = 'Bir hata oluştu. Lütfen internet bağlantınızı kontrol edip tekrar deneyin.';
                
                if (error.message) {
                    errorMessage = error.message;
                }
                
                showToast(errorMessage, 'error');
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send-fill me-2"></i>Doğrulama Kodu Gönder';
                sendBtn.style.opacity = '1';
            }
        }
        
        // Telefon numarası input'una Enter tuşu ile kod gönderme
        document.getElementById('phone').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                sendOtpCode();
            }
        });
        
        // Telefon numarası sadece rakam girişi
        document.getElementById('phone').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9\s]/g, '');
        });
        
        // Hataları toast olarak göster
        @if($errors->any() && !$errors->has('database'))
            @foreach($errors->all() as $error)
                showToast('{{ $error }}', 'error');
            @endforeach
        @endif
        
        // Başarı mesajlarını göster
        @if(session('success'))
            showToast('{{ session('success') }}', 'success');
        @endif
    </script>
</body>
</html>

