<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Sayfa Bulunamadı | Salonay</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #ec4899;
            --secondary-color: #be185d;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            padding: 20px;
        }
        .error-container {
            text-align: center;
            max-width: 600px;
            width: 100%;
        }
        .error-card {
            background: white;
            border-radius: 16px;
            padding: 60px 40px;
            box-shadow: 0 20px 60px rgba(236, 72, 153, 0.15);
            position: relative;
            overflow: hidden;
        }
        .error-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 6px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        }
        .error-icon-wrapper {
            width: 150px;
            height: 150px;
            margin: 0 auto 30px;
            background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: float 3s ease-in-out infinite;
        }
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-15px); }
        }
        .error-icon {
            font-size: 80px;
            color: var(--primary-color);
        }
        .error-code {
            font-size: 120px;
            font-weight: 900;
            margin-bottom: 20px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1;
        }
        .error-title {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 16px;
            color: #1f2937;
        }
        .error-message {
            font-size: 16px;
            color: #6b7280;
            margin-bottom: 40px;
            line-height: 1.6;
        }
        .btn-custom {
            padding: 14px 32px;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s;
            margin: 8px;
            border: none;
            cursor: pointer;
        }
        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            box-shadow: 0 8px 24px rgba(236, 72, 153, 0.3);
        }
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 32px rgba(236, 72, 153, 0.4);
            color: white;
        }
        .btn-outline-custom {
            background: white;
            color: var(--primary-color);
            border: 2px solid var(--primary-color);
        }
        .btn-outline-custom:hover {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            border-color: var(--primary-color);
        }
        @media (max-width: 768px) {
            .error-card {
                padding: 40px 20px;
            }
            .error-code {
                font-size: 80px;
            }
            .error-title {
                font-size: 24px;
            }
            .error-icon-wrapper {
                width: 120px;
                height: 120px;
            }
            .error-icon {
                font-size: 60px;
            }
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-card">
            <div class="error-icon-wrapper">
                <i class="bi bi-search error-icon"></i>
            </div>
            <div class="error-code">404</div>
            <h1 class="error-title">Sayfa Bulunamadı</h1>
            <p class="error-message">
                Aradığınız sayfa mevcut değil veya taşınmış olabilir. Lütfen URL'yi kontrol edin veya ana sayfaya dönün.
            </p>
            <div>
                <a href="{{ route('admin.dashboard') }}" class="btn-custom btn-primary-custom">
                    <i class="bi bi-speedometer2 me-2"></i>Admin Panele Git
                </a>
                <a href="{{ route('login') }}" class="btn-custom btn-outline-custom">
                    <i class="bi bi-box-arrow-in-right me-2"></i>Tekrar Giriş Yap
                </a>
            </div>
        </div>
    </div>
</body>
</html>

