<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>419 - Oturum Süresi Doldu | Salonay</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #ec4899;
            --secondary-color: #be185d;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            padding: 20px;
        }
        .error-container {
            text-align: center;
            color: #111827;
            max-width: 600px;
            width: 100%;
        }
        .error-icon {
            font-size: 150px;
            margin-bottom: 30px;
            opacity: 0.9;
            animation: pulse 2s ease-in-out infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        .error-code {
            font-size: 120px;
            font-weight: 900;
            margin-bottom: 20px;
            color: #dc2626;
            line-height: 1;
        }
        .error-title {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 16px;
            color: #111827;
        }
        .error-message {
            font-size: 18px;
            color: #6b7280;
            margin-bottom: 40px;
            line-height: 1.6;
        }
        .btn-custom {
            padding: 14px 32px;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s;
            margin: 8px;
            border: none;
            cursor: pointer;
        }
        .btn-primary-custom {
            background: #dc2626;
            color: white;
            box-shadow: 0 8px 24px rgba(220, 38, 38, 0.3);
        }
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 32px rgba(220, 38, 38, 0.4);
            color: white;
            background: #b91c1c;
        }
        .btn-outline-custom {
            background: white;
            color: #dc2626;
            border: 2px solid #dc2626;
        }
        .btn-outline-custom:hover {
            background: #dc2626;
            color: white;
        }
        @media (max-width: 768px) {
            .error-code {
                font-size: 80px;
            }
            .error-title {
                font-size: 24px;
            }
            .error-icon {
                font-size: 100px;
            }
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-icon">⏱️</div>
        <div class="error-code">419</div>
        <h1 class="error-title">Oturum Süresi Doldu</h1>
        <p class="error-message">
            Güvenlik nedeniyle oturumunuz sonlandırıldı. Devam etmek için lütfen tekrar giriş yapın.
        </p>
        <div>
            <a href="{{ route('login') }}" class="btn-custom btn-primary-custom">
                <i class="bi bi-box-arrow-in-right me-2"></i>Tekrar Giriş Yap
            </a>
            <a href="{{ url('/') }}" class="btn-custom btn-outline-custom">
                <i class="bi bi-house-door me-2"></i>Ana Sayfaya Dön
            </a>
        </div>
    </div>
</body>
</html>

