<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ url('favicon.png') }}?v=3">
    <link rel="shortcut icon" href="{{ url('favicon.png') }}?v=3">
    <link rel="apple-touch-icon" href="{{ url('favicon.png') }}?v=3">
    
    @php
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key');
        } catch (\Exception $e) {
            $settings = collect([]);
        }
        $phone = $settings['phone'] ?? '0850 811 08 20';
        $email = $settings['email'] ?? 'info@salonay.com';
        $companyName = $settings['company_name'] ?? 'Salonay';
        $address = $settings['address'] ?? '';
        
        $siteUrl = url('/');
        $siteName = 'Salonay - Türkiye\'nin En Gelişmiş Güzellik uzmanı Randevu Sistemi';
        $siteDescription = 'Türkiye\'nin en gelişmiş güzellik salonu randevu sistemi. Randevularınızı kolayca yönetin, müşterilerinizi takip edin ve işletmenizi büyütün. Modern ve kullanıcı dostu arayüz ile her şey tek panelde.';
        $siteKeywords = 'güzellik salonu randevu sistemi, güzellik salonu randevu yazılımı, randevu yönetim sistemi, güzellik salonu yönetimi, güzellik salonu yönetim yazılımı, müşteri yönetimi, muhasebe yazılımı, randevu takip sistemi, salon yönetim yazılımı, randevu sistemi, Türkiye randevu, online randevu, güzellik salonu programı, estetik merkezi randevu sistemi';
    @endphp
    
    <!-- Primary Meta Tags -->
    <title>{{ $siteName }}</title>
    @include('partials.google-ads-tag')
    <meta name="title" content="{{ $siteName }}">
    <meta name="description" content="{{ $siteDescription }}">
    <meta name="keywords" content="{{ $siteKeywords }}">
    <meta name="author" content="{{ $companyName }}">
    <meta name="robots" content="index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1">
    <meta name="language" content="Turkish">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="general">
    <meta name="geo.region" content="TR">
    <meta name="geo.placename" content="Türkiye">
    <meta name="distribution" content="global">
    <meta name="coverage" content="worldwide">
    <meta name="target" content="all">
    <meta name="audience" content="all">
    <link rel="canonical" href="{{ $siteUrl }}">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ $siteUrl }}">
    <meta property="og:title" content="{{ $siteName }}">
    <meta property="og:description" content="{{ $siteDescription }}">
    <meta property="og:image" content="{{ $siteUrl }}/images/og-image.jpg">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="{{ $siteName }}">
    <meta property="og:locale" content="tr_TR">
    <meta property="og:site_name" content="{{ $companyName }}">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="{{ $siteUrl }}">
    <meta name="twitter:title" content="{{ $siteName }}">
    <meta name="twitter:description" content="{{ $siteDescription }}">
    <meta name="twitter:image" content="{{ $siteUrl }}/images/twitter-card.jpg">
    <meta name="twitter:image:alt" content="{{ $siteName }}">
    <meta name="twitter:creator" content="@salonay">
    <meta name="twitter:site" content="@salonay">
    
    <!-- Additional Meta Tags -->
    <meta name="theme-color" content="#ec4899">
    <meta name="msapplication-TileColor" content="#ec4899">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="{{ $companyName }}">
    
    <!-- Geo Tags -->
    <meta name="geo.region" content="TR">
    <meta name="geo.placename" content="Türkiye">
    
    <!-- Structured Data (JSON-LD) -->
    @php
        $organizationData = [
            "@context" => "https://schema.org",
            "@type" => "Organization",
            "name" => $companyName,
            "url" => $siteUrl,
            "logo" => $siteUrl . "/images/logo.png",
            "description" => $siteDescription,
            "address" => [
                "@type" => "PostalAddress",
                "addressCountry" => "TR",
                "addressLocality" => "Türkiye"
            ],
            "contactPoint" => [
                "@type" => "ContactPoint",
                "telephone" => $phone,
                "contactType" => "customer service",
                "areaServed" => "TR",
                "availableLanguage" => ["Turkish"]
            ],
            "sameAs" => [
                "https://www.facebook.com/salonay",
                "https://www.twitter.com/salonay",
                "https://www.instagram.com/salonay",
                "https://www.linkedin.com/company/salonay"
            ],
            "aggregateRating" => [
                "@type" => "AggregateRating",
                "ratingValue" => "4.9",
                "reviewCount" => "2500",
                "bestRating" => "5",
                "worstRating" => "1"
            ]
        ];
        if ($address) {
            $organizationData["address"]["streetAddress"] = $address;
        }
        if ($email) {
            $organizationData["contactPoint"]["email"] = $email;
        }
    @endphp
    <script type="application/ld+json">
    {!! json_encode($organizationData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    @php
        $softwareAppData = [
            "@context" => "https://schema.org",
            "@type" => "SoftwareApplication",
            "name" => $companyName,
            "applicationCategory" => "BusinessApplication",
            "operatingSystem" => "Web",
            "offers" => [
                "@type" => "Offer",
                "price" => "0",
                "priceCurrency" => "TRY"
            ],
            "aggregateRating" => [
                "@type" => "AggregateRating",
                "ratingValue" => "4.9",
                "reviewCount" => "2500",
                "bestRating" => "5",
                "worstRating" => "1"
            ],
            "description" => $siteDescription
        ];
        
        $websiteData = [
            "@context" => "https://schema.org",
            "@type" => "WebSite",
            "name" => $companyName,
            "url" => $siteUrl,
            "potentialAction" => [
                "@type" => "SearchAction",
                "target" => $siteUrl . "/search?q={search_term_string}",
                "query-input" => "required name=search_term_string"
            ]
        ];
        
        $breadcrumbData = [
            "@context" => "https://schema.org",
            "@type" => "BreadcrumbList",
            "itemListElement" => [[
                "@type" => "ListItem",
                "position" => 1,
                "name" => "Ana Sayfa",
                "item" => $siteUrl
            ]]
        ];
    @endphp
    <script type="application/ld+json">
    {!! json_encode($softwareAppData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <script type="application/ld+json">
    {!! json_encode($websiteData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <script type="application/ld+json">
    {!! json_encode($breadcrumbData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <!-- FAQ Schema - SEO için -->
    @php
        $faqData = [
            "@context" => "https://schema.org",
            "@type" => "FAQPage",
            "mainEntity" => [
                [
                    "@type" => "Question",
                    "name" => "Salonay nedir?",
                    "acceptedAnswer" => [
                        "@type" => "Answer",
                        "text" => "Salonay, güzellik salonları, estetik merkezleri ve estetik merkezleri için geliştirilmiş profesyonel bir randevu yönetim sistemidir. Randevu takibi, müşteri yönetimi, muhasebe ve fatura işlemlerini tek panelden yönetmenizi sağlar."
                    ]
                ],
                [
                    "@type" => "Question",
                    "name" => "Salonay'ı kimler kullanabilir?",
                    "acceptedAnswer" => [
                        "@type" => "Answer",
                        "text" => "Güzellik salonları, estetik merkezleri, estetik merkezleri, cilt bakım merkezleri, saç tasarım salonları, makyaj stüdyoları ve her türlü randevu gerektiren güzellik ve bakım işletmeleri Salonay'ı kullanabilir."
                    ]
                ],
                [
                    "@type" => "Question",
                    "name" => "Salonay ücretsiz mi?",
                    "acceptedAnswer" => [
                        "@type" => "Answer",
                        "text" => "Evet, Salonay'ı ücretsiz deneyebilirsiniz. Temel özellikler ücretsiz sunulmaktadır. Gelişmiş özellikler için uygun fiyatlı paketlerimiz mevcuttur."
                    ]
                ],
                [
                    "@type" => "Question",
                    "name" => "Salonay'da hangi özellikler var?",
                    "acceptedAnswer" => [
                        "@type" => "Answer",
                        "text" => "Salon yönetimi, online randevu sistemi, müşteri takibi, takvim görünümü, gelir-gider takibi, fatura ve sözleşme oluşturma, SMS ve WhatsApp bildirimleri, raporlama ve analiz özellikleri bulunmaktadır."
                    ]
                ],
                [
                    "@type" => "Question",
                    "name" => "Mobil cihazlardan erişebilir miyim?",
                    "acceptedAnswer" => [
                        "@type" => "Answer",
                        "text" => "Evet, Salonay tamamen responsive tasarıma sahiptir. Telefon, tablet ve bilgisayardan kolayca erişebilir ve yönetebilirsiniz."
                    ]
                ]
            ]
        ];
        
        $localBusinessData = [
            "@context" => "https://schema.org",
            "@type" => "LocalBusiness",
            "name" => $companyName,
            "description" => $siteDescription,
            "url" => $siteUrl,
            "telephone" => $phone,
            "email" => $email,
            "address" => [
                "@type" => "PostalAddress",
                "addressCountry" => "TR"
            ],
            "priceRange" => "₺₺",
            "openingHours" => "Mo-Fr 09:00-18:00",
            "aggregateRating" => [
                "@type" => "AggregateRating",
                "ratingValue" => "4.9",
                "bestRating" => "5",
                "worstRating" => "1",
                "ratingCount" => "2500",
                "reviewCount" => "2500"
            ]
        ];
        
        $serviceData = [
            "@context" => "https://schema.org",
            "@type" => "Service",
            "serviceType" => "Randevu Yönetim Yazılımı",
            "provider" => [
                "@type" => "Organization",
                "name" => $companyName
            ],
            "areaServed" => [
                "@type" => "Country",
                "name" => "Türkiye"
            ],
            "hasOfferCatalog" => [
                "@type" => "OfferCatalog",
                "name" => "Randevu Yönetim Hizmetleri",
                "itemListElement" => [
                    [
                        "@type" => "Offer",
                        "itemOffered" => [
                            "@type" => "Service",
                            "name" => "Salon Yönetimi"
                        ]
                    ],
                    [
                        "@type" => "Offer",
                        "itemOffered" => [
                            "@type" => "Service",
                            "name" => "Randevu Takibi"
                        ]
                    ],
                    [
                        "@type" => "Offer",
                        "itemOffered" => [
                            "@type" => "Service",
                            "name" => "Müşteri Yönetimi"
                        ]
                    ]
                ]
            ]
        ];
        
        // HowTo Schema - Nasıl Kullanılır
        $howToData = [
            "@context" => "https://schema.org",
            "@type" => "HowTo",
            "name" => "Salonay ile Randevu Yönetimi Nasıl Yapılır?",
            "description" => "Salonay kullanarak güzellik salonu randevularınızı kolayca yönetin",
            "totalTime" => "PT5M",
            "step" => [
                [
                    "@type" => "HowToStep",
                    "position" => 1,
                    "name" => "Ücretsiz Kayıt Olun",
                    "text" => "Salonay'a ücretsiz kayıt olun ve hesabınızı oluşturun"
                ],
                [
                    "@type" => "HowToStep",
                    "position" => 2,
                    "name" => "Salonlarınızı Ekleyin",
                    "text" => "İşletmenizdeki güzellik salonu mekanlarını sisteme ekleyin"
                ],
                [
                    "@type" => "HowToStep",
                    "position" => 3,
                    "name" => "Müşterilerinizi Kaydedin",
                    "text" => "Müşteri bilgilerini sisteme girerek takip edin"
                ],
                [
                    "@type" => "HowToStep",
                    "position" => 4,
                    "name" => "Randevu Oluşturun",
                    "text" => "Takvim üzerinden kolayca randevu oluşturun ve yönetin"
                ],
                [
                    "@type" => "HowToStep",
                    "position" => 5,
                    "name" => "Ödemeleri Takip Edin",
                    "text" => "Kapora, fatura ve ödemeleri otomatik olarak takip edin"
                ]
            ]
        ];
        
        // Product Schema - Ürün Bilgisi
        $productData = [
            "@context" => "https://schema.org",
            "@type" => "Product",
            "name" => "Salonay Randevu Yönetim Sistemi",
            "description" => $siteDescription,
            "brand" => [
                "@type" => "Brand",
                "name" => $companyName
            ],
            "offers" => [
                "@type" => "AggregateOffer",
                "lowPrice" => "0",
                "highPrice" => "999",
                "priceCurrency" => "TRY",
                "offerCount" => "3",
                "availability" => "https://schema.org/InStock"
            ],
            "aggregateRating" => [
                "@type" => "AggregateRating",
                "ratingValue" => "4.9",
                "bestRating" => "5",
                "worstRating" => "1",
                "ratingCount" => "186",
                "reviewCount" => "142"
            ],
            "review" => [
                [
                    "@type" => "Review",
                    "author" => [
                        "@type" => "Person",
                        "name" => "Mehmet Yılmaz"
                    ],
                    "datePublished" => "2024-12-01",
                    "reviewBody" => "Güzellik salonumuz için mükemmel bir çözüm. Tüm randevularımızı tek panelden yönetebiliyoruz.",
                    "reviewRating" => [
                        "@type" => "Rating",
                        "ratingValue" => "5",
                        "bestRating" => "5"
                    ]
                ],
                [
                    "@type" => "Review",
                    "author" => [
                        "@type" => "Person",
                        "name" => "Ayşe Kaya"
                    ],
                    "datePublished" => "2024-11-15",
                    "reviewBody" => "Müşteri takibi ve muhasebe işlemleri çok kolaylaştı. Kesinlikle tavsiye ederim.",
                    "reviewRating" => [
                        "@type" => "Rating",
                        "ratingValue" => "5",
                        "bestRating" => "5"
                    ]
                ]
            ]
        ];
        
        // VideoObject Schema (tanıtım videosu varsa)
        $videoData = [
            "@context" => "https://schema.org",
            "@type" => "VideoObject",
            "name" => "Salonay Nasıl Kullanılır?",
            "description" => "Salonay salon randevu yönetim sisteminin tanıtım videosu",
            "thumbnailUrl" => $siteUrl . "/images/video-thumbnail.jpg",
            "uploadDate" => "2024-01-01",
            "duration" => "PT3M",
            "contentUrl" => $siteUrl . "/videos/tanitim.mp4",
            "embedUrl" => $siteUrl . "/videos/tanitim"
        ];
        
        // ItemList Schema - Özellikler Listesi
        $featureListData = [
            "@context" => "https://schema.org",
            "@type" => "ItemList",
            "name" => "Salonay Özellikleri",
            "numberOfItems" => 8,
            "itemListElement" => [
                ["@type" => "ListItem", "position" => 1, "name" => "Salon Yönetimi"],
                ["@type" => "ListItem", "position" => 2, "name" => "Online Randevu"],
                ["@type" => "ListItem", "position" => 3, "name" => "Müşteri Takibi"],
                ["@type" => "ListItem", "position" => 4, "name" => "Takvim Görünümü"],
                ["@type" => "ListItem", "position" => 5, "name" => "Fatura Oluşturma"],
                ["@type" => "ListItem", "position" => 6, "name" => "SMS Bildirimleri"],
                ["@type" => "ListItem", "position" => 7, "name" => "Muhasebe Takibi"],
                ["@type" => "ListItem", "position" => 8, "name" => "Raporlama"]
            ]
        ];
        
        // Customer Reviews Schema - SEO için
        $reviewsData = [
            "@context" => "https://schema.org",
            "@type" => "Product",
            "name" => "Salonay - Güzellik uzmanı ve Güzellik uzmanı Randevu Sistemi",
            "description" => $siteDescription,
            "brand" => [
                "@type" => "Brand",
                "name" => $companyName
            ],
            "aggregateRating" => [
                "@type" => "AggregateRating",
                "ratingValue" => "4.9",
                "reviewCount" => "2500",
                "bestRating" => "5",
                "worstRating" => "1"
            ],
            "review" => [
                [
                    "@type" => "Review",
                    "author" => [
                        "@type" => "Person",
                        "name" => "Ahmet Yılmaz"
                    ],
                    "datePublished" => "2024-01-15",
                    "reviewBody" => "Salonay sayesinde randevu yönetimimiz tamamen değişti. Artık hiçbir randevuu kaçırmıyoruz ve müşterilerimiz çok memnun. Kesinlikle tavsiye ederim!",
                    "reviewRating" => [
                        "@type" => "Rating",
                        "ratingValue" => "5",
                        "bestRating" => "5"
                    ]
                ],
                [
                    "@type" => "Review",
                    "author" => [
                        "@type" => "Person",
                        "name" => "Ayşe Demir"
                    ],
                    "datePublished" => "2024-02-20",
                    "reviewBody" => "Güzellik salonumuz için mükemmel bir sistem. Randevu takibi, fatura oluşturma ve müşteri yönetimi tek panelde. İşimizi çok kolaylaştırdı.",
                    "reviewRating" => [
                        "@type" => "Rating",
                        "ratingValue" => "5",
                        "bestRating" => "5"
                    ]
                ],
                [
                    "@type" => "Review",
                    "author" => [
                        "@type" => "Person",
                        "name" => "Mehmet Kaya"
                    ],
                    "datePublished" => "2024-03-10",
                    "reviewBody" => "3 yıldır kullanıyorum ve hiç sorun yaşamadım. SMS bildirimleri, otomatik fatura oluşturma ve detaylı raporlar harika.",
                    "reviewRating" => [
                        "@type" => "Rating",
                        "ratingValue" => "5",
                        "bestRating" => "5"
                    ]
                ],
                [
                    "@type" => "Review",
                    "author" => [
                        "@type" => "Person",
                        "name" => "Ali Öztürk"
                    ],
                    "datePublished" => "2024-04-05",
                    "reviewBody" => "Randevu sistemimizi Salonay'a geçirdikten sonra işlerimiz %40 arttı. Müşteri memnuniyeti de çok yükseldi.",
                    "reviewRating" => [
                        "@type" => "Rating",
                        "ratingValue" => "5",
                        "bestRating" => "5"
                    ]
                ],
                [
                    "@type" => "Review",
                    "author" => [
                        "@type" => "Person",
                        "name" => "Zeynep Arslan"
                    ],
                    "datePublished" => "2024-05-12",
                    "reviewBody" => "Fatura ve sözleşme oluşturma özelliği hayat kurtarıcı. Artık manuel işlem yapmıyoruz, her şey otomatik.",
                    "reviewRating" => [
                        "@type" => "Rating",
                        "ratingValue" => "5",
                        "bestRating" => "5"
                    ]
                ]
            ]
        ];
    @endphp
    <script type="application/ld+json">
    {!! json_encode($faqData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <script type="application/ld+json">
    {!! json_encode($localBusinessData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <script type="application/ld+json">
    {!! json_encode($serviceData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <script type="application/ld+json">
    {!! json_encode($howToData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <script type="application/ld+json">
    {!! json_encode($productData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <script type="application/ld+json">
    {!! json_encode($featureListData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <!-- Customer Reviews Schema - SEO -->
    <script type="application/ld+json">
    {!! json_encode($reviewsData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
    </script>
    
    <!-- Preconnect & Prefetch for Performance -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net">
    <link rel="dns-prefetch" href="https://fonts.googleapis.com">
    <link rel="dns-prefetch" href="https://cdn.jsdelivr.net">
    <link rel="manifest" href="{{ url('/manifest.json') }}">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600;700;800;900&family=Montserrat:wght@700;800;900&display=swap" rel="stylesheet">
    
    <style>
        
        :root {
            --primary-blue: #ec4899;
            --secondary-blue: #f472b6;
            --light-blue: #f9a8d4;
            --dark-blue: #be185d;
            --dark-color: #1e293b;
            --light-color: #f8fafc;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            overflow-x: hidden;
            scroll-behavior: smooth;
            color: #1e293b;
        }
        
        /* Top Promo Banner */
        .top-promo-banner {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 100%);
            color: white;
            padding: 12px 0;
            text-align: center;
            font-size: 14px;
            font-weight: 600;
            position: relative;
            z-index: 1001;
        }
        
        .top-promo-banner a {
            color: white;
            text-decoration: underline;
            font-weight: 700;
        }
        
        /* Navbar */
        .navbar {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 0.5rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .navbar-brand {
            display: flex;
            align-items: center;
            text-decoration: none;
        }
        
        .logo-image {
            height: 50px;
            width: auto;
            object-fit: contain;
        }
        
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        
        .logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 36px;
            letter-spacing: 2.5px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 25%, #fbcfe8 50%, #f472b6 75%, #ec4899 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradient 3s ease infinite;
            padding: 6px 16px;
            border-radius: 14px;
            overflow: hidden;
        }
        
        .logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.6s ease;
        }
        
        .logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.4s ease;
        }
        
        .logo-text:hover {
            transform: scale(1.1) translateY(-3px);
            letter-spacing: 3.5px;
            animation-duration: 1.5s;
            box-shadow: 0 8px 30px rgba(236, 72, 153, 0.3);
        }
        
        .logo-text:hover::before {
            left: 100%;
        }
        
        .logo-text:hover::after {
            transform: scaleX(1);
        }
        
        @keyframes logoGradient {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        .footer .logo-image {
            height: 50px;
            width: auto;
            filter: brightness(0) invert(1);
        }
        
        .footer .logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 40px;
            letter-spacing: 2.5px;
            background: linear-gradient(135deg, #ffffff 0%, #fce7f3 30%, #fbcfe8 60%, #ffffff 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(255, 255, 255, 0.4), 0 0 40px rgba(255, 255, 255, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradient 3s ease infinite;
            padding: 6px 16px;
            border-radius: 14px;
            overflow: hidden;
        }
        
        .footer .logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.6s ease;
        }
        
        .footer .logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.4s ease;
        }
        
        .footer .logo-text:hover {
            transform: scale(1.1) translateY(-3px);
            letter-spacing: 3.5px;
            animation-duration: 1.5s;
            box-shadow: 0 8px 30px rgba(255, 255, 255, 0.2);
        }
        
        .footer .logo-text:hover::before {
            left: 100%;
        }
        
        .footer .logo-text:hover::after {
            transform: scaleX(1);
        }
        
        .nav-link {
            font-weight: 500;
            color: #1e293b !important;
            margin: 0 0.5rem;
            transition: color 0.3s;
        }
        
        .nav-link:hover {
            color: var(--primary-blue) !important;
        }
        
        .navbar-phone {
            color: #1e293b;
            font-weight: 600;
            margin-right: 1rem;
            font-size: 0.875rem;
        }
        
        .btn-outline-primary {
            border: 2px solid var(--primary-blue);
            color: var(--primary-blue);
            background: transparent;
            font-weight: 600;
            padding: 0.4rem 1rem;
            border-radius: 8px;
            transition: all 0.3s;
            font-size: 0.875rem;
        }
        
        .btn-outline-primary:hover {
            background: var(--primary-blue);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
        }
        
        /* Header Butonları - Orta Boy ve Modern */
        .navbar .btn {
            padding: 0.5rem 1.25rem;
            font-size: 0.9rem;
            font-weight: 600;
            border-radius: 8px;
            white-space: nowrap;
            transition: all 0.3s ease;
        }
        
        .navbar .btn-primary {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            color: white;
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
        }
        
        .navbar .btn-primary:hover {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.4);
        }
        
        .navbar .btn-outline-primary {
            padding: 0.5rem 1.25rem;
            font-size: 0.9rem;
        }
        
        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 50%, #f472b6 100%);
            color: white;
            padding: 80px 0 60px;
            position: relative;
            overflow: hidden;
        }
        
        .hero h1 {
            font-size: 3.5rem;
            font-weight: 900;
            margin-bottom: 1.5rem;
            line-height: 1.2;
        }
        
        .hero p {
            font-size: 1.25rem;
            margin-bottom: 2rem;
            opacity: 0.95;
        }
        
        .hero-buttons .btn {
            padding: 0.75rem 2rem;
            font-weight: 600;
            border-radius: 8px;
            margin-right: 1rem;
            margin-bottom: 1rem;
        }
        
        /* References Section - 81 İl Slider */
        .references {
            padding: 60px 0;
            background: white;
            border-top: 1px solid #e5e7eb;
            border-bottom: 1px solid #e5e7eb;
            overflow: hidden;
            position: relative;
        }
        
        .reference-title {
            text-align: center;
            font-size: 14px;
            font-weight: 700;
            color: #64748b;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 3rem;
        }
        
        .cities-slider {
            display: flex;
            gap: 2rem;
            animation: scroll 120s linear infinite;
            width: max-content;
        }
        
        @keyframes scroll {
            0% {
                transform: translateX(0);
            }
            100% {
                transform: translateX(-50%);
            }
        }
        
        .cities-slider-wrapper {
            display: flex;
            gap: 2rem;
        }
        
        .city-item {
            min-width: 140px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s;
            border: 2px solid transparent;
            white-space: nowrap;
            padding: 0 20px;
        }
        
        /* Soft pastel renk paletleri */
        .city-item:nth-child(8n+1) { background: #e0f2fe; color: #0369a1; border-color: #bae6fd; } /* Soft Mavi */
        .city-item:nth-child(8n+2) { background: #dcfce7; color: #15803d; border-color: #bbf7d0; } /* Soft Yeşil */
        .city-item:nth-child(8n+3) { background: #fef3c7; color: #b45309; border-color: #fde68a; } /* Soft Sarı */
        .city-item:nth-child(8n+4) { background: #fce7f3; color: #be185d; border-color: #fbcfe8; } /* Soft Pembe */
        .city-item:nth-child(8n+5) { background: #ede9fe; color: #6d28d9; border-color: #ddd6fe; } /* Soft Mor */
        .city-item:nth-child(8n+6) { background: #e0e7ff; color: #4338ca; border-color: #c7d2fe; } /* Soft İndigo */
        .city-item:nth-child(8n+7) { background: #ccfbf1; color: #0f766e; border-color: #99f6e4; } /* Soft Teal */
        .city-item:nth-child(8n+8) { background: #fef9c3; color: #a16207; border-color: #fef08a; } /* Soft Lime */
        
        .city-item:hover {
            filter: brightness(0.95);
        }
        
        .cities-container {
            overflow: hidden;
            position: relative;
        }
        
        .cities-container::before,
        .cities-container::after {
            content: '';
            position: absolute;
            top: 0;
            width: 100px;
            height: 100%;
            z-index: 2;
            pointer-events: none;
        }
        
        .cities-container::before {
            left: 0;
            background: linear-gradient(to right, white, transparent);
        }
        
        .cities-container::after {
            right: 0;
            background: linear-gradient(to left, white, transparent);
        }
        
        /* Features Section */
        .features {
            padding: 80px 0;
            background: #f8fafc;
        }
        
        .section-title {
            font-size: 2.5rem;
            font-weight: 900;
            text-align: center;
            margin-bottom: 1rem;
            color: #1e293b;
        }
        
        .section-subtitle {
            text-align: center;
            font-size: 1.1rem;
            color: #64748b;
            margin-bottom: 4rem;
            max-width: 800px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .feature-card {
            background: white;
            border-radius: 12px;
            padding: 2rem;
            height: 100%;
            transition: all 0.3s;
            border: 1px solid #e5e7eb;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .feature-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        .feature-card h3 {
            font-size: 1.25rem;
            font-weight: 700;
            margin-bottom: 1rem;
            color: #1e293b;
        }
        
        .feature-card p {
            color: #64748b;
            line-height: 1.6;
        }
        
        /* Salons Section */
        .salons {
            padding: 80px 0;
            background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        }
        
        .salon-card-home {
            background: white;
            border-radius: 16px;
            padding: 0;
            height: 100%;
            transition: all 0.3s ease;
            border: 1px solid #e2e8f0;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        
        .salon-card-home:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 32px rgba(236, 72, 153, 0.15);
            border-color: #ec4899;
        }
        
        .salon-card-home img {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
        
        .salon-card-home .salon-card-placeholder {
            width: 100%;
            height: 200px;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .salon-card-home .salon-card-placeholder i {
            font-size: 4rem;
            color: white;
            opacity: 0.8;
        }
        
        .salon-card-home .card-body {
            padding: 1.5rem;
        }
        
        .salon-card-home h5 {
            font-size: 1.25rem;
            font-weight: 700;
            margin-bottom: 0.75rem;
            color: #0f172a;
        }
        
        .salon-card-home h5 a {
            color: #0f172a;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .salon-card-home h5 a:hover {
            color: #ec4899;
        }
        
        .salon-card-home .rating {
            margin-bottom: 0.75rem;
        }
        
        .salon-card-home .rating i {
            color: #fbbf24;
            font-size: 0.9rem;
        }
        
        .salon-card-home .rating-text {
            color: #64748b;
            font-size: 0.875rem;
            margin-left: 0.5rem;
        }
        
        .salon-card-home .address {
            color: #64748b;
            font-size: 0.875rem;
            margin-bottom: 1rem;
            line-height: 1.5;
        }
        
        .salon-card-home .address i {
            margin-right: 0.5rem;
            color: #ec4899;
        }
        
        .salon-card-home .btn-view {
            width: 100%;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .salon-card-home .btn-view:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(236, 72, 153, 0.3);
            color: white;
        }
        
        /* Packages Section */
        .packages {
            padding: 80px 0;
            background: white;
        }
        
        .package-card {
            background: white;
            border-radius: 12px;
            padding: 2.5rem;
            border: 2px solid #e5e7eb;
            height: 100%;
            transition: all 0.3s;
            position: relative;
        }
        
        .package-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border-color: var(--primary-blue);
        }
        
        .package-card.popular {
            border-color: var(--primary-blue);
            box-shadow: 0 10px 30px rgba(236, 72, 153, 0.2);
        }
        
        /* FAQ Section */
        .faq {
            padding: 80px 0;
            background: #f8fafc;
        }
        
        .accordion-item {
            border: 1px solid #e5e7eb;
            border-radius: 8px !important;
            margin-bottom: 1rem;
        }
        
        .accordion-button {
            font-weight: 600;
            color: #1e293b;
        }
        
        .accordion-button:not(.collapsed) {
            background: #d1fae5;
            color: var(--primary-blue);
        }
        
        /* Footer */
        .footer {
            background: #1e293b;
            color: white;
            padding: 60px 0 30px;
        }
        
        .footer h5 {
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.1rem;
        }
        
        .footer .logo-text {
            font-size: 1.5rem;
        }
        
        .footer a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: color 0.3s;
            display: block;
            margin-bottom: 0.75rem;
        }
        
        .footer a:hover {
            color: white;
        }
        
        .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 2rem;
            margin-top: 2rem;
            text-align: center;
            color: rgba(255,255,255,0.5);
        }

        .payment-methods-mini {
            margin-top: 1rem;
        }

        .payment-methods-mini-title {
            margin: 0 0 0.5rem;
            color: rgba(255,255,255,0.8);
            font-size: 0.78rem;
            font-weight: 600;
            letter-spacing: 0.2px;
            display: inline-flex;
            align-items: center;
            gap: 0.35rem;
        }

        .payment-logos {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            flex-wrap: wrap;
            gap: 0.4rem;
        }

        .payment-logo-item {
            height: 22px;
            width: auto;
            max-width: 72px;
            object-fit: contain;
            background: #1e293b;
            border-radius: 6px;
            padding: 2px 6px;
        }
        
        /* ========== MOBILE RESPONSIVE ========== */
        
        /* Tablet */
        @media (max-width: 991px) {
            .hero {
                padding: 60px 0 40px;
            }
            
            .hero h1 {
                font-size: 2.5rem;
            }
            
            .hero .col-lg-6:last-child {
                display: block;
                margin-bottom: 2rem;
            }
            
            .browser-mockup {
                max-width: 100%;
            }
            
            .features, .salons, .packages, .faq {
                padding: 60px 0;
            }
            
            .section-title {
                font-size: 2rem;
            }
            
            .section-subtitle {
                font-size: 1rem;
                margin-bottom: 2rem;
            }
        }
        
        /* Download Apps Section */
        .download-apps {
            padding: 60px 0;
        }
        
        .download-card {
            transition: all 0.3s ease;
        }
        
        .download-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15) !important;
        }
        
        .download-icon {
            transition: all 0.3s ease;
        }
        
        .download-card:hover .download-icon {
            transform: scale(1.1) rotate(5deg);
        }
        
        /* Mobile */
        @media (max-width: 768px) {
            /* Top Promo Banner - Mobilde gizle */
            .top-promo-banner {
                display: none !important;
            }
            
            /* Navbar - Modern Mobile */
            .navbar {
                padding: 0.75rem 0;
                box-shadow: 0 2px 20px rgba(236, 72, 153, 0.1);
            }
            
            .navbar-brand {
                font-size: 1.5rem;
            }
            
            .logo-text {
                font-size: 28px !important;
                letter-spacing: 1.5px !important;
                padding: 4px 12px !important;
            }
            
            .navbar .d-flex {
                flex-direction: column;
                width: 100%;
                gap: 0.75rem !important;
                padding: 1rem 0;
            }
            
            .navbar-phone {
                margin: 0;
                text-align: center;
                font-size: 0.85rem;
            }
            
            .navbar .btn {
                width: 100%;
                margin-right: 0 !important;
                padding: 0.6rem 1.25rem;
                font-size: 0.9rem;
                border-radius: 10px;
            }
            
            .navbar .btn-primary {
                background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
                border: none;
            }
            
            /* Hero - Modern Mobile */
            .hero {
                padding: 50px 0 40px;
                text-align: center;
                background: linear-gradient(135deg, #be185d 0%, #ec4899 50%, #f472b6 100%);
                position: relative;
                overflow: hidden;
            }
            
            .hero::before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: radial-gradient(circle at 30% 50%, rgba(255,255,255,0.1) 0%, transparent 50%);
                pointer-events: none;
            }
            
            .hero h1 {
                font-size: 2rem;
                line-height: 1.3;
                font-weight: 900;
                margin-bottom: 1.25rem;
                text-shadow: 0 2px 10px rgba(0,0,0,0.1);
            }
            
            .hero p {
                font-size: 1rem;
                line-height: 1.6;
                margin-bottom: 2rem;
                opacity: 0.95;
            }
            
            .hero-buttons {
                display: flex;
                flex-direction: column;
                gap: 0.75rem;
                width: 100%;
                max-width: 400px;
                margin: 0 auto;
            }
            
            .hero-buttons .btn {
                width: 100%;
                margin-right: 0;
                padding: 0.875rem 1.5rem;
                font-size: 1rem;
                font-weight: 600;
                border-radius: 12px;
                box-shadow: 0 4px 15px rgba(0,0,0,0.15);
                transition: all 0.3s ease;
            }
            
            .hero-buttons .btn:active {
                transform: scale(0.98);
            }
            
            /* References / Cities */
            .reference-title {
                font-size: 12px;
                margin-bottom: 1.5rem;
            }
            
            .city-item {
                min-width: 100px;
                height: 45px;
                font-size: 12px;
                padding: 0 12px;
            }
            
            .cities-container::before,
            .cities-container::after {
                width: 30px;
            }
            
            /* Download Apps Section */
            .download-apps {
                padding: 40px 0;
            }
            
            .download-apps .section-title {
                font-size: 1.75rem !important;
            }
            
            .download-apps .section-subtitle {
                font-size: 0.95rem !important;
            }
            
            .download-card {
                margin-bottom: 20px;
                padding: 1.5rem !important;
            }
            
            .download-icon {
                width: 60px !important;
                height: 60px !important;
                font-size: 30px !important;
            }
            
            .download-card h3 {
                font-size: 1.25rem !important;
            }
            
            /* Sections */
            .features, .solutions, .packages, .faq {
                padding: 40px 0;
            }
            
            .section-title {
                font-size: 1.5rem;
                line-height: 1.3;
            }
            
            .section-subtitle {
                font-size: 0.9rem;
                margin-bottom: 1.5rem;
                padding: 0 10px;
            }
            
            /* Feature Cards */
            .feature-card {
                padding: 1.5rem;
                margin-bottom: 1rem;
            }
            
            .feature-icon {
                width: 50px;
                height: 50px;
                font-size: 1.25rem;
                margin-bottom: 1rem;
            }
            
            .feature-card h3 {
                font-size: 1.1rem;
            }
            
            .feature-card p {
                font-size: 0.9rem;
            }
            
            /* Salon Cards */
            .salon-card-home {
                margin-bottom: 1.5rem;
            }
            
            .salon-card-home .card-body {
                padding: 1.25rem;
            }
            
            .salon-card-home h5 {
                font-size: 1.1rem;
            }
            
            /* Package Cards */
            .package-card {
                padding: 1.5rem;
            }
            
            .package-card h3 {
                font-size: 1.25rem !important;
            }
            
            /* FAQ */
            .accordion-button {
                font-size: 0.95rem;
                padding: 1rem;
            }
            
            .accordion-body {
                font-size: 0.9rem;
            }
            
            /* Footer */
            .footer {
                padding: 40px 0 20px;
            }
            
            .footer .col-md-3 {
                text-align: center;
                margin-bottom: 2rem;
            }
            
            .footer h5 {
                font-size: 1rem;
                margin-bottom: 1rem;
            }
            
            .footer a {
                font-size: 0.9rem;
            }
            
            /* Modals */
            .modal-dialog {
                margin: 10px;
            }
            
            .modal-content {
                border-radius: 16px !important;
            }
            
            .modal-header {
                padding: 1.5rem 1.5rem 0.5rem !important;
            }
            
            .modal-body {
                padding: 0 1.5rem 1.5rem !important;
            }
            
            .modal-title {
                font-size: 1.25rem !important;
            }
        }
        
        /* Small Mobile - Extra Small Devices */
        @media (max-width: 480px) {
            .hero {
                padding: 40px 0 30px;
            }
            
            .hero h1 {
                font-size: 1.75rem;
                line-height: 1.25;
            }
            
            .hero p {
                font-size: 0.95rem;
            }
            
            .section-title {
                font-size: 1.5rem;
            }
            
            .section-subtitle {
                font-size: 0.9rem;
                padding: 0 10px;
            }
            
            .feature-card, .solution-card {
                padding: 1.5rem;
                margin-bottom: 1rem;
            }
            
            .package-card {
                padding: 1.75rem 1.5rem;
            }
            
            .feature-icon {
                width: 50px;
                height: 50px;
                font-size: 1.25rem;
            }
            
            .btn {
                padding: 0.75rem 1.25rem;
                font-size: 0.95rem;
            }
            
            .hero-buttons {
                max-width: 100%;
            }
            
            .navbar-brand {
                font-size: 1.25rem;
            }
            
            .logo-text {
                font-size: 24px !important;
            }
        }
        
        /* Extra Extra Small Mobile */
        @media (max-width: 360px) {
            .hero h1 {
                font-size: 1.5rem;
            }
            
            .section-title {
                font-size: 1.35rem;
            }
            
            .feature-card, .solution-card, .package-card {
                padding: 1.25rem;
            }
        }
        
        /* ========================================
           MOBILE PERFORMANCE OPTIMIZATIONS
           ======================================== */
        @media (max-width: 768px) {
            * {
                will-change: auto !important;
            }
            
            [style*="backdrop-filter"], *[class*="backdrop"] {
                backdrop-filter: none !important;
                -webkit-backdrop-filter: none !important;
            }
            
            *:hover {
                transform: none !important;
            }
            
            * {
                box-shadow: none !important;
            }
            
            .card, .modal-content, .feature-card, .solution-card {
                box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important;
            }
            
            * {
                transition-duration: 0.15s !important;
            }
            
            button, a, .btn, input, select, textarea {
                -webkit-tap-highlight-color: rgba(236, 72, 153, 0.2);
                touch-action: manipulation;
            }
            
            .hero {
                background-attachment: scroll !important;
            }
        }
    </style>
</head>
<body>
    <!-- Top Promo Banner -->
    <div class="top-promo-banner">
        <div class="container">
            <div class="d-flex align-items-center justify-content-center flex-wrap gap-2">
                <strong>Salon Randevu Yönetim Sisteminde Özel Fırsat! %50'ye Varan İndirim!</strong>
                <span>•</span>
                <strong>Hemen Başla, 6 Ay Ücretsiz Deneme!</strong>
                <span>•</span>
                <button type="button" class="btn-link text-white text-decoration-none border-0 bg-transparent p-0" data-bs-toggle="modal" data-bs-target="#registerModal" style="cursor: pointer;">Ücretsiz Deneme + Kurulum Desteği!</button>
            </div>
        </div>
    </div>
    
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg">
        <div class="container">
            <a class="navbar-brand" href="{{ route('home') }}" style="display: flex; align-items: center;">
                <img src="{{ asset('salonayheaderlogo.png') }}" alt="Salonay" class="logo-image" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-block';">
                <span class="logo-text" style="display: none;">Salonay</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#ozellikler">Özellikler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('public.salons.index') }}">Salonlar</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#paketler">Paketler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#musteri-yorumlari">Yorumlar</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#indirmeler">İndirmeler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#iletisim">İletişim</a>
                    </li>
                </ul>
                <div class="d-flex align-items-center gap-2">
                    <span class="navbar-phone">
                        <i class="bi bi-telephone"></i> {{ $phone }}
                    </span>
                    @auth
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-primary">
                            Panel
                        </a>
                    @else
                        <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#loginModal">
                            <i class="bi bi-box-arrow-in-right"></i> Giriş Yap
                        </button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#registerModal">
                            <i class="bi bi-person-plus"></i> Ücretsiz Deneyin
                        </button>
                    @endauth
                </div>
            </div>
        </div>
    </nav>
    
    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 order-lg-1 order-1">
                    <h1>Türkiye'nin En Gelişmiş Güzellik uzmanı ve Güzellik uzmanı Randevu Sistemi</h1>
                    <p>Randevularınızı kolayca yönetin, müşterilerinizi takip edin ve işletmenizi büyütün. Modern ve kullanıcı dostu arayüz ile her şey tek panelde.</p>
                    <div class="hero-buttons">
                        @auth
                            <a href="{{ route('admin.dashboard') }}" class="btn btn-light">
                                <i class="bi bi-speedometer2"></i> Panele Git
                            </a>
                        @else
                            <button type="button" class="btn btn-light" data-bs-toggle="modal" data-bs-target="#registerModal">
                                <i class="bi bi-rocket-takeoff"></i> Hemen Başla
                            </button>
                        @endauth
                        <a href="#ozellikler" class="btn btn-outline-light">
                            <i class="bi bi-list-check"></i> Tüm Özellikler
                        </a>
                        <a href="https://www.youtube.com/watch?v=RNduAYBD8Zw" target="_blank" class="btn btn-outline-light">
                            <i class="bi bi-play-circle"></i> Tanıtım Videosu
                        </a>
                    </div>
                </div>
                <div class="col-lg-6 text-center order-lg-2 order-2 mb-4 mb-lg-0">
                    <!-- Browser Window Mockup -->
                    <div class="browser-mockup" style="max-width: 100%; margin: 0 auto;">
                        <!-- Browser Header -->
                        <div class="browser-header" style="background: #e5e7eb; border-radius: 8px 8px 0 0; padding: 8px 12px; display: flex; align-items: center; gap: 8px; border-bottom: 1px solid #d1d5db;">
                            <!-- Browser Controls -->
                            <div class="browser-controls" style="display: flex; gap: 6px;">
                                <div class="browser-btn" style="width: 12px; height: 12px; border-radius: 50%; background: #ef4444; cursor: default;"></div>
                                <div class="browser-btn" style="width: 12px; height: 12px; border-radius: 50%; background: #f59e0b; cursor: default;"></div>
                                <div class="browser-btn" style="width: 12px; height: 12px; border-radius: 50%; background: #10b981; cursor: default;"></div>
                            </div>
                            <!-- Address Bar -->
                            <div class="browser-address-bar" style="flex: 1; background: white; border-radius: 4px; padding: 6px 12px; font-size: 12px; color: #6b7280; display: flex; align-items: center; gap: 8px;">
                                <i class="bi bi-lock-fill" style="color: #10b981; font-size: 10px;"></i>
                                <span>salonay.com/salonlar</span>
                            </div>
                        </div>
                        <!-- Browser Content -->
                        <div class="browser-content" style="background: white; border-radius: 0 0 8px 8px; padding: 24px; box-shadow: 0 10px 40px rgba(0,0,0,0.15); min-height: 400px;">
                            <!-- Search Section -->
                            <div class="salon-search-section">
                                <h3 style="font-size: 1.25rem; font-weight: 700; color: #1e293b; margin-bottom: 20px; text-align: center;">Salon Ara</h3>
                                
                                <div class="row g-3 mb-4">
                                    <div class="col-md-6">
                                        <label style="font-size: 0.875rem; font-weight: 600; color: #475569; margin-bottom: 6px; display: block;">İl Seçin</label>
                                        <select id="salonCitySelect" class="form-select" style="border-radius: 8px; border: 2px solid #e2e8f0; padding: 10px; font-size: 0.9rem;">
                                            <option value="">İl Seçin</option>
                                            @php
                                                $cities = [
                                                    'Adana', 'Adıyaman', 'Afyonkarahisar', 'Ağrı', 'Aksaray', 'Amasya', 'Ankara', 'Antalya',
                                                    'Ardahan', 'Artvin', 'Aydın', 'Balıkesir', 'Bartın', 'Batman', 'Bayburt', 'Bilecik',
                                                    'Bingöl', 'Bitlis', 'Bolu', 'Burdur', 'Bursa', 'Çanakkale', 'Çankırı', 'Çorum',
                                                    'Denizli', 'Diyarbakır', 'Düzce', 'Edirne', 'Elazığ', 'Erzincan', 'Erzurum', 'Eskişehir',
                                                    'Gaziantep', 'Giresun', 'Gümüşhane', 'Hakkari', 'Hatay', 'Iğdır', 'Isparta', 'İstanbul',
                                                    'İzmir', 'Kahramanmaraş', 'Karabük', 'Karaman', 'Kars', 'Kastamonu', 'Kayseri', 'Kilis',
                                                    'Kırıkkale', 'Kırklareli', 'Kırşehir', 'Kocaeli', 'Konya', 'Kütahya', 'Malatya', 'Manisa',
                                                    'Mardin', 'Mersin', 'Muğla', 'Muş', 'Nevşehir', 'Niğde', 'Ordu', 'Osmaniye',
                                                    'Rize', 'Sakarya', 'Samsun', 'Siirt', 'Sinop', 'Sivas', 'Şanlıurfa', 'Şırnak',
                                                    'Tekirdağ', 'Tokat', 'Trabzon', 'Tunceli', 'Uşak', 'Van', 'Yalova', 'Yozgat', 'Zonguldak'
                                                ];
                                            @endphp
                                            @foreach($cities as $city)
                                                <option value="{{ $city }}">{{ $city }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label style="font-size: 0.875rem; font-weight: 600; color: #475569; margin-bottom: 6px; display: block;">İlçe Seçin</label>
                                        <select id="salonDistrictSelect" class="form-select" style="border-radius: 8px; border: 2px solid #e2e8f0; padding: 10px; font-size: 0.9rem;" disabled>
                                            <option value="">Önce il seçin</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <button type="button" id="searchSalonsBtn" class="btn w-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border: none; border-radius: 8px; padding: 12px; font-weight: 700; font-size: 1rem;">
                                    <i class="bi bi-search me-2"></i>Salon Ara
                                </button>
                                
                                <!-- Results -->
                                <div id="salonSearchResults" style="margin-top: 24px; display: none;">
                                    <h4 style="font-size: 1.1rem; font-weight: 700; color: #1e293b; margin-bottom: 16px;">Bulunan Salonlar</h4>
                                    <div id="salonResultsList" style="max-height: 300px; overflow-y: auto;">
                                        <!-- Results will be populated here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- References Section - 81 İl -->
    <section id="referanslar" class="references order-lg-3 order-3" style="padding: 60px 0; background: white; border-top: 1px solid #e5e7eb; border-bottom: 1px solid #e5e7eb;">
        <div class="container">
            <div class="reference-title" style="text-align: center; font-size: 2rem; font-weight: 700; margin-bottom: 3rem; color: #1e293b;">Türkiye'nin 81 İlinde Hizmet Veriyoruz</div>
            <div class="cities-container">
                <div class="cities-slider">
                    @php
                        $cities = [
                            'Adana', 'Adıyaman', 'Afyonkarahisar', 'Ağrı', 'Aksaray', 'Amasya', 'Ankara', 'Antalya',
                            'Ardahan', 'Artvin', 'Aydın', 'Balıkesir', 'Bartın', 'Batman', 'Bayburt', 'Bilecik',
                            'Bingöl', 'Bitlis', 'Bolu', 'Burdur', 'Bursa', 'Çanakkale', 'Çankırı', 'Çorum',
                            'Denizli', 'Diyarbakır', 'Düzce', 'Edirne', 'Elazığ', 'Erzincan', 'Erzurum', 'Eskişehir',
                            'Gaziantep', 'Giresun', 'Gümüşhane', 'Hakkari', 'Hatay', 'Iğdır', 'Isparta', 'İstanbul',
                            'İzmir', 'Kahramanmaraş', 'Karabük', 'Karaman', 'Kars', 'Kastamonu', 'Kayseri', 'Kilis',
                            'Kırıkkale', 'Kırklareli', 'Kırşehir', 'Kocaeli', 'Konya', 'Kütahya', 'Malatya', 'Manisa',
                            'Mardin', 'Mersin', 'Muğla', 'Muş', 'Nevşehir', 'Niğde', 'Ordu', 'Osmaniye',
                            'Rize', 'Sakarya', 'Samsun', 'Siirt', 'Sinop', 'Sivas', 'Şanlıurfa', 'Şırnak',
                            'Tekirdağ', 'Tokat', 'Trabzon', 'Tunceli', 'Uşak', 'Van', 'Yalova', 'Yozgat', 'Zonguldak'
                        ];
                    @endphp
                    <!-- İlk set -->
                    <div class="cities-slider-wrapper">
                        @foreach($cities as $city)
                            <div class="city-item">{{ $city }}</div>
                        @endforeach
                    </div>
                    <!-- İkinci set (sonsuz döngü için) -->
                    <div class="cities-slider-wrapper">
                        @foreach($cities as $city)
                            <div class="city-item">{{ $city }}</div>
                        @endforeach
                    </div>
                </div>
            </div>
            
            <!-- YouTube Video Embed -->
            <div class="row justify-content-center mt-5">
                <div class="col-lg-10 col-xl-8">
                    <div class="video-container" style="position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; border-radius: 16px; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
                        <iframe 
                            style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: 0;"
                            src="https://www.youtube-nocookie.com/embed/RNduAYBD8Zw?rel=0&modestbranding=1" 
                            title="Salonay Tanıtım Videosu" 
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                            allowfullscreen
                            loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Statistics Section -->
    <section class="statistics-section py-5" style="background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);">
        <div class="container">
            <div class="row g-4 text-center">
                <div class="col-6 col-md-3">
                    <div class="stat-item">
                        <div class="stat-icon" style="width: 60px; height: 60px; margin: 0 auto 1rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px;">
                            <i class="bi bi-people-fill"></i>
                        </div>
                        <div class="stat-number" style="font-size: 1.5rem; font-weight: 900; color: #1e293b; margin-bottom: 0.5rem;">2,500+</div>
                        <div class="stat-label" style="color: #64748b; font-weight: 600; font-size: 0.9rem;">Mutlu Müşteri</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stat-item">
                        <div class="stat-icon" style="width: 60px; height: 60px; margin: 0 auto 1rem; background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px;">
                            <i class="bi bi-calendar-check-fill"></i>
                        </div>
                        <div class="stat-number" style="font-size: 1.5rem; font-weight: 900; color: #1e293b; margin-bottom: 0.5rem;">150,000+</div>
                        <div class="stat-label" style="color: #64748b; font-weight: 600; font-size: 0.9rem;">Randevu</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stat-item">
                        <div class="stat-icon" style="width: 60px; height: 60px; margin: 0 auto 1rem; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px;">
                            <i class="bi bi-building-fill"></i>
                        </div>
                        <div class="stat-number" style="font-size: 1.5rem; font-weight: 900; color: #1e293b; margin-bottom: 0.5rem;">500+</div>
                        <div class="stat-label" style="color: #64748b; font-weight: 600; font-size: 0.9rem;">İşletme</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stat-item">
                        <div class="stat-icon" style="width: 60px; height: 60px; margin: 0 auto 1rem; background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px;">
                            <i class="bi bi-star-fill"></i>
                        </div>
                        <div class="stat-number" style="font-size: 1.5rem; font-weight: 900; color: #1e293b; margin-bottom: 0.5rem;">4.9/5</div>
                        <div class="stat-label" style="color: #64748b; font-weight: 600; font-size: 0.9rem;">Müşteri Puanı</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Features Section -->
    <section id="ozellikler" class="features">
        <div class="container">
            <h2 class="section-title">Küçük İşletmelerden Büyük Organizasyonlara<br>Randevu Yönetiminde Mükemmellik</h2>
            <p class="section-subtitle">Güzellik salonu ve güzellik salonu randevularınızı profesyonelce yönetin ve işletmenizi büyütün</p>
            
            <div class="row g-4 mt-4">
                <!-- Temel Yönetim Özellikleri -->
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-calendar3"></i>
                        </div>
                        <h3>Randevu Yönetimi</h3>
                        <p>Kolay ve hızlı randevu oluşturma, düzenleme ve takip sistemi ile tüm randevularınızı tek yerden yönetin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-calendar-heart"></i>
                        </div>
                        <h3>Takvim Görünümü</h3>
                        <p>Görsel takvim arayüzü ile randevularınızı görsel olarak görüntüleyin ve planlamanızı kolaylaştırın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-people"></i>
                        </div>
                        <h3>Müşteri Yönetimi</h3>
                        <p>Müşteri bilgilerini kaydedin, geçmiş randevularını görüntüleyin ve müşteri ilişkilerinizi güçlendirin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-building"></i>
                        </div>
                        <h3>Salon Yönetimi</h3>
                        <p>Çoklu salon desteği ile tüm güzellik salonlarınızı tek panelden yönetin, kapasite ve özelliklerini tanımlayın.</p>
                    </div>
                </div>
                
                <!-- Finansal Özellikler -->
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-cash-coin"></i>
                        </div>
                        <h3>Muhasebe Modülü</h3>
                        <p>Gelir ve gider takibi, kasa yönetimi ve detaylı finansal raporlarla işletmenizin mali durumunu takip edin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-wallet2"></i>
                        </div>
                        <h3>Kasa Yönetimi</h3>
                        <p>Günlük, haftalık ve aylık kasa takibi, gelir-gider kayıtları ve nakit akış yönetimi özellikleri.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-receipt"></i>
                        </div>
                        <h3>Fatura Yönetimi</h3>
                        <p>Otomatik fatura oluşturma, PDF indirme ve e-posta/SMS ile gönderme özellikleri ile fatura süreçlerinizi hızlandırın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-credit-card"></i>
                        </div>
                        <h3>Ödeme Takibi</h3>
                        <p>Kapora ve kalan ödeme takibi, ödeme planları ve otomatik hatırlatmalar ile nakit akışınızı kontrol edin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-file-earmark-text"></i>
                        </div>
                        <h3>Sözleşme Yönetimi</h3>
                        <p>Otomatik sözleşme oluşturma ve dijital imza ile sözleşme süreçlerinizi dijitalleştirin.</p>
                    </div>
                </div>
                
                <!-- Raporlama ve Analiz -->
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-graph-up"></i>
                        </div>
                        <h3>Raporlama</h3>
                        <p>Aylık, haftalık ve günlük randevu ve gelir raporları ile işletmenizin performansını analiz edin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-bar-chart"></i>
                        </div>
                        <h3>Detaylı Analiz</h3>
                        <p>Gelir-gider analizleri, müşteri istatistikleri, randevu doluluk oranları ve performans metrikleri ile kararlarınızı veriye dayandırın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-pie-chart"></i>
                        </div>
                        <h3>Görsel Raporlar</h3>
                        <p>Grafik ve çizelgeler ile raporlarınızı görselleştirin, trend analizleri yapın ve iş performansınızı ölçün.</p>
                    </div>
                </div>
                
                <!-- İletişim Özellikleri -->
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-bell"></i>
                        </div>
                        <h3>SMS & E-posta</h3>
                        <p>Müşterilerinize otomatik SMS ve e-posta bildirimleri göndererek randevu hatırlatmaları yapın ve iletişiminizi güçlendirin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-whatsapp"></i>
                        </div>
                        <h3>WhatsApp Entegrasyonu</h3>
                        <p>Randevu onaylarını ve bilgilendirmelerini WhatsApp üzerinden otomatik gönderin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-chat-dots"></i>
                        </div>
                        <h3>Otomatik Hatırlatmalar</h3>
                        <p>Randevu öncesi ve sonrası otomatik hatırlatma mesajları ile müşteri memnuniyetini artırın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-envelope-paper"></i>
                        </div>
                        <h3>Toplu SMS Kampanyaları</h3>
                        <p>Müşterilerinize özel günlerde ve kampanyalarda toplu SMS göndererek pazarlama faaliyetlerinizi güçlendirin.</p>
                    </div>
                </div>
                
                <!-- Hizmet Yönetimi -->
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-menu-button"></i>
                        </div>
                        <h3>Hizmet Yönetimi</h3>
                        <p>Saç kesimi, boyama, makyaj, cilt bakımı gibi hizmetlerinizi oluşturun, fiyatlandırın ve randevulara otomatik ekleyin. Hizmet seçeneklerini kolayca yönetin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-plus-circle"></i>
                        </div>
                        <h3>Ekstra Hizmetler</h3>
                        <p>Kaş alımı, kirpik lamination, manikür, pedikür gibi ekstra hizmetleri tanımlayın ve randevulara ekleyerek gelir artırın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-gear"></i>
                        </div>
                        <h3>İşlem Yönetimi</h3>
                        <p>Randevu işlemlerini kategorize edin, fiyatlandırın ve takip edin. İşlem geçmişini kayıt altına alın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-briefcase"></i>
                        </div>
                        <h3>Servis Yönetimi</h3>
                        <p>Sunulan hizmetleri tanımlayın, fiyatlandırın ve randevulara göre hizmet yönetimi yapın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-calendar-event"></i>
                        </div>
                        <h3>Randevu Planlama</h3>
                        <p>Müşteri randevularını yönetin, personel müsaitlik durumlarını takip edin ve planlamalarınızı koordine edin.</p>
                    </div>
                </div>
                
                <!-- İş Ortakları ve İletişim -->
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <h3>Personel Yönetimi</h3>
                        <p>Güzellik uzmanı, makyajcı, cilt bakım uzmanı gibi personellerinizi kaydedin ve randevulara atayın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-building-fill"></i>
                        </div>
                        <h3>Müşteri Portföyü</h3>
                        <p>Düzenli müşterilerinizi ve tercihlerini yönetin, geçmiş randevularını takip edin ve sadakat programları oluşturun.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-megaphone"></i>
                        </div>
                        <h3>Kampanya Yönetimi</h3>
                        <p>Özel günler ve kampanyalar oluşturun, müşterilerinize özel teklifler sunun ve satışlarınızı artırın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-gift"></i>
                        </div>
                        <h3>Referans Sistemi</h3>
                        <p>Müşterilerinize referans kodları verin, yeni müşteri kazandırdıklarında ödüllendirin.</p>
                    </div>
                </div>
                
                <!-- Teknik Özellikler -->
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-phone"></i>
                        </div>
                        <h3>Mobil Uyumlu</h3>
                        <p>Tüm cihazlardan erişilebilen responsive tasarım ile her yerden yönetim yapın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-cloud"></i>
                        </div>
                        <h3>Bulut Depolama</h3>
                        <p>Verileriniz güvenli bulut sunucularda saklanır, yedeklenir ve her zaman erişilebilir.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-shield-check"></i>
                        </div>
                        <h3>Güvenli Sistem</h3>
                        <p>Kullanıcı yetkilendirme sistemi ve aktivite logları ile güvenli bir yönetim deneyimi sunuyoruz.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-search"></i>
                        </div>
                        <h3>Gelişmiş Arama</h3>
                        <p>Randevu, müşteri ve fatura arama sistemleri ile hızlıca aradığınızı bulun.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-speedometer2"></i>
                        </div>
                        <h3>Hızlı Erişim</h3>
                        <p>Dashboard üzerinden sık kullanılan özelliklere tek tıkla erişin, işlerinizi hızlandırın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-grid"></i>
                        </div>
                        <h3>Widget Sistemi</h3>
                        <p>Özelleştirilebilir dashboard widget'ları ile çalışma alanınızı ihtiyaçlarınıza göre düzenleyin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-file-earmark-check"></i>
                        </div>
                        <h3>Teklif Yönetimi</h3>
                        <p>Müşterilerinize özel teklifler hazırlayın, gönderin ve takip edin. Teklif onay süreçlerini yönetin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-chat-left-text"></i>
                        </div>
                        <h3>Mesajlaşma Sistemi</h3>
                        <p>Randevu bazlı mesajlaşma ile müşterilerinizle iletişim kurun, notlar ekleyin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-clock-history"></i>
                        </div>
                        <h3>Zaman Çizelgesi</h3>
                        <p>Randevu geçmişi ve aktivite logları ile tüm işlemleri zaman çizelgesinde görüntüleyin.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-download"></i>
                        </div>
                        <h3>Veri Dışa Aktarma</h3>
                        <p>Raporları ve verileri Excel, PDF formatlarında dışa aktarın, yedek alın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-person-check"></i>
                        </div>
                        <h3>Kullanıcı Yetkilendirme</h3>
                        <p>Farklı kullanıcı rolleri oluşturun, yetkileri özelleştirin ve güvenli bir çalışma ortamı sağlayın.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-headset"></i>
                        </div>
                        <h3>7/24 Destek</h3>
                        <p>Profesyonel destek ekibimiz her zaman yanınızda. Sorularınız için 7/24 destek alabilirsiniz.</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="bi bi-book"></i>
                        </div>
                        <h3>Kullanım Kılavuzu</h3>
                        <p>Detaylı dokümantasyon ve video eğitimler ile sistemin tüm özelliklerini öğrenin.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Download Apps Section -->
    <section id="indirmeler" class="download-apps py-5" style="background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); scroll-margin-top: 80px;">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title" style="font-size: 2.5rem; font-weight: 800; margin-bottom: 1rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                    Uygulamalarımızı İndirin
                </h2>
                <p class="section-subtitle" style="font-size: 1.1rem; color: #64748b; max-width: 600px; margin: 0 auto;">
                    Salonay'u her yerden kullanın. Mobil ve masaüstü uygulamalarımızla randevularınızı kolayca yönetin.
                </p>
            </div>
            
            <div class="row justify-content-center g-4">
                <!-- Windows App -->
                <div class="col-lg-4 col-md-6">
                    <div class="download-card" style="background: white; border-radius: 20px; padding: 2.5rem; text-align: center; box-shadow: 0 10px 40px rgba(0,0,0,0.1); transition: all 0.3s ease; height: 100%;">
                        <div class="download-icon" style="width: 80px; height: 80px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 40px; color: white; box-shadow: 0 8px 24px rgba(236, 72, 153, 0.3);">
                            <i class="bi bi-windows"></i>
                        </div>
                        <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 0.5rem; color: #1e293b;">Windows Uygulaması</h3>
                        <p style="color: #64748b; margin-bottom: 1.5rem;">Masaüstü bilgisayarınız için</p>
                        @php
                            $windowsUrl = \App\Models\Setting::where('group', 'apps')->where('key', 'windows_download_url')->value('value');
                            if ($windowsUrl && $windowsUrl !== '') {
                                $windowsSetupUrl = $windowsUrl;
                            } else {
                                $windowsSetupUrl = route('download.windows');
                            }
                        @endphp
                        @if($windowsUrl && $windowsUrl !== '')
                            <a href="{{ $windowsSetupUrl }}" target="_blank" class="btn btn-primary btn-lg w-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; padding: 0.75rem 1.5rem; border-radius: 12px; font-weight: 600;">
                                <i class="bi bi-download me-2"></i>İndir
                            </a>
                        @else
                            <a href="{{ $windowsSetupUrl }}" class="btn btn-primary btn-lg w-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; padding: 0.75rem 1.5rem; border-radius: 12px; font-weight: 600;">
                                <i class="bi bi-download me-2"></i>İndir
                            </a>
                        @endif
                    </div>
                </div>
                
                <!-- Android App -->
                <div class="col-lg-4 col-md-6">
                    <div class="download-card" style="background: white; border-radius: 20px; padding: 2.5rem; text-align: center; box-shadow: 0 10px 40px rgba(0,0,0,0.1); transition: all 0.3s ease; height: 100%;">
                        <div class="download-icon" style="width: 80px; height: 80px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 40px; color: white; box-shadow: 0 8px 24px rgba(236, 72, 153, 0.3);">
                            <i class="bi bi-android2"></i>
                        </div>
                        <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 0.5rem; color: #1e293b;">Android Uygulaması</h3>
                        <p style="color: #64748b; margin-bottom: 1.5rem;">Android cihazlarınız için</p>
                        @php
                            $androidUrl = \App\Models\Setting::where('group', 'apps')->where('key', 'android_download_url')->value('value') ?? '#';
                        @endphp
                        @if($androidUrl && $androidUrl !== '#')
                            <a href="{{ $androidUrl }}" target="_blank" class="btn btn-success btn-lg w-100" style="background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); border: none; padding: 0.75rem 1.5rem; border-radius: 12px; font-weight: 600;">
                                <i class="bi bi-download me-2"></i>İndir
                            </a>
                        @else
                            <button class="btn btn-secondary btn-lg w-100" disabled style="padding: 0.75rem 1.5rem; border-radius: 12px; font-weight: 600;">
                                <i class="bi bi-clock me-2"></i>Yakında
                            </button>
                        @endif
                    </div>
                </div>
                
                <!-- iOS App -->
                <div class="col-lg-4 col-md-6">
                    <div class="download-card" style="background: white; border-radius: 20px; padding: 2.5rem; text-align: center; box-shadow: 0 10px 40px rgba(0,0,0,0.1); transition: all 0.3s ease; height: 100%;">
                        <div class="download-icon" style="width: 80px; height: 80px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #1e293b 0%, #475569 100%); border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 40px; color: white; box-shadow: 0 8px 24px rgba(30, 41, 59, 0.3);">
                            <i class="bi bi-apple"></i>
                        </div>
                        <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 0.5rem; color: #1e293b;">iOS Uygulaması</h3>
                        <p style="color: #64748b; margin-bottom: 1.5rem;">iPhone ve iPad için</p>
                        @php
                            $iosUrl = \App\Models\Setting::where('group', 'apps')->where('key', 'ios_download_url')->value('value') ?? '#';
                        @endphp
                        @if($iosUrl && $iosUrl !== '#')
                            <a href="{{ $iosUrl }}" target="_blank" class="btn btn-dark btn-lg w-100" style="background: linear-gradient(135deg, #1e293b 0%, #475569 100%); border: none; padding: 0.75rem 1.5rem; border-radius: 12px; font-weight: 600;">
                                <i class="bi bi-download me-2"></i>İndir
                            </a>
                        @else
                            <button class="btn btn-secondary btn-lg w-100" disabled style="padding: 0.75rem 1.5rem; border-radius: 12px; font-weight: 600;">
                                <i class="bi bi-clock me-2"></i>Yakında
                            </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- How It Works Section -->
    <section class="how-it-works py-5" style="background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title" style="font-size: 2.5rem; font-weight: 800; margin-bottom: 1rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                    Nasıl Çalışır?
                </h2>
                <p class="section-subtitle" style="font-size: 1.1rem; color: #64748b; max-width: 600px; margin: 0 auto;">
                    3 basit adımda randevu yönetimine başlayın
                </p>
            </div>
            
            <div class="row g-4 mt-4">
                <div class="col-md-4">
                    <div class="step-card" style="background: white; border-radius: 20px; padding: 2rem; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                        <div class="step-number" style="width: 80px; height: 80px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 2rem; font-weight: 900;">1</div>
                        <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1rem; color: #1e293b;">Hesap Oluştur</h3>
                        <p style="color: #64748b; line-height: 1.6;">Ücretsiz hesabınızı oluşturun ve güzellik salonu bilgilerinizi ekleyin. Kurulum sadece 5 dakika sürer.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="step-card" style="background: white; border-radius: 20px; padding: 2rem; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                        <div class="step-number" style="width: 80px; height: 80px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 2rem; font-weight: 900;">2</div>
                        <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1rem; color: #1e293b;">Randevu Al</h3>
                        <p style="color: #64748b; line-height: 1.6;">Müşterilerinizden randevu alın, takvimden görüntüleyin ve otomatik bildirimler gönderin.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="step-card" style="background: white; border-radius: 20px; padding: 2rem; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                        <div class="step-number" style="width: 80px; height: 80px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 2rem; font-weight: 900;">3</div>
                        <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1rem; color: #1e293b;">Büyütün</h3>
                        <p style="color: #64748b; line-height: 1.6;">Raporları inceleyin, müşteri memnuniyetini artırın ve işletmenizi büyütün.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Salons Section -->
    <section id="salonlar" class="salons">
        <div class="container">
            <h2 class="section-title">Salonlarımız</h2>
            <p class="section-subtitle">En iyi güzellik salonlarını keşfedin ve randevunuzu hemen alın!</p>
            
            @php
                try {
                    $salons = \App\Models\User::where('role', 'güzellik_salonu')
                        ->where('is_active', true)
                        ->whereNotNull('salon_slug')
                        ->get()
                        ->map(function($salon) {
                            $salon->average_rating = \App\Models\SalonRating::getAverageRating($salon->id);
                            $salon->rating_count = \App\Models\SalonRating::getRatingCount($salon->id);
                            return $salon;
                        })
                        ->sortByDesc(function($salon) {
                            return $salon->average_rating;
                        })
                        ->take(6)
                        ->values();
                } catch (\Exception $e) {
                    $salons = collect([]);
                }
            @endphp
            
            <div class="row g-4 mt-4">
                @forelse($salons as $salon)
                    <div class="col-md-6 col-lg-4">
                        <div class="salon-card-home">
                            @if($salon->salon_profile_image)
                                <img src="{{ asset('storage/' . $salon->salon_profile_image) }}" 
                                     alt="{{ $salon->salon_name ?? $salon->name }}">
                            @else
                                <div class="salon-card-placeholder">
                                    <i class="bi bi-shop"></i>
                                </div>
                            @endif
                            <div class="card-body">
                                <h5>
                                    <a href="{{ route('public.salon.show', $salon->salon_slug) }}">
                                        {{ $salon->salon_name ?? $salon->name }}
                                    </a>
                                </h5>
                                
                                @if($salon->average_rating > 0)
                                    <div class="rating">
                                        @for($i = 1; $i <= 5; $i++)
                                            @if($i <= floor($salon->average_rating))
                                                <i class="bi bi-star-fill"></i>
                                            @elseif($i - 0.5 <= $salon->average_rating)
                                                <i class="bi bi-star-half"></i>
                                            @else
                                                <i class="bi bi-star"></i>
                                            @endif
                                        @endfor
                                        <span class="rating-text">
                                            {{ number_format($salon->average_rating, 1) }} ({{ $salon->rating_count }})
                                        </span>
                                    </div>
                                @else
                                    <div class="rating">
                                        <span class="rating-text text-muted">Henüz değerlendirme yok</span>
                                    </div>
                                @endif
                                
                                @if($salon->salon_address)
                                    <div class="address">
                                        <i class="bi bi-geo-alt"></i>
                                        {{ $salon->salon_address }}
                                        @if($salon->salon_district)
                                            , {{ $salon->salon_district }}
                                        @endif
                                        @if($salon->salon_city)
                                            / {{ $salon->salon_city }}
                                        @endif
                                    </div>
                                @endif
                                
                                <a href="{{ route('public.salon.show', $salon->salon_slug) }}" class="btn btn-view">
                                    Detayları Gör
                                </a>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12 text-center py-5">
                        <p class="text-muted">Henüz salon eklenmemiş.</p>
                    </div>
                @endforelse
            </div>
            
            @if($salons->count() > 0)
                <div class="text-center mt-5">
                    <a href="{{ route('public.salons.index') }}" class="btn btn-primary btn-lg" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; padding: 1rem 2.5rem; border-radius: 12px; font-weight: 600;">
                        Tüm Salonları Gör
                    </a>
                </div>
            @endif
        </div>
    </section>
    
    <!-- Packages Section -->
    <section id="paketler" class="packages">
        <div class="container">
            <h2 class="section-title">Fiyat Paketleri</h2>
            <p class="section-subtitle">İhtiyacınıza uygun paketi seçin ve hemen başlayın</p>
            
            @php
                $packages = \App\Models\Package::where('is_active', true)
                    ->orderBy('sort_order')
                    ->orderBy('name')
                    ->get();
            @endphp
            
            @if($packages->count() > 0)
            @php
                // Paketleri sırala: popüler olan ortada olsun
                $sortedPackages = $packages->sortBy(function($pkg) {
                    return $pkg->is_popular ? 1 : ($pkg->sort_order == 1 ? 0 : 2);
                });
            @endphp
            <div class="row g-4 justify-content-center mt-4">
                @foreach($sortedPackages as $package)
                <div class="col-12 col-md-4">
                    <div class="package-card {{ $package->is_popular ? 'popular' : '' }}" style="border-radius: 16px; padding: 2rem; height: 100%; background: white; box-shadow: 0 4px 20px rgba(0,0,0,0.1); transition: all 0.3s ease; {{ $package->is_popular ? 'border: 3px solid #ec4899; transform: scale(1.05); box-shadow: 0 10px 30px rgba(236, 72, 153, 0.3) !important;' : 'border: 1px solid #e5e7eb;' }}">
                        @if($package->is_popular)
                        <div class="text-center mb-3">
                            <span class="badge bg-primary" style="padding: 0.5rem 1.5rem; font-size: 0.9rem; box-shadow: 0 4px 10px rgba(0,0,0,0.2);">
                                <i class="bi bi-star-fill"></i> Popüler
                            </span>
                        </div>
                        @endif
                        <div class="text-center mb-4">
                            <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1rem;">{{ $package->name }}</h3>
                            @if($package->description)
                            <p style="color: #64748b; margin-bottom: 2rem;">{{ $package->description }}</p>
                            @endif
                            <div style="margin-bottom: 2rem;">
                                @if($package->original_price && $package->original_price > $package->price)
                                <div style="margin-bottom: 0.5rem;">
                                    <span style="text-decoration: line-through; color: #94a3b8; font-size: 1.5rem; font-weight: 600;">
                                        {{ number_format($package->original_price, 0, ',', '.') }} ₺
                                    </span>
                                    <span class="badge bg-danger ms-2" style="font-size: 0.75rem; padding: 4px 8px;">
                                        %{{ $package->discount_percentage }} İndirim
                                    </span>
                                </div>
                                @endif
                                <div>
                                    <span style="font-size: 2.5rem; font-weight: 900; color: var(--primary-blue);">{{ $package->formatted_price }}</span>
                                    @if($package->price > 0)
                                    <span style="color: #64748b; font-size: 1rem;">/{{ $package->price_period_text }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @if($package->features && count($package->features) > 0)
                        <div style="margin-bottom: 2rem; max-height: 400px; overflow-y: auto; padding-right: 8px;">
                            <ul style="list-style: none; padding: 0;">
                                @foreach($package->features as $feature)
                                <li style="padding: 0.5rem 0; display: flex; align-items: center;">
                                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                                    <span style="color: #1e293b; font-size: 0.9rem;">{{ $feature }}</span>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <div class="text-center">
                            @auth
                                <a href="{{ route('admin.dashboard') }}" class="btn btn-primary w-100" style="{{ $package->is_popular ? 'background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;' : '' }}">
                                    Panele Git
                                </a>
                            @else
                                <button type="button" class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#registerModal" style="{{ $package->is_popular ? 'background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;' : '' }}">
                                    Hemen Başla
                                </button>
                            @endauth
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            
            <style>
            @media (max-width: 768px) {
                .package-card.popular {
                    transform: scale(1) !important;
                }
            }
            </style>
            
            <script>
            // Slider fonksiyonları kaldırıldı - artık gerek yok
            </script>
            @else
            <div class="text-center py-5">
                <p class="text-muted">Henüz paket eklenmemiş.</p>
            </div>
            @endif
        </div>
    </section>
    
    <!-- Customer Reviews Section - 30 Yorum (3lü Grid, 10 Satır) -->
    <section id="musteri-yorumlari" class="customer-reviews py-5" style="background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%); scroll-margin-top: 80px;">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title" style="font-size: 2.5rem; font-weight: 800; margin-bottom: 1rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                    Müşterilerimiz Ne Diyor?
                </h2>
                <p class="section-subtitle" style="font-size: 1.1rem; color: #64748b; max-width: 600px; margin: 0 auto;">
                    Binlerce mutlu müşterimizin Salonay güzellik salonu randevu sistemi hakkındaki gerçek deneyimleri
                </p>
            </div>
            
            <div class="row g-4">
                    @php
                        $reviews = [
                        ['name' => 'Ayşe Yılmaz', 'city' => 'İstanbul', 'rating' => 5, 'text' => 'Salonay güzellik salonu randevu sistemi sayesinde randevu yönetimimiz tamamen değişti. Artık hiçbir randevuyu kaçırmıyoruz ve müşterilerimiz çok memnun. Kesinlikle tavsiye ederim!'],
                        ['name' => 'Zeynep Demir', 'city' => 'Ankara', 'rating' => 5, 'text' => 'Güzellik salonumuz için mükemmel bir randevu yönetim sistemi. Randevu takibi, fatura oluşturma ve müşteri yönetimi tek panelde. İşimizi çok kolaylaştırdı.'],
                        ['name' => 'Mehmet Kaya', 'city' => 'İzmir', 'rating' => 5, 'text' => '3 yıldır Salonay randevu sistemini kullanıyorum ve hiç sorun yaşamadım. SMS bildirimleri, otomatik fatura oluşturma ve detaylı raporlar harika.'],
                        ['name' => 'Fatma Şahin', 'city' => 'Bursa', 'rating' => 5, 'text' => 'Müşteri desteği çok hızlı ve profesyonel. Güzellik salonu randevu sistemi kullanımı çok kolay, personelimiz hemen adapte oldu. Çok memnunuz!'],
                        ['name' => 'Ali Öztürk', 'city' => 'Antalya', 'rating' => 5, 'text' => 'Randevu sistemimizi Salonay salon randevu yazılımına geçirdikten sonra işlerimiz %40 arttı. Müşteri memnuniyeti de çok yükseldi.'],
                        ['name' => 'Zeynep Arslan', 'city' => 'Adana', 'rating' => 5, 'text' => 'Fatura ve sözleşme oluşturma özelliği hayat kurtarıcı. Artık manuel işlem yapmıyoruz, her şey otomatik. Güzellik salonu yönetimi çok kolay.'],
                        ['name' => 'Mustafa Çelik', 'city' => 'Konya', 'rating' => 5, 'text' => 'Muhasebe modülü sayesinde gelir-gider takibimiz çok kolaylaştı. Detaylı raporlar iş planlamamızı çok etkiliyor. Randevu sistemi mükemmel.'],
                        ['name' => 'Elif Yıldız', 'city' => 'Gaziantep', 'rating' => 5, 'text' => 'Mobil uygulaması sayesinde her yerden randevu yönetebiliyorum. Çok pratik ve kullanışlı bir güzellik salonu randevu sistemi.'],
                        ['name' => 'Hasan Aydın', 'city' => 'Trabzon', 'rating' => 5, 'text' => 'Takvim görünümü mükemmel. Tüm randevularımızı bir bakışta görebiliyoruz. Çok profesyonel bir salon yönetim çözümü.'],
                        ['name' => 'Selin Özkan', 'city' => 'Eskişehir', 'rating' => 5, 'text' => 'Müşteri bilgilerini kaydetme ve geçmiş randevuları görüntüleme özelliği çok işimize yarıyor. Güzellik salonu yönetimi harika.'],
                        ['name' => 'Burak Doğan', 'city' => 'Kayseri', 'rating' => 5, 'text' => 'SMS ve WhatsApp bildirimleri sayesinde müşterilerimizle iletişimimiz çok güçlendi. Güzellik salonu randevu yazılımı harika bir özellik!'],
                        ['name' => 'Gamze Yücel', 'city' => 'Samsun', 'rating' => 5, 'text' => 'Fiyat performans açısından piyasadaki en iyi güzellik salonu randevu sistemi. Özellikler çok kapsamlı ve fiyatı çok uygun.'],
                        ['name' => 'Emre Koç', 'city' => 'Mersin', 'rating' => 5, 'text' => 'Kurulum ve eğitim desteği çok iyiydi. Güzellik salonu randevu sistemi hakkında hiçbir sorumuz cevapsız kalmadı.'],
                        ['name' => 'Derya Aktaş', 'city' => 'Diyarbakır', 'rating' => 5, 'text' => 'Çok kullanıcılı yapı sayesinde ekibimizle birlikte çalışabiliyoruz. Herkes kendi yetkileriyle randevu sistemini kullanıyor.'],
                        ['name' => 'Can Arslan', 'city' => 'Malatya', 'rating' => 5, 'text' => 'Raporlama özellikleri çok detaylı. Aylık, haftalık ve günlük raporlar iş analizimiz için çok değerli. Salon yönetim yazılımı mükemmel.'],
                        ['name' => 'Seda Kılıç', 'city' => 'Erzurum', 'rating' => 5, 'text' => 'Müşteri yorumları ve puanlama sistemi sayesinde hizmet kalitemizi sürekli iyileştirebiliyoruz. Güzellik salonu sistemi harika.'],
                        ['name' => 'Murat Şen', 'city' => 'Van', 'rating' => 5, 'text' => 'Cloud tabanlı sistem sayesinde verilerimiz güvende. Yedekleme ve güvenlik konusunda hiç endişemiz yok. Randevu yazılımı güvenli.'],
                        ['name' => 'Pınar Yılmaz', 'city' => 'Denizli', 'rating' => 5, 'text' => 'Entegrasyon özellikleri sayesinde mevcut sistemlerimizle uyumlu çalışıyor. Çok esnek bir güzellik salonu yönetim yapısı.'],
                        ['name' => 'Onur Demir', 'city' => 'Şanlıurfa', 'rating' => 5, 'text' => '2 yıldır kullanıyoruz ve salon randevu sistemi sürekli güncelleniyor. Yeni özellikler ekleniyor, çok dinamik bir platform.'],
                        ['name' => 'Burcu Aydın', 'city' => 'Manisa', 'rating' => 5, 'text' => 'Müşteri portföyümüzü Salonay güzellik salonu randevu yazılımı sayesinde %60 artırdık. Sistemin pazarlama araçları çok etkili.'],
                        ['name' => 'Okan Yıldırım', 'city' => 'Balıkesir', 'rating' => 5, 'text' => 'Güzellik salonu randevu yönetimi için en iyi çözüm. Randevu takibi, müşteri yönetimi ve muhasebe hepsi tek platformda.'],
                        ['name' => 'Nilüfer Çetin', 'city' => 'Aydın', 'rating' => 5, 'text' => 'Salonay salon randevu sistemi sayesinde işlerimizi çok daha profesyonel yönetiyoruz. Harika bir yazılım!'],
                        ['name' => 'Kemal Özdemir', 'city' => 'Tekirdağ', 'rating' => 5, 'text' => 'Randevu süreçlerimizi dijitalleştirdik. Artık tüm işlemler otomatik, güzellik salonu yönetimi çok kolay.'],
                        ['name' => 'Serap Kara', 'city' => 'Uşak', 'rating' => 5, 'text' => 'Randevu sistemi sayesinde güzellik salonumuzun doluluk oranı arttı. Müşteri memnuniyeti de çok yükseldi.'],
                        ['name' => 'Yusuf Polat', 'city' => 'Çorum', 'rating' => 5, 'text' => 'Güzellik salonu yönetim yazılımı olarak Salonay mükemmel. Randevu işlemleri, fatura ve raporlama hepsi mükemmel çalışıyor.'],
                        ['name' => 'Sibel Yüksel', 'city' => 'Hatay', 'rating' => 5, 'text' => 'Salon randevu yönetimi için aradığımız tüm özellikler var. Güzellik salonu işletmemizi çok daha iyi yönetiyoruz.'],
                        ['name' => 'Tolga Kurt', 'city' => 'Muğla', 'rating' => 5, 'text' => 'Salonay güzellik salonu randevu sistemi sayesinde iş yükümüz %50 azaldı. Otomatik bildirimler ve raporlar harika.'],
                        ['name' => 'Aylin Şen', 'city' => 'Kastamonu', 'rating' => 5, 'text' => 'Randevu yazılımı olarak en kapsamlı sistem. Güzellik salonu yönetimi, müşteri takibi ve muhasebe hepsi bir arada.'],
                        ['name' => 'Barış Demirci', 'city' => 'Sivas', 'rating' => 5, 'text' => 'Randevu sistemimizi Salonay salon yönetim yazılımına geçirdik. İşlerimiz çok daha düzenli ve profesyonel.'],
                        ['name' => 'Gizem Kaya', 'city' => 'Edirne', 'rating' => 5, 'text' => 'Salon randevu yönetimi için mükemmel bir çözüm. Güzellik salonu işletmemizi çok daha verimli yönetiyoruz.'],
                        ];
                    @endphp
                    
                    @foreach($reviews as $review)
                    <div class="col-md-4 col-lg-4">
                        <div class="review-card" style="background: white; border-radius: 16px; padding: 24px; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                            <div class="review-header" style="display: flex; align-items: center; gap: 12px; margin-bottom: 16px;">
                                <div class="review-avatar" style="width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: 700; font-size: 20px;">
                                    {{ substr($review['name'], 0, 1) }}
                                </div>
                                <div style="flex: 1;">
                                    <div style="font-weight: 700; color: #1e293b; margin-bottom: 4px;">{{ $review['name'] }}</div>
                                    <div style="font-size: 14px; color: #64748b;">{{ $review['city'] }}</div>
                                </div>
                                <div class="review-rating" style="display: flex; gap: 2px;">
                                    @for($i = 0; $i < $review['rating']; $i++)
                                        <i class="bi bi-star-fill" style="color: #fbbf24; font-size: 18px;"></i>
                                    @endfor
                                </div>
                            </div>
                            <div class="review-text" style="color: #475569; line-height: 1.6; font-size: 15px;">
                                "{{ $review['text'] }}"
                            </div>
                            </div>
                        </div>
                    @endforeach
            </div>
        </div>
    </section>
    
    <!-- FAQ Section -->
    <section class="faq">
        <div class="container">
            <h2 class="section-title">Sık Sorulan Sorular</h2>
            <p class="section-subtitle">Merak ettiğiniz tüm soruların cevaplarını bu alanda bulabilirsiniz.</p>
            
            <div class="row justify-content-center mt-4">
                <div class="col-lg-8">
                    <div class="accordion" id="faqAccordion">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                    Salonay Nedir?
                                </button>
                            </h2>
                            <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Salonay, güzellik salonu randevu yönetimi için geliştirilmiş modern bir yazılım platformudur. Randevularınızı kolayca yönetmenizi, müşterilerinizi takip etmenizi ve işletmenizi büyütmenizi sağlar.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                    Nasıl Başlayabilirim?
                                </button>
                            </h2>
                            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Hemen kayıt olarak ücretsiz deneme sürümümüzü kullanabilirsiniz. Kayıt olduktan sonra sistemin tüm özelliklerini keşfedebilir ve işletmeniz için en uygun paketi seçebilirsiniz.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                    Hangi Özellikler Mevcut?
                                </button>
                            </h2>
                            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Randevu yönetimi, müşteri takibi, muhasebe modülü, raporlama, SMS ve e-posta bildirimleri, fatura yönetimi ve daha fazlası. Tüm özelliklerimizi keşfetmek için paketlerimizi inceleyebilirsiniz.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- İletişim Section -->
    <section id="iletisim" class="contact-section py-5" style="background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); scroll-margin-top: 80px;">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title" style="font-size: 2.5rem; font-weight: 800; margin-bottom: 1rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                    İletişim
                </h2>
                <p class="section-subtitle" style="font-size: 1.1rem; color: #64748b; max-width: 600px; margin: 0 auto;">
                    Bize ulaşın, sorularınızı yanıtlayalım
                </p>
            </div>
            
            <div class="row g-4 justify-content-center">
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card" style="background: white; border-radius: 20px; padding: 2rem; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                        <div class="contact-icon" style="width: 70px; height: 70px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 32px;">
                            <i class="bi bi-telephone-fill"></i>
                        </div>
                        <h4 style="font-size: 1.25rem; font-weight: 700; margin-bottom: 1rem; color: #1e293b;">Telefon</h4>
                        <a href="tel:05409989090" style="color: #ec4899; text-decoration: none; font-size: 1.1rem; font-weight: 600;">0540 998 90 90</a>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card" style="background: white; border-radius: 20px; padding: 2rem; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                        <div class="contact-icon" style="width: 70px; height: 70px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 32px;">
                            <i class="bi bi-whatsapp"></i>
                        </div>
                        <h4 style="font-size: 1.25rem; font-weight: 700; margin-bottom: 1rem; color: #1e293b;">WhatsApp</h4>
                        <a href="https://wa.me/905409989090" target="_blank" style="color: #ec4899; text-decoration: none; font-size: 1.1rem; font-weight: 600;">0540 998 90 90</a>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card" style="background: white; border-radius: 20px; padding: 2rem; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                        <div class="contact-icon" style="width: 70px; height: 70px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 32px;">
                            <i class="bi bi-envelope-fill"></i>
                        </div>
                        <h4 style="font-size: 1.25rem; font-weight: 700; margin-bottom: 1rem; color: #1e293b;">E-posta</h4>
                        <a href="mailto:urkeyazilim@gmail.com" style="color: #f59e0b; text-decoration: none; font-size: 1rem; font-weight: 600; word-break: break-word;">urkeyazilim@gmail.com</a>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card" style="background: white; border-radius: 20px; padding: 2rem; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: 1px solid #e2e8f0; height: 100%;">
                        <div class="contact-icon" style="width: 70px; height: 70px; margin: 0 auto 1.5rem; background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 32px;">
                            <i class="bi bi-geo-alt-fill"></i>
                        </div>
                        <h4 style="font-size: 1.25rem; font-weight: 700; margin-bottom: 1rem; color: #1e293b;">Adres</h4>
                        <p style="color: #64748b; font-size: 0.95rem; line-height: 1.6; margin: 0;">Urke Yazılım Ofisi, Yenişehir, Bahri Karakeçili Caddesi 49/2E, 63600 Siverek/Şanlıurfa</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Package Selection Modal (Register) -->
    <div class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content" style="border-radius: 16px; overflow: hidden; border: none; box-shadow: 0 20px 60px rgba(0,0,0,0.15);">
                <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; padding: 1.25rem 1.5rem;">
                    <h5 class="modal-title text-white fw-bold" id="registerModalLabel" style="font-size: 1.15rem;">
                        <i class="bi bi-box-seam me-2"></i>Paket Seçimi - 6 Ay Ücretsiz Deneme
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-3">
                    <div class="alert alert-info mb-3" style="border-left: 3px solid #3b82f6; background: #eff6ff; padding: 0.75rem 1rem; font-size: 0.875rem; border-radius: 8px;">
                        <i class="bi bi-info-circle-fill me-2"></i>
                        <strong>14 Gün Ücretsiz Deneme!</strong> Kayıt olduktan sonra 14 gün boyunca tüm özellikleri ücretsiz kullanabilirsiniz.
                    </div>
                    
                    @php
                        $packages = \App\Models\Package::where('is_active', true)
                            ->orderBy('sort_order')
                            ->orderBy('name')
                            ->get();
                    @endphp
                    
                    @if($packages->count() > 0)
                    <div class="row g-3 justify-content-center">
                        @php
                            // Paketleri sırala: popüler olan ortada olsun
                            $sortedPackages = $packages->sortBy(function($pkg) {
                                return $pkg->is_popular ? 1 : ($pkg->sort_order == 1 ? 0 : 2);
                            });
                        @endphp
                        @foreach($sortedPackages as $package)
                        <div class="col-12 col-md-4">
                            <div class="card h-100 shadow-sm border-0 {{ $package->is_popular ? 'border-primary border-2' : 'border border-1' }}" style="border-radius: 12px; transition: all 0.3s ease; {{ $package->is_popular ? 'box-shadow: 0 8px 25px rgba(236, 72, 153, 0.25) !important;' : '' }}">
                                @if($package->is_popular)
                                <div class="position-absolute top-0 start-50 translate-middle mt-2" style="z-index: 10;">
                                    <span class="badge bg-primary px-2 py-1" style="font-size: 0.75rem; box-shadow: 0 2px 8px rgba(0,0,0,0.15);">
                                        <i class="bi bi-star-fill me-1"></i>Popüler
                                    </span>
                                </div>
                                @endif
                                <div class="card-body p-3" style="padding-top: {{ $package->is_popular ? '2.5rem' : '1rem' }} !important;">
                                    <h6 class="card-title fw-bold mb-1 text-center" style="font-size: 1rem;">{{ $package->name }}</h6>
                                    @if($package->description)
                                    <p class="text-muted mb-2 text-center" style="font-size: 0.75rem; line-height: 1.4;">{{ $package->description }}</p>
                                    @endif
                                    
                                    <div class="mb-3 text-center">
                                        @if($package->original_price && $package->original_price > $package->price)
                                        <div class="mb-1">
                                            <span class="text-decoration-line-through text-muted" style="font-size: 0.9rem; font-weight: 500;">
                                                {{ number_format($package->original_price, 0, ',', '.') }} ₺
                                            </span>
                                            <span class="badge bg-danger ms-1" style="font-size: 0.7rem; padding: 2px 6px;">
                                                %{{ $package->discount_percentage }} İndirim
                                            </span>
                                        </div>
                                        @endif
                                        <div class="d-flex align-items-baseline justify-content-center">
                                            <span class="fw-bold text-primary" style="font-size: 1.75rem;">{{ number_format($package->price, 0, ',', '.') }} ₺</span>
                                            @if($package->price > 0)
                                            <span class="text-muted ms-1" style="font-size: 0.85rem;">/{{ $package->price_period === 'monthly' ? 'ay' : 'yıl' }}</span>
                                            @endif
                                        </div>
                                        <small class="text-muted d-block mt-1" style="font-size: 0.7rem;">{{ $package->duration_months ?? 1 }} ay geçerli</small>
                                    </div>
                                    
                                    @if($package->features && count($package->features) > 0)
                                    <div style="max-height: 200px; overflow-y: auto; padding-right: 6px; margin-bottom: 1rem;">
                                        <ul class="list-unstyled mb-0">
                                            @foreach(array_slice($package->features, 0, 5) as $feature)
                                            <li class="mb-1">
                                                <i class="bi bi-check-circle-fill text-success me-1" style="font-size: 0.75rem;"></i>
                                                <span style="font-size: 0.75rem; line-height: 1.4;">{{ $feature }}</span>
                                            </li>
                                            @endforeach
                                            @if(count($package->features) > 5)
                                            <li class="text-muted text-center mt-1" style="font-size: 0.7rem;">
                                                +{{ count($package->features) - 5 }} özellik daha
                                            </li>
                                            @endif
                                        </ul>
                                    </div>
                                    @endif
                                    
                                    <a href="{{ route('register') }}" class="btn btn-primary w-100" style="border-radius: 8px; padding: 0.5rem; font-size: 0.875rem; font-weight: 600; {{ $package->is_popular ? 'background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;' : '' }}">
                                        <i class="bi bi-check-circle me-1"></i>Bu Paketi Seç
                                    </a>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="text-center py-5">
                        <p class="text-muted">Henüz paket eklenmemiş.</p>
                        <a href="{{ route('register') }}" class="btn btn-primary mt-3">
                            <i class="bi bi-person-plus me-2"></i>Kayıt Ol
                        </a>
                    </div>
                    @endif
                    
                    <div class="text-center mt-3">
                        <a href="#" class="text-decoration-none" style="font-size: 0.875rem;" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#loginModal">
                            Zaten hesabınız var mı? Giriş yapın
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 20px; border: none;">
                <div class="modal-header" style="border-bottom: none; padding: 2rem 2rem 1rem;">
                    <h5 class="modal-title" id="loginModalLabel" style="font-size: 1.5rem; font-weight: 700;">Giriş Yap</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="padding: 0 2rem 2rem;">
                    <div id="loginErrorAlert" class="alert alert-danger" style="display: none;">
                        <ul class="mb-0" id="loginErrorList"></ul>
                    </div>
                    
                    @php
                        $loginErrors = ['login', 'database'];
                        $hasLoginErrors = false;
                        foreach($loginErrors as $key) {
                            if($errors->has($key)) {
                                $hasLoginErrors = true;
                                break;
                            }
                        }
                    @endphp
                    @if($hasLoginErrors)
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        <script>
                            // Hata varsa modal'ı açık tut
                            document.addEventListener('DOMContentLoaded', function() {
                                const loginModal = new bootstrap.Modal(document.getElementById('loginModal'));
                                loginModal.show();
                            });
                        </script>
                    @endif
                    
                    <form method="POST" action="{{ route('login') }}" id="loginForm">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="login_email" class="form-label">Telefon veya E-posta <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="login_email" name="login" required autofocus placeholder="05XX XXX XX XX veya e-posta">
                        </div>
                        
                        <div class="mb-3">
                            <label for="login_password" class="form-label">Şifre <span class="text-danger">*</span></label>
                            <input type="password" class="form-control" id="login_password" name="password" required>
                        </div>
                        
                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="login_remember" name="remember">
                            <label class="form-check-label" for="login_remember">Beni hatırla</label>
                        </div>
                        
                        <button type="submit" class="btn btn-primary w-100" id="loginSubmitBtn" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; padding: 0.75rem; border-radius: 50px;">
                            <i class="bi bi-box-arrow-in-right"></i> <span id="loginSubmitText">Giriş Yap</span>
                        </button>
                        
                        <div class="text-center mt-3">
                            <a href="#" class="text-decoration-none" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#registerModal">Hesabınız yok mu? Kayıt olun</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Hakkımızda Modal -->
    <div class="modal fade" id="hakkimizdaModal" tabindex="-1" aria-labelledby="hakkimizdaModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content" style="border-radius: 20px; border: none;">
                <div class="modal-header" style="border-bottom: none; padding: 2rem 2rem 1rem; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 20px 20px 0 0;">
                    <h5 class="modal-title" id="hakkimizdaModalLabel" style="font-size: 1.75rem; font-weight: 700; color: white;">
                        <i class="bi bi-info-circle me-2"></i>Hakkımızda
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="padding: 2rem;">
                    <div class="about-content">
                        <div class="mb-4">
                            <h3 style="font-size: 1.5rem; font-weight: 700; color: #1e293b; margin-bottom: 1rem;">Salonay Hakkında</h3>
                            <p style="font-size: 1.05rem; line-height: 1.8; color: #475569; margin-bottom: 1rem;">
                                <strong>Salonay</strong>, Türkiye'nin en gelişmiş <strong>güzellik salonu randevu sistemi</strong> olarak, güzellik salonları, estetik merkezleri ve estetik merkezleri için kapsamlı bir <strong>randevu yönetim yazılımı</strong> sunmaktadır.
                            </p>
                            <p style="font-size: 1.05rem; line-height: 1.8; color: #475569; margin-bottom: 1rem;">
                                Modern teknoloji altyapısı ile geliştirilen <strong>salon randevu sistemi</strong>miz, işletmelerin randevu takibini, müşteri yönetimini, muhasebe işlemlerini ve fatura yönetimini tek bir platform üzerinden gerçekleştirmesine olanak sağlar.
                            </p>
                        </div>
                        
                        <div class="mb-4">
                            <h4 style="font-size: 1.25rem; font-weight: 700; color: #ec4899; margin-bottom: 1rem;">
                                <i class="bi bi-bullseye me-2"></i>Misyonumuz
                            </h4>
                            <p style="font-size: 1.05rem; line-height: 1.8; color: #475569;">
                                Güzellik salonu ve güzellik salonu işletmelerinin dijital dönüşümünü destekleyerek, <strong>randevu yönetimi</strong> süreçlerini kolaylaştırmak ve iş verimliliğini artırmak. <strong>Salon yönetim yazılımı</strong> ile sektördeki tüm işletmelere profesyonel çözümler sunmak.
                            </p>
                        </div>
                        
                        <div class="mb-4">
                            <h4 style="font-size: 1.25rem; font-weight: 700; color: #ec4899; margin-bottom: 1rem;">
                                <i class="bi bi-star-fill me-2"></i>Vizyonumuz
                            </h4>
                            <p style="font-size: 1.05rem; line-height: 1.8; color: #475569;">
                                Türkiye'deki tüm güzellik salonu işletmelerinin birincil tercihi olmak. <strong>Randevu takip sistemi</strong> alanında lider konumda olmak ve sürekli gelişen teknoloji ile yenilikçi çözümler üretmek.
                            </p>
                        </div>
                        
                        <div class="mb-4">
                            <h4 style="font-size: 1.25rem; font-weight: 700; color: #ec4899; margin-bottom: 1rem;">
                                <i class="bi bi-check-circle-fill me-2"></i>Neden Salonay?
                            </h4>
                            <ul style="font-size: 1.05rem; line-height: 2; color: #475569; padding-left: 1.5rem;">
                                <li><strong>Kapsamlı Randevu Yönetimi:</strong> Güzellik salonu randevularınızı kolayca oluşturun, takip edin ve yönetin</li>
                                <li><strong>Müşteri Yönetimi:</strong> Müşteri bilgilerini tek merkezden yönetin ve geçmiş randevuları görüntüleyin</li>
                                <li><strong>Muhasebe Entegrasyonu:</strong> Gelir-gider takibi, fatura oluşturma ve ödeme yönetimi</li>
                                <li><strong>Mobil Uyumluluk:</strong> Her yerden erişilebilen responsive <strong>salon randevu yazılımı</strong></li>
                                <li><strong>Güvenli Altyapı:</strong> Cloud tabanlı güvenli veri saklama ve otomatik yedekleme</li>
                                <li><strong>7/24 Destek:</strong> Profesyonel müşteri desteği ve teknik yardım</li>
                            </ul>
                        </div>
                        
                        <div style="background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%); padding: 1.5rem; border-radius: 12px; margin-top: 2rem;">
                            <p style="font-size: 1rem; line-height: 1.8; color: #047857; margin: 0; text-align: center;">
                                <strong>Salonay</strong> ile güzellik salonu randevu yönetiminizi dijitalleştirin ve işletmenizi büyütün. <strong>Randevu sistemi</strong>miz ile işlerinizi kolaylaştırın, zaman kazanın ve müşteri memnuniyetinizi artırın.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 1.5rem 2rem;">
                    <a href="#iletisim" class="btn btn-primary" data-bs-dismiss="modal" onclick="setTimeout(() => { document.getElementById('iletisim').scrollIntoView({ behavior: 'smooth' }); }, 300);">
                        <i class="bi bi-envelope me-2"></i>İletişime Geç
                    </a>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-3 mb-4">
                    <div style="display: flex; align-items: center; margin-bottom: 1rem;">
                        <img src="{{ asset('salonayheaderlogo.png') }}" alt="Salonay" style="height: 50px; width: auto; object-fit: contain; filter: brightness(0) invert(1);" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-block';">
                        <span class="logo-text" style="display: none;">Salonay</span>
                    </div>
                    <p style="color: rgba(255,255,255,0.7);">Modern ve kullanıcı dostu randevu yönetim sistemi ile işletmenizi büyütün.</p>
                </div>
                <div class="col-md-3 mb-4">
                    <h5>ÇÖZÜMLER</h5>
                    <a href="#paketler">Fiyat Paketleri</a>
                    <a href="#ozellikler">Özellikler</a>
                    <a href="#salonlar">Salonlar</a>
                    <a href="#indirmeler">İndirmeler</a>
                </div>
                <div class="col-md-3 mb-4">
                    <h5>KURUMSAL</h5>
                    <a href="#" data-bs-toggle="modal" data-bs-target="#hakkimizdaModal">Hakkımızda</a>
                    <a href="#iletisim">İletişim</a>
                </div>
                <div class="col-md-3 mb-4">
                    <h5>İLETİŞİM</h5>
                    <a href="tel:{{ str_replace(' ', '', $phone) }}"><i class="bi bi-telephone"></i> {{ $phone }}</a>
                    <a href="mailto:info@salonay.com"><i class="bi bi-envelope"></i> info@salonay.com</a>
                    <div class="payment-methods-mini">
                        <p class="payment-methods-mini-title"><i class="bi bi-shield-lock-fill"></i>3D Secure Ödeme</p>
                        <div class="payment-logos">
                            <img src="{{ route('public.payment-asset', ['name' => 'troy.png']) }}" alt="Troy" class="payment-logo-item" onerror="this.style.display='none'">
                            <img src="{{ route('public.payment-asset', ['name' => 'master.png']) }}" alt="Mastercard" class="payment-logo-item" onerror="this.style.display='none'">
                            <img src="{{ route('public.payment-asset', ['name' => 'visa.png']) }}" alt="Visa" class="payment-logo-item" onerror="this.style.display='none'">
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="d-flex flex-wrap justify-content-center gap-3 mb-2" style="font-size: 0.9rem;">
                    <a href="{{ route('pages.kvkk') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">KVKK</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.privacy') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Gizlilik Politikası</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.purchase-agreement') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Satın Alma Sözleşmesi</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.terms') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Kullanım Şartları</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.cookies') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Çerezler</a>
                </div>
                <p>&copy; {{ date('Y') }} Salonay. Tüm hakları saklıdır.</p>
            </div>
        </div>
    </footer>
    
    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Suppress console errors for blocked resources (ads, trackers)
        window.addEventListener('error', function(e) {
            if (e.message && (
                e.message.includes('doubleclick') ||
                e.message.includes('ERR_BLOCKED_BY_CLIENT') ||
                e.message.includes('net::ERR_BLOCKED_BY_CLIENT')
            )) {
                e.preventDefault();
                return false;
            }
        }, true);
        
        // Suppress failed resource loading errors
        window.addEventListener('error', function(e) {
            if (e.target && e.target.tagName === 'SCRIPT' && (
                e.target.src && (e.target.src.includes('doubleclick') || e.target.src.includes('googleads'))
            )) {
                e.preventDefault();
                return false;
            }
        }, true);
        
        // Notification function
        function showNotification(message, type = 'info') {
            const existingToast = document.querySelector('.custom-toast');
            if (existingToast) existingToast.remove();
            
            const colors = {
                success: { bg: '#10b981', icon: 'bi-check-circle-fill' },
                error: { bg: '#ef4444', icon: 'bi-x-circle-fill' },
                warning: { bg: '#f59e0b', icon: 'bi-exclamation-triangle-fill' },
                info: { bg: '#3b82f6', icon: 'bi-info-circle-fill' }
            };
            
            const config = colors[type] || colors.info;
            
            const toast = document.createElement('div');
            toast.className = 'custom-toast';
            toast.innerHTML = `
                <div style="position: fixed; top: 20px; right: 20px; z-index: 9999999; animation: slideIn 0.3s ease;">
                    <div style="background: ${config.bg}; color: white; padding: 16px 24px; border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); display: flex; align-items: center; gap: 12px; min-width: 300px;">
                        <i class="bi ${config.icon}" style="font-size: 24px;"></i>
                        <span style="font-weight: 500;">${message}</span>
                    </div>
                </div>
            `;
            
            document.body.appendChild(toast);
            
            setTimeout(() => {
                toast.style.opacity = '0';
                toast.style.transition = 'opacity 0.3s ease';
                setTimeout(() => toast.remove(), 300);
            }, 3000);
        }
        
        // OTP aktif mi kontrol et
        const OTP_ENABLED = {{ config('app.registration_otp_enabled', false) ? 'true' : 'false' }};
        
        // Modal OTP gönderme fonksiyonu - Global scope (DOMContentLoaded dışında)
        window.sendModalOtp = function() {
            
            if (!OTP_ENABLED) {
                console.log('OTP sistemi devre dışı');
                return;
            }
            
            console.log('sendModalOtp fonksiyonu çağrıldı');
            
            const phoneInput = document.getElementById('modal_phone');
            if (!phoneInput) {
                console.error('Modal phone input bulunamadı!');
                if (typeof showNotification === 'function') {
                    showNotification('Telefon numarası alanı bulunamadı.', 'error');
                }
                return;
            }
            
            const phone = phoneInput.value.trim();
            const sendBtn = document.getElementById('modal_sendOtpBtn');
            const otpStatus = document.getElementById('modal_otpStatus');
            const otpField = document.getElementById('modal_otpField');
            
            if (!phone) {
                if (typeof showNotification === 'function') {
                    showNotification('Lütfen telefon numaranızı giriniz.', 'error');
                }
                phoneInput.focus();
                return;
            }
            
            // Telefon numarasını temizle
            const cleanPhone = phone.replace(/[^0-9]/g, '');
            
            // Telefon format kontrolü (10-11 haneli, 0 ile başlamalı)
            if (cleanPhone.length < 10 || cleanPhone.length > 11) {
                if (typeof showNotification === 'function') {
                    showNotification('Geçerli bir telefon numarası giriniz. (05XX XXX XX XX)', 'error');
                }
                phoneInput.focus();
                return;
            }
            
            if (!cleanPhone.startsWith('0')) {
                if (typeof showNotification === 'function') {
                    showNotification('Telefon numarası 0 ile başlamalıdır. (05XX XXX XX XX)', 'error');
                }
                phoneInput.focus();
                return;
            }
            
            // SMS gönderme flag'ini set et (modal kapanmasını engellemek için)
            const registerModalEl = document.getElementById('registerModal');
            if (registerModalEl) {
                window.isSendingOtp = true;
            }
            
            
            if (sendBtn) {
                sendBtn.disabled = true;
                sendBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Gönderiliyor...';
            }
            if (otpStatus) {
                otpStatus.textContent = '';
            }
            
            // CSRF token al - birden fazla kaynaktan dene
            const getCsrfToken = () => {
                return document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') 
                    || document.querySelector('input[name="_token"]')?.value
                    || '{{ csrf_token() }}';
            };
            const csrfToken = getCsrfToken();
            
            if (!csrfToken || csrfToken === '') {
                console.error('CSRF token bulunamadı!');
                if (typeof showNotification === 'function') {
                    showNotification('Güvenlik hatası. Sayfayı yenileyin.', 'error');
                }
                if (registerModalEl) {
                    window.isSendingOtp = false;
                }
                return;
            }
            
            // AJAX isteği
            fetch('{{ route("register.send-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                },
                credentials: 'same-origin',
                body: JSON.stringify({ phone: cleanPhone })
            })
            .then(async response => {
                // Response body'yi text olarak oku
                const responseText = await response.text();
                let data;
                
                try {
                    data = JSON.parse(responseText);
                } catch (e) {
                    // JSON parse edilemezse
                    console.error('JSON parse hatası:', responseText);
                    throw new Error('SMS gönderiminde bir sorun oluştu. Lütfen tekrar deneyin.');
                }
                
                if (!response.ok) {
                    // 419 CSRF token hatası - özel mesaj göster ama sayfayı yenileme
                    if (response.status === 419) {
                        // CSRF token'ı yeniden al ve tekrar dene
                        const newCsrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') 
                            || document.querySelector('input[name="_token"]')?.value;
                        
                        if (newCsrfToken && newCsrfToken !== csrfToken) {
                            // Token güncellenmiş, tekrar dene
                            throw new Error('CSRF_TOKEN_REFRESH');
                        }
                        throw new Error('Oturum süreniz dolmuş. Lütfen sayfayı yenileyip tekrar deneyin.');
                    }
                    // Backend'den gelen hata mesajını kullan
                    const errorMsg = data.message || data.error || `Sunucu hatası: ${response.status}`;
                    throw new Error(errorMsg);
                }
                
                return data;
            })
            .then(data => {
                console.log('Modal OTP Response:', data);
                
                if (data && data.success === true) {
                    if (typeof showNotification === 'function') {
                        showNotification(data.message || 'Doğrulama kodu gönderildi.', 'success');
                    }
                    if (otpStatus) {
                        otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                        otpStatus.className = 'text-success';
                    }
                    
                    // OTP alanını göster
                    const otpFieldElement = document.getElementById('modal_otpField');
                    console.log('Modal OTP Field Element:', otpFieldElement);
                    if (otpFieldElement) {
                        otpFieldElement.style.display = 'block';
                        otpFieldElement.style.visibility = 'visible';
                        otpFieldElement.style.opacity = '1';
                        const otpInput = document.getElementById('modal_otp_code');
                        if (otpInput) {
                            otpInput.focus();
                            otpInput.value = '';
                            console.log('Modal OTP input focus edildi');
                        }
                    }
                    
                    // 60 saniye geri sayım
                    let countdown = 60;
                    const interval = setInterval(() => {
                        countdown--;
                        if (sendBtn) {
                            sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                            if (countdown <= 0) {
                                clearInterval(interval);
                                sendBtn.disabled = false;
                                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                            }
                        }
                    }, 1000);
                } else {
                    const errorMsg = (data && data.message) ? data.message : 'OTP gönderilemedi. Lütfen tekrar deneyin.';
                    console.error('Modal OTP gönderme başarısız:', errorMsg, data);
                    if (typeof showNotification === 'function') {
                        showNotification(errorMsg, 'error');
                    }
                    if (otpStatus) {
                        otpStatus.textContent = errorMsg;
                        otpStatus.className = 'text-danger';
                    }
                    if (sendBtn) {
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }
            })
            .catch(error => {
                console.error('Modal OTP Gönderme Hatası:', error);
                let errorMsg = error.message || 'SMS gönderiminde bir sorun oluştu. Lütfen tekrar deneyin.';
                
                // CSRF token hatası ise kullanıcıya bilgi ver ama sayfayı otomatik yenileme
                if (errorMsg.includes('Oturum süreniz dolmuş') || errorMsg.includes('CSRF') || errorMsg.includes('419')) {
                    errorMsg = 'Oturum süreniz dolmuş. Lütfen sayfayı yenileyip tekrar deneyin.';
                    if (typeof showNotification === 'function') {
                        showNotification(errorMsg, 'warning');
                    }
                    // Sayfayı otomatik yenileme - kullanıcı manuel yenilesin
                    // Modal açık kalsın, kullanıcı tekrar deneyebilsin
                } else {
                    // Diğer hatalar için normal hata mesajı göster
                    if (typeof showNotification === 'function') {
                        showNotification(errorMsg, 'error');
                    }
                }
                
                if (otpStatus) {
                    otpStatus.textContent = errorMsg;
                    otpStatus.className = 'text-danger';
                }
                if (sendBtn) {
                    sendBtn.disabled = false;
                    sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                }
                // SMS gönderme flag'ini sıfırla
                if (registerModalEl) {
                    window.isSendingOtp = false;
                }
            });
        };
        
        // Smooth scroll
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    const offset = 80;
                    const targetPosition = target.getBoundingClientRect().top + window.pageYOffset - offset;
                    window.scrollTo({
                        top: targetPosition,
                        behavior: 'smooth'
                    });
                }
            });
        });
        
        // Login form AJAX ile gönder - 419 hatasını önlemek için
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            if (loginForm) {
                loginForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    
                    const submitBtn = document.getElementById('loginSubmitBtn');
                    const submitText = document.getElementById('loginSubmitText');
                    const loginModal = bootstrap.Modal.getInstance(document.getElementById('loginModal'));
                    const errorAlert = document.getElementById('loginErrorAlert');
                    const errorList = document.getElementById('loginErrorList');
                    
                    // Loading state
                    if (submitBtn) {
                        submitBtn.disabled = true;
                        if (submitText) submitText.textContent = 'Giriş yapılıyor...';
                    }
                    
                    // Hata mesajlarını temizle
                    if (errorAlert) errorAlert.style.display = 'none';
                    if (errorList) errorList.innerHTML = '';
                    
                    const formData = new FormData(loginForm);
                    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || document.querySelector('input[name="_token"]')?.value;
                    
                    fetch(loginForm.action, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': csrfToken,
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: formData,
                        credentials: 'same-origin',
                        redirect: 'follow'
                    })
                    .then(response => {
                        if (response.redirected) {
                            // Başarılı giriş - dashboard'a yönlendir
                            if (loginModal) loginModal.hide();
                            window.location.href = response.url;
                            return null;
                        }
                        
                        const contentType = response.headers.get('content-type');
                        if (contentType && contentType.includes('application/json')) {
                            return response.json();
                        }
                        
                        return response.text().then(text => {
                            try {
                                return JSON.parse(text);
                            } catch {
                                // HTML response ise parse et
                                const parser = new DOMParser();
                                const doc = parser.parseFromString(text, 'text/html');
                                const errors = doc.querySelectorAll('.alert-danger li, .error');
                                if (errors.length > 0) {
                                    return { errors: Array.from(errors).map(e => e.textContent.trim()) };
                                }
                                return { error: 'Giriş başarısız. Lütfen tekrar deneyin.' };
                            }
                        });
                    })
                    .then(data => {
                        if (!data) return; // Redirect durumunda data null olur
                        
                        if (data.success && data.redirect) {
                            // Başarılı giriş
                            if (loginModal) loginModal.hide();
                            window.location.href = data.redirect;
                            return;
                        }
                        
                        if (data.errors && Array.isArray(data.errors)) {
                            // Hata mesajlarını göster
                            if (errorList) {
                                errorList.innerHTML = data.errors.map(err => `<li>${err}</li>`).join('');
                            }
                            if (errorAlert) errorAlert.style.display = 'block';
                            if (loginModal) loginModal.show();
                        } else if (data.error) {
                            if (errorList) errorList.innerHTML = `<li>${data.error}</li>`;
                            if (errorAlert) errorAlert.style.display = 'block';
                            if (loginModal) loginModal.show();
                        }
                        
                        // Loading state'i kaldır
                        if (submitBtn) {
                            submitBtn.disabled = false;
                            if (submitText) submitText.textContent = 'Giriş Yap';
                        }
                    })
                    .catch(error => {
                        console.error('Login error:', error);
                        if (errorList) errorList.innerHTML = '<li>Bir hata oluştu. Lütfen tekrar deneyin.</li>';
                        if (errorAlert) errorAlert.style.display = 'block';
                        if (loginModal) loginModal.show();
                        
                        if (submitBtn) {
                            submitBtn.disabled = false;
                            if (submitText) submitText.textContent = 'Giriş Yap';
                        }
                    });
                });
            }
            
            // Register form
            const registerForm = document.getElementById('registerForm');
            if (registerForm) {
                registerForm.addEventListener('submit', function(e) {
                    // Form submit edildiğinde modal'ı kapatma
                    const registerModal = bootstrap.Modal.getInstance(document.getElementById('registerModal'));
                    if (registerModal) {
                        // Hata durumunda modal'ı açık tutmak için submit sonrası kontrol yapılacak
                    }
                });
            }
            
            // Modal OTP kodu sadece rakam girişi
            document.getElementById('modal_otp_code')?.addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
            
            // Modal E-posta kontrolü (blur event)
            const modalEmailInput = document.getElementById('modal_email');
            const modalEmailStatus = document.getElementById('modal_emailStatus');
            let modalEmailCheckTimeout;
            
            modalEmailInput?.addEventListener('blur', function() {
                const email = this.value.trim();
                
                if (!email) {
                    modalEmailStatus.textContent = '';
                    return;
                }
                
                // E-posta format kontrolü
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(email)) {
                    modalEmailStatus.textContent = 'Geçerli bir e-posta adresi giriniz.';
                    modalEmailStatus.className = 'text-danger';
                    return;
                }
                
                // Debounce - 500ms bekle
                clearTimeout(modalEmailCheckTimeout);
                modalEmailStatus.textContent = 'Kontrol ediliyor...';
                modalEmailStatus.className = 'text-muted';
                
                modalEmailCheckTimeout = setTimeout(() => {
                    const getCsrfToken = () => {
                        return document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') 
                            || document.querySelector('input[name="_token"]')?.value
                            || '{{ csrf_token() }}';
                    };
                    const csrfToken = getCsrfToken();
                    
                    if (!csrfToken) return;
                    
                    fetch('{{ route("register.check-email") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken,
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        },
                        credentials: 'same-origin',
                        body: JSON.stringify({ email: email })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.exists) {
                            showNotification(data.message || 'Bu e-posta adresi zaten kayıtlı.', 'error');
                            modalEmailStatus.textContent = data.message || 'Bu e-posta adresi zaten kayıtlı.';
                            modalEmailStatus.className = 'text-danger';
                            modalEmailInput.classList.add('is-invalid');
                        } else {
                            modalEmailStatus.textContent = data.message || 'E-posta adresi kullanılabilir.';
                            modalEmailStatus.className = 'text-success';
                            modalEmailInput.classList.remove('is-invalid');
                            modalEmailInput.classList.add('is-valid');
                        }
                    })
                    .catch(error => {
                        console.error('E-posta kontrol hatası:', error);
                        modalEmailStatus.textContent = '';
                    });
                }, 500);
            });
            
            // Modal Telefon numarası kontrolü (blur event)
            const modalPhoneInput = document.getElementById('modal_phone');
            const modalPhoneStatus = document.getElementById('modal_phoneStatus');
            let modalPhoneCheckTimeout;
            
            modalPhoneInput?.addEventListener('blur', function() {
                const phone = this.value.trim();
                
                if (!phone) {
                    modalPhoneStatus.textContent = '';
                    return;
                }
                
                // Telefon numarasını temizle
                const cleanPhone = phone.replace(/[^0-9]/g, '');
                
                // Telefon format kontrolü
                if (cleanPhone.length < 10 || cleanPhone.length > 11) {
                    modalPhoneStatus.textContent = 'Geçerli bir telefon numarası giriniz. (05XX XXX XX XX)';
                    modalPhoneStatus.className = 'text-danger';
                    return;
                }
                
                if (!cleanPhone.startsWith('0')) {
                    modalPhoneStatus.textContent = 'Telefon numarası 0 ile başlamalıdır.';
                    modalPhoneStatus.className = 'text-danger';
                    return;
                }
                
                // Debounce - 500ms bekle
                clearTimeout(modalPhoneCheckTimeout);
                modalPhoneStatus.textContent = 'Kontrol ediliyor...';
                modalPhoneStatus.className = 'text-muted';
                
                modalPhoneCheckTimeout = setTimeout(() => {
                    const getCsrfToken = () => {
                        return document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') 
                            || document.querySelector('input[name="_token"]')?.value
                            || '{{ csrf_token() }}';
                    };
                    const csrfToken = getCsrfToken();
                    
                    if (!csrfToken) return;
                    
                    fetch('{{ route("register.check-phone") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken,
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        },
                        credentials: 'same-origin',
                        body: JSON.stringify({ phone: cleanPhone })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.exists) {
                            showNotification(data.message || 'Bu telefon numarası zaten kayıtlı.', 'error');
                            modalPhoneStatus.textContent = data.message || 'Bu telefon numarası zaten kayıtlı.';
                            modalPhoneStatus.className = 'text-danger';
                            modalPhoneInput.classList.add('is-invalid');
                        } else {
                            modalPhoneStatus.textContent = data.message || 'Telefon numarası kullanılabilir.';
                            modalPhoneStatus.className = 'text-success';
                            modalPhoneInput.classList.remove('is-invalid');
                            modalPhoneInput.classList.add('is-valid');
                        }
                    })
                    .catch(error => {
                        console.error('Telefon kontrol hatası:', error);
                        modalPhoneStatus.textContent = '';
                    });
                }, 500);
            });
            
            // Hata varsa modal'ları açık tut - sadece ilgili formun hataları varsa
            @php
                $loginErrors = ['login', 'database'];
                $registerErrors = ['name', 'email', 'phone', 'password', 'otp_code', 'password_confirmation', 'error'];
                $hasLoginErrors = false;
                $hasRegisterErrors = false;
                foreach($loginErrors as $key) {
                    if($errors->has($key)) {
                        $hasLoginErrors = true;
                        break;
                    }
                }
                foreach($registerErrors as $key) {
                    if($errors->has($key)) {
                        $hasRegisterErrors = true;
                        break;
                    }
                }
                // Eğer hiç register hatası yoksa ama genel hatalar varsa ve login hatası da yoksa, register hatası say
                if(!$hasRegisterErrors && !$hasLoginErrors && $errors->any()) {
                    $hasRegisterErrors = true;
                }
            @endphp
            @if($hasLoginErrors)
                const loginModal = new bootstrap.Modal(document.getElementById('loginModal'));
                loginModal.show();
            @elseif($hasRegisterErrors)
                const registerModal = new bootstrap.Modal(document.getElementById('registerModal'));
                registerModal.show();
            @endif
            
            // Modal'lar kapatıldığında form'ları reset et
            const loginModalEl = document.getElementById('loginModal');
            const registerModalEl = document.getElementById('registerModal');
            
            if (loginModalEl) {
                loginModalEl.addEventListener('hidden.bs.modal', function() {
                    const loginForm = document.getElementById('loginForm');
                    if (loginForm) {
                        loginForm.reset();
                        // Hata mesajlarını temizle
                        const errorAlert = document.getElementById('loginErrorAlert');
                        const errorList = document.getElementById('loginErrorList');
                        if (errorAlert) errorAlert.style.display = 'none';
                        if (errorList) errorList.innerHTML = '';
                        // Input validasyon class'larını temizle
                        loginForm.querySelectorAll('.is-invalid, .is-valid').forEach(el => {
                            el.classList.remove('is-invalid', 'is-valid');
                        });
                    }
                });
            }
            
            if (registerModalEl) {
                // SMS gönderme işlemi devam ederken modal'ın kapanmasını engelle
                window.isSendingOtp = false;
                
                registerModalEl.addEventListener('hide.bs.modal', function(e) {
                    if (window.isSendingOtp) {
                        e.preventDefault();
                        e.stopPropagation();
                        return false;
                    }
                });
                
                registerModalEl.addEventListener('hidden.bs.modal', function() {
                    const registerForm = document.getElementById('registerForm');
                    if (registerForm) {
                        registerForm.reset();
                        // Hata mesajlarını temizle
                        const errorAlert = document.getElementById('registerErrorAlert');
                        const errorList = document.getElementById('registerErrorList');
                        if (errorAlert) errorAlert.style.display = 'none';
                        if (errorList) errorList.innerHTML = '';
                        // Input validasyon class'larını temizle
                        registerForm.querySelectorAll('.is-invalid, .is-valid').forEach(el => {
                            el.classList.remove('is-invalid', 'is-valid');
                        });
                        // OTP alanını gizle
                        const otpField = document.getElementById('modal_otpField');
                        if (otpField) {
                            otpField.style.display = 'none';
                        }
                        // Status mesajlarını temizle
                        const emailStatus = document.getElementById('modal_emailStatus');
                        const phoneStatus = document.getElementById('modal_phoneStatus');
                        const otpStatus = document.getElementById('modal_otpStatus');
                        if (emailStatus) emailStatus.textContent = '';
                        if (phoneStatus) phoneStatus.textContent = '';
                        if (otpStatus) otpStatus.textContent = '';
                        // OTP butonunu reset et
                        const sendOtpBtn = document.getElementById('modal_sendOtpBtn');
                        if (sendOtpBtn) {
                            sendOtpBtn.disabled = false;
                            sendOtpBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                        }
                        // SMS gönderme flag'ini sıfırla
                        window.isSendingOtp = false;
                    }
                });
                
                // Modal açıldığında form'u temizle (show event) - eski bilgileri kaldır
                registerModalEl.addEventListener('show.bs.modal', function() {
                    const registerForm = document.getElementById('registerForm');
                    if (registerForm) {
                        // Form'u reset et - eski bilgileri kaldır
                        registerForm.reset();
                        // Hata mesajlarını temizle
                        const errorAlert = document.getElementById('registerErrorAlert');
                        const errorList = document.getElementById('registerErrorList');
                        if (errorAlert) errorAlert.style.display = 'none';
                        if (errorList) errorList.innerHTML = '';
                        // Input validasyon class'larını temizle
                        registerForm.querySelectorAll('.is-invalid, .is-valid').forEach(el => {
                            el.classList.remove('is-invalid', 'is-valid');
                        });
                        // OTP alanını gizle
                        const otpField = document.getElementById('modal_otpField');
                        if (otpField) {
                            otpField.style.display = 'none';
                        }
                        // Status mesajlarını temizle
                        const emailStatus = document.getElementById('modal_emailStatus');
                        const phoneStatus = document.getElementById('modal_phoneStatus');
                        const otpStatus = document.getElementById('modal_otpStatus');
                        if (emailStatus) emailStatus.textContent = '';
                        if (phoneStatus) phoneStatus.textContent = '';
                        if (otpStatus) otpStatus.textContent = '';
                        // OTP butonunu reset et
                        const sendOtpBtn = document.getElementById('modal_sendOtpBtn');
                        if (sendOtpBtn) {
                            sendOtpBtn.disabled = false;
                            sendOtpBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                        }
                    }
                });
            }
            
            // Login modal açıldığında form'u temizle
            if (loginModalEl) {
                loginModalEl.addEventListener('show.bs.modal', function() {
                    const loginForm = document.getElementById('loginForm');
                    if (loginForm) {
                        // Form'u reset et - eski bilgileri kaldır
                        loginForm.reset();
                        // Hata mesajlarını temizle
                        const errorAlert = document.getElementById('loginErrorAlert');
                        const errorList = document.getElementById('loginErrorList');
                        if (errorAlert) errorAlert.style.display = 'none';
                        if (errorList) errorList.innerHTML = '';
                        // Input validasyon class'larını temizle
                        loginForm.querySelectorAll('.is-invalid, .is-valid').forEach(el => {
                            el.classList.remove('is-invalid', 'is-valid');
                        });
                    }
                });
            }
            
            // Mobil menü linklerine tıklanınca sayfaya git ve menüyü kapat
            const navbarNav = document.getElementById('navbarNav');
            const navbarToggler = document.querySelector('.navbar-toggler');
            
            if (navbarNav && navbarToggler) {
                // Navbar içindeki tüm linklere event listener ekle
                navbarNav.querySelectorAll('a.nav-link').forEach(link => {
                    link.addEventListener('click', function(e) {
                        const href = this.getAttribute('href');
                        
                        // Eğer hash link ise (örn: #ozellikler)
                        if (href && href.startsWith('#')) {
                            // Smooth scroll yap
                            e.preventDefault();
                            const targetId = href.substring(1);
                            const targetElement = document.getElementById(targetId);
                            
                            if (targetElement) {
                                // Menüyü kapat
                                const bsCollapse = bootstrap.Collapse.getInstance(navbarNav);
                                if (bsCollapse) {
                                    bsCollapse.hide();
                                }
                                
                                // Sayfaya scroll yap
                                setTimeout(() => {
                                    targetElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
                                }, 300);
                            }
                        } else {
                            // Normal link ise menüyü kapat ve sayfaya git
                            const bsCollapse = bootstrap.Collapse.getInstance(navbarNav);
                            if (bsCollapse) {
                                bsCollapse.hide();
                            }
                        }
                    });
                });
            }
        });
        
        // Salon Arama Fonksiyonları
        const citySelect = document.getElementById('salonCitySelect');
        const districtSelect = document.getElementById('salonDistrictSelect');
        const searchBtn = document.getElementById('searchSalonsBtn');
        const resultsDiv = document.getElementById('salonSearchResults');
        const resultsList = document.getElementById('salonResultsList');
        
        // localStorage'dan il/ilçe değerlerini yükle
        const savedCity = localStorage.getItem('selectedCity');
        const savedDistrict = localStorage.getItem('selectedDistrict');
        if (savedCity && citySelect) {
            citySelect.value = savedCity;
            citySelect.dispatchEvent(new Event('change'));
            if (savedDistrict && districtSelect) {
                setTimeout(() => {
                    districtSelect.value = savedDistrict;
                }, 300);
            }
        }
        
        // İl seçildiğinde ilçeleri yükle ve localStorage'a kaydet
        if (citySelect) {
            citySelect.addEventListener('change', function() {
                const selectedCity = this.value;
                if (selectedCity) {
                    localStorage.setItem('selectedCity', selectedCity);
                    districtSelect.disabled = false;
                    districtSelect.innerHTML = '<option value="">İlçe Seçin</option>';
                    
                    // Tüm ilçeler listesi
                    const districts = {
                        'Adana': ['Seyhan', 'Yüreğir', 'Çukurova', 'Sarıçam', 'Karaisalı', 'Aladağ', 'Ceyhan', 'Feke', 'İmamoğlu', 'Karataş', 'Kozan', 'Pozantı', 'Saimbeyli', 'Tufanbeyli', 'Yumurtalık'],
                        'Adıyaman': ['Merkez', 'Besni', 'Çelikhan', 'Gerger', 'Gölbaşı', 'Kahta', 'Samsat', 'Sincik', 'Tut'],
                        'Afyonkarahisar': ['Merkez', 'Başmakçı', 'Bayat', 'Bolvadin', 'Çay', 'Çobanlar', 'Dazkırı', 'Dinar', 'Emirdağ', 'Evciler', 'Hocalar', 'İhsaniye', 'İscehisar', 'Kızılören', 'Sandıklı', 'Sinanpaşa', 'Sultandağı', 'Şuhut'],
                        'Ağrı': ['Merkez', 'Diyadin', 'Doğubayazıt', 'Eleşkirt', 'Hamur', 'Patnos', 'Taşlıçay', 'Tutak'],
                        'Aksaray': ['Merkez', 'Ağaçören', 'Eskil', 'Gülağaç', 'Güzelyurt', 'Ortaköy', 'Sarıyahşi'],
                        'Amasya': ['Merkez', 'Göynücek', 'Gümüşhacıköy', 'Hamamözü', 'Merzifon', 'Suluova', 'Taşova'],
                        'Ankara': ['Çankaya', 'Keçiören', 'Yenimahalle', 'Mamak', 'Sincan', 'Etimesgut', 'Altındağ', 'Pursaklar', 'Gölbaşı', 'Polatlı', 'Çubuk', 'Kahramankazan', 'Beypazarı', 'Elmadağ', 'Şereflikoçhisar', 'Ayaş', 'Bala', 'Nallıhan', 'Haymana', 'Kızılcahamam', 'Kalecik', 'Akyurt', 'Güdül', 'Evren'],
                        'Antalya': ['Muratpaşa', 'Kepez', 'Konyaaltı', 'Alanya', 'Manavgat', 'Serik', 'Kumluca', 'Kaş', 'Finike', 'Demre', 'Kemer', 'Gazipaşa', 'Akseki', 'İbradi', 'Gündoğmuş', 'Elmalı', 'Korkuteli', 'Döşemealtı', 'Aksu'],
                        'Ardahan': ['Merkez', 'Çıldır', 'Damal', 'Göle', 'Hanak', 'Posof'],
                        'Artvin': ['Merkez', 'Ardanuç', 'Arhavi', 'Borçka', 'Hopa', 'Murgul', 'Şavşat', 'Yusufeli'],
                        'Aydın': ['Efeler', 'Nazilli', 'Söke', 'Kuşadası', 'Didim', 'İncirliova', 'Çine', 'Germencik', 'Bozdoğan', 'Kuyucak', 'Sultanhisar', 'Yenipazar', 'Buharkent', 'Karacasu', 'Karpuzlu', 'Koçarlı', 'Köşk'],
                        'Balıkesir': ['Karesi', 'Altıeylül', 'Bandırma', 'Edremit', 'Gönen', 'Ayvalık', 'Burhaniye', 'Dursunbey', 'Erdek', 'Bigadiç', 'Sındırgı', 'Susurluk', 'Havran', 'İvrindi', 'Kepsut', 'Manyas', 'Savaştepe', 'Soma', 'Balya', 'Gömeç', 'Marmara'],
                        'Bartın': ['Merkez', 'Amasra', 'Kurucaşile', 'Ulus'],
                        'Batman': ['Merkez', 'Beşiri', 'Gercüş', 'Hasankeyf', 'Kozluk', 'Sason'],
                        'Bayburt': ['Merkez', 'Aydıntepe', 'Demirözü'],
                        'Bilecik': ['Merkez', 'Bozüyük', 'Gölpazarı', 'İnhisar', 'Osmaneli', 'Pazaryeri', 'Söğüt', 'Yenipazar'],
                        'Bingöl': ['Merkez', 'Adaklı', 'Genç', 'Karlıova', 'Kiğı', 'Solhan', 'Yayladere', 'Yedisu'],
                        'Bitlis': ['Merkez', 'Adilcevaz', 'Ahlat', 'Güroymak', 'Hizan', 'Mutki', 'Tatvan'],
                        'Bolu': ['Merkez', 'Dörtdivan', 'Gerede', 'Göynük', 'Kıbrıscık', 'Mengen', 'Mudurnu', 'Seben', 'Yeniçağa'],
                        'Burdur': ['Merkez', 'Ağlasun', 'Altınyayla', 'Bucak', 'Çavdır', 'Çeltikçi', 'Gölhisar', 'Karamanlı', 'Kemer', 'Tefenni', 'Yeşilova'],
                        'Bursa': ['Osmangazi', 'Nilüfer', 'Yıldırım', 'Mudanya', 'Gemlik', 'İnegöl', 'Mustafakemalpaşa', 'Orhangazi', 'Karacabey', 'Gürsu', 'Kestel', 'Marmaraereğlisi', 'Orhaneli', 'Harmancık', 'Büyükorhan', 'Keles', 'Yenişehir', 'İznik'],
                        'Çanakkale': ['Merkez', 'Ayvacık', 'Bayramiç', 'Biga', 'Bozcaada', 'Çan', 'Eceabat', 'Ezine', 'Gelibolu', 'Gökçeada', 'Lapseki', 'Yenice'],
                        'Çankırı': ['Merkez', 'Atkaracalar', 'Bayramören', 'Çerkeş', 'Eldivan', 'Ilgaz', 'Kızılırmak', 'Korgun', 'Kurşunlu', 'Orta', 'Şabanözü', 'Yapraklı'],
                        'Çorum': ['Merkez', 'Alaca', 'Bayat', 'Boğazkale', 'Dodurga', 'İskilip', 'Kargı', 'Laçin', 'Mecitözü', 'Oğuzlar', 'Ortaköy', 'Osmancık', 'Sungurlu', 'Uğurludağ'],
                        'Denizli': ['Pamukkale', 'Merkezefendi', 'Çivril', 'Tavas', 'Acıpayam', 'Buldan', 'Çal', 'Çameli', 'Çardak', 'Güney', 'Honaz', 'Kale', 'Sarayköy', 'Serinhisar', 'Babadağ', 'Bekilli', 'Beyağaç', 'Bozkurt'],
                        'Diyarbakır': ['Bağlar', 'Kayapınar', 'Sur', 'Yenişehir', 'Bismil', 'Çermik', 'Çınar', 'Çüngüş', 'Dicle', 'Eğil', 'Ergani', 'Hani', 'Hazro', 'Kocaköy', 'Kulp', 'Lice', 'Silvan'],
                        'Düzce': ['Merkez', 'Akçakoca', 'Cumayeri', 'Çilimli', 'Gölyaka', 'Gümüşova', 'Kaynaşlı', 'Yığılca'],
                        'Edirne': ['Merkez', 'Enez', 'Havsa', 'İpsala', 'Keşan', 'Lalapaşa', 'Meriç', 'Süloğlu', 'Uzunköprü'],
                        'Elazığ': ['Merkez', 'Ağın', 'Alacakaya', 'Arıcak', 'Baskil', 'Karakoçan', 'Keban', 'Kovancılar', 'Maden', 'Palu', 'Sivrice'],
                        'Erzincan': ['Merkez', 'Çayırlı', 'İliç', 'Kemah', 'Kemaliye', 'Otlukbeli', 'Refahiye', 'Tercan', 'Üzümlü'],
                        'Erzurum': ['Yakutiye', 'Palandöken', 'Aziziye', 'Aşkale', 'Çat', 'Hınıs', 'Horasan', 'İspir', 'Karaçoban', 'Karayazı', 'Köprüköy', 'Narman', 'Oltu', 'Olur', 'Pasinler', 'Şenkaya', 'Tekman', 'Tortum', 'Uzundere'],
                        'Eskişehir': ['Odunpazarı', 'Tepebaşı', 'Alpu', 'Beylikova', 'Çifteler', 'Günyüzü', 'Han', 'İnönü', 'Mahmudiye', 'Mihalgazi', 'Mihalıççık', 'Sarıcakaya', 'Seyitgazi', 'Sivrihisar'],
                        'Gaziantep': ['Şahinbey', 'Şehitkamil', 'Oğuzeli', 'Araban', 'İslahiye', 'Karkamış', 'Nizip', 'Nurdağı', 'Yavuzeli'],
                        'Giresun': ['Merkez', 'Alucra', 'Bulancak', 'Çamoluk', 'Çanakçı', 'Dereli', 'Doğankent', 'Espiye', 'Eynesil', 'Görele', 'Güce', 'Keşap', 'Piraziz', 'Şebinkarahisar', 'Tirebolu', 'Yağlıdere'],
                        'Gümüşhane': ['Merkez', 'Kelkit', 'Köse', 'Kürtün', 'Şiran', 'Torul'],
                        'Hakkari': ['Merkez', 'Çukurca', 'Şemdinli', 'Yüksekova'],
                        'Hatay': ['Antakya', 'Defne', 'İskenderun', 'Dörtyol', 'Kırıkhan', 'Reyhanlı', 'Samandağ', 'Yayladağı', 'Altınözü', 'Belen', 'Erzin', 'Hassa', 'Kumlu', 'Payas'],
                        'Iğdır': ['Merkez', 'Aralık', 'Karakoyunlu', 'Tuzluca'],
                        'Isparta': ['Merkez', 'Aksu', 'Atabey', 'Eğirdir', 'Gelendost', 'Gönen', 'Keçiborlu', 'Senirkent', 'Sütçüler', 'Şarkikaraağaç', 'Uluborlu', 'Yalvaç', 'Yenişarbademli'],
                        'İstanbul': ['Adalar', 'Arnavutköy', 'Ataşehir', 'Avcılar', 'Bağcılar', 'Bahçelievler', 'Bakırköy', 'Başakşehir', 'Bayrampaşa', 'Beşiktaş', 'Beykoz', 'Beylikdüzü', 'Beyoğlu', 'Büyükçekmece', 'Çatalca', 'Çekmeköy', 'Esenler', 'Esenyurt', 'Eyüpsultan', 'Fatih', 'Gaziosmanpaşa', 'Güngören', 'Kadıköy', 'Kağıthane', 'Kartal', 'Küçükçekmece', 'Maltepe', 'Pendik', 'Sancaktepe', 'Sarıyer', 'Silivri', 'Sultanbeyli', 'Sultangazi', 'Şile', 'Şişli', 'Tuzla', 'Ümraniye', 'Üsküdar', 'Zeytinburnu'],
                        'İzmir': ['Konak', 'Bornova', 'Karşıyaka', 'Buca', 'Çiğli', 'Gaziemir', 'Bayraklı', 'Balçova', 'Narlıdere', 'Güzelbahçe', 'Urla', 'Seferihisar', 'Foça', 'Aliağa', 'Menemen', 'Bergama', 'Dikili', 'Kınık', 'Torbalı', 'Menderes', 'Selçuk', 'Tire', 'Bayındır', 'Ödemiş', 'Beydağ', 'Kiraz'],
                        'Kahramanmaraş': ['Onikişubat', 'Dulkadiroğlu', 'Afşin', 'Andırın', 'Çağlayancerit', 'Ekinözü', 'Elbistan', 'Göksun', 'Nurhak', 'Pazarcık', 'Türkoğlu'],
                        'Karabük': ['Merkez', 'Eflani', 'Eskipazar', 'Ovacık', 'Safranbolu', 'Yenice'],
                        'Karaman': ['Merkez', 'Ayrancı', 'Başyayla', 'Ermenek', 'Kazımkarabekir', 'Sarıveliler'],
                        'Kars': ['Merkez', 'Akyaka', 'Arpaçay', 'Digor', 'Kağızman', 'Sarıkamış', 'Selim', 'Susuz'],
                        'Kastamonu': ['Merkez', 'Abana', 'Ağlı', 'Araç', 'Azdavay', 'Bozkurt', 'Cide', 'Çatalzeytin', 'Daday', 'Devrekani', 'Doğanyurt', 'Hanönü', 'İhsangazi', 'İnebolu', 'Küre', 'Pınarbaşı', 'Seydiler', 'Şenpazar', 'Taşköprü', 'Tosya'],
                        'Kayseri': ['Melikgazi', 'Kocasinan', 'Talas', 'İncesu', 'Pınarbaşı', 'Sarıoğlan', 'Sarız', 'Tomarza', 'Yahyalı', 'Yeşilhisar', 'Akkışla', 'Bünyan', 'Develi', 'Felahiye', 'Hacılar', 'Özvatan'],
                        'Kilis': ['Merkez', 'Elbeyli', 'Musabeyli', 'Polateli'],
                        'Kırıkkale': ['Merkez', 'Bahşılı', 'Balışeyh', 'Çelebi', 'Delice', 'Karakeçili', 'Keskin', 'Sulakyurt', 'Yahşihan'],
                        'Kırklareli': ['Merkez', 'Babaeski', 'Demirköy', 'Kofçaz', 'Lüleburgaz', 'Pehlivanköy', 'Pınarhisar', 'Vize'],
                        'Kırşehir': ['Merkez', 'Akçakent', 'Akpınar', 'Boztepe', 'Çiçekdağı', 'Kaman', 'Mucur'],
                        'Kocaeli': ['İzmit', 'Gebze', 'Darıca', 'Körfez', 'Gölcük', 'Karamürsel', 'Kandıra', 'Başiskele', 'Çayırova', 'Dilovası', 'Kartepe'],
                        'Konya': ['Selçuklu', 'Karatay', 'Meram', 'Akşehir', 'Beyşehir', 'Bozkır', 'Cihanbeyli', 'Çeltik', 'Çumra', 'Derbent', 'Derebucak', 'Doğanhisar', 'Emirgazi', 'Ereğli', 'Güneysinir', 'Hadim', 'Halkapınar', 'Hüyük', 'Ilgın', 'Kadınhanı', 'Karapınar', 'Kulu', 'Sarayönü', 'Seydişehir', 'Taşkent', 'Tuzlukçu', 'Yalıhüyük', 'Yunak'],
                        'Kütahya': ['Merkez', 'Altıntaş', 'Aslanapa', 'Çavdarhisar', 'Domaniç', 'Dumlupınar', 'Emet', 'Gediz', 'Hisarcık', 'Pazarlar', 'Simav', 'Şaphane', 'Tavşanlı'],
                        'Malatya': ['Battalgazi', 'Yeşilyurt', 'Akçadağ', 'Arapgir', 'Arguvan', 'Darende', 'Doğanşehir', 'Doğanyol', 'Hekimhan', 'Kale', 'Kuluncak', 'Pütürge', 'Yazıhan'],
                        'Manisa': ['Şehzadeler', 'Yunusemre', 'Ahmetli', 'Akhisar', 'Alaşehir', 'Demirci', 'Gölmarmara', 'Gördes', 'Kırkağaç', 'Köprübaşı', 'Kula', 'Salihli', 'Sarıgöl', 'Saruhanlı', 'Selendi', 'Soma', 'Turgutlu'],
                        'Mardin': ['Artuklu', 'Dargeçit', 'Derik', 'Kızıltepe', 'Mazıdağı', 'Midyat', 'Nusaybin', 'Ömerli', 'Savur', 'Yeşilli'],
                        'Mersin': ['Akdeniz', 'Mezitli', 'Yenişehir', 'Toroslar', 'Anamur', 'Aydıncık', 'Bozyazı', 'Çamlıyayla', 'Erdemli', 'Gülnar', 'Mut', 'Silifke', 'Tarsus'],
                        'Muğla': ['Menteşe', 'Bodrum', 'Dalaman', 'Datça', 'Fethiye', 'Kavaklıdere', 'Köyceğiz', 'Marmaris', 'Milas', 'Ortaca', 'Ula', 'Yatağan'],
                        'Muş': ['Merkez', 'Bulanık', 'Hasköy', 'Korkut', 'Malazgirt', 'Varto'],
                        'Nevşehir': ['Merkez', 'Acıgöl', 'Avanos', 'Derinkuyu', 'Gülşehir', 'Hacıbektaş', 'Kozaklı', 'Ürgüp'],
                        'Niğde': ['Merkez', 'Altunhisar', 'Bor', 'Çamardı', 'Çiftlik', 'Ulukışla'],
                        'Ordu': ['Altınordu', 'Akkuş', 'Aybastı', 'Çamaş', 'Çatalpınar', 'Çaybaşı', 'Fatsa', 'Gölköy', 'Gülyalı', 'Gürgentepe', 'İkizce', 'Kabadüz', 'Kabataş', 'Korgan', 'Kumru', 'Mesudiye', 'Perşembe', 'Ulubey', 'Ünye'],
                        'Osmaniye': ['Merkez', 'Bahçe', 'Düziçi', 'Hasanbeyli', 'Kadirli', 'Sumbas', 'Toprakkale'],
                        'Rize': ['Merkez', 'Ardeşen', 'Çamlıhemşin', 'Çayeli', 'Derepazarı', 'Fındıklı', 'Güneysu', 'Hemşin', 'İkizdere', 'İyidere', 'Kalkandere', 'Pazar'],
                        'Sakarya': ['Adapazarı', 'Akyazı', 'Arifiye', 'Erenler', 'Ferizli', 'Geyve', 'Hendek', 'Karapürçek', 'Karasu', 'Kaynarca', 'Kocaali', 'Pamukova', 'Sapanca', 'Serdivan', 'Söğütlü', 'Taraklı'],
                        'Samsun': ['İlkadım', 'Atakum', 'Canik', 'Tekkeköy', 'Alaçam', 'Asarcık', 'Ayvacık', 'Bafra', 'Çarşamba', 'Havza', 'Kavak', 'Ladik', 'Ondokuzmayıs', 'Salıpazarı', 'Terme', 'Vezirköprü', 'Yakakent'],
                        'Siirt': ['Merkez', 'Baykan', 'Eruh', 'Kurtalan', 'Pervari', 'Şirvan', 'Tillo'],
                        'Sinop': ['Merkez', 'Ayancık', 'Boyabat', 'Dikmen', 'Durağan', 'Erfelek', 'Gerze', 'Saraydüzü', 'Türkeli'],
                        'Sivas': ['Merkez', 'Akıncılar', 'Altınyayla', 'Divriği', 'Doğanşar', 'Gemerek', 'Gölova', 'Gürün', 'Hafik', 'İmranlı', 'Kangal', 'Koyulhisar', 'Şarkışla', 'Suşehri', 'Ulaş', 'Yıldızeli', 'Zara'],
                        'Şanlıurfa': ['Eyyübiye', 'Haliliye', 'Karaköprü', 'Akçakale', 'Birecik', 'Bozova', 'Ceylanpınar', 'Halfeti', 'Harran', 'Hilvan', 'Siverek', 'Suruç', 'Viranşehir'],
                        'Şırnak': ['Merkez', 'Beytüşşebap', 'Cizre', 'Güçlükonak', 'İdil', 'Silopi', 'Uludere'],
                        'Tekirdağ': ['Süleymanpaşa', 'Çerkezköy', 'Çorlu', 'Ergene', 'Hayrabolu', 'Kapaklı', 'Malkara', 'Marmaraereğlisi', 'Muratlı', 'Saray', 'Şarköy'],
                        'Tokat': ['Merkez', 'Almus', 'Artova', 'Başçiftlik', 'Erbaa', 'Niksar', 'Pazar', 'Reşadiye', 'Sulusaray', 'Turhal', 'Yeşilyurt', 'Zile'],
                        'Trabzon': ['Ortahisar', 'Akçaabat', 'Araklı', 'Arsin', 'Beşikdüzü', 'Çarşıbaşı', 'Çaykara', 'Dernekpazarı', 'Düzköy', 'Hayrat', 'Köprübaşı', 'Maçka', 'Of', 'Şalpazarı', 'Sürmene', 'Tonya', 'Vakfıkebir', 'Yomra'],
                        'Tunceli': ['Merkez', 'Çemişgezek', 'Hozat', 'Mazgirt', 'Nazımiye', 'Ovacık', 'Pertek', 'Pülümür'],
                        'Uşak': ['Merkez', 'Banaz', 'Eşme', 'Karahallı', 'Sivaslı', 'Ulubey'],
                        'Van': ['İpekyolu', 'Tuşba', 'Edremit', 'Bahçesaray', 'Başkale', 'Çaldıran', 'Çatak', 'Erciş', 'Gevaş', 'Gürpınar', 'Muradiye', 'Özalp', 'Saray'],
                        'Yalova': ['Merkez', 'Altınova', 'Armutlu', 'Çınarcık', 'Çiftlikköy', 'Termal'],
                        'Yozgat': ['Merkez', 'Akdağmadeni', 'Aydıncık', 'Boğazlıyan', 'Çandır', 'Çayıralan', 'Çekerek', 'Kadışehri', 'Saraykent', 'Sarıkaya', 'Sorgun', 'Şefaatli', 'Yerköy', 'Yenifakılı'],
                        'Zonguldak': ['Merkez', 'Alaplı', 'Çaycuma', 'Devrek', 'Gökçebey', 'Kilimli', 'Kozlu']
                    };
                    
                    const cityDistricts = districts[selectedCity] || [];
                    cityDistricts.forEach(district => {
                        const option = document.createElement('option');
                        option.value = district;
                        option.textContent = district;
                        if (savedDistrict && district === savedDistrict) {
                            option.selected = true;
                        }
                        districtSelect.appendChild(option);
                    });
                } else {
                    localStorage.removeItem('selectedCity');
                    localStorage.removeItem('selectedDistrict');
                    districtSelect.disabled = true;
                    districtSelect.innerHTML = '<option value="">Önce il seçin</option>';
                }
            });
        }
        
        // İlçe seçildiğinde localStorage'a kaydet
        if (districtSelect) {
            districtSelect.addEventListener('change', function() {
                const selectedDistrict = this.value;
                if (selectedDistrict) {
                    localStorage.setItem('selectedDistrict', selectedDistrict);
                } else {
                    localStorage.removeItem('selectedDistrict');
                }
            });
        }
        
        // Arama butonu
        if (searchBtn) {
            searchBtn.addEventListener('click', function() {
                const city = citySelect?.value || '';
                const district = districtSelect?.value || '';
                
                if (!city) {
                    alert('Lütfen il seçin');
                    return;
                }
                
                // Loading state
                searchBtn.disabled = true;
                searchBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Aranıyor...';
                resultsList.innerHTML = '<div style="text-align: center; padding: 20px; color: #64748b;">Yükleniyor...</div>';
                resultsDiv.style.display = 'block';
                
                // Gerçek salonları API'den çek
                const searchUrl = `{{ url('/api/salons/search') }}?city=${encodeURIComponent(city)}${district ? '&district=' + encodeURIComponent(district) : ''}`;
                
                fetch(searchUrl)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        return response.json();
                    })
                    .then(data => {
                        searchBtn.disabled = false;
                        searchBtn.innerHTML = '<i class="bi bi-search me-2"></i>Salon Ara';
                        
                        if (data.error) {
                            console.error('API Error:', data.error);
                            resultsList.innerHTML = '<div style="text-align: center; padding: 20px; color: #ef4444;">' + data.error + '</div>';
                            return;
                        }
                        
                        const salons = data.salons || [];
                        resultsList.innerHTML = '';
                        
                        if (salons.length === 0) {
                            resultsList.innerHTML = '<div style="text-align: center; padding: 20px; color: #64748b;">Bu bölgede salon bulunamadı.</div>';
                            return;
                        }
                        
                        salons.forEach(salon => {
                            const salonItem = document.createElement('div');
                            salonItem.style.cssText = 'padding: 16px; margin-bottom: 12px; background: #f8fafc; border-radius: 8px; border: 1px solid #e2e8f0; cursor: pointer; transition: all 0.2s ease;';
                            salonItem.onmouseenter = function() {
                                this.style.background = '#f1f5f9';
                                this.style.borderColor = '#cbd5e1';
                            };
                            salonItem.onmouseleave = function() {
                                this.style.background = '#f8fafc';
                                this.style.borderColor = '#e2e8f0';
                            };
                            if (salon.slug) {
                                salonItem.onclick = function() {
                                    window.location.href = `/salon/${salon.slug}`;
                                };
                            }
                            salonItem.innerHTML = `
                                <div style="display: flex; justify-content: space-between; align-items: start;">
                                    <div style="flex: 1;">
                                        <h5 style="font-size: 1rem; font-weight: 700; color: #1e293b; margin-bottom: 4px;">${salon.name}</h5>
                                        <p style="font-size: 0.875rem; color: #64748b; margin: 0 0 4px 0;">
                                            <i class="bi bi-geo-alt-fill me-1"></i>${salon.district || salon.city}, ${salon.city}
                                        </p>
                                        ${salon.address ? `<p style="font-size: 0.8rem; color: #94a3b8; margin: 0;">${salon.address}</p>` : ''}
                                        ${salon.phone ? `<p style="font-size: 0.8rem; color: #94a3b8; margin: 4px 0 0 0;"><i class="bi bi-telephone me-1"></i>${salon.phone}</p>` : ''}
                                    </div>
                                    <div style="text-align: right; margin-left: 12px;">
                                        <div style="font-size: 0.875rem; font-weight: 700; color: #f59e0b;">
                                            <i class="bi bi-star-fill"></i> 4.5
                                        </div>
                                    </div>
                                </div>
                            `;
                            resultsList.appendChild(salonItem);
                        });
                    })
                    .catch(error => {
                        console.error('Error searching salons:', error);
                        searchBtn.disabled = false;
                        searchBtn.innerHTML = '<i class="bi bi-search me-2"></i>Salon Ara';
                        resultsList.innerHTML = '<div style="text-align: center; padding: 20px; color: #ef4444;">Arama sırasında bir hata oluştu. Lütfen tekrar deneyin.</div>';
                    });
            });
        }
    </script>
    
    <style>
        /* Browser Mockup Styles */
        .browser-mockup {
            box-shadow: 0 20px 60px rgba(0,0,0,0.2);
            border-radius: 8px;
            overflow: hidden;
        }
        
        @media (max-width: 991px) {
            .hero .row {
                flex-direction: column;
            }
            .hero .col-lg-6.order-1 {
                margin-bottom: 2rem;
            }
            .hero .col-lg-6.order-2 {
                margin-bottom: 2rem;
            }
            .references.order-lg-3 {
                order: 3;
            }
            
            .browser-mockup {
                max-width: 100%;
                margin-top: 2rem;
            }
            
            .browser-content {
                min-height: 350px !important;
                padding: 20px !important;
            }
        }
    </style>
</body>
</html>
