@php
    // Sözleşmeler, Faturalar, Hizmetler ve Odalar sayfalarında sidebar kapalı kalsın
    $excludedFromSidebar = request()->routeIs('admin.settings.contracts.*') 
        || request()->routeIs('admin.settings.invoices.*')
        || request()->routeIs('admin.settings.services.*')
        || request()->routeIs('admin.services.*')
        || request()->routeIs('admin.rooms.*')
        || request()->routeIs('admin.beauty-salon.services.*')
        || request()->routeIs('admin.beauty-salon.rooms.*');
    
    // Premium özellikler sayfalarında da sidebar açık kalsın
    $isPremiumFeaturePage = request()->routeIs('admin.beauty-salon.loyalty.*')
        || request()->routeIs('admin.beauty-salon.referrals.*')
        || request()->routeIs('admin.beauty-salon.branches.*')
        || request()->routeIs('admin.beauty-salon.staff-performance.*')
        || request()->routeIs('admin.beauty-salon.smart-discount.*')
        || request()->routeIs('admin.beauty-salon.customer-directory.*')
        || request()->routeIs('admin.beauty-salon.profile*')
        || request()->routeIs('admin.account.*');

    $hasPendingPackagePayment = false;
    if (auth()->check() && !auth()->user()->isSuperAdmin()) {
        $hasPendingPackagePayment = \App\Models\Transaction::where('user_id', auth()->id())
            ->where('type', 'income')
            ->where('status', 'pending')
            ->where('payment_method', 'bank_transfer')
            ->where('payment_reference', 'like', 'PKG_%')
            ->exists();
    }

    $isSettingsPage = (request()->routeIs('admin.settings.*') && !$excludedFromSidebar) || $isPremiumFeaturePage;

    $showFreeCampaignBanner = false;
    $freeCampaignDaysLeft = null;
    $freeCampaignEndDate = null;
    if (auth()->check() && auth()->user()->role === 'güzellik_salonu' && auth()->user()->free_access_ends_at) {
        $campaignEnd = \Carbon\Carbon::parse(auth()->user()->free_access_ends_at);
        if (now()->lt($campaignEnd)) {
            $freeCampaignDaysLeft = now()->diffInDays($campaignEnd) + 1;
            $freeCampaignEndDate = $campaignEnd->format('d.m.Y');
            // Sadece kampanya bitimine 30 gün kala görünür.
            $showFreeCampaignBanner = $freeCampaignDaysLeft <= 30;
        }
    }
@endphp
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Salonay')</title>
    @include('partials.google-ads-tag')
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('favicon.png') }}?v=4">
    <link rel="shortcut icon" href="{{ asset('favicon.png') }}?v=4">
    <link rel="apple-touch-icon" href="{{ asset('favicon.png') }}?v=4">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600;700;800;900&family=Montserrat:wght@700;800;900&display=swap" rel="stylesheet">
    <style>
        
        /* Responsive görünüm için header'ı her zaman göster */
        /* Mobile App için header gizleme kaldırıldı - artık responsive site görünümü */
        
        /* Özel Onay Kutusu - Modal'lardan yüksek */
        #customConfirmBox {
            z-index: 999999 !important;
        }
        
        #customConfirmBackdrop {
            z-index: 999998 !important;
        }
        
        .header-logo {
            height: 40px;
            width: auto;
            filter: none;
            opacity: 1;
        }
        
        .logo-image {
            height: 40px;
            width: auto;
            object-fit: contain;
            filter: invert(1) brightness(1.3) contrast(1.1);
            opacity: 1;
        }
        
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        
        .logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 32px;
            letter-spacing: 2px;
            background: linear-gradient(135deg, #ffffff 0%, #fce7f3 30%, #fbcfe8 60%, #ffffff 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradient 3s ease infinite;
            padding: 4px 12px;
            border-radius: 12px;
            overflow: hidden;
        }
        
        .logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.6s ease;
        }
        
        .logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 2px;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.4s ease;
        }
        
        .logo-text:hover {
            transform: scale(1.08) translateY(-2px);
            letter-spacing: 3px;
            animation-duration: 1.5s;
        }
        
        .logo-text:hover::before {
            left: 100%;
        }
        
        .logo-text:hover::after {
            transform: scaleX(1);
        }
        
        @keyframes logoGradient {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        @keyframes logoShine {
            0% {
                transform: translateX(-100%);
            }
            100% {
                transform: translateX(100%);
            }
        }
        :root {
            --primary-color: #ec4899;
            --secondary-color: #be185d;
            --bg-color: #fce7f3;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --header-top-height: 58px;
            --header-bottom-height: 50px;
            --header-height: calc(var(--header-top-height) + var(--header-bottom-height));
            --navbar-height: 0px; /* Beyaz navbar kaldırıldı */
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-color);
            color: var(--text-primary);
            padding-top: var(--header-height) !important; /* Sadece header yüksekliği */
        }
        
        /* Main content'in header'ın altında kalmaması için */
        .main-content {
            padding-top: 0 !important;
            margin-top: 0 !important;
        }
        
        /* Mobil görünümde sayfaların header'ın altında kalmaması için */
        @media (max-width: 1024px) {
            body {
                padding-top: 108px !important; /* Mobil header yüksekliği */
            }
            
            .main-content {
                padding-top: 20px !important;
                margin-top: 0 !important;
            }
            
            .container-fluid {
                padding-top: 0 !important;
            }
        }

        /* Top Header - İki Katmanlı Tasarım */
        .top-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: var(--header-height);
            background: transparent;
            border-bottom: none;
            z-index: 10000;
            display: flex;
            flex-direction: column;
        }
        
        /* Header içindeki dropdown'lar header'ın üstünde görünmeli */
        .top-header .dropdown-menu.show,
        .top-header .search-results.show {
            z-index: 999999 !important;
        }
        
        /* Üst Katman - Premium Mavi Tema */
        .header-top {
            height: var(--header-top-height);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 28px;
            background: linear-gradient(135deg, #be185d 0%, #ec4899 50%, #f472b6 100%);
            border-bottom: 1px solid rgba(255, 255, 255, 0.15);
            box-shadow: 0 2px 12px rgba(190, 24, 93, 0.2);
        }
        
        /* Alt Katman - Beyaz Tema */
        .header-bottom {
            height: var(--header-bottom-height);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0 28px;
            background: #ffffff;
            border-bottom: 1px solid #e5e7eb;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .header-menu {
            display: flex;
            align-items: center;
            gap: 4px;
            flex: 1;
            justify-content: center;
            overflow-x: auto;
            overflow-y: hidden;
            scrollbar-width: none;
            -ms-overflow-style: none;
            height: 100%;
        }
        
        .header-menu::-webkit-scrollbar {
            display: none;
        }

        .top-header .header-left {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .header-top .header-left .logo-text,
        .header-top .logo-text {
            margin: 0;
            font-family: 'LogoFont', 'Inter', sans-serif !important;
            font-size: 28px;
            font-weight: normal;
            color: #ffffff;
            letter-spacing: 1px;
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
            position: relative;
            z-index: 1;
        }

        .header-top .header-right {
            display: flex;
            align-items: center;
            gap: 12px;
            position: relative;
            z-index: 100;
        }
        
        /* SMS Al butonu - icon ile text arası mesafe */
        .sms-buy-btn {
            gap: 10px !important;
        }
        
        .sms-buy-btn i {
            margin-right: 0 !important;
        }
        
        .sms-buy-btn span {
            margin-left: 0 !important;
        }
        
        .header-top .header-right .dropdown {
            position: static !important;
        }
        
        .header-top .header-right .user-menu {
            position: static !important;
        }
        
        /* Bootstrap dropdown'ları için z-index düzeltmesi */
        .header-top .header-right .dropdown-menu {
            z-index: 999999 !important;
            position: fixed !important;
            margin-top: 8px !important;
        }
        
        .header-top .header-right .dropdown.show .dropdown-menu {
            z-index: 999999 !important;
        }
        
        /* User dropdown için de aynı - En üstte olmalı */
        .header-top .header-right .user-dropdown {
            z-index: 999999 !important;
            margin-top: 8px !important;
        }
        
        /* Şimşek düğmesi dropdown menüsü için yüksek z-index */
        .btn-group .dropdown-menu {
            z-index: 10001 !important;
        }
        
        /* Bugünkü Randevular Dropdown - Düzgün çalışacak şekilde ayarlandı */
        #todayAppointmentsDropdown,
        #todayAppointmentsDropdownPersonel {
            position: relative;
        }
        
        #todayAppointmentsDropdown .dropdown-menu,
        #todayAppointmentsDropdownPersonel .dropdown-menu {
            border-radius: 12px;
            border: none;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
            padding: 0;
            margin-top: 8px;
            position: absolute !important;
            top: 100% !important;
            right: 0 !important;
            left: auto !important;
            z-index: 1000;
            display: none;
            min-width: 350px;
            max-height: 500px;
            overflow-y: auto;
            transform: none !important;
            transition: none !important;
            animation: none !important;
            opacity: 1 !important;
            visibility: hidden;
        }
        
        @media (max-width: 768px) {
            #todayAppointmentsDropdown .dropdown-menu,
            #todayAppointmentsDropdownPersonel .dropdown-menu {
                position: fixed !important;
                left: 12px !important;
                right: 12px !important;
                width: auto !important;
                min-width: auto !important;
                max-width: calc(100% - 24px) !important;
                top: 64px !important;
                margin-top: 0 !important;
                max-height: calc(100vh - 80px) !important;
                z-index: 100005 !important;
            }
        }
        
        #todayAppointmentsDropdown .dropdown-menu.show,
        #todayAppointmentsDropdownPersonel .dropdown-menu.show {
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
            transform: none !important;
        }
        
        /* Bootstrap dropdown animasyonlarını tamamen kaldır */
        #todayAppointmentsDropdown .dropdown-menu[data-bs-popper],
        #todayAppointmentsDropdownPersonel .dropdown-menu[data-bs-popper] {
            position: absolute !important;
            top: 100% !important;
            right: 0 !important;
            left: auto !important;
            margin-top: 8px !important;
            transform: none !important;
            will-change: auto !important;
        }
        
        /* Bootstrap'in show class'ı eklendiğinde */
        #todayAppointmentsDropdown.show .dropdown-menu,
        #todayAppointmentsDropdownPersonel.show .dropdown-menu {
            display: block !important;
            visibility: visible !important;
        }
        
        #todayAppointmentsDropdown .list-group-item,
        #todayAppointmentsDropdownPersonel .list-group-item {
            border-left: 3px solid transparent;
            transition: all 0.2s;
        }
        
        #todayAppointmentsDropdown .list-group-item:hover,
        #todayAppointmentsDropdownPersonel .list-group-item:hover {
            border-left-color: #ec4899;
            background: #f8f9fa !important;
        }
        
        #todayAppointmentsDropdown .badge,
        #todayAppointmentsDropdownPersonel .badge {
            font-weight: 600;
        }

        .header-top .header-center {
            flex: 1;
            max-width: 500px;
            margin: 0 24px;
            position: relative;
            z-index: 100;
        }
        
        .header-top .header-center .search-container {
            position: relative;
            z-index: 100;
        }

        .search-container {
            position: relative;
        }

        .search-input {
            width: 100%;
            padding: 10px 45px 10px 16px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.15);
            color: white;
            font-size: 14px;
            transition: all 0.3s;
            backdrop-filter: blur(10px);
        }
        
        .search-input::placeholder {
            color: rgba(255, 255, 255, 0.9);
        }

        .search-input:focus {
            outline: none;
            border-color: rgba(255, 255, 255, 0.5);
            background: rgba(255, 255, 255, 0.25);
            box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.1);
            transform: translateY(-1px);
        }
        
        .search-icon {
            color: rgba(255, 255, 255, 0.8) !important;
        }
        
        .search-input:focus + .search-icon {
            color: white !important;
        }

        .search-icon {
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.8);
            pointer-events: none;
            transition: all 0.3s ease;
            font-size: 18px;
        }
        
        .search-input:focus + .search-icon {
            color: #ffffff;
            transform: translateY(-50%) scale(1.1);
        }

        .search-results {
            position: absolute;
            top: calc(100% + 10px);
            left: 0;
            right: 0;
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.25);
            max-height: 500px;
            overflow-y: auto;
            z-index: 999999 !important; /* Arama sonuçları en üstte */
            display: none;
            border: 1px solid #e5e7eb;
        }

        .search-results.show {
            display: block;
        }

        .search-result-item {
            padding: 12px 20px;
            border-bottom: 1px solid #f1f5f9;
            cursor: pointer;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .search-result-item:hover {
            background: #fce7f3;
        }

        .search-result-item:last-child {
            border-bottom: none;
        }

        .search-result-icon {
            width: 36px;
            height: 36px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #fce7f3;
            color: #ec4899;
            font-size: 18px;
        }

        .search-result-content {
            flex: 1;
        }

        .search-result-title {
            font-weight: 600;
            color: #1e293b;
            font-size: 14px;
            margin-bottom: 2px;
        }

        .search-result-subtitle {
            font-size: 12px;
            color: #64748b;
        }

        .search-result-type {
            font-size: 11px;
            color: #64748b;
            background: #f1f5f9;
            padding: 2px 8px;
            border-radius: 4px;
        }

        .search-section-title {
            padding: 10px 20px;
            background: #fce7f3;
            font-weight: 600;
            font-size: 12px;
            color: #64748b;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .header-top .shortcuts-container {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-right: 12px;
        }

        .shortcut-item {
            width: 42px;
            height: 42px;
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }
        
        .shortcut-item::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .shortcut-item i {
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: white;
            font-size: 18px;
        }

        .shortcut-item:hover {
            background: rgba(255, 255, 255, 0.25);
            border-color: rgba(255, 255, 255, 0.35);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }
        
        .shortcut-item:hover::before {
            opacity: 1;
        }
        
        .shortcut-item:hover i {
            color: white;
            transform: scale(1.15);
        }
        
        /* Premium Features Button */
        .premium-features-btn {
            position: relative;
        }
        
        .premium-badge {
            position: absolute;
            top: -4px;
            right: -4px;
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 10px;
            font-weight: 700;
            border: 2px solid white;
            box-shadow: 0 2px 6px rgba(251, 191, 36, 0.4);
        }
        
        /* Premium Modal Items */
        .premium-modal-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 1.5rem 1rem;
            background: white;
            border-radius: 12px;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 2px solid transparent;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
            height: 100%;
            min-height: 140px;
        }
        
        .premium-modal-item:hover {
            transform: translateY(-5px) scale(1.02);
            box-shadow: 0 8px 20px rgba(236, 72, 153, 0.2);
            border-color: #ec4899;
            text-decoration: none;
        }
        
        .premium-modal-item.active {
            border-color: #ec4899;
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        }
        
        .premium-modal-icon {
            width: 56px;
            height: 56px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.75rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .premium-modal-item:hover .premium-modal-icon {
            transform: scale(1.1) rotate(5deg);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
        }
        
        .premium-modal-icon i {
            font-size: 24px;
        }
        
        .premium-modal-title {
            font-size: 0.875rem;
            font-weight: 600;
            color: #1e293b;
            text-align: center;
            line-height: 1.3;
            transition: color 0.3s ease;
        }
        
        .premium-modal-item:hover .premium-modal-title {
            color: #ec4899;
        }

        .top-header .btn,
        .header-top .btn {
            background: rgba(255, 255, 255, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: white;
            padding: 10px 18px;
            border-radius: 10px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-weight: 500;
            font-size: 14px;
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }
        
        .top-header .btn::before,
        .header-top .btn::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .top-header .btn:hover,
        .header-top .btn:hover {
            background: rgba(255, 255, 255, 0.25);
            border-color: rgba(255, 255, 255, 0.35);
            transform: translateY(-1px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }
        
        .top-header .btn:hover::before,
        .header-top .btn:hover::before {
            opacity: 1;
        }
        
        .header-top .btn i,
        .header-top .btn span {
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: white;
        }

        .header-top .btn:hover {
            border-color: #f472b6;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(244, 114, 182, 0.15);
            background: #fce7f3;
        }
        
        .header-top .btn:hover i,
        .header-top .btn:hover span {
            color: #db2777;
        }

        /* Main Navbar - KALDIRILDI, menü header içine entegre edildi */
        .main-navbar {
            display: none !important;
        }
        
        /* Header Menu - Mavi Tema */
        .header-menu {
            display: flex;
            align-items: center;
            gap: 4px;
            flex: 1;
            justify-content: center;
            overflow-x: auto;
            overflow-y: hidden;
            scrollbar-width: none;
            -ms-overflow-style: none;
            height: 100%;
        }
        
        .header-menu::-webkit-scrollbar {
            display: none;
        }
        
        .header-menu-item {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 18px;
            color: #64748b;
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            white-space: nowrap;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 8px;
            background: transparent;
            position: relative;
            height: calc(100% - 8px);
            margin: 4px 2px;
        }
        
        .header-menu-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: #f1f5f9;
            opacity: 0;
            transition: opacity 0.3s ease;
            border-radius: 8px;
        }
        
        .header-menu-item i {
            font-size: 16px;
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: #64748b;
        }
        
        .header-menu-item span {
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
            color: #64748b;
        }
        
        .header-menu-item:hover {
            color: #ec4899;
        }
        
        .header-menu-item:hover::before {
            opacity: 1;
        }
        
        .header-menu-item:hover i {
            transform: scale(1.1);
            color: #ec4899;
        }
        
        .header-menu-item:hover span {
            color: #ec4899;
        }
        
        .header-menu-item.active {
            background: rgba(236, 72, 153, 0.12);
            color: #ec4899;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.1);
        }
        
        .header-menu-item.active::before {
            background: rgba(236, 72, 153, 0.08);
            opacity: 1;
        }
        
        .header-menu-item.active i {
            color: #ec4899;
            transform: scale(1.1);
        }
        
        .header-menu-item.active span {
            color: #ec4899;
        }
        
        .header-menu-item.active::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 50%;
            transform: translateX(-50%);
            width: 70%;
            height: 3px;
            background: rgba(236, 72, 153, 0.4);
            border-radius: 2px 2px 0 0;
        }
        
        /* Premium Features Section */
        .header-menu-divider {
            width: 100%;
            height: 1px;
            background: linear-gradient(90deg, transparent 0%, #e5e7eb 20%, #e5e7eb 80%, transparent 100%);
            margin: 12px 0;
        }
        
        .header-menu-section-title {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 18px;
            color: #64748b;
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-top: 8px;
            margin-bottom: 4px;
        }
        
        .header-menu-section-title i {
            font-size: 14px;
        }
        
        /* Premium Features Dropdown - Artık kullanılmıyor ama silmeyelim */
        .header-menu-dropdown {
            position: relative;
            display: inline-block;
        }
        
        .header-menu-dropdown .dropdown-toggle {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 18px;
            color: #64748b;
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            white-space: nowrap;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            border: none;
            background: transparent;
            cursor: pointer;
            width: 100%;
        }
        
        .header-menu-dropdown .dropdown-toggle::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: #f1f5f9;
            opacity: 0;
            transition: opacity 0.3s ease;
            border-radius: 8px;
        }
        
        .header-menu-dropdown .dropdown-toggle:hover::before,
        .header-menu-dropdown .dropdown-toggle.show::before {
            opacity: 1;
        }
        
        .header-menu-dropdown .dropdown-toggle:hover,
        .header-menu-dropdown .dropdown-toggle.show,
        .header-menu-dropdown .dropdown-toggle:focus {
            color: #ec4899;
            outline: none;
        }
        
        .header-menu-dropdown .dropdown-toggle i {
            font-size: 16px;
            transition: transform 0.3s ease;
            position: relative;
            z-index: 1;
        }
        
        .header-menu-dropdown .dropdown-toggle span {
            position: relative;
            z-index: 1;
        }
        
        .header-menu-dropdown .dropdown-toggle.show i.bi-chevron-down {
            transform: rotate(180deg);
        }
        
        .header-menu-dropdown .dropdown-toggle.active {
            background: rgba(236, 72, 153, 0.12);
            color: #ec4899;
            font-weight: 600;
        }
        
        .header-menu-dropdown .dropdown-menu {
            border: none;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
            border-radius: 12px;
            padding: 8px;
            margin-top: 8px;
            min-width: 240px;
            background: white;
            z-index: 10001 !important;
            position: absolute !important;
            top: 100% !important;
            right: 0 !important;
            left: auto !important;
            transform: none !important;
        }
        
        .header-menu-dropdown .dropdown-menu.show {
            display: block !important;
        }
        
        .header-menu-dropdown .dropdown-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px 16px;
            color: #1e293b;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.2s ease;
            border: none;
            background: transparent;
            width: 100%;
            text-align: left;
        }
        
        .header-menu-dropdown .dropdown-item:hover {
            background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%);
            color: #ec4899;
            transform: translateX(4px);
        }
        
        .header-menu-dropdown .dropdown-item.active {
            background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%);
            color: #ec4899;
            font-weight: 600;
        }
        
        .header-menu-dropdown .dropdown-item i {
            font-size: 16px;
            width: 20px;
            text-align: center;
        }
        
        @media (max-width: 1200px) {
            .header-menu-dropdown .dropdown-toggle span {
                display: none;
            }
            .header-menu-dropdown .dropdown-toggle {
                padding: 8px 12px;
                min-width: 40px;
                justify-content: center;
            }
        }
        
        @media (max-width: 1200px) and (min-width: 769px) {
            .header-menu-item span {
                display: none;
            }
            .header-menu-item {
                padding: 8px 12px;
                min-width: 40px;
                justify-content: center;
            }
        }
        
        /* Mobile Menu Toggle Button - Responsive görünümde görünür */
        .mobile-menu-toggle {
            display: none;
            background: rgba(255, 255, 255, 0.2);
            border: none;
            border-radius: 8px;
            width: 40px;
            height: 40px;
            padding: 0;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            margin-right: 12px;
            position: relative;
            z-index: 10001;
            pointer-events: auto;
        }
        
        /* Tablet ve mobil görünümde hamburger menü göster */
        @media (max-width: 992px) {
            .mobile-menu-toggle {
                display: flex !important;
            }
            
            .header-bottom {
                display: none !important;
            }
            
            .header-menu {
                display: none !important;
            }
        }
        
        .mobile-menu-toggle:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.05);
        }
        
        .mobile-menu-toggle i {
            font-size: 22px;
            color: white;
            transition: transform 0.3s ease;
        }
        
        .mobile-menu-toggle.active i {
            transform: rotate(90deg);
        }
        
        /* Mobile Menu Overlay - header üstünde olmalı ki tıklanabilsin */
        .mobile-menu-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 10002;
            opacity: 0;
            transition: opacity 0.3s ease;
            pointer-events: none;
        }
        
        .mobile-menu-overlay.active {
            display: block;
            opacity: 1;
            pointer-events: auto;
        }
        
        /* Mobile Menu Sidebar - header üstünde, overlay üstünde */
        .mobile-menu-sidebar {
            position: fixed;
            top: 0;
            left: -100%;
            width: 85%;
            max-width: 320px;
            height: 100vh;
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            box-shadow: 4px 0 24px rgba(0, 0, 0, 0.15);
            z-index: 10003;
            transition: left 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            overflow-y: auto;
            overflow-x: hidden;
        }
        
        .mobile-menu-sidebar.active {
            left: 0;
        }
        @media (max-width: 992px) {
            body.mobile-menu-open .mobile-menu-overlay {
                display: block;
                opacity: 1;
            }
            body.mobile-menu-open .mobile-menu-sidebar {
                left: 0;
            }
        }
        
        /* Desktop görünümde sidebar gizle */
        @media (min-width: 993px) {
            .mobile-menu-sidebar {
                display: none !important;
            }
            
            .mobile-menu-overlay {
                display: none !important;
            }
        }
        
        .mobile-menu-header {
            display: none; /* Mavi header bölümünü gizle */
        }
        
        
        .mobile-menu-content {
            padding: 20px 0;
            padding-bottom: 30px;
        }
        
        .mobile-menu-section {
            padding: 0 0 12px 0;
            border-bottom: 1px solid #e5e7eb;
            margin-bottom: 16px;
        }
        
        .mobile-menu-section:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }
        
        .mobile-menu-section-title {
            padding: 12px 20px 8px;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #64748b;
            margin-bottom: 4px;
        }
        
        .mobile-menu-item {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            color: #1e293b;
            text-decoration: none;
            transition: all 0.2s ease;
            border-left: 3px solid transparent;
        }
        
        .mobile-menu-item:hover,
        .mobile-menu-item.active {
            background: linear-gradient(90deg, rgba(236, 72, 153, 0.08) 0%, rgba(236, 72, 153, 0.04) 100%);
            color: #ec4899;
            border-left-color: #ec4899;
        }
        
        .mobile-menu-item i {
            font-size: 20px;
            width: 28px;
            margin-right: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .mobile-menu-item span {
            font-size: 15px;
            font-weight: 500;
        }
        
        /* Mobil menü profil bölümü stilleri */
        .mobile-menu-section .mobile-menu-item[style*="color: #ef4444"] {
            border-left-color: #ef4444 !important;
        }
        
        .mobile-menu-section .mobile-menu-item[style*="color: #ef4444"]:hover,
        .mobile-menu-section .mobile-menu-item[style*="color: #ef4444"]:active {
            background: #fef2f2 !important;
            color: #dc2626 !important;
        }
        
        @media (max-width: 768px) {
            :root {
                --header-top-height: 56px;
                --header-bottom-height: 0px;
            }
            
            body {
                padding-top: 56px !important;
            }
            
            .top-header {
                height: 56px;
            }
            
            .header-top {
                padding: 8px 12px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                gap: 8px;
                height: 56px;
                flex-wrap: nowrap;
            }
            
            .header-top .header-left {
                flex: 0 0 auto;
                display: flex;
                align-items: center;
                gap: 12px;
            }
            
            .mobile-menu-toggle {
                display: flex !important;
            }
            
            .header-top .header-left .logo-text {
                font-size: 20px !important;
                letter-spacing: 0.5px;
            }
            
            .header-top .header-center {
                display: none !important;
            }
            
            .header-top .header-right {
                flex: 0 0 auto;
                display: flex;
                align-items: center;
                gap: 4px;
                flex-wrap: nowrap;
                min-width: 0;
            }
            
            .header-top .header-right > * {
                flex-shrink: 0;
            }
            
            /* Bugünkü Randevular butonu mobilde sadece icon */
            .header-top .header-right .dropdown {
                order: -1;
            }
            
            .header-top .header-right .dropdown button {
                padding: 8px !important;
                font-size: 0 !important;
                min-width: 36px;
                width: 36px;
                height: 36px;
                border-radius: 8px;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .header-top .header-right .dropdown button i {
                font-size: 16px !important;
                margin: 0 !important;
            }
            
            .header-top .header-right .dropdown button span {
                display: none !important;
            }
            
            .header-top .header-right .dropdown button .badge {
                position: absolute;
                top: -4px;
                right: -4px;
                font-size: 9px;
                padding: 2px 4px;
                min-width: 16px;
                height: 16px;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .header-top .header-right .btn {
                padding: 8px !important;
                font-size: 0;
                min-width: 36px;
                width: 36px;
                height: 36px;
                display: flex;
                align-items: center;
                justify-content: center;
                border-radius: 8px;
            }
            
            .header-top .header-right .btn i {
                font-size: 16px !important;
                margin: 0 !important;
            }
            
            .header-top .header-right .btn span {
                display: none !important;
            }
            
            .header-top .header-right .shortcuts-container {
                display: none !important;
            }
            
            .header-top .header-right .sms-balance-bar {
                display: none !important;
            }
            
            /* User menu mobilde Bootstrap sınıfları ile gizleniyor (d-none d-md-block) */
            
            /* SMS al butonu mobilde sadece icon */
            .header-top .header-right .sms-buy-btn {
                padding: 8px !important;
                min-width: 36px;
                width: 36px;
                height: 36px;
                order: 0;
            }
            
            .header-top .header-right .sms-buy-btn span {
                display: none !important;
            }
            
            .header-top .header-right .sms-buy-btn i {
                font-size: 16px !important;
                margin: 0 !important;
            }
            
            /* Dropdown menüler mobilde düzgün görünsün */
            .header-top .header-right .dropdown-menu {
                position: fixed !important;
                left: 12px !important;
                right: 12px !important;
                width: auto !important;
                max-width: calc(100% - 24px) !important;
                margin-top: 8px !important;
                transform: none !important;
                border-radius: 16px !important;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2) !important;
                max-height: calc(100vh - 80px) !important;
                overflow-y: auto !important;
                z-index: 100005 !important;
            }
            
            /* Bugünkü Randevular dropdown mobilde tam genişlik */
            #todayAppointmentsDropdown.show .dropdown-menu,
            #todayAppointmentsDropdownPersonel.show .dropdown-menu {
                display: block !important;
                visibility: visible !important;
                opacity: 1 !important;
            }
            
            /* Touch optimization for dropdown buttons */
            .header-top .header-right .dropdown button,
            .header-top .header-right .user-avatar {
                touch-action: manipulation;
                -webkit-tap-highlight-color: rgba(255, 255, 255, 0.2);
            }
            
            /* User dropdown mobilde tam genişlik ve üstten konumlandırma */
            .header-top .header-right .user-dropdown {
                position: fixed !important;
                left: 12px !important;
                right: 12px !important;
                width: auto !important;
                max-width: calc(100% - 24px) !important;
                top: 64px !important;
                margin-top: 0 !important;
                border-radius: 16px !important;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2) !important;
                max-height: calc(100vh - 80px) !important;
                overflow-y: auto !important;
            }
            
            .header-top .header-right .user-dropdown.show {
                display: block !important;
            }
            
            /* User dropdown içeriği mobilde daha kompakt */
            .header-top .header-right .user-dropdown .px-4 {
                padding-left: 16px !important;
                padding-right: 16px !important;
            }
            
            .header-top .header-right .user-dropdown .py-2 .d-block {
                padding: 12px 16px !important;
                font-size: 14px !important;
            }
            
            .header-top .header-right .user-dropdown .py-2 .d-block i {
                font-size: 16px !important;
                margin-right: 8px !important;
            }
            
            .header-bottom {
                display: none !important;
            }
            
            .header-menu {
                display: none !important;
            }
        }
        
        /* Tablet görünümü (993px - 1200px) */
        @media (min-width: 993px) and (max-width: 1200px) {
            .header-top .header-center {
                flex: 1;
                max-width: 300px;
            }
            
            .header-top .header-right .shortcuts-container {
                display: none !important;
            }
            
            .header-top .header-right .sms-balance-bar {
                display: none !important;
            }
            
            .header-top .header-right .btn span {
                display: none !important;
            }
            
            .header-top .header-right .btn {
                padding: 8px;
                font-size: 0;
                min-width: 40px;
            }
            
            .header-top .header-right .btn i {
                font-size: 18px;
                margin: 0;
            }
        }

        /* Navbar Dropdown - Professional Version */
        .nav-dropdown {
            position: relative;
            display: inline-block;
        }

        .nav-dropdown > .top-menu-item {
            cursor: pointer;
            user-select: none;
        }

        .nav-dropdown > .top-menu-item::after {
            content: '';
            display: inline-block;
            margin-left: 6px;
            width: 0;
            height: 0;
            border-left: 4px solid transparent;
            border-right: 4px solid transparent;
            border-top: 5px solid currentColor;
            vertical-align: middle;
            transition: transform 0.2s ease;
        }

        .nav-dropdown.is-active > .top-menu-item {
            color: #ec4899;
            background: #fce7f3;
        }

        .nav-dropdown.is-active > .top-menu-item::after {
            transform: rotate(180deg);
        }

        .nav-dropdown-menu {
            position: absolute;
            top: calc(100% + 8px);
            left: 0;
            background: #ffffff;
            min-width: 260px;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.12), 0 8px 32px rgba(0, 0, 0, 0.08);
            border: 1px solid #e2e8f0;
            padding: 8px 0;
            margin: 0;
            list-style: none;
            z-index: 10050;
            display: none;
            max-height: calc(100vh - 150px);
            overflow-y: auto;
            overflow-x: hidden;
        }

        .nav-dropdown-menu.is-visible {
            display: block;
            animation: dropdownFadeIn 0.15s ease-out;
        }

        @keyframes dropdownFadeIn {
            from {
                opacity: 0;
                transform: translateY(-8px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .nav-dropdown-item {
            display: block;
            padding: 11px 20px;
            color: #334155;
            text-decoration: none;
            transition: all 0.15s ease;
            white-space: nowrap;
            font-size: 14px;
            line-height: 1.5;
        }

        .nav-dropdown-item:hover,
        .nav-dropdown-item:focus {
            background: #f1f5f9;
            color: #ec4899;
            text-decoration: none;
        }

        .nav-dropdown-item i {
            width: 20px;
            text-align: left;
            margin-right: 12px;
            font-size: 16px;
            vertical-align: middle;
        }

        /* User Menu */
        .user-menu {
            position: relative;
            z-index: 10000000 !important;
            width: fit-content;
            display: inline-block;
        }

        /* Hover ile açılmayı kaldır - sadece JS ile kontrol edilecek */
        .user-dropdown {
            display: none !important;
            opacity: 0;
            transform: translateY(-10px);
            transition: opacity 0.2s ease, transform 0.2s ease;
            pointer-events: none;
        }
        
        .user-dropdown.show {
            display: block !important;
            opacity: 1;
            transform: translateY(0);
            pointer-events: auto !important;
        }

        .user-avatar {
            width: 42px;
            height: 42px;
            background: rgba(255, 255, 255, 0.2);
            border: 2px solid rgba(255, 255, 255, 0.4);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer !important;
            transition: all 0.2s ease;
            position: relative;
            overflow: visible;
            z-index: 100001 !important;
            pointer-events: auto !important;
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
        }
        
        .user-avatar i {
            position: relative;
            z-index: 1;
            transition: all 0.2s ease;
            color: white !important;
            font-size: 26px !important;
        }

        .user-avatar:hover {
            background: rgba(255, 255, 255, 0.3);
            border-color: rgba(255, 255, 255, 0.6);
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }
        
        .user-avatar:hover i {
            color: white !important;
        }
        
        .user-avatar:active {
            transform: scale(0.98);
        }

        .user-dropdown {
            position: fixed !important;
            background: white;
            border-radius: 12px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
            min-width: 280px;
            display: none;
            z-index: 100004 !important;
            overflow: hidden;
            pointer-events: auto;
            margin-top: 8px !important;
            border: 1px solid #e5e7eb;
        }

        /* User dropdown artık sadece JS ile kontrol ediliyor - CSS hover kaldırıldı */

        /* Settings Sidebar */
        .settings-sidebar {
            position: fixed;
            top: var(--header-height);
            left: 0;
            width: 280px;
            height: calc(100vh - var(--header-height));
            background: linear-gradient(180deg, #ffffff 0%, #fce7f3 100%);
            box-shadow: 4px 0 20px rgba(0,0,0,0.08);
            z-index: 10080;
            transform: translateX(-100%);
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            overflow-y: auto;
            overflow-x: hidden;
            padding: 0;
            border-right: 1px solid #e5e7eb;
        }
        
        /* Mobilde settings sidebar'ı gizle - mobil menüden daha düşük z-index */
        @media (max-width: 768px) {
            .settings-sidebar {
                z-index: 9990 !important; /* Mobil menüden (9999) daha düşük */
                display: none !important; /* Mobilde tamamen gizle */
            }
            
            body.settings-page .main-content {
                margin-left: 0 !important;
            }
        }
        
        .settings-sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .settings-sidebar::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        
        .settings-sidebar::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }
        
        .settings-sidebar::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        .settings-sidebar.active {
            transform: translateX(0);
        }
        
        /* Ayarlar sayfasında sidebar otomatik açık olsun */
        body.settings-page .settings-sidebar {
            transform: translateX(0) !important;
        }
        
        body.settings-page .settings-overlay {
            display: none !important;
        }
        
        /* Ayarlar sayfasında main content'e margin ekle */
        body.settings-page .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Ödeme onayı beklenirken ayarlar menüsü görünür ama etkileşimsiz/arka planda kalır */
        body.payment-pending .settings-sidebar {
            pointer-events: none !important;
            z-index: 10020 !important; /* pending modal/backdrop altı */
            opacity: 0.85;
        }

        .settings-sidebar-header {
            padding: 25px 20px;
            border-bottom: 2px solid #e5e7eb;
            margin-bottom: 15px;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: white;
            position: sticky;
            top: 0;
            z-index: 10;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .settings-sidebar-header h5 {
            color: white;
            font-size: 18px;
            font-weight: 700;
            margin: 0;
        }

        .settings-sidebar-item {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            color: #475569;
            text-decoration: none;
            transition: all 0.2s ease;
            border-left: 4px solid transparent;
            font-weight: 500;
            font-size: 14px;
            margin: 2px 10px;
            border-radius: 8px;
        }
        
        .settings-sidebar-item:hover {
            background: linear-gradient(90deg, rgba(236, 72, 153, 0.08) 0%, rgba(236, 72, 153, 0.04) 100%);
        }
        
        .settings-sidebar-divider {
            height: 1px;
            background: linear-gradient(90deg, transparent 0%, #e5e7eb 20%, #e5e7eb 80%, transparent 100%);
            margin: 12px 20px;
        }
        
        .settings-sidebar-section-title {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 12px 20px;
            color: #64748b;
            font-weight: 600;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-top: 8px;
            margin-bottom: 4px;
        }
        
        .settings-sidebar-section-title i {
            font-size: 12px;
        }
            color: #ec4899;
            border-left-color: #ec4899;
            transform: translateX(4px);
        }

        .settings-sidebar-item.active {
            background: linear-gradient(90deg, rgba(236, 72, 153, 0.12) 0%, rgba(236, 72, 153, 0.06) 100%);
            color: #ec4899;
            border-left-color: #ec4899;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.1);
        }

        .settings-sidebar-item-wrapper {
            position: relative;
            display: flex;
            align-items: center;
            margin: 2px 10px;
        }

        .settings-sidebar-item-wrapper .settings-sidebar-item {
            flex: 1;
            margin: 0;
        }

        .settings-sidebar-info-btn {
            background: transparent;
            border: none;
            color: #94a3b8;
            padding: 8px;
            cursor: pointer;
            border-radius: 50%;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s ease;
            margin-left: 4px;
            flex-shrink: 0;
        }

        .settings-sidebar-info-btn:hover {
            background: rgba(236, 72, 153, 0.1);
            color: #ec4899;
            transform: scale(1.1);
        }

        .settings-sidebar-info-btn i {
            font-size: 14px;
        }

        .settings-sidebar-item i {
            width: 22px;
            margin-right: 12px;
            font-size: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .settings-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 10070;
            display: none;
            transition: opacity 0.3s ease;
        }

        .settings-overlay.active {
            display: block;
        }

        /* Main Content */
        .main-content {
            min-height: calc(100vh - var(--header-height));
            padding: 30px;
            margin-left: 0;
            transition: margin-left 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        /* Ayarlar sayfasında main content'e margin ekle */
        body.settings-page .main-content {
            margin-left: 280px;
        }

        .content-wrapper {
            max-width: 100%;
        }

        /* Cards */
        .card {
            border: 1px solid #e5e7eb;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            margin-bottom: 25px;
            border-radius: 12px;
            overflow: hidden;
            background: white;
        }

        .card-header {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-bottom: 1px solid #e5e7eb;
            font-weight: 600;
            padding: 20px;
            font-size: 18px;
            color: #1e293b;
        }

        .card-body {
            padding: 25px;
        }

        /* Buttons */
        .btn {
            border-radius: 8px;
            font-weight: 500;
            padding: 10px 20px;
            transition: all 0.2s;
        }

        .btn-primary {
            background: linear-gradient(135deg, #f472b6 0%, #ec4899 100%);
            border: none;
            color: white;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(244, 114, 182, 0.3);
        }

        /* Tables */
        .table {
            border-radius: 8px;
            overflow: hidden;
        }

        .table thead {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        }

        .table thead th {
            border: none;
            font-weight: 600;
            color: #be185d;
            padding: 15px;
        }

        .table tbody tr:hover {
            background-color: #f8fafc;
        }

        /* Forms */
        .form-control, .form-select {
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            padding: 10px 15px;
        }

        .form-control:focus, .form-select:focus {
            border-color: #f472b6;
            box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.2);
        }

        /* Alerts */
        .alert {
            border-radius: 10px;
            border: none;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .alert-success {
            background: linear-gradient(135deg, #fbcfe8 0%, #f9a8d4 100%);
            border-left: 4px solid #ec4899;
            color: #065f46;
        }

        .alert-danger {
            background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
            border-left: 4px solid #ef4444;
            color: #991b1b;
        }

        /* Modal z-index düzeltmesi - header'ın üstünde olmalı */
        .modal {
            z-index: 100000 !important;
        }
        
        /* Modal backdrop - customConfirmBox'tan düşük olmalı */
        .modal-backdrop {
            z-index: 10040 !important;
            background-color: rgba(0, 0, 0, 0.5) !important;
        }
        
        .modal-backdrop.show {
            z-index: 10040 !important;
            opacity: 1 !important;
        }
        
        /* Standart Bootstrap modal */
        .modal {
            z-index: 10050 !important;
        }
        
        .modal.show {
            z-index: 10050 !important;
        }
        
        /* Modal içeriği backdrop'un üstünde olmalı */
        .modal-dialog {
            z-index: 10051 !important;
        }
        
        /* Modal açıkken body scroll'u engelle */
        body.modal-open {
            overflow: hidden !important;
        }
        
        /* Randevu detay modal */
        #reservationDetailModal {
            z-index: 10050 !important;
        }
        
        #reservationDetailModal .modal-content {
            z-index: 10051 !important;
        }

        /* Pending ödeme modalı her zaman en üstte kalmalı */
        body.payment-pending #paymentPendingModal {
            z-index: 100120 !important;
        }
        body.payment-pending #paymentPendingModal .modal-dialog,
        body.payment-pending #paymentPendingModal .modal-content {
            z-index: 100121 !important;
        }
        body.payment-pending .modal-backdrop.show {
            z-index: 100110 !important;
        }
        
        /* Responsive */
        @media (max-width: 1200px) {
            .header-top .header-center {
                max-width: 300px;
                margin: 0 15px;
            }

            .shortcuts-container {
                gap: 4px;
                overflow-x: auto;
                overflow-y: hidden;
                scrollbar-width: none;
                -ms-overflow-style: none;
                max-width: 250px;
            }
            
            .shortcuts-container::-webkit-scrollbar {
                display: none;
            }
            
            .shortcut-item {
                width: 36px;
                height: 36px;
                flex-shrink: 0;
            }
            
            .shortcut-item i {
                font-size: 16px;
            }
        }

        @media (max-width: 768px) {
            body {
                padding-top: 0 !important;
            }
            
            .top-header {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                z-index: 10000;
            }
            
            .main-content {
                padding: 10px !important;
                margin: 0 !important;
                margin-top: 0 !important;
            }
            
            .container-fluid {
                padding-left: 10px !important;
                padding-right: 10px !important;
            }
            
            /* Dashboard specific responsive */
            .dashboard-header {
                padding: 15px !important;
            }
            
            .dashboard-title {
                font-size: 20px !important;
            }
            
            .metric-card {
                margin-bottom: 10px !important;
            }
            
            .metric-value {
                font-size: 18px !important;
            }
            
            .secondary-metric-card {
                padding: 15px !important;
            }
            
            .quick-access-card-compact {
                padding: 10px 6px !important;
            }
            
            .quick-access-icon-compact {
                width: 32px !important;
                height: 32px !important;
                font-size: 14px !important;
            }
            
            .quick-access-label-compact {
                font-size: 10px !important;
            }
            
            .dashboard-card {
                margin-bottom: 15px !important;
            }
            
            .card-body-modern {
                padding: 15px !important;
            }
            
            .chart-container {
                height: 250px !important;
            }
            
            .chart-container-small {
                height: 180px !important;
            }

            .top-menu-item {
                padding: 0 8px;
                font-size: 12px;
                gap: 4px;
            }
            
            .top-menu-item i {
                font-size: 14px;
                width: 16px;
            }
            
            .top-menu-item span {
                display: none;
            }
            
            .top-menu-nav {
                padding: 0 5px;
                gap: 2px;
            }
            
            /* Cards */
            .card {
                margin-bottom: 10px !important;
                border-radius: 12px !important;
            }
            
            .card-header {
                padding: 12px 15px !important;
            }
            
            .card-body {
                padding: 12px 15px !important;
            }
            
            /* Tables - Horizontal Scroll */
            .table-responsive {
                margin: 0 -10px;
                padding: 0 10px;
            }
            
            .table {
                font-size: 12px !important;
                min-width: 600px;
            }
            
            .table th, .table td {
                padding: 8px 10px !important;
                white-space: nowrap;
            }
            
            /* Buttons */
            .btn {
                padding: 6px 12px !important;
                font-size: 12px !important;
            }
            
            .btn-sm {
                padding: 4px 8px !important;
                font-size: 11px !important;
            }
            
            .btn-lg {
                padding: 10px 16px !important;
                font-size: 14px !important;
            }
            
            /* Forms */
            .form-control, .form-select {
                font-size: 14px !important;
                padding: 8px 12px !important;
            }
            
            .form-label {
                font-size: 13px !important;
                margin-bottom: 4px !important;
            }
            
            /* Modals */
            .modal-dialog {
                margin: 10px !important;
                max-width: calc(100% - 20px) !important;
            }
            
            .modal-xl, .modal-lg {
                max-width: calc(100% - 20px) !important;
            }
            
            .modal-content {
                border-radius: 16px !important;
            }
            
            .modal-header {
                padding: 12px 15px !important;
            }
            
            .modal-body {
                padding: 15px !important;
            }
            
            .modal-footer {
                padding: 12px 15px !important;
                flex-wrap: wrap;
                gap: 8px;
            }
            
            .modal-footer .btn {
                flex: 1;
                min-width: 100px;
            }
            
            /* Page Titles */
            h1, .h1 { font-size: 1.5rem !important; }
            h2, .h2 { font-size: 1.3rem !important; }
            h3, .h3 { font-size: 1.15rem !important; }
            h4, .h4 { font-size: 1rem !important; }
            h5, .h5 { font-size: 0.9rem !important; }
            
            /* Alerts */
            .alert {
                padding: 10px 12px !important;
                font-size: 13px !important;
            }
            
            /* Badges */
            .badge {
                font-size: 10px !important;
                padding: 4px 8px !important;
            }
            
            /* Pagination */
            .pagination {
                flex-wrap: wrap;
                justify-content: center;
                gap: 4px;
            }
            
            .page-link {
                padding: 6px 10px !important;
                font-size: 12px !important;
            }
            
            /* Stat Cards */
            .stat-card, .info-box {
                padding: 15px !important;
                margin-bottom: 10px !important;
            }
            
            .stat-value {
                font-size: 1.5rem !important;
            }
            
            /* Row & Columns */
            .row {
                margin-left: -5px !important;
                margin-right: -5px !important;
            }
            
            .row > * {
                padding-left: 5px !important;
                padding-right: 5px !important;
            }
            
            /* Dropdown */
            .dropdown-menu {
                font-size: 13px !important;
            }
            
            .dropdown-item {
                padding: 8px 12px !important;
            }
        }
        
        /* Small Mobile */
        @media (max-width: 480px) {
            body {
                padding-top: 50px !important;
            }
            
            .main-content {
                padding: 8px !important;
            }
            
            .header-top .logo-text {
                font-family: 'LogoFont', 'Inter', sans-serif !important;
                font-size: 18px !important;
            }
            
            .header-top {
                padding: 6px 8px !important;
                min-height: 45px;
            }
            
            .header-top .header-left .logo-text {
                font-size: 16px !important;
            }
            
            .header-top .header-center {
                order: 3;
                width: 100%;
                margin: 4px 0 0 0;
                padding: 0;
            }
            
            .header-top .header-center .search-input {
                font-size: 12px;
                padding: 6px 30px 6px 10px;
            }
            
            .header-top .header-right {
                flex-wrap: nowrap;
                gap: 3px;
                overflow-x: auto;
                overflow-y: hidden;
                -webkit-overflow-scrolling: touch;
                scrollbar-width: none;
            }
            
            .header-top .header-right::-webkit-scrollbar {
                display: none;
            }
            
            .header-top .header-right .btn {
                padding: 4px 6px;
                font-size: 10px;
                min-width: 32px;
                height: 32px;
            }
            
            .header-top .header-right .btn i {
                font-size: 14px;
            }
            
            .header-top .header-right .user-avatar {
                width: 28px;
                height: 28px;
            }
            
            .header-top .header-right .user-avatar i {
                font-size: 18px !important;
            }
            
            .header-bottom {
                padding: 4px 6px;
                height: 40px;
            }
            
            .header-menu-item {
                padding: 5px 8px;
                font-size: 11px;
            }
            
            .header-menu-item i {
                font-size: 12px;
                margin-right: 3px;
            }
            
            .header-menu-item span {
                font-size: 11px;
            }
            
            /* Cards - Full Width */
            .card {
                border-radius: 10px !important;
            }
            
            .card-header {
                padding: 10px 12px !important;
            }
            
            .card-body {
                padding: 10px 12px !important;
            }
            
            /* Table - More Compact */
            .table {
                font-size: 11px !important;
            }
            
            .table th, .table td {
                padding: 6px 8px !important;
            }
            
            /* Buttons in Row */
            .btn-group-mobile {
                display: flex;
                flex-direction: column;
                gap: 8px;
                width: 100%;
            }
            
            .btn-group-mobile .btn {
                width: 100%;
            }
            
            /* Modal - Full Screen */
            .modal-dialog {
                margin: 5px !important;
                max-width: calc(100% - 10px) !important;
            }
            
            .modal-header .modal-title {
                font-size: 1rem !important;
            }
            
            /* Forms */
            .form-control, .form-select {
                font-size: 16px !important; /* Prevent zoom on iOS */
            }
            
            /* Grid - Stack */
            .col-md-6, .col-lg-4, .col-lg-3 {
                width: 100% !important;
            }
        }
        
        /* Mobile Menu Toggle */
        @media (max-width: 768px) {
            .mobile-menu-toggle {
                display: flex !important;
                align-items: center;
                justify-content: center;
                width: 36px;
                height: 36px;
                background: rgba(255,255,255,0.15);
                border: none;
                border-radius: 8px;
                color: white;
                cursor: pointer;
            }
            
            .mobile-menu-toggle i {
                font-size: 20px;
            }
        }
        
        @media (min-width: 769px) {
            .mobile-menu-toggle {
                display: none !important;
            }
        }
        /* Custom Checkbox Design */
        input[type="checkbox"] {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            width: 22px;
            height: 22px;
            border: 2px solid #cbd5e1;
            border-radius: 5px;
            background-color: #ffffff;
            cursor: pointer;
            position: relative;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            margin: 0;
            flex-shrink: 0;
        }
        
        input[type="checkbox"]:hover {
            border-color: #ec4899;
            background-color: #fce7f3;
            transform: scale(1.05);
        }
        
        input[type="checkbox"]:checked {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border-color: #ec4899;
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
        }
        
        input[type="checkbox"]:checked::after {
            content: '';
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%) rotate(45deg);
            width: 5px;
            height: 10px;
            border: solid white;
            border-width: 0 2px 2px 0;
            animation: checkmark 0.2s ease-in-out;
        }
        
        @keyframes checkmark {
            0% {
                opacity: 0;
                transform: translate(-50%, -50%) rotate(45deg) scale(0);
            }
            50% {
                transform: translate(-50%, -50%) rotate(45deg) scale(1.2);
            }
            100% {
                opacity: 1;
                transform: translate(-50%, -50%) rotate(45deg) scale(1);
            }
        }
        
        input[type="checkbox"]:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.1);
        }
        
        input[type="checkbox"]:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            background-color: #f1f5f9;
            border-color: #e2e8f0;
        }
        
        input[type="checkbox"]:disabled:checked {
            background: linear-gradient(135deg, #94a3b8 0%, #64748b 100%);
            border-color: #94a3b8;
        }
        
        /* Form Check için özel stiller */
        .form-check {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 0.5rem 0;
        }
        
        .form-check-input {
            margin-top: 0;
            margin-right: 0;
        }
        
        .form-check-label {
            cursor: pointer;
            user-select: none;
            margin: 0;
            line-height: 1.5;
        }
        
        /* Form Switch için özel stiller */
        .form-switch .form-check-input {
            width: 48px;
            height: 26px;
            border-radius: 13px;
            background-color: #cbd5e1;
            border: none;
            position: relative;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .form-switch .form-check-input::before {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background-color: #ffffff;
            top: 3px;
            left: 3px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
        
        .form-switch .form-check-input:checked {
            background: linear-gradient(135deg, #ec4899 0%, #db2777 100%);
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
        }
        
        .form-switch .form-check-input:checked::before {
            left: 25px;
            background-color: #ffffff;
        }
        
        .form-switch .form-check-input:checked::after {
            display: none;
        }
        
        .form-switch .form-check-input:hover {
            transform: scale(1.05);
        }
        
        .form-switch .form-check-input:focus {
            box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.1);
        }
    </style>
    @stack('styles')
    
    <!-- Modern UI Global Styles -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <style>
        /* Modern UI Global Styles - Applied to all admin pages */
        :root {
            --glass-bg: rgba(255, 255, 255, 0.8);
            --glass-border: rgba(255, 255, 255, 0.3);
            --glass-shadow: 0 8px 32px rgba(0,0,0,0.1);
        }
        
        /* Modern Card Styles */
        .card, .dashboard-card {
            background: rgba(255, 255, 255, 0.85);
            backdrop-filter: blur(20px) saturate(180%);
            -webkit-backdrop-filter: blur(20px) saturate(180%);
            border-radius: 20px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1), 0 0 0 1px rgba(255,255,255,0.5);
            border: 1px solid rgba(255, 255, 255, 0.3);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
            position: relative;
        }
        
        /* RGB çizgi efekti kaldırıldı */
        
        .card:hover, .dashboard-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15), 0 0 0 1px rgba(255,255,255,0.6), 0 0 40px rgba(236, 72, 153, 0.1);
        }
        
        /* Modern Button Styles */
        .btn {
            border-radius: 12px;
            font-weight: 600;
            padding: 10px 20px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .btn:hover::before {
            width: 300px;
            height: 300px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(236, 72, 153, 0.5);
        }
        
        .btn-outline-primary {
            border: 2px solid #ec4899;
            color: #ec4899;
            background: transparent;
            font-weight: 600;
        }
        
        .btn-outline-primary:hover {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border-color: #ec4899;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #ec4899 0%, #db2777 100%);
            border: none;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            border: none;
        }
        
        .btn-info {
            background: linear-gradient(135deg, #f472b6 0%, #ec4899 100%);
            border: none;
        }
        
        .btn-warning {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            border: none;
        }
        
        /* Modern Table Styles */
        .table {
            border-radius: 16px;
            overflow: hidden;
        }
        
        .table thead {
            background: linear-gradient(135deg, rgba(236, 72, 153, 0.1) 0%, rgba(190, 24, 93, 0.1) 100%);
            backdrop-filter: blur(10px);
        }
        
        .table tbody tr {
            transition: all 0.2s ease;
        }
        
        .table tbody tr:hover {
            background: rgba(236, 72, 153, 0.05);
            transform: scale(1.01);
        }
        
        /* Modern Form Styles */
        .form-control, .form-select {
            border-radius: 12px;
            border: 1px solid rgba(226, 232, 240, 0.8);
            padding: 10px 16px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.9);
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #ec4899;
            box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.1);
            background: white;
        }
        
        /* Modern Badge Styles */
        .badge {
            border-radius: 8px;
            padding: 6px 12px;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        /* Override Bootstrap success colors to pink */
        .bg-success, .badge.bg-success {
            background-color: #ec4899 !important;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
        }
        
        .text-success {
            color: #ec4899 !important;
        }
        
        .btn-success {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
            border-color: #ec4899 !important;
        }
        
        .btn-success:hover {
            background: linear-gradient(135deg, #be185d 0%, #9f1239 100%) !important;
            border-color: #be185d !important;
        }
        
        /* Modern Alert Styles */
        .alert {
            border-radius: 16px;
            border: none;
            backdrop-filter: blur(10px);
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
        }
        
        /* Modern Modal Styles */
        .modal-content {
            border-radius: 24px;
            border: none;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border-bottom: none;
            padding: 24px;
        }

        .modal-header .modal-title {
            color: #ffffff !important;
        }
        
        /* Smooth Animations */
        * {
            transition: background-color 0.3s ease, color 0.3s ease, transform 0.3s ease;
        }
        
        /* Page Title Styles */
        h1, h2, h3, h4, h5, h6 {
            font-weight: 700;
            letter-spacing: -0.5px;
        }
        
        /* Container Improvements */
        .container-fluid {
            padding: 24px;
        }
        
        /* Loading States */
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        
        /* Custom Loading Screen */
        .custom-loading-screen {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.95);
            z-index: 99999;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            gap: 20px;
        }
        
        .custom-loading-screen .loading-logo {
            width: 150px;
            height: auto;
            max-height: 150px;
            object-fit: contain;
        }
        
        .custom-loading-screen .loading-gif {
            width: 200px;
            height: auto;
            max-height: 200px;
            object-fit: contain;
        }
        
        /* Replace ALL spinners with splashlogo.gif */
        .spinner-border,
        .spinner-grow,
        .spinner {
            display: none !important;
        }
        
        /* Show loading spinner instead of splashlogo.gif */
        .spinner-border::before,
        .spinner-grow::before,
        .spinner::before {
            content: '';
            display: inline-block;
            width: 40px;
            height: 40px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #ec4899;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Loading content with GIF */
        .loading-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .loading-gif {
            width: 200px;
            height: auto;
            max-height: 200px;
            object-fit: contain;
        }
        
        /* Native Mobile App Styles - Tüm sayfalar native app gibi görünecek */
        @media (max-width: 1024px) {
            /* Native App Background */
            body {
                background: #f5f5f5 !important;
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif !important;
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
            }
            
            /* Native Card Style */
            .card {
                background: #ffffff !important;
                border: none !important;
                border-radius: 16px !important;
                margin-bottom: 12px !important;
                box-shadow: 0 2px 8px rgba(0,0,0,0.08) !important;
                overflow: hidden;
            }
            
            /* Kasa sayfasındaki gradient kartları koru - inline style'ları override etme */
            .row.mb-4.g-3 .card[style*="background"] {
                background: inherit !important;
            }
            
            .row.mb-4.g-3 .card[style*="background"] .card-body {
                background: transparent !important;
            }
            
            /* Text renklerini koru */
            .row.mb-4.g-3 .card[style*="background"] .text-white,
            .row.mb-4.g-3 .card[style*="background"] .text-white-50,
            .row.mb-4.g-3 .card[style*="background"] h3,
            .row.mb-4.g-3 .card[style*="background"] h6,
            .row.mb-4.g-3 .card[style*="background"] small {
                color: white !important;
            }
            
            .card-header {
                background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
                color: #ffffff !important;
                padding: 16px 20px !important;
                font-size: 17px !important;
                font-weight: 600 !important;
                border: none !important;
            }
            
            .card-body {
                padding: 20px !important;
            }
            
            /* Native Input Style */
            .form-control, .form-select {
                background: #ffffff !important;
                border: 1px solid #e0e0e0 !important;
                border-radius: 12px !important;
                padding: 14px 16px !important;
                font-size: 16px !important;
                min-height: 48px !important;
                color: #000000 !important;
                -webkit-appearance: none;
                appearance: none;
            }
            
            .form-control:focus, .form-select:focus {
                border-color: #ec4899 !important;
                box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.1) !important;
                outline: none !important;
            }
            
            .form-label {
                font-size: 14px !important;
                font-weight: 600 !important;
                color: #333333 !important;
                margin-bottom: 8px !important;
            }
            
            /* Native Button Style */
            .btn {
                border-radius: 12px !important;
                padding: 14px 24px !important;
                font-size: 16px !important;
                font-weight: 600 !important;
                min-height: 48px !important;
                border: none !important;
                transition: all 0.2s ease !important;
                box-shadow: 0 2px 4px rgba(0,0,0,0.1) !important;
            }
            
            .btn-primary {
                background: #ec4899 !important;
                color: #ffffff !important;
            }
            
            .btn-primary:active {
                background: #be185d !important;
                transform: scale(0.98) !important;
            }
            
            .btn-secondary {
                background: #6b7280 !important;
                color: #ffffff !important;
            }
            
            .btn-success {
                background: #ec4899 !important;
                color: #ffffff !important;
            }
            
            .btn-danger {
                background: #ef4444 !important;
                color: #ffffff !important;
            }
            
            .btn-warning {
                background: #f59e0b !important;
                color: #ffffff !important;
            }
            
            .btn-info {
                background: #f472b6 !important;
                color: #ffffff !important;
            }
            
            /* Native Table Style */
            .table-responsive {
                border-radius: 12px !important;
                overflow: hidden !important;
                background: #ffffff !important;
                box-shadow: 0 2px 8px rgba(0,0,0,0.08) !important;
            }
            
            .table {
                font-size: 15px !important;
                margin-bottom: 0 !important;
            }
            
            .table thead {
                background: #f9fafb !important;
            }
            
            .table th {
                font-weight: 600 !important;
                color: #374151 !important;
                padding: 14px 12px !important;
                font-size: 13px !important;
                text-transform: uppercase !important;
                letter-spacing: 0.5px !important;
            }
            
            .table td {
                padding: 16px 12px !important;
                color: #111827 !important;
                border-bottom: 1px solid #f3f4f6 !important;
            }
            
            .table tbody tr:last-child td {
                border-bottom: none !important;
            }
            
            .table tbody tr {
                transition: background-color 0.15s ease !important;
            }
            
            .table tbody tr:active {
                background: #f3f4f6 !important;
            }
            
            /* Native Badge Style */
            .badge {
                border-radius: 8px !important;
                padding: 6px 10px !important;
                font-size: 12px !important;
                font-weight: 600 !important;
            }
            
            /* Native Alert Style */
            .alert {
                border-radius: 12px !important;
                padding: 16px 20px !important;
                font-size: 15px !important;
                border: none !important;
                box-shadow: 0 2px 8px rgba(0,0,0,0.08) !important;
            }
            
            .alert-danger {
                background: #fee2e2 !important;
                color: #991b1b !important;
            }
            
            .alert-success {
                background: #fbcfe8 !important;
                color: #065f46 !important;
            }
            
            .alert-info {
                background: #fce7f3 !important;
                color: #be185d !important;
            }
            
            .alert-warning {
                background: #fef3c7 !important;
                color: #92400e !important;
            }
            
            /* Native Modal Style - OVERRIDE için spesifik modal'lar */
            .modal-dialog:not(#requestDetailModal .modal-dialog):not(#customerPortfolioModal .modal-dialog):not(#pendingRequestsModal .modal-dialog) {
                margin: 0 !important;
                max-width: 100% !important;
                height: 100vh !important;
                display: flex !important;
                align-items: flex-end !important;
            }
            
            /* Pending Requests Modal - Ortada görünsün - ÇOK GÜÇLÜ OVERRIDE */
            #pendingRequestsModal.modal.show .modal-dialog,
            #pendingRequestsModal .modal-dialog {
                margin: 0.5rem auto !important;
                max-width: calc(100% - 20px) !important;
                max-height: calc(100vh - 20px) !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: auto !important;
                height: auto !important;
                position: relative !important;
            }
            
            #pendingRequestsModal.modal.show .modal-content,
            #pendingRequestsModal .modal-content {
                border-radius: 16px !important;
                border: none !important;
                box-shadow: 0 20px 60px rgba(0,0,0,0.3) !important;
                max-height: calc(100vh - 20px) !important;
                margin: auto !important;
                width: 100% !important;
            }
            
            #pendingRequestsModal.modal.show .modal-header,
            #pendingRequestsModal .modal-header {
                background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%) !important;
                border-bottom: none !important;
                padding: 16px 20px !important;
                border-radius: 16px 16px 0 0 !important;
            }
            
            #pendingRequestsModal.modal.show .modal-header .modal-title,
            #pendingRequestsModal.modal.show .modal-header .text-white,
            #pendingRequestsModal.modal.show .modal-header h5,
            #pendingRequestsModal.modal.show .modal-header *,
            #pendingRequestsModal .modal-header .modal-title,
            #pendingRequestsModal .modal-header .text-white,
            #pendingRequestsModal .modal-header h5,
            #pendingRequestsModal .modal-header * {
                color: #ffffff !important;
            }
            
            #pendingRequestsModal.modal.show .modal-header .btn-close-white,
            #pendingRequestsModal .modal-header .btn-close-white {
                filter: brightness(0) invert(1) !important;
                opacity: 1 !important;
            }
            
            /* Request Detail Modal - Ortada görünsün - ÇOK GÜÇLÜ OVERRIDE */
            #requestDetailModal.modal.show .modal-dialog,
            #requestDetailModal .modal-dialog {
                margin: 0.5rem auto !important;
                max-width: calc(100% - 20px) !important;
                max-height: calc(100vh - 20px) !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: auto !important;
                height: auto !important;
                position: relative !important;
            }
            
            #requestDetailModal.modal.show .modal-content,
            #requestDetailModal .modal-content {
                border-radius: 16px !important;
                border: none !important;
                box-shadow: 0 20px 60px rgba(0,0,0,0.3) !important;
                max-height: calc(100vh - 20px) !important;
                margin: auto !important;
                width: 100% !important;
            }
            
            #requestDetailModal.modal.show .modal-header,
            #requestDetailModal .modal-header {
                background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
                border-bottom: none !important;
                padding: 16px 20px !important;
                border-radius: 16px 16px 0 0 !important;
            }
            
            #requestDetailModal.modal.show .modal-header .modal-title,
            #requestDetailModal.modal.show .modal-header .text-white,
            #requestDetailModal.modal.show .modal-header h5,
            #requestDetailModal.modal.show .modal-header *,
            #requestDetailModal .modal-header .modal-title,
            #requestDetailModal .modal-header .text-white,
            #requestDetailModal .modal-header h5,
            #requestDetailModal .modal-header * {
                color: #ffffff !important;
            }
            
            #requestDetailModal.modal.show .modal-header .btn-close-white,
            #requestDetailModal .modal-header .btn-close-white {
                filter: brightness(0) invert(1) !important;
                opacity: 1 !important;
            }
            
            #requestDetailModal .modal-header .btn-close-white {
                filter: brightness(0) invert(1) !important;
            }
            
            #requestDetailModal .modal-body {
                background: #ffffff !important;
                color: #111827 !important;
            }
            
            /* Diğer modal'lar için */
            .modal-content:not(#requestDetailModal .modal-content) {
                border-radius: 20px 20px 0 0 !important;
                border: none !important;
                box-shadow: 0 -4px 20px rgba(0,0,0,0.15) !important;
                max-height: 90vh !important;
            }
            
            .modal-header:not(#requestDetailModal .modal-header) {
                background: #ffffff !important;
                border-bottom: 1px solid #e5e7eb !important;
                padding: 20px !important;
                border-radius: 20px 20px 0 0 !important;
            }
            
            .modal-body {
                padding: 20px !important;
                max-height: calc(90vh - 140px) !important;
                overflow-y: auto !important;
                -webkit-overflow-scrolling: touch !important;
            }
            
            .modal-footer {
                background: #f9fafb !important;
                border-top: 1px solid #e5e7eb !important;
                padding: 16px 20px !important;
                border-radius: 0 0 20px 20px !important;
            }
            
            /* Native Grid System */
            .row .col-md-3, .row .col-md-4, .row .col-md-6, .row .col-md-8, 
            .row .col-lg-3, .row .col-lg-4, .row .col-lg-6, .row .col-lg-8 {
                margin-bottom: 12px !important;
            }
            
            /* Native Button Groups */
            .btn-group {
                flex-direction: column !important;
                gap: 8px !important;
            }
            
            .btn-group .btn {
                width: 100% !important;
                margin-bottom: 0 !important;
            }
            
            /* Native Input Groups */
            .input-group {
                flex-wrap: wrap !important;
            }
            
            .input-group .btn {
                width: auto !important;
                min-width: 48px !important;
                flex: 0 0 auto !important;
            }
            
            /* Native Typography */
            h1, .h1 { 
                font-size: 28px !important; 
                font-weight: 700 !important;
                color: #111827 !important;
                margin-bottom: 20px !important;
            }
            
            h2, .h2 { 
                font-size: 24px !important; 
                font-weight: 700 !important;
                color: #111827 !important;
                margin-bottom: 16px !important;
            }
            
            h3, .h3 { 
                font-size: 20px !important; 
                font-weight: 600 !important;
                color: #111827 !important;
                margin-bottom: 14px !important;
            }
            
            h4, .h4 { 
                font-size: 18px !important; 
                font-weight: 600 !important;
                color: #111827 !important;
                margin-bottom: 12px !important;
            }
            
            h5, .h5 { 
                font-size: 16px !important; 
                font-weight: 600 !important;
                color: #111827 !important;
                margin-bottom: 10px !important;
            }
            
            /* Native Flex Layouts */
            .d-flex.justify-content-between {
                flex-direction: column !important;
                gap: 12px !important;
            }
            
            .d-flex.justify-content-between .btn {
                width: 100% !important;
            }
            
            /* Native Page Header */
            .d-flex.justify-content-between.align-items-center {
                flex-direction: column !important;
                align-items: stretch !important;
                gap: 16px !important;
            }
            
            /* Native List Groups */
            .list-group-item {
                border-radius: 12px !important;
                margin-bottom: 8px !important;
                border: 1px solid #e5e7eb !important;
                padding: 16px !important;
            }
            
            /* Native Pagination */
            .pagination {
                justify-content: center !important;
                gap: 8px !important;
            }
            
            .page-link {
                border-radius: 8px !important;
                padding: 8px 12px !important;
                min-height: auto !important;
                height: auto !important;
                border: 1px solid #e5e7eb !important;
                font-size: 14px !important;
            }
            
            .pagination .page-item:first-child .page-link,
            .pagination .page-item:last-child .page-link {
                padding: 8px 12px !important;
                font-size: 14px !important;
                min-height: auto !important;
            }
            
            .pagination .page-link i,
            .pagination .page-link svg {
                font-size: 14px !important;
                width: 14px !important;
                height: 14px !important;
            }
            
            /* Native Dropdown */
            .dropdown-menu {
                border-radius: 12px !important;
                box-shadow: 0 4px 16px rgba(0,0,0,0.15) !important;
                border: none !important;
                padding: 8px !important;
            }
            
            .dropdown-item {
                border-radius: 8px !important;
                padding: 12px 16px !important;
                font-size: 15px !important;
            }
            
            .dropdown-item:active {
                background: #f3f4f6 !important;
            }
            
            /* Native Container */
            .container-fluid {
                padding: 16px !important;
            }
            
            /* Remove Web-like Elements */
            .breadcrumb {
                display: none !important;
            }
            
            /* Native Shadows */
            .shadow-sm {
                box-shadow: 0 2px 8px rgba(0,0,0,0.08) !important;
            }
            
            .shadow {
                box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important;
            }
            
            .shadow-lg {
                box-shadow: 0 8px 24px rgba(0,0,0,0.12) !important;
            }
        }
        
        /* ========================================
           MOBILE PERFORMANCE OPTIMIZATIONS
           ======================================== */
        @media (max-width: 768px) {
            /* Disable expensive effects on mobile */
            * {
                will-change: auto !important;
            }
            
            /* Remove backdrop-filter - major FPS killer */
            [style*="backdrop-filter"],
            [style*="backdrop-filter"] *,
            *[class*="backdrop"] {
                backdrop-filter: none !important;
                -webkit-backdrop-filter: none !important;
            }
            
            /* Simplify transforms - disable scale on mobile */
            *:hover {
                transform: none !important;
            }
            
            /* Reduce box-shadow complexity */
            * {
                box-shadow: none !important;
            }
            
            /* Keep minimal shadows for depth */
            .card, .modal-content, .dropdown-menu {
                box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important;
            }
            
            /* Disable expensive animations */
            @keyframes fadeIn,
            @keyframes fadeInUp,
            @keyframes scaleIn,
            @keyframes shine,
            @keyframes logoGradient {
                0%, 100% { opacity: 1; transform: none; }
            }
            
            /* Disable logo animations on mobile */
            .logo-text {
                animation: none !important;
            }
            
            .logo-text::before,
            .logo-text::after {
                display: none !important;
            }
            
            /* Simplify gradients */
            .card, .btn, .header-top, .sidebar {
                background-image: none !important;
            }
            
            /* Use solid colors instead */
            .header-top {
                background: #ec4899 !important;
            }
            
            /* Optimize transitions */
            * {
                transition-duration: 0.15s !important;
                transition-timing-function: ease !important;
            }
            
            /* Reduce rendering complexity */
            body {
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
            }
            
            /* Touch optimization */
            button, a, .btn, input, select, textarea {
                -webkit-tap-highlight-color: rgba(236, 72, 153, 0.2);
                touch-action: manipulation;
            }
            
            /* Optimize tables for mobile */
            .table-responsive {
                -webkit-overflow-scrolling: touch;
            }
            
            /* Disable hover effects on touch devices */
            @media (hover: none) {
                *:hover {
                    transform: none !important;
                    box-shadow: inherit !important;
                }
            }
            
            /* Disable expensive CSS properties on mobile */
            * {
                filter: none !important;
                perspective: none !important;
                transform-style: flat !important;
            }
            
            /* Optimize images */
            img {
                image-rendering: -webkit-optimize-contrast;
                image-rendering: crisp-edges;
            }
            
            /* Reduce repaints */
            .card, .modal, .dropdown-menu {
                contain: layout style paint;
            }
            
            /* Disable will-change on mobile */
            * {
                will-change: auto !important;
            }
        }
        
        /* Additional responsive improvements */
        @media (max-width: 480px) {
            /* Extra small screens */
            .container-fluid {
                padding-left: 10px !important;
                padding-right: 10px !important;
            }
            
            .card-body {
                padding: 12px !important;
            }
            
            .btn {
                padding: 10px 16px !important;
                font-size: 14px !important;
            }
        }
        
        /* ============================================
           GENEL MOBİL RESPONSIVE DÜZENLEMELERİ
           ============================================ */
        
        @media (max-width: 1024px) {
            /* Container ve Padding Düzenlemeleri */
            .container-fluid {
                padding-left: 16px !important;
                padding-right: 16px !important;
            }
            
            /* Kartlar */
            .card {
                border-radius: 16px !important;
                margin-bottom: 16px !important;
            }
            
            .card-header {
                padding: 16px !important;
                font-size: 16px !important;
            }
            
            .card-body {
                padding: 16px !important;
            }
            
            /* Tablolar - Mobilde scroll edilebilir */
            .table-responsive {
                border-radius: 12px;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
            
            .table {
                font-size: 14px !important;
                min-width: 600px;
            }
            
            .table th,
            .table td {
                padding: 10px 8px !important;
                white-space: nowrap;
            }
            
            .table th {
                font-size: 12px !important;
                font-weight: 700 !important;
            }
            
            /* Butonlar */
            .btn {
                padding: 10px 16px !important;
                font-size: 14px !important;
                border-radius: 12px !important;
                white-space: nowrap;
            }
            
            .btn-group {
                flex-wrap: wrap;
                gap: 8px;
            }
            
            .btn-group .btn {
                flex: 1;
                min-width: auto;
            }
            
            /* Form Elemanları */
            .form-label {
                font-size: 14px !important;
                font-weight: 600 !important;
                margin-bottom: 8px !important;
            }
            
            .form-control,
            .form-select {
                padding: 12px 16px !important;
                font-size: 16px !important; /* iOS zoom önleme */
                border-radius: 12px !important;
            }
            
            .form-control:focus,
            .form-select:focus {
                font-size: 16px !important; /* iOS zoom önleme */
            }
            
            /* Input Groups */
            .input-group {
                flex-wrap: wrap;
            }
            
            .input-group .form-control {
                flex: 1;
                min-width: 0;
            }
            
            /* Grid Sistemleri */
            .row {
                margin-left: -8px !important;
                margin-right: -8px !important;
            }
            
            .row > * {
                padding-left: 8px !important;
                padding-right: 8px !important;
            }
            
            /* Badge'ler */
            .badge {
                font-size: 11px !important;
                padding: 6px 10px !important;
            }
            
            /* Modal'lar */
            .modal-dialog {
                margin: 10px !important;
                max-width: calc(100% - 20px) !important;
            }
            
            .modal-content {
                border-radius: 16px !important;
            }
            
            .modal-header {
                padding: 16px !important;
            }
            
            .modal-body {
                padding: 16px !important;
            }
            
            .modal-footer {
                padding: 12px 16px !important;
                flex-direction: column;
                gap: 8px;
            }
            
            .modal-footer .btn {
                width: 100%;
                margin: 0 !important;
            }
            
            /* List Group */
            .list-group-item {
                padding: 12px 16px !important;
            }
            
            /* Pagination */
            .pagination {
                flex-wrap: wrap;
                justify-content: center;
                gap: 4px;
            }
            
            .page-link {
                padding: 8px 12px !important;
                font-size: 14px !important;
            }
            
            /* Alert'ler */
            .alert {
                padding: 12px 16px !important;
                font-size: 14px !important;
                border-radius: 12px !important;
            }
            
            /* Dropdown Menüler */
            .dropdown-menu {
                max-width: calc(100vw - 32px);
                max-height: 70vh;
                overflow-y: auto;
            }
            
            /* Nav Tabs */
            .nav-tabs {
                flex-wrap: wrap;
                border-bottom: 2px solid #e5e7eb;
            }
            
            .nav-tabs .nav-link {
                padding: 10px 16px !important;
                font-size: 14px !important;
                white-space: nowrap;
            }
            
            /* Accordion */
            .accordion-item {
                margin-bottom: 12px !important;
                border-radius: 12px !important;
            }
            
            .accordion-button {
                padding: 14px 16px !important;
                font-size: 14px !important;
            }
            
            /* Progress Bars */
            .progress {
                height: 24px !important;
                border-radius: 12px !important;
            }
            
            /* Tooltip ve Popover */
            .tooltip,
            .popover {
                font-size: 12px !important;
            }
        }
        
        @media (max-width: 768px) {
            /* Daha küçük ekranlar için ek düzenlemeler */
            
            /* Başlıklar */
            h1 {
                font-size: 24px !important;
            }
            
            h2 {
                font-size: 20px !important;
            }
            
            h3 {
                font-size: 18px !important;
            }
            
            h4 {
                font-size: 16px !important;
            }
            
            h5 {
                font-size: 15px !important;
            }
            
            /* Container */
            .container-fluid {
                padding-left: 12px !important;
                padding-right: 12px !important;
            }
            
            /* Kartlar */
            .card-header {
                padding: 12px 16px !important;
            }
            
            .card-body {
                padding: 12px 16px !important;
            }
            
            /* Tablolar - Daha kompakt */
            .table {
                font-size: 13px !important;
            }
            
            .table th,
            .table td {
                padding: 8px 6px !important;
            }
            
            /* Butonlar */
            .btn {
                padding: 10px 14px !important;
                font-size: 13px !important;
            }
            
            .btn-sm {
                padding: 6px 12px !important;
                font-size: 12px !important;
            }
            
            .btn-lg {
                padding: 12px 20px !important;
                font-size: 15px !important;
            }
            
            /* Form Elemanları */
            .form-control,
            .form-select {
                padding: 10px 14px !important;
                font-size: 16px !important;
            }
            
            /* Grid - Tek sütun */
            .col-md-6,
            .col-lg-4,
            .col-lg-3,
            .col-xl-3 {
                flex: 0 0 0 100% !important;
                max-width: 100% !important;
            }
            
            /* Flexbox düzenlemeleri */
            .d-flex {
                flex-wrap: wrap;
            }
            
            .gap-2,
            .gap-3,
            .gap-4 {
                gap: 8px !important;
            }
            
            /* Spacing */
            .mb-4 {
                margin-bottom: 20px !important;
            }
            
            .mb-3 {
                margin-bottom: 16px !important;
            }
            
            .mt-4 {
                margin-top: 20px !important;
            }
            
            .p-4 {
                padding: 16px !important;
            }
            
            .px-4 {
                padding-left: 16px !important;
                padding-right: 16px !important;
            }
            
            .py-4 {
                padding-top: 16px !important;
                padding-bottom: 16px !important;
            }
        }
        
        @media (max-width: 480px) {
            /* Çok küçük ekranlar */
            
            .container-fluid {
                padding-left: 10px !important;
                padding-right: 10px !important;
            }
            
            .card-body {
                padding: 10px 12px !important;
            }
            
            .card-header {
                padding: 10px 12px !important;
                font-size: 14px !important;
            }
            
            .btn {
                padding: 8px 12px !important;
                font-size: 12px !important;
            }
            
            .table {
                font-size: 12px !important;
            }
            
            .table th,
            .table td {
                padding: 6px 4px !important;
            }
            
            h1 {
                font-size: 20px !important;
            }
            
            h2 {
                font-size: 18px !important;
            }
            
            h3 {
                font-size: 16px !important;
            }
        }
        
        /* Özel Sayfa Düzenlemeleri */
        @media (max-width: 1024px) {
            /* Dashboard */
            .stats-grid {
                grid-template-columns: repeat(2, 1fr) !important;
                gap: 12px !important;
            }
            
            /* Müşteri Listesi */
            .customer-card,
            .personel-card,
            .room-card {
                margin-bottom: 16px !important;
            }
            
            /* Randevu Listesi */
            .appointment-card {
                margin-bottom: 12px !important;
            }
            
            /* Form Sayfaları */
            .form-row {
                flex-direction: column;
            }
            
            .form-row .col-md-6,
            .form-row .col-md-4 {
                width: 100% !important;
                max-width: 100% !important;
            }
        }
        
        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: 1fr !important;
            }
        }
        
        /* Tablo için özel mobil görünüm */
        @media (max-width: 768px) {
            /* Tabloları kart görünümüne çevir */
            .table-mobile-card {
                display: block;
            }
            
            .table-mobile-card thead {
                display: none;
            }
            
            .table-mobile-card tbody,
            .table-mobile-card tr,
            .table-mobile-card td {
                display: block;
                width: 100%;
            }
            
            .table-mobile-card tr {
                margin-bottom: 16px;
                border: 1px solid #e5e7eb;
                border-radius: 12px;
                padding: 12px;
                background: white;
            }
            
            .table-mobile-card td {
                border: none;
                padding: 8px 0 !important;
                text-align: left !important;
            }
            
            .table-mobile-card td:before {
                content: attr(data-label) ": ";
                font-weight: 700;
                color: #64748b;
                display: inline-block;
                width: 120px;
            }
        }
        
        /* Print görünümü */
        @media print {
            .btn,
            .mobile-menu-toggle,
            .header-top,
            .header-bottom {
                display: none !important;
            }
        }
    </style>
</head>
<body class="@if($isSettingsPage) settings-page @endif @if($hasPendingPackagePayment) payment-pending @endif">
    <script>
        window.toggleMobileMenu = window.toggleMobileMenu || function(e){ if(e){ e.preventDefault(); e.stopPropagation(); } var s=document.getElementById('mobileMenuSidebar'),o=document.getElementById('mobileMenuOverlay'),t=document.getElementById('mobileMenuToggle'); if(!s||!o||!t) return; var open=!s.classList.contains('active'); s.classList.toggle('active',open); o.classList.toggle('active',open); t.classList.toggle('active',open); document.body.classList.toggle('mobile-menu-open',open); document.body.style.overflow=open?'hidden':''; };
        window.closeMobileMenu = window.closeMobileMenu || function(){ var s=document.getElementById('mobileMenuSidebar'),o=document.getElementById('mobileMenuOverlay'),t=document.getElementById('mobileMenuToggle'); if(s) s.classList.remove('active'); if(o) o.classList.remove('active'); if(t) t.classList.remove('active'); document.body.classList.remove('mobile-menu-open'); document.body.style.overflow=''; };
    </script>
    <!-- Top Header - İki Katmanlı Tasarım -->
    <div class="top-header">
        <!-- Üst Katman: Logo, Kısayollar, Arama, Butonlar -->
        <div class="header-top">
            <div class="header-left">
                <!-- Mobile Menu Toggle (Hamburger) - Responsive görünümde görünür -->
                <button type="button" class="mobile-menu-toggle" id="mobileMenuToggle" onclick="typeof toggleMobileMenu==='function'&&toggleMobileMenu(event)" aria-label="Menüyü Aç">
                    <i class="bi bi-list"></i>
                </button>
                <a href="{{ route('admin.dashboard') }}" style="text-decoration: none; display: flex; align-items: center;">
                    <img src="{{ asset('salonayadminheader.png') }}" alt="Salonay" class="header-logo" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-block';">
                    <span class="logo-text" style="display: none;">Salonay</span>
                </a>
            </div>
            
            <div class="header-center">
                <div class="search-container">
                    <input type="text" class="search-input" id="globalSearch" placeholder="Ara... (Randevu, Müşteri)" autocomplete="off">
                    <i class="bi bi-search search-icon"></i>
                    <div class="search-results" id="searchResults"></div>
                </div>
            </div>
            
            <div class="header-right">
                @if(Auth::check() && Auth::user()->isPersonel())
                    {{-- Personel için Bugünkü Randevular ve çıkış yap butonu --}}
                    @auth
                    <!-- Bugünkü Randevular Dropdown - Personel için -->
                    <div class="dropdown" id="todayAppointmentsDropdownPersonel">
                        <button class="btn btn-sm" type="button" id="todayAppointmentsBtnPersonel" data-bs-toggle="dropdown" aria-expanded="false" style="position: relative;">
                            <i class="bi bi-calendar-check"></i>
                            <span>Bugünkü Randevular</span>
                            <span class="badge bg-danger ms-2" id="todayAppointmentsBadgePersonel" style="display: none;">0</span>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end" id="todayAppointmentsMenuPersonel" style="min-width: 350px; max-height: 500px; overflow-y: auto; padding: 0;">
                            <li>
                                <div class="px-3 py-2 border-bottom" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border-radius: 8px 8px 0 0;">
                                    <h6 class="mb-0 fw-bold">
                                        <i class="bi bi-calendar-check me-2"></i>Bugünkü Randevular
                                        <span class="badge bg-white text-primary ms-2" id="todayAppointmentsCountPersonel">0</span>
                                    </h6>
                                </div>
                            </li>
                            <li>
                                <div id="todayAppointmentsContentPersonel" class="p-3">
                                    <div class="text-center py-3">
                                        <div class="spinner-border spinner-border-sm text-primary" role="status"></div>
                                        <p class="mt-2 mb-0 text-muted" style="font-size: 0.85rem;">Yükleniyor...</p>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <div class="user-menu d-none d-md-block">
                        <div class="user-avatar">
                            <i class="bi bi-person-circle" style="font-size: 26px; color: #ffffff;"></i>
                        </div>
                        <div class="user-dropdown">
                            <div class="px-4 py-3 border-bottom" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border-radius: 12px 12px 0 0;">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="d-inline-flex align-items-center justify-content-center rounded-circle" style="width: 48px; height: 48px; background: rgba(255,255,255,0.2);">
                                        <i class="bi bi-person-circle" style="font-size: 28px; color: white;"></i>
                                    </div>
                                    <div>
                                        <p class="mb-0 fw-bold">{{ Auth::check() ? Auth::user()->name : 'Kullanıcı' }}</p>
                                        <small style="opacity: 0.9; font-size: 12px;">Personel</small>
                                    </div>
                                </div>
                            </div>
                            <div class="py-2">
                                <form method="POST" action="{{ route('logout') }}" id="logoutForm">
                                    @csrf
                                    <a href="#" onclick="event.preventDefault(); document.getElementById('logoutForm').submit();" class="d-block px-4 py-2 text-decoration-none text-danger" style="transition: all 0.2s; border-radius: 0 0 12px 12px;" onmouseover="this.style.background='#fef2f2'" onmouseout="this.style.background='transparent'">
                                        <i class="bi bi-box-arrow-right me-2"></i> Çıkış Yap
                                    </a>
                                </form>
                            </div>
                        </div>
                    </div>
                    @endauth
                @else
                    {{-- Diğer kullanıcılar için normal header --}}
                    <div class="shortcuts-container d-none d-md-flex">
                        @if(Auth::check() && !Auth::user()->isSuperAdmin() && !Auth::user()->isPersonel())
                            <!-- Yeni Randevu butonu kaldırıldı -->
                            <a href="#" class="shortcut-item" title="Yeni Müşteri" onclick="event.preventDefault(); openNewCustomerModal();">
                                <i class="bi bi-person-plus"></i>
                            </a>
                            <a href="{{ route('admin.reservations.calendar') }}" class="shortcut-item" title="Takvim">
                                <i class="bi bi-calendar"></i>
                            </a>
                            <a href="{{ route('admin.accounting.cashbox') }}" class="shortcut-item" title="Kasa">
                                <i class="bi bi-cash-coin"></i>
                            </a>
                        @endif
                    </div>
                    
                    @if(Auth::check() && !Auth::user()->isSuperAdmin() && !Auth::user()->isPersonel())
                    <!-- SMS Bakiye Barı -->
                    <div class="sms-balance-bar d-none d-md-flex align-items-center" style="background: rgba(255, 255, 255, 0.15); border: 1px solid rgba(255, 255, 255, 0.2); border-radius: 10px; padding: 6px 12px; margin-right: 8px; backdrop-filter: blur(10px);">
                        <i class="bi bi-chat-dots me-2" style="color: white;"></i>
                        <div class="d-flex flex-column" style="line-height: 1.2;">
                            <span style="font-size: 10px; color: rgba(255, 255, 255, 0.7);">SMS Bakiye</span>
                            <span style="font-size: 13px; font-weight: 600; color: white;">{{ Auth::check() ? (Auth::user()->sms_balance ?? 0) : 0 }}</span>
                        </div>
                    </div>
                    @endif
                    
                    @if(Auth::check() && (Auth::user()->isBeautySalon() || Auth::user()->isPersonel()))
                    <div class="d-flex align-items-center gap-2">
                        <!-- SMS Al Butonu -->
                    <a href="{{ route('admin.sms-packages.index') }}" class="btn btn-sm d-none d-md-inline-flex sms-buy-btn" title="SMS Paketleri">
                        <i class="bi bi-plus-circle"></i> <span>SMS Al</span>
                    </a>
                    
                        <!-- Bugünkü Randevular Dropdown - SMS Al'ın sağına taşındı -->
                        <div class="dropdown" id="todayAppointmentsDropdown">
                            <button class="btn btn-sm" type="button" id="todayAppointmentsBtn" data-bs-toggle="dropdown" aria-expanded="false" style="position: relative;">
                                <i class="bi bi-calendar-check"></i>
                                <span>Bugünkü Randevular</span>
                                <span class="badge bg-danger ms-2" id="todayAppointmentsBadge" style="display: none;">0</span>
                        </button>
                            <ul class="dropdown-menu dropdown-menu-end" id="todayAppointmentsMenu" style="min-width: 350px; max-height: 500px; overflow-y: auto; padding: 0;">
                                <li>
                                    <div class="px-3 py-2 border-bottom" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border-radius: 8px 8px 0 0;">
                                        <h6 class="mb-0 fw-bold">
                                            <i class="bi bi-calendar-check me-2"></i>Bugünkü Randevular
                                            <span class="badge bg-white text-primary ms-2" id="todayAppointmentsCount">0</span>
                                </h6>
                                </div>
                            </li>
                                <li>
                                    <div id="todayAppointmentsContent" class="p-3">
                                        <div class="text-center py-3">
                                            <div class="spinner-border spinner-border-sm text-primary" role="status"></div>
                                            <p class="mt-2 mb-0 text-muted" style="font-size: 0.85rem;">Yükleniyor...</p>
                                        </div>
                                    </div>
                            </li>
                        </ul>
                    </div>
                    </div>
                    @endif
                    
                    @if(env('UYELIK'))
                        <a href="{{ env('UYELIK') }}" target="_blank" class="btn btn-sm" title="Üyelik Yenile">
                            <i class="bi bi-arrow-repeat"></i> <span>Üyelik Yenile</span>
                        </a>
                    @endif
                    
                    
                    @auth
                    <div class="user-menu d-none d-md-block">
                        <div class="user-avatar">
                            <i class="bi bi-person-circle" style="font-size: 26px; color: #ffffff;"></i>
                        </div>
                        <div class="user-dropdown">
                            <div class="px-4 py-3 border-bottom" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border-radius: 12px 12px 0 0;">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="d-inline-flex align-items-center justify-content-center rounded-circle" style="width: 48px; height: 48px; background: rgba(255,255,255,0.2);">
                                        <i class="bi bi-person-circle" style="font-size: 28px; color: white;"></i>
                                    </div>
                                    <div>
                                        <p class="mb-0 fw-bold">{{ Auth::check() ? Auth::user()->name : 'Kullanıcı' }}</p>
                                        <small style="opacity: 0.9; font-size: 12px;">{{ Auth::check() ? (Auth::user()->phone ?? '-') : '-' }}</small>
                                    </div>
                                </div>
                            </div>
                            <div class="py-2">
                                <a href="#" onclick="event.preventDefault(); if(typeof openSettingsMenu === 'function') { openSettingsMenu(); } else { @if(auth()->check() && auth()->user()->isSuperAdmin()) window.location.href='{{ route('admin.settings.general') }}'; @else window.location.href='{{ route('admin.settings.membership') }}'; @endif }" class="d-block px-4 py-2 text-decoration-none text-dark" style="transition: all 0.2s; border-radius: 0;" onmouseover="this.style.background='#f8f9fa'" onmouseout="this.style.background='transparent'">
                                    <i class="bi bi-gear me-2"></i> Ayarlar
                                </a>
                                <div class="border-top my-2"></div>
                                <form method="POST" action="{{ route('logout') }}" id="logoutForm">
                                    @csrf
                                    <a href="#" onclick="event.preventDefault(); document.getElementById('logoutForm').submit();" class="d-block px-4 py-2 text-decoration-none text-danger" style="transition: all 0.2s; border-radius: 0 0 12px 12px;" onmouseover="this.style.background='#fef2f2'" onmouseout="this.style.background='transparent'">
                                        <i class="bi bi-box-arrow-right me-2"></i> Çıkış Yap
                                    </a>
                                </form>
                            </div>
                        </div>
                    </div>
                    @endauth
                @endif
            </div>
        </div>
        
        <!-- Alt Katman: Sayfa Menüleri -->
        <div class="header-bottom">
            <div class="header-menu">
                @if(Auth::check() && Auth::user()->isSuperAdmin())
                    <a href="{{ route('admin.superadmin.dashboard') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.dashboard') ? 'active' : '' }}">
                        <i class="bi bi-shield-check"></i>
                        <span>Süper Admin</span>
                    </a>
                    <a href="{{ route('admin.superadmin.users') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.users') ? 'active' : '' }}">
                        <i class="bi bi-people"></i>
                        <span>Kullanıcılar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.packages.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.packages.*') ? 'active' : '' }}">
                        <i class="bi bi-box-seam"></i>
                        <span>Paketler</span>
                    </a>
                    <a href="{{ route('admin.superadmin.coupons.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.coupons.*') ? 'active' : '' }}">
                        <i class="bi bi-tag"></i>
                        <span>Kuponlar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.pending-payments') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.pending-payments*') ? 'active' : '' }}">
                        <i class="bi bi-hourglass-split"></i>
                        <span>Bekleyen Ödemeler</span>
                    </a>
                    <a href="{{ route('admin.superadmin.testimonials.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.testimonials.*') ? 'active' : '' }}">
                        <i class="bi bi-chat-quote"></i>
                        <span>Yorumlar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.salon-ratings.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.salon-ratings.*') ? 'active' : '' }}">
                        <i class="bi bi-stars"></i>
                        <span>Salon Yıldızları</span>
                    </a>
                    <a href="{{ route('admin.superadmin.global-contract.index') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.global-contract.*') ? 'active' : '' }}">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Global Sözleşme</span>
                    </a>
                    <a href="{{ route('admin.superadmin.app-downloads') }}" class="header-menu-item {{ request()->routeIs('admin.superadmin.app-downloads') ? 'active' : '' }}">
                        <i class="bi bi-download"></i>
                        <span>Uygulama İndirmeleri</span>
                    </a>
                @elseif(auth()->check() && auth()->user()->isPersonel())
                    <!-- Personel Menüsü -->
                    <a href="{{ route('personel.dashboard') }}" class="header-menu-item {{ request()->routeIs('personel.*') ? 'active' : '' }}">
                        <i class="bi bi-house-door"></i>
                        <span>Dashboard</span>
                    </a>
                @else
                    <a href="{{ route('admin.dashboard') }}" class="header-menu-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                        <i class="bi bi-house-door"></i>
                        <span>Anasayfa</span>
                    </a>
                    <a href="{{ route('admin.appointments.index') }}" class="header-menu-item {{ request()->routeIs('admin.appointments.*') ? 'active' : '' }}">
                        <i class="bi bi-list-ul"></i>
                        <span>Randevular</span>
                    </a>
                    <a href="{{ route('admin.reservations.calendar') }}" class="header-menu-item {{ request()->routeIs('admin.reservations.calendar') ? 'active' : '' }}">
                        <i class="bi bi-calendar3"></i>
                        <span>Takvim</span>
                    </a>
                    <a href="{{ route('admin.customers.index') }}" class="header-menu-item {{ request()->routeIs('admin.customers.*') ? 'active' : '' }}">
                        <i class="bi bi-people"></i>
                        <span>Müşteriler</span>
                    </a>
                    @if(!auth()->user()->isPersonel())
                    <a href="{{ route('admin.accounting.cashbox') }}" class="header-menu-item {{ request()->routeIs('admin.accounting.cashbox') ? 'active' : '' }}">
                        <i class="bi bi-cash-coin"></i>
                        <span>KASA</span>
                    </a>
                    @endif
                    <a href="{{ route('admin.settings.invoices.index') }}" class="header-menu-item {{ request()->routeIs('admin.settings.invoices.*') ? 'active' : '' }}">
                        <i class="bi bi-receipt"></i>
                        <span>Faturalar</span>
                    </a>
                    <a href="{{ route('admin.settings.contracts.index') }}" class="header-menu-item {{ request()->routeIs('admin.settings.contracts.*') ? 'active' : '' }}">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Sözleşmeler</span>
                    </a>
                    <a href="{{ route('admin.settings.services.index') }}" class="header-menu-item {{ request()->routeIs('admin.settings.services.*') ? 'active' : '' }}">
                        <i class="bi bi-scissors"></i>
                        <span>Hizmetler</span>
                    </a>
                    <a href="{{ route('admin.rooms.index') }}" class="header-menu-item {{ request()->routeIs('admin.rooms.*') ? 'active' : '' }}">
                        <i class="bi bi-door-open"></i>
                        <span>Odalar</span>
                    </a>
                    @if(auth()->check() && (auth()->user()->isBeautySalon() || auth()->user()->role === 'admin'))
                    <a href="{{ route('admin.beauty-salon.personel.index') }}" class="header-menu-item {{ request()->routeIs('admin.beauty-salon.personel.*') ? 'active' : '' }}">
                        <i class="bi bi-people"></i>
                        <span>Personel</span>
                    </a>
                @endif
                    <a href="{{ route('admin.help.faq') }}" class="header-menu-item {{ request()->routeIs('admin.help.*') ? 'active' : '' }}">
                        <i class="bi bi-question-circle"></i>
                        <span>Yardım</span>
                    </a>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Mobile Menu Overlay -->
    <div class="mobile-menu-overlay" id="mobileMenuOverlay" onclick="closeMobileMenu()"></div>
    
    <!-- Mobile Menu Sidebar -->
    <div class="mobile-menu-sidebar" id="mobileMenuSidebar">
        <div class="mobile-menu-content" style="padding-top: 20px;">
            @if(Auth::check() && Auth::user()->isSuperAdmin())
                <div class="mobile-menu-section">
                    <div class="mobile-menu-section-title">Süper Admin</div>
                    <a href="{{ route('admin.superadmin.dashboard') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.dashboard') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-shield-check"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="{{ route('admin.superadmin.users') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.users') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-people"></i>
                        <span>Kullanıcılar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.packages.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.packages.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-box-seam"></i>
                        <span>Paketler</span>
                    </a>
                    <a href="{{ route('admin.superadmin.coupons.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.coupons.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-tag"></i>
                        <span>Kuponlar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.pending-payments') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.pending-payments*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-hourglass-split"></i>
                        <span>Bekleyen Ödemeler</span>
                    </a>
                    <a href="{{ route('admin.superadmin.testimonials.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.testimonials.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-chat-quote"></i>
                        <span>Yorumlar</span>
                    </a>
                    <a href="{{ route('admin.superadmin.salon-ratings.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.salon-ratings.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-stars"></i>
                        <span>Salon Yıldızları</span>
                    </a>
                    <a href="{{ route('admin.superadmin.global-contract.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.global-contract.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Global Sözleşme</span>
                    </a>
                    <a href="{{ route('admin.superadmin.app-downloads') }}" class="mobile-menu-item {{ request()->routeIs('admin.superadmin.app-downloads') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-download"></i>
                        <span>Uygulama İndirmeleri</span>
                    </a>
                </div>
            @elseif(auth()->check() && auth()->user()->isPersonel())
                <!-- Personel Mobil Menüsü -->
                <div class="mobile-menu-section">
                    <a href="{{ route('personel.dashboard') }}" class="mobile-menu-item {{ request()->routeIs('personel.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-house-door"></i>
                        <span>Dashboard</span>
                    </a>
                </div>
            @else
                <!-- Desktop'taki ana menü sayfaları -->
                <div class="mobile-menu-section">
                    <a href="{{ route('admin.dashboard') }}" class="mobile-menu-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-house-door"></i>
                        <span>Anasayfa</span>
                    </a>
                    <a href="{{ route('admin.appointments.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.appointments.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-list-ul"></i>
                        <span>Randevular</span>
                    </a>
                    <a href="{{ route('admin.reservations.calendar') }}" class="mobile-menu-item {{ request()->routeIs('admin.reservations.calendar') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-calendar3"></i>
                        <span>Takvim</span>
                    </a>
                    <a href="{{ route('admin.customers.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.customers.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-people"></i>
                        <span>Müşteriler</span>
                    </a>
                    @if(!auth()->user()->isPersonel())
                    <a href="{{ route('admin.accounting.cashbox') }}" class="mobile-menu-item {{ request()->routeIs('admin.accounting.cashbox') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-cash-coin"></i>
                        <span>Kasa</span>
                    </a>
                    @endif
                    <a href="{{ route('admin.settings.invoices.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.settings.invoices.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-receipt"></i>
                        <span>Faturalar</span>
                    </a>
                    <a href="{{ route('admin.settings.contracts.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.settings.contracts.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-file-earmark-text"></i>
                        <span>Sözleşmeler</span>
                    </a>
                    @if(auth()->check() && (auth()->user()->isBeautySalon() || auth()->user()->role === 'admin'))
                    <a href="{{ route('admin.beauty-salon.personel.index') }}" class="mobile-menu-item {{ request()->routeIs('admin.beauty-salon.personel.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-people"></i>
                        <span>Personel</span>
                    </a>
                @endif
                    <a href="{{ route('admin.help.faq') }}" class="mobile-menu-item {{ request()->routeIs('admin.help.*') ? 'active' : '' }}" onclick="closeMobileMenu()">
                        <i class="bi bi-question-circle"></i>
                        <span>Yardım</span>
                    </a>
                </div>
            @endif
            
            <div class="mobile-menu-section">
                <div class="mobile-menu-section-title">Hızlı İşlemler</div>
                <!-- Yeni Randevu butonu kaldırıldı -->
                <a href="#" class="mobile-menu-item" onclick="event.preventDefault(); openNewCustomerModal(); closeMobileMenu();">
                    <i class="bi bi-person-plus"></i>
                    <span>Yeni Müşteri</span>
                </a>
                <a href="{{ auth()->check() && auth()->user()->isSuperAdmin() ? route('admin.settings.general') : route('admin.settings.membership') }}" class="mobile-menu-item" onclick="closeMobileMenu()">
                    <i class="bi bi-gear"></i>
                    <span>Ayarlar</span>
                </a>
            </div>
            
            <!-- Profil Menüsü Bölümü - Mobilde görünür -->
            @auth
            <div class="mobile-menu-section" style="border-top: 2px solid #e5e7eb; margin-top: 20px; padding-top: 16px;">
                <div class="mobile-menu-section-title">Hesap</div>
                <div class="px-4 py-3 mb-3" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px; color: white;">
                    <div class="d-flex align-items-center gap-3">
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle" style="width: 48px; height: 48px; background: rgba(255,255,255,0.2);">
                            <i class="bi bi-person-circle" style="font-size: 28px; color: white;"></i>
                        </div>
                        <div>
                            <p class="mb-0 fw-bold" style="color: white;">{{ Auth::check() ? Auth::user()->name : 'Kullanıcı' }}</p>
                            <small style="opacity: 0.9; font-size: 12px; color: white;">
                                @if(Auth::check() && Auth::user()->isPersonel())
                                    Personel
                                @elseif(Auth::check() && Auth::user()->isBeautySalon())
                                    {{ Auth::user()->phone ?? 'Güzellik Salonu' }}
                                @else
                                    Kullanıcı
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
                <a href="{{ auth()->check() && auth()->user()->isSuperAdmin() ? route('admin.settings.general') : route('admin.settings.membership') }}" class="mobile-menu-item" onclick="closeMobileMenu();">
                    <i class="bi bi-gear"></i>
                    <span>Ayarlar</span>
                </a>
                <div style="border-top: 1px solid #e5e7eb; margin: 12px 20px;"></div>
                <form method="POST" action="{{ route('logout') }}" id="logoutFormMobile">
                    @csrf
                    <a href="#" onclick="event.preventDefault(); document.getElementById('logoutFormMobile').submit();" class="mobile-menu-item" style="color: #ef4444;" onmouseover="this.style.background='#fef2f2'; this.style.color='#dc2626';" onmouseout="this.style.background='transparent'; this.style.color='#ef4444';">
                        <i class="bi bi-box-arrow-right"></i>
                        <span>Çıkış Yap</span>
                    </a>
                </form>
            </div>
            @endauth
        </div>
    </div>

    <!-- Main Navbar - KALDIRILDI (menü header içine taşındı) -->

    <!-- Main Content -->
    <div class="main-content">
        <div class="content-wrapper">
            <!-- Session flash mesajları artık popup olarak gösteriliyor (aşağıda script ile) -->
            
            @if(isset($errors) && $errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($showFreeCampaignBanner)
                <div class="alert alert-warning border-0 mb-3" role="alert">
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start gap-2">
                        <div>
                            <div class="fw-semibold">
                                <i class="bi bi-info-circle me-1"></i>
                                Ücretsiz kullanım bitimine {{ $freeCampaignDaysLeft }} gün kaldı
                            </div>
                            <div class="small">
                                Bitiş tarihi: <strong>{{ $freeCampaignEndDate }}</strong>. Devam için paket seçebilir veya kupon kodunuzu kullanabilirsiniz.
                            </div>
                        </div>
                        <a href="{{ route('admin.packages.select') }}" class="btn btn-sm btn-dark">
                            Paketleri Incele
                        </a>
                    </div>
                </div>
            @endif
            
            @yield('content')
        </div>
    </div>
    
    <!-- Settings Sidebar -->
    <div class="settings-sidebar" id="settingsSidebar">
        <div class="settings-sidebar-header">
            <h5>
                @if(request()->routeIs('admin.beauty-salon.loyalty.*') || request()->routeIs('admin.beauty-salon.campaigns.*') || request()->routeIs('admin.beauty-salon.referrals.*') || request()->routeIs('admin.beauty-salon.branches.*') || request()->routeIs('admin.beauty-salon.staff-performance.*') || request()->routeIs('admin.beauty-salon.smart-pricing.*') || request()->routeIs('admin.beauty-salon.customer-directory.*'))
                    <i class="bi bi-puzzle-fill me-2"></i> Eklentiler
                @else
                    <i class="bi bi-gear-fill me-2"></i> Ayarlar
                @endif
            </h5>
        </div>
        
        @if(request()->routeIs('admin.beauty-salon.loyalty.*') || request()->routeIs('admin.beauty-salon.campaigns.*') || request()->routeIs('admin.beauty-salon.referrals.*') || request()->routeIs('admin.beauty-salon.memberships.*') || request()->routeIs('admin.beauty-salon.branches.*') || request()->routeIs('admin.beauty-salon.staff-performance.*') || request()->routeIs('admin.beauty-salon.clv.*') || request()->routeIs('admin.beauty-salon.smart-pricing.*') || request()->routeIs('admin.beauty-salon.customer-directory.*'))
        <!-- Eklentiler Menüsü -->
        <div class="settings-sidebar-divider"></div>
        <div class="settings-sidebar-section-title">
            <i class="bi bi-star-fill" style="color: #fbbf24;"></i> Premium Özellikler
        </div>
        @php
            $plugins = [];
        @endphp
        @if(($plugins['loyalty'] ?? false))
        <div class="settings-sidebar-item-wrapper">
            <a href="{{ route('admin.beauty-salon.loyalty.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.beauty-salon.loyalty.*') ? 'active' : '' }}">
                <i class="bi bi-credit-card"></i> Kart Programı
            </a>
            <button type="button" class="settings-sidebar-info-btn" data-bs-toggle="modal" data-bs-target="#premiumInfoModal" data-feature="loyalty" onclick="showPremiumInfo('loyalty')">
                <i class="bi bi-info-circle"></i>
            </button>
        </div>
        @endif
        @if(($plugins['referral'] ?? false))
        <div class="settings-sidebar-item-wrapper">
            <a href="{{ route('admin.beauty-salon.referrals.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.beauty-salon.referrals.*') ? 'active' : '' }}">
                <i class="bi bi-people-fill"></i> Referans Sistemi
            </a>
            <button type="button" class="settings-sidebar-info-btn" data-bs-toggle="modal" data-bs-target="#premiumInfoModal" data-feature="referral" onclick="showPremiumInfo('referral')">
                <i class="bi bi-info-circle"></i>
            </button>
        </div>
        @endif
        @if(($plugins['branch'] ?? false))
        <div class="settings-sidebar-item-wrapper">
            <a href="{{ route('admin.beauty-salon.branches.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.beauty-salon.branches.*') ? 'active' : '' }}" style="opacity: 0.6; position: relative;">
                <i class="bi bi-building"></i> Şube Yönetimi
                <span class="badge bg-warning text-dark ms-2" style="font-size: 0.7rem;">Bakımda</span>
            </a>
            <button type="button" class="settings-sidebar-info-btn" data-bs-toggle="modal" data-bs-target="#premiumInfoModal" data-feature="branch" onclick="showPremiumInfo('branch')">
                <i class="bi bi-info-circle"></i>
            </button>
        </div>
        @endif
        @if(($plugins['staff_performance'] ?? false))
        <div class="settings-sidebar-item-wrapper">
            <a href="{{ route('admin.beauty-salon.staff-performance.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.beauty-salon.staff-performance.*') ? 'active' : '' }}">
                <i class="bi bi-trophy-fill"></i> Personel Performans
            </a>
            <button type="button" class="settings-sidebar-info-btn" data-bs-toggle="modal" data-bs-target="#premiumInfoModal" data-feature="staff_performance" onclick="showPremiumInfo('staff_performance')">
                <i class="bi bi-info-circle"></i>
            </button>
        </div>
        @endif
        @if(($plugins['smart_pricing'] ?? false))
        <div class="settings-sidebar-item-wrapper">
            <a href="{{ route('admin.beauty-salon.smart-discount.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.beauty-salon.smart-discount.*') ? 'active' : '' }}">
                <i class="bi bi-percent"></i> Akıllı İndirim
            </a>
            <button type="button" class="settings-sidebar-info-btn" data-bs-toggle="modal" data-bs-target="#premiumInfoModal" data-feature="smart_pricing" onclick="showPremiumInfo('smart_pricing')">
                <i class="bi bi-info-circle"></i>
            </button>
        </div>
        @endif
        <div class="settings-sidebar-item-wrapper">
            <a href="{{ route('admin.beauty-salon.customer-directory.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.beauty-salon.customer-directory.*') ? 'active' : '' }}">
                <i class="bi bi-book"></i> Müşteri Rehberi
            </a>
        </div>
        @else
        <!-- Ayarlar Menüsü -->
        <!-- Hesap Ayarları -->
        <div class="settings-sidebar-section-title">
            <i class="bi bi-person-circle"></i> Hesap
        </div>
        <a href="{{ route('admin.account.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.account.*') ? 'active' : '' }}">
            <i class="bi bi-person-badge"></i> Hesap Ayarları
        </a>
        <a href="{{ route('admin.settings.membership') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.membership') ? 'active' : '' }}">
            <i class="bi bi-credit-card"></i> Üyelik Bilgilerim
        </a>
        @if(Route::has('admin.settings.invoice-info'))
        <a href="{{ route('admin.settings.invoice-info') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.invoice-info') ? 'active' : '' }}">
            <i class="bi bi-receipt"></i> Fatura Bilgileri
        </a>
        @endif
        @if(Route::has('admin.settings.personal-invoices'))
        <a href="{{ route('admin.settings.personal-invoices') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.personal-invoices') ? 'active' : '' }}">
            <i class="bi bi-receipt"></i> Kişisel Faturalar
        </a>
        @endif
        
        @if(auth()->check() && (auth()->user()->isBeautySalon() || auth()->user()->role === 'admin'))
        <!-- Salon Ayarları -->
        <div class="settings-sidebar-divider"></div>
        <div class="settings-sidebar-section-title">
            <i class="bi bi-building"></i> Salon
        </div>
        <a href="{{ route('admin.beauty-salon.profile') }}" class="settings-sidebar-item {{ request()->routeIs('admin.beauty-salon.profile*') ? 'active' : '' }}">
            <i class="bi bi-building"></i> Salon Profili
        </a>
        @endif
        
        @if(auth()->check() && auth()->user()->isSuperAdmin())
        <!-- Süper Admin Ayarları -->
        <div class="settings-sidebar-divider"></div>
        <div class="settings-sidebar-section-title">
            <i class="bi bi-shield-check"></i> Sistem
        </div>
        <a href="{{ route('admin.settings.salons.index') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.salons.*') ? 'active' : '' }}">
            <i class="bi bi-building"></i> Salon Yönetimi
        </a>
        <a href="{{ route('admin.settings.homepage') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.homepage') ? 'active' : '' }}">
            <i class="bi bi-house"></i> Ana Sayfa Ayarları
        </a>
        <a href="{{ route('admin.settings.sms') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.sms') ? 'active' : '' }}">
            <i class="bi bi-chat-dots"></i> SMS Ayarları
        </a>
        <a href="{{ route('admin.settings.general') }}" class="settings-sidebar-item {{ request()->routeIs('admin.settings.general') ? 'active' : '' }}">
            <i class="bi bi-gear"></i> Genel Ayarlar
        </a>
        @endif
        @endif
    </div>
    
    <!-- Modals -->
    @include('partials.modals')
    @include('partials.modals-appointments-contacts')
    
    <!-- Premium Feature Info Modal -->
    <div class="modal fade" id="premiumInfoModal" tabindex="-1" aria-labelledby="premiumInfoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content" style="border: none; border-radius: 16px;">
                <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="modal-title text-white fw-bold" id="premiumInfoModalLabel">
                        <i class="bi bi-star-fill me-2"></i><span id="premiumInfoTitle">Premium Özellik</span>
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                    <div id="premiumInfoContent">
                        <p class="text-muted">Yükleniyor...</p>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Özel Onay Kutusu - Bootstrap Modal KULLANMIYOR -->
    <div id="customConfirmBox" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 999999;">
        <!-- Backdrop -->
        <div id="customConfirmBackdrop" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5);"></div>
        <!-- Dialog -->
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 1000000; width: 90%; max-width: 450px; padding: 0 15px;">
            <div style="background: white; border-radius: 16px; box-shadow: 0 25px 50px rgba(0,0,0,0.25); min-width: 300px; max-width: 100%; overflow: hidden;">
                <div style="background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); padding: 20px 24px;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div style="width: 50px; height: 50px; background: linear-gradient(135deg, #f59e0b 0%, #ef4444 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                            <i class="bi bi-exclamation-triangle-fill text-white" style="font-size: 24px;"></i>
                        </div>
                        <div style="flex: 1;">
                            <h5 style="margin: 0; color: #1f2937; font-weight: 600;">Onay Gerekli</h5>
                        </div>
                        <button type="button" id="customConfirmClose" style="background: none; border: none; font-size: 24px; color: #6b7280; cursor: pointer; padding: 0; line-height: 1;">&times;</button>
                    </div>
                </div>
                <div style="padding: 24px;">
                    <p id="customConfirmMessage" style="margin: 0; color: #4b5563; font-size: 15px;">Bu işlemi yapmak istediğinize emin misiniz?</p>
                </div>
                <div style="padding: 16px 24px; background: #f9fafb; display: flex; justify-content: flex-end; gap: 12px;">
                    <button type="button" id="customConfirmCancel" style="padding: 10px 20px; border: 1px solid #d1d5db; background: white; color: #374151; border-radius: 8px; font-weight: 500; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                        <i class="bi bi-x-circle"></i> İptal
                    </button>
                    <button type="button" id="customConfirmOk" style="padding: 10px 20px; border: none; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); color: white; border-radius: 8px; font-weight: 500; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                        <i class="bi bi-check-circle"></i> Onayla
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Başarı/Hata/Bilgi Popup Kutusu -->
    <div id="customPopupBox" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 999998;">
        <!-- Backdrop -->
        <div id="customPopupBackdrop" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.4);"></div>
        <!-- Dialog -->
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 999999;">
            <div style="background: white; border-radius: 16px; box-shadow: 0 25px 50px rgba(0,0,0,0.25); min-width: 400px; max-width: 450px; overflow: hidden;">
                <div id="customPopupHeader" style="padding: 20px 24px;">
                    <div style="display: flex; align-items: center; gap: 16px;">
                        <div id="customPopupIcon" style="width: 50px; height: 50px; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                            <i id="customPopupIconClass" class="text-white" style="font-size: 24px;"></i>
                        </div>
                        <div style="flex: 1;">
                            <h5 id="customPopupTitle" style="margin: 0; color: #1f2937; font-weight: 600;"></h5>
                        </div>
                        <button type="button" id="customPopupClose" style="background: none; border: none; font-size: 24px; color: #6b7280; cursor: pointer; padding: 0; line-height: 1;">&times;</button>
                    </div>
                </div>
                <div style="padding: 24px;">
                    <p id="customPopupMessage" style="margin: 0; color: #4b5563; font-size: 15px; line-height: 1.6;"></p>
                </div>
                <div style="padding: 16px 24px; background: #f9fafb; display: flex; justify-content: flex-end;">
                    <button type="button" id="customPopupOk" style="padding: 10px 24px; border: none; border-radius: 8px; font-weight: 500; cursor: pointer; display: flex; align-items: center; gap: 8px; color: white;">
                        <i class="bi bi-check-circle"></i> Tamam
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    
    <!-- Randevu Detay Modal -->
    <div class="modal fade" id="reservationDetailModal" tabindex="-1" aria-labelledby="reservationDetailModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="modal-title text-white fw-bold" id="reservationDetailModalLabel">
                        <i class="bi bi-calendar3"></i> Randevu Detayları
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="reservationDetailContent" style="max-height: 70vh; overflow-y: auto;">
                    <div class="text-center py-5">
                        <div class="loading-content" style="display: flex; flex-direction: column; align-items: center; gap: 20px;">
                            <img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" class="loading-gif" style="width: 200px; height: auto; max-height: 200px; object-fit: contain;">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                    <button type="button" class="btn btn-primary" id="confirmReservationBtn" onclick="confirmReservation()" style="display: none;">
                        <i class="bi bi-check-circle"></i> Onayla
                    </button>
                    <button type="button" class="btn btn-success" id="completeReservationBtn" onclick="completeReservation()" style="display: none;">
                        <i class="bi bi-check2-all"></i> Onayla ve Bitir
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Session Flash Mesajları için Popup -->
    @if(session('success'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('success', '{{ session('success') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('success', '{{ session('success') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('error'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('error', '{{ session('error') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('error', '{{ session('error') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('warning'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('warning', '{{ session('warning') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('warning', '{{ session('warning') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('info'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof showToast === 'function') {
                    showToast('info', '{{ session('info') }}');
                } else if (typeof showPopup === 'function') {
                    showPopup('info', '{{ session('info') }}');
                }
            }, 300);
        });
        </script>
    @endif
    
    @if(session('sms_warning') && !$hasPendingPackagePayment)
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const smsWarningModal = new bootstrap.Modal(document.getElementById('smsBalanceWarningModal'));
                smsWarningModal.show();
            }, 500);
        });
        </script>
    @endif
    
    <script>
    let currentReservationId = null;
    
    function openReservationDetailModal(reservationId) {
        currentReservationId = reservationId;
        const modal = new bootstrap.Modal(document.getElementById('reservationDetailModal'));
        modal.show();
        
        // İçeriği yükle
        loadReservationDetails(reservationId);
    }
    
    // Alias function for compatibility - Global scope'a ekle
    window.showReservationDetail = function(reservationId) {
        if (typeof openReservationDetailModal === 'function') {
            openReservationDetailModal(reservationId);
        } else {
            console.error('openReservationDetailModal fonksiyonu bulunamadı');
        }
    };
    
    function loadReservationDetails(reservationId) {
        const content = document.getElementById('reservationDetailContent');
        if (!content) {
            console.error('reservationDetailContent elementi bulunamadı');
            return;
        }
        
        // reservationId'yi sakla (catch bloğunda kullanmak için)
        const originalReservationId = reservationId;
        
        content.innerHTML = '<div class="text-center py-5"><div class="loading-content" style="display: flex; flex-direction: column; align-items: center; gap: 20px;"><img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" class="loading-gif" style="width: 200px; height: auto; max-height: 200px; object-fit: contain;"></div></div>';
        
        // reservationId'yi string'den number'a çevir
        reservationId = parseInt(reservationId);
        if (isNaN(reservationId)) {
            content.innerHTML = '<div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i> <strong>Hata:</strong> Geçersiz randevu ID\'si: ' + originalReservationId + '</div>';
            return;
        }
        
        const url = '{{ route("admin.appointments.show", ":id") }}'.replace(':id', reservationId);
        fetch(url, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
            }
        })
        .then(response => {
            if (!response.ok) {
                // Response'u text olarak oku, sonra JSON'a çevirmeyi dene
                return response.text().then(text => {
                    let errorData;
                    try {
                        errorData = JSON.parse(text);
                    } catch (e) {
                        errorData = { error: 'HTTP ' + response.status, message: text || 'Bilinmeyen hata' };
                    }
                    throw new Error(errorData.message || errorData.error || 'HTTP ' + response.status);
                });
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                content.innerHTML = '<div class="alert alert-danger">' + data.error + '</div>';
                return;
            }
            
            const reservation = data.reservation || data;
            const customer = data.customer;
            const service = reservation.appointment_request?.service || (data.service ? { name: data.service.name, price: data.service.price } : null);
            
            let html = '<div class="row g-3">';
            
            // Sol taraf: Müşteri ve Randevu Bilgileri
            html += '<div class="col-md-6">';
            html += '<div class="card shadow-sm mb-3" style="border-radius: 12px; border: none;">';
            html += '<div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">';
            html += '<h6 class="mb-0 text-white fw-bold"><i class="bi bi-person-circle me-2"></i>Müşteri Bilgileri</h6>';
            html += '</div>';
            html += '<div class="card-body p-3">';
            if (customer) {
                html += '<p class="mb-2"><strong>Ad Soyad:</strong> ' + (customer.name || '-') + ' ' + (customer.surname || '') + '</p>';
                html += '<p class="mb-2"><strong>Telefon:</strong> ' + (customer.phone || '-') + '</p>';
                if (customer.email) {
                    html += '<p class="mb-2"><strong>E-posta:</strong> ' + customer.email + '</p>';
                }
            } else {
                html += '<p class="text-muted">Müşteri bilgisi bulunamadı.</p>';
            }
            html += '</div></div>';
            
            html += '<div class="card shadow-sm" style="border-radius: 12px; border: none;">';
            html += '<div class="card-header" style="background: linear-gradient(135deg, #f472b6 0%, #ec4899 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">';
            html += '<h6 class="mb-0 text-white fw-bold"><i class="bi bi-calendar3 me-2"></i>Randevu Bilgileri</h6>';
            html += '</div>';
            html += '<div class="card-body p-3">';
            html += '<p class="mb-2"><strong>Tarih:</strong> ' + (reservation.date ? new Date(reservation.date).toLocaleDateString('tr-TR') : '-') + '</p>';
            html += '<p class="mb-2"><strong>Saat:</strong> ' + (reservation.start_time || '-') + '</p>';
            if (service) {
                html += '<p class="mb-2"><strong>Hizmet:</strong> ' + service.name + '</p>';
                if (service.price) {
                    html += '<p class="mb-2"><strong>Fiyat:</strong> ' + parseFloat(service.price).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺</p>';
                }
            }
            if (reservation.personel) {
                html += '<p class="mb-2"><strong>Personel:</strong> ' + reservation.personel.name + '</p>';
            }
            if (reservation.room) {
                html += '<p class="mb-2"><strong>Oda:</strong> ' + reservation.room.name + '</p>';
            }
            html += '<p class="mb-2"><strong>Durum:</strong> ';
            if (reservation.status === 'pending' || reservation.status === 'open') {
                html += '<span class="badge bg-warning">Beklemede</span>';
            } else if (reservation.status === 'confirmed') {
                html += '<span class="badge bg-success">Onaylandı</span>';
            } else if (reservation.status === 'completed') {
                html += '<span class="badge bg-info">Tamamlandı</span>';
            } else {
                html += '<span class="badge bg-danger">İptal</span>';
            }
            html += '</p>';
            if (reservation.notes) {
                html += '<p class="mb-0"><strong>Notlar:</strong> ' + reservation.notes + '</p>';
            }
            html += '</div></div>';
            html += '</div>';
            
            // Sağ taraf: Ödeme Bilgileri ve İşlemler
            html += '<div class="col-md-6">';
            html += '<div class="card shadow-sm mb-3" style="border-radius: 12px; border: none;">';
            html += '<div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">';
            html += '<h6 class="mb-0 text-white fw-bold"><i class="bi bi-cash-coin me-2"></i>Ödeme Bilgileri</h6>';
            html += '</div>';
            html += '<div class="card-body p-3">';
            html += '<p class="mb-2"><strong>Toplam Tutar:</strong> <span class="text-success fw-bold">' + parseFloat(reservation.total_price || 0).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺</span></p>';
            html += '<p class="mb-2"><strong>Ödenen:</strong> ' + parseFloat(reservation.deposit_paid || 0).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺</p>';
            const remaining = parseFloat(reservation.remaining_amount || 0);
            html += '<p class="mb-0"><strong>Kalan:</strong> <span class="' + (remaining > 0 ? 'text-danger' : 'text-success') + ' fw-bold">' + remaining.toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺</span></p>';
            html += '</div></div>';
            
            html += '<div class="card shadow-sm" style="border-radius: 12px; border: none;">';
            html += '<div class="card-header" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">';
            html += '<h6 class="mb-0 text-white fw-bold"><i class="bi bi-gear me-2"></i>İşlemler</h6>';
            html += '</div>';
            html += '<div class="card-body p-3">';
            html += '<div class="d-grid gap-2">';
            
            // Onayla butonu (sadece pending/open durumunda)
            if (reservation.status === 'pending' || reservation.status === 'open') {
                html += '<button type="button" class="btn btn-success fw-bold" onclick="confirmReservation(' + reservation.id + ')">';
                html += '<i class="bi bi-check-circle me-2"></i>Onayla';
                html += '</button>';
            }
            
            // Bitir butonu (sadece confirmed durumunda)
            if (reservation.status === 'confirmed') {
                html += '<button type="button" class="btn btn-primary fw-bold" onclick="completeReservation(' + reservation.id + ')">';
                html += '<i class="bi bi-check2-all me-2"></i>Bitir ve Kasaya Ekle';
                html += '</button>';
            }
            
            html += '<button type="button" class="btn btn-secondary fw-bold" data-bs-dismiss="modal">';
            html += '<i class="bi bi-x-circle me-2"></i>Kapat';
            html += '</button>';
            html += '</div></div></div>';
            html += '</div></div>';
            html += '</div></div>';
            
            content.innerHTML = html;
        })
        .catch(error => {
            console.error('Randevu detayı yüklenirken hata:', error);
            const errorMessage = error.message || 'Randevu bilgileri yüklenirken bir hata oluştu.';
            if (content) {
                content.innerHTML = `
                    <div class="alert alert-danger">
                        <i class="bi bi-exclamation-triangle"></i> 
                        <strong>Hata:</strong> ${errorMessage}
                        <br><small>Randevu ID: ${originalReservationId}</small>
                        <br><button class="btn btn-sm btn-outline-danger mt-2" onclick="window.location.reload()">Sayfayı Yenile</button>
                    </div>
                `;
            }
        });
    }
    
    // Randevuyu onayla
    window.confirmReservation = function(reservationId) {
        if (!confirm('Bu randevuyu onaylamak istediğinize emin misiniz?')) return;
        
        const confirmUrl = '{{ route("admin.appointments.confirm", ["id" => ":id"]) }}'.replace(':id', reservationId);
        
        fetch(confirmUrl, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(async response => {
            const data = await response.json();
            if (!response.ok) {
                throw new Error(data.message || 'HTTP ' + response.status);
            }
            return data;
        })
        .then(data => {
            if (data.success) {
                alert('Randevu başarıyla onaylandı!');
                const modal = bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal'));
                if (modal) modal.hide();
                setTimeout(() => window.location.reload(), 1000);
            } else {
                alert(data.message || 'Hata oluştu');
            }
        })
        .catch(error => {
            console.error('Randevu onaylama hatası:', error);
            alert(error.message || 'Randevu onaylanırken bir hata oluştu.');
        });
    };
    
    // Randevuyu bitir ve kasaya ekle
    window.completeReservation = function(reservationId) {
        if (!confirm('Bu randevuyu bitirmek ve kalan ödemeyi kasaya eklemek istediğinize emin misiniz?')) return;
        
        const completeUrl = '{{ route("admin.appointments.complete", ["id" => ":id"]) }}'.replace(':id', reservationId);
        
        fetch(completeUrl, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(async response => {
            const data = await response.json();
            if (!response.ok) {
                throw new Error(data.message || 'HTTP ' + response.status);
            }
            return data;
        })
        .then(data => {
            if (data.success) {
                alert(data.message || 'Randevu başarıyla tamamlandı!');
                const modal = bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal'));
                if (modal) modal.hide();
                setTimeout(() => window.location.reload(), 1000);
            } else {
                alert(data.message || 'Hata oluştu');
            }
        })
        .catch(error => {
            console.error('Randevu tamamlama hatası:', error);
            alert(error.message || 'Randevu tamamlanırken bir hata oluştu.');
        });
    };
    
    async function confirmReservation() {
        if (!currentReservationId) return;
        
        const confirmed = await customConfirm('Bu randevuu onaylamak istediğinize emin misiniz?');
        if (!confirmed) {
            return;
        }
        
        const btn = document.getElementById('confirmReservationBtn');
        btn.disabled = true;
        const loadingGifUrl = '{{ asset("splashlogo.gif") }}';
        btn.innerHTML = '<img src="' + loadingGifUrl + '" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">İşleniyor...';
        
        const randevularBaseUrl = '{{ url("admin/randevular") }}';
        fetch(`${randevularBaseUrl}/${currentReservationId}/onayla`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
                window.location.reload();
            } else {
                alert('Bir hata oluştu: ' + (data.message || 'Bilinmeyen hata'));
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-check-circle"></i> Onayla';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Randevu onaylanırken bir hata oluştu.');
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-check-circle"></i> Onayla';
        });
    }
    
    async function completeReservation() {
        if (!currentReservationId) return;
        
        const confirmed = await customConfirm('Bu randevuu tamamlamak istediğinize emin misiniz?');
        if (!confirmed) {
            return;
        }
        
        const btn = document.getElementById('completeReservationBtn');
        btn.disabled = true;
        const loadingGifUrl = '{{ asset("splashlogo.gif") }}';
        btn.innerHTML = '<img src="' + loadingGifUrl + '" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">İşleniyor...';
        
        const randevularBaseUrl2 = '{{ url("admin/randevular") }}';
        fetch(`${randevularBaseUrl2}/${currentReservationId}/tamamla`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
                window.location.reload();
            } else {
                alert('Bir hata oluştu: ' + (data.message || 'Bilinmeyen hata'));
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-check2-all"></i> Onayla ve Bitir';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Randevu tamamlanırken bir hata oluştu.');
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-check2-all"></i> Onayla ve Bitir';
        });
    }
    </script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Özel Confirm Dialog Sistemi - Bootstrap Modal KULLANMIYOR
        let confirmResolve = null;
        
        function customConfirm(message) {
            return new Promise((resolve) => {
                confirmResolve = resolve;
                
                const box = document.getElementById('customConfirmBox');
                const messageEl = document.getElementById('customConfirmMessage');
                
                if (messageEl) {
                    messageEl.textContent = message || 'Bu işlemi yapmak istediğinize emin misiniz?';
                }
                
                // Kutuyu göster
                box.style.display = 'block';
                document.body.style.overflow = 'hidden';
            });
        }
        
        function hideConfirmBox() {
            const box = document.getElementById('customConfirmBox');
            box.style.display = 'none';
            document.body.style.overflow = '';
        }
        
        // Popup mesaj göster (başarı, hata, bilgi)
        function showPopup(type, message, title = null) {
            const box = document.getElementById('customPopupBox');
            const icon = document.getElementById('customPopupIcon');
            const iconClass = document.getElementById('customPopupIconClass');
            const titleEl = document.getElementById('customPopupTitle');
            const messageEl = document.getElementById('customPopupMessage');
            const header = document.getElementById('customPopupHeader');
            const okBtn = document.getElementById('customPopupOk');
            
            // Tip'e göre renk ve ikon ayarla
            let bgColor, iconBg, iconName, defaultTitle;
            if (type === 'success') {
                bgColor = 'linear-gradient(135deg, #ec4899 0%, #db2777 100%)';
                iconBg = 'linear-gradient(135deg, #ec4899 0%, #db2777 100%)';
                iconName = 'bi-check-circle-fill';
                defaultTitle = 'Başarılı';
            } else if (type === 'error') {
                bgColor = 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)';
                iconBg = 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)';
                iconName = 'bi-x-circle-fill';
                defaultTitle = 'Hata';
            } else if (type === 'warning') {
                bgColor = 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)';
                iconBg = 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)';
                iconName = 'bi-exclamation-triangle-fill';
                defaultTitle = 'Uyarı';
            } else {
                bgColor = 'linear-gradient(135deg, #f472b6 0%, #ec4899 100%)';
                iconBg = 'linear-gradient(135deg, #f472b6 0%, #ec4899 100%)';
                iconName = 'bi-info-circle-fill';
                defaultTitle = 'Bilgi';
            }
            
            header.style.background = bgColor;
            icon.style.background = iconBg;
            iconClass.className = iconName + ' text-white';
            titleEl.textContent = title || defaultTitle;
            titleEl.style.color = 'white';
            messageEl.textContent = message;
            okBtn.style.background = iconBg;
            
            box.style.display = 'block';
            document.body.style.overflow = 'hidden';
            
            // Otomatik kapanma (5 saniye)
            setTimeout(() => {
                hidePopup();
            }, 5000);
        }
        
        function hidePopup() {
            const box = document.getElementById('customPopupBox');
            box.style.display = 'none';
            document.body.style.overflow = '';
        }
        
        // Global showToast fonksiyonunu popup'a yönlendir
        window.showToast = function(type, message) {
            showPopup(type, message);
        };
        
        // Browser alert() fonksiyonunu override et - site içi popup kullan
        window.alert = function(message) {
            showPopup('info', message, 'Bilgi');
        };
        
        // Browser confirm() fonksiyonunu override et - site içi popup kullan
        window.confirm = function(message) {
            return customConfirm(message);
        };
        
        // Event listener'ları ekle
        document.addEventListener('DOMContentLoaded', function() {
            const okBtn = document.getElementById('customConfirmOk');
            const cancelBtn = document.getElementById('customConfirmCancel');
            const closeBtn = document.getElementById('customConfirmClose');
            const backdrop = document.getElementById('customConfirmBackdrop');
            
            if (okBtn) {
                okBtn.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(true);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            if (cancelBtn) {
                cancelBtn.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(false);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            if (closeBtn) {
                closeBtn.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(false);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            // Backdrop'a tıklanınca kapat
            if (backdrop) {
                backdrop.addEventListener('click', function() {
                    if (confirmResolve) {
                        confirmResolve(false);
                        confirmResolve = null;
                    }
                    hideConfirmBox();
                });
            }
            
            // Popup event listener'ları
            const popupOk = document.getElementById('customPopupOk');
            const popupClose = document.getElementById('customPopupClose');
            const popupBackdrop = document.getElementById('customPopupBackdrop');
            
            if (popupOk) {
                popupOk.addEventListener('click', function() {
                    hidePopup();
                });
            }
            
            if (popupClose) {
                popupClose.addEventListener('click', function() {
                    hidePopup();
                });
            }
            
            if (popupBackdrop) {
                popupBackdrop.addEventListener('click', function() {
                    hidePopup();
                });
            }
            
            // Escape tuşuna basılınca kapat
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    const popupBox = document.getElementById('customPopupBox');
                    if (popupBox && popupBox.style.display !== 'none') {
                        hidePopup();
                        return;
                    }
                    const box = document.getElementById('customConfirmBox');
                    if (box && box.style.display === 'block') {
                        if (confirmResolve) {
                            confirmResolve(false);
                            confirmResolve = null;
                        }
                        hideConfirmBox();
                    }
                }
            });
            
            // Form submit'lerdeki confirm'leri handle et
            document.querySelectorAll('.delete-form').forEach(form => {
                form.addEventListener('submit', async function(e) {
                    e.preventDefault();
                    const message = this.getAttribute('data-message') || 'Bu kaydı silmek istediğinize emin misiniz?';
                    const confirmed = await customConfirm(message);
                    if (confirmed) {
                        this.submit();
                    }
                });
            });
        });
        
        // Chrome'un varsayılan confirm'ini override et (global)
        // window.confirm ve window.alert artık override edildi ve site içi popup kullanıyor
        
        // Global Search Functionality
        let searchTimeout;
        const searchInput = document.getElementById('globalSearch');
        const searchResults = document.getElementById('searchResults');

        if (searchInput && searchResults) {
            searchInput.addEventListener('input', function() {
                clearTimeout(searchTimeout);
                const query = this.value.trim();

                if (query.length < 2) {
                    searchResults.classList.remove('show');
                    return;
                }

                searchTimeout = setTimeout(() => {
                    const searchRoute = '{{ route("admin.search") }}';
                    fetch(`${searchRoute}?q=${encodeURIComponent(query)}`, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        credentials: 'same-origin'
                    })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Arama isteği başarısız: ' + response.status);
                            }
                            return response.json();
                        })
                        .then(data => {
                            displaySearchResults(data);
                        })
                        .catch(error => {
                            console.error('Arama hatası:', error);
                            if (searchResults) {
                                searchResults.innerHTML = '<div class="search-result-item"><div class="text-center text-danger w-100">Arama sırasında bir hata oluştu</div></div>';
                                searchResults.classList.add('show');
                            }
                        });
                }, 300);
            });
            
            searchInput.addEventListener('focus', function() {
                if (this.value.trim().length >= 2 && searchResults.innerHTML.trim() !== '') {
                    searchResults.classList.add('show');
                }
            });
        }
        
        function displaySearchResults(data) {
            let html = '';
            let hasResults = false;
            let currentCustomerId = null;

            // Müşteriler ve Randevuları
            if (data.customers && data.customers.length > 0) {
                hasResults = true;
                
                data.customers.forEach(item => {
                    if (item.is_customer) {
                        // Müşteri başlığı
                        html += `
                            <div class="search-customer-header">
                                <a href="${item.url}" class="search-result-item customer-item">
                                    <div class="search-result-icon" style="background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%); color: white;">
                                        <i class="bi ${item.icon}"></i>
                                    </div>
                                    <div class="search-result-content">
                                        <div class="search-result-title fw-bold">${item.title}</div>
                                        <div class="search-result-subtitle">${item.subtitle || ''}</div>
                                    </div>
                                    <div class="search-result-type badge bg-primary">${item.type}</div>
                                </a>
                            </div>
                        `;
                        currentCustomerId = item.id;
                    } else {
                        // Randevu (müşterinin altında veya personel için direkt randevu)
                        let statusClass = 'bg-secondary';
                        if (item.type === 'Açık') statusClass = 'bg-warning text-dark';
                        else if (item.type === 'Onaylı') statusClass = 'bg-success';
                        else if (item.type === 'İptal') statusClass = 'bg-danger';
                        else if (item.type === 'Tamamlandı') statusClass = 'bg-info';
                        
                        // Personel için modal aç, diğerleri için sayfaya yönlendir
                        let clickHandler = '';
                        if (item.reservation_id && typeof window.showReservationDetail === 'function') {
                            clickHandler = `onclick="event.preventDefault(); window.showReservationDetail(${item.reservation_id}); document.getElementById('searchResults').classList.remove('show');"`;
                        }
                        
                        const paddingLeft = item.is_customer ? '50px' : '15px';
                        html += `
                            <a href="${item.url === '#' ? 'javascript:void(0)' : item.url}" ${clickHandler} class="search-result-item reservation-item" style="padding-left: ${paddingLeft}; background: #f8fafc; cursor: pointer;">
                                <div class="search-result-icon" style="background: #e2e8f0; color: #64748b; width: 32px; height: 32px; font-size: 14px;">
                                    <i class="bi ${item.icon}"></i>
                                </div>
                                <div class="search-result-content">
                                    <div class="search-result-title" style="font-size: 13px;">${item.title}</div>
                                    ${item.subtitle ? `<div class="search-result-subtitle" style="font-size: 11px; color: #64748b; margin-top: 2px;">${item.subtitle}</div>` : ''}
                                </div>
                                <div class="search-result-type badge ${statusClass}" style="font-size: 10px;">${item.type}</div>
                            </a>
                        `;
                    }
                });
            }

            if (!hasResults) {
                html = '<div class="search-result-item"><div class="text-center text-muted w-100 py-3"><i class="bi bi-search me-2"></i>Sonuç bulunamadı</div></div>';
            }

            if (searchResults) {
                searchResults.innerHTML = html;
                searchResults.classList.add('show');
            }
        }

        // Close search results when clicking outside
        if (searchInput && searchResults) {
            document.addEventListener('click', function(event) {
                if (!searchInput.contains(event.target) && !searchResults.contains(event.target)) {
                    searchResults.classList.remove('show');
                }
            });
        }

        // Professional Navbar Dropdown System
        (function() {
            'use strict';
            
            const dropdowns = [];
            let closeTimer = null;
            let scrollPosition = window.pageYOffset || document.documentElement.scrollTop;

            function init() {
                const dropdownElements = document.querySelectorAll('.nav-dropdown');
                
                dropdownElements.forEach((dropdown) => {
                    const menu = dropdown.querySelector('.nav-dropdown-menu');
                    if (!menu) return;

                    const dropdownObj = {
                        element: dropdown,
                        menu: menu,
                        timer: null
                    };
                    
                    dropdowns.push(dropdownObj);

                    // Open dropdown
                    function open() {
                        clearAllTimers();
                        closeAll();
                        dropdown.classList.add('is-active');
                        menu.classList.add('is-visible');
                    }

                    // Close dropdown
                    function close() {
                        dropdown.classList.remove('is-active');
                        menu.classList.remove('is-visible');
                    }

                    // Schedule close
                    function scheduleClose() {
                        clearTimer(dropdownObj);
                        dropdownObj.timer = setTimeout(close, 200);
                    }

                    // Cancel scheduled close
                    function cancelClose() {
                        clearTimer(dropdownObj);
                    }

                    // Mouse enter on dropdown
                    dropdown.addEventListener('mouseenter', (e) => {
                        cancelClose();
                        open();
                    });

                    // Mouse leave from dropdown
                    dropdown.addEventListener('mouseleave', (e) => {
                        const relatedTarget = e.relatedTarget;
                        if (relatedTarget && (dropdown.contains(relatedTarget) || menu.contains(relatedTarget))) {
                            return;
                        }
                        scheduleClose();
                    });

                    // Mouse enter on menu
                    menu.addEventListener('mouseenter', () => {
                        cancelClose();
                        open();
                    });

                    // Mouse leave from menu
                    menu.addEventListener('mouseleave', (e) => {
                        const relatedTarget = e.relatedTarget;
                        if (relatedTarget && dropdown.contains(relatedTarget)) {
                            return;
                        }
                        scheduleClose();
                    });
                });
            }

            function clearTimer(dropdownObj) {
                if (dropdownObj.timer) {
                    clearTimeout(dropdownObj.timer);
                    dropdownObj.timer = null;
                }
            }

            function clearAllTimers() {
                dropdowns.forEach(clearTimer);
            }

            function closeAll() {
                dropdowns.forEach((obj) => {
                    obj.element.classList.remove('is-active');
                    obj.menu.classList.remove('is-visible');
                    clearTimer(obj);
                });
            }

            // Close on scroll - IMMEDIATE
            window.addEventListener('scroll', () => {
                const currentScroll = window.pageYOffset || document.documentElement.scrollTop;
                if (Math.abs(currentScroll - scrollPosition) > 1) {
                    closeAll();
                }
                scrollPosition = currentScroll;
            }, { passive: true });

            // Close on click outside
            document.addEventListener('click', (e) => {
                let inside = false;
                dropdowns.forEach((obj) => {
                    if (obj.element.contains(e.target)) {
                        inside = true;
                    }
                });
                if (!inside) {
                    closeAll();
                }
            });

            // Initialize
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();

        // User menu dropdown - Basit ve direkt çözüm
        (function() {
            function setupUserMenu() {
                const userMenus = document.querySelectorAll('.user-menu');
                
                if (userMenus.length === 0) {
                    console.log('User menu bulunamadı, tekrar denenecek...');
                    return false;
                }
                
                userMenus.forEach(function(userMenu, index) {
                    const avatar = userMenu.querySelector('.user-avatar');
                    const dropdown = userMenu.querySelector('.user-dropdown');
                    
                    if (!avatar || !dropdown) {
                        console.log('Avatar veya dropdown bulunamadı:', index);
                        return;
                    }
                    
                    // Eğer zaten setup edilmişse tekrar etme
                    if (avatar.dataset.setup === 'true') {
                        return;
                    }
                    
                    avatar.dataset.setup = 'true';
                    console.log('User menu setup ediliyor:', index);
                    
                    // CSS ayarları
                    avatar.style.cursor = 'pointer';
                    avatar.style.pointerEvents = 'auto';
                    avatar.style.position = 'relative';
                    avatar.style.zIndex = '100000';
                    
                    // Toggle fonksiyonu - closure ile avatar ve dropdown'ı sakla
                    (function(av, dd) {
                        function toggleMenu(e) {
                            if (e) {
                                e.preventDefault();
                                e.stopPropagation();
                                e.stopImmediatePropagation();
                            }
                            
                            console.log('Toggle menu çağrıldı');
                            const isOpen = dd.classList.contains('show') || dd.style.display === 'block';
                            
                            // Diğer tüm dropdown'ları kapat
                            document.querySelectorAll('.user-dropdown').forEach(function(drop) {
                                if (drop !== dd) {
                                    drop.classList.remove('show');
                                    drop.style.display = 'none';
                                    drop.style.opacity = '0';
                                }
                            });
                            
                            if (isOpen) {
                                // Kapat
                                console.log('Dropdown kapatılıyor');
                                dd.classList.remove('show');
                                dd.style.opacity = '0';
                                setTimeout(function() {
                                    dd.style.display = 'none';
                                }, 200);
                            } else {
                                // Aç
                                console.log('Dropdown açılıyor');
                                const rect = av.getBoundingClientRect();
                                const isMobile = window.innerWidth <= 768;
                                
                                dd.style.position = 'fixed';
                                dd.style.zIndex = '999999';
                                dd.style.display = 'block';
                                dd.style.opacity = '0';
                                
                                if (isMobile) {
                                    dd.style.left = '12px';
                                    dd.style.right = '12px';
                                    dd.style.top = '68px';
                                    dd.style.width = 'auto';
                                    dd.style.maxWidth = 'calc(100% - 24px)';
                                } else {
                                    dd.style.left = 'auto';
                                    dd.style.right = (window.innerWidth - rect.right) + 'px';
                                    dd.style.top = (rect.bottom + 8) + 'px';
                                    dd.style.width = '280px';
                                    dd.style.maxWidth = '280px';
                                }
                                
                                // Force reflow
                                dd.offsetHeight;
                                
                                setTimeout(function() {
                                    dd.classList.add('show');
                                    dd.style.opacity = '1';
                                }, 10);
                            }
                        }
                        
                        // Event listener'ları ekle
                        av.addEventListener('click', toggleMenu);
                        av.addEventListener('touchend', function(e) {
                            e.preventDefault();
                            toggleMenu(e);
                        });
                        
                        // Dropdown içindeki linklere tıklandığında kapat
                        dd.addEventListener('click', function(e) {
                            if (e.target.tagName === 'A' || e.target.closest('a')) {
                                setTimeout(function() {
                                    dd.classList.remove('show');
                                    dd.style.display = 'none';
                                    dd.style.opacity = '0';
                                }, 100);
                            }
                            e.stopPropagation();
                        });
                    })(avatar, dropdown);
                });
                
                return true;
            }
            
            // Global click listener - sadece bir kere ekle
            let globalClickAdded = false;
            function addGlobalListeners() {
                if (globalClickAdded) return;
                globalClickAdded = true;
                
                // Sayfa herhangi bir yerine tıklandığında kapat
                document.addEventListener('click', function(e) {
                    if (!e.target.closest('.user-menu')) {
                        document.querySelectorAll('.user-dropdown.show').forEach(function(dd) {
                            dd.classList.remove('show');
                            dd.style.opacity = '0';
                            setTimeout(function() {
                                dd.style.display = 'none';
                            }, 200);
                        });
                    }
                }, true);
                
                // ESC tuşu ile kapat
                document.addEventListener('keydown', function(e) {
                    if (e.key === 'Escape') {
                        document.querySelectorAll('.user-dropdown').forEach(function(dd) {
                            dd.classList.remove('show');
                            dd.style.display = 'none';
                            dd.style.opacity = '0';
                        });
                    }
                });
            }
            
            // İlk deneme
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', function() {
                    addGlobalListeners();
                    setupUserMenu();
                    // Retry for dynamic content
                    setTimeout(setupUserMenu, 300);
                    setTimeout(setupUserMenu, 1000);
                });
            } else {
                addGlobalListeners();
                setupUserMenu();
                setTimeout(setupUserMenu, 300);
                setTimeout(setupUserMenu, 1000);
            }
        })();
    </script>
    
    @if(Auth::check() && (Auth::user()->isBeautySalon() || Auth::user()->isPersonel()))
    <script>
        // Bugünkü Randevular Sistemi - Mobil uyumlu
        (function() {
            const todayAppointmentsBtn = document.getElementById('todayAppointmentsBtn');
            const todayAppointmentsDropdown = document.getElementById('todayAppointmentsDropdown');
            const todayAppointmentsMenu = document.getElementById('todayAppointmentsMenu');
            const todayAppointmentsContent = document.getElementById('todayAppointmentsContent');
            const todayAppointmentsBadge = document.getElementById('todayAppointmentsBadge');
            const todayAppointmentsCount = document.getElementById('todayAppointmentsCount');
            
            if (!todayAppointmentsBtn || !todayAppointmentsMenu || !todayAppointmentsContent) return;
            
            let isLoading = false;
            let isMenuOpen = false;
            
            // Mobilde dropdown'ı manuel kontrol et
            function toggleDropdown(e) {
                if (e) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                
                if (isMenuOpen) {
                    closeDropdown();
                } else {
                    openDropdown();
                }
            }
            
            function openDropdown() {
                if (isMenuOpen) return;
                isMenuOpen = true;
                
                // Bootstrap show class'ını ekle
                todayAppointmentsDropdown.classList.add('show');
                todayAppointmentsMenu.classList.add('show');
                todayAppointmentsBtn.setAttribute('aria-expanded', 'true');
                
                // Mobilde position fixed
                if (window.innerWidth <= 768) {
                    const btnRect = todayAppointmentsBtn.getBoundingClientRect();
                    const headerTopHeight = 56;
                    todayAppointmentsMenu.style.position = 'fixed';
                    todayAppointmentsMenu.style.left = '12px';
                    todayAppointmentsMenu.style.right = '12px';
                    todayAppointmentsMenu.style.width = 'auto';
                    todayAppointmentsMenu.style.maxWidth = 'calc(100% - 24px)';
                    todayAppointmentsMenu.style.top = (headerTopHeight + 8) + 'px';
                    todayAppointmentsMenu.style.zIndex = '100005';
                }
                
                loadTodayAppointments();
            }
            
            function closeDropdown() {
                if (!isMenuOpen) return;
                isMenuOpen = false;
                
                todayAppointmentsDropdown.classList.remove('show');
                todayAppointmentsMenu.classList.remove('show');
                todayAppointmentsBtn.setAttribute('aria-expanded', 'false');
            }
            
            // Buton'a tıklama ve touch event'leri ekle
            todayAppointmentsBtn.addEventListener('click', toggleDropdown);
            todayAppointmentsBtn.addEventListener('touchend', function(e) {
                e.preventDefault();
                toggleDropdown(e);
            });
            
            // Sayfa herhangi bir yerine tıklayınca kapat
            document.addEventListener('click', function(e) {
                if (!todayAppointmentsDropdown.contains(e.target) && !todayAppointmentsMenu.contains(e.target)) {
                    closeDropdown();
                }
            });
            
            // Touch için de aynı mantık
            document.addEventListener('touchend', function(e) {
                if (!todayAppointmentsDropdown.contains(e.target) && !todayAppointmentsMenu.contains(e.target)) {
                    closeDropdown();
                }
            });
            
            // Bootstrap dropdown event'lerini de dinle (desktop için)
            if (todayAppointmentsMenu) {
                todayAppointmentsMenu.addEventListener('show.bs.dropdown', function() {
                    if (!isMenuOpen) {
                        openDropdown();
                    }
                });
                
                todayAppointmentsMenu.addEventListener('hide.bs.dropdown', function() {
                    if (isMenuOpen) {
                        closeDropdown();
                    }
                });
            }
            
            function loadTodayAppointments() {
                if (isLoading) return;
                isLoading = true;
                
                fetch('{{ route("admin.notifications.today") }}', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    isLoading = false;
                    const appointments = data.appointments || [];
                    const count = data.count || 0;
                    
                    // Badge ve count güncelle
                    if (todayAppointmentsBadge) {
                        if (count > 0) {
                            todayAppointmentsBadge.textContent = count;
                            todayAppointmentsBadge.style.display = 'inline-block';
                        } else {
                            todayAppointmentsBadge.style.display = 'none';
                        }
                    }
                    
                    if (todayAppointmentsCount) {
                        todayAppointmentsCount.textContent = count;
                    }
                    
                    // İçerik güncelle
                    if (appointments.length === 0) {
                        todayAppointmentsContent.innerHTML = `
                            <div class="text-center py-4">
                                <i class="bi bi-calendar-x" style="font-size: 48px; color: #cbd5e1;"></i>
                                <p class="mt-3 mb-0 text-muted" style="font-size: 0.9rem;">Bugün randevu yok</p>
                            </div>
                        `;
                    } else {
                        let html = '<div class="list-group list-group-flush">';
                        appointments.forEach(appointment => {
                            let statusBadge = '';
                            if (appointment.status === 'confirmed') {
                                statusBadge = '<span class="badge bg-success" style="font-size: 0.7rem;">Onaylandı</span>';
                            } else if (appointment.status === 'pending') {
                                statusBadge = '<span class="badge bg-warning" style="font-size: 0.7rem;">Beklemede</span>';
                            } else if (appointment.status === 'completed') {
                                statusBadge = '<span class="badge bg-info" style="font-size: 0.7rem;">Tamamlandı</span>';
                            } else {
                                statusBadge = '<span class="badge bg-secondary" style="font-size: 0.7rem;">' + appointment.status + '</span>';
                            }
                            
                            html += `
                                <div class="list-group-item list-group-item-action border-0" style="padding: 12px; border-radius: 8px; margin-bottom: 8px; transition: all 0.2s; cursor: pointer;" onmouseover="this.style.background='#f8f9fa'" onmouseout="this.style.background='white'" onclick="if(typeof window.showReservationDetail === 'function') { window.showReservationDetail(${appointment.id}); } else if(typeof showReservationDetail === 'function') { showReservationDetail(${appointment.id}); } else { window.location.href='${appointment.url}'; }">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div style="flex: 1;">
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <strong style="font-size: 0.9rem; color: #1f2937;">${appointment.customer_name}</strong>
                                                ${statusBadge}
                                            </div>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <small class="text-muted" style="font-size: 0.8rem;">
                                                    <i class="bi bi-clock me-1"></i>${appointment.start_time}
                                                </small>
                                                ${appointment.service_name ? `<small class="text-muted" style="font-size: 0.8rem;"><i class="bi bi-scissors me-1"></i>${appointment.service_name}</small>` : ''}
                                                ${appointment.personel_name ? `<small class="text-muted" style="font-size: 0.8rem;"><i class="bi bi-person me-1"></i>${appointment.personel_name}</small>` : ''}
                                            </div>
                                            ${appointment.total_price ? `<div class="mt-1"><small class="text-success fw-bold" style="font-size: 0.85rem;">${parseFloat(appointment.total_price).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})} ₺</small></div>` : ''}
                                        </div>
                                    </div>
                                </div>
                            `;
                        });
                        html += '</div>';
                        todayAppointmentsContent.innerHTML = html;
                    }
                })
                .catch(error => {
                    isLoading = false;
                    console.error('Bugünkü randevular yüklenemedi:', error);
                    todayAppointmentsContent.innerHTML = `
                        <div class="text-center py-3">
                            <i class="bi bi-exclamation-triangle text-warning" style="font-size: 32px;"></i>
                            <p class="mt-2 mb-0 text-muted" style="font-size: 0.85rem;">Randevular yüklenirken bir hata oluştu</p>
                        </div>
                    `;
                });
            }
            
            // Window resize'da pozisyonu güncelle - debounced
            let resizeTimeout;
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimeout);
                resizeTimeout = setTimeout(function() {
                    if (isMenuOpen) {
                        openDropdown();
                    }
                }, 150);
            }, { passive: true });
            
            // Scroll'da kapat - passive
            window.addEventListener('scroll', function() {
                closeDropdown();
            }, { passive: true });
            
            // Sayfa yüklendiğinde badge'i güncelle
            loadTodayAppointments();
            
            // Her 30 saniyede bir güncelle - optimize for mobile
            let appointmentInterval;
            function startAppointmentInterval() {
                if (appointmentInterval) clearInterval(appointmentInterval);
                if (!document.hidden) {
                    appointmentInterval = setInterval(loadTodayAppointments, 30000);
                }
            }
            startAppointmentInterval();
            document.addEventListener('visibilitychange', function() {
                if (document.hidden) {
                    if (appointmentInterval) clearInterval(appointmentInterval);
                } else {
                    startAppointmentInterval();
                }
            });
        })();
    </script>
    
    <script>
    
    @if(Auth::check() && Auth::user()->isPersonel())
    <script>
        // Bugünkü Randevular Sistemi - Personel için (Mobil uyumlu)
        (function() {
            const todayAppointmentsBtn = document.getElementById('todayAppointmentsBtnPersonel');
            const todayAppointmentsDropdown = document.getElementById('todayAppointmentsDropdownPersonel');
            const todayAppointmentsMenu = document.getElementById('todayAppointmentsMenuPersonel');
            const todayAppointmentsContent = document.getElementById('todayAppointmentsContentPersonel');
            const todayAppointmentsBadge = document.getElementById('todayAppointmentsBadgePersonel');
            const todayAppointmentsCount = document.getElementById('todayAppointmentsCountPersonel');
            
            if (!todayAppointmentsBtn || !todayAppointmentsMenu || !todayAppointmentsContent) return;
            
            let isLoading = false;
            let isMenuOpen = false;
            
            // Mobilde dropdown'ı manuel kontrol et
            function toggleDropdown(e) {
                if (e) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                
                if (isMenuOpen) {
                    closeDropdown();
                } else {
                    openDropdown();
                }
            }
            
            function openDropdown() {
                if (isMenuOpen) return;
                isMenuOpen = true;
                
                // Bootstrap show class'ını ekle
                todayAppointmentsDropdown.classList.add('show');
                todayAppointmentsMenu.classList.add('show');
                todayAppointmentsBtn.setAttribute('aria-expanded', 'true');
                
                // Mobilde position fixed
                if (window.innerWidth <= 768) {
                    const btnRect = todayAppointmentsBtn.getBoundingClientRect();
                    const headerTopHeight = 56;
                    todayAppointmentsMenu.style.position = 'fixed';
                    todayAppointmentsMenu.style.left = '12px';
                    todayAppointmentsMenu.style.right = '12px';
                    todayAppointmentsMenu.style.width = 'auto';
                    todayAppointmentsMenu.style.maxWidth = 'calc(100% - 24px)';
                    todayAppointmentsMenu.style.top = (headerTopHeight + 8) + 'px';
                    todayAppointmentsMenu.style.zIndex = '100005';
                }
                
                loadTodayAppointments();
            }
            
            function closeDropdown() {
                if (!isMenuOpen) return;
                isMenuOpen = false;
                
                todayAppointmentsDropdown.classList.remove('show');
                todayAppointmentsMenu.classList.remove('show');
                todayAppointmentsBtn.setAttribute('aria-expanded', 'false');
            }
            
            // Buton'a tıklama ve touch event'leri ekle
            todayAppointmentsBtn.addEventListener('click', toggleDropdown);
            todayAppointmentsBtn.addEventListener('touchend', function(e) {
                e.preventDefault();
                toggleDropdown(e);
            });
            
            // Sayfa herhangi bir yerine tıklayınca kapat
            document.addEventListener('click', function(e) {
                if (!todayAppointmentsDropdown.contains(e.target) && !todayAppointmentsMenu.contains(e.target)) {
                    closeDropdown();
                }
            });
            
            // Touch için de aynı mantık
            document.addEventListener('touchend', function(e) {
                if (!todayAppointmentsDropdown.contains(e.target) && !todayAppointmentsMenu.contains(e.target)) {
                    closeDropdown();
                }
            });
            
            // Bootstrap dropdown event'lerini de dinle (desktop için)
            if (todayAppointmentsMenu) {
                todayAppointmentsMenu.addEventListener('show.bs.dropdown', function() {
                    if (!isMenuOpen) {
                        openDropdown();
                    }
                });
                
                todayAppointmentsMenu.addEventListener('hide.bs.dropdown', function() {
                    if (isMenuOpen) {
                        closeDropdown();
                    }
                });
            }
            
            function loadTodayAppointments() {
                if (isLoading) return;
                isLoading = true;
                
                // Yükleme durumunu göster
                if (todayAppointmentsContent) {
                    todayAppointmentsContent.innerHTML = `
                        <div class="text-center py-3">
                            <div class="spinner-border spinner-border-sm text-primary" role="status"></div>
                            <p class="mt-2 mb-0 text-muted" style="font-size: 0.85rem;">Yükleniyor...</p>
                        </div>
                    `;
                }
                
                fetch('{{ route("admin.notifications.today") }}', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('HTTP ' + response.status);
                    }
                    return response.json();
                })
                .then(data => {
                    isLoading = false;
                    const appointments = data.appointments || [];
                    const count = data.count || 0;
                    
                    // Badge ve count güncelle
                    if (todayAppointmentsBadge) {
                        if (count > 0) {
                            todayAppointmentsBadge.textContent = count;
                            todayAppointmentsBadge.style.display = 'inline-block';
                        } else {
                            todayAppointmentsBadge.style.display = 'none';
                        }
                    }
                    
                    if (todayAppointmentsCount) {
                        todayAppointmentsCount.textContent = count;
                    }
                    
                    // İçerik güncelle
                    if (appointments.length === 0) {
                        todayAppointmentsContent.innerHTML = `
                            <div class="text-center py-4">
                                <i class="bi bi-calendar-x" style="font-size: 48px; color: #cbd5e1;"></i>
                                <p class="mt-3 mb-0 text-muted" style="font-size: 0.9rem;">Bugün randevu yok</p>
                            </div>
                        `;
                    } else {
                        let html = '<div class="list-group list-group-flush">';
                        appointments.forEach(appointment => {
                            let statusBadge = '';
                            if (appointment.status === 'confirmed' || appointment.status === 'onaylandı') {
                                statusBadge = '<span class="badge" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; font-size: 0.7rem;">Onaylandı</span>';
                            } else if (appointment.status === 'open' || appointment.status === 'açık') {
                                statusBadge = '<span class="badge bg-warning text-dark" style="font-size: 0.7rem;">Açık</span>';
                            } else if (appointment.status === 'pending') {
                                statusBadge = '<span class="badge bg-warning" style="font-size: 0.7rem;">Beklemede</span>';
                            } else if (appointment.status === 'completed' || appointment.status === 'tamamlandı') {
                                statusBadge = '<span class="badge bg-info" style="font-size: 0.7rem;">Tamamlandı</span>';
                            } else {
                                statusBadge = '<span class="badge bg-secondary" style="font-size: 0.7rem;">' + (appointment.status || 'Bilinmiyor') + '</span>';
                            }
                            
                            html += `
                                <div class="list-group-item list-group-item-action border-0" style="padding: 12px; border-radius: 8px; margin-bottom: 8px; transition: all 0.2s; cursor: pointer;" onmouseover="this.style.background='#f8f9fa'" onmouseout="this.style.background='white'" onclick="event.stopPropagation(); if(typeof window.showReservationDetail === 'function') { window.showReservationDetail(${appointment.id}); } else { window.location.href='${appointment.url || '#'}'; }">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div style="flex: 1;">
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <strong style="font-size: 0.9rem; color: #1f2937;">${appointment.customer_name || 'Müşteri'}</strong>
                                                ${statusBadge}
                                            </div>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <small class="text-muted" style="font-size: 0.8rem;">
                                                    <i class="bi bi-clock me-1"></i>${appointment.start_time || '-'}
                                                </small>
                                                ${appointment.service_name ? `<small class="text-muted" style="font-size: 0.8rem;"><i class="bi bi-scissors me-1"></i>${appointment.service_name}</small>` : ''}
                                                ${appointment.room_name ? `<small class="text-muted" style="font-size: 0.8rem;"><i class="bi bi-door-open me-1"></i>${appointment.room_name}</small>` : ''}
                                            </div>
                                            ${appointment.total_price ? `<div class="mt-1"><small class="text-success fw-bold" style="font-size: 0.85rem;">${parseFloat(appointment.total_price).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})} ₺</small></div>` : ''}
                                        </div>
                                    </div>
                                </div>
                            `;
                        });
                        html += '</div>';
                        todayAppointmentsContent.innerHTML = html;
                    }
                })
                .catch(error => {
                    isLoading = false;
                    console.error('Bugünkü randevular yüklenemedi:', error);
                    if (todayAppointmentsContent) {
                        todayAppointmentsContent.innerHTML = `
                            <div class="text-center py-3">
                                <i class="bi bi-exclamation-triangle text-warning" style="font-size: 32px;"></i>
                                <p class="mt-2 mb-0 text-muted" style="font-size: 0.85rem;">Randevular yüklenirken bir hata oluştu</p>
                                <button class="btn btn-sm btn-primary mt-2" onclick="loadTodayAppointments()">Tekrar Dene</button>
                            </div>
                        `;
                    }
                });
            }
            
            // Window resize'da pozisyonu güncelle - debounced
            let resizeTimeout;
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimeout);
                resizeTimeout = setTimeout(function() {
                    if (isMenuOpen) {
                        openDropdown();
                    }
                }, 150);
            }, { passive: true });
            
            // Scroll'da kapat - passive
            window.addEventListener('scroll', function() {
                closeDropdown();
            }, { passive: true });
            
            // Sayfa yüklendiğinde badge'i güncelle
            loadTodayAppointments();
            
            // Her 30 saniyede bir güncelle - optimize for mobile
            let appointmentInterval;
            function startAppointmentInterval() {
                if (appointmentInterval) clearInterval(appointmentInterval);
                if (!document.hidden) {
                    appointmentInterval = setInterval(loadTodayAppointments, 30000);
                }
            }
            startAppointmentInterval();
            document.addEventListener('visibilitychange', function() {
                if (document.hidden) {
                    if (appointmentInterval) clearInterval(appointmentInterval);
                } else {
                    startAppointmentInterval();
                }
            });
        })();
    </script>
    @endif

    <script>
        // Settings menu functions
        function openSettingsMenu() {
            try {
                console.log('openSettingsMenu çağrıldı');
                @if(auth()->check() && auth()->user()->isSuperAdmin())
                    window.location.href = '{{ route('admin.settings.general') }}';
                @else
                    window.location.href = '{{ route('admin.settings.membership') }}';
                @endif
            } catch (error) {
                console.error('openSettingsMenu hatası:', error);
                // Fallback: direkt URL ile dene
                @if(auth()->check() && auth()->user()->isSuperAdmin())
                    window.location.href = '/admin/ayarlar/genel-ayarlar';
                @else
                    window.location.href = '/admin/ayarlar/uyelik';
                @endif
            }
        }
        
        // Global scope'a ekle
        window.openSettingsMenu = openSettingsMenu;
        
        // Mobile Menu Functions (robust)
        function isMobileViewport() {
            return window.matchMedia('(max-width: 992px)').matches;
        }

        function getMobileMenuElements() {
            return {
                sidebar: document.getElementById('mobileMenuSidebar'),
                overlay: document.getElementById('mobileMenuOverlay'),
                toggle: document.getElementById('mobileMenuToggle')
            };
        }

        function setMobileMenuState(isOpen) {
            const { sidebar, overlay, toggle } = getMobileMenuElements();
            if (!sidebar || !overlay || !toggle) return;

            sidebar.classList.toggle('active', isOpen);
            overlay.classList.toggle('active', isOpen);
            toggle.classList.toggle('active', isOpen);
            document.body.classList.toggle('mobile-menu-open', isOpen);
            document.body.style.overflow = isOpen ? 'hidden' : '';
            toggle.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
        }

        function toggleMobileMenu(event) {
            if (event) {
                event.preventDefault();
                event.stopPropagation();
            }
            const { sidebar, overlay, toggle } = getMobileMenuElements();
            if (!sidebar || !overlay || !toggle) return;
            var isOpen = sidebar.classList.contains('active');
            setMobileMenuState(!isOpen);
        }
        
        function closeMobileMenu(event) {
            if (event) {
                event.preventDefault();
                event.stopPropagation();
            }
            setMobileMenuState(false);
        }

        window.toggleMobileMenu = toggleMobileMenu;
        window.closeMobileMenu = closeMobileMenu;

        document.addEventListener('DOMContentLoaded', function () {
            const { toggle, sidebar, overlay } = getMobileMenuElements();
            if (toggle) {
                toggle.removeAttribute('onclick');
                toggle.addEventListener('click', toggleMobileMenu, { passive: false });
            }
            if (overlay) {
                overlay.addEventListener('click', closeMobileMenu);
            }
            if (sidebar) {
                sidebar.addEventListener('click', function (e) {
                    e.stopPropagation();
                });
            }
        });
        
        // Close mobile menu on escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeMobileMenu();
        });
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', function(e) {
            const { sidebar, toggle } = getMobileMenuElements();
            if (!sidebar || !toggle) return;
            if (!sidebar.classList.contains('active')) return;
            if (sidebar.contains(e.target) || e.target.closest('#mobileMenuToggle')) return;
            closeMobileMenu();
        });

        // Reset menu state when viewport grows
        window.addEventListener('resize', function () {
            if (!isMobileViewport()) {
                closeMobileMenu();
            }
        });

        function closeSettingsMenu() {
            // Ayarlar sayfasından çık - dashboard'a yönlendir
            window.location.href = "{{ route('admin.dashboard') }}";
        }
        
        // Ayarlar sayfalarında sidebar otomatik açık olsun (PHP ile body class zaten ekleniyor)
        document.addEventListener('DOMContentLoaded', function() {
            // PHP'den gelen settings-page class'ı varsa, sidebar otomatik açık olacak (CSS ile)
            // Ekstra bir işlem yapmaya gerek yok, CSS zaten hallediyor
        });

        // Premium Feature Info Modal
        const premiumFeatureInfo = {
            loyalty: {
                title: 'Kart Programı',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Müşterilerinize dijital bir kart verin! Her randevuda puan kazansınlar, seviye atlayıp ödüller kazansınlar. Müşterileriniz kendi kartlarını özel linklerinden görüntüleyebilir.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Müşteri sayfasından kart programını aktif edin</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Müşteriye özel link oluşturulur: salonay.com/salon/{salon-ismi}/{telefon}</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Müşteriler randevu aldığında otomatik puan kazanır</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Puanları biriktirip ödüller alabilirler</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Kart seviyeleri oluşturabilirsiniz (Bronz, Gümüş, Altın gibi)</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Her seviyede farklı avantajlar sunabilirsiniz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Müşteriler kendi kartlarını özel linklerinden görüntüleyebilir</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> Müşterilerinize dijital kart vererek onları daha sık gelmeye teşvik edin ve gelirinizi artırın.
                    </div>
                `
            },
            campaign: {
                title: 'Kampanya Yönetimi',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Müşterilerinize özel kampanyalar oluşturup, indirimler ve promosyonlar düzenleyebilirsiniz. Zaman bazlı, ziyaret bazlı veya harcama bazlı kampanyalar yapabilirsiniz.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Kampanya oluşturursunuz (örn: "5. randevuda %20 indirim")</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Kampanya kurallarını belirlersiniz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Müşteriler otomatik olarak kampanyadan yararlanır</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Kampanya performansını takip edebilirsiniz</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> Yavaş günlerde kampanya yaparak salonunuzu doldurun.
                    </div>
                `
            },
            referral: {
                title: 'Referans Sistemi',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Mevcut müşterileriniz arkadaşlarını getirdiğinde hem onlara hem de yeni müşteriye ödül verirsiniz. Böylece müşterileriniz sizin için reklam yapar.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Müşterilerinize özel referans kodu verilir</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Arkadaşları bu kodu kullanarak randevu alır</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Hem eski müşteri hem yeni müşteri ödül kazanır</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Referans geçmişini takip edebilirsiniz</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> En iyi reklam, memnun müşterilerin arkadaşlarına anlatmasıdır.
                    </div>
                `
            },
            membership: {
                title: 'Üyelik Sistemi',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Müşterilerinize aylık veya yıllık üyelik paketleri satabilirsiniz. Üyeler belirli sayıda hizmeti daha ucuza veya ücretsiz alabilir.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Üyelik paketleri oluşturursunuz (örn: "Aylık 5 Saç Kesimi")</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Müşteriler paket satın alır</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Her randevuda paketten hakkı düşer</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Paket bitince yeniden satın alabilir</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> Düzenli gelir sağlar ve müşterilerinizi bağlar.
                    </div>
                `
            },
            branch: {
                title: 'Şube Yönetimi',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Birden fazla şubeniz varsa hepsini tek yerden yönetebilirsiniz. Her şubenin kendi personeli, odaları ve gelirleri olur.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Şubeleri ekleyip yönetirsiniz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Her şubenin kendi ayarları olur</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Şubeler arası gelir paylaşımı yapabilirsiniz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Tüm şubelerin performansını tek ekranda görürsünüz</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> Franchise veya bayilik sistemi için idealdir.
                    </div>
                `
            },
            staff_performance: {
                title: 'Personel Performans',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Personellerinizin ne kadar randevu aldığını, ne kadar gelir getirdiğini ve müşteri memnuniyetini takip edebilirsiniz. Komisyon ve bonus sistemleri kurabilirsiniz.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Her personelin performansını görürsünüz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Komisyon oranları belirlersiniz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Hedeflere ulaşanlara bonus verirsiniz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Personeller arası yarış ortamı oluşur</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> Personellerinizi motive eder ve salon gelirini artırır.
                    </div>
                `
            },
            clv: {
                title: 'Müşteri Değeri Analizi',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Hangi müşterilerin size en çok kazandırdığını, hangilerinin gitme riski olduğunu öğrenirsiniz. VIP müşterilerinizi belirleyip onlara özel teklifler sunarsınız.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Sistem müşterilerinizi analiz eder</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Her müşteriye bir değer skoru verir</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Yüksek değerli müşterileri VIP yaparsınız</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Gitme riski olanlara özel teklifler gönderirsiniz</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> En değerli müşterilerinizi kaybetmemek için özel ilgi gösterin.
                    </div>
                `
            },
            smart_pricing: {
                title: 'Akıllı Fiyatlandırma',
                content: `
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Bu özellik ne işe yarar?</h6>
                        <p>Fiyatlarınızı otomatik olarak ayarlayabilirsiniz. Yoğun saatlerde fiyat artar, boş saatlerde düşer. Böylece gelirinizi maksimize edersiniz.</p>
                    </div>
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">Nasıl çalışır?</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Fiyat kuralları oluşturursunuz</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Zaman bazlı fiyat ayarlaması yaparsınız</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Talep az olduğunda fiyat düşer</li>
                            <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Talep çok olduğunda fiyat artar</li>
                        </ul>
                    </div>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-lightbulb me-2"></i><strong>İpucu:</strong> Boş saatleri doldurur, yoğun saatlerden daha fazla kazanırsınız.
                    </div>
                `
            }
        };

        function showPremiumInfo(feature) {
            const info = premiumFeatureInfo[feature];
            if (info) {
                document.getElementById('premiumInfoTitle').textContent = info.title;
                document.getElementById('premiumInfoContent').innerHTML = info.content;
            }
        }
        
        // Modal fonksiyonlarını global scope'a ekle (eğer modals.blade.php'de tanımlı değilse)
        
        // Global fonksiyonları tanımla
        window.openNewCustomerModal = function() {
            const modalElement = document.getElementById('newCustomerModal');
            if (modalElement) {
                try {
                    const modal = new bootstrap.Modal(modalElement);
                    modal.show();
                } catch (error) {
                    console.error('Modal açılırken hata:', error);
                    // Fallback: Modal'ı manuel olarak göster
                    modalElement.classList.add('show');
                    modalElement.style.display = 'block';
                    document.body.classList.add('modal-open');
                    const backdrop = document.createElement('div');
                    backdrop.className = 'modal-backdrop fade show';
                    backdrop.id = 'modalBackdrop';
                    document.body.appendChild(backdrop);
                }
            } else {
                console.error('newCustomerModal bulunamadı. Modal elementi yüklenmemiş olabilir.');
            }
        };
        
        // submitCustomerForm fonksiyonunun tanımlı olduğundan emin ol
        if (typeof submitCustomerForm === 'undefined') {
            window.submitCustomerForm = function() {
                console.log('submitCustomerForm fallback - form normal submit kullanıyor');
            };
        }
        
        
        // Yaklaşan randevu bildirimleri
        let shownNotifications = JSON.parse(localStorage.getItem('shownReservationNotifications') || '[]');
        let notificationSound = null;
        let soundEnabled = false;
        
        // Ses dosyasını önceden yükle
        function initNotificationSound() {
            if (!notificationSound) {
                try {
                    // Önce public klasöründen dene
                    const soundUrl = '{{ asset("notf.mp3") }}';
                    notificationSound = new Audio(soundUrl);
                    
                    notificationSound.onerror = function() {
                        // Public'te bulamazsa sessizce devam et
                        notificationSound = null;
                    };
                    
                    notificationSound.oncanplaythrough = function() {
                        console.log('Bildirim sesi public klasöründen yüklendi');
                        notificationSound.volume = 0.7;
                    };
                    
                    if (notificationSound) {
                        notificationSound.volume = 0.7;
                        notificationSound.preload = 'auto';
                        notificationSound.load();
                    }
                } catch (e) {
                    console.error('Bildirim sesi yüklenemedi:', e);
                    notificationSound = null;
                }
            }
        }
        
        // Sayfa yüklendiğinde ses dosyasını hazırla
        document.addEventListener('DOMContentLoaded', initNotificationSound);
        
        // Kullanıcı sayfayla etkileşime girdiğinde sesi aktif et
        document.addEventListener('click', function() {
            if (!soundEnabled) {
                soundEnabled = true;
                // Sesi sessiz çal (tarayıcı izni için)
                if (notificationSound) {
                    notificationSound.volume = 0;
                    notificationSound.play().then(() => {
                        notificationSound.pause();
                        notificationSound.currentTime = 0;
                        notificationSound.volume = 0.7;
                    }).catch(() => {});
                }
            }
        }, { once: true });
        
        // Bildirim sesi çal
        function playNotificationSound() {
            if (notificationSound && soundEnabled) {
                try {
                    notificationSound.currentTime = 0;
                    const playPromise = notificationSound.play();
                    if (playPromise !== undefined) {
                        playPromise.then(() => {
                            console.log('Bildirim sesi çalındı');
                        }).catch(e => {
                            console.error('Ses çalınamadı:', e);
                            // Ses çalınamazsa tekrar yükle ve dene
                            if (notificationSound) {
                                notificationSound.load();
                                notificationSound.play().catch(err => {
                                    console.error('Ses tekrar çalınamadı:', err);
                                });
                            }
                        });
                    }
                } catch (e) {
                    console.error('Ses çalma hatası:', e);
                }
            } else {
                if (!notificationSound) {
                    console.warn('Bildirim sesi yüklenmemiş');
                }
                if (!soundEnabled) {
                    console.warn('Ses etkinleştirilmemiş');
                }
            }
        }
        
        function checkUpcomingAppointments() {
            fetch('{{ route("admin.notifications.upcoming") }}', {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('HTTP ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                if (!data || !data.appointments || data.appointments.length === 0) {
                    return;
                }
                
                const now = new Date();
                
                data.appointments.forEach(reservation => {
                    if (reservation.status === 'cancelled' || reservation.status === 'completed') {
                        return;
                    }
                    
                    try {
                        // Tarih ve saat formatını düzelt
                        let reservationDateTime;
                        if (reservation.date && reservation.start_time) {
                            // Tarih formatı: YYYY-MM-DD, saat formatı: HH:MM
                            const dateStr = reservation.date;
                            const timeStr = reservation.start_time;
                            reservationDateTime = new Date(dateStr + 'T' + timeStr + ':00');
                        } else {
                            return;
                        }
                        
                        if (isNaN(reservationDateTime.getTime())) {
                            console.error('Geçersiz tarih/saat:', reservation.date, reservation.start_time);
                            return;
                        }
                        
                        const reservationId = reservation.id;
                        const timeDiff = Math.floor((reservationDateTime - now) / 1000 / 60); // Dakika cinsinden
                        
                        // 1 saat kala bildirim (60 dakika ile 30 dakika arası)
                        const oneHourKey = `reservation_${reservationId}_1hour`;
                        if (timeDiff <= 60 && timeDiff > 30 && !shownNotifications.includes(oneHourKey)) {
                            console.log('1 saat kala bildirim gösteriliyor:', reservation);
                            showReservationNotification(reservation, '1 saat', oneHourKey);
                        }
                        
                        // 30 dakika kala bildirim (30 dakika ile 0 dakika arası)
                        const thirtyMinKey = `reservation_${reservationId}_30min`;
                        if (timeDiff <= 30 && timeDiff > 0 && !shownNotifications.includes(thirtyMinKey)) {
                            console.log('30 dakika kala bildirim gösteriliyor:', reservation);
                            showReservationNotification(reservation, '30 dakika', thirtyMinKey);
                        }
                    } catch (error) {
                        console.error('Randevu işlenirken hata:', error, reservation);
                    }
                });
            })
            .catch(error => {
                console.error('Yaklaşan randevular kontrol edilemedi:', error);
            });
        }
        
        function showReservationNotification(reservation, timeText, notificationKey) {
            // Bildirimi gösterildi olarak işaretle
            shownNotifications.push(notificationKey);
            localStorage.setItem('shownReservationNotifications', JSON.stringify(shownNotifications));
            
            // Bildirim sesi çal
            playNotificationSound();
            
            // Bildirim HTML'i oluştur
            const appointmentsUrl = '{{ route("admin.appointments.index") }}';
            const notificationHtml = `
                <div class="reservation-notification" data-key="${notificationKey}" style="
                    position: fixed;
                    top: 80px;
                    right: 20px;
                    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
                    border-radius: 16px;
                    box-shadow: 0 10px 40px rgba(0,0,0,0.15), 0 0 0 1px rgba(245, 158, 11, 0.3);
                    padding: 24px;
                    min-width: 360px;
                    max-width: 420px;
                    z-index: 100010;
                    border-left: 5px solid #f59e0b;
                    animation: slideInRight 0.4s ease-out;
                ">
                    <div class="d-flex justify-content-between align-items-start">
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <div style="width: 40px; height: 40px; background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                    <i class="bi bi-bell-fill text-warning" style="font-size: 18px;"></i>
                                </div>
                                <strong class="text-dark" style="font-size: 16px;">⏰ Yaklaşan Randevu</strong>
                            </div>
                            <p class="mb-1 text-muted" style="font-size: 14px;">
                                <strong>${reservation.customer?.name || 'Müşteri'}</strong> - ${reservation.salon?.name || 'Salon'}
                            </p>
                            <p class="mb-0 text-muted" style="font-size: 13px;">
                                <i class="bi bi-calendar3"></i> ${new Date(reservation.date).toLocaleDateString('tr-TR')} 
                                <i class="bi bi-clock ms-2"></i> ${reservation.start_time}
                            </p>
                            <p class="mb-0 mt-1">
                                <span class="badge bg-warning">${timeText} kaldı</span>
                            </p>
                            <a href="${appointmentsUrl}/${reservation.id}" class="btn btn-sm btn-primary mt-2" style="font-size: 12px;">
                                <i class="bi bi-eye"></i> Detayları Gör
                            </a>
                        </div>
                        <button type="button" class="btn-close" onclick="closeNotification('${notificationKey}')" style="margin-left: 10px;"></button>
                    </div>
                </div>
            `;
            
            // Bildirimi ekle
            document.body.insertAdjacentHTML('beforeend', notificationHtml);
        }
        
        function closeNotification(key) {
            const notification = document.querySelector(`.reservation-notification[data-key="${key}"]`);
            if (notification) {
                notification.style.animation = 'slideOutRight 0.3s ease-out';
                setTimeout(() => {
                    notification.remove();
                }, 300);
            }
        }
        
        // Her 30 saniyede bir yaklaşan randevuları kontrol et
        setInterval(checkUpcomingAppointments, 30000);
        // Sayfa yüklendiğinde de kontrol et
        document.addEventListener('DOMContentLoaded', function() {
            // İlk kontrolü 2 saniye sonra yap
            setTimeout(checkUpcomingAppointments, 2000);
            // Sonra her 30 saniyede bir kontrol et (zaten setInterval var ama emin olmak için)
        });
        
        // Sayfa görünür olduğunda da kontrol et (tab değiştiğinde)
        document.addEventListener('visibilitychange', function() {
            if (!document.hidden) {
                setTimeout(checkUpcomingAppointments, 1000);
            }
        });
        
        // Animasyonlar
        const style = document.createElement('style');
        style.textContent = `
            @keyframes slideInRight {
                from {
                    transform: translateX(400px);
                    opacity: 0;
                }
                to {
                    transform: translateX(0);
                    opacity: 1;
                }
            }
            @keyframes slideOutRight {
                from {
                    transform: translateX(0);
                    opacity: 1;
                }
                to {
                    transform: translateX(400px);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
    
    <!-- Lisans Süresi Dolmuş Popup -->
    @auth
        @if(
            Auth::check() &&
            !Auth::user()->isSuperAdmin() &&
            Auth::user()->role !== 'personel' &&
            !Auth::user()->hasValidLicense() &&
            !$hasPendingPackagePayment
        )
            <div class="modal fade" id="licenseExpiredModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="licenseExpiredModalLabel" aria-hidden="false">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content" style="border-radius: 20px; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.2);">
                        <div class="modal-header border-0" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 20px 20px 0 0; padding: 24px;">
                            <div class="w-100 text-center">
                                <i class="bi bi-exclamation-triangle-fill text-white" style="font-size: 48px;"></i>
                                <h4 class="modal-title text-white mt-3 mb-0" id="licenseExpiredModalLabel">Lisans Süresi Doldu</h4>
                            </div>
                        </div>
                        <div class="modal-body text-center" style="padding: 32px;">
                            <p class="text-muted mb-4" style="font-size: 16px;">
                                Panel kullanımınız için lisansınızı yenilemeniz gerekmektedir.
                            </p>
                            <div class="d-flex gap-3 justify-content-center">
                                <a href="{{ env('LISANSYENILE', '#') }}" target="_blank" class="btn btn-primary btn-lg px-4" style="border-radius: 12px; font-weight: 600;">
                                    <i class="bi bi-arrow-clockwise me-2"></i> Lisansı Yenile
                                </a>
                                <form method="POST" action="{{ route('logout') }}" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-outline-secondary btn-lg px-4" style="border-radius: 12px; font-weight: 600;">
                                        <i class="bi bi-box-arrow-right me-2"></i> Çıkış Yap
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const licenseModal = new bootstrap.Modal(document.getElementById('licenseExpiredModal'));
                    licenseModal.show();
                });
            </script>
        @endif
    @endauth
    
    <!-- SMS BAKİYE UYARI MODAL -->
    <div class="modal fade" id="smsBalanceWarningModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 16px; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
                <div class="modal-header border-0" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); padding: 20px 24px;">
                    <div class="d-flex align-items-center gap-3">
                        <div style="width: 48px; height: 48px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                            <i class="bi bi-exclamation-triangle-fill text-white" style="font-size: 24px;"></i>
                        </div>
                        <h5 class="modal-title text-white fw-bold mb-0" style="font-size: 1.25rem;">
                            SMS Bakiyesi Kalmadı
                        </h5>
                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4" style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);">
                    <div class="d-flex align-items-start gap-3">
                        <i class="bi bi-phone text-warning" style="font-size: 2rem; flex-shrink: 0; margin-top: 4px;"></i>
                        <div>
                            <p class="mb-2 fw-bold text-dark" style="font-size: 1.1rem;">
                                SMS bakiyeniz kalmamıştır!
                            </p>
                            <p class="mb-2 text-muted" style="font-size: 0.95rem;">
                                @if(session('sms_warning'))
                                    {{ session('sms_warning') }}
                                @else
                                    İşlem başarıyla tamamlandı ancak SMS gönderilemedi.
                                @endif
                            </p>
                            <p class="mb-0 text-muted" style="font-size: 0.95rem;">
                                SMS göndermek için lütfen SMS paketi satın alın.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0" style="background: #ffffff; padding: 16px 24px;">
                    <button type="button" class="btn btn-secondary px-4" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle me-2"></i>Kapat
                    </button>
                    <a href="{{ route('admin.sms-packages.index') }}" class="btn btn-primary px-4">
                        <i class="bi bi-credit-card me-2"></i>SMS Paketi Satın Al
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    @if($hasPendingPackagePayment && Auth::check() && !Auth::user()->isSuperAdmin())
        <div class="modal fade" id="paymentPendingModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="paymentPendingModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 20px; overflow: hidden;">
                    <div class="modal-header border-0" style="background: linear-gradient(135deg, #0ea5e9 0%, #2563eb 100%);">
                        <h5 class="modal-title text-white fw-bold" id="paymentPendingModalLabel">
                            <i class="bi bi-hourglass-split me-2"></i>Ödeme Onayı Bekleniyor
                        </h5>
                    </div>
                    <div class="modal-body text-center p-4">
                        <div class="mb-3">
                            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status" aria-hidden="true"></div>
                        </div>
                        <h5 class="fw-bold mb-2">Havale/EFT ödemeniz kontrol ediliyor</h5>
                        <p class="text-muted mb-3">
                            Ödeme talebiniz super admin onayına gönderildi. Onay verildiğinde paketiniz otomatik olarak aktif olacaktır.
                        </p>
                        <div class="alert alert-info mb-0 text-start" style="border-left: 4px solid #0ea5e9;">
                            <i class="bi bi-info-circle-fill me-2"></i>
                            Bu süreçte ödeme onayı beklenmektedir ve panel işlemleri geçici olarak kısıtlıdır.
                        </div>
                    </div>
                    <div class="modal-footer border-0 justify-content-center pb-4">
                        <form method="POST" action="{{ route('logout') }}" class="m-0">
                            @csrf
                            <button type="submit" class="btn btn-outline-danger px-4 py-2" style="border-radius: 10px; font-weight: 600;">
                                <i class="bi bi-box-arrow-right me-2"></i>Çıkış Yap
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const pendingModalElement = document.getElementById('paymentPendingModal');
            if (pendingModalElement) {
                const pendingModal = new bootstrap.Modal(pendingModalElement, {
                    backdrop: 'static',
                    keyboard: false
                });
                pendingModal.show();
            }
        });
        </script>
    @endif

    <!-- Paket Seçim Modal (Zorunlu) -->
    @if(session('show_package_selection') && Auth::check() && !Auth::user()->isSuperAdmin() && !$hasPendingPackagePayment)
        @php
            $packages = \App\Models\Package::where('is_active', true)
                ->orderBy('sort_order')
                ->orderBy('name')
                ->get();
        @endphp
        @if($packages->count() > 0)
        <div class="modal fade" id="packageSelectionModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="packageSelectionModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content" style="border-radius: 20px; overflow: hidden;">
                    <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <h5 class="modal-title text-white fw-bold" id="packageSelectionModalLabel">
                            <i class="bi bi-box-seam me-2"></i>Paket Seçimi
                        </h5>
                    </div>
                    <div class="modal-body p-4">
                        <div class="alert alert-warning mb-4" style="border-left: 4px solid #f59e0b;">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i>
                            <strong>Paket satın almanız gerekmektedir!</strong> Devam edebilmek için bir paket seçin veya kupon kodunuz varsa uygulayın.
                        </div>

                        <div class="border rounded-3 p-3 mb-4" style="border: 2px dashed #ec4899 !important;">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-tag-fill me-2" style="color: #ec4899;"></i>
                                <strong style="color: #be185d;">Kupon kodunuz var mı?</strong>
                            </div>
                            <div class="row g-2 align-items-end">
                                <div class="col">
                                    <input type="text" id="modalCouponCode" class="form-control" placeholder="Kupon kodu" maxlength="64">
                                    <div id="modalCouponMessage" class="small mt-1"></div>
                                </div>
                                <div class="col-auto">
                                    <button type="button" id="modalCouponApply" class="btn text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                                        <i class="bi bi-check2-circle me-1"></i>Uygula
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row g-4 justify-content-center">
                            @php
                                // Paketleri sırala: popüler olan ortada olsun
                                $sortedPackages = $packages->sortBy(function($pkg) {
                                    return $pkg->is_popular ? 1 : ($pkg->sort_order == 1 ? 0 : 2);
                                });
                            @endphp
                            @foreach($sortedPackages as $package)
                            <div class="col-12 col-md-4">
                                <div class="card h-100 shadow-sm border-0 {{ $package->is_popular ? 'border-primary border-3' : 'border' }}" style="border-radius: 16px; transition: all 0.3s ease; {{ $package->is_popular ? 'transform: scale(1.05); box-shadow: 0 10px 30px rgba(236, 72, 153, 0.3) !important;' : '' }}">
                                    @if($package->is_popular)
                                    <div class="position-absolute top-0 start-50 translate-middle mt-3" style="z-index: 10;">
                                        <span class="badge bg-primary px-3 py-2" style="font-size: 0.85rem; box-shadow: 0 4px 10px rgba(0,0,0,0.2);">
                                            <i class="bi bi-star-fill me-1"></i>Popüler
                                        </span>
                                    </div>
                                    @endif
                                    <div class="card-body p-4" style="padding-top: {{ $package->is_popular ? '3.5rem' : '1.5rem' }} !important;">
                                        <h5 class="card-title fw-bold mb-2 text-center">{{ $package->name }}</h5>
                                        @if($package->description)
                                        <p class="text-muted small mb-3 text-center">{{ $package->description }}</p>
                                        @endif
                                        
                                        <div class="mb-4 text-center">
                                            @if($package->original_price && $package->original_price > $package->price)
                                            <div class="mb-2">
                                                <span class="text-decoration-line-through text-muted" style="font-size: 1.5rem; font-weight: 600;">
                                                    {{ number_format($package->original_price, 0, ',', '.') }} ₺
                                                </span>
                                                <span class="badge bg-danger ms-2" style="font-size: 0.85rem; padding: 4px 10px;">
                                                    %{{ $package->discount_percentage }} İndirim
                                                </span>
                                            </div>
                                            @endif
                                            <div class="d-flex align-items-baseline justify-content-center">
                                                <span class="display-4 fw-bold text-primary">{{ $package->formatted_price }}</span>
                                                @if($package->price > 0)
                                                <span class="text-muted ms-2">/{{ $package->price_period_text }}</span>
                                                @endif
                                            </div>
                                            <small class="text-muted d-block mt-1">{{ $package->duration_months ?? 1 }} ay geçerli</small>
                                        </div>
                                        
                                        @if($package->features && count($package->features) > 0)
                                        <div style="max-height: 400px; overflow-y: auto; padding-right: 8px;">
                                            <ul class="list-unstyled mb-4">
                                                @foreach($package->features as $feature)
                                                <li class="mb-2">
                                                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                                                    <span style="font-size: 0.85rem;">{{ $feature }}</span>
                                                </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                        @endif
                                        
                                        <a href="{{ route('payment.checkout.package', $package->id) }}" class="btn btn-primary w-100 {{ $package->is_popular ? 'btn-lg' : '' }} mt-auto text-decoration-none d-block" style="border-radius: 10px; {{ $package->is_popular ? 'background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;' : '' }}">
                                            <i class="bi bi-check-circle me-2"></i>Seç ve Devam Et
                                        </a>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const modal = new bootstrap.Modal(document.getElementById('packageSelectionModal'), {
                backdrop: 'static',
                keyboard: false
            });
            modal.show();

            (function() {
                var btn = document.getElementById('modalCouponApply');
                var input = document.getElementById('modalCouponCode');
                var msgEl = document.getElementById('modalCouponMessage');
                if (!btn || !input) return;
                function applyCoupon() {
                    var code = (input.value || '').trim();
                    if (!code) { if (msgEl) msgEl.innerHTML = '<span class="text-danger">Kupon kodu giriniz.</span>'; return; }
                    if (msgEl) msgEl.innerHTML = '';
                    btn.disabled = true;
                    fetch('{{ route("admin.packages.coupon.apply") }}', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content, 'Accept': 'application/json' },
                        body: JSON.stringify({ code: code })
                    }).then(function(r) { return r.json().then(function(d) { return { ok: r.ok, data: d }; }); })
                    .then(function(res) {
                        if (res.ok && res.data.success) {
                            if (msgEl) msgEl.innerHTML = '<span class="text-success">' + (res.data.message || 'Kupon uygulandı.') + '</span>';
                            if (res.data.redirect) setTimeout(function() { window.location.href = res.data.redirect; }, 1000);
                        } else {
                            if (msgEl) msgEl.innerHTML = '<span class="text-danger">' + (res.data.message || 'Kupon uygulanamadı.') + '</span>';
                            btn.disabled = false;
                        }
                    }).catch(function() {
                        if (msgEl) msgEl.innerHTML = '<span class="text-danger">Bir hata oluştu.</span>';
                        btn.disabled = false;
                    });
                }
                btn.addEventListener('click', applyCoupon);
                input.addEventListener('keydown', function(e) { if (e.key === 'Enter') applyCoupon(); });
            })();
            
            // AJAX istekleri için global interceptor
            const originalFetch = window.fetch;
            window.fetch = function(...args) {
                return originalFetch.apply(this, args)
                    .then(response => {
                        if (response.status === 403) {
                            return response.json().then(data => {
                                if (data.message && data.message.includes('Paket satın almanız gerekmektedir')) {
                                    // Paket seçim modalını göster
                                    if (document.getElementById('packageSelectionModal')) {
                                        const modal = new bootstrap.Modal(document.getElementById('packageSelectionModal'), {
                                            backdrop: 'static',
                                            keyboard: false
                                        });
                                        modal.show();
                                    } else if (document.getElementById('paymentPendingModal')) {
                                        const pendingModal = new bootstrap.Modal(document.getElementById('paymentPendingModal'), {
                                            backdrop: 'static',
                                            keyboard: false
                                        });
                                        pendingModal.show();
                                    } else {
                                        window.location.href = data.redirect || '{{ route("admin.packages.select") }}';
                                    }
                                } else if (data.message && data.message.includes('onay bekliyor')) {
                                    if (document.getElementById('paymentPendingModal')) {
                                        const pendingModal = new bootstrap.Modal(document.getElementById('paymentPendingModal'), {
                                            backdrop: 'static',
                                            keyboard: false
                                        });
                                        pendingModal.show();
                                    } else {
                                        window.location.href = data.redirect || '{{ route("admin.settings.personal-invoices") }}';
                                    }
                                }
                                return Promise.reject(new Error(data.message || 'İşlem engellendi'));
                            });
                        }
                        return response;
                    });
            };
            
            // jQuery AJAX için de interceptor (eğer kullanılıyorsa)
            if (typeof jQuery !== 'undefined') {
                $(document).ajaxError(function(event, xhr) {
                    if (xhr.status === 403) {
                        try {
                            const data = JSON.parse(xhr.responseText);
                            if (data.message && data.message.includes('Paket satın almanız gerekmektedir')) {
                                if (document.getElementById('packageSelectionModal')) {
                                    const modal = new bootstrap.Modal(document.getElementById('packageSelectionModal'), {
                                        backdrop: 'static',
                                        keyboard: false
                                    });
                                    modal.show();
                                } else if (document.getElementById('paymentPendingModal')) {
                                    const pendingModal = new bootstrap.Modal(document.getElementById('paymentPendingModal'), {
                                        backdrop: 'static',
                                        keyboard: false
                                    });
                                    pendingModal.show();
                                } else {
                                    window.location.href = data.redirect || '{{ route("admin.packages.select") }}';
                                }
                            } else if (data.message && data.message.includes('onay bekliyor')) {
                                if (document.getElementById('paymentPendingModal')) {
                                    const pendingModal = new bootstrap.Modal(document.getElementById('paymentPendingModal'), {
                                        backdrop: 'static',
                                        keyboard: false
                                    });
                                    pendingModal.show();
                                } else {
                                    window.location.href = data.redirect || '{{ route("admin.settings.personal-invoices") }}';
                                }
                            }
                        } catch (e) {
                            console.error('AJAX error parsing failed:', e);
                        }
                    }
                });
            }
        });
        </script>
        @endif
    @endif

    @yield('scripts')
    @stack('scripts')
    
    <!-- AOS Animation Library -->
    <!-- AOS animasyonları devre dışı bırakıldı -->
    <script>
        
        document.addEventListener('DOMContentLoaded', function() {
            // Tüm data-aos attribute'larını kaldır
            document.querySelectorAll('[data-aos]').forEach(el => {
                el.removeAttribute('data-aos');
                el.removeAttribute('data-aos-delay');
                el.removeAttribute('data-aos-duration');
                el.removeAttribute('data-aos-easing');
            });
        });
    </script>
    @endif
</body>
</html>

