<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hakkımızda - Salonay</title>
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #10b981;
            --secondary-blue: #34d399;
            --light-blue: #60a5fa;
            --dark-blue: #047857;
            --gradient: linear-gradient(135deg, #10b981 0%, #34d399 50%, #60a5fa 100%);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            padding-top: 80px;
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(15px);
            box-shadow: 0 2px 25px rgba(16, 185, 129, 0.1);
        }
        
        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            background: var(--gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .hero-section {
            background: var(--gradient);
            color: white;
            padding: 4rem 0;
        }
        
        .content-section {
            padding: 4rem 0;
        }
        
        .feature-box {
            padding: 2rem;
            border-radius: 15px;
            background: #f8fafc;
            margin-bottom: 2rem;
            transition: all 0.3s;
        }
        
        .feature-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(16, 185, 129, 0.15);
        }
        
        .feature-icon {
            width: 60px;
            height: 60px;
            background: var(--gradient);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    @include('partials.navbar')
    
    <section class="hero-section">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h1 class="display-4 fw-bold mb-3">Hakkımızda</h1>
                    <p class="lead">Salonay ile yeni nesil çözümler</p>
                </div>
            </div>
        </div>
    </section>
    
    <section class="content-section">
        <div class="container">
            <div class="row mb-5">
                <div class="col-lg-6">
                    <h2 class="fw-bold mb-4">Misyonumuz</h2>
                    <p class="lead">Güzellik salonu işletmelerinin randevu süreçlerini dijitalleştirerek, müşteri memnuniyetini artırmak ve işletmelerin verimliliğini maksimize etmek.</p>
                    <p>Modern teknoloji ile geleneksel güzellik salonu işletmeciliğini bir araya getirerek, sektörde yeni bir standart oluşturuyoruz.</p>
                </div>
                <div class="col-lg-6">
                    <h2 class="fw-bold mb-4">Vizyonumuz</h2>
                    <p class="lead">Türkiye'nin en güvenilir ve kullanıcı dostu randevu yönetim platformu olmak.</p>
                    <p>İnovatif çözümlerimiz ile güzellik salonu işletmelerinin büyümesine katkıda bulunmak ve müşterilere en iyi deneyimi sunmak.</p>
                </div>
            </div>
            
            <!-- Sistem Mimarisi Banner -->
            <div class="row mb-5">
                <div class="col-12">
                    <div class="p-4" style="background: linear-gradient(135deg, #10b981 0%, #34d399 100%); border-radius: 15px; color: white;">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="fw-bold mb-2">Premium SaaS Platform Mimarisi</h4>
                                <p class="mb-0">8 entegre büyüme modülü ile işletmenizi büyütün. Sistem mimarimizi detaylı inceleyin.</p>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <a href="{{ route('pages.architecture') }}" class="btn btn-light">
                                    <i class="bi bi-diagram-3"></i> Mimarisi İncele
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row mt-5">
                <div class="col-12">
                    <h2 class="fw-bold mb-4 text-center">Neden Bizi Seçmelisiniz?</h2>
                </div>
                <div class="col-md-4">
                    <div class="feature-box">
                        <div class="feature-icon">
                            <i class="bi bi-shield-check"></i>
                        </div>
                        <h4>Güvenilir Sistem</h4>
                        <p>Verileriniz güvende. SSL şifreleme ve düzenli yedekleme ile verileriniz korunur.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-box">
                        <div class="feature-icon">
                            <i class="bi bi-headset"></i>
                        </div>
                        <h4>7/24 Destek</h4>
                        <p>Her zaman yanınızdayız. Teknik destek ekibimiz size yardımcı olmaya hazır.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-box">
                        <div class="feature-icon">
                            <i class="bi bi-graph-up-arrow"></i>
                        </div>
                        <h4>Sürekli Gelişim</h4>
                        <p>Platformumuz sürekli güncellenir ve yeni özellikler eklenir.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    @include('partials.footer')
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

