<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İletişim - Salonay</title>
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #10b981;
            --gradient: linear-gradient(135deg, #10b981 0%, #34d399 50%, #60a5fa 100%);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            padding-top: 80px;
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(15px);
            box-shadow: 0 2px 25px rgba(16, 185, 129, 0.1);
        }
        
        .hero-section {
            background: var(--gradient);
            color: white;
            padding: 4rem 0;
        }
        
        .contact-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        
        .contact-icon {
            width: 60px;
            height: 60px;
            background: var(--gradient);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }
        
        .form-control:focus {
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 0.2rem rgba(16, 185, 129, 0.15);
        }
        
        .btn-primary {
            background: var(--gradient);
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 50px;
        }
    </style>
</head>
<body>
    @include('partials.navbar')
    
    <section class="hero-section">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h1 class="display-4 fw-bold mb-3">İletişim</h1>
                    <p class="lead">Sorularınız için bizimle iletişime geçin</p>
                </div>
            </div>
        </div>
    </section>
    
    <section class="py-5">
        <div class="container">
            <!-- Sistem Mimarisi Banner -->
            <div class="row mb-5">
                <div class="col-12">
                    <div class="p-4" style="background: linear-gradient(135deg, #10b981 0%, #34d399 100%); border-radius: 15px; color: white;">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="fw-bold mb-2">Premium SaaS Platform Mimarisi</h4>
                                <p class="mb-0">8 entegre büyüme modülü ile işletmenizi büyütün. Sistem mimarimizi detaylı inceleyin.</p>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <a href="{{ route('pages.architecture') }}" class="btn btn-light">
                                    <i class="bi bi-diagram-3"></i> Mimarisi İncele
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-8 mb-4">
                    <div class="contact-card">
                        <h3 class="mb-4">Bize Mesaj Gönderin</h3>
                        <form>
                            <div class="mb-3">
                                <label class="form-label">Adınız Soyadınız</label>
                                <input type="text" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">E-posta</label>
                                <input type="email" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Telefon</label>
                                <input type="tel" class="form-control">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Mesajınız</label>
                                <textarea class="form-control" rows="5" required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary text-white">
                                <i class="bi bi-send"></i> Gönder
                            </button>
                        </form>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <h5>Adres</h5>
                        <p>İstanbul, Türkiye</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="bi bi-telephone"></i>
                        </div>
                        <h5>Telefon</h5>
                        <p>+90 (555) 123 45 67</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="bi bi-envelope"></i>
                        </div>
                        <h5>E-posta</h5>
                        <p>info@dugunrandevu.com</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    @include('partials.footer')
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

