<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Çerez Politikası - Salonay</title>
    <meta name="description" content="Salonay çerez politikası. Web sitemizde kullanılan çerezler ve bunların yönetimi hakkında bilgi edinin.">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ url('/cerez-politikasi') }}">
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Inter', sans-serif; background: #f8fafc; }
        .page-header { background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 60px 0; color: white; }
        .content-section { padding: 60px 0; }
        .content-card { background: white; border-radius: 15px; padding: 40px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        h2 { color: #10b981; margin-top: 30px; }
        .footer { background: #1e293b; color: white; padding: 40px 0; }
    </style>
</head>
<body>
    <header class="page-header">
        <div class="container">
            <nav class="mb-4">
                <a href="{{ url('/') }}" class="text-white text-decoration-none">
                    <i class="bi bi-arrow-left me-2"></i>Ana Sayfa
                </a>
            </nav>
            <h1><i class="bi bi-cookie me-2"></i>Çerez Politikası</h1>
            <p class="mb-0 opacity-75">Son güncelleme: {{ date('d.m.Y') }}</p>
        </div>
    </header>
    
    <section class="content-section">
        <div class="container">
            <div class="content-card">
                <p class="lead">Bu Çerez Politikası, Salonay web sitesinde kullanılan çerezler hakkında sizi bilgilendirmek amacıyla hazırlanmıştır.</p>
                
                <h2><i class="bi bi-question-circle me-2"></i>Çerez Nedir?</h2>
                <p>Çerezler, web sitelerinin tarayıcınıza yerleştirdiği küçük metin dosyalarıdır. Bu dosyalar, siteyi tekrar ziyaret ettiğinizde sizi tanımak ve deneyiminizi kişiselleştirmek için kullanılır.</p>
                
                <h2><i class="bi bi-list-check me-2"></i>Kullandığımız Çerez Türleri</h2>
                <table class="table table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th>Çerez Türü</th>
                            <th>Amaç</th>
                            <th>Süre</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><strong>Zorunlu Çerezler</strong></td>
                            <td>Sitenin temel işlevleri için gerekli (oturum yönetimi, güvenlik)</td>
                            <td>Oturum süresi</td>
                        </tr>
                        <tr>
                            <td><strong>İşlevsel Çerezler</strong></td>
                            <td>Tercihlerinizi hatırlamak (dil, tema seçimi)</td>
                            <td>1 yıl</td>
                        </tr>
                        <tr>
                            <td><strong>Performans Çerezleri</strong></td>
                            <td>Site performansını ölçmek ve iyileştirmek</td>
                            <td>2 yıl</td>
                        </tr>
                        <tr>
                            <td><strong>Analitik Çerezler</strong></td>
                            <td>Ziyaretçi davranışlarını analiz etmek</td>
                            <td>2 yıl</td>
                        </tr>
                    </tbody>
                </table>
                
                <h2><i class="bi bi-gear me-2"></i>Çerezleri Yönetme</h2>
                <p>Çerezleri tarayıcı ayarlarınızdan yönetebilirsiniz:</p>
                <ul>
                    <li><strong>Chrome:</strong> Ayarlar > Gizlilik ve güvenlik > Çerezler</li>
                    <li><strong>Firefox:</strong> Seçenekler > Gizlilik ve Güvenlik > Çerezler</li>
                    <li><strong>Safari:</strong> Tercihler > Gizlilik > Çerezler</li>
                    <li><strong>Edge:</strong> Ayarlar > Çerezler ve site izinleri</li>
                </ul>
                
                <div class="alert alert-warning mt-4">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Not:</strong> Çerezleri devre dışı bırakmak, web sitemizin bazı özelliklerinin düzgün çalışmamasına neden olabilir.
                </div>
                
                <h2><i class="bi bi-envelope me-2"></i>İletişim</h2>
                <p>Sorularınız için {{ $settings['email'] ?? 'info@salonay.com' }} adresinden bize ulaşabilirsiniz.</p>
            </div>
        </div>
    </section>
    
    <footer class="footer">
        <div class="container text-center">
            <p class="mb-0">&copy; {{ date('Y') }} {{ $companyName ?? 'Salonay' }}. Tüm hakları saklıdır.</p>
        </div>
    </footer>
</body>
</html>


