<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sıkça Sorulan Sorular (SSS) - Salonay</title>
    <meta name="description" content="Salonay hakkında sıkça sorulan sorular ve cevapları. Salon randevu sistemi, fiyatlandırma ve özellikler hakkında bilgi alın.">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ url('/sss') }}">
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Inter', sans-serif; background: #f8fafc; }
        .page-header { background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 60px 0; color: white; }
        .content-section { padding: 60px 0; }
        .accordion-button:not(.collapsed) { background: #eff6ff; color: #10b981; }
        .accordion-button:focus { box-shadow: none; border-color: #10b981; }
        .category-title { color: #10b981; font-weight: 600; margin: 30px 0 15px; }
        .footer { background: #1e293b; color: white; padding: 40px 0; }
    </style>
    
    <!-- FAQ Schema -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "FAQPage",
        "mainEntity": [
            {
                "@type": "Question",
                "name": "Salonay nedir?",
                "acceptedAnswer": {
                    "@type": "Answer",
                    "text": "Salonay, güzellik salonları ve kuaförler için geliştirilmiş profesyonel bir randevu yönetim sistemidir."
                }
            },
            {
                "@type": "Question",
                "name": "Salonay ücretsiz mi?",
                "acceptedAnswer": {
                    "@type": "Answer",
                    "text": "Evet, temel özellikler ücretsiz sunulmaktadır. Gelişmiş özellikler için uygun fiyatlı paketler mevcuttur."
                }
            },
            {
                "@type": "Question",
                "name": "Mobil cihazlardan kullanabilir miyim?",
                "acceptedAnswer": {
                    "@type": "Answer",
                    "text": "Evet, Salonay tamamen responsive tasarıma sahiptir ve tüm cihazlardan erişilebilir."
                }
            }
        ]
    }
    </script>
</head>
<body>
    <header class="page-header">
        <div class="container">
            <nav class="mb-4">
                <a href="{{ url('/') }}" class="text-white text-decoration-none">
                    <i class="bi bi-arrow-left me-2"></i>Ana Sayfa
                </a>
            </nav>
            <h1><i class="bi bi-question-circle me-2"></i>Sıkça Sorulan Sorular</h1>
            <p class="mb-0 opacity-75">Merak ettiğiniz her şeyin cevabı burada</p>
        </div>
    </header>
    
    <section class="content-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    
                    <h3 class="category-title"><i class="bi bi-info-circle me-2"></i>Genel Sorular</h3>
                    <div class="accordion" id="faqGeneral">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                    Salonay nedir?
                                </button>
                            </h2>
                            <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqGeneral">
                                <div class="accordion-body">
                                    Salonay, güzellik salonları, kuaförler ve estetik merkezleri için geliştirilmiş profesyonel bir randevu yönetim sistemidir. Randevularınızı, müşterilerinizi, ödemelerinizi ve tüm işletme süreçlerinizi tek panelden yönetmenizi sağlar.
                                </div>
                            </div>
                        </div>
                        
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                    Kimler Salonay'ı kullanabilir?
                                </button>
                            </h2>
                            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqGeneral">
                                <div class="accordion-body">
                                    <ul>
                                        <li>Güzellik salonları</li>
                                        <li>Kuaförler</li>
                                        <li>Estetik merkezleri</li>
                                        <li>Cilt bakım merkezleri</li>
                                        <li>Masaj ve spa merkezleri</li>
                                        <li>Her türlü randevu gerektiren işletme</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                    Mobil cihazlardan erişebilir miyim?
                                </button>
                            </h2>
                            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqGeneral">
                                <div class="accordion-body">
                                    Evet! Salonay tamamen responsive (duyarlı) tasarıma sahiptir. Telefon, tablet ve bilgisayarınızdan sorunsuz bir şekilde erişebilir ve yönetebilirsiniz. Ayrıca mobil uygulamamız da mevcuttur.
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <h3 class="category-title"><i class="bi bi-credit-card me-2"></i>Fiyatlandırma</h3>
                    <div class="accordion" id="faqPricing">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                                    Salonay ücretsiz mi?
                                </button>
                            </h2>
                            <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqPricing">
                                <div class="accordion-body">
                                    Evet, Salonay'ın temel özellikleri ücretsiz olarak sunulmaktadır. Daha gelişmiş özellikler ve daha fazla kapasite için uygun fiyatlı premium paketlerimiz mevcuttur.
                                </div>
                            </div>
                        </div>
                        
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq5">
                                    Ödeme yöntemleri nelerdir?
                                </button>
                            </h2>
                            <div id="faq5" class="accordion-collapse collapse" data-bs-parent="#faqPricing">
                                <div class="accordion-body">
                                    Kredi kartı, banka kartı ve havale/EFT ile ödeme yapabilirsiniz. Tüm ödemeler SSL güvenlik protokolü ile korunmaktadır.
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <h3 class="category-title"><i class="bi bi-gear me-2"></i>Özellikler</h3>
                    <div class="accordion" id="faqFeatures">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq6">
                                    Hangi özellikler mevcut?
                                </button>
                            </h2>
                            <div id="faq6" class="accordion-collapse collapse" data-bs-parent="#faqFeatures">
                                <div class="accordion-body">
                                    <ul>
                                        <li>Salon ve mekan yönetimi</li>
                                        <li>Online randevu sistemi</li>
                                        <li>Takvim görünümü</li>
                                        <li>Müşteri yönetimi (CRM)</li>
                                        <li>Gelir-gider ve kasa takibi</li>
                                        <li>Fatura ve sözleşme oluşturma</li>
                                        <li>SMS bildirimleri</li>
                                        <li>Detaylı raporlama</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq7">
                                    Verilerim güvende mi?
                                </button>
                            </h2>
                            <div id="faq7" class="accordion-collapse collapse" data-bs-parent="#faqFeatures">
                                <div class="accordion-body">
                                    Evet! Verileriniz SSL şifreleme ile korunmaktadır. Düzenli yedekleme yapılmakta ve KVKK uyumlu veri politikalarımızla güvenliğiniz sağlanmaktadır.
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <h3 class="category-title"><i class="bi bi-headset me-2"></i>Destek</h3>
                    <div class="accordion" id="faqSupport">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq8">
                                    Nasıl destek alabilirim?
                                </button>
                            </h2>
                            <div id="faq8" class="accordion-collapse collapse" data-bs-parent="#faqSupport">
                                <div class="accordion-body">
                                    <ul>
                                        <li><strong>E-posta:</strong> {{ $settings['email'] ?? 'info@salonay.com' }}</li>
                                        <li><strong>Telefon:</strong> 0850 811 08 20</li>
                                        <li><strong>Canlı Destek:</strong> Panel içinden 7/24</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-5">
                        <p class="text-muted">Sorunuzun cevabını bulamadınız mı?</p>
                        <a href="{{ url('/iletisim') }}" class="btn btn-primary btn-lg">
                            <i class="bi bi-envelope me-2"></i>Bize Ulaşın
                        </a>
                    </div>
                    
                </div>
            </div>
        </div>
    </section>
    
    <footer class="footer">
        <div class="container text-center">
            <p class="mb-0">&copy; {{ date('Y') }} {{ $companyName ?? 'Salonay' }}. Tüm hakları saklıdır.</p>
        </div>
    </footer>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


