<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ url('favicon.png') }}?v=3">
    <link rel="shortcut icon" href="{{ url('favicon.png') }}?v=3">
    <link rel="apple-touch-icon" href="{{ url('favicon.png') }}?v=3">
    
    @php
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key');
        } catch (\Exception $e) {
            $settings = collect([]);
        }
        $phone = $settings['phone'] ?? '0850 811 08 20';
        $email = $settings['email'] ?? 'info@salonay.com';
        $companyName = $settings['company_name'] ?? 'Salonay';
        $address = $settings['address'] ?? '';
    @endphp
    
    <title>KVKK Aydınlatma Metni - {{ $companyName }}</title>
    <meta name="description" content="6698 Sayılı Kişisel Verilerin Korunması Kanunu kapsamında {{ $companyName }} aydınlatma metni.">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ url('/kvkk') }}">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600;700;800;900&family=Montserrat:wght@700;800;900&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #ec4899;
            --secondary-blue: #f472b6;
            --light-blue: #f9a8d4;
            --dark-blue: #be185d;
            --dark-color: #1e293b;
            --light-color: #f8fafc;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            overflow-x: hidden;
            scroll-behavior: smooth;
            color: #1e293b;
        }
        
        /* Top Promo Banner */
        .top-promo-banner {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 100%);
            color: white;
            padding: 12px 0;
            text-align: center;
            font-size: 14px;
            font-weight: 600;
            position: relative;
            z-index: 1001;
        }
        
        .top-promo-banner a {
            color: white;
            text-decoration: underline;
            font-weight: 700;
        }
        
        /* Navbar */
        .navbar {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 0.5rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .navbar-brand {
            display: flex;
            align-items: center;
            text-decoration: none;
        }
        
        .logo-image {
            height: 50px;
            width: auto;
            object-fit: contain;
        }
        
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        
        .logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 36px;
            letter-spacing: 2.5px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 25%, #fbcfe8 50%, #f472b6 75%, #ec4899 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradient 3s ease infinite;
            padding: 6px 16px;
            border-radius: 14px;
            overflow: hidden;
        }
        
        @keyframes logoGradient {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        .logo-text:hover {
            transform: scale(1.1) translateY(-3px);
            letter-spacing: 3.5px;
            animation-duration: 1.5s;
        }
        
        .nav-link {
            font-weight: 500;
            color: #1e293b !important;
            margin: 0 0.5rem;
            transition: color 0.3s;
        }
        
        .nav-link:hover, .nav-link.active {
            color: var(--primary-blue) !important;
        }
        
        .navbar-phone {
            color: #1e293b;
            font-weight: 600;
            margin-right: 1rem;
            font-size: 0.875rem;
        }
        
        .navbar .btn {
            padding: 0.5rem 1.25rem;
            font-size: 0.9rem;
            font-weight: 600;
            border-radius: 8px;
            white-space: nowrap;
            transition: all 0.3s ease;
        }
        
        .navbar .btn-primary {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            color: white;
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
        }
        
        .navbar .btn-primary:hover {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.4);
        }
        
        .navbar .btn-outline-primary {
            border: 2px solid var(--primary-blue);
            color: var(--primary-blue);
            background: transparent;
            padding: 0.5rem 1.25rem;
        }
        
        .navbar .btn-outline-primary:hover {
            background: var(--primary-blue);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
        }
        
        /* Hero Section */
        .page-hero {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 50%, #f472b6 100%);
            color: white;
            padding: 60px 0 40px;
            position: relative;
            overflow: hidden;
        }
        
        .page-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 30% 50%, rgba(255,255,255,0.1) 0%, transparent 50%),
                        radial-gradient(circle at 70% 80%, rgba(255,255,255,0.1) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .page-hero h1 {
            font-size: 3rem;
            font-weight: 900;
            margin-bottom: 1rem;
            line-height: 1.2;
            position: relative;
            z-index: 1;
        }
        
        .page-hero p {
            font-size: 1.15rem;
            margin-bottom: 0;
            opacity: 0.95;
            position: relative;
            z-index: 1;
        }
        
        /* Content Section */
        .content-section {
            padding: 60px 0;
            background: #f8fafc;
        }
        
        .content-card {
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
            border: 1px solid #e2e8f0;
        }
        
        .content-card h2 {
            color: #ec4899;
            margin-top: 30px;
            font-weight: 700;
            font-size: 1.5rem;
        }
        
        .content-card h2:first-child {
            margin-top: 0;
        }
        
        .content-card p {
            color: #64748b;
            line-height: 1.8;
            margin-bottom: 1rem;
        }
        
        .content-card ul, .content-card ol {
            color: #64748b;
            line-height: 1.8;
            margin-bottom: 1rem;
            padding-left: 1.5rem;
        }
        
        .content-card li {
            margin-bottom: 0.5rem;
        }
        
        .info-box {
            background: linear-gradient(135deg, #fdf2f8 0%, #fce7f3 100%);
            border-left: 4px solid #ec4899;
            padding: 20px;
            border-radius: 0 12px 12px 0;
            margin: 20px 0;
            color: #1e293b;
        }
        
        .info-box strong {
            color: #ec4899;
        }
        
        .table {
            margin-top: 1rem;
            margin-bottom: 1rem;
        }
        
        /* Footer */
        .footer {
            background: #1e293b;
            color: white;
            padding: 60px 0 30px;
            margin-top: 80px;
        }
        
        .footer h5 {
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.1rem;
            color: white;
        }
        
        .footer a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: color 0.3s;
            display: block;
            margin-bottom: 0.75rem;
        }
        
        .footer a:hover {
            color: white;
        }
        
        .footer .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 2rem;
            margin-top: 2rem;
            text-align: center;
            color: rgba(255,255,255,0.5);
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .top-promo-banner {
                display: none !important;
            }
            
            .navbar {
                padding: 0.75rem 0;
            }
            
            .logo-text {
                font-size: 28px !important;
                letter-spacing: 1.5px !important;
            }
            
            .page-hero {
                padding: 40px 0 30px;
                text-align: center;
            }
            
            .page-hero h1 {
                font-size: 2rem;
            }
            
            .page-hero p {
                font-size: 1rem;
            }
            
            .content-card {
                padding: 1.5rem;
            }
            
            .navbar .d-flex {
                flex-direction: column;
                width: 100%;
                gap: 0.75rem !important;
                padding: 1rem 0;
            }
            
            .navbar-phone {
                margin: 0;
                text-align: center;
            }
            
            .navbar .btn {
                width: 100%;
                margin-right: 0 !important;
            }
        }
    </style>
</head>
<body>
    <!-- Top Promo Banner -->
    <div class="top-promo-banner">
        <div class="container">
            <div class="d-flex align-items-center justify-content-center flex-wrap gap-2">
                <strong>Salon Randevu Yönetim Sisteminde Özel Fırsat! %50'ye Varan İndirim!</strong>
                <span>•</span>
                <strong>Hemen Başla, İlk Ay Ücretsiz!</strong>
            </div>
        </div>
    </div>
    
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg">
        <div class="container">
            <a class="navbar-brand" href="{{ route('home') }}" style="display: flex; align-items: center;">
                <img src="{{ asset('salonayheaderlogo.png') }}" alt="Salonay" class="logo-image" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-block';">
                <span class="logo-text" style="display: none;">Salonay</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('home') }}#ozellikler">Özellikler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('public.salons.index') }}">Salonlar</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('home') }}#paketler">Paketler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('pages.about') }}">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('pages.contact') }}">İletişim</a>
                    </li>
                </ul>
                <div class="d-flex align-items-center gap-2">
                    <span class="navbar-phone">
                        <i class="bi bi-telephone"></i> {{ $phone }}
                    </span>
                    @auth
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-primary">
                            Panel
                        </a>
                    @else
                        <a href="{{ route('login') }}" class="btn btn-outline-primary">
                            <i class="bi bi-box-arrow-in-right"></i> Giriş Yap
                        </a>
                        <a href="{{ route('register') }}" class="btn btn-primary">
                            <i class="bi bi-person-plus"></i> Ücretsiz Deneyin
                        </a>
                    @endauth
                </div>
            </div>
        </div>
    </nav>
    
    <!-- Hero Section -->
    <section class="page-hero">
        <div class="container">
            <h1><i class="bi bi-shield-check me-2"></i>KVKK Aydınlatma Metni</h1>
            <p>6698 Sayılı Kişisel Verilerin Korunması Kanunu</p>
        </div>
    </section>
    
    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-card">
                <div class="info-box">
                    <strong>Veri Sorumlusu:</strong> {{ $companyName }}<br>
                    <strong>İletişim:</strong> {{ $email }} | {{ $phone }}
                </div>
                
                <p class="lead">6698 sayılı Kişisel Verilerin Korunması Kanunu ("KVKK") uyarınca, kişisel verilerinizin işlenmesine ilişkin aşağıdaki bilgilendirmeyi dikkatinize sunarız.</p>
                
                <h2><i class="bi bi-1-circle me-2"></i>1. Veri Sorumlusunun Kimliği</h2>
                <p>{{ $companyName }}, KVKK kapsamında veri sorumlusu sıfatıyla kişisel verilerinizi işlemektedir.</p>
                
                <h2><i class="bi bi-2-circle me-2"></i>2. Kişisel Verilerin İşlenme Amacı</h2>
                <p>Kişisel verileriniz aşağıdaki amaçlarla işlenmektedir:</p>
                <ul>
                    <li>Hizmet sözleşmesinin kurulması ve ifası</li>
                    <li>Müşteri ilişkileri yönetimi</li>
                    <li>Yasal yükümlülüklerin yerine getirilmesi</li>
                    <li>İletişim faaliyetlerinin yürütülmesi</li>
                    <li>Bilgi güvenliği süreçlerinin yürütülmesi</li>
                    <li>Finans ve muhasebe işlemlerinin yürütülmesi</li>
                </ul>
                
                <h2><i class="bi bi-3-circle me-2"></i>3. İşlenen Kişisel Veriler</h2>
                <table class="table table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th>Veri Kategorisi</th>
                            <th>Veri Türleri</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Kimlik Bilgileri</td>
                            <td>Ad, soyad, T.C. kimlik numarası</td>
                        </tr>
                        <tr>
                            <td>İletişim Bilgileri</td>
                            <td>Telefon, e-posta, adres</td>
                        </tr>
                        <tr>
                            <td>Müşteri İşlem Bilgileri</td>
                            <td>Randevu, fatura, ödeme bilgileri</td>
                        </tr>
                        <tr>
                            <td>İşlem Güvenliği Bilgileri</td>
                            <td>IP adresi, log kayıtları, şifre</td>
                        </tr>
                    </tbody>
                </table>
                
                <h2><i class="bi bi-4-circle me-2"></i>4. Kişisel Verilerin Aktarımı</h2>
                <p>Kişisel verileriniz, yukarıda belirtilen amaçlarla sınırlı olarak:</p>
                <ul>
                    <li>Yasal zorunluluk halinde yetkili kamu kurum ve kuruluşlarına</li>
                    <li>Hizmet sağlayıcılarına (hosting, SMS hizmeti vb.)</li>
                    <li>İş ortaklarına (açık rızanız dahilinde)</li>
                </ul>
                <p>aktarılabilmektedir.</p>
                
                <h2><i class="bi bi-5-circle me-2"></i>5. Veri İşlemenin Hukuki Sebebi</h2>
                <p>Kişisel verileriniz, KVKK'nın 5. ve 6. maddelerinde belirtilen:</p>
                <ul>
                    <li>Açık rıza</li>
                    <li>Sözleşmenin kurulması ve ifası</li>
                    <li>Hukuki yükümlülük</li>
                    <li>Meşru menfaat</li>
                </ul>
                <p>hukuki sebeplerine dayanılarak işlenmektedir.</p>
                
                <h2><i class="bi bi-6-circle me-2"></i>6. KVKK Kapsamındaki Haklarınız</h2>
                <p>KVKK'nın 11. maddesi kapsamında aşağıdaki haklara sahipsiniz:</p>
                <ul>
                    <li>Kişisel verilerinizin işlenip işlenmediğini öğrenme</li>
                    <li>İşlenmişse bilgi talep etme</li>
                    <li>İşlenme amacını ve amaca uygun kullanılıp kullanılmadığını öğrenme</li>
                    <li>Yurt içinde veya yurt dışında aktarıldığı üçüncü kişileri bilme</li>
                    <li>Eksik veya yanlış işlenmişse düzeltilmesini isteme</li>
                    <li>KVKK'nın 7. maddesindeki şartlar çerçevesinde silinmesini veya yok edilmesini isteme</li>
                    <li>Düzeltme ve silme işlemlerinin üçüncü kişilere bildirilmesini isteme</li>
                    <li>Otomatik sistemlerle analiz sonucu aleyhinize çıkan sonuca itiraz etme</li>
                    <li>Kanuna aykırı işleme nedeniyle zarara uğramanız halinde zararın giderilmesini talep etme</li>
                </ul>
                
                <h2><i class="bi bi-7-circle me-2"></i>7. Başvuru Yöntemi</h2>
                <p>Haklarınızı kullanmak için:</p>
                <ul>
                    <li><strong>E-posta:</strong> {{ $email }}</li>
                    <li><strong>Telefon:</strong> {{ $phone }}</li>
                </ul>
                <p>adreslerine başvurabilirsiniz. Başvurularınız en geç 30 gün içinde cevaplanacaktır.</p>
            </div>
        </div>
    </section>
    
    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-3 mb-4">
                    <div style="display: flex; align-items: center; margin-bottom: 1rem;">
                        <span class="logo-text" style="font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif; font-weight: normal; font-size: 40px; letter-spacing: 2.5px; background: linear-gradient(135deg, #ffffff 0%, #fce7f3 30%, #fbcfe8 60%, #ffffff 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; background-size: 200% 200%; text-shadow: 0 4px 20px rgba(255, 255, 255, 0.4), 0 0 40px rgba(255, 255, 255, 0.2); user-select: none; position: relative; display: inline-flex; align-items: center; animation: logoGradient 3s ease infinite; padding: 6px 16px; border-radius: 14px;">{{ $companyName }}</span>
                    </div>
                    <p style="color: rgba(255,255,255,0.7);">Modern ve kullanıcı dostu randevu yönetim sistemi ile işletmenizi büyütün.</p>
                </div>
                <div class="col-md-3 mb-4">
                    <h5>ÇÖZÜMLER</h5>
                    <a href="{{ route('home') }}#paketler">Fiyat Paketleri</a>
                    <a href="{{ route('home') }}#ozellikler">Özellikler</a>
                    <a href="{{ route('public.salons.index') }}">Salonlar</a>
                    <a href="{{ route('home') }}#indirmeler">İndirmeler</a>
                </div>
                <div class="col-md-3 mb-4">
                    <h5>KURUMSAL</h5>
                    <a href="{{ route('pages.about') }}">Hakkımızda</a>
                    <a href="{{ route('pages.contact') }}">İletişim</a>
                </div>
                <div class="col-md-3 mb-4">
                    <h5>İLETİŞİM</h5>
                    <a href="tel:{{ str_replace(' ', '', $phone) }}"><i class="bi bi-telephone me-2"></i> {{ $phone }}</a>
                    <a href="mailto:{{ $email }}"><i class="bi bi-envelope me-2"></i> {{ $email }}</a>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="d-flex flex-wrap justify-content-center gap-3 mb-2" style="font-size: 0.9rem;">
                    <a href="{{ route('pages.kvkk') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">KVKK</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.privacy') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Gizlilik Politikası</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.purchase-agreement') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Satın Alma Sözleşmesi</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.terms') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Kullanım Şartları</a>
                    <span style="color: rgba(255,255,255,0.3);">|</span>
                    <a href="{{ route('pages.cookies') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Çerezler</a>
                </div>
                <p class="mb-0">&copy; {{ date('Y') }} {{ $companyName }}. Tüm hakları saklıdır.</p>
            </div>
        </div>
    </footer>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
