<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fiyatlandırma - Salonay</title>
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #10b981;
            --gradient: linear-gradient(135deg, #10b981 0%, #34d399 50%, #60a5fa 100%);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            padding-top: 80px;
        }
        
        .hero-section {
            background: var(--gradient);
            color: white;
            padding: 4rem 0;
        }
        
        .pricing-card {
            background: white;
            border-radius: 20px;
            padding: 2.5rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            transition: all 0.3s;
            height: 100%;
            border: 2px solid #e2e8f0;
        }
        
        .pricing-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(16, 185, 129, 0.2);
            border-color: var(--primary-blue);
        }
        
        .pricing-card.featured {
            border-color: var(--primary-blue);
            position: relative;
            overflow: hidden;
        }
        
        .pricing-card.featured::before {
            content: 'POPÜLER';
            position: absolute;
            top: 20px;
            right: -30px;
            background: var(--gradient);
            color: white;
            padding: 5px 40px;
            transform: rotate(45deg);
            font-size: 0.75rem;
            font-weight: 700;
        }
        
        .price {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary-blue);
        }
        
        .price-period {
            color: #64748b;
            font-size: 1rem;
        }
        
        .feature-list {
            list-style: none;
            padding: 0;
        }
        
        .feature-list li {
            padding: 0.75rem 0;
            border-bottom: 1px solid #e2e8f0;
        }
        
        .feature-list li:last-child {
            border-bottom: none;
        }
        
        .feature-list li i {
            color: #10b981;
            margin-right: 0.5rem;
        }
        
        .btn-pricing {
            background: var(--gradient);
            border: none;
            color: white;
            padding: 0.75rem 2rem;
            border-radius: 50px;
            font-weight: 600;
            width: 100%;
            margin-top: 1.5rem;
        }
    </style>
</head>
<body>
    @include('partials.navbar')
    
    <section class="hero-section">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h1 class="display-4 fw-bold mb-3">Fiyatlandırma</h1>
                    <p class="lead">İhtiyacınıza uygun paketi seçin</p>
                </div>
            </div>
        </div>
    </section>
    
    <section class="py-5">
        <div class="container">
            <!-- Sistem Mimarisi Banner -->
            <div class="row mb-5">
                <div class="col-12">
                    <div class="p-4" style="background: linear-gradient(135deg, #10b981 0%, #34d399 100%); border-radius: 15px; color: white;">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="fw-bold mb-2">Premium SaaS Platform Mimarisi</h4>
                                <p class="mb-0">8 entegre büyüme modülü ile işletmenizi büyütün. Sistem mimarimizi detaylı inceleyin.</p>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <a href="{{ route('pages.architecture') }}" class="btn btn-light">
                                    <i class="bi bi-diagram-3"></i> Mimarisi İncele
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row g-4">
                @forelse($packages as $index => $package)
                    @if($package)
                    <div class="col-lg-4">
                        <div class="pricing-card {{ $package->is_popular ? 'featured' : '' }}">
                            <h3 class="mb-3">{{ $package->name }}</h3>
                            <div class="mb-4">
                                @if($package->price > 0)
                                    <span class="price">₺{{ number_format($package->price, 0, ',', '.') }}</span>
                                    <span class="price-period">/{{ $package->price_period === 'monthly' ? 'ay' : 'yıl' }}</span>
                                @else
                                    <span class="price">Özel</span>
                                    <span class="price-period">Fiyat</span>
                                @endif
                            </div>
                            @if($package->description)
                                <p class="text-muted mb-3">{{ $package->description }}</p>
                            @endif
                            <ul class="feature-list">
                                @foreach($package->packageFeatures ?? [] as $feature)
                                    @if($feature->is_included)
                                        <li><i class="bi bi-check-circle-fill"></i> {{ $feature->feature_name }}</li>
                                    @endif
                                @endforeach
                            </ul>
                            @if($package->price > 0)
                                <a href="{{ route('pages.register') }}" class="btn btn-pricing">Başvur</a>
                            @else
                                <a href="{{ route('pages.contact') }}" class="btn btn-pricing">İletişime Geç</a>
                            @endif
                        </div>
                    </div>
                    @endif
                @empty
                    <div class="col-12 text-center py-5">
                        <p class="text-muted">Paketler yükleniyor...</p>
                    </div>
                @endforelse
            </div>
        </div>
    </section>
    
    @include('partials.footer')
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

