<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gizlilik Politikası - Salonay</title>
    <meta name="description" content="Salonay gizlilik politikası. Kişisel verilerinizin nasıl toplandığı, kullanıldığı ve korunduğu hakkında bilgi edinin.">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ url('/gizlilik-politikasi') }}">
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Inter', sans-serif; background: #f8fafc; }
        .page-header { background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 60px 0; color: white; }
        .content-section { padding: 60px 0; }
        .content-card { background: white; border-radius: 15px; padding: 40px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        h2 { color: #10b981; margin-top: 30px; }
        .footer { background: #1e293b; color: white; padding: 40px 0; }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="page-header">
        <div class="container">
            <nav class="mb-4">
                <a href="{{ url('/') }}" class="text-white text-decoration-none">
                    <i class="bi bi-arrow-left me-2"></i>Ana Sayfa
                </a>
            </nav>
            <h1><i class="bi bi-shield-lock me-2"></i>Gizlilik Politikası</h1>
            <p class="mb-0 opacity-75">Son güncelleme: {{ date('d.m.Y') }}</p>
        </div>
    </header>
    
    <!-- Content -->
    <section class="content-section">
        <div class="container">
            <div class="content-card">
                <p class="lead">Salonay olarak, kullanıcılarımızın gizliliğine büyük önem veriyoruz. Bu Gizlilik Politikası, hizmetlerimizi kullanırken kişisel bilgilerinizi nasıl topladığımızı, kullandığımızı ve koruduğumuzu açıklamaktadır.</p>
                
                <h2><i class="bi bi-collection me-2"></i>1. Toplanan Bilgiler</h2>
                <p>Hizmetlerimizi kullanırken aşağıdaki bilgileri toplayabiliriz:</p>
                <ul>
                    <li><strong>Kimlik Bilgileri:</strong> Ad, soyad, e-posta adresi, telefon numarası</li>
                    <li><strong>İşletme Bilgileri:</strong> Firma adı, adres, vergi numarası</li>
                    <li><strong>Kullanım Verileri:</strong> IP adresi, tarayıcı türü, ziyaret edilen sayfalar, tıklama verileri</li>
                    <li><strong>İşlem Verileri:</strong> Randevu bilgileri, ödeme kayıtları, müşteri verileri</li>
                </ul>
                
                <h2><i class="bi bi-gear me-2"></i>2. Bilgilerin Kullanımı</h2>
                <p>Toplanan bilgiler aşağıdaki amaçlarla kullanılmaktadır:</p>
                <ul>
                    <li>Hizmetlerimizi sunmak ve iyileştirmek</li>
                    <li>Kullanıcı hesaplarını yönetmek</li>
                    <li>Müşteri desteği sağlamak</li>
                    <li>Yasal yükümlülüklerimizi yerine getirmek</li>
                    <li>Güvenlik önlemleri almak</li>
                </ul>
                
                <h2><i class="bi bi-share me-2"></i>3. Bilgi Paylaşımı</h2>
                <p>Kişisel bilgileriniz aşağıdaki durumlar dışında üçüncü taraflarla paylaşılmaz:</p>
                <ul>
                    <li>Açık rızanız olduğunda</li>
                    <li>Yasal zorunluluk durumunda</li>
                    <li>Hizmet sağlayıcılarımızla (veri işleyicileri) sınırlı kapsamda</li>
                </ul>
                
                <h2><i class="bi bi-lock me-2"></i>4. Veri Güvenliği</h2>
                <p>Verilerinizin güvenliği için aşağıdaki önlemleri alıyoruz:</p>
                <ul>
                    <li>SSL/TLS şifreleme</li>
                    <li>Güvenli sunucu altyapısı</li>
                    <li>Düzenli güvenlik denetimleri</li>
                    <li>Erişim kontrolleri ve yetkilendirme</li>
                </ul>
                
                <h2><i class="bi bi-person-check me-2"></i>5. Kullanıcı Hakları</h2>
                <p>KVKK kapsamında aşağıdaki haklara sahipsiniz:</p>
                <ul>
                    <li>Kişisel verilerinizin işlenip işlenmediğini öğrenme</li>
                    <li>İşlenme amacını ve bu amaca uygun kullanılıp kullanılmadığını öğrenme</li>
                    <li>Yurtiçi veya yurtdışında verilerin aktarıldığı üçüncü kişileri bilme</li>
                    <li>Verilerin eksik veya yanlış işlenmesi durumunda düzeltilmesini isteme</li>
                    <li>Verilerin silinmesini veya yok edilmesini isteme</li>
                </ul>
                
                <h2><i class="bi bi-cookie me-2"></i>6. Çerezler</h2>
                <p>Web sitemizde çerezler kullanılmaktadır. Çerezler hakkında detaylı bilgi için <a href="{{ url('/cerez-politikasi') }}">Çerez Politikamızı</a> inceleyebilirsiniz.</p>
                
                <h2><i class="bi bi-envelope me-2"></i>7. İletişim</h2>
                <p>Gizlilik politikamız hakkında sorularınız için:</p>
                <ul>
                    <li><strong>E-posta:</strong> {{ $settings['email'] ?? 'info@salonay.com' }}</li>
                    <li><strong>Telefon:</strong> {{ $settings['phone'] ?? '0850 811 08 20' }}</li>
                </ul>
            </div>
        </div>
    </section>
    
    <!-- Footer -->
    <footer class="footer">
        <div class="container text-center">
            <p class="mb-0">&copy; {{ date('Y') }} Salonay. Tüm hakları saklıdır.</p>
        </div>
    </footer>
</body>
</html>


