<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Satın Alma Sözleşmesi - Salonay</title>
    <meta name="description" content="Salonay satın alma sözleşmesi ve mesafeli satış sözleşmesi şartları.">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ url('/satin-alma-sozlesmesi') }}">
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Inter', sans-serif; background: #f8fafc; }
        .page-header { background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); padding: 60px 0; color: white; }
        .content-section { padding: 60px 0; }
        .content-card { background: white; border-radius: 15px; padding: 40px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        h2 { color: #ec4899; margin-top: 30px; }
        .footer { background: #1e293b; color: white; padding: 40px 0; }
    </style>
</head>
<body>
    <header class="page-header">
        <div class="container">
            <nav class="mb-4">
                <a href="{{ url('/') }}" class="text-white text-decoration-none">
                    <i class="bi bi-arrow-left me-2"></i>Ana Sayfa
                </a>
            </nav>
            <h1><i class="bi bi-file-earmark-text me-2"></i>Satın Alma Sözleşmesi</h1>
            <p class="mb-0 opacity-75">Mesafeli Satış Sözleşmesi</p>
        </div>
    </header>
    
    <section class="content-section">
        <div class="container">
            <div class="content-card">
                <p class="lead">Bu sözleşme, Salonay platformu üzerinden yapılan tüm satın alma işlemlerine uygulanır.</p>
                
                <h2><i class="bi bi-1-circle me-2"></i>1. Taraflar</h2>
                <p><strong>Satıcı:</strong> Salonay</p>
                <p><strong>Alıcı:</strong> Platform üzerinden hizmet satın alan gerçek veya tüzel kişi</p>
                
                <h2><i class="bi bi-2-circle me-2"></i>2. Konu</h2>
                <p>Bu sözleşme, Salonay platformu üzerinden satın alınan yazılım hizmeti, paket abonelikleri ve SMS paketleri gibi dijital hizmetlerin satışına ilişkindir.</p>
                
                <h2><i class="bi bi-3-circle me-2"></i>3. Hizmetin Tanımı</h2>
                <p>Salonay, güzellik salonları ve benzeri işletmeler için randevu yönetim sistemi sunmaktadır. Hizmet kapsamı:</p>
                <ul>
                    <li>Online randevu yönetimi</li>
                    <li>Müşteri yönetimi</li>
                    <li>Personel ve hizmet yönetimi</li>
                    <li>Muhasebe ve kasa takibi</li>
                    <li>SMS bildirimleri</li>
                    <li>Raporlama ve analiz</li>
                </ul>
                
                <h2><i class="bi bi-4-circle me-2"></i>4. Fiyat ve Ödeme</h2>
                <p>Hizmet fiyatları platform üzerinde belirtilmiştir. Ödemeler aşağıdaki yöntemlerle yapılabilir:</p>
                <ul>
                    <li>Kredi kartı ile ödeme</li>
                    <li>Banka kartı ile ödeme</li>
                    <li>Diğer ödeme yöntemleri (platform tarafından belirlenir)</li>
                </ul>
                <p>Tüm fiyatlar KDV dahildir. Ödeme işlemi tamamlandıktan sonra hizmet aktif hale gelir.</p>
                <p><strong>Deneme Süresi:</strong> Yeni hesaplar 14 gün ücretsiz deneme hakkına sahiptir. Bu süre sonunda kullanımın devamı için paket seçimi yapılması veya kupon kodu kullanılması gerekir; güncel paket ücretleri geçerlidir.</p>
                
                <h2><i class="bi bi-5-circle me-2"></i>5. Cayma Hakkı</h2>
                <p>Mesafeli Satışlar Yönetmeliği uyarınca, dijital içeriklerin teslim edilmesi ve tüketicinin onayı ile başlaması halinde cayma hakkı kullanılamaz. Ancak:</p>
                <ul>
                    <li>Hizmet başlamadan önce cayma hakkı kullanılabilir</li>
                    <li>Cayma talebi 14 gün içinde yapılmalıdır</li>
                    <li>İade işlemi 14 iş günü içinde tamamlanır</li>
                </ul>
                
                <h2><i class="bi bi-6-circle me-2"></i>6. Hizmetin Başlaması ve Süresi</h2>
                <p>Ödeme tamamlandıktan sonra hizmet anında aktif hale gelir. Abonelik paketleri için:</p>
                <ul>
                    <li>Aylık paketler: Ödeme tarihinden itibaren 30 gün</li>
                    <li>Yıllık paketler: Ödeme tarihinden itibaren 365 gün</li>
                    <li>Paket süresi bitmeden yenileme yapılabilir</li>
                </ul>
                
                <h2><i class="bi bi-7-circle me-2"></i>7. Sorumluluklar</h2>
                <p><strong>Satıcı Sorumlulukları:</strong></p>
                <ul>
                    <li>Hizmetin kesintisiz sunulması için gerekli teknik altyapıyı sağlamak</li>
                    <li>Kullanıcı verilerinin güvenliğini sağlamak</li>
                    <li>Hizmet kalitesini korumak</li>
                </ul>
                <p><strong>Alıcı Sorumlulukları:</strong></p>
                <ul>
                    <li>Hesap bilgilerinin güvenliğini sağlamak</li>
                    <li>Hizmeti yasalara uygun kullanmak</li>
                    <li>Ödeme yükümlülüklerini yerine getirmek</li>
                </ul>
                
                <h2><i class="bi bi-8-circle me-2"></i>8. Fesih</h2>
                <p>Her iki taraf da aşağıdaki durumlarda sözleşmeyi feshedebilir:</p>
                <ul>
                    <li>Ödeme yapılmaması durumunda hizmet otomatik olarak durdurulur</li>
                    <li>Yasalara aykırı kullanım durumunda hizmet derhal sonlandırılır</li>
                    <li>Kullanıcı istediği zaman aboneliği iptal edebilir</li>
                </ul>
                
                <h2><i class="bi bi-9-circle me-2"></i>9. İletişim</h2>
                <p>Satın alma sözleşmesi ile ilgili sorularınız için:</p>
                <ul>
                    <li><strong>E-posta:</strong> {{ $settings['email'] ?? 'info@salonay.com' }}</li>
                    <li><strong>Telefon:</strong> {{ $settings['phone'] ?? '0850 811 08 20' }}</li>
                </ul>
                
                <h2><i class="bi bi-10-circle me-2"></i>10. Uygulanacak Hukuk</h2>
                <p>Bu sözleşme Türkiye Cumhuriyeti yasalarına tabidir. Uyuşmazlıklar İstanbul mahkemelerinde çözülecektir.</p>
            </div>
        </div>
    </section>
    
    <footer class="footer">
        <div class="container text-center">
            <p class="mb-0">&copy; {{ date('Y') }} Salonay. Tüm hakları saklıdır.</p>
        </div>
    </footer>
</body>
</html>

