<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kayıt Başvurusu - Salonay</title>
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #10b981;
            --gradient: linear-gradient(135deg, #10b981 0%, #34d399 50%, #60a5fa 100%);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            padding-top: 80px;
            background: #f8fafc;
        }
        
        .hero-section {
            background: var(--gradient);
            color: white;
            padding: 3rem 0;
        }
        
        .form-card {
            background: white;
            border-radius: 20px;
            padding: 3rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            margin: -3rem auto 3rem;
            max-width: 800px;
        }
        
        .form-control:focus {
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 0.2rem rgba(16, 185, 129, 0.15);
        }
        
        .btn-submit {
            background: var(--gradient);
            border: none;
            color: white;
            padding: 0.75rem 3rem;
            border-radius: 50px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    @include('partials.navbar')
    
    <section class="hero-section">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h1 class="display-4 fw-bold mb-3">Kayıt Başvurusu</h1>
                    <p class="lead">Güzellik salonu randevu sistemi için başvurun</p>
                </div>
            </div>
        </div>
    </section>
    
    <section class="py-5">
        <div class="container">
            <!-- Sistem Mimarisi Banner -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="p-4" style="background: linear-gradient(135deg, #10b981 0%, #34d399 100%); border-radius: 15px; color: white;">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h5 class="fw-bold mb-2">Premium SaaS Platform Mimarisi</h5>
                                <p class="mb-0 small">8 entegre büyüme modülü ile işletmenizi büyütün.</p>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <a href="{{ route('pages.architecture') }}" class="btn btn-light btn-sm">
                                    <i class="bi bi-diagram-3"></i> Mimarisi İncele
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="form-card">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle"></i> {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                <form method="POST" action="{{ route('pages.application.store') }}">
                    @csrf
                    <h3 class="mb-4">Şirket Bilgileri</h3>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Şirket Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="company_name" value="{{ old('company_name') }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">İletişim Kişisi <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="contact_person" value="{{ old('contact_person') }}" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">E-posta <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" name="email" value="{{ old('email') }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Telefon <span class="text-danger">*</span></label>
                            <input type="tel" class="form-control" name="phone" value="{{ old('phone') }}" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Şehir</label>
                            <input type="text" class="form-control" name="city" value="{{ old('city') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Adres</label>
                            <input type="text" class="form-control" name="address" value="{{ old('address') }}">
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label">Açıklama / Ek Bilgiler</label>
                        <textarea class="form-control" name="description" rows="5" placeholder="İşletmeniz hakkında bilgi verin...">{{ old('description') }}</textarea>
                    </div>
                    
                    <div class="text-center">
                        <button type="submit" class="btn btn-submit">
                            <i class="bi bi-send"></i> Başvuruyu Gönder
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </section>
    
    @include('partials.footer')
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

