<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kullanım Şartları - Salonay</title>
    <meta name="description" content="Salonay kullanım şartları ve koşulları. Hizmetlerimizi kullanmadan önce lütfen bu şartları okuyun.">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ url('/kullanim-sartlari') }}">
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Inter', sans-serif; background: #f8fafc; }
        .page-header { background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 60px 0; color: white; }
        .content-section { padding: 60px 0; }
        .content-card { background: white; border-radius: 15px; padding: 40px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        h2 { color: #10b981; margin-top: 30px; }
        .footer { background: #1e293b; color: white; padding: 40px 0; }
    </style>
</head>
<body>
    <header class="page-header">
        <div class="container">
            <nav class="mb-4">
                <a href="{{ url('/') }}" class="text-white text-decoration-none">
                    <i class="bi bi-arrow-left me-2"></i>Ana Sayfa
                </a>
            </nav>
            <h1><i class="bi bi-file-text me-2"></i>Kullanım Şartları</h1>
            <p class="mb-0 opacity-75">Son güncelleme: {{ date('d.m.Y') }}</p>
        </div>
    </header>
    
    <section class="content-section">
        <div class="container">
            <div class="content-card">
                <p class="lead">Salonay hizmetlerini kullanarak aşağıdaki şartları kabul etmiş sayılırsınız. Lütfen bu şartları dikkatle okuyunuz.</p>
                
                <h2><i class="bi bi-1-circle me-2"></i>1. Genel Hükümler</h2>
                <p>Bu kullanım şartları, Salonay ("Şirket") tarafından sunulan salon randevu yönetim sistemi hizmetlerinin kullanımını düzenler. Hizmetlerimizi kullanarak bu şartları kabul etmiş olursunuz.</p>
                
                <h2><i class="bi bi-2-circle me-2"></i>2. Hizmet Tanımı</h2>
                <p>Salonay, işletmelere aşağıdaki hizmetleri sunar:</p>
                <ul>
                    <li>Online randevu yönetimi</li>
                    <li>Müşteri ilişkileri yönetimi (CRM)</li>
                    <li>Muhasebe ve kasa takibi</li>
                    <li>Fatura ve sözleşme oluşturma</li>
                    <li>SMS ve bildirim hizmetleri</li>
                </ul>
                
                <h2><i class="bi bi-3-circle me-2"></i>3. Hesap Güvenliği</h2>
                <p>Kullanıcılar:</p>
                <ul>
                    <li>Hesap bilgilerini gizli tutmakla yükümlüdür</li>
                    <li>Hesabında gerçekleşen tüm işlemlerden sorumludur</li>
                    <li>Şüpheli aktiviteleri derhal bildirmelidir</li>
                </ul>
                
                <h2><i class="bi bi-4-circle me-2"></i>4. Kabul Edilmeyen Kullanımlar</h2>
                <p>Aşağıdaki davranışlar kesinlikle yasaktır:</p>
                <ul>
                    <li>Yasadışı faaliyetler için kullanım</li>
                    <li>Sistemin güvenliğini tehlikeye atacak eylemler</li>
                    <li>Spam veya istenmeyen içerik paylaşımı</li>
                    <li>Üçüncü taraf haklarını ihlal eden kullanım</li>
                </ul>
                
                <h2><i class="bi bi-5-circle me-2"></i>5. Ödeme Koşulları</h2>
                <ul>
                    <li>Ücretli hizmetler için belirlenen tarife geçerlidir</li>
                    <li>Ödemeler zamanında yapılmalıdır</li>
                    <li>Geç ödemelerde hizmet askıya alınabilir</li>
                </ul>
                <p><strong>Deneme Süresi:</strong> Yeni hesaplarda 14 gün ücretsiz deneme süresi tanımlanır. Bu sürenin sonunda hizmet, paket seçimi veya kupon ile devam edebilir; aksi halde o tarihte geçerli paket ücretleri uygulanır.</p>
                
                <h2><i class="bi bi-6-circle me-2"></i>6. Fikri Mülkiyet</h2>
                <p>Salonay'a ait tüm içerik, logo, yazılım ve tasarımlar fikri mülkiyet koruması altındadır. İzinsiz kullanım yasaktır.</p>
                
                <h2><i class="bi bi-7-circle me-2"></i>7. Sorumluluk Sınırı</h2>
                <p>Salonay, hizmet kesintileri veya veri kayıplarından kaynaklanan dolaylı zararlardan sorumlu tutulamaz. Azami sorumluluk, kullanıcının ödediği son 12 aylık ücretle sınırlıdır.</p>
                
                <h2><i class="bi bi-8-circle me-2"></i>8. Fesih</h2>
                <p>Her iki taraf da 30 gün önceden bildirimde bulunarak hizmeti sonlandırabilir. Şartların ihlali durumunda derhal fesih hakkı saklıdır.</p>
                
                <h2><i class="bi bi-9-circle me-2"></i>9. İletişim</h2>
                <p>Sorularınız için:</p>
                <ul>
                    <li><strong>E-posta:</strong> {{ $settings['email'] ?? 'info@salonay.com' }}</li>
                    <li><strong>Telefon:</strong> {{ $settings['phone'] ?? '0850 811 08 20' }}</li>
                </ul>
            </div>
        </div>
    </section>
    
    <footer class="footer">
        <div class="container text-center">
            <p class="mb-0">&copy; {{ date('Y') }} Salonay. Tüm hakları saklıdır.</p>
        </div>
    </footer>
</body>
</html>


