@php
    try {
        $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key');
    } catch (\Exception $e) {
        $settings = collect([]);
    }
    $phone = $settings['phone'] ?? '0850 811 08 20';
    $email = $settings['email'] ?? 'info@salonay.com';
    $companyName = $settings['company_name'] ?? 'Salonay';
    $address = $settings['address'] ?? '';
@endphp
<footer class="footer" style="background: #1e293b; color: white; padding: 60px 0 30px; margin-top: 80px;">
    <div class="container">
        <div class="row">
            <div class="col-md-3 mb-4">
                <div style="display: flex; align-items: center; margin-bottom: 1rem;">
                    <span class="logo-text" style="font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif; font-weight: normal; font-size: 40px; letter-spacing: 2.5px; background: linear-gradient(135deg, #ffffff 0%, #fce7f3 30%, #fbcfe8 60%, #ffffff 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; background-size: 200% 200%; text-shadow: 0 4px 20px rgba(255, 255, 255, 0.4), 0 0 40px rgba(255, 255, 255, 0.2); user-select: none; position: relative; display: inline-flex; align-items: center; animation: logoGradient 3s ease infinite; padding: 6px 16px; border-radius: 14px;">{{ $companyName }}</span>
                </div>
                <p style="color: rgba(255,255,255,0.7);">Modern ve kullanıcı dostu randevu yönetim sistemi ile işletmenizi büyütün.</p>
            </div>
            <div class="col-md-3 mb-4">
                <h5 style="font-weight: 700; margin-bottom: 1.5rem; font-size: 1.1rem; color: white;">ÇÖZÜMLER</h5>
                <a href="{{ route('home') }}#paketler" style="display: block; margin-bottom: 0.75rem; color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Fiyat Paketleri</a>
                <a href="{{ route('home') }}#ozellikler" style="display: block; margin-bottom: 0.75rem; color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Özellikler</a>
                <a href="{{ route('public.salons.index') }}" style="display: block; margin-bottom: 0.75rem; color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Salonlar</a>
            </div>
            <div class="col-md-3 mb-4">
                <h5 style="font-weight: 700; margin-bottom: 1.5rem; font-size: 1.1rem; color: white;">KURUMSAL</h5>
                <a href="{{ route('pages.about') }}" style="display: block; margin-bottom: 0.75rem; color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Hakkımızda</a>
                <a href="{{ route('pages.contact') }}" style="display: block; margin-bottom: 0.75rem; color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">İletişim</a>
            </div>
            <div class="col-md-3 mb-4">
                <h5 style="font-weight: 700; margin-bottom: 1.5rem; font-size: 1.1rem; color: white;">İLETİŞİM</h5>
                <a href="tel:{{ str_replace(' ', '', $phone) }}" style="display: block; margin-bottom: 0.75rem; color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'"><i class="bi bi-telephone me-2"></i> {{ $phone }}</a>
                <a href="mailto:{{ $email }}" style="display: block; margin-bottom: 0.75rem; color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.3s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'"><i class="bi bi-envelope me-2"></i> {{ $email }}</a>
            </div>
        </div>
        <div class="footer-bottom" style="border-top: 1px solid rgba(255,255,255,0.1); padding-top: 2rem; margin-top: 2rem; text-align: center; color: rgba(255,255,255,0.5);">
            <div class="d-flex flex-wrap justify-content-center gap-3 mb-2" style="font-size: 0.9rem;">
                <a href="{{ route('pages.kvkk') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">KVKK</a>
                <span style="color: rgba(255,255,255,0.3);">|</span>
                <a href="{{ route('pages.privacy') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Gizlilik Politikası</a>
                <span style="color: rgba(255,255,255,0.3);">|</span>
                <a href="{{ route('pages.terms') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Kullanım Şartları</a>
                <span style="color: rgba(255,255,255,0.3);">|</span>
                <a href="{{ route('pages.cookies') }}" style="color: rgba(255,255,255,0.7); text-decoration: none; transition: color 0.2s;" onmouseover="this.style.color='white'" onmouseout="this.style.color='rgba(255,255,255,0.7)'">Çerezler</a>
            </div>
            <p class="mb-0">&copy; {{ date('Y') }} {{ $companyName }}. Tüm hakları saklıdır.</p>
        </div>
    </div>
</footer>

