<!-- Yeni Müşteri Modal -->
<div class="modal fade" id="newCustomerModal" tabindex="-1" aria-labelledby="newCustomerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form method="POST" action="{{ route('admin.customers.store') }}" id="quickCustomerForm">
                @csrf
                <input type="hidden" name="redirect_back" value="1">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="newCustomerModalLabel">
                        <i class="bi bi-person-plus"></i> Yeni Müşteri Ekle
                </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
                <div class="modal-body">
                    <div id="customerFormErrors" class="alert alert-danger" style="display: none;"></div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-bold">Ad Soyad <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="customerName" class="form-control" placeholder="Müşteri adı" required>
                        <div class="invalid-feedback"></div>
                                </div>
                                
                    <div class="mb-3">
                        <label class="form-label fw-bold">Telefon <span class="text-danger">*</span></label>
                        <input type="text" name="phone" id="customerPhone" class="form-control" placeholder="05XX XXX XX XX" required>
                        <div class="invalid-feedback"></div>
                                </div>
                                
                    <div class="mb-3">
                        <label class="form-label">E-posta (Opsiyonel)</label>
                        <input type="email" name="email" id="customerEmail" class="form-control" placeholder="email@example.com">
                        <div class="invalid-feedback"></div>
                                </div>
                                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary" id="customerSubmitBtn">
                        <i class="bi bi-check-circle"></i> Kaydet
                            </button>
                        </div>
                </form>
        </div>
    </div>
</div>

<!-- Fatura Ön Gösterim Modal -->
<div class="modal fade" id="invoicePreviewModal" tabindex="-1" aria-labelledby="invoicePreviewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content" style="display: flex; flex-direction: column; max-height: 90vh;">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="invoicePreviewModalLabel">
                    <i class="bi bi-receipt"></i> E-Fatura Ön Gösterim
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="invoicePreviewContent" style="flex: 1 1 auto; overflow-y: auto; max-height: calc(90vh - 160px);">
                <!-- Fatura içeriği buraya yüklenecek -->
            </div>
            <div class="modal-footer" style="flex-shrink: 0; margin-top: auto;">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-success btn-lg" onclick="submitReservation()">
                    <i class="bi bi-check-circle"></i> Onayla ve Kaydet
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Yeni Müşteri Modal -->
<div class="modal fade" id="newCustomerModal" tabindex="-1" aria-labelledby="newCustomerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form method="POST" action="{{ route('admin.customers.store') }}" id="quickCustomerForm">
                @csrf
                <input type="hidden" name="redirect_back" value="1">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="newCustomerModalLabel">
                        <i class="bi bi-person-plus"></i> Yeni Müşteri Ekle
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="customerFormErrors" class="alert alert-danger" style="display: none;"></div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-bold">Ad Soyad <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="customerName" class="form-control" placeholder="Müşteri adı" required>
                        <div class="invalid-feedback"></div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-bold">Telefon <span class="text-danger">*</span></label>
                        <input type="text" name="phone" id="customerPhone" class="form-control" placeholder="05XX XXX XX XX" required>
                        <div class="invalid-feedback"></div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">E-posta (Opsiyonel)</label>
                        <input type="email" name="email" id="customerEmail" class="form-control" placeholder="email@example.com">
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary" id="customerSubmitBtn">
                        <i class="bi bi-check-circle"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Yeni Salon Modal -->
<div class="modal fade" id="newSalonModal" tabindex="-1" aria-labelledby="newSalonModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title text-dark" id="newSalonModalLabel">
                    <i class="bi bi-building"></i> Yeni Salon Ekle
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="salonForm" method="POST" action="{{ route('admin.salons.store') }}">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Salon Adı <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kapasite</label>
                        <input type="number" name="capacity" class="form-control" min="1">
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_active" id="salonIsActive" value="1" checked>
                        <label class="form-check-label" for="salonIsActive">Aktif</label>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-primary" onclick="submitSalonForm()">Kaydet</button>
            </div>
        </div>
    </div>
</div>

<!-- Gelir Ekleme Modal -->
<div class="modal fade" id="incomeModal" tabindex="-1" aria-labelledby="incomeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="incomeModalLabel">
                    <i class="bi bi-arrow-down-circle"></i> Gelir Ekle
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="incomeForm" method="POST" action="{{ route('admin.accounting.cashbox.income.store') }}">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Tutar (₺) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" class="form-control" required min="0">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" required value="{{ date('Y-m-d') }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Açıklama</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Müşteri</label>
                        <select name="customer_id" class="form-select">
                            <option value="">Müşteri Seçin</option>
                            @if(isset($customers))
                                @foreach($customers as $customer)
                                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Randevu</label>
                        <select name="reservation_id" class="form-select">
                            <option value="">Randevu Seçin</option>
                            @if(isset($appointments))
                                @foreach($appointments as $reservation)
                                    <option value="{{ $reservation->id }}">{{ $reservation->code ?? 'Randevu #' . $reservation->id }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-danger" onclick="document.getElementById('incomeForm').submit();">Kaydet</button>
            </div>
        </div>
    </div>
</div>

<!-- Gider Ekleme Modal -->
<div class="modal fade" id="expenseModal" tabindex="-1" aria-labelledby="expenseModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="expenseModalLabel">
                    <i class="bi bi-arrow-up-circle"></i> Gider Ekle
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="expenseForm" method="POST" action="{{ route('admin.accounting.cashbox.expense.store') }}">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Tutar (₺) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" class="form-control" required min="0">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" required value="{{ date('Y-m-d') }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Açıklama</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Müşteri</label>
                        <select name="customer_id" class="form-select">
                            <option value="">Müşteri Seçin</option>
                            @if(isset($customers))
                                @foreach($customers as $customer)
                                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Randevu</label>
                        <select name="reservation_id" class="form-select">
                            <option value="">Randevu Seçin</option>
                            @if(isset($appointments))
                                @foreach($appointments as $reservation)
                                    <option value="{{ $reservation->id }}">{{ $reservation->code ?? 'Randevu #' . $reservation->id }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-danger" onclick="document.getElementById('expenseForm').submit();">Kaydet</button>
            </div>
        </div>
    </div>
</div>

<script>
// ============================================
// ESKİ SİSTEM KALDIRILDI - YENİ MODAL YUKARIDA
// ============================================

// Dolu olmayan saatleri yükle (eski - kullanılmıyor)
function loadAvailableHours_OLD() {
    const date = document.getElementById('reservationDate')?.value;
    const salonId = document.getElementById('salonSelect')?.value;
    const startSelect = document.getElementById('startTimeSelect');
    const endSelect = document.getElementById('endTimeSelect');
    const busyInfo = document.getElementById('busyHoursInfo');
    const busyText = document.getElementById('busyHoursText');
    
    if (!startSelect || !endSelect) return;
    
    // Tarih veya salon seçilmediyse
    if (!date || !salonId) {
        startSelect.innerHTML = '<option value="">Önce tarih ve salon seçin</option>';
        endSelect.innerHTML = '<option value="">Önce başlangıç saati seçin</option>';
        if (busyInfo) busyInfo.style.display = 'none';
        return;
    }
    
    // Yükleniyor göster
    startSelect.innerHTML = '<option value="">Yükleniyor...</option>';
    if (busyInfo) {
        busyInfo.style.display = 'block';
        busyText.innerHTML = '<i class="bi bi-hourglass-split"></i> Müsait saatler kontrol ediliyor...';
    }
    
    // API'den dolu saatleri al
    fetch(`/admin/randevular/check-availability?date=${date}&salon_id=${salonId}`, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        const busyRanges = data.busy_hours || [];
        
        // Tüm saatleri oluştur (08:00 - 23:30)
        const allHours = [];
        for (let hour = 8; hour < 24; hour++) {
            for (let minute = 0; minute < 60; minute += 30) {
                allHours.push(String(hour).padStart(2, '0') + ':' + String(minute).padStart(2, '0'));
            }
        }
        
        // Dolu saatleri işaretle
        const busyHours = new Set();
        busyRanges.forEach(range => {
            const start = range.start_time.substring(0, 5);
            const end = range.end_time.substring(0, 5);
            allHours.forEach(hour => {
                if (hour >= start && hour < end) {
                    busyHours.add(hour);
                }
            });
        });
        
        // Başlangıç saatlerini doldur (dolu olmayanlar)
        startSelect.innerHTML = '<option value="">Başlangıç Saati Seçin</option>';
        allHours.forEach(hour => {
            const isBusy = busyHours.has(hour);
            const opt = new Option(hour + (isBusy ? ' (DOLU)' : ''), hour);
            if (isBusy) {
                opt.disabled = true;
                opt.style.color = '#dc3545';
            }
            startSelect.add(opt);
        });
        
        // Bitiş saati - başlangıç seçilince doldurulacak
        endSelect.innerHTML = '<option value="">Önce başlangıç saati seçin</option>';
        
        // Dolu saat bilgisini göster
        if (busyInfo && busyText) {
            if (busyRanges.length > 0) {
                const busyList = busyRanges.map(r => r.start_time.substring(0,5) + '-' + r.end_time.substring(0,5)).join(', ');
                busyText.innerHTML = `<strong>Dolu saatler:</strong> ${busyList}`;
                busyInfo.className = 'alert alert-warning mb-3';
            } else {
                busyText.innerHTML = '<i class="bi bi-check-circle"></i> Tüm saatler müsait!';
                busyInfo.className = 'alert alert-success mb-3';
            }
            busyInfo.style.display = 'block';
        }
        
        // Başlangıç saati değiştiğinde bitiş saatlerini güncelle
        startSelect.onchange = function() {
            updateEndTimeOptions(this.value, allHours, busyHours);
        };
    })
    .catch(error => {
        console.error('Saat kontrolü hatası:', error);
        // Hata durumunda tüm saatleri göster
        fillAllHours(startSelect, endSelect);
        if (busyInfo) busyInfo.style.display = 'none';
    });
}

// Bitiş saatlerini güncelle
function updateEndTimeOptions(startTime, allHours, busyHours) {
    const endSelect = document.getElementById('endTimeSelect');
    if (!endSelect || !startTime) {
        endSelect.innerHTML = '<option value="">Önce başlangıç saati seçin</option>';
        return;
    }
    
    endSelect.innerHTML = '<option value="">Bitiş Saati Seçin</option>';
    
    let canAdd = false;
    allHours.forEach(hour => {
        if (hour > startTime) {
            canAdd = true;
        }
        if (canAdd) {
            const isBusy = busyHours.has(hour);
            const opt = new Option(hour + (isBusy ? ' (DOLU)' : ''), hour);
            if (isBusy) {
                opt.disabled = true;
                opt.style.color = '#dc3545';
            }
            endSelect.add(opt);
        }
    });
}

// Tüm saatleri doldur (fallback)
function fillAllHours(startSelect, endSelect) {
    startSelect.innerHTML = '<option value="">Başlangıç Saati Seçin</option>';
    endSelect.innerHTML = '<option value="">Bitiş Saati Seçin</option>';
    
    for (let hour = 8; hour < 24; hour++) {
        for (let minute = 0; minute < 60; minute += 30) {
            const time = String(hour).padStart(2, '0') + ':' + String(minute).padStart(2, '0');
            startSelect.add(new Option(time, time));
            endSelect.add(new Option(time, time));
        }
    }
    
    startSelect.onchange = function() {
        const startVal = this.value;
        Array.from(endSelect.options).forEach((opt, idx) => {
            if (idx === 0) return;
            opt.disabled = opt.value <= startVal;
        });
    };
}
    
    fetch('{{ route("admin.reservations.check-times") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': token,
            'Accept': 'application/json'
        },
        body: JSON.stringify({ date, salon_id: salonId })
    })
    .then(r => r.json())
    .then(data => {
        const booked = data.booked_slots || [];
        [startSelect, endSelect].forEach(select => {
            Array.from(select.options).forEach(opt => {
                if (opt.value && booked.includes(opt.value)) {
                    opt.disabled = true;
                    opt.style.color = '#dc3545';
                    if (!opt.textContent.includes('(Dolu)')) {
                        opt.textContent = opt.value + ' (Dolu)';
                    }
                } else if (opt.value) {
                    opt.disabled = false;
                    opt.style.color = '';
                    opt.textContent = opt.textContent.replace(' (Dolu)', '');
                }
            });
        });
    })
    .catch(() => {});
}

// Yemek satırı ekle
function addMealRow() {
    mealRowCount++;
    const tbody = document.getElementById('mealsTableBody');
    const row = document.createElement('tr');
    row.id = `mealRow${mealRowCount}`;
    row.innerHTML = `
        <td><input type="text" name="meals[${mealRowCount}][name]" class="form-control meal-name" placeholder="Yemek adı yazın"></td>
        <td><input type="number" name="meals[${mealRowCount}][quantity]" class="form-control meal-quantity" min="1" value="1"></td>
        <td><input type="number" step="0.01" name="meals[${mealRowCount}][price]" class="form-control meal-price" min="0" value="0" placeholder="0.00"></td>
        <td><input type="text" class="form-control meal-total" readonly value="0.00" style="background: #f8f9fa;"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeMealRow(${mealRowCount})"><i class="bi bi-trash"></i></button></td>
    `;
    tbody.appendChild(row);
    
    // Event listener'ları ekle
    const qty = row.querySelector('.meal-quantity');
    const price = row.querySelector('.meal-price');
    qty.oninput = calculateTotal;
    qty.onchange = calculateTotal;
    price.oninput = calculateTotal;
    price.onchange = calculateTotal;
    
    calculateTotal();
}

// Yemek satırı sil
function removeMealRow(id) {
    const row = document.getElementById(`mealRow${id}`);
    if (row) {
        row.remove();
        
        // Eğer hiç satır kalmadıysa yeni bir boş satır ekle
        const tbody = document.getElementById('mealsTableBody');
        if (tbody && tbody.children.length === 0) {
            mealRowCount = 0;
            const newRow = document.createElement('tr');
            newRow.id = 'mealRow0';
            newRow.innerHTML = `
                <td><input type="text" name="meals[0][name]" class="form-control meal-name" placeholder="Yemek adı yazın"></td>
                <td><input type="number" name="meals[0][quantity]" class="form-control meal-quantity" min="1" value="1"></td>
                <td><input type="number" step="0.01" name="meals[0][price]" class="form-control meal-price" min="0" value="0" placeholder="0.00"></td>
                <td><input type="text" class="form-control meal-total" readonly value="0.00" style="background: #f8f9fa;"></td>
                <td><button type="button" class="btn btn-danger btn-sm" onclick="removeMealRow(0)"><i class="bi bi-trash"></i></button></td>
            `;
            tbody.appendChild(newRow);
            
            // Event listener'ları ekle
            const qty = newRow.querySelector('.meal-quantity');
            const price = newRow.querySelector('.meal-price');
            if (qty) { qty.oninput = calculateTotal; qty.onchange = calculateTotal; }
            if (price) { price.oninput = calculateTotal; price.onchange = calculateTotal; }
        }
        
        calculateTotal();
    }
}

// Ekstra satırı ekle
function addExtraRow() {
    extraRowCount++;
    const tbody = document.getElementById('extrasTableBody');
    const row = document.createElement('tr');
    row.id = `extraRow${extraRowCount}`;
    row.innerHTML = `
        <td><input type="text" name="extras[${extraRowCount}][name]" class="form-control extra-name" placeholder="Ekstra adı yazın"></td>
        <td><input type="number" step="0.01" name="extras[${extraRowCount}][price]" class="form-control extra-price" min="0" value="0" placeholder="0.00"></td>
        <td><input type="text" class="form-control extra-total" readonly value="0.00" style="background: #f8f9fa;"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeExtraRow(${extraRowCount})"><i class="bi bi-trash"></i></button></td>
    `;
    tbody.appendChild(row);
    
    // Event listener ekle
    const price = row.querySelector('.extra-price');
    price.oninput = calculateTotal;
    price.onchange = calculateTotal;
    
    calculateTotal();
}

// Ekstra satırı sil
function removeExtraRow(id) {
    const row = document.getElementById(`extraRow${id}`);
    if (row) {
        row.remove();
        
        // Eğer hiç satır kalmadıysa yeni bir boş satır ekle
        const tbody = document.getElementById('extrasTableBody');
        if (tbody && tbody.children.length === 0) {
            extraRowCount = 0;
            const newRow = document.createElement('tr');
            newRow.id = 'extraRow0';
            newRow.innerHTML = `
                <td><input type="text" name="extras[0][name]" class="form-control extra-name" placeholder="Ekstra adı yazın"></td>
                <td><input type="number" step="0.01" name="extras[0][price]" class="form-control extra-price" min="0" value="0" placeholder="0.00"></td>
                <td><input type="text" class="form-control extra-total" readonly value="0.00" style="background: #f8f9fa;"></td>
                <td><button type="button" class="btn btn-danger btn-sm" onclick="removeExtraRow(0)"><i class="bi bi-trash"></i></button></td>
            `;
            tbody.appendChild(newRow);
            
            // Event listener ekle
            const price = newRow.querySelector('.extra-price');
            if (price) { price.oninput = calculateTotal; price.onchange = calculateTotal; }
        }
        
        calculateTotal();
    }
}

// Global fiyat formatlama fonksiyonu (binlik ayırıcı nokta, ondalık virgül)
function formatPrice(amount) {
    const parts = parseFloat(amount || 0).toFixed(2).split('.');
    const integerPart = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    return integerPart + ',' + parts[1];
}

// Toplam hesapla
function calculateTotal() {
    const reservationPrice = parseFloat(document.getElementById('reservationPrice')?.value || 0);
    const organizationPrice = parseFloat(document.getElementById('organizationPrice')?.value || 0);
    const depositPaid = parseFloat(document.getElementById('depositPaid')?.value || 0);
    
    // Yemek toplamı
    let mealTotal = 0;
    document.querySelectorAll('#mealsTableBody tr').forEach(row => {
        const qty = parseFloat(row.querySelector('.meal-quantity')?.value || 0);
        const price = parseFloat(row.querySelector('.meal-price')?.value || 0);
        const total = qty * price;
        mealTotal += total;
        
        const totalInput = row.querySelector('.meal-total');
        if (totalInput) totalInput.value = total.toFixed(2);
    });
    
    // Ekstra toplamı
    let extraTotal = 0;
    document.querySelectorAll('#extrasTableBody tr').forEach(row => {
        const price = parseFloat(row.querySelector('.extra-price')?.value || 0);
        extraTotal += price;
        
        const totalInput = row.querySelector('.extra-total');
        if (totalInput) totalInput.value = price.toFixed(2);
    });
    
    // Genel toplam
    const grandTotal = reservationPrice + mealTotal + organizationPrice + extraTotal;
    const remaining = grandTotal - depositPaid;
    
    // Fiyat formatla (binlik ayırıcı nokta, ondalık virgül)
    function formatPrice(amount) {
        const parts = amount.toFixed(2).split('.');
        const integerPart = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        return integerPart + ',' + parts[1];
    }
    
    // Güncelle
    document.getElementById('displayReservationPrice').textContent = formatPrice(reservationPrice);
    document.getElementById('displayMealTotal').textContent = formatPrice(mealTotal);
    document.getElementById('displayOrganizationPrice').textContent = formatPrice(organizationPrice);
    document.getElementById('displayExtraTotal').textContent = formatPrice(extraTotal);
    document.getElementById('displayTotalPrice').textContent = formatPrice(grandTotal);
    document.getElementById('displayDepositPaid').textContent = formatPrice(depositPaid);
    
    const remainingEl = document.getElementById('remainingAmount');
    if (remainingEl) {
        remainingEl.textContent = formatPrice(remaining);
        remainingEl.className = remaining < 0 ? 'text-danger' : 'text-success';
    }
}

// Event listener'ları ekle
function attachEventListeners() {
    document.getElementById('reservationPrice').oninput = calculateTotal;
    document.getElementById('reservationPrice').onchange = calculateTotal;
    document.getElementById('organizationPrice').oninput = calculateTotal;
    document.getElementById('organizationPrice').onchange = calculateTotal;
    document.getElementById('depositPaid').oninput = calculateTotal;
    document.getElementById('depositPaid').onchange = calculateTotal;
    
    document.getElementById('reservationDate').onchange = loadAvailableHours;
    document.getElementById('salonSelect').onchange = loadAvailableHours;
    
    // İlk yemek satırı için event listener
    const firstMealRow = document.querySelector('#mealRow0');
    if (firstMealRow) {
        const qty = firstMealRow.querySelector('.meal-quantity');
        const price = firstMealRow.querySelector('.meal-price');
        if (qty) { qty.oninput = calculateTotal; qty.onchange = calculateTotal; }
        if (price) { price.oninput = calculateTotal; price.onchange = calculateTotal; }
    }
    
    // İlk ekstra satırı için event listener
    const firstExtraRow = document.querySelector('#extraRow0');
    if (firstExtraRow) {
        const price = firstExtraRow.querySelector('.extra-price');
        if (price) { price.oninput = calculateTotal; price.onchange = calculateTotal; }
    }
}

// Silme butonları için event delegation
function setupDeleteButtons() {
    // Yemek satırları için silme butonları
    const mealsTableBody = document.getElementById('mealsTableBody');
    if (mealsTableBody) {
        mealsTableBody.addEventListener('click', function(e) {
            if (e.target.closest('.btn-danger') && e.target.closest('tr')) {
                const row = e.target.closest('tr');
                const rowId = row.id;
                const match = rowId.match(/mealRow(\d+)/);
                if (match) {
                    const id = parseInt(match[1]);
                    removeMealRow(id);
                }
            }
        });
    }
    
    // Ekstra satırları için silme butonları
    const extrasTableBody = document.getElementById('extrasTableBody');
    if (extrasTableBody) {
        extrasTableBody.addEventListener('click', function(e) {
            if (e.target.closest('.btn-danger') && e.target.closest('tr')) {
                const row = e.target.closest('tr');
                const rowId = row.id;
                const match = rowId.match(/extraRow(\d+)/);
                if (match) {
                    const id = parseInt(match[1]);
                    removeExtraRow(id);
                }
            }
        });
    }
}

// Onayla ve Faturalandır
function confirmAndInvoice() {
    const form = document.getElementById('reservationForm');
    
    // Müşteri seçilmiş mi kontrol et
    const customerId = document.getElementById('selectedCustomerId')?.value;
    if (!customerId) {
        alert('Lütfen bir müşteri seçin veya yeni müşteri ekleyin.');
        return;
    }
    
    // Salon seçilmiş mi kontrol et
    const salonId = form.querySelector('select[name="salon_id"]')?.value;
    if (!salonId) {
        alert('Lütfen bir salon seçin.');
        return;
    }
    
    // Tarih seçilmiş mi kontrol et
    const date = document.getElementById('reservationDate')?.value;
    if (!date) {
        alert('Lütfen tarih seçin.');
        return;
    }
    
    // Fatura verilerini topla
    const selectedCustomerDisplay = document.getElementById('selectedCustomerDisplay');
    const customerName = selectedCustomerDisplay && selectedCustomerDisplay.style.display !== 'none' 
        ? document.getElementById('selectedCustomerName')?.textContent || ''
        : document.getElementById('customerSelect').options[document.getElementById('customerSelect').selectedIndex]?.text || '';
    const salonName = document.getElementById('salonSelect').options[document.getElementById('salonSelect').selectedIndex]?.text || '';
    const date = document.getElementById('reservationDate').value;
    const startTime = document.getElementById('startTimeSelect').value;
    const endTime = document.getElementById('endTimeSelect').value;
    
    const reservationPrice = parseFloat(document.getElementById('reservationPrice').value || 0);
    const organizationPrice = parseFloat(document.getElementById('organizationPrice').value || 0);
    const depositPaid = parseFloat(document.getElementById('depositPaid').value || 0);
    
    // Yemekler
    const meals = [];
    document.querySelectorAll('#mealsTableBody tr').forEach(row => {
        const name = row.querySelector('.meal-name')?.value?.trim();
        const qty = parseFloat(row.querySelector('.meal-quantity')?.value || 0);
        const price = parseFloat(row.querySelector('.meal-price')?.value || 0);
        if (name && qty && price) {
            meals.push({ name, quantity: qty, price, total: qty * price });
        }
    });
    
    // Ekstralar
    const extras = [];
    document.querySelectorAll('#extrasTableBody tr').forEach(row => {
        const name = row.querySelector('.extra-name')?.value?.trim();
        const price = parseFloat(row.querySelector('.extra-price')?.value || 0);
        if (name && price) {
            extras.push({ name, price });
        }
    });
    
    const mealTotal = meals.reduce((sum, m) => sum + m.total, 0);
    const extraTotal = extras.reduce((sum, e) => sum + e.price, 0);
    const grandTotal = reservationPrice + mealTotal + organizationPrice + extraTotal;
    const remaining = grandTotal - depositPaid;
    
    // Fatura HTML'i
    let itemsHtml = '';
    let itemNo = 0;
    
    if (reservationPrice > 0) {
        itemsHtml += `<tr><td>${++itemNo}</td><td>Randevu Ücreti</td><td>-</td><td>${reservationPrice.toFixed(2)}</td><td>${reservationPrice.toFixed(2)}</td></tr>`;
    }
    
    meals.forEach(meal => {
        itemsHtml += `<tr><td>${++itemNo}</td><td>${meal.name}</td><td>${meal.quantity} Adet</td><td>${formatPrice(meal.price)}</td><td>${formatPrice(meal.total)}</td></tr>`;
    });
    
    if (organizationPrice > 0) {
        itemsHtml += `<tr><td>${++itemNo}</td><td>Organizasyon</td><td>-</td><td>${formatPrice(organizationPrice)}</td><td>${formatPrice(organizationPrice)}</td></tr>`;
    }
    
    extras.forEach(extra => {
        itemsHtml += `<tr><td>${++itemNo}</td><td>${extra.name}</td><td>-</td><td>${formatPrice(extra.price)}</td><td>${formatPrice(extra.price)}</td></tr>`;
    });
    
    const invoiceHtml = `
        <div class="p-4" style="background: white; font-family: Arial, sans-serif;">
            <div class="text-center mb-4 border-bottom pb-3">
                <h3 class="fw-bold text-primary mb-2">E-FATURA</h3>
                <div class="text-muted">
                    <strong>Müşteri:</strong> ${customerName}<br>
                    <strong>Salon:</strong> ${salonName}<br>
                    <strong>Tarih:</strong> ${date} | <strong>Saat:</strong> ${startTime} - ${endTime}
                </div>
            </div>
            
            <table class="table table-bordered">
                <thead class="table-light">
                    <tr>
                        <th style="width: 8%;">#</th>
                        <th style="width: 40%;">Açıklama</th>
                        <th style="width: 15%;">Miktar</th>
                        <th style="width: 18%;">Birim Fiyat (₺)</th>
                        <th style="width: 19%;">Tutar (₺)</th>
                    </tr>
                </thead>
                <tbody>
                    ${itemsHtml || '<tr><td colspan="5" class="text-center text-muted">Yemek veya ekstra bulunamadı</td></tr>'}
                </tbody>
            </table>
            
            <div class="row mt-4">
                <div class="col-md-6"></div>
                <div class="col-md-6">
                    <div class="bg-light p-3 rounded border">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Ara Toplam:</span>
                            <span>${formatPrice(grandTotal)} ₺</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>KDV:</span>
                            <span>0.00 ₺</span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between mb-2">
                            <strong>GENEL TOPLAM:</strong>
                            <strong class="text-primary" style="font-size: 20px;">${formatPrice(grandTotal)} ₺</strong>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Alınan Kapora:</span>
                            <span class="text-success">${formatPrice(depositPaid)} ₺</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <strong>KALAN ÖDEME:</strong>
                            <strong class="${remaining < 0 ? 'text-danger' : 'text-success'}" style="font-size: 18px;">${formatPrice(remaining)} ₺</strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    document.getElementById('invoicePreviewContent').innerHTML = invoiceHtml;
    const invoiceModal = new bootstrap.Modal(document.getElementById('invoicePreviewModal'));
    invoiceModal.show();
}

// Randevuu kaydet
function submitReservation() {
    const form = document.getElementById('reservationForm');
    
    // Müşteri seçilmiş mi kontrol et
    const customerId = document.getElementById('selectedCustomerId')?.value;
    if (!customerId) {
        alert('Lütfen bir müşteri seçin veya yeni müşteri ekleyin.');
        return;
    }
    
    // Salon seçilmiş mi kontrol et
    const salonId = form.querySelector('select[name="salon_id"]')?.value;
    if (!salonId) {
        alert('Lütfen bir salon seçin.');
        return;
    }
    
    // Tarih seçilmiş mi kontrol et
    const date = document.getElementById('reservationDate')?.value;
    if (!date) {
        alert('Lütfen tarih seçin.');
        return;
    }
    
    // Yemek ve ekstra verilerini notes'a ekle
    const notesData = {};
    const meals = [];
    document.querySelectorAll('#mealsTableBody tr').forEach(row => {
        const name = row.querySelector('.meal-name')?.value?.trim();
        const qty = parseInt(row.querySelector('.meal-quantity')?.value || 0);
        const price = parseFloat(row.querySelector('.meal-price')?.value || 0);
        if (name && qty && price) {
            meals.push({ name, quantity: qty, price });
        }
    });
    if (meals.length > 0) notesData.meals = meals;
    
    const organizationPrice = parseFloat(document.getElementById('organizationPrice')?.value || 0);
    if (organizationPrice > 0) notesData.organization_price = organizationPrice;
    
    const extras = [];
    document.querySelectorAll('#extrasTableBody tr').forEach(row => {
        const name = row.querySelector('.extra-name')?.value?.trim();
        const price = parseFloat(row.querySelector('.extra-price')?.value || 0);
        if (name && price > 0) {
            extras.push({ name, price });
        }
    });
    if (extras.length > 0) notesData.extras = extras;
    
    // items_data hidden input'a JSON olarak kaydet (notes'a değil!)
    const itemsDataInput = document.getElementById('itemsData');
    if (itemsDataInput && Object.keys(notesData).length > 0) {
        itemsDataInput.value = JSON.stringify(notesData);
    }
    // Notes textarea'sı kullanıcının yazdığı notlar için kalacak - değiştirme!
    
    // Status ekle
    let statusInput = form.querySelector('input[name="status"]');
    if (!statusInput) {
        statusInput = document.createElement('input');
        statusInput.type = 'hidden';
        statusInput.name = 'status';
        form.appendChild(statusInput);
    }
// Global fonksiyonlar - Yeni Müşteri ve Salon modalleri

window.openNewCustomerModal = function() {
    const modalElement = document.getElementById('newCustomerModal');
    if (modalElement) {
        try {
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } catch (error) {
            console.error('Modal açılırken hata:', error);
            // Fallback: Modal'ı manuel olarak göster
            modalElement.classList.add('show');
            modalElement.style.display = 'block';
            document.body.classList.add('modal-open');
            const backdrop = document.createElement('div');
            backdrop.className = 'modal-backdrop fade show';
            backdrop.id = 'modalBackdrop';
            document.body.appendChild(backdrop);
        }
    } else {
        console.error('newCustomerModal bulunamadı. Modal elementi yüklenmemiş olabilir.');
    }
};

window.openNewSalonModal = function() {
    const modal = new bootstrap.Modal(document.getElementById('newSalonModal'));
    modal.show();
};

window.submitSalonForm = function() {
    const form = document.getElementById('salonForm');
    if (!form.checkValidity()) {
        form.reportValidity();
        return;
    }
    
    const submitBtn = form.querySelector('button[onclick*="submitSalonForm"]');
    if (submitBtn) {
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Kaydediliyor...';
    }
    
    fetch(form.action, {
        method: 'POST',
        body: new FormData(form),
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || document.querySelector('input[name="_token"]')?.value
        }
    })
    .then(response => response.ok ? response.json() : response.json().then(err => Promise.reject(err)))
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById('newSalonModal')).hide();
            form.reset();
            window.location.reload();
        } else {
            alert(data.message || 'Bir hata oluştu.');
            if (submitBtn) {
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'Kaydet';
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Bir hata oluştu. Lütfen tekrar deneyin.');
        if (submitBtn) {
            submitBtn.disabled = false;
            submitBtn.innerHTML = 'Kaydet';
        }
    });
};

// Yeni müşteri formu AJAX ile gönder
document.addEventListener('DOMContentLoaded', function() {
    const quickCustomerForm = document.getElementById('quickCustomerForm');
    if (quickCustomerForm) {
        quickCustomerForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const form = this;
            const submitBtn = form.querySelector('#customerSubmitBtn');
            const errorsDiv = form.querySelector('#customerFormErrors');
            const nameInput = form.querySelector('#customerName');
            const phoneInput = form.querySelector('#customerPhone');
            const emailInput = form.querySelector('#customerEmail');
            
            // Hata mesajlarını temizle
            if (errorsDiv) errorsDiv.style.display = 'none';
            [nameInput, phoneInput, emailInput].forEach(input => {
                if (input) {
                    input.classList.remove('is-invalid');
                    const feedback = input.nextElementSibling;
                    if (feedback && feedback.classList.contains('invalid-feedback')) {
                        feedback.textContent = '';
                    }
                }
            });
            
            
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Kaydediliyor...';
            }
            
            // FormData oluştur
            const formData = new FormData(form);
            
            // AJAX isteği
            fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': formData.get('_token')
                }
            })
            .then(response => {
                return response.json().then(data => {
                    if (!response.ok) {
                        throw { status: response.status, data: data };
                    }
                    return data;
                });
            })
            .then(data => {
                if (data.success) {
                    // Yeni müşteriyi select'lere ekle
                    const customer = data.customer;
                    if (customer) {
                        // Randevu sayfasındaki customerSelect'e ekle (eski)
                        const customerSelect = document.getElementById('customerSelect');
                        if (customerSelect) {
                            const option = document.createElement('option');
                            option.value = customer.id;
                            option.textContent = customer.name + ' - ' + (customer.phone || '');
                            option.selected = true;
                            option.setAttribute('data-phone', customer.phone || '');
                            customerSelect.appendChild(option);
                        }
                        
                        // Randevu oluşturma sayfasındaki customer_id select'ine ekle (create.blade.php)
                        const customerIdSelect = document.getElementById('customer_id');
                        if (customerIdSelect) {
                            // Mevcut seçimi temizle
                            customerIdSelect.value = '';
                            
                            // Yeni müşteriyi ekle
                            const option = document.createElement('option');
                            option.value = customer.id;
                            const displayText = customer.name + (customer.phone ? ' (' + customer.phone + ')' : '');
                            option.textContent = displayText;
                            option.selected = true;
                            option.setAttribute('data-name', customer.name);
                            option.setAttribute('data-phone', customer.phone || '');
                            option.setAttribute('data-email', customer.email || '');
                            customerIdSelect.appendChild(option);
                            
                            // Select'in değişikliğini trigger et
                            customerIdSelect.dispatchEvent(new Event('change', { bubbles: true }));
                        }
                        
                        
                    }
                    
                    // Başarılı - modal'ı kapat
                    const modal = bootstrap.Modal.getInstance(document.getElementById('newCustomerModal'));
                    if (modal) modal.hide();
                    
                    // Toast bildirimi göster
                    if (typeof showToast === 'function') {
                        showToast(data.message || 'Müşteri başarıyla eklendi.', 'success');
                    } else if (typeof showNotification === 'function') {
                        showNotification(data.message || 'Müşteri başarıyla eklendi.', 'success');
                    } else {
                        alert(data.message || 'Müşteri başarıyla eklendi.');
                    }
                    
                    // Formu temizle
                    form.reset();
                    
                    // Randevu oluşturma sayfasında mıyız kontrol et
                    const isReservationCreatePage = window.location.pathname.includes('/randevular/create') || 
                                                   window.location.pathname.includes('/admin/randevular/create') ||
                                                   document.getElementById('reservationForm') !== null;
                    
                    // Eğer randevu oluşturma sayfası açıksa sayfayı yenileme
                    if (!isReservationCreatePage) {
                        const isCustomerIndexPage = window.location.pathname.includes('/musteriler') || 
                                                    window.location.pathname.includes('/admin/musteriler');
                        if (isCustomerIndexPage) {
                            setTimeout(() => {
                                window.location.reload();
                            }, 500);
                        }
                    }
                } else {
                    throw { status: 400, data: data };
                }
            })
            .catch(error => {
                console.error('Müşteri ekleme hatası:', error);
                
                const errorData = error.data || error;
                let errorMessage = 'Müşteri oluşturulurken bir hata oluştu.';
                
                // Validation hatalarını göster
                if (errorData.errors) {
                    const errors = errorData.errors;
                    let errorHtml = '<ul class="mb-0">';
                    
                    Object.keys(errors).forEach(field => {
                        const fieldErrors = Array.isArray(errors[field]) ? errors[field] : [errors[field]];
                        fieldErrors.forEach(err => {
                            errorHtml += `<li>${err}</li>`;
                        });
                        
                        // Input alanlarını işaretle
                        const inputMap = {
                            'name': nameInput,
                            'phone': phoneInput,
                            'email': emailInput
                        };
                        const input = inputMap[field];
                        if (input) {
                            input.classList.add('is-invalid');
                            const feedback = input.nextElementSibling;
                            if (feedback && feedback.classList.contains('invalid-feedback')) {
                                feedback.textContent = fieldErrors[0];
                            }
                        }
                    });
                    
                    errorHtml += '</ul>';
                    if (errorsDiv) {
                        errorsDiv.innerHTML = errorHtml;
                        errorsDiv.style.display = 'block';
                    }
                } else {
                    errorMessage = errorData.message || errorMessage;
                    if (errorsDiv) {
                        errorsDiv.textContent = errorMessage;
                        errorsDiv.style.display = 'block';
                    }
                    
                    // Toast bildirimi göster
                    if (typeof showToast === 'function') {
                        showToast(errorMessage, 'error');
                    } else if (typeof showNotification === 'function') {
                        showNotification(errorMessage, 'error');
                    }
                }
                
                // Butonu tekrar aktif et
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = '<i class="bi bi-check-circle"></i> Kaydet';
                }
            });
        });
    }
});

// Uyumluluk için fonksiyonlar
window.saveNewCustomer = function() {
    const form = document.getElementById('quickCustomerForm');
    if (form) {
        form.dispatchEvent(new Event('submit'));
    }
};
window.submitCustomerForm = window.saveNewCustomer;

function openIncomeExpenseModal() {
    const modal = new bootstrap.Modal(document.getElementById('incomeExpenseModal'));
    modal.show();
}

function openIncomeModal() {
    const parentModal = bootstrap.Modal.getInstance(document.getElementById('incomeExpenseModal'));
    if (parentModal) parentModal.hide();
    const modal = new bootstrap.Modal(document.getElementById('incomeModal'));
    modal.show();
}

function openExpenseModal() {
    const parentModal = bootstrap.Modal.getInstance(document.getElementById('incomeExpenseModal'));
    if (parentModal) parentModal.hide();
    const modal = new bootstrap.Modal(document.getElementById('expenseModal'));
    modal.show();
}

// Toast bildirimi göster
window.showToast = function(message, type = 'info') {
    // Mevcut toast varsa kaldır
    const existingToast = document.querySelector('.custom-toast');
    if (existingToast) existingToast.remove();
    
    const bgColors = {
        'success': 'linear-gradient(135deg, #28a745 0%, #20c997 100%)',
        'error': 'linear-gradient(135deg, #dc3545 0%, #e74c3c 100%)',
        'warning': 'linear-gradient(135deg, #ffc107 0%, #fd7e14 100%)',
        'info': 'linear-gradient(135deg, #17a2b8 0%, #007bff 100%)'
    };
    
    const icons = {
        'success': 'bi-check-circle-fill',
        'error': 'bi-x-circle-fill',
        'warning': 'bi-exclamation-triangle-fill',
        'info': 'bi-info-circle-fill'
    };
    
    const toast = document.createElement('div');
    toast.className = 'custom-toast';
    toast.innerHTML = `<i class="bi ${icons[type] || icons.info} me-2"></i>${message}`;
    toast.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        padding: 15px 25px;
        background: ${bgColors[type] || bgColors.info};
        color: white;
        border-radius: 10px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.3);
        z-index: 999999;
        font-weight: 500;
        animation: slideInRight 0.3s ease;
        max-width: 400px;
    `;
    
    // Animasyon style ekle
    if (!document.getElementById('toastAnimationStyle')) {
        const style = document.createElement('style');
        style.id = 'toastAnimationStyle';
        style.textContent = `
            @keyframes slideInRight {
                from { transform: translateX(100%); opacity: 0; }
                to { transform: translateX(0); opacity: 1; }
            }
            @keyframes slideOutRight {
                from { transform: translateX(0); opacity: 1; }
                to { transform: translateX(100%); opacity: 0; }
            }
        `;
        document.head.appendChild(style);
    }
    
    document.body.appendChild(toast);
    
    // 3 saniye sonra kaldır
    setTimeout(() => {
        toast.style.animation = 'slideOutRight 0.3s ease';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
};

// Müşteri seçimini temizle
window.clearCustomerSelection = function() {
    const selectedCustomerId = document.getElementById('selectedCustomerId');
    const selectedCustomerDisplay = document.getElementById('selectedCustomerDisplay');
    const customerSearchInput = document.getElementById('customerSearchInput');
    
    if (selectedCustomerId) selectedCustomerId.value = '';
    if (selectedCustomerDisplay) selectedCustomerDisplay.style.display = 'none';
    if (customerSearchInput) {
        customerSearchInput.value = '';
        customerSearchInput.style.display = 'block';
        customerSearchInput.focus();
    }
};
</script>

<!-- Silme Onay Modal -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title text-dark" id="deleteConfirmModalLabel">
                    <i class="bi bi-exclamation-triangle"></i> Silme Onayı
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p id="deleteConfirmMessage">Bu kaydı silmek istediğinizden emin misiniz?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <form id="deleteConfirmForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Sil</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(id, name, type = 'customer') {
    const modal = new bootstrap.Modal(document.getElementById('deleteConfirmModal'));
    const form = document.getElementById('deleteConfirmForm');
    const message = document.getElementById('deleteConfirmMessage');
    
    let route = '';
    if (type === 'customer') {
        route = '{{ route("admin.customers.index") }}';
        message.textContent = `"${name}" adlı müşteriyi silmek istediğinizden emin misiniz?`;
        form.action = '{{ route("admin.customers.destroy", ["musteriler" => "__ID__"]) }}'.replace('__ID__', id);
    }
    
    modal.show();
}
</script>

