<nav class="navbar navbar-expand-lg navbar-light" style="background: white; box-shadow: 0 2px 10px rgba(0,0,0,0.1); padding: 0.5rem 0; position: sticky; top: 0; z-index: 1000;">
    <div class="container">
        <a class="navbar-brand" href="{{ route('home') }}" style="display: flex; align-items: center; text-decoration: none;">
            <img src="{{ asset('salonayheaderlogo.png') }}" alt="Salonay" style="height: 50px; width: auto; object-fit: contain;" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-block';">
            <span class="logo-text" style="display: none; font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif; font-weight: normal; font-size: 36px; letter-spacing: 2.5px; background: linear-gradient(135deg, #ec4899 0%, #f472b6 25%, #fbcfe8 50%, #f472b6 75%, #ec4899 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; background-size: 200% 200%; animation: logoGradient 3s ease infinite;">Salonay</span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('home') }}#ozellikler" style="font-weight: 500; color: #1e293b !important; margin: 0 0.5rem; transition: color 0.3s;">Özellikler</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="{{ route('public.salons.index') }}" style="font-weight: 500; color: #ec4899 !important; margin: 0 0.5rem; transition: color 0.3s;">Salonlar</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('home') }}#paketler" style="font-weight: 500; color: #1e293b !important; margin: 0 0.5rem; transition: color 0.3s;">Paketler</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('pages.about') }}" style="font-weight: 500; color: #1e293b !important; margin: 0 0.5rem; transition: color 0.3s;">Hakkımızda</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('pages.contact') }}" style="font-weight: 500; color: #1e293b !important; margin: 0 0.5rem; transition: color 0.3s;">İletişim</a>
                </li>
            </ul>
            <div class="d-flex align-items-center gap-2">
                @php
                    try {
                        $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key');
                    } catch (\Exception $e) {
                        $settings = collect([]);
                    }
                    $phone = $settings['phone'] ?? '0850 811 08 20';
                @endphp
                <span style="color: #1e293b; font-weight: 600; margin-right: 1rem; font-size: 0.875rem;">
                    <i class="bi bi-telephone"></i> {{ $phone }}
                </span>
                @auth
                    <a href="{{ route('admin.dashboard') }}" class="btn" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; color: white; padding: 0.5rem 1.25rem; font-size: 0.9rem; font-weight: 600; border-radius: 8px;">
                        Panel
                    </a>
                @else
                    <a href="{{ route('login') }}" class="btn" style="border: 2px solid #ec4899; color: #ec4899; background: transparent; padding: 0.5rem 1.25rem; font-size: 0.9rem; font-weight: 600; border-radius: 8px;">
                        <i class="bi bi-box-arrow-in-right"></i> Giriş Yap
                    </a>
                    <a href="{{ route('register') }}" class="btn" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; color: white; padding: 0.5rem 1.25rem; font-size: 0.9rem; font-weight: 600; border-radius: 8px;">
                        <i class="bi bi-person-plus"></i> Ücretsiz Deneyin
                    </a>
                @endauth
            </div>
        </div>
    </div>
</nav>

