<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Havale / EFT Ödeme - {{ $package->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        .payment-container {
            max-width: 700px;
            margin: 0 auto;
        }
        .info-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        .bank-info {
            background: linear-gradient(135deg, #fdf2f8 0%, #ffffff 100%);
            border: 2px solid #fbcfe8;
            border-radius: 16px;
            padding: 25px;
            margin: 20px 0;
        }
        .bank-info-item {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #fbcfe8;
        }
        .bank-info-item:last-child {
            border-bottom: none;
        }
        .copy-btn {
            background: #ec4899;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
        }
        .copy-btn:hover {
            background: #be185d;
        }
        .alert-warning {
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
            border: 2px solid #f59e0b;
            border-radius: 12px;
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="info-card text-center">
            <h1 class="mb-3" style="color: #0f172a;">
                <i class="bi bi-bank me-2" style="color: #ec4899;"></i>Havale / EFT Ödeme
            </h1>
            <p class="text-muted mb-4">{{ $package->name }} paketi için ödeme bilgileri</p>
            
            <div class="price-display" style="font-size: 36px; font-weight: 800; color: #ec4899; margin: 20px 0;">
                {{ number_format($package->price, 2, ',', '.') }} ₺
            </div>
        </div>

        <div class="info-card">
            <h4 class="mb-4" style="color: #0f172a;">
                <i class="bi bi-info-circle me-2" style="color: #ec4899;"></i>Ödeme Talimatı
            </h4>
            
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <strong>Önemli:</strong> Havale/EFT yaptıktan sonra "Ödemeyi Yaptım" butonuna tıklayın. Ödemeniz onaylandıktan sonra paketiniz aktif olacaktır.
            </div>

            <div class="bank-info">
                <h5 class="mb-3 fw-bold" style="color: #ec4899;">
                    <i class="bi bi-bank me-2"></i>Banka Bilgileri
                </h5>
                
                <div class="bank-info-item">
                    <span class="fw-bold">Banka Adı:</span>
                    <span id="bankName">Salonay Bankası</span>
                    <button class="copy-btn" onclick="copyToClipboard('bankName')">
                        <i class="bi bi-copy"></i> Kopyala
                    </button>
                </div>
                
                <div class="bank-info-item">
                    <span class="fw-bold">Hesap Adı:</span>
                    <span id="accountName">Salonay Yazılım A.Ş.</span>
                    <button class="copy-btn" onclick="copyToClipboard('accountName')">
                        <i class="bi bi-copy"></i> Kopyala
                    </button>
                </div>
                
                <div class="bank-info-item">
                    <span class="fw-bold">IBAN:</span>
                    <span id="iban">TR00 0000 0000 0000 0000 0000 00</span>
                    <button class="copy-btn" onclick="copyToClipboard('iban')">
                        <i class="bi bi-copy"></i> Kopyala
                    </button>
                </div>
                
                <div class="bank-info-item">
                    <span class="fw-bold">Açıklama:</span>
                    <span id="description">{{ $merchant_oid }}</span>
                    <button class="copy-btn" onclick="copyToClipboard('description')">
                        <i class="bi bi-copy"></i> Kopyala
                    </button>
                </div>
            </div>

            <div class="mt-4">
                <p class="text-muted">
                    <strong>Not:</strong> Havale/EFT yaparken açıklama kısmına <strong>{{ $merchant_oid }}</strong> numarasını mutlaka yazın. 
                    Bu numara olmadan ödemeniz işleme alınamaz.
                </p>
            </div>
        </div>

        <div class="info-card">
            <form action="{{ route('payment.package.bank-transfer.confirm', $package->id) }}" method="POST" id="confirmForm">
                @csrf
                <input type="hidden" name="merchant_oid" value="{{ $merchant_oid }}">
                
                <div class="mb-3">
                    <label class="form-label fw-bold">
                        <i class="bi bi-calendar me-2"></i>Ödeme Tarihi <span class="text-danger">*</span>
                    </label>
                    <input type="date" name="payment_date" class="form-control form-control-lg" value="{{ date('Y-m-d') }}" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">
                        <i class="bi bi-receipt me-2"></i>Dekont/Fiş Numarası (Opsiyonel)
                    </label>
                    <input type="text" name="receipt_number" class="form-control form-control-lg" placeholder="Dekont veya fiş numarası">
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">
                        <i class="bi bi-chat-left-text me-2"></i>Notlar (Opsiyonel)
                    </label>
                    <textarea name="notes" class="form-control" rows="3" placeholder="Ek bilgi veya notlarınız"></textarea>
                </div>
                
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-lg" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border: none; border-radius: 12px; font-weight: 600; padding: 16px;">
                        <i class="bi bi-check-circle me-2"></i>Ödemeyi Yaptım, Onay Bekliyorum
                    </button>
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-lg" style="border-radius: 12px;">
                        <i class="bi bi-arrow-left me-2"></i>Daha Sonra Yapacağım
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script>
        function copyToClipboard(elementId) {
            const element = document.getElementById(elementId);
            const text = element.textContent.trim();
            
            navigator.clipboard.writeText(text).then(() => {
                const btn = event.target.closest('.copy-btn');
                const originalHTML = btn.innerHTML;
                btn.innerHTML = '<i class="bi bi-check"></i> Kopyalandı!';
                btn.style.background = '#10b981';
                
                setTimeout(() => {
                    btn.innerHTML = originalHTML;
                    btn.style.background = '#ec4899';
                }, 2000);
            });
        }

        // Tarih input'unun maksimum değerini bugün yap
        document.querySelector('input[name="payment_date"]').max = new Date().toISOString().split('T')[0];
    </script>
</body>
</html>

