<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Ödeme - {{ $package->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Inter', -apple-system, sans-serif; background: linear-gradient(135deg, #fdf2f8 0%, #fce7f3 50%, #fbcfe8 100%); min-height: 100vh; padding: 24px 16px; }
        .checkout-container { max-width: 900px; margin: 0 auto; }
        .checkout-card { background: white; border-radius: 20px; box-shadow: 0 25px 50px -12px rgba(236, 72, 153, 0.2); margin-bottom: 24px; overflow: hidden; border: 1px solid rgba(236, 72, 153, 0.1); }
        .checkout-header { background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; padding: 28px 32px; }
        .checkout-header h1 { font-size: 1.5rem; font-weight: 700; margin-bottom: 0.5rem; }
        .checkout-header .amount { font-size: 2rem; font-weight: 800; }
        .checkout-body { padding: 28px 32px; }
        .section-title { font-size: 1.1rem; font-weight: 700; color: #0f172a; margin-bottom: 20px; display: flex; align-items: center; gap: 10px; }
        .section-title i { color: #ec4899; }
        .form-label { font-weight: 600; color: #374151; margin-bottom: 0.5rem; }
        .form-control, .form-select { border-radius: 12px; border: 2px solid #e5e7eb; padding: 12px 16px; }
        .form-control:focus, .form-select:focus { border-color: #ec4899; box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.15); }
        .payment-option { border: 2px solid #e5e7eb; border-radius: 16px; padding: 20px; cursor: pointer; transition: all 0.3s; margin-bottom: 12px; }
        .payment-option:hover { border-color: #ec4899; background: #fdf2f8; }
        .payment-option.selected { border-color: #ec4899; background: linear-gradient(135deg, #fdf2f8 0%, #fce7f3 100%); }
        .payment-option input { display: none; }
        .btn-pay { background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 12px; padding: 16px 32px; font-size: 1.1rem; font-weight: 700; color: white; width: 100%; transition: all 0.3s; }
        .btn-pay:hover { transform: translateY(-2px); box-shadow: 0 10px 25px rgba(236, 72, 153, 0.4); color: white; }
        .order-summary { background: #f8fafc; border-radius: 16px; padding: 24px; }
        .invoice-hint { font-size: 0.875rem; color: #64748b; margin-top: 8px; }
        .secure-badge { display: flex; align-items: center; justify-content: center; gap: 8px; color: #64748b; font-size: 0.875rem; margin-top: 16px; }
        .secure-badge i { color: #10b981; }
    </style>
</head>
<body>
    <div class="checkout-container">
        <a href="{{ route('admin.packages.select') }}" class="btn btn-link text-dark text-decoration-none mb-3 d-inline-flex align-items-center">
            <i class="bi bi-arrow-left me-2"></i>Paket seçimine dön
        </a>
        <div class="checkout-card">
            <div class="checkout-header">
                <h1><i class="bi bi-cart-check me-2"></i>{{ $package->name }}</h1>
                <p class="mb-0 opacity-90">{{ $package->description }}</p>
                <div class="amount mt-2">{{ number_format($package->price, 2, ',', '.') }} ₺</div>
            </div>

            <form id="checkoutForm" action="{{ route('payment.package.process', $package->id) }}" method="post">
                @csrf
                <input type="hidden" name="payment_method" id="paymentMethod" value="paytr">

                <div class="checkout-body">
                    <!-- Fatura Bilgileri -->
                    <div class="mb-4">
                        <div class="section-title"><i class="bi bi-receipt"></i>Fatura Bilgileri</div>
                        <p class="invoice-hint mb-3">Faturanız bu bilgilerle kesilecektir. <a href="{{ route('admin.settings.invoice-info') }}" target="_blank">Ayarlardan kaydedebilirsiniz</a>.</p>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Fatura Türü</label>
                                <select name="invoice_type" class="form-select" id="invoiceType">
                                    <option value="bireysel" {{ ($user->invoice_type ?? 'bireysel') == 'bireysel' ? 'selected' : '' }}>Bireysel</option>
                                    <option value="kurumsal" {{ ($user->invoice_type ?? '') == 'kurumsal' ? 'selected' : '' }}>Kurumsal</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" id="invoiceNameLabel">Ad Soyad</label>
                                <input type="text" name="invoice_name" class="form-control" value="{{ old('invoice_name', $user->invoice_name ?? $user->name) }}" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" id="taxLabel">TC Kimlik No</label>
                                <input type="text" name="invoice_tax_number" class="form-control" value="{{ old('invoice_tax_number', $user->invoice_tax_number) }}" placeholder="11 hane" maxlength="11" id="taxInput">
                            </div>
                            <div class="col-md-6" id="taxOfficeWrap" style="display:none;">
                                <label class="form-label">Vergi Dairesi</label>
                                <input type="text" name="invoice_tax_office" class="form-control" value="{{ old('invoice_tax_office', $user->invoice_tax_office) }}">
                            </div>
                            <div class="col-12">
                                <label class="form-label">Fatura Adresi</label>
                                <textarea name="invoice_address" class="form-control" rows="2" required>{{ old('invoice_address', $user->invoice_address ?? 'Türkiye') }}</textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">İl</label>
                                <select name="invoice_city" class="form-select" id="invoiceCity">
                                    <option value="">İl seçin</option>
                                    @foreach(array_keys(\App\Helpers\DistrictHelper::getAllDistricts()) as $city)
                                        <option value="{{ $city }}" {{ ($user->invoice_city ?? '') == $city ? 'selected' : '' }}>{{ $city }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">İlçe</label>
                                <select name="invoice_district" class="form-select" id="invoiceDistrict">
                                    <option value="">Önce il seçin</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Ödeme Yöntemi -->
                    <div class="mb-4">
                        <div class="section-title"><i class="bi bi-wallet2"></i>Ödeme Yöntemi</div>
                        <div class="payment-option selected" data-method="paytr">
                            <input type="radio" name="pay_method" value="paytr" id="payPaytr" checked>
                            <label for="payPaytr" class="d-flex align-items-center mb-0 cursor-pointer">
                                <i class="bi bi-credit-card-2-front fs-3 me-3" style="color:#ec4899;"></i>
                                <div>
                                    <strong>Kredi Kartı / Banka Kartı</strong>
                                    <p class="text-muted small mb-0 mt-1">PayTR ile güvenli ödeme</p>
                                </div>
                            </label>
                        </div>
                        <div class="payment-option" data-method="bank_transfer">
                            <input type="radio" name="pay_method" value="bank_transfer" id="payHavale">
                            <label for="payHavale" class="d-flex align-items-center mb-0 cursor-pointer">
                                <i class="bi bi-bank fs-3 me-3" style="color:#64748b;"></i>
                                <div>
                                    <strong>Havale / EFT</strong>
                                    <p class="text-muted small mb-0 mt-1">Manuel onay gerekir</p>
                                </div>
                            </label>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-pay" id="submitBtn">
                        <i class="bi bi-lock-fill me-2"></i>Ödemeyi Tamamla
                    </button>
                    <div class="secure-badge"><i class="bi bi-shield-check"></i><span>256-bit SSL ile güvenli ödeme</span></div>
                </div>
            </form>
        </div>
    </div>

    <script>
    const districts = @json(\App\Helpers\DistrictHelper::getAllDistricts());
    const currentDistrict = @json($user->invoice_district ?? '');
    document.getElementById('invoiceType').addEventListener('change', function() {
        const isKurumsal = this.value === 'kurumsal';
        document.getElementById('invoiceNameLabel').textContent = isKurumsal ? 'Ünvan' : 'Ad Soyad';
        document.getElementById('taxLabel').textContent = isKurumsal ? 'Vergi No (VKN)' : 'TC Kimlik No';
        document.getElementById('taxInput').placeholder = isKurumsal ? '10 hane' : '11 hane';
        document.getElementById('taxInput').maxLength = isKurumsal ? 10 : 11;
        document.getElementById('taxOfficeWrap').style.display = isKurumsal ? 'block' : 'none';
    });
    document.getElementById('invoiceType').dispatchEvent(new Event('change'));
    document.getElementById('invoiceCity').addEventListener('change', function() {
        const city = this.value;
        const sel = document.getElementById('invoiceDistrict');
        sel.innerHTML = '<option value="">İlçe seçin</option>';
        if (city && districts[city]) {
            districts[city].forEach(d => {
                const opt = document.createElement('option');
                opt.value = d;
                opt.textContent = d;
                if (d === currentDistrict) opt.selected = true;
                sel.appendChild(opt);
            });
        }
    });
    document.getElementById('invoiceCity').dispatchEvent(new Event('change'));
    document.querySelectorAll('.payment-option').forEach(el => {
        el.addEventListener('click', function() {
            document.querySelectorAll('.payment-option').forEach(x => x.classList.remove('selected'));
            this.classList.add('selected');
            document.getElementById('paymentMethod').value = this.dataset.method;
        });
    });
    document.getElementById('checkoutForm').addEventListener('submit', function() {
        document.getElementById('submitBtn').disabled = true;
        document.getElementById('submitBtn').innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>İşleniyor...';
    });
    </script>
</body>
</html>
