<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Ödeme - {{ $package->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            font-family: 'Inter', -apple-system, sans-serif;
            background: linear-gradient(135deg, #fdf2f8 0%, #fce7f3 50%, #fbcfe8 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        .payment-card {
            max-width: 480px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 25px 50px -12px rgba(236, 72, 153, 0.25);
            overflow: hidden;
            border: 1px solid rgba(236, 72, 153, 0.1);
        }
        .payment-header {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: white;
            padding: 28px 32px;
            text-align: center;
        }
        .payment-header h1 {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        .payment-header .amount {
            font-size: 2rem;
            font-weight: 800;
        }
        .payment-body {
            padding: 32px;
        }
        .form-label {
            font-weight: 600;
            color: #374151;
            margin-bottom: 0.5rem;
        }
        .form-control {
            border-radius: 12px;
            border: 2px solid #e5e7eb;
            padding: 12px 16px;
        }
        .form-control:focus {
            border-color: #ec4899;
            box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.15);
        }
        .card-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }
        .btn-pay {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            border-radius: 12px;
            padding: 16px 32px;
            font-size: 1.1rem;
            font-weight: 700;
            color: white;
            width: 100%;
            transition: all 0.3s;
        }
        .btn-pay:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(236, 72, 153, 0.4);
            color: white;
        }
        .secure-badge {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            color: #64748b;
            font-size: 0.875rem;
            margin-top: 20px;
        }
        .secure-badge i {
            color: #10b981;
        }
    </style>
</head>
<body>
    <div class="payment-card">
        <div class="payment-header">
            <h1><i class="bi bi-credit-card me-2"></i>{{ $package->name }}</h1>
            <p class="mb-0 opacity-90">{{ $package->description }}</p>
            <div class="amount mt-2">{{ number_format($package->price, 2, ',', '.') }} ₺</div>
        </div>

        <div class="payment-body">
            <form id="paymentForm" action="{{ $form_data['post_url'] }}" method="post">
                @foreach($form_data as $key => $value)
                    @if($key !== 'post_url' && $key !== 'success')
                        <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                    @endif
                @endforeach

                <div class="mb-3">
                    <label for="cc_owner" class="form-label">Kart Sahibi Adı Soyadı</label>
                    <input type="text" id="cc_owner" name="cc_owner" class="form-control" placeholder="Kart üzerindeki isim" required maxlength="50" value="{{ $user->name }}">
                </div>

                <div class="mb-3">
                    <label for="card_number" class="form-label">Kart Numarası</label>
                    <input type="text" id="card_number" name="card_number" class="form-control" placeholder="0000 0000 0000 0000" required maxlength="19" autocomplete="cc-number">
                </div>

                <div class="card-row mb-3">
                    <div>
                        <label for="expiry_month" class="form-label">Son Kullanma Ay</label>
                        <select id="expiry_month" name="expiry_month" class="form-select" required style="border-radius: 12px; border: 2px solid #e5e7eb; padding: 12px;">
                            <option value="">Ay</option>
                            @for($m = 1; $m <= 12; $m++)
                                <option value="{{ str_pad($m, 2, '0', STR_PAD_LEFT) }}">{{ str_pad($m, 2, '0', STR_PAD_LEFT) }}</option>
                            @endfor
                        </select>
                    </div>
                    <div>
                        <label for="expiry_year" class="form-label">Son Kullanma Yıl</label>
                        <select id="expiry_year" name="expiry_year" class="form-select" required style="border-radius: 12px; border: 2px solid #e5e7eb; padding: 12px;">
                            <option value="">Yıl</option>
                            @for($y = date('y'); $y <= date('y') + 15; $y++)
                                <option value="{{ $y }}">{{ $y }}</option>
                            @endfor
                        </select>
                    </div>
                </div>

                <div class="mb-4">
                    <label for="cvv" class="form-label">Güvenlik Kodu (CVV)</label>
                    <input type="text" id="cvv" name="cvv" class="form-control" placeholder="•••" required maxlength="4" autocomplete="cc-csc" style="max-width: 120px;">
                    <small class="text-muted">Kartın arkasındaki 3 veya 4 haneli numara</small>
                </div>

                <button type="submit" class="btn btn-pay" id="submitBtn">
                    <i class="bi bi-lock-fill me-2"></i>Ödemeyi Tamamla
                </button>

                <div class="secure-badge">
                    <i class="bi bi-shield-check"></i>
                    <span>256-bit SSL ile güvenli ödeme</span>
                </div>
            </form>
        </div>
    </div>

    <script>
        function formatCardNumber(value) {
            const v = value.replace(/\s+/g, '').replace(/[^0-9]/gi, '');
            const matches = v.match(/\d{4,16}/g);
            const match = (matches && matches[0]) || '';
            const parts = [];
            for (let i = 0, len = match.length; i < len; i += 4) {
                parts.push(match.substring(i, i + 4));
            }
            return parts.length ? parts.join(' ') : value;
        }
        document.getElementById('card_number').addEventListener('input', function(e) {
            e.target.value = formatCardNumber(e.target.value);
        });
        document.getElementById('paymentForm').addEventListener('submit', function(e) {
            document.getElementById('card_number').value = document.getElementById('card_number').value.replace(/\s/g, '');
            document.getElementById('submitBtn').disabled = true;
            document.getElementById('submitBtn').innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>İşleniyor...';
        });
    </script>
</body>
</html>
