<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ödeme Yöntemi Seçimi - {{ $package->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        .payment-container {
            max-width: 800px;
            margin: 0 auto;
        }
        .package-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        .method-card {
            background: white;
            border-radius: 16px;
            padding: 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            margin-bottom: 20px;
            border: 2px solid #e2e8f0;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .method-card:hover {
            border-color: #ec4899;
            box-shadow: 0 8px 30px rgba(236, 72, 153, 0.2);
            transform: translateY(-3px);
        }
        .method-card.selected {
            border-color: #ec4899;
            background: linear-gradient(135deg, #fdf2f8 0%, #ffffff 100%);
        }
        .method-icon {
            font-size: 48px;
            color: #ec4899;
            margin-bottom: 15px;
        }
        .price-display {
            font-size: 36px;
            font-weight: 800;
            color: #ec4899;
            margin: 20px 0;
        }
        .original-price {
            text-decoration: line-through;
            color: #94a3b8;
            font-size: 24px;
            margin-right: 10px;
        }
        .discount-badge {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            display: inline-block;
            margin-left: 10px;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="package-card text-center">
            <h1 class="mb-3" style="color: #0f172a;">
                <i class="bi bi-box-seam me-2" style="color: #ec4899;"></i>{{ $package->name }}
            </h1>
            <p class="text-muted mb-4">{{ $package->description }}</p>
            
            <div class="price-display">
                @if($package->original_price && $package->original_price > $package->price)
                    <span class="original-price">{{ number_format($package->original_price, 2, ',', '.') }} ₺</span>
                @endif
                <span>{{ number_format($package->price, 2, ',', '.') }} ₺</span>
                @if($package->discount_percentage > 0)
                    <span class="discount-badge">%{{ $package->discount_percentage }} İndirim</span>
                @endif
            </div>
            
            <p class="text-muted mb-0">
                <i class="bi bi-calendar-check me-2"></i>{{ $package->duration_months ?? 1 }} ay geçerli
            </p>
        </div>

        <h3 class="text-center mb-4" style="color: #0f172a;">
            <i class="bi bi-credit-card me-2" style="color: #ec4899;"></i>Ödeme Yöntemi Seçin
        </h3>

        <form id="paymentMethodForm" action="{{ route('payment.package.process', $package->id) }}" method="POST">
            @csrf
            <input type="hidden" name="payment_method" id="selectedPaymentMethod">
            
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="method-card" data-method="paytr" onclick="selectMethod('paytr')">
                        <div class="text-center">
                            <i class="bi bi-credit-card method-icon"></i>
                            <h4 class="fw-bold mb-2">PayTR ile Ödeme</h4>
                            <p class="text-muted mb-3">Kredi kartı veya banka kartı ile güvenli ödeme</p>
                            <ul class="list-unstyled text-start">
                                <li><i class="bi bi-check-circle-fill text-success me-2"></i>Anında aktivasyon</li>
                                <li><i class="bi bi-check-circle-fill text-success me-2"></i>Güvenli ödeme</li>
                                <li><i class="bi bi-check-circle-fill text-success me-2"></i>256-bit SSL şifreleme</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="method-card" data-method="bank_transfer" onclick="selectMethod('bank_transfer')">
                        <div class="text-center">
                            <i class="bi bi-bank method-icon"></i>
                            <h4 class="fw-bold mb-2">Havale / EFT</h4>
                            <p class="text-muted mb-3">Banka havalesi veya EFT ile ödeme</p>
                            <ul class="list-unstyled text-start">
                                <li><i class="bi bi-info-circle text-info me-2"></i>Manuel onay gerekir</li>
                                <li><i class="bi bi-info-circle text-info me-2"></i>1-2 iş günü içinde aktif</li>
                                <li><i class="bi bi-check-circle-fill text-success me-2"></i>Komisyon yok</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="text-center mt-4">
                <button type="submit" class="btn btn-lg px-5" id="submitBtn" disabled style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border: none; border-radius: 12px; font-weight: 600;">
                    <i class="bi bi-arrow-right me-2"></i>Devam Et
                </button>
            </div>
        </form>
    </div>

    <script>
        function selectMethod(method) {
            // Tüm kartlardan selected class'ını kaldır
            document.querySelectorAll('.method-card').forEach(card => {
                card.classList.remove('selected');
            });
            
            // Seçilen kartı işaretle
            document.querySelector(`[data-method="${method}"]`).classList.add('selected');
            
            // Hidden input'a değeri yaz
            document.getElementById('selectedPaymentMethod').value = method;
            
            // Submit butonunu aktif et
            document.getElementById('submitBtn').disabled = false;
        }
    </script>
</body>
</html>

