@extends('layouts.admin')

@section('title', 'Randevularım')
@section('page-title', 'Randevularım')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-calendar-check me-2"></i>Randevularım
                </h2>
                <a href="{{ route('personel.dashboard') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Dashboard
                </a>
            </div>
        </div>
    </div>

    <!-- Filtreler -->
    <div class="card shadow-sm mb-4" style="border: none; border-radius: 16px;">
        <div class="card-body">
            <form method="GET" action="{{ route('personel.appointments') }}" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label fw-bold">Durum</label>
                    <select name="status" class="form-select">
                        <option value="all" {{ request('status') === 'all' || !request('status') ? 'selected' : '' }}>Tümü</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Aktif</option>
                        <option value="confirmed" {{ request('status') === 'confirmed' ? 'selected' : '' }}>Onaylı</option>
                        <option value="open" {{ request('status') === 'open' ? 'selected' : '' }}>Açık</option>
                        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Tamamlanan</option>
                        <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>İptal</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Başlangıç Tarihi</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Bitiş Tarihi</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Müşteri Ara</label>
                    <input type="text" name="search" class="form-control" placeholder="İsim veya telefon" value="{{ request('search') }}">
                </div>
                <div class="col-12">
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-funnel me-2"></i>Filtrele
                    </button>
                    <a href="{{ route('personel.appointments') }}" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-2"></i>Temizle
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Randevular Listesi -->
    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Randevular
                <span class="badge bg-white text-primary ms-2">{{ $appointments->total() }}</span>
            </h5>
        </div>
        <div class="card-body">
            @if($appointments->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Tarih</th>
                                <th>Saat</th>
                                <th>Müşteri</th>
                                <th>Hizmet</th>
                                <th>Oda</th>
                                <th>Durum</th>
                                <th>Tutar</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($appointments as $appointment)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $appointment->date->format('d.m.Y') }}</div>
                                        <small class="text-muted">{{ $appointment->date->format('l') }}</small>
                                    </td>
                                    <td>
                                        <div class="fw-bold">{{ $appointment->start_time }}</div>
                                        @if($appointment->end_time)
                                            <small class="text-muted">{{ $appointment->end_time }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="fw-bold">{{ $appointment->customer->name ?? 'Müşteri' }}</div>
                                        @if($appointment->customer && $appointment->customer->phone)
                                            <small class="text-muted">
                                                <i class="bi bi-telephone me-1"></i>{{ $appointment->customer->phone }}
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($appointment->appointmentRequest && $appointment->appointmentRequest->service)
                                            <span class="badge bg-info">{{ $appointment->appointmentRequest->service->name }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($appointment->room)
                                            <span class="badge bg-secondary">{{ $appointment->room->name }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($appointment->status === 'completed')
                                            <span class="badge bg-success">Tamamlandı</span>
                                        @elseif($appointment->status === 'confirmed')
                                            <span class="badge bg-primary">Onaylı</span>
                                        @elseif($appointment->status === 'open')
                                            <span class="badge bg-warning text-dark">Açık</span>
                                        @elseif($appointment->status === 'cancelled')
                                            <span class="badge bg-danger">İptal</span>
                                        @else
                                            <span class="badge bg-secondary">{{ $appointment->status }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="fw-bold text-primary">{{ number_format($appointment->total_price, 2, ',', '.') }} ₺</span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#appointmentModal{{ $appointment->id }}" title="Detay">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>

                                <!-- Randevu Detay Modal -->
                                <div class="modal fade" id="appointmentModal{{ $appointment->id }}" tabindex="-1">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content" style="border-radius: 16px; border: none;">
                                            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                                                <h5 class="modal-title text-white fw-bold">
                                                    <i class="bi bi-calendar-check me-2"></i>Randevu Detayı
                                                </h5>
                                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label class="form-label fw-bold text-muted">Müşteri</label>
                                                        <div class="fw-bold">{{ $appointment->customer->name ?? 'Müşteri' }}</div>
                                                        @if($appointment->customer && $appointment->customer->phone)
                                                            <small class="text-muted">{{ $appointment->customer->phone }}</small>
                                                        @endif
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label fw-bold text-muted">Tarih & Saat</label>
                                                        <div class="fw-bold">{{ $appointment->date->format('d.m.Y') }} - {{ $appointment->start_time }}</div>
                                                        @if($appointment->end_time)
                                                            <small class="text-muted">Bitiş: {{ $appointment->end_time }}</small>
                                                        @endif
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label fw-bold text-muted">Hizmet</label>
                                                        <div>
                                                            @if($appointment->appointmentRequest && $appointment->appointmentRequest->service)
                                                                <span class="badge bg-info">{{ $appointment->appointmentRequest->service->name }}</span>
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label fw-bold text-muted">Oda</label>
                                                        <div>
                                                            @if($appointment->room)
                                                                <span class="badge bg-secondary">{{ $appointment->room->name }}</span>
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label fw-bold text-muted">Durum</label>
                                                        <div>
                                                            @if($appointment->status === 'completed')
                                                                <span class="badge bg-success">Tamamlandı</span>
                                                            @elseif($appointment->status === 'confirmed')
                                                                <span class="badge bg-primary">Onaylı</span>
                                                            @elseif($appointment->status === 'open')
                                                                <span class="badge bg-warning text-dark">Açık</span>
                                                            @elseif($appointment->status === 'cancelled')
                                                                <span class="badge bg-danger">İptal</span>
                                                            @else
                                                                <span class="badge bg-secondary">{{ $appointment->status }}</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label fw-bold text-muted">Tutar</label>
                                                        <div class="fw-bold text-primary" style="font-size: 1.2rem;">{{ number_format($appointment->total_price, 2, ',', '.') }} ₺</div>
                                                    </div>
                                                    @if($appointment->notes)
                                                        <div class="col-12">
                                                            <label class="form-label fw-bold text-muted">Notlar</label>
                                                            <div class="p-3 bg-light rounded">{{ $appointment->notes }}</div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $appointments->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-calendar-x" style="font-size: 64px; color: #ccc;"></i>
                    <h5 class="mt-3 text-muted">Randevu bulunamadı</h5>
                    <p class="text-muted">Filtreleri değiştirerek tekrar deneyin.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

