@extends('layouts.admin')

@section('title', 'Randevu Takvimim')
@section('page-title', 'Randevu Takvimim')

@section('content')
<style>
    body {
        padding-top: var(--header-height) !important;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    }
    
    .main-content {
        padding: 0 !important;
        margin: 0 !important;
    }
    
    .calendar-wrapper {
        background: white;
        border-radius: 24px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
        overflow: hidden;
        margin: 20px;
        min-height: calc(100vh - 120px);
        display: flex;
        flex-direction: column;
    }
    
    .calendar-header-section {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        padding: 24px 32px;
        color: white;
        position: relative;
        overflow: hidden;
    }
    
    .calendar-header-section::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -10%;
        width: 300px;
        height: 300px;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        border-radius: 50%;
    }
    
    .calendar-header-section h2 {
        color: white;
        font-weight: 700;
        font-size: 32px;
        margin: 0 0 16px 0;
        text-shadow: 0 2px 8px rgba(0,0,0,0.1);
        position: relative;
        z-index: 1;
    }
    
    .calendar-header-actions {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
        position: relative;
        z-index: 1;
    }
    
    .header-action-btn {
        padding: 10px 20px;
        border: 2px solid rgba(255,255,255,0.3);
        background: rgba(255,255,255,0.15);
        color: white;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }
    
    .header-action-btn:hover {
        background: rgba(255,255,255,0.25);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        color: white;
    }
    
    .header-action-btn.active {
        background: white;
        color: #ec4899;
        border-color: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .fc {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    }
    
    .fc-toolbar {
        padding: 20px 32px !important;
        background: white;
        border-bottom: 2px solid #e2e8f0;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px;
    }
    
    .fc-toolbar-title {
        font-size: 24px !important;
        font-weight: 700 !important;
        color: #1e293b !important;
        letter-spacing: -0.5px;
    }
    
    .fc-button {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
        border: none !important;
        color: white !important;
        padding: 10px 20px !important;
        font-size: 14px !important;
        border-radius: 12px !important;
        font-weight: 600 !important;
        transition: all 0.3s ease !important;
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.2) !important;
    }
    
    .fc-button:hover {
        background: linear-gradient(135deg, #be185d 0%, #1e3a8a 100%) !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3) !important;
    }
    
    .fc-button:active {
        transform: translateY(0) !important;
    }
    
    .fc-button-group {
        gap: 8px !important;
    }
    
    .fc-col-header-cell {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%) !important;
        padding: 16px 8px !important;
        border-color: #e2e8f0 !important;
        font-weight: 700 !important;
        color: #475569 !important;
        font-size: 13px !important;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .fc-daygrid-day {
        background: white !important;
        border-color: #e2e8f0 !important;
        min-height: 140px !important;
        transition: all 0.2s ease;
        position: relative;
    }
    
    .fc-daygrid-day:hover {
        background: #f8fafc !important;
    }
    
    .fc-day-today {
        background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%) !important;
        position: relative;
    }
    
    .fc-day-today::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
    }
    
    .fc-daygrid-day-number {
        padding: 8px !important;
        font-weight: 600 !important;
        color: #1e293b !important;
        font-size: 14px !important;
        width: 36px !important;
        height: 36px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        border-radius: 50% !important;
        background: transparent !important;
        margin: 6px auto !important;
        text-decoration: none !important;
        border: none !important;
        transition: all 0.2s ease !important;
    }
    
    .fc-day-today .fc-daygrid-day-number {
        color: white !important;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
        font-weight: 700 !important;
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3) !important;
    }
    
    .fc-daygrid-day-number:hover {
        background: #f1f5f9 !important;
        color: #ec4899 !important;
    }
    
    .fc-day-today .fc-daygrid-day-number:hover {
        background: linear-gradient(135deg, #be185d 0%, #1e3a8a 100%) !important;
        color: white !important;
    }
    
    .fc-event {
        border: none !important;
        padding: 10px 14px !important;
        border-radius: 12px !important;
        cursor: pointer !important;
        font-size: 13px !important;
        margin: 4px 6px !important;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12) !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        font-weight: 600 !important;
        border-left: 4px solid rgba(255,255,255,0.8) !important;
        position: relative !important;
        overflow: hidden !important;
    }
    
    .fc-event::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, rgba(255,255,255,0.05) 100%);
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .fc-event:hover {
        transform: translateY(-3px) scale(1.02) !important;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2) !important;
        z-index: 10 !important;
        border-left-width: 5px !important;
    }
    
    .fc-event:hover::before {
        opacity: 1;
    }
    
    .fc-event[data-status="confirmed"] {
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%) !important;
        color: white !important;
    }
    
    .fc-event[data-status="open"] {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%) !important;
        color: white !important;
    }
    
    .fc-event[data-status="completed"] {
        background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%) !important;
        color: white !important;
    }
    
    .fc-event[data-status="cancelled"] {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%) !important;
        color: white !important;
    }
    
    .fc-event-title {
        font-weight: 600 !important;
        line-height: 1.4 !important;
    }
    
    .fc-daygrid-event {
        white-space: nowrap !important;
        overflow: hidden !important;
        text-overflow: ellipsis !important;
    }
    
    .fc-scrollgrid {
        border: 2px solid #e2e8f0 !important;
        border-radius: 16px !important;
        overflow: hidden !important;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06) !important;
        margin: 0 32px 32px 32px !important;
    }
    
    .fc-view-harness {
        padding: 0 !important;
        flex: 1;
        overflow: auto;
        background: white;
    }
    
    #personelCalendar {
        flex: 1;
        min-height: 0;
        padding: 0;
    }
    
    .fc-timegrid-slot {
        height: 50px !important;
        border-color: #f1f5f9 !important;
    }
    
    .fc-timegrid-slot-minor {
        height: 25px !important;
        border-color: #f8fafc !important;
    }
    
    .fc-timegrid-event {
        border-radius: 10px !important;
        padding: 8px 12px !important;
        font-size: 13px !important;
        font-weight: 600 !important;
        border: none !important;
        cursor: pointer !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15) !important;
        transition: all 0.3s ease !important;
    }
    
    .fc-timegrid-event:hover {
        transform: translateY(-2px) !important;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.25) !important;
    }
    
    .fc-timegrid-event-title {
        font-weight: 600 !important;
        line-height: 1.4 !important;
    }
    
    .fc-timegrid-axis {
        width: 60px !important;
        font-size: 12px !important;
        color: #64748b !important;
        font-weight: 600 !important;
    }
    
    .fc-timegrid-col {
        border-color: #f1f5f9 !important;
    }
    
    /* İstatistik Kartları */
    .stats-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        padding: 24px 32px;
        background: white;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .stat-card {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-radius: 16px;
        padding: 20px;
        text-align: center;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }
    
    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
        border-color: #ec4899;
    }
    
    .stat-card-value {
        font-size: 28px;
        font-weight: 700;
        color: #ec4899;
        margin-bottom: 8px;
    }
    
    .stat-card-label {
        font-size: 14px;
        color: #64748b;
        font-weight: 600;
    }
    
    /* Mobile Responsive */
    @media (max-width: 1024px) {
        .calendar-wrapper {
            margin: 0;
            border-radius: 0;
            min-height: 100vh;
        }
        
        .calendar-header-section {
            padding: 20px 24px;
        }
        
        .calendar-header-section h2 {
            font-size: 24px;
        }
        
        .fc-toolbar {
            padding: 16px 20px !important;
            flex-direction: column;
            gap: 12px;
        }
        
        .fc-toolbar-title {
            font-size: 20px !important;
        }
        
        .fc-button {
            padding: 8px 16px !important;
            font-size: 13px !important;
        }
        
        .fc-scrollgrid {
            margin: 0 16px 16px 16px !important;
        }
        
        .stats-cards {
            grid-template-columns: repeat(2, 1fr);
            padding: 20px 16px;
            gap: 12px;
        }
        
        .stat-card {
            padding: 16px;
        }
        
        .stat-card-value {
            font-size: 24px;
        }
    }
    
    @media (max-width: 768px) {
        .stats-cards {
            grid-template-columns: 1fr;
        }
        
        .fc-daygrid-day {
            min-height: 100px !important;
        }
        
        .fc-timegrid-slot {
            height: 45px !important;
        }
    }
</style>

<div class="calendar-wrapper">
    <div class="calendar-header-section">
        <h2><i class="bi bi-calendar3 me-2"></i>Randevu Takvimim</h2>
        <div class="calendar-header-actions">
            <a href="{{ route('personel.dashboard') }}" class="header-action-btn">
                <i class="bi bi-house-door"></i> Dashboard
            </a>
            <a href="{{ route('personel.appointments') }}" class="header-action-btn">
                <i class="bi bi-list-ul"></i> Randevular
            </a>
        </div>
    </div>
    
    <!-- İstatistikler -->
    <div class="stats-cards">
        @php
            $today = now()->toDateString();
            $todayCount = \App\Models\Reservation::where('personel_id', auth()->id())
                ->where('date', $today)
                ->whereNotIn('status', ['cancelled'])
                ->count();
            $weekStart = now()->startOfWeek()->toDateString();
            $weekEnd = now()->endOfWeek()->toDateString();
            $weekCount = \App\Models\Reservation::where('personel_id', auth()->id())
                ->whereBetween('date', [$weekStart, $weekEnd])
                ->whereNotIn('status', ['cancelled'])
                ->count();
            $upcomingCount = \App\Models\Reservation::where('personel_id', auth()->id())
                ->where('date', '>=', $today)
                ->whereNotIn('status', ['cancelled', 'completed'])
                ->count();
            $completedCount = \App\Models\Reservation::where('personel_id', auth()->id())
                ->where('status', 'completed')
                ->count();
        @endphp
        <div class="stat-card">
            <div class="stat-card-value">{{ $todayCount }}</div>
            <div class="stat-card-label">Bugünkü Randevu</div>
        </div>
        <div class="stat-card">
            <div class="stat-card-value">{{ $weekCount }}</div>
            <div class="stat-card-label">Bu Hafta</div>
        </div>
        <div class="stat-card">
            <div class="stat-card-value">{{ $upcomingCount }}</div>
            <div class="stat-card-label">Yaklaşan</div>
        </div>
        <div class="stat-card">
            <div class="stat-card-value">{{ $completedCount }}</div>
            <div class="stat-card-label">Tamamlanan</div>
        </div>
    </div>
    
    <div class="fc-view-harness">
        <div id="personelCalendar"></div>
    </div>
</div>

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales/tr.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('personelCalendar');
    if (!calendarEl) return;
    
    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'timeGridDay',
        locale: 'tr',
        firstDay: 1,
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        views: {
            dayGridMonth: {
                buttonText: 'Ay',
                dayMaxEvents: 4,
                moreLinkClick: 'popover'
            },
            timeGridWeek: {
                buttonText: 'Hafta',
                slotDuration: '00:30:00',
                slotMinTime: '08:00:00',
                slotMaxTime: '23:00:00',
                allDaySlot: false
            },
            timeGridDay: {
                buttonText: 'Gün',
                slotDuration: '00:30:00',
                slotMinTime: '08:00:00',
                slotMaxTime: '23:00:00',
                allDaySlot: false
            }
        },
        height: 'auto',
        contentHeight: 'auto',
        aspectRatio: null,
        expandRows: true,
        allDaySlot: false,
        slotMinTime: '08:00:00',
        slotMaxTime: '23:00:00',
        slotDuration: '00:30:00',
        themeSystem: 'standard',
        events: function(fetchInfo, successCallback, failureCallback) {
            try {
                fetch('{{ route("personel.calendar.feed") }}?start=' + fetchInfo.startStr + '&end=' + fetchInfo.endStr)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('HTTP error! status: ' + response.status);
                        }
                        return response.json();
                    })
                    .then(data => {
                        if (!Array.isArray(data)) {
                            console.error('Takvim verisi array değil:', data);
                            successCallback([]);
                            return;
                        }
                        
                        try {
                            const events = data.map(event => {
                                if (!event || typeof event !== 'object') {
                                    return null;
                                }
                                
                                const status = event.extendedProps?.status || event.status || 'open';
                                
                                // Renk belirleme
                                let bgColor = '#f59e0b';
                                let borderColor = '#d97706';
                                
                                switch(status) {
                                    case 'confirmed':
                                        bgColor = '#3b82f6';
                                        borderColor = '#2563eb';
                                        break;
                                    case 'completed':
                                        bgColor = '#22c55e';
                                        borderColor = '#16a34a';
                                        break;
                                    case 'cancelled':
                                        bgColor = '#ef4444';
                                        borderColor = '#dc2626';
                                        break;
                                    default:
                                        bgColor = '#f59e0b';
                                        borderColor = '#d97706';
                                }
                                
                                return {
                                    id: event.id || null,
                                    title: event.title || 'Randevu',
                                    start: event.start || null,
                                    end: event.end || null,
                                    backgroundColor: bgColor,
                                    borderColor: borderColor,
                                    textColor: 'white',
                                    extendedProps: event.extendedProps || event
                                };
                            }).filter(event => event !== null && event.start !== null);
                            
                            successCallback(events);
                        } catch (mapError) {
                            console.error('Event mapping hatası:', mapError);
                            successCallback([]);
                        }
                    })
                    .catch(error => {
                        console.error('Takvim yükleme hatası:', error);
                        successCallback([]);
                    });
            } catch (error) {
                console.error('Takvim events fonksiyonu hatası:', error);
                successCallback([]);
            }
        },
        eventDidMount: function(info) {
            const status = info.event.extendedProps?.status || 'open';
            info.el.setAttribute('data-status', status);
            
            const props = info.event.extendedProps || {};
            const service = props.service || 'Hizmet';
            const customer = props.customer || 'Müşteri';
            const time = props.start_time ? props.start_time.substring(0, 5) : '';
            const price = props.total_price ? parseFloat(props.total_price).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺' : '';
            const room = props.room || '';
            const notes = props.notes || '';
            
            // Tooltip içeriği
            let tooltipContent = `${customer}\n${service}`;
            if (time) tooltipContent += `\n${time}`;
            if (price) tooltipContent += `\n${price}`;
            if (room) tooltipContent += `\nOda: ${room}`;
            if (notes) tooltipContent += `\nNot: ${notes}`;
            
            info.el.setAttribute('title', tooltipContent);
            info.el.setAttribute('data-bs-toggle', 'tooltip');
            info.el.setAttribute('data-bs-placement', 'top');
            info.el.style.cursor = 'pointer';
        },
        eventClick: function(info) {
            info.jsEvent.preventDefault();
            const props = info.event.extendedProps || {};
            const reservationId = props.reservation_id || info.event.id;
            
            if (reservationId) {
                const service = props.service || 'Hizmet';
                const customer = props.customer || 'Müşteri';
                const time = props.start_time || '';
                const price = props.total_price ? parseFloat(props.total_price).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺' : '';
                const room = props.room || '';
                const notes = props.notes || '';
                const status = props.status || 'open';
                
                let statusText = 'Açık';
                let statusColor = '#f59e0b';
                if (status === 'confirmed') {
                    statusText = 'Onaylı';
                    statusColor = '#3b82f6';
                } else if (status === 'completed') {
                    statusText = 'Tamamlandı';
                    statusColor = '#22c55e';
                } else if (status === 'cancelled') {
                    statusText = 'İptal Edildi';
                    statusColor = '#ef4444';
                }
                
                // Modal oluştur
                const modalHtml = `
                    <div class="modal fade" id="appointmentDetailModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content" style="border-radius: 16px; border: none;">
                                <div class="modal-header" style="background: linear-gradient(135deg, ${statusColor} 0%, ${statusColor}dd 100%); border-radius: 16px 16px 0 0;">
                                    <h5 class="modal-title text-white fw-bold">
                                        <i class="bi bi-calendar-check me-2"></i>Randevu Detayı
                                    </h5>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body p-4">
                                    <div class="row g-3">
                                        <div class="col-12">
                                            <label class="form-label fw-bold text-muted small">Müşteri</label>
                                            <div class="fw-bold" style="font-size: 18px; color: #1e293b;">${customer}</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold text-muted small">Tarih</label>
                                            <div class="fw-bold">${info.event.start.toLocaleDateString('tr-TR', {day: 'numeric', month: 'long', year: 'numeric'})}</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold text-muted small">Saat</label>
                                            <div class="fw-bold">${time}</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold text-muted small">Hizmet</label>
                                            <div><span class="badge bg-info">${service}</span></div>
                                        </div>
                                        ${room ? `<div class="col-md-6">
                                            <label class="form-label fw-bold text-muted small">Oda</label>
                                            <div><span class="badge bg-secondary">${room}</span></div>
                                        </div>` : ''}
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold text-muted small">Durum</label>
                                            <div><span class="badge" style="background: ${statusColor}; color: white;">${statusText}</span></div>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold text-muted small">Tutar</label>
                                            <div class="fw-bold text-primary" style="font-size: 18px;">${price}</div>
                                        </div>
                                        ${notes ? `<div class="col-12">
                                            <label class="form-label fw-bold text-muted small">Notlar</label>
                                            <div class="p-3 bg-light rounded">${notes}</div>
                                        </div>` : ''}
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                
                // Eski modal'ı kaldır
                const oldModal = document.getElementById('appointmentDetailModal');
                if (oldModal) {
                    oldModal.remove();
                }
                
                // Yeni modal'ı ekle
                document.body.insertAdjacentHTML('beforeend', modalHtml);
                const modal = new bootstrap.Modal(document.getElementById('appointmentDetailModal'));
                modal.show();
                
                // Modal kapandığında DOM'dan kaldır
                document.getElementById('appointmentDetailModal').addEventListener('hidden.bs.modal', function() {
                    this.remove();
                });
            }
        },
        dateClick: function(info) {
            return false;
        },
        eventDisplay: 'block',
        eventTimeFormat: {
            hour: '2-digit',
            minute: '2-digit',
            hour12: false
        },
        dayMaxEvents: 4,
        moreLinkClick: 'popover'
    });
    
    calendar.render();
    
    // View değiştiğinde optimize et
    calendar.on('viewDidMount', function() {
        setTimeout(() => {
            calendar.updateSize();
        }, 100);
    });
    
    // Window resize'da takvimi güncelle
    window.addEventListener('resize', function() {
        calendar.updateSize();
    });
});
</script>
@endpush
@endsection
