@extends('layouts.admin')

@section('title', 'Personel Dashboard')
@section('page-title', 'Randevularım')

@push('styles')
<style>
    .reservations-list {
        max-height: 600px;
        overflow-y: auto;
    }
    .reservation-item {
        border-left: 4px solid #ec4899;
        transition: all 0.3s ease;
        cursor: pointer;
    }
    .reservation-item:hover {
        transform: translateX(5px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        background: #ffffff !important;
    }
    .calendar-container {
        min-height: 500px;
        padding: 1rem;
    }
    
    /* Responsive Styles */
    @media (max-width: 991.98px) {
        .reservations-list {
            max-height: 400px;
        }
        .calendar-container {
            min-height: 400px;
        }
        #personelCalendar .fc-header-toolbar {
            flex-direction: column;
            gap: 0.5rem;
        }
        #personelCalendar .fc-toolbar-chunk {
            width: 100%;
            display: flex;
            justify-content: center;
        }
        #personelCalendar .fc-button-group {
            flex-wrap: wrap;
        }
    }
    
    @media (max-width: 767.98px) {
        .calendar-container {
            min-height: 350px;
            padding: 0.5rem;
        }
        #personelCalendar .fc-toolbar-title {
            font-size: 1.2rem;
        }
        #personelCalendar .fc-button {
            padding: 0.4rem 0.8rem;
            font-size: 0.875rem;
        }
    }
    
    /* FullCalendar Modern Stilleri - Excel görünümünü kaldır */
    #personelCalendar {
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        background: transparent;
    }
    
    /* Ana takvim container - border ve shadow kaldır */
    #personelCalendar .fc-scrollgrid {
        border: none !important;
        border-radius: 0 !important;
        box-shadow: none !important;
    }
    
    /* Header toolbar - modern görünüm */
    #personelCalendar .fc-header-toolbar {
        margin-bottom: 1.5rem;
        padding: 1rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-radius: 16px;
        border: none;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    }
    
    /* Önceki/Sonraki butonları arasındaki mesafe */
    #personelCalendar .fc-toolbar-chunk:first-child {
        display: flex;
        gap: 1rem;
    }
    
    #personelCalendar .fc-button {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border: none;
        border-radius: 10px;
        padding: 0.6rem 1.2rem;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.2);
    }
    
    /* Prev/Next butonları arasındaki özel mesafe */
    #personelCalendar .fc-prev-button {
        margin-right: 0.75rem !important;
    }
    
    #personelCalendar .fc-next-button {
        margin-left: 0.75rem !important;
    }
    
    #personelCalendar .fc-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.4);
    }
    
    #personelCalendar .fc-button-active {
        background: linear-gradient(135deg, #be185d 0%, #9f1239 100%);
        box-shadow: 0 4px 16px rgba(190, 24, 93, 0.4);
    }
    
    #personelCalendar .fc-today-button {
        background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%);
        box-shadow: 0 2px 8px rgba(59, 130, 246, 0.2);
    }
    
    #personelCalendar .fc-today-button:hover {
        box-shadow: 0 4px 16px rgba(59, 130, 246, 0.4);
    }
    
    #personelCalendar .fc-toolbar-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: #111827;
        letter-spacing: -0.5px;
    }
    
    /* Gün hücreleri - border kaldır, modern görünüm */
    #personelCalendar .fc-daygrid-day {
        border: none !important;
        border-right: 1px solid rgba(229, 231, 235, 0.5) !important;
        border-bottom: 1px solid rgba(229, 231, 235, 0.5) !important;
        background: #ffffff;
        transition: all 0.2s ease;
    }
    
    #personelCalendar .fc-daygrid-day:hover {
        background: #f9fafb;
    }
    
    #personelCalendar .fc-daygrid-day-top {
        padding: 0.75rem 0.5rem;
    }
    
    /* Bugünün günü - özel stil */
    #personelCalendar .fc-day-today {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%) !important;
        position: relative;
    }
    
    #personelCalendar .fc-day-today::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 3px;
        background: linear-gradient(90deg, #ec4899 0%, #be185d 100%);
    }
    
    #personelCalendar .fc-day-today .fc-daygrid-day-number {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        border-radius: 50%;
        width: 2.25rem;
        height: 2.25rem;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
    }
    
    /* Randevu eventleri - modern kart görünümü */
    #personelCalendar .fc-event {
        border-radius: 10px;
        padding: 6px 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        margin-bottom: 4px;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
    }
    
    #personelCalendar .fc-event:hover {
        transform: translateY(-2px) scale(1.02);
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.4);
        z-index: 10;
    }
    
    #personelCalendar .fc-event-title {
        font-weight: 600;
        font-size: 0.875rem;
    }
    
    #personelCalendar .fc-daygrid-event {
        margin-bottom: 6px;
    }
    
    /* Başlık satırı (Pzt, Sal, Çar...) - modern görünüm */
    #personelCalendar .fc-col-header-cell {
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        padding: 1rem 0.5rem;
        font-weight: 700;
        color: #374151;
        border: none !important;
        border-bottom: 2px solid rgba(236, 72, 153, 0.15) !important;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
    }
    
    #personelCalendar .fc-col-header-cell-cushion {
        padding: 0.5rem;
    }
    
    /* Gün numaraları */
    #personelCalendar .fc-daygrid-day-number {
        font-weight: 600;
        color: #111827;
        padding: 0.5rem;
        font-size: 0.95rem;
    }
    
    /* Diğer ay günleri - soluk görünüm */
    #personelCalendar .fc-daygrid-day.fc-day-other {
        background-color: #fafafa;
        opacity: 0.6;
    }
    
    #personelCalendar .fc-daygrid-day.fc-day-other .fc-daygrid-day-number {
        color: #9ca3af;
    }
    
    /* Scrollbar stil */
    #personelCalendar .fc-scroller::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }
    
    #personelCalendar .fc-scroller::-webkit-scrollbar-track {
        background: #f1f5f9;
        border-radius: 4px;
    }
    
    #personelCalendar .fc-scroller::-webkit-scrollbar-thumb {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border-radius: 4px;
    }
    
    #personelCalendar .fc-scroller::-webkit-scrollbar-thumb:hover {
        background: linear-gradient(135deg, #be185d 0%, #9f1239 100%);
    }
    
    /* Popover (more link) - modern görünüm */
    #personelCalendar .fc-popover {
        border-radius: 16px;
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
        border: none;
        overflow: hidden;
    }
    
    #personelCalendar .fc-popover-header {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        border-radius: 0;
        padding: 1rem;
        font-weight: 600;
    }
    
    #personelCalendar .fc-popover-body {
        padding: 1rem;
        background: white;
    }
    
    #personelCalendar .fc-popover-close {
        color: white;
        opacity: 0.9;
        font-size: 1.2rem;
    }
    
    #personelCalendar .fc-popover-close:hover {
        opacity: 1;
    }
</style>
@endpush

@section('content')
<div class="container-fluid px-3 px-md-4">
    <div class="row g-3 g-md-4">
        <!-- Rezervasyonlar Listesi -->
        <div class="col-12 col-lg-6">
            <div class="card shadow-sm border-0" style="border-radius: 16px;">
                <div class="card-header d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-calendar-check me-2"></i>Randevularım
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="reservations-list p-3">
                        @php
                            $user = auth()->user();
                            $reservations = \App\Models\Reservation::with(['customer', 'appointmentRequest.service', 'room'])
                                ->where('personel_id', $user->id)
                                ->where('date', '>=', now()->format('Y-m-d'))
                                ->whereNotIn('status', ['cancelled'])
                                ->orderBy('date', 'asc')
                                ->orderBy('start_time', 'asc')
                                ->limit(20)
                                ->get();
                        @endphp
                        
                        @if($reservations->count() > 0)
                            <div class="list-group list-group-flush">
                                @foreach($reservations as $reservation)
                                    <div class="list-group-item reservation-item border-0 mb-2 rounded" style="background: #f9fafb;" onclick="if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $reservation->id }}); } else { window.location.href='{{ route('personel.appointments') }}?highlight={{ $reservation->id }}'; }">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <div class="d-flex align-items-center gap-2 mb-2">
                                                    <h6 class="mb-0 fw-bold">{{ $reservation->customer->name ?? 'Müşteri' }}</h6>
                                                    <span class="badge" style="background: 
                                                        @if($reservation->status === 'completed') #10b981
                                                        @elseif($reservation->status === 'confirmed') #3b82f6
                                                        @elseif($reservation->status === 'open') #f59e0b
                                                        @else #6b7280
                                                        @endif; color: white;">
                                                        @if($reservation->status === 'completed') Tamamlandı
                                                        @elseif($reservation->status === 'confirmed') Onaylı
                                                        @elseif($reservation->status === 'open') Açık
                                                        @else {{ $reservation->status }}
                                                        @endif
                                                    </span>
                                                </div>
                                                <div class="d-flex flex-wrap gap-3 text-muted small mb-2">
                                                    <span><i class="bi bi-calendar3 me-1"></i>{{ \Carbon\Carbon::parse($reservation->date)->format('d.m.Y') }}</span>
                                                    <span><i class="bi bi-clock me-1"></i>{{ $reservation->start_time }}</span>
                                                    @if($reservation->appointmentRequest && $reservation->appointmentRequest->service)
                                                        <span><i class="bi bi-scissors me-1"></i>{{ $reservation->appointmentRequest->service->name }}</span>
                                                    @endif
                                                    @if($reservation->room)
                                                        <span><i class="bi bi-door-open me-1"></i>{{ $reservation->room->name }}</span>
                                                    @endif
                                                </div>
                                                @if($reservation->customer && $reservation->customer->phone)
                                                    <div class="text-muted small">
                                                        <i class="bi bi-telephone me-1"></i>{{ $reservation->customer->phone }}
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-5">
                                <i class="bi bi-calendar-x" style="font-size: 3rem; color: #d1d5db;"></i>
                                <p class="text-muted mt-3 mb-0">Henüz randevu bulunmamaktadır.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Takvim Görünümü -->
        <div class="col-12 col-lg-6">
            <div class="card shadow-sm border-0" style="border-radius: 16px; overflow: hidden;">
                <div class="card-header d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-calendar3 me-2"></i>Takvim
                    </h5>
                </div>
                <div class="card-body calendar-container p-3" style="background: #ffffff;">
                    <div id="personelCalendar"></div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css' rel='stylesheet' />
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales/tr.js'></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('personelCalendar');
    if (calendarEl) {
        const calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: 'tr',
            height: 'auto',
            contentHeight: 'auto',
            headerToolbar: {
                left: 'prev,next',
                center: 'title',
                right: 'today dayGridMonth,timeGridWeek,timeGridDay'
            },
            buttonText: {
                today: 'Bugün',
                month: 'Ay',
                week: 'Hafta',
                day: 'Gün'
            },
            firstDay: 1, // Pazartesi başlangıç
            dayMaxEvents: 3,
            moreLinkClick: 'popover',
            events: function(fetchInfo, successCallback, failureCallback) {
                fetch('{{ route("personel.calendar.feed") }}?start=' + fetchInfo.startStr + '&end=' + fetchInfo.endStr)
                    .then(response => response.json())
                    .then(data => {
                        successCallback(data);
                    })
                    .catch(error => {
                        console.error('Takvim verisi yüklenemedi:', error);
                        failureCallback(error);
                    });
            },
            eventClick: function(info) {
                const reservationId = info.event.extendedProps.reservation_id;
                if (reservationId && typeof window.showReservationDetail === 'function') {
                    window.showReservationDetail(reservationId);
                } else if (reservationId) {
                    window.location.href = '{{ route("personel.appointments") }}?highlight=' + reservationId;
                }
            },
            eventTimeFormat: {
                hour: '2-digit',
                minute: '2-digit',
                hour12: false
            },
            eventDisplay: 'block',
            eventColor: '#ec4899',
            eventTextColor: '#ffffff',
            dayHeaderFormat: { weekday: 'short' },
            dayHeaderContent: function(arg) {
                return arg.text.toUpperCase();
            }
        });
        calendar.render();
    }
});
</script>
@endpush
