@extends('layouts.admin')

@section('title', 'Profil Düzenle')
@section('page-title', 'Profil Düzenle')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-person-circle me-2"></i>Profil Bilgilerim
                    </h5>
                </div>
                <div class="card-body p-4">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    @if($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    <form action="{{ route('personel.profile.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <!-- Profil Fotoğrafı -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <label class="form-label fw-bold mb-3">
                                    <i class="bi bi-image me-2"></i>Profil Fotoğrafı
                                </label>
                                <div class="profile-image-upload-container">
                                    <div class="profile-image-preview-wrapper">
                                        @if($user->profile_image)
                                            <img src="{{ asset('storage/' . $user->profile_image) }}" alt="Profil" id="profileImagePreview" class="profile-image-preview">
                                        @else
                                            <div id="profileImagePreview" class="profile-image-placeholder">
                                                <i class="bi bi-person-circle" style="font-size: 80px; color: white;"></i>
                                                <span class="d-block mt-2" style="color: white; font-size: 14px;">Profil Fotoğrafı Yok</span>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="profile-image-upload-controls">
                                        <input type="file" id="profile_image" name="profile_image" accept="image/jpeg,image/png,image/jpg,image/gif,image/webp" class="d-none" onchange="handleProfileImageUpload(this)">
                                        <button type="button" class="btn btn-primary" onclick="document.getElementById('profile_image').click()">
                                            <i class="bi bi-upload me-2"></i>Fotoğraf Seç
                                        </button>
                                        @if($user->profile_image)
                                        <button type="button" class="btn btn-outline-danger" onclick="removeProfileImage()">
                                            <i class="bi bi-trash me-2"></i>Kaldır
                                        </button>
                                        @endif
                                    </div>
                                    <small class="text-muted d-block mt-2 text-center">
                                        <i class="bi bi-info-circle me-1"></i>Maksimum 5 MB. Desteklenen formatlar: JPG, PNG, GIF, WEBP
                                    </small>
                                    @error('profile_image')
                                        <div class="text-danger small mt-1 text-center">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label fw-semibold">
                                    <i class="bi bi-person me-1"></i>Ad Soyad <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control form-control-lg" id="name" name="name" value="{{ old('name', $user->name) }}" required>
                                @error('name')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label fw-semibold">
                                    <i class="bi bi-envelope me-1"></i>E-posta <span class="text-danger">*</span>
                                </label>
                                <input type="email" class="form-control form-control-lg" id="email" name="email" value="{{ old('email', $user->email) }}" required>
                                @error('email')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label fw-semibold">
                                    <i class="bi bi-telephone me-1"></i>Telefon
                                </label>
                                <input type="tel" class="form-control form-control-lg" id="phone" name="phone" value="{{ old('phone', $user->phone) }}">
                                @error('phone')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="password" class="form-label fw-semibold">
                                    <i class="bi bi-lock me-1"></i>Yeni Şifre
                                </label>
                                <input type="password" class="form-control form-control-lg" id="password" name="password" placeholder="Değiştirmek istemiyorsanız boş bırakın">
                                @error('password')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="password_confirmation" class="form-label fw-semibold">
                                    <i class="bi bi-lock-fill me-1"></i>Şifre Tekrar
                                </label>
                                <input type="password" class="form-control form-control-lg" id="password_confirmation" name="password_confirmation" placeholder="Yeni şifrenizi tekrar girin">
                            </div>
                        </div>
                        
                        <div class="mt-4 d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-save me-2"></i>Güncelle
                            </button>
                            <a href="{{ route('personel.dashboard') }}" class="btn btn-secondary btn-lg">
                                <i class="bi bi-arrow-left me-2"></i>Geri Dön
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .profile-image-upload-container {
        display: flex;
        flex-direction: column;
        gap: 20px;
        padding: 32px;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-radius: 20px;
        border: 2px dashed #e5e7eb;
        transition: all 0.3s ease;
        align-items: center;
    }
    
    .profile-image-upload-container:hover {
        border-color: #ec4899;
        background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%);
    }
    
    .profile-image-preview-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 200px;
    }
    
    .profile-image-preview {
        width: 180px;
        height: 180px;
        border-radius: 50%;
        object-fit: cover;
        border: 5px solid #ec4899;
        box-shadow: 0 12px 32px rgba(236, 72, 153, 0.4);
        transition: all 0.3s ease;
        cursor: pointer;
    }
    
    .profile-image-preview:hover {
        transform: scale(1.05);
        box-shadow: 0 16px 40px rgba(236, 72, 153, 0.5);
    }
    
    .profile-image-placeholder {
        width: 180px;
        height: 180px;
        border-radius: 50%;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        color: white;
        border: 5px solid #ec4899;
        box-shadow: 0 12px 32px rgba(236, 72, 153, 0.4);
        transition: all 0.3s ease;
    }
    
    .profile-image-placeholder:hover {
        transform: scale(1.05);
        box-shadow: 0 16px 40px rgba(236, 72, 153, 0.5);
    }
    
    .profile-image-upload-controls {
        display: flex;
        gap: 12px;
        justify-content: center;
        flex-wrap: wrap;
    }
    
    .form-control-lg {
        border-radius: 12px;
        border: 2px solid #e5e7eb;
        transition: all 0.3s ease;
    }
    
    .form-control-lg:focus {
        border-color: #ec4899;
        box-shadow: 0 0 0 0.2rem rgba(236, 72, 153, 0.25);
    }
    
    .card {
        border-radius: 16px;
        overflow: hidden;
    }
    
    .btn-lg {
        border-radius: 12px;
        padding: 12px 24px;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border: none;
    }
    
    .btn-primary:hover {
        background: linear-gradient(135deg, #be185d 0%, #9f1239 100%);
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(236, 72, 153, 0.4);
    }
</style>
@endpush

@push('scripts')
<script>
    function handleProfileImageUpload(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('profileImagePreview');
                if (preview.tagName === 'IMG') {
                    preview.src = e.target.result;
                } else {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.className = 'profile-image-preview';
                    img.id = 'profileImagePreview';
                    preview.parentNode.replaceChild(img, preview);
                }
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
    
    function removeProfileImage() {
        if (confirm('Profil fotoğrafını kaldırmak istediğinize emin misiniz?')) {
            const input = document.getElementById('profile_image');
            input.value = '';
            const preview = document.getElementById('profileImagePreview');
            const placeholder = document.createElement('div');
            placeholder.id = 'profileImagePreview';
            placeholder.className = 'profile-image-placeholder';
            placeholder.innerHTML = '<i class="bi bi-person-circle" style="font-size: 80px; color: white;"></i><span class="d-block mt-2" style="color: white; font-size: 14px;">Profil Fotoğrafı Yok</span>';
            preview.parentNode.replaceChild(placeholder, preview);
        }
    }
    
    // Profil fotoğrafına tıklandığında dosya seçiciyi aç
    document.addEventListener('DOMContentLoaded', function() {
        const previewWrapper = document.querySelector('.profile-image-preview-wrapper');
        if (previewWrapper) {
            previewWrapper.addEventListener('click', function() {
                document.getElementById('profile_image').click();
            });
        }
        
        // Şifre ve şifre tekrarı kontrolü
        const passwordInput = document.getElementById('password');
        const passwordConfirmationInput = document.getElementById('password_confirmation');
        const form = document.querySelector('form[action*="profile.update"]');
        
        function validatePasswords() {
            const password = passwordInput.value;
            const passwordConfirmation = passwordConfirmationInput.value;
            
            // Şifre tekrarı alanından hata mesajını kaldır
            let errorDiv = passwordConfirmationInput.parentElement.querySelector('.password-error');
            if (errorDiv) {
                errorDiv.remove();
            }
            
            // Şifre girilmişse ama şifre tekrarı girilmemişse veya eşleşmiyorsa hata göster
            if (password) {
                if (!passwordConfirmation) {
                    errorDiv = document.createElement('div');
                    errorDiv.className = 'text-danger small password-error mt-1';
                    errorDiv.textContent = 'Şifre tekrarı gereklidir!';
                    passwordConfirmationInput.parentElement.appendChild(errorDiv);
                    passwordConfirmationInput.setCustomValidity('Şifre tekrarı gereklidir');
                    return false;
                } else if (password !== passwordConfirmation) {
                    errorDiv = document.createElement('div');
                    errorDiv.className = 'text-danger small password-error mt-1';
                    errorDiv.textContent = 'Şifreler eşleşmiyor!';
                    passwordConfirmationInput.parentElement.appendChild(errorDiv);
                    passwordConfirmationInput.setCustomValidity('Şifreler eşleşmiyor');
                    return false;
                } else {
                    passwordConfirmationInput.setCustomValidity('');
                    return true;
                }
            } else {
                // Şifre girilmemişse, şifre tekrarı da boş olmalı
                if (passwordConfirmation) {
                    errorDiv = document.createElement('div');
                    errorDiv.className = 'text-danger small password-error mt-1';
                    errorDiv.textContent = 'Önce şifre girmelisiniz!';
                    passwordConfirmationInput.parentElement.appendChild(errorDiv);
                    passwordConfirmationInput.setCustomValidity('Önce şifre girmelisiniz');
                    return false;
                } else {
                    passwordConfirmationInput.setCustomValidity('');
                    return true;
                }
            }
        }
        
        if (passwordInput && passwordConfirmationInput) {
            passwordInput.addEventListener('input', validatePasswords);
            passwordConfirmationInput.addEventListener('input', validatePasswords);
        }
        
        // Form submit kontrolü
        if (form) {
            form.addEventListener('submit', function(e) {
                if (!validatePasswords()) {
                    e.preventDefault();
                    e.stopPropagation();
                    return false;
                }
            });
        }
    });
</script>
@endpush
@endsection


