<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $contract->name }} - Sözleşme</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="{{ url('favicon.png?v=3') }}">
    <link rel="shortcut icon" href="{{ url('favicon.png?v=3') }}">
    <link rel="apple-touch-icon" href="{{ url('favicon.png?v=3') }}">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        .contract-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .contract-header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .contract-header h1 {
            margin: 0;
            font-size: 1.8rem;
            font-weight: 700;
        }
        .contract-header p {
            margin: 10px 0 0;
            opacity: 0.9;
        }
        .contract-body {
            padding: 40px;
        }
        .contract-content {
            line-height: 1.8;
            color: #333;
            text-align: justify;
        }
        .contract-content p {
            margin-bottom: 15px;
        }
        .contract-footer {
            background: #f8f9fa;
            padding: 20px 40px;
            text-align: center;
            border-top: 1px solid #e9ecef;
        }
        .logo-text {
            font-size: 24px;
            font-weight: bold;
            color: white;
            margin-bottom: 5px;
        }
        @media print {
            body {
                background: white;
                padding: 0;
            }
            .contract-container {
                box-shadow: none;
                border-radius: 0;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="contract-container">
        <div class="contract-header">
            <div class="logo-text">Salonay</div>
            <h1>{{ $contract->name }}</h1>
            <p>Sözleşme Belgesi</p>
        </div>
        
        <div class="contract-body">
            <div class="contract-content">
                {!! nl2br(e($contract->content)) !!}
            </div>
        </div>
        
        <div class="contract-footer">
            <p class="text-muted mb-2">Bu sözleşme dijital ortamda oluşturulmuştur.</p>
            <button onclick="window.print()" class="btn btn-outline-primary no-print">
                <i class="bi bi-printer"></i> Yazdır
            </button>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</body>
</html>
