<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fatura - {{ $invoice->invoice_number }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        :root {
            --primary-color: #ec4899;
            --secondary-color: #be185d;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .invoice-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
        }
        
        .invoice-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .invoice-header h1 {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .invoice-number {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .status-badge {
            display: inline-block;
            padding: 8px 20px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 600;
            margin-top: 15px;
        }
        
        .status-approved {
            background: #ec4899;
            color: white;
        }
        
        .status-draft {
            background: #f59e0b;
            color: white;
        }
        
        .status-sent {
            background: #f472b6;
            color: white;
        }
        
        .invoice-body {
            padding: 30px;
        }
        
        .info-section {
            margin-bottom: 30px;
        }
        
        .info-section h5 {
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e5e7eb;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .info-label {
            color: #6b7280;
            font-size: 14px;
        }
        
        .info-value {
            font-weight: 600;
            color: #1f2937;
        }
        
        .items-table {
            width: 100%;
            margin-bottom: 30px;
        }
        
        .items-table th {
            background: #f8fafc;
            padding: 12px;
            font-size: 13px;
            color: #6b7280;
            text-transform: uppercase;
            font-weight: 600;
            border-bottom: 2px solid #e5e7eb;
        }
        
        .items-table td {
            padding: 15px 12px;
            border-bottom: 1px solid #f3f4f6;
            font-size: 14px;
        }
        
        .items-table .text-end {
            text-align: right;
        }
        
        .totals-section {
            background: #f8fafc;
            border-radius: 12px;
            padding: 20px;
            margin-top: 20px;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            font-size: 15px;
        }
        
        .total-row.grand-total {
            border-top: 2px solid var(--primary-color);
            margin-top: 10px;
            padding-top: 15px;
            font-size: 20px;
            font-weight: 700;
            color: var(--primary-color);
        }
        
        .total-row.remaining {
            color: #dc2626;
            font-weight: 700;
            font-size: 22px;
        }
        
        .download-btn {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
        }
        
        .download-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(236, 72, 153, 0.4);
            color: white;
        }
        
        /* Yazdırma Stilleri */
        @media print {
            body {
                background: white !important;
                padding: 0 !important;
            }
            
            .download-btn,
            button.download-btn {
                display: none !important;
            }
            
            .invoice-card {
                box-shadow: none !important;
                border-radius: 0 !important;
            }
            
            .invoice-header {
                page-break-inside: avoid;
            }
            
            .invoice-body {
                page-break-inside: avoid;
            }
        }
        
        .company-info {
            text-align: center;
            padding: 20px;
            background: #f8fafc;
            border-top: 1px solid #e5e7eb;
        }
        
        .company-info img {
            max-height: 50px;
            margin-bottom: 10px;
        }
        
        .company-info .company-name {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary-color);
        }
        
        .company-info .company-contact {
            font-size: 13px;
            color: #6b7280;
        }
        
        @media (max-width: 768px) {
            body {
                padding: 10px;
            }
            
            .invoice-container {
                max-width: 100%;
            }
            
            .invoice-header {
                padding: 20px 15px;
            }
            
            .invoice-header h1 {
                font-size: 20px;
            }
            
            .invoice-number {
                font-size: 14px;
            }
            
            .status-badge {
                font-size: 12px;
                padding: 6px 15px;
                margin-top: 10px;
            }
            
            .invoice-body {
                padding: 20px 15px;
            }
            
            .info-section {
                margin-bottom: 20px;
            }
            
            .info-section h5 {
                font-size: 16px;
                margin-bottom: 12px;
            }
            
            .info-row {
                flex-direction: column;
                gap: 4px;
                padding: 10px 0;
            }
            
            .info-label {
                font-weight: 600;
                color: #6b7280;
            }
            
            .items-table {
                font-size: 11px;
                display: block;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
            
            .items-table thead,
            .items-table tbody,
            .items-table tr {
                display: block;
            }
            
            .items-table thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            
            .items-table tbody tr {
                border: 1px solid #e5e7eb;
                border-radius: 8px;
                margin-bottom: 10px;
                padding: 10px;
                background: #f9fafb;
            }
            
            .items-table td {
                display: block;
                text-align: right !important;
                padding: 6px 0;
                border: none;
                position: relative;
                padding-left: 50%;
            }
            
            .items-table td:before {
                content: attr(data-label);
                position: absolute;
                left: 0;
                width: 45%;
                text-align: left;
                font-weight: 600;
                color: #6b7280;
            }
            
            .items-table th, .items-table td {
                padding: 8px 6px;
            }
            
            .total-section {
                margin-top: 20px;
            }
            
            .total-row {
                flex-direction: column;
                gap: 8px;
                padding: 12px 0;
            }
            
            .company-info {
                margin-top: 20px;
            }
            
            .company-info h4 {
                font-size: 16px;
            }
            
            .company-info .company-contact {
                font-size: 12px;
            }
        }
        
        @media (max-width: 576px) {
            .invoice-header h1 {
                font-size: 18px;
            }
            
            .invoice-body {
                padding: 15px 10px;
            }
            
            .items-table {
                font-size: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="invoice-card">
            <div class="invoice-header">
                <h1><i class="bi bi-receipt"></i> FATURA</h1>
                <div class="invoice-number">{{ $invoice->invoice_number }}</div>
                
                @if($invoice->is_approved)
                    <span class="status-badge status-approved">
                        <i class="bi bi-check-circle"></i> Onaylandı
                    </span>
                @elseif($invoice->status == 'sent')
                    <span class="status-badge status-sent">
                        <i class="bi bi-send"></i> Gönderildi
                    </span>
                @else
                    <span class="status-badge status-draft">
                        <i class="bi bi-clock"></i> Beklemede
                    </span>
                @endif
            </div>
            
            <div class="invoice-body">
                <!-- Müşteri ve Randevu/İşlem Bilgileri -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-section">
                            @if($invoice->reservation)
                                <h5><i class="bi bi-person"></i> Müşteri Bilgileri</h5>
                                <div class="info-row">
                                    <span class="info-label">Ad Soyad</span>
                                    <span class="info-value">{{ $invoice->customer->name ?? $invoice->reservation->customer->name ?? '-' }}</span>
                                </div>
                                <div class="info-row">
                                    <span class="info-label">Telefon</span>
                                    <span class="info-value">{{ $invoice->customer->phone ?? $invoice->reservation->customer->phone ?? '-' }}</span>
                                </div>
                            @else
                                <h5><i class="bi bi-info-circle"></i> İşlem Bilgileri</h5>
                                @if($transaction)
                                    <div class="info-row">
                                        <span class="info-label">İşlem Tipi</span>
                                        <span class="info-value">
                                            @if($transaction->type === 'income')
                                                <span class="badge bg-success">Gelir</span>
                                            @else
                                                <span class="badge bg-danger">Gider</span>
                                            @endif
                                        </span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Açıklama</span>
                                        <span class="info-value">{{ $transaction->description ?? '-' }}</span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">İşlem Tarihi</span>
                                        <span class="info-value">{{ $transaction->date ? $transaction->date->format('d.m.Y') : ($transaction->created_at ? $transaction->created_at->format('d.m.Y') : '-') }}</span>
                                    </div>
                                    @if($transaction->customer)
                                        <div class="info-row">
                                            <span class="info-label">Müşteri</span>
                                            <span class="info-value">{{ $transaction->customer->name ?? '-' }}</span>
                                        </div>
                                    @endif
                                @else
                                    <div class="info-row">
                                        <span class="info-label">Fatura Tarihi</span>
                                        <span class="info-value">{{ $invoice->invoice_date ? $invoice->invoice_date->format('d.m.Y') : '-' }}</span>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-section">
                            @if($invoice->reservation)
                                <h5><i class="bi bi-calendar3"></i> Randevu Bilgileri</h5>
                                @php
                                    $salonName = '-';
                                    if ($invoice->reservation->beauty_salon_id) {
                                        $beautySalon = \App\Models\User::find($invoice->reservation->beauty_salon_id);
                                        if ($beautySalon) {
                                            $salonName = $beautySalon->salon_name ?? $beautySalon->name ?? 'Güzellik Salonu';
                                        }
                                    } elseif ($invoice->reservation->salon) {
                                        $salonName = $invoice->reservation->salon->name ?? 'Güzellik Salonu';
                                    }
                                @endphp
                                <div class="info-row">
                                    <span class="info-label">Salon</span>
                                    <span class="info-value">{{ $salonName }}</span>
                                </div>
                                <div class="info-row">
                                    <span class="info-label">Tarih</span>
                                    <span class="info-value">{{ $invoice->reservation->date ? $invoice->reservation->date->format('d.m.Y') : '-' }}</span>
                                </div>
                                <div class="info-row">
                                    <span class="info-label">Saat</span>
                                    <span class="info-value">{{ $invoice->reservation->start_time ?? '-' }} - {{ $invoice->reservation->end_time ?? '-' }}</span>
                                </div>
                            @else
                                <h5><i class="bi bi-calendar3"></i> Fatura Bilgileri</h5>
                                <div class="info-row">
                                    <span class="info-label">Fatura Tarihi</span>
                                    <span class="info-value">{{ $invoice->invoice_date ? $invoice->invoice_date->format('d.m.Y') : '-' }}</span>
                                </div>
                                <div class="info-row">
                                    <span class="info-label">Fatura No</span>
                                    <span class="info-value">{{ $invoice->invoice_number ?? '-' }}</span>
                                </div>
                                @if($transaction && $transaction->account)
                                    <div class="info-row">
                                        <span class="info-label">Hesap</span>
                                        <span class="info-value">{{ $transaction->account->name ?? '-' }}</span>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
                
                <!-- Fatura Kalemleri -->
                <div class="info-section">
                    <h5><i class="bi bi-list-ul"></i> Fatura Kalemleri</h5>
                    <table class="items-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Açıklama</th>
                                <th class="text-end">Miktar</th>
                                <th class="text-end">B. Fiyat</th>
                                <th class="text-end">Toplam</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $itemsJson = $invoice->items_json;
                                // Eğer items_json metadata formatında ise (transaction_id içeriyorsa)
                                if (is_array($itemsJson) && isset($itemsJson['items']) && is_array($itemsJson['items'])) {
                                    $items = $itemsJson['items'];
                                } elseif (is_array($itemsJson) && isset($itemsJson[0]) && is_array($itemsJson[0])) {
                                    // Eski format: direkt items array
                                    $items = $itemsJson;
                                } else {
                                    $items = [];
                                }
                            @endphp
                            @if(!empty($items))
                                @foreach($items as $item)
                                    <tr>
                                        <td data-label="#">{{ $item['number'] ?? $loop->iteration }}</td>
                                        <td data-label="Açıklama">{{ $item['name'] ?? '-' }}</td>
                                        <td class="text-end" data-label="Miktar">{{ $item['quantity'] ?? '-' }}</td>
                                        <td class="text-end" data-label="Birim Fiyat">{{ number_format($item['price'] ?? 0, 2, ',', '.') }} ₺</td>
                                        <td class="text-end" data-label="Toplam"><strong>{{ number_format($item['total'] ?? 0, 2, ',', '.') }} ₺</strong></td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5" class="text-center text-muted">Kalem bulunamadı</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                
                <!-- Toplamlar -->
                <div class="totals-section">
                    <div class="total-row">
                        <span>Ara Toplam</span>
                        <span><strong>{{ number_format($invoice->total_amount, 2, ',', '.') }} ₺</strong></span>
                    </div>
                    <div class="total-row" style="color: #ec4899;">
                        <span><i class="bi bi-check-circle"></i> Alınan Kapora</span>
                        <span><strong>- {{ number_format($invoice->deposit_paid, 2, ',', '.') }} ₺</strong></span>
                    </div>
                    <div class="total-row grand-total">
                        <span>GENEL TOPLAM</span>
                        <span>{{ number_format($invoice->total_amount, 2, ',', '.') }} ₺</span>
                    </div>
                </div>
                
                <!-- PDF İndirme ve Yazdırma Butonları -->
                <div class="text-center mt-4 d-flex gap-2 justify-content-center flex-wrap">
                    <a href="{{ url('/fatura/' . $invoice->public_token . '/pdf') }}" class="download-btn">
                        <i class="bi bi-download"></i> PDF Olarak İndir
                    </a>
                    <button type="button" onclick="window.print()" class="download-btn" style="background: linear-gradient(135deg, #ec4899 0%, #db2777 100%);">
                        <i class="bi bi-printer"></i> Yazdır
                    </button>
                </div>
                
                <!-- Sözleşme Onay Bilgisi -->
                @if(isset($contractUrl) && $contractUrl)
                <div class="contract-section mt-4" style="background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%); border-radius: 12px; padding: 20px;">
                    <div class="d-flex flex-column flex-md-row align-items-center justify-content-between gap-3">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-file-earmark-check text-primary" style="font-size: 2rem;"></i>
                            <div class="ms-3">
                                <strong class="text-dark">Müşteri sözleşmeyi okumuş ve onaylamıştır.</strong>
                                <div class="text-muted small">Sözleşme detaylarını görüntülemek için butona tıklayın.</div>
                            </div>
                        </div>
                        <a href="{{ $contractUrl }}" target="_blank" class="btn btn-primary" style="border-radius: 50px; padding: 10px 25px;">
                            <i class="bi bi-eye me-2"></i>Sözleşmeyi Görüntüle
                        </a>
                    </div>
                </div>
                @endif
            </div>
            
            <!-- Firma Bilgileri -->
            <div class="company-info">
                @if($logo)
                    <img src="{{ asset('storage/' . $logo) }}" alt="Logo">
                @else
                    <div class="company-name">{{ $companyName }}</div>
                @endif
                <div class="company-contact">
                    @if($companyPhone)<i class="bi bi-telephone"></i> {{ $companyPhone }} @endif
                    @if($companyPhone && $companyEmail) | @endif
                    @if($companyEmail)<i class="bi bi-envelope"></i> {{ $companyEmail }} @endif
                </div>
                <div class="mt-2 text-muted" style="font-size: 12px;">
                    Fatura Tarihi: {{ $invoice->invoice_date ? $invoice->invoice_date->format('d.m.Y') : now()->format('d.m.Y') }}
                </div>
            </div>
        </div>
        
        <div class="text-center mt-4 text-white opacity-75" style="font-size: 13px;">
            <i class="bi bi-shield-check"></i> Bu fatura {{ $companyName }} tarafından oluşturulmuştur.
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
