<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $salon->name }} - Kart Programı</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .loyalty-card {
            max-width: 400px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .card-header {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .card-header h1 {
            font-size: 24px;
            font-weight: bold;
            margin: 0;
        }
        .card-header p {
            margin: 5px 0 0 0;
            opacity: 0.9;
        }
        .card-body {
            padding: 30px;
        }
        .customer-info {
            text-align: center;
            margin-bottom: 30px;
        }
        .customer-name {
            font-size: 22px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
        }
        .customer-phone {
            color: #6b7280;
            font-size: 14px;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
            padding: 20px;
            border-radius: 12px;
            text-align: center;
        }
        .stat-value {
            font-size: 32px;
            font-weight: bold;
            color: #0ea5e9;
            margin-bottom: 5px;
        }
        .stat-label {
            font-size: 12px;
            color: #64748b;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .tier-section {
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
        }
        .tier-name {
            font-size: 18px;
            font-weight: bold;
            color: #92400e;
            margin-bottom: 10px;
        }
        .progress-bar-container {
            background: white;
            border-radius: 10px;
            height: 20px;
            overflow: hidden;
            margin-bottom: 10px;
        }
        .progress-bar-fill {
            background: linear-gradient(90deg, #f59e0b 0%, #d97706 100%);
            height: 100%;
            transition: width 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 11px;
            font-weight: bold;
        }
        .next-tier-info {
            font-size: 12px;
            color: #78350f;
        }
        .points-display {
            text-align: center;
            padding: 20px;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: white;
            border-radius: 12px;
            margin-bottom: 20px;
        }
        .points-value {
            font-size: 48px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .points-label {
            font-size: 14px;
            opacity: 0.9;
        }
        .stamp-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 10px;
            margin-top: 20px;
        }
        .stamp {
            aspect-ratio: 1;
            border: 3px dashed #cbd5e1;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f8f9fa;
            position: relative;
        }
        .stamp.filled {
            border-color: #10b981;
            background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
        }
        .stamp.filled::after {
            content: '✓';
            color: #10b981;
            font-size: 24px;
            font-weight: bold;
        }
        .footer {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            color: #6b7280;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="loyalty-card">
        <div class="card-header">
            <h1><i class="bi bi-credit-card me-2"></i>{{ $salon->name }}</h1>
            <p>Kart Programı</p>
        </div>
        
        <div class="card-body">
            <div class="customer-info">
                <div class="customer-name">{{ $customer->name }}</div>
                <div class="customer-phone">{{ $customer->phone }}</div>
            </div>

            <div class="points-display">
                <div class="points-value">{{ number_format($totalPoints, 0) }}</div>
                <div class="points-label">Toplam Puan</div>
            </div>

            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-value">{{ $completedReservations }}</div>
                    <div class="stat-label">Randevu</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">{{ $currentTier ? $currentTier->level : '-' }}</div>
                    <div class="stat-label">Seviye</div>
                </div>
            </div>

            @if($currentTier)
            <div class="tier-section">
                <div class="tier-name">
                    <i class="bi bi-trophy-fill me-2"></i>{{ $currentTier->name }}
                </div>
                @if($nextTier)
                    @php
                        $progress = $nextTier->min_visits > 0 
                            ? min(100, ($completedReservations / $nextTier->min_visits) * 100)
                            : 0;
                    @endphp
                    <div class="progress-bar-container">
                        <div class="progress-bar-fill" style="width: {{ $progress }}%">
                            @if($progress > 20){{ $completedReservations }}/{{ $nextTier->min_visits }}@endif
                        </div>
                    </div>
                    <div class="next-tier-info">
                        Sonraki seviye: <strong>{{ $nextTier->name }}</strong> için {{ $nextTier->min_visits }} randevu gerekli
                    </div>
                @else
                    <div class="next-tier-info">
                        <strong>Maksimum seviyeye ulaştınız! 🎉</strong>
                    </div>
                @endif
            </div>
            @endif

            <!-- Stamp Grid (5x5 = 25 stamp) -->
            <div>
                <h6 class="mb-3" style="color: #1f2937; font-weight: bold;">
                    <i class="bi bi-calendar-check me-2"></i>Randevu Damgaları
                </h6>
                <div class="stamp-grid">
                    @for($i = 1; $i <= 25; $i++)
                        <div class="stamp {{ $i <= $completedReservations ? 'filled' : '' }}"></div>
                    @endfor
                </div>
                <p class="text-center text-muted mt-3" style="font-size: 12px;">
                    {{ $completedReservations }}/25 randevu tamamlandı
                </p>
            </div>
        </div>

        <div class="footer">
            <p class="mb-0">salonay.com</p>
            <p class="mb-0" style="font-size: 10px;">Bu kart sadece {{ $salon->name }} için geçerlidir.</p>
        </div>
    </div>
</body>
</html>

