<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ url('favicon.png') }}?v=3">
    <link rel="shortcut icon" href="{{ url('favicon.png') }}?v=3">
    <link rel="apple-touch-icon" href="{{ url('favicon.png') }}?v=3">
    
    @php
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key');
        } catch (\Exception $e) {
            $settings = collect([]);
        }
        $phone = $settings['phone'] ?? '0850 811 08 20';
        $email = $settings['email'] ?? 'info@salonay.com';
        $companyName = $settings['company_name'] ?? 'Salonay';
        $address = $settings['address'] ?? '';
    @endphp
    
    <title>Salonlarımız - {{ $companyName }}</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600;700;800;900&family=Montserrat:wght@700;800;900&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #ec4899;
            --secondary-blue: #f472b6;
            --light-blue: #f9a8d4;
            --dark-blue: #be185d;
            --dark-color: #1e293b;
            --light-color: #f8fafc;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            overflow-x: hidden;
            scroll-behavior: smooth;
            color: #1e293b;
            padding-top: 0 !important;
        }
        
        /* Top Promo Banner */
        .top-promo-banner {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 100%);
            color: white;
            padding: 12px 0;
            text-align: center;
            font-size: 14px;
            font-weight: 600;
            position: relative;
            z-index: 1001;
        }
        
        .top-promo-banner a {
            color: white;
            text-decoration: underline;
            font-weight: 700;
        }
        
        /* Navbar */
        .navbar {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 0.5rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .navbar-brand {
            display: flex;
            align-items: center;
            text-decoration: none;
        }
        
        .logo-image {
            height: 50px;
            width: auto;
            object-fit: contain;
        }
        
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ url("fonts/font.ttf") }}') format('truetype'),
                 url('{{ asset("fonts/font.ttf") }}') format('truetype'),
                 url('/fonts/font.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
        
        .logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 36px;
            letter-spacing: 2.5px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 25%, #fbcfe8 50%, #f472b6 75%, #ec4899 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradient 3s ease infinite;
            padding: 6px 16px;
            border-radius: 14px;
            overflow: hidden;
        }
        
        @keyframes logoGradient {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        .logo-text:hover {
            transform: scale(1.1) translateY(-3px);
            letter-spacing: 3.5px;
            animation-duration: 1.5s;
        }
        
        .nav-link {
            font-weight: 500;
            color: #1e293b !important;
            margin: 0 0.5rem;
            transition: color 0.3s;
        }
        
        .nav-link:hover, .nav-link.active {
            color: var(--primary-blue) !important;
        }
        
        .navbar-phone {
            color: #1e293b;
            font-weight: 600;
            margin-right: 1rem;
            font-size: 0.875rem;
        }
        
        .navbar .btn {
            padding: 0.5rem 1.25rem;
            font-size: 0.9rem;
            font-weight: 600;
            border-radius: 8px;
            white-space: nowrap;
            transition: all 0.3s ease;
        }
        
        .navbar .btn-primary {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            color: white;
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
        }
        
        .navbar .btn-primary:hover {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.4);
        }
        
        .navbar .btn-outline-primary {
            border: 2px solid var(--primary-blue);
            color: var(--primary-blue);
            background: transparent;
            padding: 0.5rem 1.25rem;
        }
        
        .navbar .btn-outline-primary:hover {
            background: var(--primary-blue);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
        }
        
        /* Hero Section */
        .salons-hero {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 50%, #f472b6 100%);
            color: white;
            padding: 60px 0 40px;
            position: relative;
            overflow: hidden;
        }
        
        .salons-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 30% 50%, rgba(255,255,255,0.1) 0%, transparent 50%),
                        radial-gradient(circle at 70% 80%, rgba(255,255,255,0.1) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .salons-hero h1 {
            font-size: 3rem;
            font-weight: 900;
            margin-bottom: 1rem;
            line-height: 1.2;
            position: relative;
            z-index: 1;
        }
        
        .salons-hero p {
            font-size: 1.15rem;
            margin-bottom: 0;
            opacity: 0.95;
            position: relative;
            z-index: 1;
        }
        
        /* Content Section */
        .salons-content {
            padding: 60px 0;
            background: #f8fafc;
        }
        
        .section-title {
            font-size: 2.5rem;
            font-weight: 900;
            text-align: center;
            margin-bottom: 1rem;
            color: #1e293b;
        }
        
        .section-subtitle {
            text-align: center;
            font-size: 1.1rem;
            color: #64748b;
            margin-bottom: 3rem;
            max-width: 800px;
            margin-left: auto;
            margin-right: auto;
        }
        
        /* Filter Card */
        .filter-card {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
            margin-bottom: 3rem;
            border: 1px solid #e2e8f0;
        }
        
        .form-label {
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 0.5rem;
        }
        
        .form-control, .form-select {
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            padding: 0.75rem 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #ec4899;
            box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.1);
            outline: none;
        }
        
        .btn-filter {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            color: white;
            padding: 0.75rem 2rem;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            width: 100%;
        }
        
        .btn-filter:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(236, 72, 153, 0.3);
            color: white;
        }
        
        .btn-clear {
            background: #f8fafc;
            border: 2px solid #e2e8f0;
            color: #64748b;
            padding: 0.5rem 1.5rem;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-clear:hover {
            background: #e2e8f0;
            color: #1e293b;
        }
        
        /* Salon Cards */
        .salon-card {
            background: white;
            border-radius: 16px;
            padding: 0;
            height: 100%;
            transition: all 0.3s ease;
            border: 1px solid #e2e8f0;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        
        .salon-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 32px rgba(236, 72, 153, 0.15);
            border-color: #ec4899;
        }
        
        .salon-card img {
            width: 100%;
            height: 220px;
            object-fit: cover;
        }
        
        .salon-card-placeholder {
            width: 100%;
            height: 220px;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .salon-card-placeholder i {
            font-size: 4.5rem;
            color: white;
            opacity: 0.8;
        }
        
        .salon-card .card-body {
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
        }
        
        .salon-card h5 {
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 0.75rem;
            color: #0f172a;
        }
        
        .salon-card h5 a {
            color: #0f172a;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .salon-card h5 a:hover {
            color: #ec4899;
        }
        
        .salon-card .rating {
            margin-bottom: 0.75rem;
        }
        
        .salon-card .rating i {
            color: #fbbf24;
            font-size: 1rem;
            margin-right: 2px;
        }
        
        .salon-card .rating-text {
            color: #64748b;
            font-size: 0.875rem;
            margin-left: 0.5rem;
        }
        
        .salon-card .address {
            color: #64748b;
            font-size: 0.9rem;
            margin-bottom: 1rem;
            line-height: 1.5;
        }
        
        .salon-card .address i {
            margin-right: 0.5rem;
            color: #ec4899;
        }
        
        .salon-card .description {
            color: #64748b;
            font-size: 0.875rem;
            margin-bottom: 1rem;
            flex-grow: 1;
            line-height: 1.6;
        }
        
        .salon-card .btn-view {
            width: 100%;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            text-decoration: none;
            text-align: center;
        }
        
        .salon-card .btn-view:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(236, 72, 153, 0.3);
            color: white;
        }
        
        /* Empty State */
        .empty-state {
            background: white;
            border-radius: 16px;
            padding: 4rem 2rem;
            text-align: center;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        }
        
        .empty-state i {
            font-size: 4rem;
            color: #cbd5e1;
            margin-bottom: 1.5rem;
        }
        
        .empty-state h3 {
            font-size: 1.5rem;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 0.5rem;
        }
        
        .empty-state p {
            color: #64748b;
            font-size: 1rem;
        }
        
        /* Footer */
        .footer {
            background: #1e293b;
            color: white;
            padding: 60px 0 30px;
            margin-top: 80px;
        }
        
        .footer h5 {
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.1rem;
            color: white;
        }
        
        .footer a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer a:hover {
            color: white;
        }
        
        .footer .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 2rem;
            margin-top: 2rem;
            text-align: center;
            color: rgba(255,255,255,0.5);
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .top-promo-banner {
                display: none !important;
            }
            
            .navbar {
                padding: 0.75rem 0;
            }
            
            .logo-text {
                font-size: 28px !important;
                letter-spacing: 1.5px !important;
            }
            
            .salons-hero {
                padding: 40px 0 30px;
                text-align: center;
            }
            
            .salons-hero h1 {
                font-size: 2rem;
            }
            
            .salons-hero p {
                font-size: 1rem;
            }
            
            .section-title {
                font-size: 2rem;
            }
            
            .section-subtitle {
                font-size: 1rem;
            }
            
            .filter-card {
                padding: 1.5rem;
            }
            
            .navbar .d-flex {
                flex-direction: column;
                width: 100%;
                gap: 0.75rem !important;
                padding: 1rem 0;
            }
            
            .navbar-phone {
                margin: 0;
                text-align: center;
            }
            
            .navbar .btn {
                width: 100%;
                margin-right: 0 !important;
            }
        }
    </style>
</head>
<body>
    <!-- Top Promo Banner -->
    <div class="top-promo-banner">
        <div class="container">
            <div class="d-flex align-items-center justify-content-center flex-wrap gap-2">
                <strong>Salon Randevu Yönetim Sisteminde Özel Fırsat! %50'ye Varan İndirim!</strong>
                <span>•</span>
                <strong>Hemen Başla, İlk Ay Ücretsiz!</strong>
            </div>
        </div>
    </div>
    
    <!-- Navbar -->
    @include('partials.navbar')
    
    <!-- Hero Section -->
    <section class="salons-hero">
        <div class="container">
            <h1>Salonlarımız</h1>
            <p>Tüm salonlarımızı keşfedin ve en iyi hizmeti bulun</p>
        </div>
    </section>
    
    <!-- Content Section -->
    <section class="salons-content">
        <div class="container">
            <!-- Filtreleme Formu -->
            <div class="filter-card">
                <form method="GET" action="{{ route('public.salons.index') }}" class="row g-3">
                    <div class="col-md-4">
                        <label for="search" class="form-label">
                            <i class="bi bi-search me-2"></i>Salon Adı
                        </label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ $search }}" placeholder="Salon adı ara...">
                    </div>
                    <div class="col-md-3">
                        <label for="city" class="form-label">
                            <i class="bi bi-geo-alt me-2"></i>İl
                        </label>
                        <select class="form-select" id="city" name="city">
                            <option value="">Tüm İller</option>
                            @foreach($cities as $cityItem)
                                <option value="{{ $cityItem }}" {{ $city == $cityItem ? 'selected' : '' }}>
                                    {{ $cityItem }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="district" class="form-label">
                            <i class="bi bi-geo-alt-fill me-2"></i>İlçe
                        </label>
                        <select class="form-select" id="district" name="district">
                            <option value="">Tüm İlçeler</option>
                            @foreach($districts as $districtItem)
                                <option value="{{ $districtItem }}" {{ $district == $districtItem ? 'selected' : '' }}>
                                    {{ $districtItem }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-filter">
                            <i class="bi bi-funnel me-2"></i>Filtrele
                        </button>
                    </div>
                </form>
                @if($search || $city || $district)
                    <div class="mt-3">
                        <a href="{{ route('public.salons.index') }}" class="btn btn-clear">
                            <i class="bi bi-x-circle me-2"></i>Filtreleri Temizle
                        </a>
                    </div>
                @endif
            </div>
            
            <!-- Salon Listesi -->
            <div class="row g-4">
                @forelse($salons as $salon)
                    <div class="col-md-6 col-lg-4">
                        <div class="salon-card">
                            @if($salon->salon_profile_image)
                                <img src="{{ asset('storage/' . $salon->salon_profile_image) }}" 
                                     alt="{{ $salon->salon_name ?? $salon->name }}">
                            @else
                                <div class="salon-card-placeholder">
                                    <i class="bi bi-shop"></i>
                                </div>
                            @endif
                            <div class="card-body">
                                <h5>
                                    <a href="{{ route('public.salon.show', $salon->salon_slug) }}">
                                        {{ $salon->salon_name ?? $salon->name }}
                                    </a>
                                </h5>
                                
                                @if($salon->average_rating > 0)
                                    <div class="rating">
                                        @for($i = 1; $i <= 5; $i++)
                                            @if($i <= floor($salon->average_rating))
                                                <i class="bi bi-star-fill"></i>
                                            @elseif($i - 0.5 <= $salon->average_rating)
                                                <i class="bi bi-star-half"></i>
                                            @else
                                                <i class="bi bi-star"></i>
                                            @endif
                                        @endfor
                                        <span class="rating-text">
                                            {{ number_format($salon->average_rating, 1) }} ({{ $salon->rating_count }} değerlendirme)
                                        </span>
                                    </div>
                                @else
                                    <div class="rating">
                                        <span class="rating-text text-muted">Henüz değerlendirme yok</span>
                                    </div>
                                @endif
                                
                                @if($salon->salon_address)
                                    <div class="address">
                                        <i class="bi bi-geo-alt"></i>
                                        {{ $salon->salon_address }}
                                        @if($salon->salon_district)
                                            , {{ $salon->salon_district }}
                                        @endif
                                        @if($salon->salon_city)
                                            / {{ $salon->salon_city }}
                                        @endif
                                    </div>
                                @endif
                                
                                @if($salon->salon_description)
                                    <div class="description">
                                        {{ \Illuminate\Support\Str::limit(strip_tags($salon->salon_description), 120) }}
                                    </div>
                                @endif
                                
                                <a href="{{ route('public.salon.show', $salon->salon_slug) }}" class="btn-view">
                                    <i class="bi bi-arrow-right me-2"></i>Detayları Gör
                                </a>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12">
                        <div class="empty-state">
                            <i class="bi bi-inbox"></i>
                            <h3>Aradığınız kriterlere uygun salon bulunamadı</h3>
                            <p>Filtrelerinizi değiştirerek tekrar deneyin veya tüm salonları görüntüleyin.</p>
                            <a href="{{ route('public.salons.index') }}" class="btn btn-filter mt-3" style="width: auto; display: inline-block;">
                                <i class="bi bi-arrow-clockwise me-2"></i>Filtreleri Temizle
                            </a>
                        </div>
                    </div>
                @endforelse
            </div>
        </div>
    </section>
    
    <!-- Footer -->
    @include('partials.footer')
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    // İl seçildiğinde formu submit et
    document.getElementById('city')?.addEventListener('change', function() {
        const city = this.value;
        const districtSelect = document.getElementById('district');
        
        if (city) {
            // İl seçildiğinde ilçe listesini güncellemek için formu submit et
            this.form.submit();
        } else {
            // İl seçilmediyse ilçe seçimini temizle
            districtSelect.value = '';
        }
    });
    </script>
</body>
</html>
