<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $salon->salon_name }} - Değerlendirme</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(135deg, #fdf2f8 0%, #fce7f3 50%, #fbcfe8 100%);
            min-height: 100vh;
            padding: 40px 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .rating-container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            padding: 40px;
        }
        .salon-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .salon-header img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 15px;
        }
        .star-rating {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin: 30px 0;
        }
        .star {
            font-size: 40px;
            color: #e5e7eb;
            cursor: pointer;
            transition: all 0.2s;
        }
        .star:hover,
        .star.active {
            color: #fbbf24;
        }
        .star.filled {
            color: #fbbf24;
        }
        textarea {
            min-height: 120px;
            resize: vertical;
        }
        .btn-submit {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border: none;
            color: white;
            padding: 12px 40px;
            border-radius: 12px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(236, 72, 153, 0.4);
        }
    </style>
</head>
<body>
    <div class="rating-container">
        <div class="salon-header">
            @if($salon->salon_profile_image)
                <img src="{{ \Illuminate\Support\Facades\Storage::url($salon->salon_profile_image) }}" alt="{{ $salon->salon_name }}">
            @else
                <div style="width: 80px; height: 80px; border-radius: 50%; background: #ec4899; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px; color: white; font-size: 32px; font-weight: bold;">
                    {{ $salon->initials }}
                </div>
            @endif
            <h2>{{ $salon->salon_name }}</h2>
            <p class="text-muted">Randevunuzu değerlendirin</p>
            @if($rating->referral_code)
            <div class="alert alert-info mt-3" style="background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%); border: none; border-radius: 12px;">
                <div class="d-flex align-items-center justify-content-center">
                    <i class="bi bi-gift-fill me-2" style="font-size: 24px; color: #3b82f6;"></i>
                    <div>
                        <strong style="color: #1e40af;">🎁 Referans Kodunuz:</strong>
                        <div class="mt-2">
                            <span style="font-size: 28px; font-weight: bold; color: #1e40af; letter-spacing: 4px; font-family: 'Courier New', monospace;">
                                {{ $rating->referral_code }}
                            </span>
                        </div>
                        <small class="text-muted d-block mt-2">
                            Bu kodu arkadaşlarınızla paylaşın, onlar randevu aldığında size 3 puan kazandırır!
                        </small>
                    </div>
                </div>
            </div>
            @endif
        </div>
        
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        
        @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        <form action="{{ route('public.salon.rating.store', ['slug' => $salon->salon_slug, 'token' => $rating->token]) }}" method="POST">
            @csrf
            
            <div class="mb-4">
                <label class="form-label fw-bold">Puanınız</label>
                <div class="star-rating">
                    @for($i = 1; $i <= 5; $i++)
                        <i class="bi bi-star-fill star" data-rating="{{ $i }}" onclick="setRating({{ $i }})"></i>
                    @endfor
                </div>
                <input type="hidden" name="rating" id="rating" value="{{ old('rating', 0) }}" required>
                <div class="text-danger mt-2" id="rating-error" style="display: none;">Lütfen puan seçin.</div>
            </div>
            
            <div class="mb-4">
                <label for="comment" class="form-label fw-bold">Yorumunuz (İsteğe bağlı)</label>
                <textarea class="form-control" id="comment" name="comment" rows="5" placeholder="Deneyiminizi paylaşın...">{{ old('comment') }}</textarea>
            </div>
            
            <div class="text-center">
                <button type="submit" class="btn btn-submit">
                    <i class="bi bi-check-circle me-2"></i>Değerlendirmeyi Gönder
                </button>
            </div>
        </form>
    </div>
    
    <script>
        let selectedRating = 0;
        
        function setRating(rating) {
            selectedRating = rating;
            document.getElementById('rating').value = rating;
            
            const stars = document.querySelectorAll('.star');
            stars.forEach((star, index) => {
                if (index < rating) {
                    star.classList.add('filled', 'active');
                } else {
                    star.classList.remove('filled', 'active');
                }
            });
            
            document.getElementById('rating-error').style.display = 'none';
        }
        
        // Hover efekti
        document.querySelectorAll('.star').forEach((star, index) => {
            star.addEventListener('mouseenter', function() {
                const rating = parseInt(this.dataset.rating);
                const stars = document.querySelectorAll('.star');
                stars.forEach((s, i) => {
                    if (i < rating) {
                        s.classList.add('active');
                    } else {
                        s.classList.remove('active');
                    }
                });
            });
            
            star.addEventListener('mouseleave', function() {
                const stars = document.querySelectorAll('.star');
                stars.forEach((s, i) => {
                    if (i < selectedRating) {
                        s.classList.add('active');
                    } else {
                        s.classList.remove('active');
                    }
                });
            });
        });
        
        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            if (selectedRating === 0) {
                e.preventDefault();
                document.getElementById('rating-error').style.display = 'block';
                return false;
            }
        });
    </script>
</body>
</html>

