<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <title>{{ $salon->salon_name }} - Güzellik Salonu</title>
    @include('partials.google-ads-tag')
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ url('favicon.png') }}?v=3">
    <link rel="shortcut icon" href="{{ url('favicon.png') }}?v=3">
    <link rel="apple-touch-icon" href="{{ url('favicon.png') }}?v=3">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        
        @php
            // Renk Paleti Sistemi
            $colorSchemes = [
                'pink' => [
                    'primary' => '#ec4899',
                    'secondary' => '#be185d',
                    'accent' => '#f472b6',
                    'light' => '#fdf2f8',
                    'medium' => '#fce7f3',
                    'dark' => '#fbcfe8',
                    'rgba_primary' => '236, 72, 153',
                    'rgba_secondary' => '190, 24, 93',
                ],
                'blue' => [
                    'primary' => '#3b82f6',
                    'secondary' => '#1e40af',
                    'accent' => '#60a5fa',
                    'light' => '#eff6ff',
                    'medium' => '#dbeafe',
                    'dark' => '#bfdbfe',
                    'rgba_primary' => '59, 130, 246',
                    'rgba_secondary' => '30, 64, 175',
                ],
                'purple' => [
                    'primary' => '#8b5cf6',
                    'secondary' => '#7c3aed',
                    'accent' => '#a78bfa',
                    'light' => '#f5f3ff',
                    'medium' => '#ede9fe',
                    'dark' => '#ddd6fe',
                    'rgba_primary' => '139, 92, 246',
                    'rgba_secondary' => '124, 58, 237',
                ],
                'orange' => [
                    'primary' => '#f97316',
                    'secondary' => '#ea580c',
                    'accent' => '#fb923c',
                    'light' => '#fff7ed',
                    'medium' => '#ffedd5',
                    'dark' => '#fed7aa',
                    'rgba_primary' => '249, 115, 22',
                    'rgba_secondary' => '234, 88, 12',
                ],
                'green' => [
                    'primary' => '#10b981',
                    'secondary' => '#059669',
                    'accent' => '#34d399',
                    'light' => '#f0fdf4',
                    'medium' => '#dcfce7',
                    'dark' => '#bbf7d0',
                    'rgba_primary' => '16, 185, 129',
                    'rgba_secondary' => '5, 150, 105',
                ],
            ];
            $colors = $colorSchemes[$colorScheme ?? 'pink'];
        @endphp
        
        :root {
            --primary-color: {{ $colors['primary'] }};
            --secondary-color: {{ $colors['secondary'] }};
            --accent-color: {{ $colors['accent'] }};
            --bg-color: #f8fafc;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --glass-bg: rgba(255, 255, 255, 0.85);
            --glass-border: rgba(255, 255, 255, 0.3);
            --glass-shadow: 0 8px 32px rgba(0,0,0,0.1);
            --rgba-primary: {{ $colors['rgba_primary'] }};
            --rgba-secondary: {{ $colors['rgba_secondary'] }};
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, {{ $colors['light'] }} 0%, {{ $colors['medium'] }} 50%, {{ $colors['dark'] }} 100%);
            background-attachment: fixed;
            color: var(--text-primary);
            line-height: 1.6;
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }

        /* Animated Background Particles */
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 20% 50%, rgba(var(--rgba-primary), 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(var(--rgba-primary), 0.08) 0%, transparent 50%),
                radial-gradient(circle at 40% 20%, rgba(var(--rgba-secondary), 0.1) 0%, transparent 50%);
            animation: float 20s ease-in-out infinite;
            z-index: 0;
            pointer-events: none;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(5deg); }
        }

        /* Hero Section - Modern Glass Morphism */
        .hero-section {
            @if($salon->salon_banner_image)
                background-image: url('{{ \Illuminate\Support\Facades\Storage::url($salon->salon_banner_image) }}');
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
            @else
                background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            @endif
            color: white;
            padding: 80px 0 60px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            @if($salon->salon_banner_image)
                background: linear-gradient(135deg, rgba(var(--rgba-primary), 0.7) 0%, rgba(var(--rgba-secondary), 0.7) 100%);
            @else
                background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><defs><pattern id="grid" width="100" height="100" patternUnits="userSpaceOnUse"><path d="M 100 0 L 0 0 0 100" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="1"/></pattern></defs><rect width="100%" height="100%" fill="url(%23grid)"/></svg>');
                opacity: 0.3;
            @endif
            z-index: 1;
        }

        .hero-section::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: moveBackground 30s linear infinite;
            z-index: 0;
        }

        @keyframes moveBackground {
            0% { transform: translate(0, 0); }
            100% { transform: translate(50px, 50px); }
        }

        .hero-content {
            position: relative;
            z-index: 2;
        }

        .profile-image {
            width: 180px;
            height: 180px;
            border-radius: 50%;
            object-fit: cover;
            border: 8px solid rgba(255, 255, 255, 0.4);
            margin: 0 auto 30px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3), 0 0 0 20px rgba(255,255,255,0.1);
            backdrop-filter: blur(10px);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            z-index: 1;
            animation: pulse 3s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% { box-shadow: 0 20px 60px rgba(0,0,0,0.3), 0 0 0 20px rgba(255,255,255,0.1); }
            50% { box-shadow: 0 20px 60px rgba(0,0,0,0.4), 0 0 0 30px rgba(255,255,255,0.15); }
        }

        .profile-image:hover {
            transform: scale(1.1) rotate(5deg);
            box-shadow: 0 30px 80px rgba(0,0,0,0.5), 0 0 0 40px rgba(255,255,255,0.2);
        }

        .hero-section h1 {
            font-size: 4rem;
            font-weight: 900;
            margin-bottom: 20px;
            letter-spacing: -2px;
            text-shadow: 0 4px 30px rgba(0,0,0,0.3), 0 0 40px rgba(255,255,255,0.2);
            background: linear-gradient(135deg, #ffffff 0%, rgba(255,255,255,0.8) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: fadeInUp 1s ease-out;
            position: relative;
            z-index: 1;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Ilk acilista calisan animasyonlari kapat */
        body::before,
        .hero-section::after,
        .profile-image,
        .hero-section h1,
        .service-category-content,
        .step-services-category-content,
        .tab-content {
            animation: none !important;
        }

        .hero-section .lead {
            font-size: 1.3rem;
            font-weight: 400;
            opacity: 0.95;
            margin-bottom: 30px;
        }

        .contact-info {
            display: flex;
            justify-content: center;
            gap: 40px;
            margin: 30px 0;
            flex-wrap: wrap;
        }

        .contact-item {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 1.1rem;
            opacity: 0.9;
        }

        .contact-item i {
            font-size: 1.3rem;
        }

        /* Salon Info Compact */
        .salon-info-compact {
            padding: 20px 0;
            background: rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(10px);
            margin-top: -20px;
            position: relative;
            z-index: 1;
        }

        .salon-info-box {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(20px);
            border-radius: 12px;
            padding: 16px 20px;
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
            font-size: 0.9rem;
        }

        .salon-description-compact {
            margin-bottom: 10px;
            color: #374151;
            line-height: 1.5;
            font-size: 0.85rem;
        }

        .salon-address-compact {
            color: #6b7280;
            font-size: 0.85rem;
            display: flex;
            align-items: flex-start;
            gap: 8px;
        }

        .salon-address-compact i {
            color: var(--primary-color);
            margin-top: 2px;
        }

        /* Modern Button */
        .btn-modern {
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(20px) saturate(180%);
            -webkit-backdrop-filter: blur(20px) saturate(180%);
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 16px;
            padding: 16px 40px;
            font-size: 1.1rem;
            font-weight: 600;
            color: white;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 8px 32px rgba(0,0,0,0.2);
            position: relative;
            overflow: hidden;
        }

        .btn-modern::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }

        .btn-modern:hover::before {
            width: 300px;
            height: 300px;
        }

        .btn-modern:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 40px rgba(0,0,0,0.3);
            background: rgba(255, 255, 255, 0.3);
        }

        /* Section */
        .section {
            padding: 80px 0;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 800;
            text-align: center;
            margin-bottom: 60px;
            color: var(--text-primary);
            letter-spacing: -1px;
        }

        /* Modern Card - Glass Morphism */
        .service-card, .personel-card {
            background: var(--glass-bg);
            backdrop-filter: blur(30px) saturate(200%);
            -webkit-backdrop-filter: blur(30px) saturate(200%);
            border-radius: 28px;
            border: 2px solid var(--glass-border);
            box-shadow: var(--glass-shadow), 0 0 0 1px rgba(255,255,255,0.5) inset;
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
            position: relative;
            height: 100%;
            transform-style: preserve-3d;
        }

        .service-card::after, .personel-card::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.1), transparent);
            transform: rotate(45deg);
            transition: all 0.6s;
            opacity: 0;
        }

        .service-card:hover::after, .personel-card:hover::after {
            animation: shine 0.6s ease-in-out;
        }

        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); opacity: 0; }
            50% { opacity: 1; }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); opacity: 0; }
        }

        .service-card::before, .personel-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color), var(--accent-color));
            opacity: 0;
            transition: opacity 0.3s;
        }

        .service-card:hover::before, .personel-card:hover::before {
            opacity: 1;
        }

        .service-card:hover, .personel-card:hover {
            transform: translateY(-12px) scale(1.02);
            box-shadow: 0 25px 70px rgba(var(--rgba-primary), 0.3), 0 0 40px rgba(var(--rgba-primary), 0.2);
            border-color: rgba(var(--rgba-primary), 0.5);
        }

        .card-body {
            padding: 30px;
        }

        .service-card h5, .personel-card h5 {
            font-size: 1.4rem;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--text-primary);
        }

        .service-card .card-text {
            color: var(--text-secondary);
            font-size: 0.95rem;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        .price-badge {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--primary-color);
            margin-bottom: 5px;
        }

        .duration-badge {
            font-size: 0.85rem;
            color: var(--text-secondary);
        }

        /* Modern Button Primary */
        .btn-primary-modern {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border: none;
            border-radius: 12px;
            padding: 12px 28px;
            font-weight: 600;
            color: white;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 4px 16px rgba(var(--rgba-primary), 0.3);
            position: relative;
            overflow: hidden;
        }

        .btn-primary-modern::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }

        .btn-primary-modern:hover::before {
            width: 300px;
            height: 300px;
        }

        .btn-primary-modern:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(var(--rgba-primary), 0.5);
        }

        /* Personel Avatar */
        .personel-avatar {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 2.5rem;
            color: white;
            font-weight: 700;
            box-shadow: 0 8px 24px rgba(0,0,0,0.15);
            transition: all 0.3s;
        }

        .personel-card:hover .personel-avatar {
            transform: scale(1.1);
        }

        .service-badge {
            display: inline-block;
            background: linear-gradient(135deg, var(--primary-color), var(--accent-color));
            color: white;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
            margin: 4px;
            box-shadow: 0 2px 8px rgba(var(--rgba-primary), 0.3);
        }

        /* Gallery Section */
        .gallery-grid-public {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .gallery-item-public {
            position: relative;
            overflow: hidden;
            border-radius: 16px;
            aspect-ratio: 1;
            cursor: pointer;
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .gallery-item-public:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 32px rgba(var(--rgba-primary), 0.4);
        }

        .gallery-image-public {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .gallery-item-public:hover .gallery-image-public {
            transform: scale(1.1);
        }

        .gallery-item-public::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(var(--rgba-primary), 0.1) 0%, rgba(var(--rgba-primary), 0.3) 100%);
            opacity: 0;
            transition: opacity 0.3s;
        }

        .gallery-item-public:hover::after {
            opacity: 1;
        }

        @media (max-width: 768px) {
            .gallery-grid-public {
                grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
                gap: 12px;
            }
        }

        /* Footer */
        footer {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            color: white;
            padding: 40px 0;
            text-align: center;
        }

        footer .container {
            padding-left: 15px;
            padding-right: 15px;
        }

        /* Modern Modal */
        .modal-content {
            border-radius: 28px;
            border: none;
            box-shadow: 0 25px 80px rgba(0,0,0,0.3);
            overflow: hidden;
            background: white;
        }

        .modal-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border-bottom: none;
            padding: 28px 32px;
            color: white;
        }

        .modal-title {
            font-size: 1.5rem;
            font-weight: 700;
            letter-spacing: -0.5px;
        }

        .modal-body {
            padding: 32px;
        }

        .appointment-step {
            min-height: 350px;
            padding: 20px 0;
        }

        .appointment-step h6 {
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 30px;
            color: var(--text-primary);
            letter-spacing: -0.5px;
        }

        /* Modern Form Controls */
        .form-control, .form-select {
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 14px 18px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 4px rgba(var(--rgba-primary), 0.1);
            outline: none;
        }

        .form-label {
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 10px;
            font-size: 0.95rem;
        }

        .input-group .btn {
            border-radius: 0 12px 12px 0;
            border-left: none;
        }

        .input-group .form-control {
            border-radius: 12px 0 0 12px;
        }

        /* OTP Input */
        #otpCode {
            font-size: 2rem;
            letter-spacing: 12px;
            text-align: center;
            font-weight: 700;
            padding: 20px;
            border: 2px solid #e2e8f0;
            border-radius: 16px;
        }

        #otpCode:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 4px rgba(var(--rgba-primary), 0.1);
        }

        /* Service Option Card */
        .service-option-card {
            background: var(--glass-bg);
            backdrop-filter: blur(20px) saturate(180%);
            -webkit-backdrop-filter: blur(20px) saturate(180%);
            border-radius: 20px;
            border: 2px solid #e2e8f0;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            overflow: hidden;
            position: relative;
        }

        .service-option-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 32px rgba(var(--rgba-primary), 0.2);
            border-color: var(--primary-color);
        }

        .service-option-card.border-primary {
            border-color: var(--primary-color) !important;
            border-width: 3px !important;
            border-style: solid !important;
            box-shadow: 0 8px 24px rgba(var(--rgba-primary), 0.3) !important;
        }

        .service-option-card.border-primary:hover {
            border-color: var(--primary-color) !important;
            border-width: 3px !important;
        }

        /* Step Category Tabs */
        .step-category-tab-btn {
            padding: 8px 16px;
            border: none;
            background: #f3f4f6;
            border-radius: 8px;
            cursor: pointer;
            white-space: nowrap;
            transition: all 0.3s;
            color: #000000 !important;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .step-category-tab-btn:hover {
            background: #e5e7eb;
            transform: translateY(-2px);
        }

        .step-category-tab-btn.active {
            background: #fce7f3;
            color: #111827 !important;
            border: 1px solid var(--primary-color);
            box-shadow: 0 4px 12px rgba(var(--rgba-primary), 0.3);
        }

        .step-services-category-content {
            animation: fadeIn 0.3s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Service Checkbox */
        .service-checkbox-wrapper {
            position: relative;
            flex-shrink: 0;
        }

        .service-checkbox {
            width: 28px;
            height: 28px;
            border: 3px solid #e2e8f0;
            border-radius: 6px;
            background: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
            position: relative;
        }

        .service-checkbox i {
            color: white;
            font-size: 16px;
            font-weight: bold;
            display: none;
            position: absolute;
            z-index: 2;
        }

        .service-option-card.border-primary .service-checkbox {
            background: var(--primary-color) !important;
            border-color: var(--primary-color) !important;
            border-width: 3px !important;
        }

        .service-option-card.border-primary .service-checkbox i {
            display: flex !important;
            color: white !important;
        }
        
        /* Inline style override koruması */
        .service-option-card.border-primary [data-service-id] {
            border-color: var(--primary-color) !important;
        }

        /* Modern Alert */
        .alert-modern {
            background: rgba(59, 130, 246, 0.1);
            border: 2px solid rgba(59, 130, 246, 0.2);
            border-radius: 12px;
            padding: 16px 20px;
            color: #1e40af;
            backdrop-filter: blur(10px);
        }

        /* Modal Footer */
        .modal-footer {
            border-top: 1px solid #e2e8f0;
            padding: 24px 32px;
            background: #f8fafc;
        }

        .btn-outline-primary-modern {
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            border-radius: 12px;
            padding: 12px 28px;
            font-weight: 600;
            transition: all 0.3s;
        }

        .btn-outline-primary-modern:hover {
            background: var(--primary-color);
            color: white;
            transform: translateY(-2px);
        }

        /* Modern Tab System */
        .tab-container {
            background: var(--glass-bg);
            backdrop-filter: blur(30px) saturate(200%);
            -webkit-backdrop-filter: blur(30px) saturate(200%);
            border-radius: 28px;
            border: 2px solid var(--glass-border);
            box-shadow: var(--glass-shadow);
            padding: 40px;
            margin-top: 40px;
        }

        .tab-nav {
            display: flex;
            gap: 10px;
            margin-bottom: 40px;
            border-bottom: 2px solid rgba(var(--rgba-primary), 0.1);
            padding-bottom: 0;
        }

        .tab-btn {
            background: transparent;
            border: none;
            padding: 16px 32px;
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--text-secondary);
            cursor: pointer;
            position: relative;
            transition: all 0.3s ease;
            border-radius: 12px 12px 0 0;
        }

        .tab-btn::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 3px;
            background: linear-gradient(135deg, var(--primary-color), var(--accent-color));
            transition: width 0.3s ease;
        }

        .category-tabs {
            margin-bottom: 20px;
        }

        .category-tab-btn {
            padding: 8px 16px;
            border: none;
            background: #f3f4f6;
            border-radius: 8px;
            cursor: pointer;
            white-space: nowrap;
            transition: all 0.3s;
            color: #374151;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .category-tab-btn:hover {
            background: #e5e7eb;
            transform: translateY(-2px);
        }

        .category-tab-btn.active {
            background: #fce7f3;
            color: #111827 !important;
            border: 1px solid var(--primary-color);
            box-shadow: 0 4px 12px rgba(var(--rgba-primary), 0.3);
        }

        .category-tab-btn,
        .category-tab-btn span,
        .step-category-tab-btn,
        .step-category-tab-btn span {
            color: #111827 !important;
        }

        .service-category-content {
            animation: fadeIn 0.3s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .tab-btn.active {
            color: var(--primary-color);
            background: rgba(var(--rgba-primary), 0.05);
        }

        .tab-btn.active::after {
            width: 100%;
        }

        .tab-btn:hover {
            color: var(--primary-color);
            background: rgba(var(--rgba-primary), 0.05);
        }

        .tab-content {
            display: none;
            animation: fadeIn 0.4s ease-in;
        }

        .tab-content.active {
            display: block;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive - Modern Mobile */
        @media (max-width: 768px) {
            .hero-section {
                padding: 60px 0 50px;
            }
            
            .hero-section h1 {
                font-size: 1.75rem;
                line-height: 1.3;
                margin-bottom: 1rem;
            }
            
            .hero-section .lead {
                font-size: 1rem;
                margin-bottom: 1.5rem;
            }

            .section-title {
                font-size: 1.5rem;
                margin-bottom: 1.5rem;
            }

            .salon-info-compact {
                padding: 15px 0;
            }

            .salon-info-box {
                padding: 12px 16px;
                font-size: 0.8rem;
            }

            .salon-description-compact,
            .salon-address-compact {
                font-size: 0.75rem;
            }

            .contact-info {
                flex-direction: column;
                gap: 15px;
                margin-bottom: 1.5rem;
                max-width: 100%;
                padding: 0 15px;
            }
            
            .contact-item {
                font-size: 0.9rem;
                padding: 12px 16px !important;
                width: 100% !important;
                min-width: 100% !important;
                max-width: 100% !important;
                text-align: center !important;
                flex-direction: row !important;
                justify-content: center !important;
            }
            
            .contact-item i {
                font-size: 1.1rem !important;
            }
            
            .contact-item span {
                font-size: 0.85rem !important;
            }

            .modal-body {
                padding: 20px;
            }
            
            .modal-dialog {
                margin: 15px;
                max-width: calc(100% - 30px);
            }
            
            .modal-content {
                border-radius: 20px;
            }

            .tab-container {
                padding: 20px 15px;
            }

            .tab-nav {
                flex-direction: row;
                gap: 10px;
                margin-bottom: 20px;
            }

            .tab-btn {
                flex: 1;
                text-align: center;
                border-radius: 12px;
                padding: 12px 16px;
                font-size: 0.9rem;
            }

            .tab-btn::after {
                display: none;
            }
            
            .service-card, .personel-card {
                margin-bottom: 1rem;
            }
            
            .card-body {
                padding: 1.25rem;
            }
            
            .btn-modern {
                width: 100%;
                padding: 14px 24px;
                font-size: 1rem;
            }
            
            .profile-image {
                width: 120px;
                height: 120px;
                margin-bottom: 1.5rem;
            }
        }
        
        /* Small Mobile */
        @media (max-width: 480px) {
            .hero-section {
                padding: 50px 0 40px;
            }
            
            .hero-section h1 {
                font-size: 1.5rem;
            }
            
            .hero-section .lead {
                font-size: 0.95rem;
            }
            
            .section-title {
                font-size: 1.35rem;
            }

            .salon-info-compact {
                padding: 12px 0;
            }

            .salon-info-box {
                padding: 10px 12px;
                font-size: 0.75rem;
            }

            .salon-description-compact,
            .salon-address-compact {
                font-size: 0.7rem;
            }
            
            .tab-container {
                padding: 15px 10px;
            }
            
            .tab-btn {
                font-size: 0.85rem;
                padding: 10px 12px;
            }
            
            .card-body {
                padding: 1rem;
            }
            
            .profile-image {
                width: 100px;
                height: 100px;
            }
            
            .contact-info {
                padding: 0 10px;
                gap: 12px;
            }
            
            .contact-item {
                padding: 10px 14px !important;
                font-size: 0.85rem;
                width: 100% !important;
                min-width: 100% !important;
                max-width: 100% !important;
                flex-direction: row !important;
                justify-content: center !important;
            }
            
            .contact-item i {
                font-size: 1rem !important;
            }
            
            .contact-item span {
                font-size: 0.8rem !important;
            }
        }
        
        /* ========================================
           MOBILE PERFORMANCE OPTIMIZATIONS
           ======================================== */
        @media (max-width: 768px) {
            /* Disable expensive effects on mobile */
            * {
                will-change: auto !important;
            }
            
            /* Remove backdrop-filter - major FPS killer */
            .service-card, .personel-card,
            [style*="backdrop-filter"],
            [style*="backdrop-filter"] * {
                backdrop-filter: none !important;
                -webkit-backdrop-filter: none !important;
                background: rgba(255, 255, 255, 0.95) !important;
            }
            
            /* Disable hover transforms */
            .service-card:hover, .personel-card:hover,
            .gallery-item-public:hover .gallery-image-public {
                transform: none !important;
                box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important;
            }
            
            /* Disable expensive animations */
            .service-card::after, .personel-card::after,
            .service-card::before, .personel-card::before {
                display: none !important;
            }
            
            /* Simplify box-shadows */
            * {
                box-shadow: none !important;
            }
            
            .card, .modal-content, .service-card, .personel-card {
                box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important;
            }
            
            /* Disable gradient animations */
            .modal-header {
                background: var(--primary-color) !important;
            }
            
            /* Optimize transitions */
            * {
                transition-duration: 0.15s !important;
            }
            
            /* Touch optimization */
            button, a, .btn, input, select, textarea {
                -webkit-tap-highlight-color: rgba(236, 72, 153, 0.2);
                touch-action: manipulation;
            }
        }
        
        @media (max-width: 480px) {
            /* Extra optimizations for small screens */
            .hero-section {
                background-attachment: scroll !important;
            }
        }
    </style>
    <style>
        /* Theme1 redesign layer: Aurora Surface */
        body.aurora-theme {
            background:
                radial-gradient(1200px 500px at 10% -10%, rgba(var(--rgba-primary), 0.17), transparent 62%),
                radial-gradient(900px 420px at 92% -8%, rgba(var(--rgba-secondary), 0.12), transparent 64%),
                #f4f7fb;
            color: #0f172a;
        }

        body.aurora-theme .hero-section {
            min-height: 500px;
            padding: 88px 0 120px;
            border-radius: 0 0 38px 38px;
            box-shadow: 0 24px 50px rgba(15, 23, 42, 0.18);
        }

        body.aurora-theme .hero-section::before {
            background: linear-gradient(130deg, rgba(var(--rgba-primary), 0.74), rgba(var(--rgba-secondary), 0.62));
        }

        body.aurora-theme .hero-content {
            max-width: 1040px;
            margin: 0 auto;
        }

        body.aurora-theme .profile-image {
            width: 165px;
            height: 165px;
            border-width: 6px;
            margin-bottom: 22px;
            box-shadow: 0 16px 34px rgba(15, 23, 42, 0.36), 0 0 0 10px rgba(255, 255, 255, 0.2);
            animation: none;
        }

        body.aurora-theme .hero-section h1 {
            font-size: clamp(2rem, 4.2vw, 3.4rem);
            letter-spacing: -0.02em;
            margin-bottom: 12px;
            text-shadow: 0 12px 28px rgba(15, 23, 42, 0.32);
            -webkit-text-fill-color: #ffffff;
            background: none;
        }

        body.aurora-theme .rating-display {
            display: inline-flex !important;
            gap: 12px !important;
            margin: 12px auto 8px !important;
            padding: 8px 14px !important;
            border-radius: 999px !important;
            background: rgba(255, 255, 255, 0.2) !important;
            border: 1px solid rgba(255, 255, 255, 0.35) !important;
        }

        body.aurora-theme .contact-info {
            margin: 22px auto 16px !important;
            gap: 10px !important;
        }

        body.aurora-theme .contact-item {
            background: rgba(255, 255, 255, 0.2) !important;
            border: 1px solid rgba(255, 255, 255, 0.35) !important;
            border-radius: 14px !important;
            padding: 10px 14px !important;
            min-width: 190px !important;
            box-shadow: 0 8px 20px rgba(15, 23, 42, 0.18) !important;
        }

        body.aurora-theme .btn-modern {
            border-radius: 12px;
            padding: 12px 24px;
            font-size: 0.98rem;
            letter-spacing: 0.01em;
            text-transform: none;
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            color: #111827;
            border: 1px solid rgba(255, 255, 255, 0.6);
            box-shadow: 0 12px 24px rgba(15, 23, 42, 0.2);
        }

        body.aurora-theme .btn-modern:hover {
            transform: translateY(-2px);
            box-shadow: 0 16px 30px rgba(15, 23, 42, 0.24);
        }

        body.aurora-theme .section {
            margin-top: -68px;
            position: relative;
            z-index: 3;
            padding-bottom: 34px;
        }

        body.aurora-theme .tab-container {
            background: rgba(255, 255, 255, 0.92);
            border: 1px solid rgba(15, 23, 42, 0.08);
            border-radius: 24px;
            box-shadow: 0 24px 44px rgba(15, 23, 42, 0.12);
            backdrop-filter: blur(8px);
            overflow: hidden;
        }

        body.aurora-theme .tab-nav {
            padding: 16px;
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 0;
            background: linear-gradient(180deg, #ffffff 0%, #f8fafc 100%);
            border-bottom: 1px solid #e2e8f0;
        }

        body.aurora-theme .tab-btn {
            border: 1px solid #e2e8f0 !important;
            border-radius: 12px !important;
            background: #f8fafc !important;
            color: #334155 !important;
            padding: 10px 14px !important;
            font-weight: 600;
            transition: all 0.2s ease;
            flex: 1 1 auto;
            min-width: 140px;
            justify-content: center;
            text-align: center;
        }

        body.aurora-theme .tab-btn.active,
        body.aurora-theme .tab-btn:hover {
            background: rgba(var(--rgba-primary), 0.14) !important;
            border-color: rgba(var(--rgba-primary), 0.42) !important;
            color: #0f172a !important;
            transform: translateY(-1px);
        }

        body.aurora-theme .tab-content {
            padding: 20px 18px 16px;
        }

        body.aurora-theme .category-tabs {
            border-bottom: 1px solid #e5e7eb !important;
            padding-bottom: 12px !important;
            margin-bottom: 14px !important;
        }

        body.aurora-theme .category-tab-btn {
            border: 1px solid #e2e8f0 !important;
            background: #ffffff !important;
            color: #334155 !important;
            border-radius: 999px !important;
            padding: 8px 13px !important;
            font-weight: 600;
        }

        body.aurora-theme .category-tab-btn.active {
            background: rgba(var(--rgba-primary), 0.14) !important;
            border-color: rgba(var(--rgba-primary), 0.42) !important;
            color: #111827 !important;
        }

        body.aurora-theme .service-card,
        body.aurora-theme .personel-card,
        body.aurora-theme .elegant-card {
            border: 1px solid #e5e7eb !important;
            border-radius: 16px !important;
            background: #ffffff !important;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08) !important;
            transition: transform .2s ease, box-shadow .2s ease, border-color .2s ease;
        }

        body.aurora-theme .service-card:hover,
        body.aurora-theme .personel-card:hover,
        body.aurora-theme .elegant-card:hover {
            transform: translateY(-3px);
            border-color: rgba(var(--rgba-primary), 0.35) !important;
            box-shadow: 0 16px 32px rgba(15, 23, 42, 0.12) !important;
        }

        body.aurora-theme .price-badge,
        body.aurora-theme .price-elegant {
            color: var(--primary-color);
            font-weight: 800;
            font-size: 1.1rem;
        }

        body.aurora-theme .duration-badge,
        body.aurora-theme .duration-elegant {
            color: #64748b;
            font-size: 0.85rem;
        }

        body.aurora-theme .gallery-grid-public {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(210px, 1fr));
            gap: 14px;
        }

        body.aurora-theme .gallery-item-public {
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid #e2e8f0;
            box-shadow: 0 10px 22px rgba(15, 23, 42, 0.1);
            background: #fff;
        }

        body.aurora-theme .gallery-image-public {
            width: 100%;
            aspect-ratio: 4 / 3;
            object-fit: cover;
            cursor: zoom-in;
            transition: transform .3s ease;
        }

        body.aurora-theme .gallery-item-public:hover .gallery-image-public {
            transform: scale(1.05);
        }

        body.aurora-theme .personel-avatar,
        body.aurora-theme .personel-avatar-elegant {
            box-shadow: 0 8px 20px rgba(15, 23, 42, 0.2);
        }

        body.aurora-theme .service-badge,
        body.aurora-theme .service-badge-elegant {
            background: rgba(var(--rgba-primary), 0.12);
            color: #0f172a;
            border: 1px solid rgba(var(--rgba-primary), 0.2);
        }

        body.aurora-theme #ratingsTab .elegant-card {
            border: 1px solid #e5e7eb !important;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08) !important;
        }

        body.aurora-theme .modal-content {
            border-radius: 18px;
            border: 1px solid #e5e7eb;
        }

        @media (max-width: 992px) {
            body.aurora-theme .hero-section {
                min-height: auto;
                padding: 64px 0 98px;
                border-radius: 0 0 28px 28px;
            }

            body.aurora-theme .section {
                margin-top: -54px;
            }
        }

        @media (max-width: 768px) {
            body.aurora-theme .tab-container {
                border-radius: 16px;
            }

            body.aurora-theme .tab-nav {
                padding: 12px;
                gap: 8px;
            }

            body.aurora-theme .tab-btn {
                min-width: unset;
                flex: 1 1 calc(50% - 8px);
                font-size: 0.85rem;
                padding: 9px 10px !important;
            }

            body.aurora-theme .tab-content {
                padding: 14px 12px 10px;
            }

            body.aurora-theme .service-card,
            body.aurora-theme .personel-card,
            body.aurora-theme .elegant-card,
            body.aurora-theme .gallery-item-public {
                box-shadow: 0 8px 16px rgba(15, 23, 42, 0.1) !important;
            }
        }
    </style>
    <style>
        /* Radical redesign layer: Mono Editorial */
        body.mono-editorial-theme {
            background: #f6f1e8;
            color: #111111;
            font-family: 'Inter', Arial, sans-serif;
        }

        body.mono-editorial-theme::before {
            display: none !important;
        }

        body.mono-editorial-theme .hero-section {
            border-radius: 0 !important;
            padding: 72px 0 96px !important;
            box-shadow: none !important;
            border-bottom: 3px solid #111111;
        }

        body.mono-editorial-theme .hero-section::before {
            background: linear-gradient(135deg, rgba(17, 17, 17, 0.76), rgba(var(--rgba-primary), 0.56)) !important;
        }

        body.mono-editorial-theme .hero-section::after {
            opacity: 0.08;
        }

        body.mono-editorial-theme .hero-content {
            max-width: 1100px;
            margin: 0 auto;
            padding: 0 8px;
        }

        body.mono-editorial-theme .profile-image {
            width: 150px;
            height: 150px;
            border: 4px solid #ffffff;
            border-radius: 20px;
            box-shadow: 10px 10px 0 #111111;
            animation: none;
            transform: none !important;
        }

        body.mono-editorial-theme .hero-section h1 {
            font-size: clamp(2rem, 5vw, 3.8rem);
            letter-spacing: -0.03em;
            font-weight: 900;
            color: #ffffff !important;
            -webkit-text-fill-color: #ffffff !important;
            text-transform: uppercase;
            margin-bottom: 12px;
            text-shadow: 4px 4px 0 rgba(0, 0, 0, 0.28);
        }

        body.mono-editorial-theme .hero-layout {
            align-items: stretch;
        }

        body.mono-editorial-theme .hero-left {
            text-align: left;
            display: flex;
            flex-direction: column;
            justify-content: center;
            gap: 10px;
        }

        body.mono-editorial-theme .hero-left .profile-image {
            margin: 0 0 10px;
        }

        body.mono-editorial-theme .hero-right {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        body.mono-editorial-theme .hero-quick-panel {
            width: 100%;
            max-width: 360px;
            background: rgba(255, 255, 255, 0.92);
            color: #111111;
            border: 3px solid #111111;
            border-radius: 10px;
            box-shadow: 10px 10px 0 rgba(17, 17, 17, 0.3);
            padding: 18px;
            display: grid;
            gap: 10px;
        }

        body.mono-editorial-theme .hero-quick-title {
            font-size: 0.84rem;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            font-weight: 800;
            color: #475569;
            margin-bottom: 2px;
        }

        body.mono-editorial-theme .hero-quick-item {
            display: flex;
            align-items: flex-start;
            gap: 10px;
            padding: 10px 12px;
            border: 2px solid #111111;
            border-radius: 8px;
            background: #fff;
            color: #111111;
            text-decoration: none;
        }

        body.mono-editorial-theme .hero-quick-item i {
            font-size: 1rem;
            margin-top: 2px;
        }

        body.mono-editorial-theme .hero-quick-item .small {
            font-size: 0.72rem;
            color: #64748b;
            letter-spacing: 0.06em;
            text-transform: uppercase;
            font-weight: 700;
        }

        body.mono-editorial-theme .hero-quick-item .value {
            font-size: 0.92rem;
            font-weight: 700;
            line-height: 1.35;
            color: #0f172a;
        }

        body.mono-editorial-theme .rating-display {
            border-radius: 4px !important;
            border: 2px solid #ffffff !important;
            background: rgba(0, 0, 0, 0.3) !important;
            padding: 10px 14px !important;
        }

        body.mono-editorial-theme .contact-info {
            gap: 10px !important;
            margin: 18px auto 16px !important;
        }

        body.mono-editorial-theme .contact-item {
            border-radius: 6px !important;
            border: 2px solid #ffffff !important;
            background: rgba(0, 0, 0, 0.26) !important;
            box-shadow: none !important;
            padding: 10px 14px !important;
            min-width: 170px !important;
        }

        body.mono-editorial-theme .btn-modern {
            border-radius: 6px !important;
            background: #ffffff !important;
            color: #111111 !important;
            border: 2px solid #111111 !important;
            box-shadow: 5px 5px 0 #111111 !important;
            text-transform: uppercase;
            font-weight: 800;
            letter-spacing: 0.04em;
            padding: 12px 20px;
        }

        body.mono-editorial-theme .btn-modern:hover {
            transform: translate(2px, 2px) !important;
            box-shadow: 3px 3px 0 #111111 !important;
        }

        body.mono-editorial-theme .section {
            margin-top: -44px !important;
            padding-bottom: 34px;
        }

        body.mono-editorial-theme .tab-container {
            display: grid;
            grid-template-columns: 270px minmax(0, 1fr);
            align-items: start;
            background: #fffdf8 !important;
            border: 3px solid #111111 !important;
            border-radius: 10px !important;
            box-shadow: 12px 12px 0 #111111 !important;
            overflow: hidden;
        }

        body.mono-editorial-theme .tab-nav {
            background: #f3eadb !important;
            border-right: 3px solid #111111 !important;
            border-bottom: 0 !important;
            padding: 14px !important;
            gap: 8px !important;
            margin-bottom: 0 !important;
            flex-direction: column;
            position: sticky;
            top: 12px;
            align-self: start;
            min-height: 100%;
        }

        body.mono-editorial-theme .tab-btn {
            border-radius: 4px !important;
            border: 2px solid #111111 !important;
            background: #ffffff !important;
            color: #111111 !important;
            padding: 10px 12px !important;
            font-size: 0.9rem !important;
            font-weight: 700 !important;
            min-width: 100%;
            text-align: left;
            justify-content: flex-start;
        }

        body.mono-editorial-theme .tab-btn.active,
        body.mono-editorial-theme .tab-btn:hover {
            background: #111111 !important;
            color: #ffffff !important;
            transform: none !important;
        }

        body.mono-editorial-theme .tab-content {
            padding: 16px 14px 12px !important;
            color: #1f2937;
            border-left: 0 !important;
        }

        body.mono-editorial-theme .category-tabs {
            border-bottom: 2px solid #111111 !important;
            padding-bottom: 10px !important;
            margin-bottom: 12px !important;
        }

        body.mono-editorial-theme .category-tab-btn {
            border: 2px solid #111111 !important;
            border-radius: 999px !important;
            background: #ffffff !important;
            color: #111111 !important;
            font-weight: 700 !important;
            padding: 8px 12px !important;
        }

        body.mono-editorial-theme .category-tab-btn.active {
            background: #111111 !important;
            color: #ffffff !important;
        }

        body.mono-editorial-theme .service-card,
        body.mono-editorial-theme .personel-card,
        body.mono-editorial-theme .elegant-card {
            border: 2px solid #111111 !important;
            border-radius: 8px !important;
            background: #ffffff !important;
            box-shadow: 6px 6px 0 rgba(17, 17, 17, 0.18) !important;
            transform: none !important;
        }

        body.mono-editorial-theme .service-card:hover,
        body.mono-editorial-theme .personel-card:hover,
        body.mono-editorial-theme .elegant-card:hover {
            box-shadow: 8px 8px 0 rgba(17, 17, 17, 0.24) !important;
        }

        body.mono-editorial-theme .price-badge,
        body.mono-editorial-theme .price-elegant {
            color: #111111 !important;
            background: #fef08a !important;
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            border: 1px solid #111111;
            font-weight: 800 !important;
        }

        body.mono-editorial-theme .duration-badge,
        body.mono-editorial-theme .duration-elegant {
            color: #334155 !important;
            margin-top: 6px;
        }

        body.mono-editorial-theme .gallery-grid-public {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            gap: 10px;
        }

        body.mono-editorial-theme .gallery-item-public {
            border: 2px solid #111111;
            border-radius: 8px;
            background: #ffffff;
            overflow: hidden;
            box-shadow: 6px 6px 0 rgba(17, 17, 17, 0.16);
        }

        body.mono-editorial-theme .gallery-image-public {
            width: 100%;
            aspect-ratio: 4 / 3;
            object-fit: cover;
            filter: saturate(1.05) contrast(1.02);
        }

        body.mono-editorial-theme .personel-avatar,
        body.mono-editorial-theme .personel-avatar-elegant {
            border: 2px solid #111111 !important;
            box-shadow: 3px 3px 0 rgba(17, 17, 17, 0.32) !important;
        }

        body.mono-editorial-theme .service-badge,
        body.mono-editorial-theme .service-badge-elegant {
            border: 1px solid #111111;
            border-radius: 999px;
            background: #e2e8f0;
            color: #111111;
            font-weight: 700;
        }

        body.mono-editorial-theme .modal-content {
            border-radius: 10px !important;
            border: 2px solid #111111 !important;
        }

        @media (max-width: 768px) {
            body.mono-editorial-theme .hero-section {
                padding: 54px 0 80px !important;
            }

            body.mono-editorial-theme .hero-left {
                text-align: center;
                align-items: center;
            }

            body.mono-editorial-theme .hero-left .profile-image {
                margin: 0 auto 10px;
            }

            body.mono-editorial-theme .section {
                margin-top: -32px !important;
            }

            body.mono-editorial-theme .tab-container {
                display: block;
                box-shadow: 8px 8px 0 #111111 !important;
            }

            body.mono-editorial-theme .tab-nav {
                border-right: 0 !important;
                border-bottom: 2px solid #111111 !important;
                position: static;
                flex-direction: row;
            }

            body.mono-editorial-theme .tab-btn {
                flex: 1 1 calc(50% - 8px);
                min-width: unset;
                text-align: center;
                justify-content: center;
            }

            body.mono-editorial-theme .tab-content {
                padding: 12px 10px 8px !important;
            }
        }
    </style>
    <style>
        /* Unified modern layer */
        body.modern-v3 {
            background: radial-gradient(1200px 440px at 0% -10%, rgba(var(--rgba-primary), 0.14), transparent 60%), #f8fafc;
            color: #0f172a;
        }
        body.modern-v3 .hero-section,
        body.modern-v3 .elegant-header {
            border-radius: 0 0 30px 30px;
            box-shadow: 0 18px 40px rgba(15, 23, 42, 0.16);
            padding-bottom: 90px;
        }
        body.modern-v3 .profile-image,
        body.modern-v3 .profile-classic {
            width: 156px;
            height: 156px;
            border-width: 6px;
            box-shadow: 0 14px 30px rgba(15, 23, 42, 0.3);
            animation: none;
        }
        body.modern-v3 .hero-section h1,
        body.modern-v3 .elegant-title {
            font-size: clamp(2rem, 4.2vw, 3.3rem);
            letter-spacing: -0.02em;
            text-shadow: 0 10px 24px rgba(0, 0, 0, 0.25);
        }
        body.modern-v3 .contact-item {
            border-radius: 14px !important;
            border: 1px solid rgba(255, 255, 255, 0.38) !important;
            background: rgba(255, 255, 255, 0.22) !important;
            box-shadow: 0 8px 18px rgba(15, 23, 42, 0.16) !important;
        }
        body.modern-v3 .btn-modern, body.modern-v3 .btn-elegant {
            border-radius: 12px;
            padding: 12px 24px;
            text-transform: none;
            letter-spacing: 0.01em;
            box-shadow: 0 10px 22px rgba(15, 23, 42, 0.2);
        }
        body.modern-v3 .section, body.modern-v3 .classic-section {
            margin-top: -58px;
            position: relative;
            z-index: 3;
            padding-bottom: 30px;
        }
        body.modern-v3 .tab-container {
            background: rgba(255, 255, 255, 0.95);
            border: 1px solid rgba(15, 23, 42, 0.09);
            border-radius: 22px;
            box-shadow: 0 22px 42px rgba(15, 23, 42, 0.12);
            overflow: hidden;
        }
        body.modern-v3 .tab-nav {
            padding: 14px;
            background: linear-gradient(180deg, #ffffff 0%, #f8fafc 100%);
            border-bottom: 1px solid #e2e8f0;
            margin-bottom: 0;
            gap: 10px;
            display: flex;
            flex-wrap: wrap;
        }
        body.modern-v3 .tab-btn {
            border-radius: 12px !important;
            border: 1px solid #e2e8f0 !important;
            background: #f8fafc !important;
            color: #334155 !important;
            padding: 10px 14px !important;
            font-weight: 600;
        }
        body.modern-v3 .tab-btn.active, body.modern-v3 .tab-btn:hover {
            background: rgba(var(--rgba-primary), 0.14) !important;
            border-color: rgba(var(--rgba-primary), 0.4) !important;
            color: #0f172a !important;
        }
        body.modern-v3 .tab-content { padding: 18px 16px 14px; }
        body.modern-v3 .category-tab-btn {
            border: 1px solid #e2e8f0 !important;
            border-radius: 999px !important;
            background: #fff !important;
            color: #334155 !important;
            font-weight: 600;
        }
        body.modern-v3 .category-tab-btn.active {
            background: rgba(var(--rgba-primary), 0.14) !important;
            border-color: rgba(var(--rgba-primary), 0.42) !important;
            color: #111827 !important;
        }
        body.modern-v3 .service-card, body.modern-v3 .personel-card, body.modern-v3 .elegant-card, body.modern-v3 .personel-elegant {
            border: 1px solid #e5e7eb !important;
            border-radius: 16px !important;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08) !important;
            background: #ffffff !important;
        }
        body.modern-v3 .gallery-item-public {
            border-radius: 14px;
            overflow: hidden;
            border: 1px solid #e2e8f0;
            box-shadow: 0 8px 18px rgba(15, 23, 42, 0.1);
        }
        body.modern-v3 .gallery-image-public { aspect-ratio: 4 / 3; object-fit: cover; }
        body.modern-v3 .personel-avatar, body.modern-v3 .personel-avatar-elegant { box-shadow: 0 8px 18px rgba(15, 23, 42, 0.2); }
        body.modern-v3 .modal-content { border-radius: 16px; border: 1px solid #e5e7eb; }
    </style>
    <style>
        /* Mobile hardening - shared responsive safety */
        @media (max-width: 1024px) {
            .container {
                max-width: 100% !important;
                padding-left: 14px !important;
                padding-right: 14px !important;
            }
            .tab-container {
                border-radius: 16px !important;
            }
            .tab-content {
                padding: 14px 12px !important;
            }
            .row {
                --bs-gutter-x: 0.9rem !important;
                --bs-gutter-y: 0.9rem !important;
            }
        }

        @media (max-width: 768px) {
            html, body {
                overflow-x: hidden !important;
            }
            .hero-section, .elegant-header {
                padding: 42px 0 72px !important;
                min-height: auto !important;
                border-radius: 0 0 18px 18px !important;
            }
            .hero-content, .header-content {
                padding-left: 2px !important;
                padding-right: 2px !important;
            }
            .profile-image, .profile-classic, .profile-classic-placeholder {
                width: 110px !important;
                height: 110px !important;
                margin-bottom: 14px !important;
            }
            .hero-section h1, .elegant-title {
                font-size: 1.4rem !important;
                line-height: 1.25 !important;
                margin-bottom: 8px !important;
            }
            .rating-display {
                width: auto !important;
                max-width: 100% !important;
                padding: 7px 10px !important;
                gap: 8px !important;
            }
            .contact-info {
                display: grid !important;
                grid-template-columns: 1fr !important;
                gap: 10px !important;
                width: 100% !important;
                margin: 14px 0 !important;
            }
            .contact-item {
                width: 100% !important;
                min-width: 100% !important;
                max-width: 100% !important;
                justify-content: center !important;
                padding: 10px 12px !important;
            }
            .section, .classic-section {
                margin-top: -26px !important;
                padding-bottom: 18px !important;
            }
            .tab-container {
                border-radius: 12px !important;
                overflow: hidden !important;
            }
            .tab-nav {
                display: grid !important;
                grid-template-columns: 1fr 1fr !important;
                gap: 8px !important;
                padding: 10px !important;
                position: static !important;
            }
            .tab-btn {
                min-width: 0 !important;
                width: 100% !important;
                justify-content: center !important;
                text-align: center !important;
                padding: 9px 8px !important;
                font-size: 0.82rem !important;
                line-height: 1.2 !important;
            }
            .category-tabs .d-flex {
                gap: 6px !important;
            }
            .category-tab-btn, .step-category-tab-btn {
                padding: 7px 10px !important;
                font-size: 0.78rem !important;
                white-space: nowrap !important;
            }
            .service-card, .elegant-card, .personel-card, .personel-elegant {
                margin-bottom: 0 !important;
            }
            .card-body {
                padding: 12px !important;
            }
            .gallery-grid-public {
                grid-template-columns: 1fr 1fr !important;
                gap: 8px !important;
            }
            .gallery-item-public {
                border-radius: 10px !important;
            }
            .gallery-image-public {
                aspect-ratio: 1 / 1 !important;
            }
            .modal-dialog {
                margin: 10px !important;
            }
            .modal-content {
                border-radius: 12px !important;
                max-height: calc(100vh - 20px) !important;
            }
            .modal-body {
                max-height: calc(100vh - 180px) !important;
                overflow-y: auto !important;
            }
            #appointmentModal .modal-footer {
                flex-wrap: wrap !important;
                gap: 8px !important;
            }
            #appointmentModal .modal-footer .btn {
                flex: 1 1 calc(50% - 8px) !important;
                min-width: 120px !important;
            }
            .date-option-card, .time-slot-btn {
                min-height: 44px !important;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding-left: 10px !important;
                padding-right: 10px !important;
            }
            .tab-nav {
                grid-template-columns: 1fr !important;
            }
            .tab-btn {
                font-size: 0.8rem !important;
                padding: 9px 10px !important;
            }
            .gallery-grid-public {
                grid-template-columns: 1fr !important;
            }
            #appointmentModal .modal-footer .btn {
                flex: 1 1 100% !important;
                width: 100% !important;
            }
            .btn-modern, .btn-elegant {
                width: 100% !important;
                padding: 11px 14px !important;
            }
        }
    </style>
    <style>
        /* Interaction safety layer for tab menus */
        .hero-section::before,
        .hero-section::after,
        .elegant-header::before,
        .elegant-header::after {
            pointer-events: none !important;
        }

        .section,
        .classic-section,
        .tab-container,
        .tab-nav {
            position: relative;
            z-index: 25;
        }

        .tab-btn,
        .category-tab-btn,
        .step-category-tab-btn {
            position: relative;
            z-index: 26;
            pointer-events: auto !important;
        }

        .tab-container .tab-content {
            display: none;
        }

        .tab-container .tab-content.active {
            display: block !important;
        }
    </style>
</head>
<body class="mono-editorial-theme">
    <!-- Hero Section -->
    <div class="hero-section">
        <div class="container" style="position: relative; z-index: 2;">
            <div class="hero-content hero-layout row g-4">
                <div class="col-lg-8 hero-left">
                    @if($salon->salon_profile_image)
                        <img src="{{ \Illuminate\Support\Facades\Storage::url($salon->salon_profile_image) }}" alt="{{ $salon->salon_name }}" class="profile-image">
                    @else
                        <div class="profile-image" style="background: {{ $salon->avatar_color }}; display: flex; align-items: center; justify-content: center; font-size: 48px; color: white; font-weight: bold;">
                            {{ $salon->initials }}
                        </div>
                    @endif
                    <h1>{{ $salon->salon_name }}</h1>
                    @if($ratingCount > 0)
                        <div class="rating-display" style="display: flex; align-items: center; justify-content: center; gap: 15px; margin: 20px 0;">
                            <div style="display: flex; align-items: center; gap: 8px;">
                                <div style="display: flex; gap: 3px;">
                                    @for($i = 1; $i <= 5; $i++)
                                        <i class="bi bi-star-fill" style="font-size: 24px; color: {{ $i <= round($averageRating) ? '#fbbf24' : '#e5e7eb' }};"></i>
                                    @endfor
                                </div>
                                <span style="font-size: 20px; font-weight: 700; color: rgba(255, 255, 255, 0.95);">{{ number_format($averageRating, 1) }}</span>
                            </div>
                            <span style="font-size: 16px; color: rgba(255, 255, 255, 0.85);">({{ $ratingCount }} değerlendirme)</span>
                        </div>
                    @else
                        <p class="lead" style="color: rgba(255, 255, 255, 0.9);">Henüz değerlendirme yapılmamış</p>
                    @endif
                    @if(!empty($salon->salon_description))
                        <p class="lead mb-0" style="max-width: 680px; color: rgba(255,255,255,0.92);">
                            {{ \Illuminate\Support\Str::limit(strip_tags($salon->salon_description), 160) }}
                        </p>
                    @endif
                </div>

                <div class="col-lg-4 hero-right">
                    <div class="hero-quick-panel">
                        <div class="hero-quick-title">Hızlı Bilgiler</div>
                        <a href="tel:{{ $salon->salon_phone ? preg_replace('/[^0-9+]/', '', $salon->salon_phone) : '' }}" class="hero-quick-item">
                            <i class="bi bi-telephone"></i>
                            <div>
                                <div class="small">Telefon</div>
                                <div class="value">{{ $salon->salon_phone ?: 'Telefon bilgisi yok' }}</div>
                            </div>
                        </a>
                        <div class="hero-quick-item">
                            <i class="bi bi-geo-alt"></i>
                            <div>
                                <div class="small">Adres</div>
                                <div class="value">{{ $salon->salon_address ?: 'Adres bilgisi yok' }}</div>
                            </div>
                        </div>
                        @php
                            $workingDayLabels = [
                                'monday' => 'Pazartesi',
                                'tuesday' => 'Salı',
                                'wednesday' => 'Çarşamba',
                                'thursday' => 'Perşembe',
                                'friday' => 'Cuma',
                                'saturday' => 'Cumartesi',
                                'sunday' => 'Pazar',
                            ];
                            $workingHours = is_array($salon->salon_working_hours ?? null) ? $salon->salon_working_hours : [];
                            $todayKey = strtolower(now()->locale('en')->englishDayOfWeek);
                        @endphp
                        <div class="hero-quick-item" style="align-items: flex-start;">
                            <i class="bi bi-clock"></i>
                            <div style="width: 100%;">
                                <div class="small">Çalışma Saatleri</div>
                                @if(!empty($workingHours))
                                    <div class="value" style="font-size: 0.92rem;">
                                        @foreach($workingDayLabels as $dayKey => $dayLabel)
                                            @php
                                                $dayData = $workingHours[$dayKey] ?? [];
                                                $isOpen = (bool) ($dayData['is_open'] ?? false);
                                                $openText = ($dayData['open_time'] ?? null) && ($dayData['close_time'] ?? null)
                                                    ? (($dayData['open_time'] ?? '') . ' - ' . ($dayData['close_time'] ?? ''))
                                                    : null;
                                            @endphp
                                            <div style="display:flex; justify-content:space-between; gap:12px; {{ $todayKey === $dayKey ? 'font-weight:700;' : '' }}">
                                                <span>{{ $dayLabel }}</span>
                                                <span>
                                                    {{ $isOpen ? ($openText ?: 'Açık') : 'Kapalı' }}
                                                </span>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <div class="value">Çalışma saatleri belirtilmemiş</div>
                                @endif
                            </div>
                        </div>
                        <button type="button" class="btn-modern w-100" data-bs-toggle="modal" data-bs-target="#appointmentModalV3" onclick="if (typeof openAppointmentModalV3 === 'function') { openAppointmentModalV3(); return false; }">
                            <i class="bi bi-calendar-check me-2"></i>Randevu Oluştur
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Services & Personel Section with Tabs -->
    <div class="section">
        <div class="container">
            <div class="tab-container" id="salon-tabs">
                @php
                    $allowedPublicTabs = ['services', 'gallery', 'personels', 'ratings'];
                    $activePublicTab = request()->query('tab', 'services');
                    if (!in_array($activePublicTab, $allowedPublicTabs, true)) {
                        $activePublicTab = 'services';
                    }
                @endphp
                <div class="tab-nav salon-tab-nav" role="tablist" aria-label="Salon bilgi sekmeleri">
                    <a class="salon-tab-btn {{ $activePublicTab === 'services' ? 'is-active' : '' }}" data-tab-key="services" href="{{ request()->fullUrlWithQuery(['tab' => 'services']) }}" role="tab" aria-controls="servicesTab" aria-selected="{{ $activePublicTab === 'services' ? 'true' : 'false' }}">
                        <i class="bi bi-scissors me-2"></i>Hizmetlerimiz
                    </a>
                    <a class="salon-tab-btn {{ $activePublicTab === 'gallery' ? 'is-active' : '' }}" data-tab-key="gallery" href="{{ request()->fullUrlWithQuery(['tab' => 'gallery']) }}" role="tab" aria-controls="galleryTab" aria-selected="{{ $activePublicTab === 'gallery' ? 'true' : 'false' }}">
                        <i class="bi bi-images me-2"></i>Galeri
                    </a>
                    <a class="salon-tab-btn {{ $activePublicTab === 'personels' ? 'is-active' : '' }}" data-tab-key="personels" href="{{ request()->fullUrlWithQuery(['tab' => 'personels']) }}" role="tab" aria-controls="personelsTab" aria-selected="{{ $activePublicTab === 'personels' ? 'true' : 'false' }}">
                        <i class="bi bi-people me-2"></i>Personellerimiz
                    </a>
                    <a class="salon-tab-btn {{ $activePublicTab === 'ratings' ? 'is-active' : '' }}" data-tab-key="ratings" href="{{ request()->fullUrlWithQuery(['tab' => 'ratings']) }}" role="tab" aria-controls="ratingsTab" aria-selected="{{ $activePublicTab === 'ratings' ? 'true' : 'false' }}">
                        <i class="bi bi-star me-2"></i>Yorumlar
                    </a>
                </div>
                <style>
                    .salon-tab-nav {
                        display: flex;
                        gap: 12px;
                        flex-wrap: nowrap;
                        overflow-x: auto;
                        padding-bottom: 6px;
                        position: relative;
                        z-index: 50;
                        pointer-events: auto;
                    }
                    .salon-tab-btn {
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border: 1px solid #e5e7eb;
                        background: #fff;
                        color: #111827;
                        border-radius: 10px;
                        padding: 10px 14px;
                        font-weight: 600;
                        text-decoration: none;
                        transition: all 0.2s ease;
                        white-space: nowrap;
                        min-width: 140px;
                    }
                    .salon-tab-btn:hover {
                        border-color: #d1d5db;
                        transform: translateY(-1px);
                    }
                    .salon-tab-btn.is-active {
                        border-color: #ec4899;
                        color: #111827;
                        background: #fdf2f8;
                    }
                    .salon-tab-pane {
                        display: none;
                        margin-top: 24px;
                    }
                    .salon-tab-pane.is-active {
                        display: block;
                    }
                    .compact-filter-wrap {
                        border: 1px solid #e5e7eb;
                        background: #f8fafc;
                        border-radius: 12px;
                        padding: 12px;
                    }
                    .compact-filter-select {
                        border-radius: 10px;
                        border-color: #d1d5db;
                        background: #fff;
                    }
                </style>
                <script>
                    (function () {
                        const container = document.getElementById('salon-tabs');
                        if (!container || container.dataset.clientTabsReady === '1') return;
                        container.dataset.clientTabsReady = '1';

                        const tabMap = {
                            services: 'servicesTab',
                            gallery: 'galleryTab',
                            personels: 'personelsTab',
                            ratings: 'ratingsTab'
                        };

                        function activate(tabKey, shouldUpdateUrl) {
                            const targetId = tabMap[tabKey];
                            if (!targetId) return;

                            container.querySelectorAll('.salon-tab-btn[data-tab-key]').forEach((link) => {
                                const isActive = link.getAttribute('data-tab-key') === tabKey;
                                link.classList.toggle('is-active', isActive);
                                link.setAttribute('aria-selected', isActive ? 'true' : 'false');
                            });
                            container.querySelectorAll('.salon-tab-pane').forEach((pane) => {
                                pane.classList.toggle('is-active', pane.id === targetId);
                            });

                            if (shouldUpdateUrl && window.history && typeof window.history.replaceState === 'function') {
                                const url = new URL(window.location.href);
                                url.searchParams.set('tab', tabKey);
                                window.history.replaceState({}, '', `${url.pathname}?${url.searchParams.toString()}`);
                            }
                        }

                        container.addEventListener('click', function (event) {
                            const link = event.target.closest('.salon-tab-btn[data-tab-key]');
                            if (!link || !container.contains(link)) return;
                            event.preventDefault();
                            const tabKey = link.getAttribute('data-tab-key');
                            if (tabKey) activate(tabKey, true);
                        });
                    })();
                </script>

                <!-- Services Tab -->
                <div id="servicesTab" class="salon-tab-pane {{ $activePublicTab === 'services' ? 'is-active' : '' }}" role="tabpanel">
                    <!-- Category Tabs -->
                    @if($serviceCategories && $serviceCategories->count() > 0)
                        <div class="category-tabs mb-4 compact-filter-wrap">
                            <label for="serviceCategorySelect" class="form-label mb-2 fw-semibold">Kategori</label>
                            <select id="serviceCategorySelect" class="form-select compact-filter-select" onchange="switchServiceCategory(this.value)">
                                <option value="all">Tum Hizmetler</option>
                                @foreach($serviceCategories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }} ({{ $category->services_count }})</option>
                                @endforeach
                            </select>
                        </div>
                    @endif

                    <!-- All Services Content -->
                    <div id="serviceCategoryContent-all" class="service-category-content">
                        <div class="row">
                            @forelse($services as $service)
                                <div class="col-md-4 mb-4 service-item" data-service-id="{{ $service->id }}" data-category-id="{{ $service->service_category_id ?? 'none' }}">
                                    <div class="card service-card h-100">
                                        <div class="card-body">
                                            <h5>{{ $service->name }}</h5>
                                            @if($service->description)
                                                <p class="card-text">{{ \Illuminate\Support\Str::limit($service->description, 100) }}</p>
                                            @endif
                                            <div class="d-flex justify-content-between align-items-center mt-4">
                                                <div>
                                                    <div class="price-badge">{{ number_format($service->price, 2, ',', '.') }} ₺</div>
                                                    @if($service->duration)
                                                        <div class="duration-badge"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dakika</div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-12 text-center">
                                    <p class="text-muted">Henüz hizmet bulunmamaktadır.</p>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <!-- Category Services Content -->
                    @foreach($serviceCategories as $category)
                        <div id="serviceCategoryContent-{{ $category->id }}" class="service-category-content" style="display: none;">
                            <div class="row">
                                @php
                                    $categoryServices = $services->where('service_category_id', $category->id);
                                @endphp
                                @forelse($categoryServices as $service)
                                    <div class="col-md-4 mb-4 service-item" data-service-id="{{ $service->id }}" data-category-id="{{ $service->service_category_id ?? 'none' }}">
                                        <div class="card service-card h-100">
                                            <div class="card-body">
                                                <h5>{{ $service->name }}</h5>
                                                @if($service->description)
                                                    <p class="card-text">{{ \Illuminate\Support\Str::limit($service->description, 100) }}</p>
                                                @endif
                                                <div class="d-flex justify-content-between align-items-center mt-4">
                                                    <div>
                                                        <div class="price-badge">{{ number_format($service->price, 2, ',', '.') }} ₺</div>
                                                        @if($service->duration)
                                                            <div class="duration-badge"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dakika</div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <div class="col-12 text-center">
                                        <p class="text-muted">Bu kategoride henüz hizmet bulunmamaktadır.</p>
                                    </div>
                                @endforelse
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Gallery Tab -->
                <div id="galleryTab" class="salon-tab-pane {{ $activePublicTab === 'gallery' ? 'is-active' : '' }}" role="tabpanel">
                    @if($salon->salon_gallery && is_array($salon->salon_gallery) && count($salon->salon_gallery) > 0)
                        <div class="gallery-grid-public">
                            @foreach($salon->salon_gallery as $imagePath)
                                <div class="gallery-item-public">
                                    <img src="{{ \Illuminate\Support\Facades\Storage::url($imagePath) }}" alt="{{ $salon->salon_name }} Galeri" class="gallery-image-public" onclick="openGalleryModal('{{ \Illuminate\Support\Facades\Storage::url($imagePath) }}')">
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="col-12 text-center py-5">
                            <i class="bi bi-images" style="font-size: 64px; color: #cbd5e1;"></i>
                            <p class="text-muted mt-3">Henüz galeri görseli bulunmamaktadır.</p>
                        </div>
                    @endif
                </div>

                <!-- Personels Tab -->
                <div id="personelsTab" class="salon-tab-pane {{ $activePublicTab === 'personels' ? 'is-active' : '' }}" role="tabpanel">
                    <div class="row">
                        @forelse($personels as $personel)
                            <div class="col-md-4 mb-4">
                                <div class="card personel-card h-100">
                                    <div class="card-body text-center">
                                        <div class="personel-avatar" style="background: {{ $personel->avatar_color }};">
                                            {{ $personel->initials }}
                                        </div>
                                        <h5>{{ $personel->name }}</h5>
                                        @if($personel->services && $personel->services->count() > 0)
                                            <div class="mt-3">
                                                @foreach($personel->services as $service)
                                                    <span class="service-badge">{{ $service->name }}</span>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="col-12 text-center">
                                <p class="text-muted">Henüz personel bilgisi bulunmamaktadır.</p>
                            </div>
                        @endforelse
                    </div>
                </div>

                <!-- Ratings Tab -->
                <div id="ratingsTab" class="salon-tab-pane {{ $activePublicTab === 'ratings' ? 'is-active' : '' }}" role="tabpanel">
                    @if($ratings && $ratings->count() > 0)
                        <div class="row">
                            @foreach($ratings as $ratingItem)
                                <div class="col-12 mb-4">
                                    <div class="card" style="border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px;">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-start mb-3">
                                                <div>
                                                    <h6 class="mb-1 fw-bold">
                                                        @php
                                                            $customerName = $ratingItem->customer_name ?: 'Anonim';
                                                            if ($customerName !== 'Anonim' && strpos($customerName, ' ') !== false) {
                                                                $nameParts = explode(' ', $customerName, 2);
                                                                $firstName = $nameParts[0];
                                                                $lastName = $nameParts[1] ?? '';
                                                                if ($lastName) {
                                                                    $lastNameInitial = mb_substr($lastName, 0, 1);
                                                                    $maskedLastName = $lastNameInitial . '****';
                                                                    $customerName = $firstName . ' ' . $maskedLastName;
                                                                }
                                                            }
                                                        @endphp
                                                        {{ $customerName }}
                                                    </h6>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="d-flex gap-1">
                                                            @for($i = 1; $i <= 5; $i++)
                                                                <i class="bi bi-star-fill" style="font-size: 14px; color: {{ $i <= $ratingItem->rating ? '#fbbf24' : '#e5e7eb' }};"></i>
                                                            @endfor
                                                        </div>
                                                        <span class="text-muted small">{{ $ratingItem->created_at->format('d.m.Y') }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            @if($ratingItem->comment)
                                                <p class="mb-0" style="color: #374151; line-height: 1.6;">{{ $ratingItem->comment }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-star" style="font-size: 48px; color: #d1d5db;"></i>
                            <p class="text-muted mt-3">Henüz yorum yapılmamış.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Gallery Modal -->
    <div class="modal fade" id="galleryModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content" style="background: transparent; border: none;">
                <button type="button" class="btn-close btn-close-white position-absolute top-0 end-0 m-3" style="z-index: 1051; background: rgba(0,0,0,0.5); border-radius: 50%; padding: 10px;" data-bs-dismiss="modal" aria-label="Close"></button>
                <img id="galleryModalImage" src="" alt="Galeri Görseli" style="width: 100%; border-radius: 12px;">
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        <div class="container">
            <p class="mb-0">&copy; {{ date('Y') }} {{ $salon->salon_name }}. Tüm hakları saklıdır.</p>
        </div>
    </footer>

    <style>
        #appointmentModal .modal-content {
            border: 0;
            border-radius: 18px;
            overflow: hidden;
            box-shadow: 0 18px 50px rgba(0, 0, 0, 0.22);
        }
        #appointmentModal .modal-header {
            padding: 18px 20px 12px;
            border-bottom: 1px solid #f1f5f9;
            background: linear-gradient(180deg, #ffffff 0%, #fcfcfd 100%);
        }
        #appointmentModal .modal-title {
            font-size: 1.05rem;
            font-weight: 700;
            color: #111827;
        }
        .appointment-progress {
            padding: 0 20px 14px;
            border-bottom: 1px solid #f1f5f9;
            background: #fff;
        }
        .appointment-progress-track {
            height: 6px;
            border-radius: 999px;
            background: #e5e7eb;
            overflow: hidden;
            margin-bottom: 10px;
        }
        .appointment-progress-bar {
            height: 100%;
            width: 16.66%;
            background: linear-gradient(90deg, #ec4899 0%, #db2777 100%);
            transition: width 0.25s ease;
        }
        .appointment-progress-steps {
            display: grid;
            grid-template-columns: repeat(6, minmax(0, 1fr));
            gap: 6px;
        }
        .appointment-progress-step {
            font-size: 11px;
            color: #94a3b8;
            text-align: center;
            font-weight: 600;
        }
        .appointment-progress-step.is-active {
            color: #be185d;
        }
        #appointmentModal .modal-body {
            padding: 18px 20px;
            background: #fff;
        }
        #appointmentModal .appointment-step h6 {
            font-size: 0.98rem;
            margin-bottom: 14px;
        }
        #appointmentModal .modal-footer {
            border-top: 1px solid #f1f5f9;
            padding: 14px 20px;
            background: #fff;
        }
        .appointment-footer-actions {
            display: flex;
            width: 100%;
            justify-content: space-between;
            gap: 10px;
            align-items: center;
        }
        .appointment-footer-actions-right {
            display: flex;
            gap: 8px;
            align-items: center;
        }
        /* V3 Randevu Tasarimi */
        #appointmentModalV3 .modal-content {
            border-radius: 20px;
            overflow: hidden;
        }
        #appointmentModalV3 .modal-header {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            border-bottom: 0;
            color: #fff;
        }
        #appointmentModalV3 .modal-title {
            color: #fff;
            font-weight: 700;
        }
        #appointmentModalV3 .btn-close {
            filter: invert(1);
        }
        .v3-section-card {
            border: 1px solid #f1f5f9;
            border-radius: 14px;
            background: #fff;
            padding: 12px;
            margin-bottom: 12px;
        }
        .v3-step-title {
            font-size: 1rem;
            font-weight: 700;
            color: #0f172a;
            margin-bottom: 6px;
        }
        .v3-step-subtitle {
            color: #64748b;
            font-size: 0.88rem;
            margin-bottom: 12px;
        }
        .v3-service-grid {
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            gap: 10px;
        }
        .v3-service-chip {
            width: 100%;
            text-align: left;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 10px 12px;
            background: #fff;
            transition: all .2s ease;
            position: relative;
        }
        .v3-service-chip:hover {
            border-color: #f9a8d4;
            transform: translateY(-1px);
            box-shadow: 0 6px 14px rgba(236, 72, 153, 0.12);
        }
        .v3-service-chip.is-selected {
            border-color: #ec4899;
            background: linear-gradient(180deg, #fff 0%, #fdf2f8 100%);
            box-shadow: 0 8px 18px rgba(236, 72, 153, 0.2);
        }
        .v3-service-chip .v3-check {
            position: absolute;
            top: 8px;
            right: 8px;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: #ec4899;
            color: #fff;
            display: none;
            align-items: center;
            justify-content: center;
            font-size: 11px;
        }
        .v3-service-chip.is-selected .v3-check { display: flex; }
        .v3-service-name {
            display: block;
            font-weight: 600;
            color: #0f172a;
            margin-bottom: 3px;
            padding-right: 20px;
        }
        .v3-service-meta {
            font-size: 0.78rem;
            color: #64748b;
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
        }
        .v3-calendar-grid {
            display: grid;
            grid-template-columns: repeat(7, minmax(0, 1fr));
            gap: 6px;
        }
        .v3-day-btn {
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            background: #fff;
            min-height: 70px;
            padding: 6px 4px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            gap: 2px;
            transition: all .2s ease;
        }
        .v3-day-btn .v3-day-week {
            font-size: 11px;
            color: #64748b;
            font-weight: 600;
        }
        .v3-day-btn .v3-day-num {
            font-size: 16px;
            font-weight: 700;
            color: #0f172a;
        }
        .v3-day-btn:hover:not(:disabled) {
            border-color: #f9a8d4;
            transform: translateY(-1px);
        }
        .v3-day-btn.is-selected {
            border-color: #ec4899;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        }
        .v3-day-btn.is-selected .v3-day-week,
        .v3-day-btn.is-selected .v3-day-num {
            color: #fff;
        }
        .v3-day-btn:disabled {
            opacity: .45;
            background: #f8fafc;
        }
        .v3-time-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(96px, 1fr));
            gap: 8px;
        }
        .v3-time-btn {
            border: 1px solid #e2e8f0;
            background: #fff;
            border-radius: 10px;
            height: 40px;
            font-size: 0.84rem;
            font-weight: 600;
            color: #0f172a;
            transition: all .2s ease;
        }
        .v3-time-btn:hover:not(:disabled) {
            border-color: #f9a8d4;
            transform: translateY(-1px);
        }
        .v3-time-btn.is-selected {
            border-color: #ec4899;
            background: #ec4899;
            color: #fff;
        }
        .v3-time-btn:disabled {
            opacity: .55;
            color: #94a3b8;
            background: #f8fafc;
        }
        @media (max-width: 768px) {
            .v3-service-grid { grid-template-columns: 1fr; }
            .v3-calendar-grid { gap: 4px; }
            .v3-day-btn { min-height: 62px; }
            .v3-day-btn .v3-day-num { font-size: 14px; }
        }
    </style>

    <!-- Modern Randevu Talep Modal -->
    <div class="modal fade" id="appointmentModal" tabindex="-1" aria-labelledby="appointmentModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="appointmentModalLabel">
                        <i class="bi bi-calendar-check me-2"></i>Randevu Talebi
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="appointment-progress">
                    <div class="appointment-progress-track">
                        <div class="appointment-progress-bar" id="appointmentProgressBar"></div>
                    </div>
                    <div class="appointment-progress-steps">
                        <div class="appointment-progress-step is-active" data-step-indicator="1">Telefon</div>
                        <div class="appointment-progress-step" data-step-indicator="2">Bilgi</div>
                        <div class="appointment-progress-step" data-step-indicator="3">Kod</div>
                        <div class="appointment-progress-step" data-step-indicator="4">Hizmet</div>
                        <div class="appointment-progress-step" data-step-indicator="5">Tarih</div>
                        <div class="appointment-progress-step" data-step-indicator="6">Saat</div>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- Step 1: Telefon Numarası -->
                    <div id="step1" class="appointment-step">
                        <h6><i class="bi bi-phone me-2"></i>1. Adım: Telefon Numarası</h6>
                        <form id="step1Form">
                            <div class="mb-4">
                                <label for="customerPhone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="tel" class="form-control" id="customerPhone" name="phone" placeholder="05XX XXX XX XX" required>
                                    <button type="button" class="btn btn-primary-modern" id="verifyPhoneBtn" onclick="checkPhone()">
                                        <i class="bi bi-check-circle me-1"></i>Kontrol Et
                                    </button>
                                </div>
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>Telefon numaranızı girerek devam edin.
                                </small>
                            </div>
                            <div id="customerInfo" style="display: none;" class="alert-modern">
                                <i class="bi bi-info-circle me-2"></i>
                                <span id="customerInfoText"></span>
                            </div>
                        </form>
                    </div>

                    <!-- Step 2: Kayıtsız Müşteri Bilgileri -->
                    <div id="step2" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-person me-2"></i>2. Adım: Bilgilerinizi Tamamlayın</h6>
                        <div id="newCustomerSection">
                            <div class="mb-4">
                                <label for="customerName" class="form-label">İsim <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="customerName" name="name" placeholder="Adınızı giriniz" required>
                            </div>
                            <div class="mb-4">
                                <label for="customerSurname" class="form-label">Soyisim <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="customerSurname" name="surname" placeholder="Soyadınızı giriniz" required>
                            </div>
                            <div class="mb-4">
                                <label for="customerAge" class="form-label">Yaş <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="customerAge" name="age" min="1" max="120" placeholder="Yaşınızı giriniz" required>
                            </div>
                            <div class="mb-4">
                                <label for="referralCode" class="form-label">
                                    <i class="bi bi-gift me-1"></i>Referans Kodu <small class="text-muted">(Opsiyonel)</small>
                                </label>
                                <input type="text" class="form-control" id="referralCode" name="referral_code" maxlength="6" placeholder="000000" pattern="[0-9]{6}">
                                <small class="text-muted d-block mt-1">
                                    <i class="bi bi-info-circle me-1"></i>Eğer bir arkadaşınızdan referans kodu aldıysanız buraya girin
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Step 3: OTP Doğrulama -->
                    <div id="step3" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-shield-check me-2"></i>3. Adım: Telefon Doğrulama</h6>
                        <div id="otpSection">
                            <div class="mb-4">
                                <label for="otpCode" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="otpCode" name="otp_code" maxlength="6" placeholder="000000" required>
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>Telefonunuza gönderilen 6 haneli kodu giriniz.
                                </small>
                            </div>
                            <div class="mb-3">
                                <button type="button" class="btn btn-outline-primary-modern" id="resendOTPBtn" onclick="resendOTP()">
                                    <i class="bi bi-arrow-clockwise me-1"></i>Kodu Tekrar Gönder
                                </button>
                                <small class="text-muted d-block mt-2" id="resendCountdown" style="display: none;">
                                    <i class="bi bi-clock me-1"></i><span id="countdownText">60</span> saniye sonra tekrar gönderebilirsiniz.
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Step 4: Hizmet Seçimi -->
                    <div id="step4" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-list-check me-2"></i>4. Adım: Hizmet Seçimi</h6>
                        
                        <div class="alert alert-info mb-4">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgilendirme:</strong> Randevu almak istediğiniz hizmet(ler)i seçiniz. Birden fazla hizmet seçebilirsiniz.
                        </div>
                        
                        <!-- Kategori Sekmeleri -->
                        @if($serviceCategories && $serviceCategories->count() > 0)
                            <div class="mb-4 compact-filter-wrap">
                                <label for="stepServiceCategorySelect" class="form-label mb-2 fw-semibold">Kategori</label>
                                <select id="stepServiceCategorySelect" class="form-select compact-filter-select" onchange="switchStepServiceCategory(this.value)">
                                    <option value="all">Tum Hizmetler</option>
                                    @foreach($serviceCategories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }} ({{ $category->services_count }})</option>
                                    @endforeach
                                </select>
                            </div>
                        @endif
                        
                        <!-- Hizmet Seçimi -->
                        <div class="mb-3">
                            <label class="form-label">Hizmet Seçiniz <span class="text-danger">*</span> 
                                <span id="selectedServicesCount" class="badge bg-primary ms-2" style="display: none;">0 hizmet seçildi</span>
                            </label>
                            <p class="text-muted small mb-3">İstediğiniz hizmet(ler)i seçerek devam edebilirsiniz. Birden fazla hizmet seçmek için kartlara tıklayın.</p>
                            
                            <!-- Tüm Hizmetler -->
                            <div id="stepServicesContent-all" class="step-services-category-content">
                                <div class="row" id="servicesList">
                                    @foreach($services as $service)
                                        <div class="col-md-6 mb-3">
                                            <div class="service-option-card" data-service-id="{{ $service->id }}" onclick="selectService({{ $service->id }})">
                                                <div class="card-body" style="position: relative; z-index: 1;">
                                                    <div class="d-flex align-items-start">
                                                        <div class="service-checkbox-wrapper" style="margin-right: 12px; margin-top: 2px;">
                                                            <div class="service-checkbox" data-service-id="{{ $service->id }}">
                                                                <i class="bi bi-check"></i>
                                                            </div>
                                                        </div>
                                                        <div style="flex: 1;">
                                                            <h6 class="mb-2" style="font-weight: 600;">{{ $service->name }}</h6>
                                                            @if($service->description)
                                                                <p class="text-muted small mb-3">{{ \Illuminate\Support\Str::limit($service->description, 80) }}</p>
                                                            @endif
                                                            <div class="d-flex justify-content-between align-items-center">
                                                                <div>
                                                                    <strong class="price-badge" style="font-size: 1.2rem;">{{ number_format($service->price, 2, ',', '.') }} ₺</strong>
                                                                    @if($service->duration)
                                                                        <div class="duration-badge"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dk</div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <!-- Kategori Hizmetleri -->
                            @foreach($serviceCategories as $category)
                                @php
                                    $categoryServices = $services->where('service_category_id', $category->id);
                                @endphp
                                <div id="stepServicesContent-{{ $category->id }}" class="step-services-category-content" style="display: none;">
                                    <div class="row">
                                        @forelse($categoryServices as $service)
                                            <div class="col-md-6 mb-3">
                                                <div class="service-option-card" data-service-id="{{ $service->id }}" onclick="selectService({{ $service->id }})">
                                                    <div class="card-body" style="position: relative; z-index: 1;">
                                                        <div class="d-flex align-items-start">
                                                            <div class="service-checkbox-wrapper" style="margin-right: 12px; margin-top: 2px;">
                                                                <div class="service-checkbox" data-service-id="{{ $service->id }}">
                                                                    <i class="bi bi-check"></i>
                                                                </div>
                                                            </div>
                                                            <div style="flex: 1;">
                                                                <h6 class="mb-2" style="font-weight: 600;">{{ $service->name }}</h6>
                                                                @if($service->description)
                                                                    <p class="text-muted small mb-3">{{ \Illuminate\Support\Str::limit($service->description, 80) }}</p>
                                                                @endif
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div>
                                                                        <strong class="price-badge" style="font-size: 1.2rem;">{{ number_format($service->price, 2, ',', '.') }} ₺</strong>
                                                                        @if($service->duration)
                                                                            <div class="duration-badge"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dk</div>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @empty
                                            <div class="col-12 text-center">
                                                <p class="text-muted">Bu kategoride henüz hizmet bulunmamaktadır.</p>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <input type="hidden" id="selectedServiceId" name="service_id">
                        <input type="hidden" id="selectedServiceIds" name="service_ids">
                        
                        <!-- Referans Kodu (OTP doğrulama sonrası değiştirilebilir) -->
                        <div class="mb-4" id="referralCodeStep4Container" style="display: none; background: #f0f9ff; padding: 15px; border-radius: 8px; border: 2px solid #ec4899; margin-top: 20px;">
                            <label for="referralCodeStep4" class="form-label">
                                <i class="bi bi-gift me-1"></i>Referans Kodu <small class="text-muted">(Opsiyonel - Değiştirebilirsiniz)</small>
                            </label>
                            <input type="text" class="form-control" id="referralCodeStep4" name="referral_code_step4" maxlength="6" placeholder="000000" pattern="[0-9]{6}">
                            <small class="text-muted d-block mt-1">
                                <i class="bi bi-info-circle me-1"></i>Eğer bir arkadaşınızdan referans kodu aldıysanız buraya girin. Daha önce girilen kod varsa değiştirebilirsiniz.
                            </small>
                        </div>
                    </div>

                    <!-- Step 5: Tarih Seçimi -->
                    <div id="step5" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-calendar3 me-2"></i>5. Adım: Tarih Seçimi</h6>
                        
                        <div class="alert alert-info mb-4" id="step5Info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgilendirme:</strong> Lütfen randevu için uygun tarihi seçiniz.
                        </div>

                        <!-- Tarih Seçimi -->
                        <div class="mb-4">
                            <label class="form-label">Tarih Seçiniz <span class="text-danger">*</span></label>
                            <div class="row" id="dateList">
                                <!-- 2 haftalık tarih listesi JavaScript ile doldurulacak -->
                            </div>
                        </div>

                        <input type="hidden" id="selectedDate" name="appointment_date">
                    </div>

                    <!-- Step 6: Saat Seçimi -->
                    <div id="step6" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-clock me-2"></i>6. Adım: Saat Seçimi</h6>
                        
                        <div class="alert alert-info mb-4" id="step6Info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgilendirme:</strong> Lütfen randevu için uygun saati seçiniz.
                        </div>

                        <!-- Saat Seçimi -->
                        <div class="mb-4" id="timeSelectionContainer">
                            <label class="form-label">Saat Seçiniz <span class="text-danger">*</span></label>
                            <div class="alert alert-warning mb-3" style="font-size: 0.875rem;">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <strong>Not:</strong> Dolu saatler seçilemez. Tüm personellerin müsait olduğu saatleri seçebilirsiniz.
                            </div>
                            <div class="row" id="timeList">
                                <!-- Saatler JavaScript ile doldurulacak -->
                            </div>
                        </div>

                        <input type="hidden" id="selectedTime" name="appointment_time">
                        
                        <!-- Tekrarlanan Seans Seçeneği -->
                        <div class="mb-4 mt-4" style="border-top: 2px solid #e5e7eb; padding-top: 20px;">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="enableRecurring" onchange="toggleRecurringOptions()" style="width: 20px; height: 20px; cursor: pointer;">
                                <label class="form-check-label" for="enableRecurring" style="font-weight: 600; font-size: 1rem; cursor: pointer; margin-left: 8px;">
                                    <i class="bi bi-calendar-repeat me-2"></i>Bu randevuyu tekrarlamak istiyorum
                                </label>
                            </div>
                            
                            <div id="recurringOptions" style="display: none; background: #f9fafb; padding: 20px; border-radius: 12px; margin-top: 15px;">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Tekrarlama Tipi <span class="text-danger">*</span></label>
                                        <select class="form-select" id="recurring_type" name="recurring_type" onchange="toggleRecurringDayOptions()" style="border-radius: 8px; padding: 10px;">
                                            <option value="">Seçiniz</option>
                                            <option value="weekly">Haftalık</option>
                                            <option value="monthly">Aylık</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3" id="day_of_week_container" style="display: none;">
                                        <label class="form-label">Haftanın Günü <span class="text-danger">*</span></label>
                                        <select class="form-select" id="day_of_week" name="day_of_week" style="border-radius: 8px; padding: 10px;">
                                            <option value="">Seçiniz</option>
                                            <option value="1">Pazartesi</option>
                                            <option value="2">Salı</option>
                                            <option value="3">Çarşamba</option>
                                            <option value="4">Perşembe</option>
                                            <option value="5">Cuma</option>
                                            <option value="6">Cumartesi</option>
                                            <option value="7">Pazar</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3" id="day_of_month_container" style="display: none;">
                                        <label class="form-label">Ayın Günü <span class="text-danger">*</span></label>
                                        <select class="form-select" id="day_of_month" name="day_of_month" style="border-radius: 8px; padding: 10px;">
                                            <option value="">Seçiniz</option>
                                            @for($i = 1; $i <= 31; $i++)
                                                <option value="{{ $i }}">{{ $i }}</option>
                                            @endfor
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Kaç Kez Tekrarlansın? <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" id="recurring_count" name="recurring_count" min="1" max="24" value="1" style="border-radius: 8px; padding: 10px;" placeholder="1-24 arası">
                                        <small class="text-muted">Maksimum 24 kez tekrarlanabilir</small>
                                    </div>
                                </div>
                                
                                <div class="alert alert-info mt-3 mb-0" style="font-size: 0.875rem;">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <strong>Bilgi:</strong> Tekrarlanan randevular otomatik olarak oluşturulacak ve size WhatsApp ile hatırlatma mesajı gönderilecektir.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="appointment-footer-actions">
                        <button type="button" class="btn btn-light border" data-bs-dismiss="modal">Kapat</button>
                        <div class="appointment-footer-actions-right">
                            <button type="button" class="btn btn-outline-primary-modern" id="prevStepBtn" onclick="prevStep()" style="display: none;">
                                <i class="bi bi-arrow-left me-1"></i>Geri
                            </button>
                            <button type="button" class="btn btn-primary-modern" id="nextStepBtn" onclick="nextStep()" style="display: none;">
                                Devam<i class="bi bi-arrow-right ms-1"></i>
                            </button>
                            <button type="button" class="btn btn-primary-modern" id="submitBtn" style="display: none;">
                                <i class="bi bi-check-circle me-1"></i>Talep Gonder
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Güvenli fallback: Ana script yüklenemese bile "Randevu Oluştur" butonu modal açabilsin.
        if (typeof window.openAppointmentModal !== 'function') {
            window.openAppointmentModal = function() {
                const modalElement = document.getElementById('appointmentModal');
                if (modalElement && window.bootstrap && window.bootstrap.Modal) {
                    new bootstrap.Modal(modalElement).show();
                }
            };
        }
    </script>
    <script>
        // CSS değişkenlerini JavaScript'te kullanmak için helper fonksiyon
        function getPrimaryColor() {
            return getComputedStyle(document.documentElement).getPropertyValue('--primary-color').trim();
        }
        
        function getPrimaryColorRgba() {
            return getComputedStyle(document.documentElement).getPropertyValue('--rgba-primary').trim();
        }
        
        // Tab Switching Function
        function switchTab(tabName) {
            // Remove active class from all tabs and buttons
            document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
                content.style.display = 'none';
            });

            const targetBtn = Array.from(document.querySelectorAll('.tab-btn')).find(btn => {
                const fromData = btn.getAttribute('data-tab');
                const fromOnclick = btn.getAttribute('onclick') || '';
                return fromData === tabName || fromOnclick.includes(`switchTab('${tabName}')`);
            });
            if (targetBtn) {
                targetBtn.classList.add('active');
            }

            const tabIdMap = {
                services: 'servicesTab',
                gallery: 'galleryTab',
                personels: 'personelsTab',
                ratings: 'ratingsTab'
            };
            const targetContent = document.getElementById(tabIdMap[tabName] || `${tabName}Tab`);
            if (targetContent) {
                targetContent.classList.add('active');
                targetContent.style.display = 'block';
            }
        }

        // Service Category Switching Function
        function switchServiceCategory(categoryId) {
            const categorySelect = document.getElementById('serviceCategorySelect');
            if (categorySelect && String(categorySelect.value) !== String(categoryId)) {
                categorySelect.value = String(categoryId);
            }

            // Remove active class from all category tabs
            document.querySelectorAll('.category-tab-btn').forEach(btn => {
                btn.classList.remove('active');
                btn.style.background = '#f3f4f6';
                btn.style.color = '#374151';
            });

            // Hide all category contents
            document.querySelectorAll('.service-category-content').forEach(content => {
                content.style.display = 'none';
            });

            // Add active class to selected category tab
            const selectedBtn = document.querySelector(`.category-tab-btn[data-category="${categoryId}"]`);
            if (selectedBtn) {
                selectedBtn.classList.add('active');
                selectedBtn.style.background = '#fce7f3';
                selectedBtn.style.color = '#111827';
                selectedBtn.style.border = '1px solid #ec4899';
            }

            // Show selected category content
            const selectedContent = document.getElementById(`serviceCategoryContent-${categoryId}`);
            if (selectedContent) {
                selectedContent.style.display = 'block';
            }
        }

        let currentStep = 1;
        let selectedServiceId = null;
        let selectedServiceIds = [];
        let isRegisteredCustomer = false;
        let customerId = null;
        let customerName = '';
        let salonId = {{ $salon->id }};
        let resendOTPCooldown = 0; // Cooldown süresi (saniye)
        let resendOTPTimer = null; // Timer referansı

        function openAppointmentModal(serviceId = null) {
            try {
                selectedServiceId = serviceId;
                selectedServiceIds = serviceId ? [serviceId] : [];
                currentStep = 1;
                isRegisteredCustomer = false;
                customerId = null;
                customerName = '';
                
                // Reset form
                const step1Form = document.getElementById('step1Form');
                if (step1Form) step1Form.reset();
                
                const step2 = document.getElementById('step2');
                const step3 = document.getElementById('step3');
                const step4 = document.getElementById('step4');
                const step5 = document.getElementById('step5');
                const step1 = document.getElementById('step1');
                const customerInfo = document.getElementById('customerInfo');
                const prevStepBtn = document.getElementById('prevStepBtn');
                const nextStepBtn = document.getElementById('nextStepBtn');
                const submitBtn = document.getElementById('submitBtn');
                
                const step6 = document.getElementById('step6');
                if (step2) step2.style.display = 'none';
                if (step3) step3.style.display = 'none';
                if (step4) step4.style.display = 'none';
                if (step5) step5.style.display = 'none';
                if (step6) step6.style.display = 'none';
                if (step1) step1.style.display = 'block';
                if (customerInfo) customerInfo.style.display = 'none';
                if (prevStepBtn) prevStepBtn.style.display = 'none';
                if (nextStepBtn) nextStepBtn.style.display = 'none';
                if (submitBtn) submitBtn.style.display = 'none';
                
                // Tarih ve saat seçimlerini sıfırla
                if (document.getElementById('selectedDate')) document.getElementById('selectedDate').value = '';
                if (document.getElementById('selectedTime')) document.getElementById('selectedTime').value = '';
                document.querySelectorAll('.service-option-card').forEach(card => {
                    card.classList.remove('border-primary');
                    const checkbox = card.querySelector('.service-checkbox');
                    const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                    if (checkbox) {
                        checkbox.style.background = 'white';
                        checkbox.style.borderColor = '#e5e7eb';
                        checkbox.style.setProperty('background', 'white', 'important');
                        checkbox.style.setProperty('border-color', '#e5e7eb', 'important');
                    }
                    if (checkboxIcon) {
                        checkboxIcon.style.display = 'none';
                    }
                });
                updateSelectedServicesCount();
                switchStepServiceCategory('all');
                
                // Eğer hizmet seçildiyse direkt 4. etaba geç
                if (serviceId) {
                    selectedServiceIds = [serviceId];
                    const selectedServiceIdInput = document.getElementById('selectedServiceId');
                    if (selectedServiceIdInput) {
                        selectedServiceIdInput.value = serviceId;
                    }
                    const selectedServiceIdsInput = document.getElementById('selectedServiceIds');
                    if (selectedServiceIdsInput) {
                        selectedServiceIdsInput.value = JSON.stringify(selectedServiceIds);
                    }
                    // Hizmet seçimini göster
                    document.querySelectorAll('.service-option-card').forEach(card => {
                        const cardServiceId = card.getAttribute('data-service-id');
                        if (cardServiceId == serviceId || cardServiceId == serviceId.toString()) {
                            card.classList.add('border-primary');
                            // Checkbox'ı pembe renge çevir
                            const checkbox = card.querySelector('.service-checkbox');
                            const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                            if (checkbox) {
                                checkbox.style.background = '#ec4899';
                                checkbox.style.borderColor = '#ec4899';
                                checkbox.style.setProperty('background', '#ec4899', 'important');
                                checkbox.style.setProperty('border-color', '#ec4899', 'important');
                            }
                            if (checkboxIcon) {
                                checkboxIcon.style.display = 'flex';
                                checkboxIcon.style.setProperty('display', 'flex', 'important');
                            }
                        }
                    });
                    updateSelectedServicesCount();
                }
                
                // Modal'ı aç
                const modalElement = document.getElementById('appointmentModal');
                if (modalElement) {
                    const modal = new bootstrap.Modal(modalElement);
                    modal.show();
                } else {
                    console.error('appointmentModal elementi bulunamadı');
                }
            } catch (error) {
                console.error('openAppointmentModal hatası:', error);
                alert('Randevu modalı açılırken bir hata oluştu. Lütfen sayfayı yenileyin.');
            }
        }

        function checkPhone() {
            const phoneInput = document.getElementById('customerPhone');
            const verifyBtn = document.getElementById('verifyPhoneBtn');
            if (!phoneInput || !verifyBtn) {
                alert('Telefon doğrulama alanları bulunamadı. Lütfen sayfayı yenileyin.');
                return;
            }
            const phone = phoneInput.value.trim();
            
            if (!phone) {
                alert('Lütfen telefon numarasını giriniz.');
                return;
            }

            const originalText = verifyBtn.innerHTML;
            verifyBtn.disabled = true;
            verifyBtn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Kontrol Ediliyor...';

            fetch('{{ route("public.appointment-request.send-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    salon_id: salonId,
                    phone: phone
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Sunucu hatası: ' + response.status);
                    });
                }
                return response.json();
            })
            .then(data => {
                verifyBtn.disabled = false;
                verifyBtn.innerHTML = originalText;
                
                if (data.success) {
                    if (data.is_registered) {
                        // Kayıtlı müşteri - Bilgileri otomatik doldur ve OTP adımına geç
                        isRegisteredCustomer = true;
                        customerId = data.customer_id;
                        customerName = data.customer_name || '';
                        
                        // Müşteri bilgilerini otomatik doldur (hidden input'lara)
                        if (data.customer_name) {
                            document.getElementById('customerName').value = data.customer_name;
                        }
                        if (data.customer_surname) {
                            document.getElementById('customerSurname').value = data.customer_surname;
                        }
                        if (data.customer_age) {
                            document.getElementById('customerAge').value = data.customer_age;
                        }
                        
                        document.getElementById('customerInfo').style.display = 'block';
                        document.getElementById('customerInfoText').textContent = 'Kayıtlı müşterisiniz. Bilgileriniz otomatik dolduruldu. Doğrulama kodu gönderildi.';
                        // Step2'yi atla, direkt OTP adımına geç
                        document.getElementById('step1').style.display = 'none';
                        document.getElementById('step2').style.display = 'none';
                        document.getElementById('step3').style.display = 'block';
                        document.getElementById('prevStepBtn').style.display = 'inline-block';
                        document.getElementById('nextStepBtn').style.display = 'inline-block';
                        currentStep = 3;
                        // Cooldown başlat
                        startResendCooldown(60);
                    } else {
                        // Kayıtsız müşteri - bilgi girişi adımına geç
                        isRegisteredCustomer = false;
                        customerId = null;
                        // Form alanlarını temizle
                        document.getElementById('customerName').value = '';
                        document.getElementById('customerSurname').value = '';
                        document.getElementById('customerAge').value = '';
                        document.getElementById('customerInfo').style.display = 'block';
                        document.getElementById('customerInfoText').textContent = 'Yeni müşterisiniz. Lütfen bilgilerinizi tamamlayın.';
                        // 2. etaba (bilgi girişi) geç
                        document.getElementById('step1').style.display = 'none';
                        document.getElementById('step2').style.display = 'block';
                        document.getElementById('prevStepBtn').style.display = 'inline-block';
                        document.getElementById('nextStepBtn').style.display = 'inline-block';
                        currentStep = 2;
                    }
                } else {
                    alert(data.message || 'Telefon kontrolü sırasında bir hata oluştu.');
                }
            })
            .catch(error => {
                verifyBtn.disabled = false;
                verifyBtn.innerHTML = originalText;
                console.error('Error:', error);
                alert(error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.');
            });
        }

        function sendOTP() {
            const phone = document.getElementById('customerPhone').value;
            let name = '';
            
            if (isRegisteredCustomer) {
                name = customerName || '';
            } else {
                name = document.getElementById('customerName').value;
                if (!name) {
                    alert('Lütfen isim bilginizi giriniz.');
                    return;
                }
            }

            fetch('{{ route("public.appointment-request.send-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                },
                body: JSON.stringify({
                    salon_id: salonId,
                    phone: phone,
                    name: name
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // OTP gönderildi, OTP adımına geç
                    if (isRegisteredCustomer) {
                        document.getElementById('step1').style.display = 'none';
                        document.getElementById('step3').style.display = 'block';
                        document.getElementById('prevStepBtn').style.display = 'inline-block';
                        document.getElementById('nextStepBtn').style.display = 'inline-block';
                    } else {
                        document.getElementById('step2').style.display = 'none';
                        document.getElementById('step3').style.display = 'block';
                    }
                    currentStep = 3;
                } else {
                    alert(data.message || 'OTP gönderilirken bir hata oluştu.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Bir hata oluştu. Lütfen tekrar deneyin.');
            });
        }

        function resendOTP() {
            // Cooldown kontrolü
            if (resendOTPCooldown > 0) {
                return;
            }

            // OTP'yi tekrar gönder
            const phone = document.getElementById('customerPhone').value;
            let name = '';
            
            if (isRegisteredCustomer) {
                name = customerName || '';
            } else {
                name = document.getElementById('customerName').value;
            }

            const resendBtn = document.getElementById('resendOTPBtn');
            const originalText = resendBtn.innerHTML;
            resendBtn.disabled = true;
            resendBtn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Gönderiliyor...';

            fetch('{{ route("public.appointment-request.send-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    salon_id: salonId,
                    phone: phone,
                    name: name
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Sunucu hatası: ' + response.status);
                    });
                }
                return response.json();
            })
            .then(data => {
                resendBtn.disabled = false;
                resendBtn.innerHTML = originalText;
                
                if (data.success) {
                    alert('Doğrulama kodu tekrar gönderildi.');
                    // 1 dakika (60 saniye) cooldown başlat
                    startResendCooldown(60);
                } else {
                    alert(data.message || 'OTP gönderilirken bir hata oluştu.');
                }
            })
            .catch(error => {
                resendBtn.disabled = false;
                resendBtn.innerHTML = originalText;
                console.error('Error:', error);
                alert(error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.');
            });
        }

        function startResendCooldown(seconds) {
            resendOTPCooldown = seconds;
            const resendBtn = document.getElementById('resendOTPBtn');
            const countdownEl = document.getElementById('resendCountdown');
            const countdownText = document.getElementById('countdownText');
            
            resendBtn.disabled = true;
            countdownEl.style.display = 'block';
            
            // Timer'ı temizle (eğer varsa)
            if (resendOTPTimer) {
                clearInterval(resendOTPTimer);
            }
            
            resendOTPTimer = setInterval(() => {
                resendOTPCooldown--;
                countdownText.textContent = resendOTPCooldown;
                
                if (resendOTPCooldown <= 0) {
                    clearInterval(resendOTPTimer);
                    resendOTPTimer = null;
                    resendBtn.disabled = false;
                    countdownEl.style.display = 'none';
                }
            }, 1000);
        }

        function nextStep() {
            if (currentStep === 2) {
                if (!document.getElementById('customerName').value || !document.getElementById('customerSurname').value || !document.getElementById('customerAge').value) {
                    alert('Lütfen tüm bilgilerinizi giriniz.');
                    return;
                }
                // OTP gönderme - checkPhone'da zaten gönderildi, sadece adımı değiştir
                // sendOTP() çağrısını kaldırdık çünkü checkPhone() zaten OTP gönderiyor
                document.getElementById('step2').style.display = 'none';
                document.getElementById('step3').style.display = 'block';
                document.getElementById('prevStepBtn').style.display = 'inline-block';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                currentStep = 3;
                // Cooldown başlat (OTP zaten gönderildi)
                startResendCooldown(60);
            } else if (currentStep === 3) {
                const otpCode = document.getElementById('otpCode').value;
                if (!otpCode || otpCode.length !== 6) {
                    alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
                    return;
                }
                
                verifyOTP(otpCode).then(verified => {
                    if (verified) {
                        goToStep4();
                    } else {
                        alert('Doğrulama kodu hatalı. Lütfen tekrar deneyin.');
                    }
                });
            } else if (currentStep === 4) {
                // Hizmet seçimi kontrolü (çoklu hizmet)
                const serviceIdsInput = document.getElementById('selectedServiceIds');
                let serviceIdsArray = [];
                
                if (serviceIdsInput && serviceIdsInput.value) {
                    try {
                        serviceIdsArray = JSON.parse(serviceIdsInput.value);
                    } catch (e) {
                        // JSON parse edilemezse, tek hizmet ID'sini kullan
                        const singleServiceId = document.getElementById('selectedServiceId')?.value;
                        if (singleServiceId) {
                            serviceIdsArray = [singleServiceId];
                        }
                    }
                } else {
                    // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                    const singleServiceId = document.getElementById('selectedServiceId')?.value;
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
                
                if (serviceIdsArray.length === 0) {
                    alert('Lütfen en az bir hizmet seçiniz.');
                    return;
                }
                // Hizmet seçildiyse Step 5'e geç (Tarih seçimi)
                if (typeof goToStep5 === 'function') {
                    goToStep5();
                } else {
                    console.error('goToStep5 fonksiyonu bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                }
            } else if (currentStep === 5) {
                // Tarih seçimi kontrolü
                const selectedDate = document.getElementById('selectedDate').value;
                if (!selectedDate) {
                    alert('Lütfen bir tarih seçiniz.');
                    return;
                }
                // Tarih seçildiyse Step 6'ya geç (Saat seçimi)
                if (typeof goToStep6 === 'function') {
                    goToStep6();
                } else {
                    console.error('goToStep6 fonksiyonu bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                }
            }
        }

        function goToStep4() {
            document.getElementById('step3').style.display = 'none';
            document.getElementById('step4').style.display = 'block';
            document.getElementById('nextStepBtn').style.display = 'inline-block';
            document.getElementById('submitBtn').style.display = 'none';
            
            // Referans kodunu Step 4'te göster ve değiştirilebilir yap
            const referralCodeStep4Container = document.getElementById('referralCodeStep4Container');
            const referralCodeStep4Input = document.getElementById('referralCodeStep4');
            const referralCodeInput = document.getElementById('referralCode');
            
            if (referralCodeStep4Container && referralCodeStep4Input) {
                referralCodeStep4Container.style.display = 'block';
                
                // Eğer Step 2'de referans kodu girildiyse, Step 4'e kopyala
                if (referralCodeInput && referralCodeInput.value) {
                    referralCodeStep4Input.value = referralCodeInput.value;
                }
            }
            
            currentStep = 4;
        }

        function goToStep5() {
            try {
                // Çoklu hizmet kontrolü
                const serviceIdsInput = document.getElementById('selectedServiceIds');
                let serviceIdsArray = [];
                
                if (serviceIdsInput && serviceIdsInput.value) {
                    try {
                        serviceIdsArray = JSON.parse(serviceIdsInput.value);
                    } catch (e) {
                        // JSON parse edilemezse, tek hizmet ID'sini kullan
                        const singleServiceId = document.getElementById('selectedServiceId')?.value;
                        if (singleServiceId) {
                            serviceIdsArray = [singleServiceId];
                        }
                    }
                } else {
                    // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                    const singleServiceId = document.getElementById('selectedServiceId')?.value;
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
                
                if (serviceIdsArray.length === 0) {
                    alert('Lütfen en az bir hizmet seçiniz.');
                    return;
                }
                
                // İlk seçilen hizmeti ana hizmet olarak kaydet (geriye dönük uyumluluk için)
                const serviceId = serviceIdsArray[0];
                
                const step4 = document.getElementById('step4');
                const step5 = document.getElementById('step5');
                const step6 = document.getElementById('step6');
                const nextStepBtn = document.getElementById('nextStepBtn');
                const submitBtn = document.getElementById('submitBtn');
                
                if (!step4 || !step5) {
                    console.error('Step 4 veya Step 5 elementi bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                    return;
                }
                
                // Step 4'ü gizle, Step 5'i göster, Step 6'yı gizle
                step4.style.display = 'none';
                step5.style.display = 'block';
                if (step6) step6.style.display = 'none';
                
                // Butonları güncelle
                if (nextStepBtn) nextStepBtn.style.display = 'inline-block';
                if (submitBtn) submitBtn.style.display = 'none';
                
                // Current step'i güncelle
                currentStep = 5;
                
                // 2 haftalık tarih listesini yükle
                if (typeof loadDateList === 'function') {
                    loadDateList();
                } else {
                    console.error('loadDateList fonksiyonu bulunamadı!');
                }
            } catch (error) {
                console.error('goToStep5 hatası:', error);
                alert('Tarih seçimi açılırken bir hata oluştu. Lütfen sayfayı yenileyin.');
            }
        }

        function goToStep6() {
            try {
                const selectedDate = document.getElementById('selectedDate').value;
                if (!selectedDate) {
                    alert('Lütfen bir tarih seçiniz.');
                    return;
                }
                
                const step5 = document.getElementById('step5');
                const step6 = document.getElementById('step6');
                const nextStepBtn = document.getElementById('nextStepBtn');
                const submitBtn = document.getElementById('submitBtn');
                
                if (!step5 || !step6) {
                    console.error('Step 5 veya Step 6 elementi bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                    return;
                }
                
                // Step 5'i gizle, Step 6'yı göster
                step5.style.display = 'none';
                step6.style.display = 'block';
                
                // Butonları güncelle
                if (nextStepBtn) nextStepBtn.style.display = 'none';
                if (submitBtn) submitBtn.style.display = 'inline-block';
                
                // Current step'i güncelle
                currentStep = 6;
                
                // Seçilen tarih için saatleri yükle
                if (typeof loadTimeSlots === 'function') {
                    loadTimeSlots(selectedDate);
                } else {
                    console.error('loadTimeSlots fonksiyonu bulunamadı!');
                }
                
                // Seçilen tarih için saatleri yükle
                if (typeof loadTimeSlots === 'function') {
                    loadTimeSlots(selectedDate);
                } else {
                    console.error('loadTimeSlots fonksiyonu bulunamadı!');
                }
            } catch (error) {
                console.error('goToStep6 hatası:', error);
                alert('Saat seçimi açılırken bir hata oluştu. Lütfen sayfayı yenileyin.');
            }
        }

        function loadDateList() {
            const dateList = document.getElementById('dateList');
            if (!dateList) return;
            
            dateList.innerHTML = '<div class="col-12 text-center py-3"><div class="spinner-border spinner-border-sm text-primary" role="status"></div></div>';
            
            const today = new Date();
            const dates = [];
            
            // Bugünden başlayarak 14 gün (2 hafta) tarih oluştur
            for (let i = 0; i < 14; i++) {
                const date = new Date(today);
                date.setDate(today.getDate() + i);
                dates.push(date);
            }
            
            let html = '';
            dates.forEach((date, index) => {
                const dateStr = date.toISOString().split('T')[0];
                const dayName = date.toLocaleDateString('tr-TR', { weekday: 'long' });
                const dayNameShort = date.toLocaleDateString('tr-TR', { weekday: 'short' });
                const dayNumber = date.getDate();
                const monthName = date.toLocaleDateString('tr-TR', { month: 'long' });
                const monthNameShort = date.toLocaleDateString('tr-TR', { month: 'short' });
                const isToday = index === 0;
                
                html += `
                    <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-3">
                        <div class="date-option-card ${isToday ? 'today' : ''}" data-date="${dateStr}" onclick="selectDate('${dateStr}')" style="border: 2px solid #e5e7eb; border-radius: 16px; padding: 16px 12px; text-align: center; cursor: pointer; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); background: white; min-height: 100px; display: flex; flex-direction: column; justify-content: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);" onmouseover="if(!this.classList.contains('selected')) { this.style.borderColor='#ec4899'; this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 16px rgba(236, 72, 153, 0.15)'; }" onmouseout="if(!this.classList.contains('selected')) { this.style.borderColor='#e5e7eb'; this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 4px rgba(0,0,0,0.05)'; }">
                            <div style="font-size: 0.7rem; color: #6b7280; margin-bottom: 6px; font-weight: 500; text-transform: capitalize;">
                                <span class="d-none d-sm-inline">${dayName}</span>
                                <span class="d-sm-none">${dayNameShort}</span>
                            </div>
                            <div style="font-size: 1.75rem; font-weight: 700; color: #1f2937; margin-bottom: 4px; line-height: 1.2;">${dayNumber}</div>
                            <div style="font-size: 0.75rem; color: #6b7280; text-transform: capitalize;">
                                <span class="d-none d-sm-inline">${monthName}</span>
                                <span class="d-sm-none">${monthNameShort}</span>
                            </div>
                            ${isToday ? '<div style="font-size: 0.65rem; color: #ec4899; margin-top: 6px; font-weight: 600; padding: 2px 6px; background: #fce7f3; border-radius: 8px; display: inline-block;">Bugün</div>' : ''}
                        </div>
                    </div>
                `;
            });
            
            dateList.innerHTML = html;
        }

        function selectDate(dateStr) {
            document.getElementById('selectedDate').value = dateStr;
            
            // Seçili tarihi görsel olarak işaretle
            document.querySelectorAll('.date-option-card').forEach(card => {
                card.classList.remove('selected');
                card.style.borderColor = '#e5e7eb';
                card.style.background = 'white';
                card.style.boxShadow = '0 2px 4px rgba(0,0,0,0.05)';
                card.style.transform = 'translateY(0)';
            });
            
            const selectedCard = document.querySelector(`[data-date="${dateStr}"]`);
            if (selectedCard) {
                selectedCard.classList.add('selected');
                selectedCard.style.borderColor = '#ec4899';
                selectedCard.style.background = 'linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%)';
                selectedCard.style.boxShadow = '0 8px 20px rgba(236, 72, 153, 0.25)';
                selectedCard.style.transform = 'translateY(-2px)';
            }
            
            // Tarih seçildiğinde saatleri yükleme - Step 6'ya geçildiğinde yüklenecek
        }

        let selectedServiceId = null;
        let servicePersonels = [];
        let serviceDuration = 30;

        function loadTimeSlots(dateStr) {
            // Çoklu hizmet seçimi kontrolü
            const serviceIdsInput = document.getElementById('selectedServiceIds');
            let serviceIdsArray = [];
            
            if (serviceIdsInput && serviceIdsInput.value) {
                try {
                    serviceIdsArray = JSON.parse(serviceIdsInput.value);
                } catch (e) {
                    // JSON parse edilemezse, tek hizmet ID'sini kullan
                    const singleServiceId = document.getElementById('selectedServiceId')?.value;
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
            } else {
                // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                const singleServiceId = document.getElementById('selectedServiceId')?.value;
                if (singleServiceId) {
                    serviceIdsArray = [singleServiceId];
                }
            }
            
            if (serviceIdsArray.length === 0) {
                alert('Lütfen önce en az bir hizmet seçiniz.');
                return;
            }
            
            const timeList = document.getElementById('timeList');
            const timeSelectionContainer = document.getElementById('timeSelectionContainer');
            
            if (!timeList || !timeSelectionContainer) return;
            
            timeSelectionContainer.style.display = 'block';
            timeList.innerHTML = '<div class="col-12 text-center py-3"><div class="spinner-border spinner-border-sm text-primary" role="status"></div></div>';
            
            // Çoklu hizmet için service_ids parametresini gönder
            const serviceIdsParam = serviceIdsArray.join(',');
            
            // Müsait saatleri getir
            fetch(`{{ route("public.appointment-request.available-slots-ascii") }}?service_ids=${serviceIdsParam}&salon_id=${salonId}&date=${dateStr}`, {
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                }
            })
            .then(async response => {
                const data = await response.json();
                if (!response.ok || !data.success) {
                    // Validation hatalarını göster
                    let errorMessage = data.message || 'Müsait saatler getirilemedi.';
                    if (data.errors) {
                        const errorMessages = Object.values(data.errors).flat();
                        if (errorMessages.length > 0) {
                            errorMessage = errorMessages.join(', ');
                        }
                    }
                    throw new Error(errorMessage);
                }
                return data;
            })
            .then(data => {
                
                servicePersonels = data.personels || [];
                serviceDuration = data.service_duration || 30;
                
                // 08:00 - 22:00 arası, 30 dakika aralıklarla saatler
                const allSlots = [];
                for (let hour = 8; hour < 22; hour++) {
                    allSlots.push(String(hour).padStart(2, '0') + ':00');
                    allSlots.push(String(hour).padStart(2, '0') + ':30');
                }
                allSlots.push('22:00');
                
                // Müsait saatleri kontrol et
                const availableSlots = data.available_slots || [];
                const slotMap = {};
                availableSlots.forEach(slot => {
                    slotMap[slot.time] = slot.available;
                });
                
                let html = '';
                allSlots.forEach(slot => {
                    const isAvailable = slotMap[slot] !== false; // Eğer slotMap'te yoksa veya true ise müsait
                    const isDisabled = !isAvailable;
                    
                    html += `
                        <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-3">
                            <button type="button" class="time-slot-btn ${isDisabled ? 'disabled' : ''}" 
                                    data-time="${slot}" 
                                    onclick="${isDisabled ? '' : `selectTime('${slot}')`}"
                                    ${isDisabled ? 'disabled' : ''}
                                    style="width: 100%; padding: 14px 8px; border: 2px solid ${isDisabled ? '#e5e7eb' : '#ec4899'}; border-radius: 12px; background: ${isDisabled ? '#f3f4f6' : 'white'}; color: ${isDisabled ? '#9ca3af' : '#ec4899'}; font-weight: 600; font-size: 0.95rem; cursor: ${isDisabled ? 'not-allowed' : 'pointer'}; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); box-shadow: 0 2px 4px rgba(0,0,0,0.05); min-height: 50px; display: flex; align-items: center; justify-content: center;"
                                    onmouseover="${isDisabled ? '' : "if(!this.classList.contains('selected')) { this.style.background='#fce7f3'; this.style.transform='translateY(-3px)'; this.style.boxShadow='0 6px 12px rgba(236, 72, 153, 0.2)'; }"}"
                                    onmouseout="${isDisabled ? '' : "if(!this.classList.contains('selected')) { this.style.background='white'; this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 4px rgba(0,0,0,0.05)'; }"}">
                                <i class="bi bi-clock me-1" style="font-size: 0.85rem;"></i>${slot}
                            </button>
                        </div>
                    `;
                });
                
                timeList.innerHTML = html;
            })
            .catch(error => {
                console.error('Müsait saatler yüklenirken hata:', error);
                timeList.innerHTML = '<div class="col-12"><div class="alert alert-danger">Müsait saatler yüklenirken bir hata oluştu. Lütfen tekrar deneyin.</div></div>';
            });
        }

        function selectTime(time) {
            document.getElementById('selectedTime').value = time;
            
            // Seçili saati görsel olarak işaretle
            document.querySelectorAll('.time-slot-btn').forEach(btn => {
                if (!btn.disabled) {
                    btn.classList.remove('selected');
                    btn.style.background = 'white';
                    btn.style.borderColor = '#ec4899';
                    btn.style.color = '#ec4899';
                    btn.style.boxShadow = '0 2px 4px rgba(0,0,0,0.05)';
                    btn.style.transform = 'translateY(0)';
                }
            });
            
            const selectedBtn = document.querySelector(`[data-time="${time}"]`);
            if (selectedBtn && !selectedBtn.disabled) {
                selectedBtn.classList.add('selected');
                selectedBtn.style.background = 'linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%)';
                selectedBtn.style.color = '#ec4899';
                selectedBtn.style.borderColor = '#ec4899';
                selectedBtn.style.boxShadow = '0 6px 16px rgba(236, 72, 153, 0.3)';
                selectedBtn.style.transform = 'translateY(-2px)';
            }
        }

        function prevStep() {
            if (currentStep === 2) {
                document.getElementById('step1').style.display = 'block';
                document.getElementById('step2').style.display = 'none';
                document.getElementById('prevStepBtn').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'none';
                document.getElementById('customerInfo').style.display = 'none';
                currentStep = 1;
            } else if (currentStep === 3) {
                if (isRegisteredCustomer) {
                    document.getElementById('step1').style.display = 'block';
                    document.getElementById('step3').style.display = 'none';
                    document.getElementById('prevStepBtn').style.display = 'none';
                    document.getElementById('nextStepBtn').style.display = 'none';
                    document.getElementById('customerInfo').style.display = 'none';
                    currentStep = 1;
                } else {
                    document.getElementById('step2').style.display = 'block';
                    document.getElementById('step3').style.display = 'none';
                    currentStep = 2;
                }
            } else if (currentStep === 4) {
                document.getElementById('step3').style.display = 'block';
                document.getElementById('step4').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                document.getElementById('submitBtn').style.display = 'none';
                currentStep = 3;
            } else if (currentStep === 5) {
                // Step 5'ten Step 4'e dön
                document.getElementById('step4').style.display = 'block';
                document.getElementById('step5').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                document.getElementById('submitBtn').style.display = 'none';
                currentStep = 4;
            } else if (currentStep === 6) {
                // Step 6'dan Step 5'e dön
                document.getElementById('step5').style.display = 'block';
                document.getElementById('step6').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                document.getElementById('submitBtn').style.display = 'none';
                currentStep = 5;
            }
        }

        function verifyOTP(otpCode) {
            const phone = document.getElementById('customerPhone').value;
            if (!phone) {
                console.error('Telefon numarası bulunamadı');
                return Promise.resolve(false);
            }
            
            return fetch('{{ route("public.appointment-request.verify-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json',
                },
                body: JSON.stringify({
                    phone: phone,
                    otp_code: otpCode
                })
            })
            .then(async response => {
                if (!response.ok) {
                    const errorData = await response.json().catch(() => ({ message: 'Sunucu hatası: ' + response.status }));
                    console.error('OTP doğrulama hatası:', errorData);
                    return false;
                }
                return response.json();
            })
            .then(data => {
                if (data && data.success) {
                    return true;
                }
                console.error('OTP doğrulama başarısız:', data);
                return false;
            })
            .catch(error => {
                console.error('OTP doğrulama hatası:', error);
                return false;
            });
        }

        function selectService(serviceId) {
            // Tüm service-option-card elementlerini bul (hem modal içinde hem dışında)
            const allCards = document.querySelectorAll(`[data-service-id="${serviceId}"], [data-service-id="${serviceId.toString()}"]`);
            
            if (allCards.length > 0) {
                // İlk kartı ana kart olarak al
                const selectedCard = allCards[0];
                
                // Checkbox'ı bul
                const checkbox = selectedCard.querySelector('.service-checkbox');
                const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                
                // Çoklu seçim: Tıklanan kartı toggle et
                const isSelected = selectedCard.classList.contains('border-primary');
                
                // Tüm eşleşen kartları güncelle
                allCards.forEach(card => {
                    if (isSelected) {
                        // Seçimi kaldır
                        card.classList.remove('border-primary');
                        const cardCheckbox = card.querySelector('.service-checkbox');
                        const cardCheckboxIcon = cardCheckbox ? cardCheckbox.querySelector('i') : null;
                        if (cardCheckbox) {
                            cardCheckbox.style.background = 'white';
                            cardCheckbox.style.borderColor = '#e2e8f0';
                            cardCheckbox.style.setProperty('background', 'white', 'important');
                            cardCheckbox.style.setProperty('border-color', '#e2e8f0', 'important');
                        }
                        if (cardCheckboxIcon) {
                            cardCheckboxIcon.style.display = 'none';
                        }
                    } else {
                        // Seçimi ekle
                        card.classList.add('border-primary');
                        const cardCheckbox = card.querySelector('.service-checkbox');
                        const cardCheckboxIcon = cardCheckbox ? cardCheckbox.querySelector('i') : null;
                        if (cardCheckbox) {
                            cardCheckbox.style.background = '#ec4899';
                            cardCheckbox.style.borderColor = '#ec4899';
                            cardCheckbox.style.setProperty('background', '#ec4899', 'important');
                            cardCheckbox.style.setProperty('border-color', '#ec4899', 'important');
                        }
                        if (cardCheckboxIcon) {
                            cardCheckboxIcon.style.display = 'flex';
                            cardCheckboxIcon.style.setProperty('display', 'flex', 'important');
                        }
                    }
                });
                
                if (isSelected) {
                    selectedServiceIds = selectedServiceIds.filter(id => id !== serviceId && id !== parseInt(serviceId));
                } else {
                    if (!selectedServiceIds.includes(serviceId) && !selectedServiceIds.includes(parseInt(serviceId))) {
                        selectedServiceIds.push(serviceId);
                    }
                }
                
                // İlk seçilen hizmeti ana hizmet olarak kaydet (geriye dönük uyumluluk için)
                selectedServiceId = selectedServiceIds.length > 0 ? selectedServiceIds[0] : null;
                
                const selectedServiceIdInput = document.getElementById('selectedServiceId');
                if (selectedServiceIdInput) {
                    selectedServiceIdInput.value = selectedServiceId;
                }
                
                const selectedServiceIdsInput = document.getElementById('selectedServiceIds');
                if (selectedServiceIdsInput) {
                    selectedServiceIdsInput.value = JSON.stringify(selectedServiceIds);
                }
                
                // Seçilen hizmet sayısını göster
                updateSelectedServicesCount();
            }
        }

        function switchStepServiceCategory(categoryId) {
            const stepCategorySelect = document.getElementById('stepServiceCategorySelect');
            if (stepCategorySelect && String(stepCategorySelect.value) !== String(categoryId)) {
                stepCategorySelect.value = String(categoryId);
            }

            // Tüm sekmelerin active class'ını kaldır
            document.querySelectorAll('.step-category-tab-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Tıklanan sekmenin active class'ını ekle
            const clickedBtn = document.querySelector(`[data-step-category="${categoryId}"]`);
            if (clickedBtn) {
                clickedBtn.classList.add('active');
            }
            
            // Tüm kategori içeriklerini gizle
            document.querySelectorAll('.step-services-category-content').forEach(content => {
                content.style.display = 'none';
            });
            
            // Seçilen kategori içeriğini göster
            const selectedContent = document.getElementById(`stepServicesContent-${categoryId}`);
            if (selectedContent) {
                selectedContent.style.display = 'block';
            }
        }
        
        function updateSelectedServicesCount() {
            const count = selectedServiceIds.length;
            const countBadge = document.getElementById('selectedServicesCount');
            if (countBadge) {
                if (count > 0) {
                    countBadge.textContent = `${count} hizmet seçildi`;
                    countBadge.style.display = 'inline-block';
                } else {
                    countBadge.style.display = 'none';
                }
            }
        }

        function selectServiceAndOpenModal(serviceId) {
            // Önce hizmeti seç - tüm kartları bul
            const allCards = document.querySelectorAll(`[data-service-id="${serviceId}"], [data-service-id="${serviceId.toString()}"]`);
            
            if (allCards.length > 0) {
                const selectedCard = allCards[0];
                if (!selectedCard.classList.contains('border-primary')) {
                    // Tüm eşleşen kartları güncelle
                    allCards.forEach(card => {
                        card.classList.add('border-primary');
                        const checkbox = card.querySelector('.service-checkbox');
                        const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                        if (checkbox) {
                            checkbox.style.background = '#ec4899';
                            checkbox.style.borderColor = '#ec4899';
                            checkbox.style.setProperty('background', '#ec4899', 'important');
                            checkbox.style.setProperty('border-color', '#ec4899', 'important');
                        }
                        if (checkboxIcon) {
                            checkboxIcon.style.display = 'flex';
                            checkboxIcon.style.setProperty('display', 'flex', 'important');
                        }
                    });
                    
                    if (!selectedServiceIds.includes(serviceId) && !selectedServiceIds.includes(parseInt(serviceId))) {
                        selectedServiceIds.push(serviceId);
                    }
                    
                    selectedServiceId = selectedServiceIds.length > 0 ? selectedServiceIds[0] : null;
                    
                    const selectedServiceIdInput = document.getElementById('selectedServiceId');
                    if (selectedServiceIdInput) {
                        selectedServiceIdInput.value = selectedServiceId;
                    }
                    
                    const selectedServiceIdsInput = document.getElementById('selectedServiceIds');
                    if (selectedServiceIdsInput) {
                        selectedServiceIdsInput.value = JSON.stringify(selectedServiceIds);
                    }
                    
                    updateSelectedServicesCount();
                }
            }
            
            // Sonra modalı aç ve Step 4'e git
            openAppointmentModal(serviceId);
            setTimeout(() => {
                goToStep4();
            }, 300);
        }

        function toggleRecurringOptions() {
            const enableRecurring = document.getElementById('enableRecurring');
            const recurringOptions = document.getElementById('recurringOptions');
            
            if (enableRecurring && recurringOptions) {
                if (enableRecurring.checked) {
                    recurringOptions.style.display = 'block';
                } else {
                    recurringOptions.style.display = 'none';
                    // Form alanlarını sıfırla
                    document.getElementById('recurring_type').value = '';
                    document.getElementById('day_of_week').value = '';
                    document.getElementById('day_of_month').value = '';
                    document.getElementById('recurring_count').value = '1';
                    document.getElementById('day_of_week_container').style.display = 'none';
                    document.getElementById('day_of_month_container').style.display = 'none';
                }
            }
        }

        function toggleRecurringDayOptions() {
            const recurringType = document.getElementById('recurring_type').value;
            const dayOfWeekContainer = document.getElementById('day_of_week_container');
            const dayOfMonthContainer = document.getElementById('day_of_month_container');
            
            if (recurringType === 'weekly') {
                if (dayOfWeekContainer) dayOfWeekContainer.style.display = 'block';
                if (dayOfMonthContainer) dayOfMonthContainer.style.display = 'none';
                if (document.getElementById('day_of_month')) document.getElementById('day_of_month').value = '';
            } else if (recurringType === 'monthly') {
                if (dayOfWeekContainer) dayOfWeekContainer.style.display = 'none';
                if (dayOfMonthContainer) dayOfMonthContainer.style.display = 'block';
                if (document.getElementById('day_of_week')) document.getElementById('day_of_week').value = '';
            } else {
                if (dayOfWeekContainer) dayOfWeekContainer.style.display = 'none';
                if (dayOfMonthContainer) dayOfMonthContainer.style.display = 'none';
            }
        }

        function initializeAppointmentWizardBindings() {
            if (window.__appointmentWizardBindingsInitialized) {
                return;
            }
            const hasAppointmentUi = !!document.getElementById('appointmentModal');
            const hasTabUi = document.querySelectorAll('.tab-btn').length > 0;
            if (!hasAppointmentUi && !hasTabUi) {
                return;
            }
            window.__appointmentWizardBindingsInitialized = true;

            const bindClick = (id, handler) => {
                const element = document.getElementById(id);
                if (!element || typeof handler !== 'function') return;
                element.addEventListener('click', function(event) {
                    event.preventDefault();
                    handler();
                });
            };

            bindClick('verifyPhoneBtn', checkPhone);
            bindClick('resendOTPBtn', resendOTP);
            bindClick('nextStepBtn', nextStep);
            bindClick('prevStepBtn', prevStep);

            document.querySelectorAll('.tab-btn').forEach(btn => {
                const onclickValue = btn.getAttribute('onclick') || '';
                const match = onclickValue.match(/switchTab\('([^']+)'\)/);
                const tabName = btn.getAttribute('data-tab') || (match ? match[1] : null);
                if (!tabName) return;
                btn.setAttribute('data-tab', tabName);
                btn.addEventListener('click', function(event) {
                    event.preventDefault();
                    switchTab(tabName);
                });
            });

            document.querySelectorAll('.category-tab-btn').forEach(btn => {
                const categoryId = btn.getAttribute('data-category');
                if (categoryId === null) return;
                btn.addEventListener('click', function(event) {
                    event.preventDefault();
                    switchServiceCategory(categoryId);
                });
            });

            document.querySelectorAll('.gallery-image-public').forEach(image => {
                image.addEventListener('click', function(event) {
                    event.preventDefault();
                    const imageSrc = image.getAttribute('src') || image.dataset.src;
                    if (imageSrc) {
                        openGalleryModal(imageSrc);
                    }
                });
            });

            const phoneInput = document.getElementById('customerPhone');
            if (phoneInput) {
                phoneInput.addEventListener('keydown', function(event) {
                    if (event.key === 'Enter') {
                        event.preventDefault();
                        checkPhone();
                    }
                });
            }

            const appointmentModal = document.getElementById('appointmentModal');
            const modalRoot = appointmentModal || document;

            modalRoot.querySelectorAll('.service-option-card[data-service-id]').forEach(() => {});
            modalRoot.querySelectorAll('.step-category-tab-btn[data-step-category]').forEach(btn => {
                btn.addEventListener('click', function(event) {
                    event.preventDefault();
                    const categoryId = btn.getAttribute('data-step-category');
                    if (categoryId !== null) {
                        switchStepServiceCategory(categoryId);
                    }
                });
            });

            document.addEventListener('click', function(event) {
                const serviceCard = event.target.closest('.service-option-card[data-service-id]');
                if (serviceCard && modalRoot.contains(serviceCard)) {
                    event.preventDefault();
                    const serviceId = serviceCard.getAttribute('data-service-id');
                    if (serviceId) {
                        selectService(serviceId);
                    }
                    return;
                }

                const dateCard = event.target.closest('.date-option-card[data-date]');
                if (dateCard && modalRoot.contains(dateCard)) {
                    event.preventDefault();
                    const dateValue = dateCard.getAttribute('data-date');
                    if (dateValue) {
                        selectDate(dateValue);
                    }
                    return;
                }

                const timeButton = event.target.closest('.time-slot-btn[data-time]');
                if (timeButton && modalRoot.contains(timeButton) && !timeButton.disabled && !timeButton.classList.contains('disabled')) {
                    event.preventDefault();
                    const timeValue = timeButton.getAttribute('data-time');
                    if (timeValue) {
                        selectTime(timeValue);
                    }
                }
            });

            window.openAppointmentModal = openAppointmentModal;
            window.checkPhone = checkPhone;
            window.resendOTP = resendOTP;
            window.nextStep = nextStep;
            window.prevStep = prevStep;
            window.selectService = selectService;
            window.selectDate = selectDate;
            window.selectTime = selectTime;
        }

        // Hard fallback: sekme gecisini her durumda garanti et
        function forceSwitchTab(tabName) {
            const tabIdMap = {
                services: 'servicesTab',
                gallery: 'galleryTab',
                personels: 'personelsTab',
                ratings: 'ratingsTab'
            };
            document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
                content.style.display = 'none';
            });
            const targetBtn = document.querySelector(`.tab-btn[data-tab="${tabName}"]`) ||
                Array.from(document.querySelectorAll('.tab-btn')).find(btn => (btn.getAttribute('onclick') || '').includes(`switchTab('${tabName}')`));
            if (targetBtn) targetBtn.classList.add('active');
            const targetContent = document.getElementById(tabIdMap[tabName] || `${tabName}Tab`);
            if (targetContent) {
                targetContent.classList.add('active');
                targetContent.style.display = 'block';
            }
        }
        window.switchTab = forceSwitchTab;

        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initializeAppointmentWizardBindings, { once: true });
        } else {
            initializeAppointmentWizardBindings();
        }

        // Son güvenlik katmanı: kritik butonlar event delegation ile her zaman çalışsın
        document.addEventListener('click', function(event) {
            const verifyBtn = event.target.closest('#verifyPhoneBtn');
            if (verifyBtn) {
                event.preventDefault();
                if (typeof checkPhone === 'function') checkPhone();
                return;
            }
            const resendBtn = event.target.closest('#resendOTPBtn');
            if (resendBtn) {
                event.preventDefault();
                if (typeof resendOTP === 'function') resendOTP();
                return;
            }
            const nextBtn = event.target.closest('#nextStepBtn');
            if (nextBtn) {
                event.preventDefault();
                if (typeof nextStep === 'function') nextStep();
                return;
            }
            const prevBtn = event.target.closest('#prevStepBtn');
            if (prevBtn) {
                event.preventDefault();
                if (typeof prevStep === 'function') prevStep();
                return;
            }
            const tabBtn = event.target.closest('.tab-btn');
            if (tabBtn) {
                const tabName = tabBtn.getAttribute('data-tab');
                if (tabName) {
                    event.preventDefault();
                    forceSwitchTab(tabName);
                }
                return;
            }
            const catBtn = event.target.closest('.category-tab-btn[data-category]');
            if (catBtn) {
                const categoryId = catBtn.getAttribute('data-category');
                if (categoryId !== null && typeof switchServiceCategory === 'function') {
                    event.preventDefault();
                    switchServiceCategory(categoryId);
                }
            }
        });

        const submitBtnEl = document.getElementById('submitBtn');
        if (submitBtnEl) submitBtnEl.addEventListener('click', function() {
            // Tarih ve saat kontrolü (Step 6)
            const selectedDate = document.getElementById('selectedDate').value;
            const selectedTime = document.getElementById('selectedTime').value;
            
            if (!selectedDate) {
                alert('Lütfen tarih seçiniz.');
                return;
            }
            
            if (!selectedTime) {
                alert('Lütfen saat seçiniz.');
                return;
            }
            
            // Elementleri kontrol et
            const customerPhoneEl = document.getElementById('customerPhone');
            const customerNameEl = document.getElementById('customerName');
            
            // Müşteri bilgileri
            let finalCustomerName = '';
            let finalCustomerSurname = '';
            let finalCustomerAge = null;
            
            if (isRegisteredCustomer) {
                // Kayıtlı müşteri için otomatik doldurulan bilgileri kullan
                finalCustomerName = document.getElementById('customerName')?.value || customerName || '';
                finalCustomerSurname = document.getElementById('customerSurname')?.value || '';
                finalCustomerAge = document.getElementById('customerAge')?.value || null;
                
                if (!finalCustomerName) {
                    alert('Müşteri bilgisi bulunamadı. Lütfen sayfayı yenileyin.');
                    return;
                }
            } else {
                // Kayıtsız müşteri için formdan al
                if (!customerNameEl || !customerNameEl.value) {
                    alert('Lütfen adınızı giriniz.');
                    if (customerNameEl) customerNameEl.focus();
                    return;
                }
                finalCustomerName = customerNameEl.value;
                
                const customerSurnameEl = document.getElementById('customerSurname');
                if (!customerSurnameEl || !customerSurnameEl.value) {
                    alert('Lütfen soyadınızı giriniz.');
                    if (customerSurnameEl) customerSurnameEl.focus();
                    return;
                }
                finalCustomerSurname = customerSurnameEl.value;
                
                const customerAgeEl = document.getElementById('customerAge');
                if (!customerAgeEl || !customerAgeEl.value) {
                    alert('Lütfen yaşınızı giriniz.');
                    if (customerAgeEl) customerAgeEl.focus();
                    return;
                }
                finalCustomerAge = customerAgeEl.value;
            }
            
            if (!customerPhoneEl || !customerPhoneEl.value) {
                alert('Telefon numarası bulunamadı. Lütfen sayfayı yenileyin.');
                return;
            }
            
            // Tekrarlanan seans bilgilerini kontrol et
            const enableRecurring = document.getElementById('enableRecurring')?.checked || false;
            let recurringData = null;
            
            if (enableRecurring) {
                const recurringType = document.getElementById('recurring_type')?.value;
                const recurringCount = document.getElementById('recurring_count')?.value;
                
                if (!recurringType) {
                    alert('Lütfen tekrarlama tipini seçiniz.');
                    return;
                }
                
                if (!recurringCount || parseInt(recurringCount) < 1 || parseInt(recurringCount) > 24) {
                    alert('Lütfen 1-24 arası bir tekrarlama sayısı giriniz.');
                    return;
                }
                
                if (recurringType === 'weekly') {
                    const dayOfWeek = document.getElementById('day_of_week')?.value;
                    if (!dayOfWeek) {
                        alert('Lütfen haftanın gününü seçiniz.');
                        return;
                    }
                    recurringData = {
                        recurring_type: recurringType,
                        day_of_week: parseInt(dayOfWeek),
                        recurring_count: parseInt(recurringCount)
                    };
                } else if (recurringType === 'monthly') {
                    const dayOfMonth = document.getElementById('day_of_month')?.value;
                    if (!dayOfMonth) {
                        alert('Lütfen ayın gününü seçiniz.');
                        return;
                    }
                    recurringData = {
                        recurring_type: recurringType,
                        day_of_month: parseInt(dayOfMonth),
                        recurring_count: parseInt(recurringCount)
                    };
                }
            }
            
            // Seçilen hizmet ID'lerini al
            const serviceIdsInput = document.getElementById('selectedServiceIds');
            let serviceIdsArray = [];
            if (serviceIdsInput && serviceIdsInput.value) {
                try {
                    serviceIdsArray = JSON.parse(serviceIdsInput.value);
                } catch (e) {
                    // Eğer JSON parse edilemezse, tek hizmet ID'sini kullan
                    const singleServiceId = selectedServiceId || (document.getElementById('selectedServiceId') ? document.getElementById('selectedServiceId').value : null);
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
            } else {
                // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                const singleServiceId = selectedServiceId || (document.getElementById('selectedServiceId') ? document.getElementById('selectedServiceId').value : null);
                if (singleServiceId) {
                    serviceIdsArray = [singleServiceId];
                }
            }
            
            // Referans kodunu al (Step 4'teki varsa onu kullan, yoksa Step 2'deki)
            const referralCodeStep4 = document.getElementById('referralCodeStep4')?.value;
            const referralCodeStep2 = document.getElementById('referralCode')?.value;
            const referralCode = referralCodeStep4 || referralCodeStep2 || null;
            
            const formData = {
                salon_id: salonId,
                service_id: selectedServiceId || (document.getElementById('selectedServiceId') ? document.getElementById('selectedServiceId').value : null), // Geriye dönük uyumluluk için
                service_ids: serviceIdsArray.length > 0 ? serviceIdsArray : null, // Birden fazla hizmet
                name: finalCustomerName,
                phone: customerPhoneEl.value,
                customer_id: customerId || null,
                surname: finalCustomerSurname || null,
                age: finalCustomerAge ? parseInt(finalCustomerAge) : null,
                date: selectedDate,
                time: selectedTime,
                referral_code: referralCode,
                recurring: recurringData
            };

            fetch('{{ route("public.appointment-request.store") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(async response => {
                if (!response.ok) {
                    const errorData = await response.json().catch(() => ({ message: 'Sunucu hatası: ' + response.status }));
                    // Validation hatalarını daha iyi göster
                    if (errorData.errors) {
                        const errorMessages = Object.values(errorData.errors).flat().join('\n');
                        throw new Error(errorMessages);
                    }
                    throw new Error(errorData.message || 'Sunucu hatası: ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    bootstrap.Modal.getInstance(document.getElementById('appointmentModal')).hide();
                    showCustomAlert('Randevu talebiniz başarıyla gönderildi. En kısa sürede size dönüş yapılacaktır.', 'success');
                    setTimeout(() => location.reload(), 2000);
                } else {
                    showCustomAlert(data.message || 'Randevu talebi gönderilirken bir hata oluştu.', 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showCustomAlert(error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.', 'error');
            });
        });

        // Gallery Modal
        function openGalleryModal(imageSrc) {
            const galleryImage = document.getElementById('galleryModalImage');
            const galleryModalEl = document.getElementById('galleryModal');
            if (!galleryImage || !galleryModalEl) {
                return;
            }
            galleryImage.src = imageSrc;
            if (window.bootstrap && window.bootstrap.Modal) {
                const galleryModal = new bootstrap.Modal(galleryModalEl);
                galleryModal.show();
            }
        }

        // Custom Success Popup
        function showCustomAlert(message, type = 'success') {
            // Varsa eski popup'ı kaldır
            const existingPopup = document.getElementById('customAlertPopup');
            if (existingPopup) existingPopup.remove();
            
            const colors = {
                success: { bg: '#10b981', icon: 'bi-check-circle-fill' },
                error: { bg: '#ef4444', icon: 'bi-x-circle-fill' },
                warning: { bg: '#f59e0b', icon: 'bi-exclamation-triangle-fill' },
                info: { bg: '#3b82f6', icon: 'bi-info-circle-fill' }
            };
            
            const config = colors[type] || colors.success;
            
            const popup = document.createElement('div');
            popup.id = 'customAlertPopup';
            popup.style.cssText = 'position: fixed; top: 20px; right: 20px; z-index: 999999; animation: slideInRight 0.3s ease;';
            popup.innerHTML = `
                <div style="background: ${config.bg}; color: white; padding: 20px 24px; border-radius: 16px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); display: flex; align-items: center; gap: 16px; min-width: 300px; max-width: 500px;">
                    <i class="bi ${config.icon}" style="font-size: 28px; flex-shrink: 0;"></i>
                    <div style="flex: 1;">
                        <div style="font-weight: 600; font-size: 16px; margin-bottom: 4px;">${type === 'success' ? 'Başarılı' : type === 'error' ? 'Hata' : type === 'warning' ? 'Uyarı' : 'Bilgi'}</div>
                        <div style="font-size: 14px; opacity: 0.95;">${message}</div>
                    </div>
                    <button type="button" onclick="this.closest('#customAlertPopup').remove()" style="background: rgba(255,255,255,0.2); border: none; color: white; width: 28px; height: 28px; border-radius: 50%; cursor: pointer; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-size: 18px; line-height: 1;">&times;</button>
                </div>
            `;
            
            // CSS animation ekle
            if (!document.getElementById('customAlertStyles')) {
                const style = document.createElement('style');
                style.id = 'customAlertStyles';
                style.textContent = `
                    @keyframes slideInRight {
                        from {
                            transform: translateX(100%);
                            opacity: 0;
                        }
                        to {
                            transform: translateX(0);
                            opacity: 1;
                        }
                    }
                `;
                document.head.appendChild(style);
            }
            
            document.body.appendChild(popup);
            
            // 5 saniye sonra otomatik kapat
            setTimeout(() => {
                if (popup && popup.parentNode) {
                    popup.style.opacity = '0';
                    popup.style.transition = 'opacity 0.3s ease';
                    setTimeout(() => popup.remove(), 300);
                }
            }, 5000);
        }
        
        // Custom Confirm Popup
        function customConfirm(message) {
            return new Promise((resolve) => {
                // Varsa eski popup'ı kaldır
                const existingPopup = document.getElementById('customConfirmPopup');
                if (existingPopup) existingPopup.remove();
                
                const popup = document.createElement('div');
                popup.id = 'customConfirmPopup';
                popup.style.cssText = 'position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 999999; background: rgba(0,0,0,0.5); display: flex; align-items: center; justify-content: center; animation: fadeIn 0.2s ease;';
                popup.innerHTML = `
                    <div style="background: white; border-radius: 16px; padding: 32px; max-width: 400px; width: 90%; box-shadow: 0 20px 60px rgba(0,0,0,0.3); animation: slideUp 0.3s ease;">
                        <div style="text-align: center; margin-bottom: 24px;">
                            <i class="bi bi-question-circle-fill" style="font-size: 48px; color: #3b82f6; margin-bottom: 16px;"></i>
                            <div style="font-size: 18px; font-weight: 600; color: #1f2937; margin-bottom: 8px;">Onay</div>
                            <div style="font-size: 14px; color: #6b7280; line-height: 1.6;">${message || 'Bu işlemi yapmak istediğinize emin misiniz?'}</div>
                        </div>
                        <div style="display: flex; gap: 12px;">
                            <button id="confirmCancelBtn" style="flex: 1; padding: 12px; border: 1px solid #e5e7eb; background: white; color: #6b7280; border-radius: 8px; cursor: pointer; font-weight: 600; transition: all 0.2s;">İptal</button>
                            <button id="confirmOkBtn" style="flex: 1; padding: 12px; border: none; background: #3b82f6; color: white; border-radius: 8px; cursor: pointer; font-weight: 600; transition: all 0.2s;">Onayla</button>
                        </div>
                    </div>
                    <style>
                        @keyframes fadeIn {
                            from { opacity: 0; }
                            to { opacity: 1; }
                        }
                        @keyframes slideUp {
                            from { transform: translateY(20px); opacity: 0; }
                            to { transform: translateY(0); opacity: 1; }
                        }
                        #confirmCancelBtn:hover { background: #f9fafb !important; }
                        #confirmOkBtn:hover { background: #2563eb !important; }
                    </style>
                `;
                
                document.body.appendChild(popup);
                
                const okBtn = popup.querySelector('#confirmOkBtn');
                const cancelBtn = popup.querySelector('#confirmCancelBtn');
                
                const closePopup = (result) => {
                    popup.style.opacity = '0';
                    popup.style.transition = 'opacity 0.2s ease';
                    setTimeout(() => {
                        if (popup && popup.parentNode) {
                            popup.remove();
                        }
                        resolve(result);
                    }, 200);
                };
                
                okBtn.onclick = () => closePopup(true);
                cancelBtn.onclick = () => closePopup(false);
                popup.onclick = (e) => {
                    if (e.target === popup) closePopup(false);
                };
            });
        }
        
        // Browser alert() fonksiyonunu override et - site içi popup kullan
        window.alert = function(message) {
            showCustomAlert(message, 'info');
        };
        
        // Browser confirm() fonksiyonunu override et - site içi popup kullan
        window.confirm = function(message) {
            return customConfirm(message);
        };
        @include('public.salon.partials.appointment-wizard-v2-js')
    </script>

    <!-- Appointment Modal V3 (independent and stable) -->
    <div class="modal fade" id="appointmentModalV3" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content" style="border-radius:16px; overflow:hidden; border:0;">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-calendar-check me-2"></i>Randevu Talebi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="v3Flash" class="alert py-2 mb-3" style="display:none;"></div>
                    <div class="mb-3">
                        <div class="progress" style="height:6px;">
                            <div id="v3Progress" class="progress-bar" role="progressbar" style="width:25%; background:#ec4899;"></div>
                        </div>
                    </div>

                    <div id="v3Step1">
                        <h6 class="mb-3">1) Telefon</h6>
                        <div class="input-group mb-2">
                            <input type="tel" id="v3Phone" class="form-control" placeholder="05XX XXX XX XX">
                            <button type="button" class="btn btn-primary-modern" id="v3CheckPhoneBtn">Kontrol Et</button>
                        </div>
                        <small class="text-muted">Telefonunuza doğrulama kodu gönderilir.</small>
                    </div>

                    <div id="v3Step2" style="display:none;">
                        <h6 class="mb-3">2) Doğrulama</h6>
                        <div id="v3NewCustomerFields" style="display:none;">
                            <div class="row g-2 mb-2">
                                <div class="col-md-4"><input type="text" id="v3Name" class="form-control" placeholder="Ad"></div>
                                <div class="col-md-4"><input type="text" id="v3Surname" class="form-control" placeholder="Soyad"></div>
                                <div class="col-md-4"><input type="number" id="v3Age" class="form-control" min="1" max="120" placeholder="Yaş"></div>
                            </div>
                        </div>
                        <div class="input-group">
                            <input type="text" id="v3Otp" class="form-control" maxlength="6" placeholder="6 haneli kod">
                            <button type="button" class="btn btn-outline-primary-modern" id="v3VerifyOtpBtn">Doğrula</button>
                        </div>
                    </div>

                    <div id="v3Step3" style="display:none;">
                        <div class="v3-step-title">3) Hizmet ve Gün Seçimi</div>
                        <div class="v3-step-subtitle">İstediğiniz hizmetleri seçin, ardından takvimden bir gün belirleyin.</div>
                        <div class="v3-section-card" style="max-height:260px; overflow:auto;">
                            @if($serviceCategories && $serviceCategories->count() > 0)
                                @foreach($serviceCategories as $category)
                                    @php
                                        $categoryServices = $services->where('service_category_id', $category->id);
                                    @endphp
                                    @if($categoryServices->count() > 0)
                                    <div class="mb-3">
                                        <div class="small fw-semibold text-muted mb-2">{{ $category->name }}</div>
                                        <div class="v3-service-grid">
                                            @foreach($categoryServices as $service)
                                                <label class="v3-service-chip v3-service-card" style="cursor:pointer;">
                                                    <input type="checkbox" class="v3-service d-none" value="{{ $service->id }}">
                                                    <span class="v3-check"><i class="bi bi-check"></i></span>
                                                    <span class="v3-service-name">{{ $service->name }}</span>
                                                    <span class="v3-service-meta">
                                                        @if($service->price)
                                                            <span>{{ number_format($service->price, 2, ',', '.') }} ₺</span>
                                                        @endif
                                                        @if($service->duration)
                                                            <span>{{ $service->duration }} dk</span>
                                                        @endif
                                                    </span>
                                                </label>
                                            @endforeach
                                        </div>
                                    </div>
                                    @endif
                                @endforeach
                                @php
                                    $uncategorizedServices = $services->filter(function($service) {
                                        return empty($service->service_category_id);
                                    });
                                @endphp
                                @if($uncategorizedServices->count() > 0)
                                    <div class="mb-1">
                                        <div class="small fw-semibold text-muted mb-2">Diğer Hizmetler</div>
                                        <div class="v3-service-grid">
                                            @foreach($uncategorizedServices as $service)
                                                <label class="v3-service-chip v3-service-card" style="cursor:pointer;">
                                                    <input type="checkbox" class="v3-service d-none" value="{{ $service->id }}">
                                                    <span class="v3-check"><i class="bi bi-check"></i></span>
                                                    <span class="v3-service-name">{{ $service->name }}</span>
                                                    <span class="v3-service-meta">
                                                        @if($service->price)
                                                            <span>{{ number_format($service->price, 2, ',', '.') }} ₺</span>
                                                        @endif
                                                        @if($service->duration)
                                                            <span>{{ $service->duration }} dk</span>
                                                        @endif
                                                    </span>
                                                </label>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            @else
                                <div class="v3-service-grid">
                                    @foreach($services as $service)
                                        <label class="v3-service-chip v3-service-card" style="cursor:pointer;">
                                            <input type="checkbox" class="v3-service d-none" value="{{ $service->id }}">
                                            <span class="v3-check"><i class="bi bi-check"></i></span>
                                            <span class="v3-service-name">{{ $service->name }}</span>
                                            <span class="v3-service-meta">
                                                @if($service->price)
                                                    <span>{{ number_format($service->price, 2, ',', '.') }} ₺</span>
                                                @endif
                                                @if($service->duration)
                                                    <span>{{ $service->duration }} dk</span>
                                                @endif
                                            </span>
                                        </label>
                                    @endforeach
                                </div>
                            @endif
                        </div>

                        <div class="v3-section-card">
                            <div class="d-flex align-items-center justify-content-between mb-2">
                                <button type="button" id="v3PrevMonthBtn" class="btn btn-sm btn-light border"><i class="bi bi-chevron-left"></i></button>
                                <strong id="v3MonthLabel"></strong>
                                <button type="button" id="v3NextMonthBtn" class="btn btn-sm btn-light border"><i class="bi bi-chevron-right"></i></button>
                            </div>
                            <div id="v3CalendarGrid" class="v3-calendar-grid"></div>
                        </div>
                        <small class="text-muted d-block mt-2">Önce tarihi seçin, sonra saat listesine geçilir.</small>
                    </div>

                    <div id="v3Step4" style="display:none;">
                        <div class="v3-step-title">4) Saat Seçimi</div>
                        <div class="v3-step-subtitle">Seçtiğiniz gün için uygun saatlerden birini seçin.</div>
                        <div id="v3SelectedDateLabel" class="mb-2 small text-muted"></div>
                        <div id="v3TimeGrid" class="v3-time-grid"></div>
                        <small class="text-muted d-block mt-2">Gri saatler doludur, tıklanamaz. Renkli saatler seçilebilir.</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light border" data-bs-dismiss="modal">Kapat</button>
                    <button type="button" class="btn btn-outline-primary-modern" id="v3BackBtn" style="display:none;">Geri</button>
                    <button type="button" class="btn btn-primary-modern" id="v3NextBtn" style="display:none;">Devam</button>
                    <button type="button" class="btn btn-primary-modern" id="v3SubmitBtn" style="display:none;" disabled>Talep Gönder</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        (function () {
            const modalEl = document.getElementById('appointmentModalV3');
            if (!modalEl || window.__appointmentV3Ready) return;
            window.__appointmentV3Ready = true;

            const MONTHS = ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'];

            const state = {
                step: 1,
                salonId: {{ $salon->id }},
                isRegistered: false,
                customerId: null,
                selectedDate: null,
                selectedTime: null,
                slotsByDate: {},
                selectedSlot: null,
                monthCursor: (() => {
                    const d = new Date();
                    return new Date(d.getFullYear(), d.getMonth(), 1);
                })()
            };

            const $ = (id) => document.getElementById(id);
            const in30Days = (dateObj) => {
                const now = new Date();
                now.setHours(0, 0, 0, 0);
                const max = new Date(now);
                max.setDate(max.getDate() + 30);
                return dateObj >= now && dateObj <= max;
            };
            const isoDate = (dateObj) => {
                const y = dateObj.getFullYear();
                const m = String(dateObj.getMonth() + 1).padStart(2, '0');
                const d = String(dateObj.getDate()).padStart(2, '0');
                return `${y}-${m}-${d}`;
            };

            const showMessage = (msg, type) => {
                const flash = $('v3Flash');
                const cls = type === 'error' ? 'alert-danger' : type === 'warning' ? 'alert-warning' : type === 'success' ? 'alert-success' : 'alert-info';
                flash.className = `alert ${cls} py-2 mb-3`;
                flash.textContent = msg;
                flash.style.display = 'block';
            };
            const hideMessage = () => { $('v3Flash').style.display = 'none'; };
            const showGlobalToast = (msg, type) => {
                const old = document.getElementById('v3GlobalToast');
                if (old) old.remove();
                const toast = document.createElement('div');
                toast.id = 'v3GlobalToast';
                const bg = type === 'error' ? '#ef4444' : type === 'warning' ? '#f59e0b' : type === 'success' ? '#10b981' : '#3b82f6';
                toast.style.cssText = `position:fixed;top:16px;right:16px;z-index:999999;background:${bg};color:#fff;padding:12px 16px;border-radius:10px;box-shadow:0 8px 24px rgba(0,0,0,.2);`;
                toast.textContent = msg;
                document.body.appendChild(toast);
                setTimeout(() => toast.remove(), 3500);
            };

            const setStep = (step) => {
                state.step = step;
                $('v3Step1').style.display = step === 1 ? 'block' : 'none';
                $('v3Step2').style.display = step === 2 ? 'block' : 'none';
                $('v3Step3').style.display = step === 3 ? 'block' : 'none';
                $('v3Step4').style.display = step === 4 ? 'block' : 'none';
                $('v3Progress').style.width = (step * 25) + '%';
                $('v3BackBtn').style.display = step > 1 ? 'inline-block' : 'none';
                $('v3NextBtn').style.display = step === 2 ? 'inline-block' : 'none';
                $('v3SubmitBtn').style.display = step === 4 ? 'inline-block' : 'none';
                $('v3SubmitBtn').disabled = !(step === 4 && state.selectedTime);
            };

            const reset = () => {
                state.isRegistered = false;
                state.customerId = null;
                state.selectedDate = null;
                state.selectedTime = null;
                state.slotsByDate = {};
                state.selectedSlot = null;
                $('v3Phone').value = '';
                $('v3Otp').value = '';
                $('v3Name').value = '';
                $('v3Surname').value = '';
                $('v3Age').value = '';
                $('v3NewCustomerFields').style.display = 'none';
                document.querySelectorAll('.v3-service').forEach((c) => { c.checked = false; });
                hideMessage();
                setStep(1);
                syncV3ServiceChipTheme();
                renderCalendar();
                renderTimeGrid([]);
            };

            function syncV3ServiceChipTheme() {
                modalEl.querySelectorAll('.v3-service-chip').forEach((chip) => {
                    const checkbox = chip.querySelector('.v3-service');
                    if (!checkbox) return;
                    chip.classList.toggle('is-selected', !!checkbox.checked);
                });
            }

            function renderCalendar() {
                const monthDate = state.monthCursor;
                const year = monthDate.getFullYear();
                const month = monthDate.getMonth();
                $('v3MonthLabel').textContent = `${MONTHS[month]} ${year}`;
                const WEEK = ['Pzt', 'Sal', 'Car', 'Per', 'Cum', 'Cmt', 'Paz'];

                const first = new Date(year, month, 1);
                const last = new Date(year, month + 1, 0);
                const offset = (first.getDay() + 6) % 7;
                const cells = [];

                for (let i = 0; i < offset; i++) cells.push('<div></div>');

                for (let day = 1; day <= last.getDate(); day++) {
                    const current = new Date(year, month, day);
                    const selectable = in30Days(current);
                    const dateStr = isoDate(current);
                    const isSelected = state.selectedDate === dateStr;
                    const cls = `v3-day-btn ${isSelected ? 'is-selected' : ''}`;
                    const disabled = selectable ? '' : 'disabled';
                    const weekday = WEEK[(current.getDay() + 6) % 7];
                    cells.push(
                        `<div>
                            <button type="button" class="${cls}" data-date="${dateStr}" ${disabled} title="${dateStr}">
                                <span class="v3-day-week">${weekday}</span>
                                <span class="v3-day-num">${day}</span>
                            </button>
                        </div>`
                    );
                }

                $('v3CalendarGrid').innerHTML = cells.join('');
            }

            function renderTimeGrid(slots) {
                const container = $('v3TimeGrid');
                if (!slots.length) {
                    container.innerHTML = '<div class="text-muted small">Bu tarih icin uygun saat bulunamadi.</div>';
                    $('v3SubmitBtn').disabled = true;
                    return;
                }
                container.innerHTML = slots.map((slot) => {
                    const isAvailable = slot.available !== false;
                    const isSelected = state.selectedTime === slot.time;
                    const baseCls = `v3-time-btn ${isSelected ? 'is-selected' : ''}`;
                    const disabled = isAvailable ? '' : 'disabled';
                    return `<button type="button" class="${baseCls}" data-time="${slot.time}" ${disabled}>${slot.time}${isAvailable ? '' : ' (Dolu)'}</button>`;
                }).join('');
            }

            async function loadSlotsForDate(dateStr) {
                const serviceIds = Array.from(document.querySelectorAll('.v3-service:checked')).map((x) => x.value);
                if (!serviceIds.length) {
                    showMessage('Önce en az bir hizmet seçin.', 'warning');
                    return;
                }
                hideMessage();
                $('v3SelectedDateLabel').textContent = `Seçilen tarih: ${dateStr}`;
                $('v3TimeGrid').innerHTML = '<div class="text-muted small">Saatler yükleniyor...</div>';
                try {
                    const q = new URLSearchParams({ service_ids: serviceIds.join(','), salon_id: String(state.salonId), date: dateStr });
                    const r = await fetch(`{{ route("public.appointment-request.available-slots-ascii") }}?${q.toString()}`, { headers: { 'Accept': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}' } });
                    const data = await r.json().catch(() => ({}));
                    if (!r.ok || !data.success) throw new Error(data.message || 'Saatler alınamadı.');
                    const slots = Array.isArray(data.available_slots) ? data.available_slots : [];
                    state.slotsByDate[dateStr] = slots;
                    renderTimeGrid(slots);
                    setStep(4);
                } catch (e) {
                    showMessage(e.message || 'Saatler alınamadı.', 'error');
                    renderTimeGrid([]);
                }
            }

            async function checkPhoneV3() {
                const phone = ($('v3Phone').value || '').trim();
                if (!phone) return showMessage('Telefon numarası giriniz.', 'warning');
                const btn = $('v3CheckPhoneBtn');
                const old = btn.innerHTML;
                btn.disabled = true;
                btn.innerHTML = 'Kontrol...';
                try {
                    const r = await fetch('{{ route("public.appointment-request.send-otp") }}', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json' },
                        body: JSON.stringify({ salon_id: state.salonId, phone: phone })
                    });
                    const data = await r.json().catch(() => ({}));
                    if (!r.ok || !data.success) throw new Error(data.message || 'Telefon kontrolü başarısız.');
                    state.isRegistered = !!data.is_registered;
                    state.customerId = data.customer_id || null;
                    if (state.isRegistered) {
                        $('v3Name').value = data.customer_name || '';
                        $('v3Surname').value = data.customer_surname || '';
                        $('v3Age').value = data.customer_age || '';
                        $('v3NewCustomerFields').style.display = 'none';
                        showMessage('Kayıtlı müşteri bulundu. Kod gönderildi.', 'info');
                    } else {
                        $('v3NewCustomerFields').style.display = 'block';
                        showMessage('Yeni müşteri. Bilgileri doldurup kodu doğrulayın.', 'info');
                    }
                    setStep(2);
                } catch (e) {
                    showMessage(e.message || 'Hata oluştu.', 'error');
                } finally {
                    btn.disabled = false;
                    btn.innerHTML = old;
                }
            }

            async function verifyOtpV3() {
                const otp = ($('v3Otp').value || '').trim();
                const phone = ($('v3Phone').value || '').trim();
                if (otp.length !== 6) return showMessage('6 haneli kod giriniz.', 'warning');
                if (!state.isRegistered) {
                    if (!$('v3Name').value.trim() || !$('v3Surname').value.trim() || !$('v3Age').value.trim()) {
                        return showMessage('Ad, soyad ve yas zorunludur.', 'warning');
                    }
                }
                const r = await fetch('{{ route("public.appointment-request.verify-otp") }}', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json' },
                    body: JSON.stringify({ phone: phone, otp_code: otp })
                });
                const data = await r.json().catch(() => ({}));
                if (!r.ok || !data.success) return showMessage(data.message || 'Kod doğrulanamadı.', 'error');
                hideMessage();
                setStep(3);
            }

            async function submitV3() {
                const phone = ($('v3Phone').value || '').trim();
                const date = state.selectedDate;
                const time = state.selectedTime;
                const serviceIds = Array.from(document.querySelectorAll('.v3-service:checked')).map((x) => Number(x.value));
                if (!phone || !date || !time || !serviceIds.length) return showMessage('Tüm zorunlu alanları doldurun.', 'warning');
                if (!$('v3Name').value.trim()) return showMessage('Ad alani zorunludur.', 'warning');
                const payload = {
                    salon_id: state.salonId,
                    service_id: serviceIds[0],
                    service_ids: serviceIds,
                    name: $('v3Name').value.trim(),
                    surname: $('v3Surname').value.trim() || null,
                    age: $('v3Age').value ? parseInt($('v3Age').value, 10) : null,
                    phone: phone,
                    customer_id: state.customerId,
                    date: date,
                    time: time
                };
                const btn = $('v3SubmitBtn');
                const old = btn.innerHTML;
                btn.disabled = true;
                btn.innerHTML = 'Gönderiliyor...';
                try {
                    const r = await fetch('{{ route("public.appointment-request.store") }}', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json' },
                        body: JSON.stringify(payload)
                    });
                    const data = await r.json().catch(() => ({}));
                    if (!r.ok || !data.success) throw new Error(data.message || 'Talep gönderilemedi.');
                    bootstrap.Modal.getOrCreateInstance(modalEl).hide();
                    showGlobalToast('Randevu talebiniz alindi.', 'success');
                    reset();
                } catch (e) {
                    showMessage(e.message || 'Hata oluştu.', 'error');
                } finally {
                    btn.disabled = !(state.selectedTime && state.step === 4);
                    btn.innerHTML = old;
                }
            }

            $('v3CheckPhoneBtn').onclick = (e) => { e.preventDefault(); checkPhoneV3(); };
            $('v3VerifyOtpBtn').onclick = (e) => { e.preventDefault(); verifyOtpV3(); };
            $('v3BackBtn').onclick = (e) => {
                e.preventDefault();
                if (state.step === 4) setStep(3);
                else setStep(Math.max(1, state.step - 1));
            };
            $('v3NextBtn').onclick = (e) => { e.preventDefault(); if (state.step === 2) verifyOtpV3(); };
            $('v3SubmitBtn').onclick = (e) => { e.preventDefault(); submitV3(); };

            document.addEventListener('change', function (e) {
                if (e.target && e.target.classList.contains('v3-service')) {
                    syncV3ServiceChipTheme();
                    if (state.step === 4 && state.selectedDate) {
                        state.selectedTime = null;
                        state.selectedSlot = null;
                        loadSlotsForDate(state.selectedDate);
                    }
                }
            });

            document.addEventListener('click', function (e) {
                const dayBtn = e.target.closest('.v3-day-btn');
                if (dayBtn) {
                    const dateStr = dayBtn.getAttribute('data-date');
                    if (!dateStr) return;
                    state.selectedDate = dateStr;
                    state.selectedTime = null;
                    state.selectedSlot = null;
                    renderCalendar();
                    loadSlotsForDate(dateStr);
                    return;
                }

                const timeBtn = e.target.closest('.v3-time-btn');
                if (timeBtn) {
                    const time = timeBtn.getAttribute('data-time');
                    if (!time) return;
                    const slots = state.slotsByDate[state.selectedDate] || [];
                    const slot = slots.find((s) => String(s.time) === String(time));
                    if (!slot || slot.available === false) return;
                    state.selectedTime = time;
                    state.selectedSlot = slot;
                    renderTimeGrid(slots);
                    $('v3SubmitBtn').disabled = false;
                    // Bilgi metni istenmediği için personel uygunluk yazısı gösterilmiyor.
                }
            });

            $('v3PrevMonthBtn').onclick = () => {
                state.monthCursor = new Date(state.monthCursor.getFullYear(), state.monthCursor.getMonth() - 1, 1);
                renderCalendar();
            };
            $('v3NextMonthBtn').onclick = () => {
                state.monthCursor = new Date(state.monthCursor.getFullYear(), state.monthCursor.getMonth() + 1, 1);
                renderCalendar();
            };

            window.openAppointmentModalV3 = function () {
                reset();
                bootstrap.Modal.getOrCreateInstance(modalEl).show();
            };
            window.openAppointmentModal = window.openAppointmentModalV3;
            window.selectServiceAndOpenModal = function (serviceId) {
                window.openAppointmentModalV3();
                const cb = modalEl.querySelector(`.v3-service[value="${serviceId}"]`);
                if (cb) {
                    cb.checked = true;
                    syncV3ServiceChipTheme();
                }
            };

            syncV3ServiceChipTheme();
            renderCalendar();
        })();
    </script>
</body>
</html>
