<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <title>{{ $salon->salon_name }} - Güzellik Salonu</title>
    @include('partials.google-ads-tag')
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ url('favicon.png') }}?v=3">
    <link rel="shortcut icon" href="{{ url('favicon.png') }}?v=3">
    <link rel="apple-touch-icon" href="{{ url('favicon.png') }}?v=3">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ url('favicon.png') }}?v=3">
    <link rel="shortcut icon" href="{{ url('favicon.png') }}?v=3">
    <link rel="apple-touch-icon" href="{{ url('favicon.png') }}?v=3">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;600;700;900&family=Lora:wght@400;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        @php
            // Renk Paleti Sistemi
            $colorSchemes = [
                'pink' => ['primary' => '#ec4899', 'secondary' => '#be185d', 'accent' => '#f472b6', 'gold' => '#fbbf24', 'light' => '#fef7f7', 'rgba_primary' => '236, 72, 153'],
                'blue' => ['primary' => '#3b82f6', 'secondary' => '#1e40af', 'accent' => '#60a5fa', 'gold' => '#fbbf24', 'light' => '#f0f9ff', 'rgba_primary' => '59, 130, 246'],
                'purple' => ['primary' => '#8b5cf6', 'secondary' => '#7c3aed', 'accent' => '#a78bfa', 'gold' => '#fbbf24', 'light' => '#faf5ff', 'rgba_primary' => '139, 92, 246'],
                'orange' => ['primary' => '#f97316', 'secondary' => '#ea580c', 'accent' => '#fb923c', 'gold' => '#fbbf24', 'light' => '#fff7ed', 'rgba_primary' => '249, 115, 22'],
                'green' => ['primary' => '#10b981', 'secondary' => '#059669', 'accent' => '#34d399', 'gold' => '#fbbf24', 'light' => '#f0fdf4', 'rgba_primary' => '16, 185, 129'],
            ];
            $colors = $colorSchemes[$colorScheme ?? 'pink'];
        @endphp
        
        :root {
            --primary-color: {{ $colors['primary'] }};
            --secondary-color: {{ $colors['secondary'] }};
            --accent-color: {{ $colors['accent'] }};
            --elegant-gold: {{ $colors['gold'] }};
            --dark-navy: #1e293b;
            --light-cream: {{ $colors['light'] }};
            --warm-gray: #6b7280;
            --rgba-primary: {{ $colors['rgba_primary'] }};
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Lora', serif;
            background: var(--light-cream);
            background-image: 
                radial-gradient(circle at 10% 20%, rgba(var(--rgba-primary), 0.05) 0%, transparent 50%),
                radial-gradient(circle at 90% 80%, rgba(var(--rgba-primary), 0.05) 0%, transparent 50%);
            background-attachment: fixed;
            color: var(--dark-navy);
            line-height: 1.8;
            position: relative;
        }

        /* Classic Elegant Header */
        .elegant-header {
            @if($salon->salon_banner_image)
                background-image: url('{{ \Illuminate\Support\Facades\Storage::url($salon->salon_banner_image) }}');
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
            @else
                background: linear-gradient(135deg, var(--dark-navy) 0%, var(--primary-color) 50%, var(--secondary-color) 100%);
            @endif
            color: white;
            padding: 60px 0 40px;
            position: relative;
            overflow: hidden;
        }
        
        .elegant-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            @if($salon->salon_banner_image)
                background: linear-gradient(135deg, rgba(30, 58, 138, 0.7) 0%, rgba(var(--rgba-primary), 0.7) 100%);
            @else
                background: transparent;
            @endif
            z-index: 1;
        }

        .elegant-header::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            @if(!$salon->salon_banner_image)
                background: linear-gradient(45deg, transparent 30%, rgba(255,255,255,0.05) 50%, transparent 70%);
                animation: shimmer 3s infinite;
            @endif
            z-index: 0;
        }

        @keyframes shimmer {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        
        .header-content {
            position: relative;
            z-index: 2;
        }

        .profile-classic {
            width: 220px;
            height: 220px;
            border-radius: 50%;
            object-fit: cover;
            border: 10px solid var(--elegant-gold);
            margin: 0 auto 30px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.5), 0 0 0 15px rgba(251, 191, 36, 0.2);
            display: block;
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            z-index: 1;
            animation: elegantPulse 4s ease-in-out infinite;
        }

        @keyframes elegantPulse {
            0%, 100% { 
                box-shadow: 0 20px 60px rgba(0,0,0,0.5), 0 0 0 15px rgba(251, 191, 36, 0.2);
            }
            50% { 
                box-shadow: 0 25px 70px rgba(0,0,0,0.6), 0 0 0 25px rgba(251, 191, 36, 0.3);
            }
        }

        .profile-classic:hover {
            transform: scale(1.08) rotate(2deg);
            box-shadow: 0 30px 80px rgba(0,0,0,0.6), 0 0 0 30px rgba(251, 191, 36, 0.4);
        }

        .profile-classic-placeholder {
            width: 200px;
            height: 200px;
            border-radius: 50%;
            border: 8px solid var(--elegant-gold);
            margin: 0 auto 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 60px;
            color: white;
            font-weight: bold;
            background: var(--primary-color);
            box-shadow: 0 15px 50px rgba(0,0,0,0.4);
        }

        .elegant-title {
            font-family: 'Playfair Display', serif;
            font-size: 4.5rem;
            font-weight: 900;
            text-align: center;
            margin-bottom: 20px;
            color: white;
            text-shadow: 3px 3px 15px rgba(0,0,0,0.4), 0 0 30px rgba(251, 191, 36, 0.3);
            letter-spacing: 3px;
            position: relative;
            z-index: 1;
            animation: fadeInDown 1s ease-out;
        }

        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .elegant-subtitle {
            font-size: 1.4rem;
            text-align: center;
            opacity: 0.9;
            font-style: italic;
            margin-bottom: 40px;
            color: var(--elegant-gold);
        }

        .contact-elegant {
            display: flex;
            justify-content: center;
            gap: 50px;
            margin: 30px 0;
            flex-wrap: wrap;
        }

        .contact-elegant-item {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.1rem;
            padding: 12px 24px;
            background: rgba(255,255,255,0.1);
            border-radius: 30px;
            border: 1px solid rgba(212,175,55,0.3);
        }

        .contact-elegant-item i {
            font-size: 1.5rem;
            color: var(--elegant-gold);
        }

        .btn-elegant {
            background: var(--elegant-gold);
            color: var(--dark-navy);
            border: none;
            padding: 18px 45px;
            font-size: 1.2rem;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
            box-shadow: 0 8px 25px rgba(212,175,55,0.4);
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .btn-elegant:hover {
            background: #c9a52a;
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(212,175,55,0.6);
            color: var(--dark-navy);
        }

        /* Salon Info Compact */
        .salon-info-compact {
            padding: 20px 0;
            background: rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(10px);
            margin-top: -20px;
            position: relative;
            z-index: 1;
        }

        .salon-info-box {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 16px;
            padding: 18px 22px;
            box-shadow: 0 6px 24px rgba(0,0,0,0.12);
            font-size: 0.9rem;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(212, 175, 55, 0.2);
        }

        .salon-info-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--elegant-gold) 0%, var(--primary-color) 100%);
            opacity: 0.7;
            transition: opacity 0.3s ease;
        }

        .salon-info-box:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 32px rgba(0,0,0,0.15);
            border-color: rgba(212, 175, 55, 0.4);
        }

        .salon-info-box {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 12px;
            padding: 16px 20px;
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
            font-size: 0.9rem;
            border: 1px solid rgba(212, 175, 55, 0.2);
        }

        .salon-description-compact {
            margin-bottom: 10px;
            color: #374151;
            line-height: 1.5;
            font-size: 0.85rem;
        }

        .salon-address-compact {
            color: #6b7280;
            font-size: 0.85rem;
            display: flex;
            align-items: flex-start;
            gap: 8px;
        }

        .salon-address-compact i {
            color: var(--elegant-gold);
            margin-top: 2px;
        }

        /* Classic Section */
        .classic-section {
            padding: 100px 0;
            background: white;
        }

        .section-title-elegant {
            font-family: 'Playfair Display', serif;
            font-size: 3.5rem;
            font-weight: 700;
            text-align: center;
            margin-bottom: 60px;
            color: var(--dark-navy);
            position: relative;
            padding-bottom: 20px;
        }

        .section-title-elegant::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 4px;
            background: linear-gradient(90deg, var(--elegant-gold), var(--accent-color));
        }

        /* Elegant Cards */
        .elegant-card {
            background: white;
            border-radius: 15px;
            border: 2px solid #e5e7eb;
            padding: 40px;
            transition: all 0.4s ease;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        .elegant-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--elegant-gold));
            transform: scaleX(0);
            transition: transform 0.4s ease;
        }

        .elegant-card:hover::before {
            transform: scaleX(1);
        }

        .elegant-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.15);
            border-color: var(--elegant-gold);
        }

        .elegant-card h5 {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 20px;
            color: var(--dark-navy);
        }

        .elegant-card .card-text {
            color: var(--warm-gray);
            font-size: 1rem;
            line-height: 1.8;
            margin-bottom: 25px;
        }

        .price-elegant {
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            font-weight: 700;
            color: var(--elegant-gold);
            margin-bottom: 10px;
        }

        .duration-elegant {
            font-size: 0.9rem;
            color: var(--warm-gray);
            font-style: italic;
        }

        .btn-elegant-sm {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s ease;
            text-transform: uppercase;
            font-size: 0.9rem;
            letter-spacing: 0.5px;
        }

        .btn-elegant-sm:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(var(--rgba-primary), 0.4);
            color: white;
        }

        /* Personel Elegant */
        .personel-elegant {
            background: white;
            border-radius: 15px;
            border: 2px solid #e5e7eb;
            padding: 40px;
            text-align: center;
            transition: all 0.4s ease;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            height: 100%;
        }

        .personel-elegant:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.15);
            border-color: var(--elegant-gold);
        }

        .personel-avatar-elegant {
            width: 140px;
            height: 140px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
            font-size: 3rem;
            color: white;
            font-weight: 700;
            border: 5px solid var(--elegant-gold);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
        }

        .personel-elegant:hover .personel-avatar-elegant {
            transform: scale(1.1);
            border-color: var(--accent-color);
        }

        .personel-elegant h5 {
            font-family: 'Playfair Display', serif;
            font-size: 1.6rem;
            font-weight: 700;
            margin-bottom: 20px;
            color: var(--dark-navy);
        }

        .service-badge-elegant {
            display: inline-block;
            background: var(--primary-color);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
            margin: 5px;
            border: 2px solid var(--elegant-gold);
        }

        /* Gallery Section */
        .gallery-grid-public {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .gallery-item-public {
            position: relative;
            overflow: hidden;
            border-radius: 16px;
            aspect-ratio: 1;
            cursor: pointer;
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 2px solid var(--elegant-gold);
        }

        .gallery-item-public:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 32px rgba(212,175,55,0.4);
            border-color: var(--primary-color);
        }

        .gallery-image-public {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .gallery-item-public:hover .gallery-image-public {
            transform: scale(1.1);
        }

        .gallery-item-public::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(212,175,55,0.1) 0%, rgba(212,175,55,0.3) 100%);
            opacity: 0;
            transition: opacity 0.3s;
        }

        .gallery-item-public:hover::after {
            opacity: 1;
        }

        @media (max-width: 768px) {
            .gallery-grid-public {
                grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
                gap: 12px;
            }
        }

        /* Elegant Footer */
        footer {
            background: var(--dark-navy);
            color: white;
            padding: 50px 0;
            text-align: center;
            border-top: 4px solid var(--elegant-gold);
        }

        footer .container {
            padding-left: 15px;
            padding-right: 15px;
        }

        /* Elegant Modal */
        .modal-content {
            border-radius: 20px;
            border: 3px solid var(--elegant-gold);
            box-shadow: 0 10px 50px rgba(0,0,0,0.3);
            overflow: hidden;
        }

        .modal-header {
            background: linear-gradient(135deg, var(--dark-navy) 0%, var(--primary-color) 100%);
            border-bottom: 3px solid var(--elegant-gold);
            padding: 25px 35px;
            color: white;
        }

        .modal-title {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            font-weight: 700;
        }

        .modal-body {
            padding: 35px;
            background: var(--light-cream);
        }

        .appointment-step {
            min-height: 350px;
            padding: 20px 0;
        }

        .appointment-step h6 {
            font-family: 'Playfair Display', serif;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 30px;
            color: var(--dark-navy);
        }

        .form-control, .form-select {
            border-radius: 10px;
            border: 2px solid #d1d5db;
            padding: 15px 20px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--elegant-gold);
            box-shadow: 0 0 0 4px rgba(212,175,55,0.1);
            outline: none;
        }

        .form-label {
            font-weight: 600;
            color: var(--dark-navy);
            margin-bottom: 10px;
        }

        #otpCode {
            font-size: 2rem;
            letter-spacing: 12px;
            text-align: center;
            font-weight: 700;
            padding: 20px;
            border: 3px solid var(--elegant-gold);
            border-radius: 15px;
        }

        .service-option-card {
            position: relative;
            background: white;
            border-radius: 15px;
            border: 3px solid #e5e7eb;
            transition: all 0.3s ease;
            cursor: pointer;
            overflow: hidden;
        }

        .service-option-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border-color: var(--elegant-gold);
        }

        .service-option-card.border-primary {
            border-color: #ec4899 !important;
            border-width: 3px !important;
            border-style: solid !important;
            box-shadow: 0 8px 24px rgba(236, 72, 153, 0.3) !important;
        }

        .service-option-card.border-primary:hover {
            border-color: #ec4899 !important;
            border-width: 3px !important;
        }

        /* Step Category Tabs */
        .step-category-tab-btn {
            padding: 8px 16px;
            border: none;
            background: #f3f4f6;
            border-radius: 8px;
            cursor: pointer;
            white-space: nowrap;
            transition: all 0.3s;
            color: #000000 !important;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .step-category-tab-btn:hover {
            background: #e5e7eb;
            transform: translateY(-2px);
        }

        .step-category-tab-btn.active {
            background: var(--elegant-gold);
            color: #ffffff;
            box-shadow: 0 4px 12px rgba(212,175,55,0.3);
        }

        .step-services-category-content {
            animation: fadeIn 0.3s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Service Checkbox */
        .service-checkbox-wrapper {
            position: relative;
            flex-shrink: 0;
        }

        .service-checkbox {
            width: 28px;
            height: 28px;
            border: 3px solid #e5e7eb;
            border-radius: 6px;
            background: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
            position: relative;
        }

        .service-checkbox i {
            color: white;
            font-size: 16px;
            font-weight: bold;
            display: none;
            position: absolute;
            z-index: 2;
        }

        .service-option-card.border-primary .service-checkbox {
            background: #ec4899 !important;
            border-color: #ec4899 !important;
            border-width: 3px !important;
        }

        .service-option-card.border-primary .service-checkbox i {
            display: flex !important;
            color: white !important;
        }
        
        /* Inline style override koruması */
        .service-option-card.border-primary [data-service-id] {
            border-color: #ec4899 !important;
        }

        .alert-modern {
            background: rgba(var(--rgba-primary), 0.1);
            border: 2px solid var(--primary-color);
            border-radius: 12px;
            padding: 16px 20px;
            color: var(--primary-color);
        }

        .modal-footer {
            border-top: 2px solid var(--elegant-gold);
            padding: 25px 35px;
            background: white;
        }

        .btn-outline-primary-modern {
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-outline-primary-modern:hover {
            background: var(--primary-color);
            color: white;
            transform: translateY(-2px);
        }

        .btn-primary-modern {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
            color: white;
            transition: all 0.3s ease;
        }

        .btn-primary-modern:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(var(--rgba-primary), 0.4);
        }

        /* Elegant Tab System */
        .tab-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            padding: 50px;
            margin-top: 50px;
            border: 2px solid rgba(var(--rgba-primary), 0.1);
        }

        .tab-nav {
            display: flex;
            gap: 15px;
            margin-bottom: 50px;
            border-bottom: 3px solid rgba(251, 191, 36, 0.2);
            padding-bottom: 0;
        }

        .tab-btn {
            background: transparent;
            border: none;
            padding: 18px 40px;
            font-size: 1.2rem;
            font-weight: 600;
            font-family: 'Playfair Display', serif;
            color: var(--warm-gray);
            cursor: pointer;
            position: relative;
            transition: all 0.3s ease;
            border-radius: 15px 15px 0 0;
        }

        .tab-btn::after {
            content: '';
            position: absolute;
            bottom: -3px;
            left: 0;
            width: 0;
            height: 3px;
            background: linear-gradient(135deg, var(--elegant-gold), var(--primary-color));
            transition: width 0.3s ease;
        }

        .tab-btn.active {
            color: var(--primary-color);
            background: rgba(var(--rgba-primary), 0.05);
        }

        .tab-btn.active::after {
            width: 100%;
        }

        .tab-btn:hover {
            color: var(--primary-color);
            background: rgba(var(--rgba-primary), 0.05);
        }

        .tab-content {
            display: none;
            animation: elegantFadeIn 0.5s ease-in;
        }

        .tab-content.active {
            display: block;
        }

        @keyframes elegantFadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive - Modern Mobile */
        @media (max-width: 768px) {
            .elegant-header {
                padding: 50px 0 40px;
            }
            
            .elegant-title {
                font-size: 1.75rem;
                line-height: 1.3;
                margin-bottom: 1rem;
            }
            
            .salon-info-compact {
                padding: 15px 0;
            }

            .salon-info-box {
                padding: 12px 16px;
                font-size: 0.8rem;
            }

            .salon-description-compact,
            .salon-address-compact {
                font-size: 0.75rem;
            }

            .section-title-elegant {
                font-size: 1.5rem;
                margin-bottom: 1.5rem;
            }
            
            .btn-elegant {
                width: 100%;
                padding: 14px 24px;
                font-size: 1rem;
            }
            
            .profile-classic, .profile-classic-placeholder {
                width: 120px;
                height: 120px;
                margin-bottom: 1.5rem;
            }
            
            .modal-dialog {
                margin: 15px;
                max-width: calc(100% - 30px);
            }
            
            .modal-content {
                border-radius: 20px;
            }
            
            .modal-body {
                padding: 20px;
            }
            
            .contact-info {
                flex-direction: column;
                gap: 15px;
                margin-bottom: 1.5rem;
                max-width: 100%;
                padding: 0 15px;
            }
            
            .contact-item {
                font-size: 0.9rem;
                padding: 12px 16px !important;
                width: 100% !important;
                min-width: 100% !important;
                max-width: 100% !important;
                text-align: center !important;
                flex-direction: row !important;
                justify-content: center !important;
            }
            
            .contact-item i {
                font-size: 1.1rem !important;
            }
            
            .contact-item span {
                font-size: 0.85rem !important;
            }
            
            .tab-container {
                padding: 20px 15px;
            }
            
            .tab-nav {
                flex-direction: row;
                gap: 10px;
                margin-bottom: 20px;
            }
            
            .tab-btn {
                flex: 1;
                padding: 12px 16px;
                font-size: 0.9rem;
            }
            
            .card {
                margin-bottom: 1rem;
            }
        }
        
        /* Small Mobile */
        @media (max-width: 480px) {
            .elegant-header {
                padding: 40px 0 30px;
            }
            
            .elegant-title {
                font-size: 1.5rem;
            }
            
            .salon-info-compact {
                padding: 12px 0;
            }

            .salon-info-box {
                padding: 10px 12px;
                font-size: 0.75rem;
            }

            .salon-description-compact,
            .salon-address-compact {
                font-size: 0.7rem;
            }
            
            .section-title-elegant {
                font-size: 1.35rem;
            }
            
            .profile-classic, .profile-classic-placeholder {
                width: 100px;
                height: 100px;
            }
            
            .contact-info {
                padding: 0 10px;
                gap: 12px;
            }
            
            .contact-item {
                padding: 10px 14px;
                font-size: 0.85rem;
                width: 100%;
                min-width: 100%;
                max-width: 100%;
            }
            
            .contact-item i {
                font-size: 1rem;
            }
            
            .contact-item span {
                font-size: 0.8rem;
            }
            
            .tab-container {
                padding: 15px 10px;
            }
            
            .tab-btn {
                font-size: 0.85rem;
                padding: 10px 12px;
            }
        }
        
        /* ========================================
           MOBILE PERFORMANCE OPTIMIZATIONS
           ======================================== */
        @media (max-width: 768px) {
            * {
                will-change: auto !important;
            }
            
            [style*="backdrop-filter"], *[class*="backdrop"] {
                backdrop-filter: none !important;
                -webkit-backdrop-filter: none !important;
            }
            
            *:hover {
                transform: none !important;
            }
            
            * {
                box-shadow: none !important;
            }
            
            .card, .modal-content {
                box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important;
            }
            
            * {
                transition-duration: 0.15s !important;
            }
            
            button, a, .btn, input, select, textarea {
                -webkit-tap-highlight-color: rgba(236, 72, 153, 0.2);
                touch-action: manipulation;
            }
        }
    </style>
    <style>
        /* Modern refresh layer - theme2 */
        body.modern-salon-theme {
            font-family: 'Inter', 'Lora', serif;
            color: #0f172a;
            background:
                radial-gradient(1000px 400px at 0% -10%, rgba(var(--rgba-primary), 0.14), transparent 60%),
                radial-gradient(900px 380px at 100% 0%, rgba(15, 23, 42, 0.08), transparent 60%),
                #f8fafc;
        }

        body.modern-salon-theme .elegant-header {
            min-height: 460px;
            padding: 72px 0 110px;
            border-radius: 0 0 36px 36px;
            box-shadow: 0 20px 50px rgba(15, 23, 42, 0.18);
        }

        body.modern-salon-theme .header-content {
            max-width: 1080px;
            margin: 0 auto;
        }

        body.modern-salon-theme .profile-classic,
        body.modern-salon-theme .profile-classic-placeholder {
            width: 170px;
            height: 170px;
            border-width: 6px;
            margin-bottom: 22px;
            box-shadow: 0 14px 32px rgba(15, 23, 42, 0.35), 0 0 0 9px rgba(251, 191, 36, 0.22);
            animation: none;
        }

        body.modern-salon-theme .elegant-title {
            font-family: 'Inter', sans-serif;
            font-size: clamp(2rem, 4vw, 3.4rem);
            line-height: 1.15;
            letter-spacing: -0.02em;
            font-weight: 800;
            margin-bottom: 14px;
        }

        body.modern-salon-theme .rating-display {
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            gap: 12px !important;
            margin: 12px auto 4px !important;
            padding: 9px 16px !important;
            border-radius: 999px !important;
            background: rgba(255, 255, 255, 0.16) !important;
            border: 1px solid rgba(255, 255, 255, 0.34) !important;
            backdrop-filter: blur(6px);
        }

        body.modern-salon-theme .contact-info {
            margin: 22px auto !important;
            gap: 10px !important;
        }

        body.modern-salon-theme .contact-item {
            background: rgba(255, 255, 255, 0.16) !important;
            border: 1px solid rgba(255, 255, 255, 0.32) !important;
            border-radius: 14px !important;
            padding: 10px 14px !important;
            min-width: 180px !important;
            box-shadow: 0 8px 22px rgba(2, 6, 23, 0.16) !important;
        }

        body.modern-salon-theme .btn-elegant {
            padding: 12px 24px;
            border-radius: 12px;
            font-size: 1rem;
            letter-spacing: 0.01em;
            text-transform: none;
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
            box-shadow: 0 12px 26px rgba(245, 158, 11, 0.35);
        }

        body.modern-salon-theme .btn-elegant:hover {
            transform: translateY(-2px);
            box-shadow: 0 16px 30px rgba(245, 158, 11, 0.42);
        }

        body.modern-salon-theme .classic-section {
            margin-top: -62px;
            position: relative;
            z-index: 3;
            padding-bottom: 36px;
        }

        body.modern-salon-theme .tab-container {
            background: rgba(255, 255, 255, 0.96);
            backdrop-filter: blur(8px);
            border: 1px solid rgba(15, 23, 42, 0.08);
            border-radius: 24px;
            box-shadow: 0 24px 45px rgba(15, 23, 42, 0.12);
            overflow: hidden;
        }

        body.modern-salon-theme .tab-nav {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            padding: 18px;
            border-bottom: 1px solid #e5e7eb;
            background: linear-gradient(180deg, #ffffff 0%, #f8fafc 100%);
            position: sticky;
            top: 0;
            z-index: 10;
        }

        body.modern-salon-theme .tab-btn {
            border: 1px solid #e2e8f0 !important;
            background: #f8fafc !important;
            color: #334155 !important;
            border-radius: 12px;
            padding: 10px 16px;
            font-weight: 600;
            font-size: 0.93rem;
            transition: all 0.2s ease;
        }

        body.modern-salon-theme .tab-btn.active,
        body.modern-salon-theme .tab-btn:hover {
            border-color: rgba(var(--rgba-primary), 0.35) !important;
            background: rgba(var(--rgba-primary), 0.12) !important;
            color: #0f172a !important;
            transform: translateY(-1px);
        }

        body.modern-salon-theme .tab-content {
            padding: 22px 20px 18px;
        }

        body.modern-salon-theme .category-tabs {
            border-bottom: 1px solid #e5e7eb !important;
            padding-bottom: 14px !important;
            margin-bottom: 16px !important;
        }

        body.modern-salon-theme .category-tab-btn {
            border: 1px solid #e2e8f0 !important;
            border-radius: 999px !important;
            background: #ffffff !important;
            color: #334155 !important;
            font-weight: 600;
            padding: 8px 14px !important;
        }

        body.modern-salon-theme .category-tab-btn.active {
            background: rgba(var(--rgba-primary), 0.14) !important;
            color: #0f172a !important;
            border-color: rgba(var(--rgba-primary), 0.42) !important;
        }

        body.modern-salon-theme .service-category-content .row {
            --bs-gutter-x: 1.1rem;
            --bs-gutter-y: 1.1rem;
        }

        body.modern-salon-theme .elegant-card {
            height: 100%;
            border: 1px solid #e5e7eb;
            border-radius: 16px;
            padding: 18px;
            background: #ffffff;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08);
            transition: transform 0.2s ease, box-shadow 0.2s ease, border-color 0.2s ease;
        }

        body.modern-salon-theme .elegant-card:hover {
            transform: translateY(-3px);
            border-color: rgba(var(--rgba-primary), 0.35);
            box-shadow: 0 16px 30px rgba(15, 23, 42, 0.12);
        }

        body.modern-salon-theme .elegant-card h5 {
            font-size: 1.05rem;
            font-weight: 700;
            margin-bottom: 8px;
            color: #0f172a;
        }

        body.modern-salon-theme .price-elegant {
            font-size: 1.22rem;
            font-weight: 800;
            color: var(--primary-color);
        }

        body.modern-salon-theme .duration-elegant {
            color: #64748b;
            font-size: 0.88rem;
            margin-top: 2px;
        }

        body.modern-salon-theme .gallery-grid-public {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(210px, 1fr));
            gap: 14px;
        }

        body.modern-salon-theme .gallery-item-public {
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid #e2e8f0;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.10);
            background: #fff;
        }

        body.modern-salon-theme .gallery-image-public {
            width: 100%;
            aspect-ratio: 4 / 3;
            object-fit: cover;
            cursor: zoom-in;
            transition: transform 0.3s ease;
        }

        body.modern-salon-theme .gallery-item-public:hover .gallery-image-public {
            transform: scale(1.05);
        }

        body.modern-salon-theme .personel-elegant {
            border: 1px solid #e2e8f0;
            border-radius: 18px;
            padding: 20px;
            background: #fff;
            height: 100%;
            text-align: center;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08);
        }

        body.modern-salon-theme .personel-avatar-elegant {
            width: 72px;
            height: 72px;
            border-radius: 50%;
            display: grid;
            place-items: center;
            color: #fff;
            font-weight: 700;
            margin: 0 auto 12px;
            box-shadow: 0 8px 20px rgba(15, 23, 42, 0.22);
        }

        body.modern-salon-theme .service-badge-elegant {
            display: inline-block;
            margin: 4px;
            padding: 6px 10px;
            border-radius: 999px;
            font-size: 0.78rem;
            background: rgba(var(--rgba-primary), 0.14);
            color: #0f172a;
            font-weight: 600;
        }

        body.modern-salon-theme #ratingsTab .elegant-card {
            border: 1px solid #e5e7eb !important;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08) !important;
            border-radius: 16px !important;
        }

        body.modern-salon-theme #ratingsTab .elegant-card .card-body {
            padding: 16px 18px;
        }

        body.modern-salon-theme .modal-content {
            border-radius: 18px;
            border: 1px solid #e5e7eb;
        }

        @media (max-width: 992px) {
            body.modern-salon-theme .elegant-header {
                min-height: auto;
                padding: 56px 0 95px;
                border-radius: 0 0 26px 26px;
            }

            body.modern-salon-theme .classic-section {
                margin-top: -52px;
            }
        }

        @media (max-width: 768px) {
            body.modern-salon-theme .tab-container {
                border-radius: 16px;
                box-shadow: 0 10px 24px rgba(15, 23, 42, 0.12) !important;
            }

            body.modern-salon-theme .tab-nav {
                gap: 8px;
                padding: 12px;
            }

            body.modern-salon-theme .tab-btn {
                flex: 1 1 calc(50% - 8px);
                justify-content: center;
                text-align: center;
                font-size: 0.83rem;
                padding: 9px 10px;
            }

            body.modern-salon-theme .tab-content {
                padding: 14px 12px 10px;
            }

            body.modern-salon-theme .elegant-card,
            body.modern-salon-theme .personel-elegant,
            body.modern-salon-theme .gallery-item-public {
                box-shadow: 0 8px 18px rgba(15, 23, 42, 0.10) !important;
            }
        }
    </style>
    <style>
        /* Alternative redesign layer: Neo Luxe */
        body.neo-salon-theme {
            background:
                radial-gradient(1200px 520px at 20% -20%, rgba(var(--rgba-primary), 0.20), transparent 60%),
                radial-gradient(900px 450px at 90% -15%, rgba(10, 15, 35, 0.40), transparent 62%),
                #0b1020;
            color: #e2e8f0;
        }

        body.neo-salon-theme .elegant-header {
            border-radius: 0 0 42px 42px;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.45);
        }

        body.neo-salon-theme .elegant-header::before {
            background: linear-gradient(120deg, rgba(11, 16, 32, 0.78) 0%, rgba(var(--rgba-primary), 0.58) 100%);
        }

        body.neo-salon-theme .elegant-title {
            text-shadow: 0 14px 30px rgba(0, 0, 0, 0.45);
        }

        body.neo-salon-theme .contact-item {
            background: rgba(11, 16, 32, 0.48) !important;
            border: 1px solid rgba(255, 255, 255, 0.16) !important;
            box-shadow: 0 12px 26px rgba(0, 0, 0, 0.28) !important;
        }

        body.neo-salon-theme .contact-item span,
        body.neo-salon-theme .contact-item i {
            color: #f8fafc !important;
        }

        body.neo-salon-theme .classic-section {
            margin-top: -72px;
        }

        body.neo-salon-theme .tab-container {
            background: linear-gradient(180deg, rgba(15, 23, 42, 0.92) 0%, rgba(15, 23, 42, 0.84) 100%);
            border: 1px solid rgba(255, 255, 255, 0.12);
            box-shadow: 0 26px 55px rgba(0, 0, 0, 0.36);
        }

        body.neo-salon-theme .tab-nav {
            background: rgba(11, 16, 32, 0.62);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        body.neo-salon-theme .tab-btn {
            background: rgba(30, 41, 59, 0.65) !important;
            border: 1px solid rgba(148, 163, 184, 0.25) !important;
            color: #e2e8f0 !important;
        }

        body.neo-salon-theme .tab-btn.active,
        body.neo-salon-theme .tab-btn:hover {
            background: rgba(var(--rgba-primary), 0.32) !important;
            border-color: rgba(var(--rgba-primary), 0.72) !important;
            color: #ffffff !important;
        }

        body.neo-salon-theme .tab-content {
            color: #cbd5e1;
        }

        body.neo-salon-theme .elegant-card,
        body.neo-salon-theme .personel-elegant,
        body.neo-salon-theme .gallery-item-public {
            background: rgba(15, 23, 42, 0.72) !important;
            border: 1px solid rgba(148, 163, 184, 0.22) !important;
            box-shadow: 0 14px 34px rgba(0, 0, 0, 0.30) !important;
        }

        body.neo-salon-theme .elegant-card h5,
        body.neo-salon-theme .personel-elegant h5 {
            color: #f8fafc;
        }

        body.neo-salon-theme .elegant-card p,
        body.neo-salon-theme .text-muted {
            color: #94a3b8 !important;
        }

        body.neo-salon-theme .service-badge-elegant {
            background: rgba(var(--rgba-primary), 0.26);
            color: #f8fafc;
        }

        body.neo-salon-theme .category-tab-btn {
            background: rgba(30, 41, 59, 0.62) !important;
            border-color: rgba(148, 163, 184, 0.22) !important;
            color: #e2e8f0 !important;
        }

        body.neo-salon-theme .category-tab-btn.active {
            background: rgba(var(--rgba-primary), 0.36) !important;
            border-color: rgba(var(--rgba-primary), 0.76) !important;
            color: #ffffff !important;
        }

        body.neo-salon-theme .price-elegant {
            color: #facc15;
        }
    </style>
    <style>
        /* Unified modern layer */
        body.modern-v3 {
            background: radial-gradient(1200px 440px at 0% -10%, rgba(var(--rgba-primary), 0.14), transparent 60%), #f8fafc;
            color: #0f172a;
        }
        body.modern-v3 .hero-section,
        body.modern-v3 .elegant-header {
            border-radius: 0 0 30px 30px;
            box-shadow: 0 18px 40px rgba(15, 23, 42, 0.16);
            padding-bottom: 90px;
        }
        body.modern-v3 .profile-image,
        body.modern-v3 .profile-classic {
            width: 156px;
            height: 156px;
            border-width: 6px;
            box-shadow: 0 14px 30px rgba(15, 23, 42, 0.3);
            animation: none;
        }
        body.modern-v3 .hero-section h1,
        body.modern-v3 .elegant-title {
            font-size: clamp(2rem, 4.2vw, 3.3rem);
            letter-spacing: -0.02em;
            text-shadow: 0 10px 24px rgba(0, 0, 0, 0.25);
        }
        body.modern-v3 .contact-item {
            border-radius: 14px !important;
            border: 1px solid rgba(255, 255, 255, 0.38) !important;
            background: rgba(255, 255, 255, 0.22) !important;
            box-shadow: 0 8px 18px rgba(15, 23, 42, 0.16) !important;
        }
        body.modern-v3 .btn-modern, body.modern-v3 .btn-elegant {
            border-radius: 12px;
            padding: 12px 24px;
            text-transform: none;
            letter-spacing: 0.01em;
            box-shadow: 0 10px 22px rgba(15, 23, 42, 0.2);
        }
        body.modern-v3 .section, body.modern-v3 .classic-section {
            margin-top: -58px;
            position: relative;
            z-index: 3;
            padding-bottom: 30px;
        }
        body.modern-v3 .tab-container {
            background: rgba(255, 255, 255, 0.95);
            border: 1px solid rgba(15, 23, 42, 0.09);
            border-radius: 22px;
            box-shadow: 0 22px 42px rgba(15, 23, 42, 0.12);
            overflow: hidden;
        }
        body.modern-v3 .tab-nav {
            padding: 14px;
            background: linear-gradient(180deg, #ffffff 0%, #f8fafc 100%);
            border-bottom: 1px solid #e2e8f0;
            margin-bottom: 0;
            gap: 10px;
            display: flex;
            flex-wrap: wrap;
        }
        body.modern-v3 .tab-btn {
            border-radius: 12px !important;
            border: 1px solid #e2e8f0 !important;
            background: #f8fafc !important;
            color: #334155 !important;
            padding: 10px 14px !important;
            font-weight: 600;
        }
        body.modern-v3 .tab-btn.active, body.modern-v3 .tab-btn:hover {
            background: rgba(var(--rgba-primary), 0.14) !important;
            border-color: rgba(var(--rgba-primary), 0.4) !important;
            color: #0f172a !important;
        }
        body.modern-v3 .tab-content { padding: 18px 16px 14px; }
        body.modern-v3 .category-tab-btn {
            border: 1px solid #e2e8f0 !important;
            border-radius: 999px !important;
            background: #fff !important;
            color: #334155 !important;
            font-weight: 600;
        }
        body.modern-v3 .category-tab-btn.active {
            background: rgba(var(--rgba-primary), 0.14) !important;
            border-color: rgba(var(--rgba-primary), 0.42) !important;
            color: #111827 !important;
        }
        body.modern-v3 .service-card, body.modern-v3 .personel-card, body.modern-v3 .elegant-card, body.modern-v3 .personel-elegant {
            border: 1px solid #e5e7eb !important;
            border-radius: 16px !important;
            box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08) !important;
            background: #ffffff !important;
        }
        body.modern-v3 .gallery-item-public {
            border-radius: 14px;
            overflow: hidden;
            border: 1px solid #e2e8f0;
            box-shadow: 0 8px 18px rgba(15, 23, 42, 0.1);
        }
        body.modern-v3 .gallery-image-public { aspect-ratio: 4 / 3; object-fit: cover; }
        body.modern-v3 .personel-avatar, body.modern-v3 .personel-avatar-elegant { box-shadow: 0 8px 18px rgba(15, 23, 42, 0.2); }
        body.modern-v3 .modal-content { border-radius: 16px; border: 1px solid #e5e7eb; }
    </style>
    <style>
        /* Theme2 identity: Neon Glass */
        body.theme2-neon-glass .elegant-header {
            border-radius: 0 0 34px 34px;
            overflow: hidden;
        }
        body.theme2-neon-glass .elegant-header::before {
            background: linear-gradient(125deg, rgba(15, 23, 42, 0.76), rgba(var(--rgba-primary), 0.58)) !important;
        }
        body.theme2-neon-glass .tab-container {
            border: 1px solid rgba(99, 102, 241, 0.24);
            box-shadow: 0 22px 44px rgba(79, 70, 229, 0.14), 0 8px 20px rgba(15, 23, 42, 0.08);
        }
        body.theme2-neon-glass .tab-btn.active {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.18), rgba(236, 72, 153, 0.14)) !important;
            border-color: rgba(99, 102, 241, 0.45) !important;
        }
        body.theme2-neon-glass .elegant-card,
        body.theme2-neon-glass .personel-elegant {
            border: 1px solid rgba(99, 102, 241, 0.16) !important;
        }
    </style>
    <style>
        /* Mobile hardening - shared responsive safety */
        @media (max-width: 1024px) {
            .container {
                max-width: 100% !important;
                padding-left: 14px !important;
                padding-right: 14px !important;
            }
            .tab-container {
                border-radius: 16px !important;
            }
            .tab-content {
                padding: 14px 12px !important;
            }
            .row {
                --bs-gutter-x: 0.9rem !important;
                --bs-gutter-y: 0.9rem !important;
            }
        }

        @media (max-width: 768px) {
            html, body {
                overflow-x: hidden !important;
            }
            .hero-section, .elegant-header {
                padding: 42px 0 72px !important;
                min-height: auto !important;
                border-radius: 0 0 18px 18px !important;
            }
            .hero-content, .header-content {
                padding-left: 2px !important;
                padding-right: 2px !important;
            }
            .profile-image, .profile-classic, .profile-classic-placeholder {
                width: 110px !important;
                height: 110px !important;
                margin-bottom: 14px !important;
            }
            .hero-section h1, .elegant-title {
                font-size: 1.4rem !important;
                line-height: 1.25 !important;
                margin-bottom: 8px !important;
            }
            .rating-display {
                width: auto !important;
                max-width: 100% !important;
                padding: 7px 10px !important;
                gap: 8px !important;
            }
            .contact-info {
                display: grid !important;
                grid-template-columns: 1fr !important;
                gap: 10px !important;
                width: 100% !important;
                margin: 14px 0 !important;
            }
            .contact-item {
                width: 100% !important;
                min-width: 100% !important;
                max-width: 100% !important;
                justify-content: center !important;
                padding: 10px 12px !important;
            }
            .section, .classic-section {
                margin-top: -26px !important;
                padding-bottom: 18px !important;
            }
            .tab-container {
                border-radius: 12px !important;
                overflow: hidden !important;
            }
            .tab-nav {
                display: grid !important;
                grid-template-columns: 1fr 1fr !important;
                gap: 8px !important;
                padding: 10px !important;
                position: static !important;
            }
            .tab-btn {
                min-width: 0 !important;
                width: 100% !important;
                justify-content: center !important;
                text-align: center !important;
                padding: 9px 8px !important;
                font-size: 0.82rem !important;
                line-height: 1.2 !important;
            }
            .category-tabs .d-flex {
                gap: 6px !important;
            }
            .category-tab-btn, .step-category-tab-btn {
                padding: 7px 10px !important;
                font-size: 0.78rem !important;
                white-space: nowrap !important;
            }
            .service-card, .elegant-card, .personel-card, .personel-elegant {
                margin-bottom: 0 !important;
            }
            .card-body {
                padding: 12px !important;
            }
            .gallery-grid-public {
                grid-template-columns: 1fr 1fr !important;
                gap: 8px !important;
            }
            .gallery-item-public {
                border-radius: 10px !important;
            }
            .gallery-image-public {
                aspect-ratio: 1 / 1 !important;
            }
            .modal-dialog {
                margin: 10px !important;
            }
            .modal-content {
                border-radius: 12px !important;
                max-height: calc(100vh - 20px) !important;
            }
            .modal-body {
                max-height: calc(100vh - 180px) !important;
                overflow-y: auto !important;
            }
            #appointmentModal .modal-footer {
                flex-wrap: wrap !important;
                gap: 8px !important;
            }
            #appointmentModal .modal-footer .btn {
                flex: 1 1 calc(50% - 8px) !important;
                min-width: 120px !important;
            }
            .date-option-card, .time-slot-btn {
                min-height: 44px !important;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding-left: 10px !important;
                padding-right: 10px !important;
            }
            .tab-nav {
                grid-template-columns: 1fr !important;
            }
            .tab-btn {
                font-size: 0.8rem !important;
                padding: 9px 10px !important;
            }
            .gallery-grid-public {
                grid-template-columns: 1fr !important;
            }
            #appointmentModal .modal-footer .btn {
                flex: 1 1 100% !important;
                width: 100% !important;
            }
            .btn-modern, .btn-elegant {
                width: 100% !important;
                padding: 11px 14px !important;
            }
        }
    </style>
    <style>
        /* Interaction safety layer for tab menus */
        .hero-section::before,
        .hero-section::after,
        .elegant-header::before,
        .elegant-header::after {
            pointer-events: none !important;
        }

        .section,
        .classic-section,
        .tab-container,
        .tab-nav {
            position: relative;
            z-index: 25;
        }

        .tab-btn,
        .category-tab-btn,
        .step-category-tab-btn {
            position: relative;
            z-index: 26;
            pointer-events: auto !important;
        }

        .tab-container .tab-content {
            display: none;
        }

        .tab-container .tab-content.active {
            display: block !important;
        }
    </style>
</head>
<body class="modern-salon-theme neo-salon-theme modern-v3 theme2-neon-glass">
    <!-- Elegant Header -->
    <div class="elegant-header">
        <div class="container" style="position: relative; z-index: 2;">
            <div class="header-content">
                @if($salon->salon_profile_image)
                    <img src="{{ \Illuminate\Support\Facades\Storage::url($salon->salon_profile_image) }}" alt="{{ $salon->salon_name }}" class="profile-classic">
                @else
                    <div class="profile-classic-placeholder" style="background: {{ $salon->avatar_color }};">
                        {{ $salon->initials }}
                    </div>
                @endif
                <h1 class="elegant-title">{{ $salon->salon_name }}</h1>
                @if($ratingCount > 0)
                    <div class="rating-display" style="display: flex; align-items: center; justify-content: center; gap: 15px; margin: 20px 0;">
                        <div style="display: flex; align-items: center; gap: 8px;">
                            <div style="display: flex; gap: 3px;">
                                @for($i = 1; $i <= 5; $i++)
                                    <i class="bi bi-star-fill" style="font-size: 24px; color: {{ $i <= round($averageRating) ? '#fbbf24' : '#e5e7eb' }};"></i>
                                @endfor
                            </div>
                            <span style="font-size: 20px; font-weight: 700; color: rgba(255, 255, 255, 0.95);">{{ number_format($averageRating, 1) }}</span>
                        </div>
                        <span style="font-size: 16px; color: rgba(255, 255, 255, 0.85);">({{ $ratingCount }} değerlendirme)</span>
                    </div>
                @else
                    <p class="lead" style="color: rgba(255,255,255,0.9); margin-bottom: 20px;">Henüz değerlendirme yapılmamış</p>
                @endif
                <div class="contact-info" style="display: flex; justify-content: center; align-items: center; max-width: 700px; margin: 30px auto; flex-wrap: wrap; gap: 15px;">
                    <a href="tel:{{ $salon->salon_phone ? preg_replace('/[^0-9+]/', '', $salon->salon_phone) : '' }}" class="contact-item" style="background: rgba(255, 255, 255, 0.2); backdrop-filter: blur(10px); border-radius: 16px; padding: 15px 25px; display: flex; align-items: center; gap: 12px; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1); flex: 0 1 auto; min-width: 200px; text-decoration: none; cursor: pointer; transition: all 0.3s ease;" onmouseover="this.style.background='rgba(255, 255, 255, 0.3)'; this.style.transform='translateY(-2px)'; this.style.boxShadow='0 6px 20px rgba(0, 0, 0, 0.15)';" onmouseout="this.style.background='rgba(255, 255, 255, 0.2)'; this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(0, 0, 0, 0.1)';">
                        <i class="bi bi-telephone" style="font-size: 1.3rem; color: rgba(255, 255, 255, 0.95);"></i>
                        <span style="color: rgba(255, 255, 255, 0.95); font-weight: 500;">{{ $salon->salon_phone ?: 'Telefon bilgisi yok' }}</span>
                    </a>
                    <div class="contact-item" style="background: rgba(255, 255, 255, 0.2); backdrop-filter: blur(10px); border-radius: 16px; padding: 15px 25px; display: flex; align-items: center; gap: 12px; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1); flex: 0 1 auto; min-width: 200px;">
                        <i class="bi bi-geo-alt" style="font-size: 1.3rem; color: rgba(255, 255, 255, 0.95);"></i>
                        <span style="color: rgba(255, 255, 255, 0.95); font-weight: 500;">{{ $salon->salon_address }}</span>
                    </div>
                </div>
                <div class="text-center mt-4">
                    <button type="button" class="btn btn-elegant" data-bs-toggle="modal" data-bs-target="#appointmentModal" onclick="if (typeof openAppointmentModal === 'function') { openAppointmentModal(); return false; }">
                        <i class="bi bi-calendar-check me-2"></i>Randevu Oluştur
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Services & Personel Section with Tabs -->
    <div class="classic-section">
        <div class="container">
            <div class="tab-container" id="salon-tabs">
                @php
                    $allowedPublicTabs = ['services', 'gallery', 'personels', 'ratings'];
                    $activePublicTab = request()->query('tab', 'services');
                    if (!in_array($activePublicTab, $allowedPublicTabs, true)) {
                        $activePublicTab = 'services';
                    }
                @endphp
                <div class="tab-nav salon-tab-nav" role="tablist" aria-label="Salon bilgi sekmeleri">
                    <a class="salon-tab-btn {{ $activePublicTab === 'services' ? 'is-active' : '' }}" data-tab-key="services" href="{{ request()->fullUrlWithQuery(['tab' => 'services']) }}" role="tab" aria-controls="servicesTab" aria-selected="{{ $activePublicTab === 'services' ? 'true' : 'false' }}">
                        <i class="bi bi-scissors me-2"></i>Hizmetlerimiz
                    </a>
                    <a class="salon-tab-btn {{ $activePublicTab === 'gallery' ? 'is-active' : '' }}" data-tab-key="gallery" href="{{ request()->fullUrlWithQuery(['tab' => 'gallery']) }}" role="tab" aria-controls="galleryTab" aria-selected="{{ $activePublicTab === 'gallery' ? 'true' : 'false' }}">
                        <i class="bi bi-images me-2"></i>Galeri
                    </a>
                    <a class="salon-tab-btn {{ $activePublicTab === 'personels' ? 'is-active' : '' }}" data-tab-key="personels" href="{{ request()->fullUrlWithQuery(['tab' => 'personels']) }}" role="tab" aria-controls="personelsTab" aria-selected="{{ $activePublicTab === 'personels' ? 'true' : 'false' }}">
                        <i class="bi bi-people me-2"></i>Personellerimiz
                    </a>
                    <a class="salon-tab-btn {{ $activePublicTab === 'ratings' ? 'is-active' : '' }}" data-tab-key="ratings" href="{{ request()->fullUrlWithQuery(['tab' => 'ratings']) }}" role="tab" aria-controls="ratingsTab" aria-selected="{{ $activePublicTab === 'ratings' ? 'true' : 'false' }}">
                        <i class="bi bi-star me-2"></i>Yorumlar
                    </a>
                </div>
                <style>
                    .salon-tab-nav {
                        display: flex;
                        gap: 12px;
                        flex-wrap: wrap;
                        position: relative;
                        z-index: 50;
                        pointer-events: auto;
                    }
                    .salon-tab-btn {
                        display: inline-flex;
                        align-items: center;
                        border: 1px solid #e5e7eb;
                        background: #fff;
                        color: #111827;
                        border-radius: 10px;
                        padding: 12px 16px;
                        font-weight: 600;
                        text-decoration: none;
                        transition: all 0.2s ease;
                    }
                    .salon-tab-btn:hover {
                        border-color: #d1d5db;
                        transform: translateY(-1px);
                    }
                    .salon-tab-btn.is-active {
                        border-color: #ec4899;
                        color: #111827;
                        background: #fdf2f8;
                    }
                    .salon-tab-pane {
                        display: none;
                        margin-top: 24px;
                    }
                    .salon-tab-pane.is-active {
                        display: block;
                    }
                </style>
                <script>
                    (function () {
                        const container = document.getElementById('salon-tabs');
                        if (!container || container.dataset.clientTabsReady === '1') return;
                        container.dataset.clientTabsReady = '1';

                        const tabMap = {
                            services: 'servicesTab',
                            gallery: 'galleryTab',
                            personels: 'personelsTab',
                            ratings: 'ratingsTab'
                        };

                        function activate(tabKey, shouldUpdateUrl) {
                            const targetId = tabMap[tabKey];
                            if (!targetId) return;

                            container.querySelectorAll('.salon-tab-btn[data-tab-key]').forEach((link) => {
                                const isActive = link.getAttribute('data-tab-key') === tabKey;
                                link.classList.toggle('is-active', isActive);
                                link.setAttribute('aria-selected', isActive ? 'true' : 'false');
                            });
                            container.querySelectorAll('.salon-tab-pane').forEach((pane) => {
                                pane.classList.toggle('is-active', pane.id === targetId);
                            });

                            if (shouldUpdateUrl && window.history && typeof window.history.replaceState === 'function') {
                                const url = new URL(window.location.href);
                                url.searchParams.set('tab', tabKey);
                                window.history.replaceState({}, '', `${url.pathname}?${url.searchParams.toString()}`);
                            }
                        }

                        container.addEventListener('click', function (event) {
                            const link = event.target.closest('.salon-tab-btn[data-tab-key]');
                            if (!link || !container.contains(link)) return;
                            event.preventDefault();
                            const tabKey = link.getAttribute('data-tab-key');
                            if (tabKey) activate(tabKey, true);
                        });
                    })();
                </script>

                <!-- Services Tab -->
                <div id="servicesTab" class="salon-tab-pane {{ $activePublicTab === 'services' ? 'is-active' : '' }}" role="tabpanel">
                    <!-- Category Tabs -->
                    @if($serviceCategories && $serviceCategories->count() > 0)
                        <div class="category-tabs mb-4" style="border-bottom: 2px solid #e5e7eb; padding-bottom: 15px;">
                            <div class="d-flex flex-wrap gap-2" style="overflow-x: auto; -webkit-overflow-scrolling: touch;">
                                <button class="category-tab-btn active" onclick="switchServiceCategory('all')" data-category="all" style="padding: 8px 16px; border: none; background: #f3f4f6; border-radius: 8px; cursor: pointer; white-space: nowrap; transition: all 0.3s;">
                                    <i class="bi bi-grid me-1"></i>Tüm Hizmetler
                                </button>
                                @foreach($serviceCategories as $category)
                                    <button class="category-tab-btn" onclick="switchServiceCategory({{ $category->id }})" data-category="{{ $category->id }}" style="padding: 8px 16px; border: none; background: #f3f4f6; border-radius: 8px; cursor: pointer; white-space: nowrap; transition: all 0.3s; {{ $category->color ? 'border-left: 3px solid ' . $category->color . ';' : '' }}">
                                        {{ $category->name }}
                                        <span class="badge bg-secondary ms-1" style="font-size: 0.75rem;">{{ $category->services_count }}</span>
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- All Services Content -->
                    <div id="serviceCategoryContent-all" class="service-category-content">
                        <div class="row">
                            @forelse($services as $service)
                                <div class="col-md-4 mb-4 service-item" data-service-id="{{ $service->id }}" data-category-id="{{ $service->service_category_id ?? 'none' }}">
                                    <div class="elegant-card">
                                        <h5>{{ $service->name }}</h5>
                                        @if($service->description)
                                            <p class="card-text">{{ \Illuminate\Support\Str::limit($service->description, 100) }}</p>
                                        @endif
                                        <div class="d-flex justify-content-between align-items-center mt-4">
                                            <div>
                                                <div class="price-elegant">{{ number_format($service->price, 2, ',', '.') }} ₺</div>
                                                @if($service->duration)
                                                    <div class="duration-elegant"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dakika</div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-12 text-center">
                                    <p class="text-muted">Henüz hizmet bulunmamaktadır.</p>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <!-- Category Services Content -->
                    @foreach($serviceCategories as $category)
                        <div id="serviceCategoryContent-{{ $category->id }}" class="service-category-content" style="display: none;">
                            <div class="row">
                                @php
                                    $categoryServices = $services->where('service_category_id', $category->id);
                                @endphp
                                @forelse($categoryServices as $service)
                                    <div class="col-md-4 mb-4 service-item" data-service-id="{{ $service->id }}" data-category-id="{{ $service->service_category_id ?? 'none' }}">
                                        <div class="elegant-card">
                                            <h5>{{ $service->name }}</h5>
                                            @if($service->description)
                                                <p class="card-text">{{ \Illuminate\Support\Str::limit($service->description, 100) }}</p>
                                            @endif
                                            <div class="d-flex justify-content-between align-items-center mt-4">
                                                <div>
                                                    <div class="price-elegant">{{ number_format($service->price, 2, ',', '.') }} ₺</div>
                                                    @if($service->duration)
                                                        <div class="duration-elegant"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dakika</div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <div class="col-12 text-center">
                                        <p class="text-muted">Bu kategoride henüz hizmet bulunmamaktadır.</p>
                                    </div>
                                @endforelse
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Gallery Tab -->
                <div id="galleryTab" class="salon-tab-pane {{ $activePublicTab === 'gallery' ? 'is-active' : '' }}" role="tabpanel">
                    @if($salon->salon_gallery && is_array($salon->salon_gallery) && count($salon->salon_gallery) > 0)
                        <div class="gallery-grid-public">
                            @foreach($salon->salon_gallery as $imagePath)
                                <div class="gallery-item-public">
                                    <img src="{{ \Illuminate\Support\Facades\Storage::url($imagePath) }}" alt="{{ $salon->salon_name }} Galeri" class="gallery-image-public" onclick="openGalleryModal('{{ \Illuminate\Support\Facades\Storage::url($imagePath) }}')">
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="col-12 text-center py-5">
                            <i class="bi bi-images" style="font-size: 64px; color: #cbd5e1;"></i>
                            <p class="text-muted mt-3">Henüz galeri görseli bulunmamaktadır.</p>
                        </div>
                    @endif
                </div>

                <!-- Personels Tab -->
                <div id="personelsTab" class="salon-tab-pane {{ $activePublicTab === 'personels' ? 'is-active' : '' }}" role="tabpanel">
                    <div class="row">
                        @forelse($personels as $personel)
                            <div class="col-md-4 mb-4">
                                <div class="personel-elegant">
                                    <div class="personel-avatar-elegant" style="background: {{ $personel->avatar_color }};">
                                        {{ $personel->initials }}
                                    </div>
                                    <h5>{{ $personel->name }}</h5>
                                    @if($personel->services && $personel->services->count() > 0)
                                        <div class="mt-3">
                                            @foreach($personel->services as $service)
                                                <span class="service-badge-elegant">{{ $service->name }}</span>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <div class="col-12 text-center">
                                <p class="text-muted">Henüz personel bilgisi bulunmamaktadır.</p>
                            </div>
                        @endforelse
                    </div>
                </div>

                <!-- Ratings Tab -->
                <div id="ratingsTab" class="salon-tab-pane {{ $activePublicTab === 'ratings' ? 'is-active' : '' }}" role="tabpanel">
                    @if($ratings && $ratings->count() > 0)
                        <div class="row">
                            @foreach($ratings as $ratingItem)
                                <div class="col-12 mb-4">
                                    <div class="elegant-card" style="border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px;">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-start mb-3">
                                                <div>
                                                    <h6 class="mb-1 fw-bold">
                                                        @php
                                                            $customerName = $ratingItem->customer_name ?: 'Anonim';
                                                            if ($customerName !== 'Anonim' && strpos($customerName, ' ') !== false) {
                                                                $nameParts = explode(' ', $customerName, 2);
                                                                $firstName = $nameParts[0];
                                                                $lastName = $nameParts[1] ?? '';
                                                                if ($lastName) {
                                                                    $lastNameInitial = mb_substr($lastName, 0, 1);
                                                                    $maskedLastName = $lastNameInitial . '****';
                                                                    $customerName = $firstName . ' ' . $maskedLastName;
                                                                }
                                                            }
                                                        @endphp
                                                        {{ $customerName }}
                                                    </h6>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="d-flex gap-1">
                                                            @for($i = 1; $i <= 5; $i++)
                                                                <i class="bi bi-star-fill" style="font-size: 14px; color: {{ $i <= $ratingItem->rating ? '#fbbf24' : '#e5e7eb' }};"></i>
                                                            @endfor
                                                        </div>
                                                        <span class="text-muted small">{{ $ratingItem->created_at->format('d.m.Y') }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            @if($ratingItem->comment)
                                                <p class="mb-0" style="color: #374151; line-height: 1.6;">{{ $ratingItem->comment }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-star" style="font-size: 48px; color: #d1d5db;"></i>
                            <p class="text-muted mt-3">Henüz yorum yapılmamış.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Gallery Modal -->
    <div class="modal fade" id="galleryModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content" style="background: transparent; border: none;">
                <button type="button" class="btn-close btn-close-white position-absolute top-0 end-0 m-3" style="z-index: 1051; background: rgba(0,0,0,0.5); border-radius: 50%; padding: 10px;" data-bs-dismiss="modal" aria-label="Close"></button>
                <img id="galleryModalImage" src="" alt="Galeri Görseli" style="width: 100%; border-radius: 12px;">
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        <div class="container">
            <p class="mb-0">&copy; {{ date('Y') }} {{ $salon->salon_name }}. Tüm hakları saklıdır.</p>
        </div>
    </footer>

    <!-- Elegant Randevu Talep Modal -->
    <div class="modal fade" id="appointmentModal" tabindex="-1" aria-labelledby="appointmentModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="appointmentModalLabel">
                        <i class="bi bi-calendar-check me-2"></i>Randevu Oluştur
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Step 1: Telefon Numarası -->
                    <div id="step1" class="appointment-step">
                        <h6><i class="bi bi-phone me-2"></i>1. Adım: Telefon Numarası</h6>
                        <form id="step1Form">
                            <div class="mb-4">
                                <label for="customerPhone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="tel" class="form-control" id="customerPhone" name="phone" placeholder="05XX XXX XX XX" required>
                                    <button type="button" class="btn btn-primary-modern" id="verifyPhoneBtn" onclick="checkPhone()">
                                        <i class="bi bi-check-circle me-1"></i>Kontrol Et
                                    </button>
                                </div>
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>Telefon numaranızı girerek devam edin.
                                </small>
                            </div>
                            <div id="customerInfo" style="display: none;" class="alert-modern">
                                <i class="bi bi-info-circle me-2"></i>
                                <span id="customerInfoText"></span>
                            </div>
                        </form>
                    </div>

                    <!-- Step 2: Kayıtsız Müşteri Bilgileri -->
                    <div id="step2" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-person me-2"></i>2. Adım: Bilgilerinizi Tamamlayın</h6>
                        <div id="newCustomerSection">
                            <div class="mb-4">
                                <label for="customerName" class="form-label">İsim <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="customerName" name="name" placeholder="Adınızı giriniz" required>
                            </div>
                            <div class="mb-4">
                                <label for="customerSurname" class="form-label">Soyisim <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="customerSurname" name="surname" placeholder="Soyadınızı giriniz" required>
                            </div>
                            <div class="mb-4">
                                <label for="customerAge" class="form-label">Yaş <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="customerAge" name="age" min="1" max="120" placeholder="Yaşınızı giriniz" required>
                            </div>
                            <div class="mb-4">
                                <label for="referralCode" class="form-label">
                                    <i class="bi bi-gift me-1"></i>Referans Kodu <small class="text-muted">(Opsiyonel)</small>
                                </label>
                                <input type="text" class="form-control" id="referralCode" name="referral_code" maxlength="6" placeholder="000000" pattern="[0-9]{6}">
                                <small class="text-muted d-block mt-1">
                                    <i class="bi bi-info-circle me-1"></i>Eğer bir arkadaşınızdan referans kodu aldıysanız buraya girin
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Step 3: OTP Doğrulama -->
                    <div id="step3" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-shield-check me-2"></i>3. Adım: Telefon Doğrulama</h6>
                        <div id="otpSection">
                            <div class="mb-4">
                                <label for="otpCode" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="otpCode" name="otp_code" maxlength="6" placeholder="000000" required>
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>Telefonunuza gönderilen 6 haneli kodu giriniz.
                                </small>
                            </div>
                            <div class="mb-3">
                                <button type="button" class="btn btn-outline-primary-modern" id="resendOTPBtn" onclick="resendOTP()">
                                    <i class="bi bi-arrow-clockwise me-1"></i>Kodu Tekrar Gönder
                                </button>
                                <small class="text-muted d-block mt-2" id="resendCountdown" style="display: none;">
                                    <i class="bi bi-clock me-1"></i><span id="countdownText">60</span> saniye sonra tekrar gönderebilirsiniz.
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Step 4: Hizmet Seçimi -->
                    <div id="step4" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-list-check me-2"></i>4. Adım: Hizmet Seçimi</h6>
                        
                        <div class="alert alert-info mb-4">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgilendirme:</strong> Randevu almak istediğiniz hizmet(ler)i seçiniz. Birden fazla hizmet seçebilirsiniz.
                        </div>
                        
                        <!-- Kategori Sekmeleri -->
                        @if($serviceCategories && $serviceCategories->count() > 0)
                            <div class="mb-4" style="border-bottom: 2px solid #e5e7eb; padding-bottom: 15px;">
                                <div class="d-flex flex-wrap gap-2" style="overflow-x: auto; -webkit-overflow-scrolling: touch;">
                                    <button class="step-category-tab-btn active" onclick="switchStepServiceCategory('all')" data-step-category="all" style="padding: 8px 16px; border: none; background: #f3f4f6; border-radius: 8px; cursor: pointer; white-space: nowrap; transition: all 0.3s; color: #000000 !important;">
                                        <i class="bi bi-grid me-1"></i>Tüm Hizmetler
                                    </button>
                                    @foreach($serviceCategories as $category)
                                        <button class="step-category-tab-btn" onclick="switchStepServiceCategory({{ $category->id }})" data-step-category="{{ $category->id }}" style="padding: 8px 16px; border: none; background: #f3f4f6; border-radius: 8px; cursor: pointer; white-space: nowrap; transition: all 0.3s; color: #000000 !important; {{ $category->color ? 'border-left: 3px solid ' . $category->color . ';' : '' }}">
                                            {{ $category->name }}
                                            <span class="badge bg-secondary ms-1" style="font-size: 0.75rem;">{{ $category->services_count }}</span>
                                        </button>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        
                        <!-- Hizmet Seçimi -->
                        <div class="mb-3">
                            <label class="form-label">Hizmet Seçiniz <span class="text-danger">*</span> 
                                <span id="selectedServicesCount" class="badge bg-primary ms-2" style="display: none;">0 hizmet seçildi</span>
                            </label>
                            <p class="text-muted small mb-3">İstediğiniz hizmet(ler)i seçerek devam edebilirsiniz. Birden fazla hizmet seçmek için kartlara tıklayın.</p>
                            
                            <!-- Tüm Hizmetler -->
                            <div id="stepServicesContent-all" class="step-services-category-content">
                                <div class="row" id="servicesList">
                                    @foreach($services as $service)
                                        <div class="col-md-6 mb-3">
                                            <div class="service-option-card" data-service-id="{{ $service->id }}" onclick="selectService({{ $service->id }})">
                                                <div class="card-body" style="position: relative; z-index: 1;">
                                                    <div class="d-flex align-items-start">
                                                        <div class="service-checkbox-wrapper" style="margin-right: 12px; margin-top: 2px;">
                                                            <div class="service-checkbox" data-service-id="{{ $service->id }}">
                                                                <i class="bi bi-check"></i>
                                                            </div>
                                                        </div>
                                                        <div style="flex: 1;">
                                                            <h6 class="mb-2" style="font-weight: 600;">{{ $service->name }}</h6>
                                                            @if($service->description)
                                                                <p class="text-muted small mb-3">{{ \Illuminate\Support\Str::limit($service->description, 80) }}</p>
                                                            @endif
                                                            <div class="d-flex justify-content-between align-items-center">
                                                                <div>
                                                                    <strong class="price-elegant" style="font-size: 1.2rem;">{{ number_format($service->price, 2, ',', '.') }} ₺</strong>
                                                                    @if($service->duration)
                                                                        <div class="duration-elegant"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dk</div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <!-- Kategori Hizmetleri -->
                            @foreach($serviceCategories as $category)
                                @php
                                    $categoryServices = $services->where('service_category_id', $category->id);
                                @endphp
                                <div id="stepServicesContent-{{ $category->id }}" class="step-services-category-content" style="display: none;">
                                    <div class="row">
                                        @forelse($categoryServices as $service)
                                            <div class="col-md-6 mb-3">
                                                <div class="service-option-card" data-service-id="{{ $service->id }}" onclick="selectService({{ $service->id }})">
                                                    <div class="card-body" style="position: relative; z-index: 1;">
                                                        <div class="d-flex align-items-start">
                                                            <div class="service-checkbox-wrapper" style="margin-right: 12px; margin-top: 2px;">
                                                                <div class="service-checkbox" data-service-id="{{ $service->id }}" style="width: 24px; height: 24px; border: 2px solid #e5e7eb; border-radius: 6px; background: white; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.3s;">
                                                                    <i class="bi bi-check" style="color: white; font-size: 14px; font-weight: bold; display: none;"></i>
                                                                </div>
                                                            </div>
                                                            <div style="flex: 1;">
                                                                <h6 class="mb-2" style="font-weight: 600;">{{ $service->name }}</h6>
                                                                @if($service->description)
                                                                    <p class="text-muted small mb-3">{{ \Illuminate\Support\Str::limit($service->description, 80) }}</p>
                                                                @endif
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div>
                                                                        <strong class="price-elegant" style="font-size: 1.2rem;">{{ number_format($service->price, 2, ',', '.') }} ₺</strong>
                                                                        @if($service->duration)
                                                                            <div class="duration-elegant"><i class="bi bi-clock me-1"></i>{{ $service->duration }} dk</div>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @empty
                                            <div class="col-12 text-center">
                                                <p class="text-muted">Bu kategoride henüz hizmet bulunmamaktadır.</p>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <input type="hidden" id="selectedServiceId" name="service_id">
                        <input type="hidden" id="selectedServiceIds" name="service_ids">
                        
                        <!-- Referans Kodu (OTP doğrulama sonrası değiştirilebilir) -->
                        <div class="mb-4" id="referralCodeStep4Container" style="display: none; background: #f0f9ff; padding: 15px; border-radius: 8px; border: 2px solid #ec4899; margin-top: 20px;">
                            <label for="referralCodeStep4" class="form-label">
                                <i class="bi bi-gift me-1"></i>Referans Kodu <small class="text-muted">(Opsiyonel - Değiştirebilirsiniz)</small>
                            </label>
                            <input type="text" class="form-control" id="referralCodeStep4" name="referral_code_step4" maxlength="6" placeholder="000000" pattern="[0-9]{6}">
                            <small class="text-muted d-block mt-1">
                                <i class="bi bi-info-circle me-1"></i>Eğer bir arkadaşınızdan referans kodu aldıysanız buraya girin. Daha önce girilen kod varsa değiştirebilirsiniz.
                            </small>
                        </div>
                    </div>

                    <!-- Step 5: Tarih Seçimi -->
                    <div id="step5" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-calendar3 me-2"></i>5. Adım: Tarih Seçimi</h6>
                        
                        <div class="alert alert-info mb-4" id="step5Info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgilendirme:</strong> Lütfen randevu için uygun tarihi seçiniz.
                        </div>

                        <!-- Tarih Seçimi -->
                        <div class="mb-4">
                            <label class="form-label">Tarih Seçiniz <span class="text-danger">*</span></label>
                            <div class="row" id="dateList">
                                <!-- 2 haftalık tarih listesi JavaScript ile doldurulacak -->
                            </div>
                        </div>

                        <input type="hidden" id="selectedDate" name="appointment_date">
                    </div>

                    <!-- Step 6: Saat Seçimi -->
                    <div id="step6" class="appointment-step" style="display: none;">
                        <h6><i class="bi bi-clock me-2"></i>6. Adım: Saat Seçimi</h6>
                        
                        <div class="alert alert-info mb-4" id="step6Info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgilendirme:</strong> Lütfen randevu için uygun saati seçiniz.
                        </div>

                        <!-- Saat Seçimi -->
                        <div class="mb-4" id="timeSelectionContainer">
                            <label class="form-label">Saat Seçiniz <span class="text-danger">*</span></label>
                            <div class="alert alert-warning mb-3" style="font-size: 0.875rem;">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <strong>Not:</strong> Dolu saatler seçilemez. Tüm personellerin müsait olduğu saatleri seçebilirsiniz.
                            </div>
                            <div class="row" id="timeList">
                                <!-- Saatler JavaScript ile doldurulacak -->
                            </div>
                        </div>

                        <input type="hidden" id="selectedTime" name="appointment_time">
                        
                        <!-- Tekrarlanan Seans Seçeneği -->
                        <div class="mb-4 mt-4" style="border-top: 2px solid #e5e7eb; padding-top: 20px;">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="enableRecurring" onchange="toggleRecurringOptions()" style="width: 20px; height: 20px; cursor: pointer;">
                                <label class="form-check-label" for="enableRecurring" style="font-weight: 600; font-size: 1rem; cursor: pointer; margin-left: 8px;">
                                    <i class="bi bi-calendar-repeat me-2"></i>Bu randevuyu tekrarlamak istiyorum
                                </label>
                            </div>
                            
                            <div id="recurringOptions" style="display: none; background: #f9fafb; padding: 20px; border-radius: 12px; margin-top: 15px;">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Tekrarlama Tipi <span class="text-danger">*</span></label>
                                        <select class="form-select" id="recurring_type" name="recurring_type" onchange="toggleRecurringDayOptions()" style="border-radius: 8px; padding: 10px;">
                                            <option value="">Seçiniz</option>
                                            <option value="weekly">Haftalık</option>
                                            <option value="monthly">Aylık</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3" id="day_of_week_container" style="display: none;">
                                        <label class="form-label">Haftanın Günü <span class="text-danger">*</span></label>
                                        <select class="form-select" id="day_of_week" name="day_of_week" style="border-radius: 8px; padding: 10px;">
                                            <option value="">Seçiniz</option>
                                            <option value="1">Pazartesi</option>
                                            <option value="2">Salı</option>
                                            <option value="3">Çarşamba</option>
                                            <option value="4">Perşembe</option>
                                            <option value="5">Cuma</option>
                                            <option value="6">Cumartesi</option>
                                            <option value="7">Pazar</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3" id="day_of_month_container" style="display: none;">
                                        <label class="form-label">Ayın Günü <span class="text-danger">*</span></label>
                                        <select class="form-select" id="day_of_month" name="day_of_month" style="border-radius: 8px; padding: 10px;">
                                            <option value="">Seçiniz</option>
                                            @for($i = 1; $i <= 31; $i++)
                                                <option value="{{ $i }}">{{ $i }}</option>
                                            @endfor
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Kaç Kez Tekrarlansın? <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" id="recurring_count" name="recurring_count" min="1" max="24" value="1" style="border-radius: 8px; padding: 10px;" placeholder="1-24 arası">
                                        <small class="text-muted">Maksimum 24 kez tekrarlanabilir</small>
                                    </div>
                                </div>
                                
                                <div class="alert alert-info mt-3 mb-0" style="font-size: 0.875rem;">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <strong>Bilgi:</strong> Tekrarlanan randevular otomatik olarak oluşturulacak ve size WhatsApp ile hatırlatma mesajı gönderilecektir.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-outline-primary-modern" id="prevStepBtn" onclick="prevStep()" style="display: none;">
                        <i class="bi bi-arrow-left me-1"></i>Geri
                    </button>
                    <button type="button" class="btn btn-primary-modern" id="nextStepBtn" onclick="nextStep()" style="display: none;">
                        İleri<i class="bi bi-arrow-right ms-1"></i>
                    </button>
                    <button type="button" class="btn btn-primary-modern" id="submitBtn" style="display: none;">
                        <i class="bi bi-check-circle me-1"></i>Gönder
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Güvenli fallback: Ana script yüklenemese bile "Randevu Oluştur" modalı açılabilsin.
        if (typeof window.openAppointmentModal !== 'function') {
            window.openAppointmentModal = function() {
                const modalElement = document.getElementById('appointmentModal');
                if (modalElement && window.bootstrap && window.bootstrap.Modal) {
                    new bootstrap.Modal(modalElement).show();
                }
            };
        }
    </script>
    <script>
        // Tab Switching Function
        // Service Category Switching Function
        function switchServiceCategory(categoryId) {
            // Remove active class from all category tabs
            document.querySelectorAll('.category-tab-btn').forEach(btn => {
                btn.classList.remove('active');
                btn.style.background = '#f3f4f6';
                btn.style.color = '#374151';
            });

            // Hide all category contents
            document.querySelectorAll('.service-category-content').forEach(content => {
                content.style.display = 'none';
            });

            // Add active class to selected category tab
            const selectedBtn = document.querySelector(`.category-tab-btn[data-category="${categoryId}"]`);
            if (selectedBtn) {
                selectedBtn.classList.add('active');
                selectedBtn.style.background = '#fce7f3';
                selectedBtn.style.color = '#111827';
                selectedBtn.style.border = '1px solid #ec4899';
            }

            // Show selected category content
            const selectedContent = document.getElementById(`serviceCategoryContent-${categoryId}`);
            if (selectedContent) {
                selectedContent.style.display = 'block';
            }
        }

        function switchTab(tabName) {
            document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
                content.style.display = 'none';
            });
            const targetBtn = Array.from(document.querySelectorAll('.tab-btn')).find(btn => {
                const fromData = btn.getAttribute('data-tab');
                const fromOnclick = btn.getAttribute('onclick') || '';
                return fromData === tabName || fromOnclick.includes(`switchTab('${tabName}')`);
            });
            if (targetBtn) {
                targetBtn.classList.add('active');
            }

            const tabIdMap = {
                services: 'servicesTab',
                gallery: 'galleryTab',
                personels: 'personelsTab',
                ratings: 'ratingsTab'
            };
            const targetContent = document.getElementById(tabIdMap[tabName] || `${tabName}Tab`);
            if (targetContent) {
                targetContent.classList.add('active');
                targetContent.style.display = 'block';
            }
        }

        let currentStep = 1;
        let selectedServiceId = null;
        let selectedServiceIds = [];
        let isRegisteredCustomer = false;
        let customerId = null;
        let customerName = '';
        let salonId = {{ $salon->id }};
        let resendOTPCooldown = 0;
        let resendOTPTimer = null;

        function openAppointmentModal(serviceId = null) {
            try {
                selectedServiceId = serviceId;
                selectedServiceIds = serviceId ? [serviceId] : [];
                currentStep = 1;
                isRegisteredCustomer = false;
                customerId = null;
                customerName = '';
                
                const step1Form = document.getElementById('step1Form');
                if (step1Form) step1Form.reset();
                
                const step2 = document.getElementById('step2');
                const step3 = document.getElementById('step3');
                const step4 = document.getElementById('step4');
                const step5 = document.getElementById('step5');
                const step6 = document.getElementById('step6');
                const step1 = document.getElementById('step1');
                const customerInfo = document.getElementById('customerInfo');
                const prevStepBtn = document.getElementById('prevStepBtn');
                const nextStepBtn = document.getElementById('nextStepBtn');
                const submitBtn = document.getElementById('submitBtn');
                
                if (step2) step2.style.display = 'none';
                if (step3) step3.style.display = 'none';
                if (step4) step4.style.display = 'none';
                if (step5) step5.style.display = 'none';
                if (step6) step6.style.display = 'none';
                if (step1) step1.style.display = 'block';
                if (customerInfo) customerInfo.style.display = 'none';
                if (prevStepBtn) prevStepBtn.style.display = 'none';
                if (nextStepBtn) nextStepBtn.style.display = 'none';
                if (submitBtn) submitBtn.style.display = 'none';

                // Tarih/saat ve hizmet seçimlerini sıfırla
                if (document.getElementById('selectedDate')) document.getElementById('selectedDate').value = '';
                if (document.getElementById('selectedTime')) document.getElementById('selectedTime').value = '';
                const selectedServiceIdInput = document.getElementById('selectedServiceId');
                const selectedServiceIdsInput = document.getElementById('selectedServiceIds');
                if (selectedServiceIdInput) selectedServiceIdInput.value = serviceId || '';
                if (selectedServiceIdsInput) selectedServiceIdsInput.value = JSON.stringify(selectedServiceIds);
                document.querySelectorAll('.service-option-card').forEach(card => {
                    card.classList.remove('border-primary');
                    const checkbox = card.querySelector('.service-checkbox');
                    const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                    if (checkbox) {
                        checkbox.style.background = 'white';
                        checkbox.style.borderColor = '#e5e7eb';
                        checkbox.style.setProperty('background', 'white', 'important');
                        checkbox.style.setProperty('border-color', '#e5e7eb', 'important');
                    }
                    if (checkboxIcon) {
                        checkboxIcon.style.display = 'none';
                    }
                });
                updateSelectedServicesCount();
                
                // Eğer hizmet seçildiyse direkt 4. etaba geç
                if (serviceId) {
                    if (selectedServiceIdInput) {
                        selectedServiceIdInput.value = serviceId;
                    }
                    if (selectedServiceIdsInput) {
                        selectedServiceIdsInput.value = JSON.stringify([serviceId]);
                    }
                    // Hizmet seçimini göster
                    document.querySelectorAll('.service-option-card').forEach(card => {
                        const cardServiceId = card.getAttribute('data-service-id');
                        if (cardServiceId == serviceId || cardServiceId == serviceId.toString()) {
                            card.classList.add('border-primary');
                            // Checkbox'ı pembe renge çevir
                            const checkbox = card.querySelector('.service-checkbox');
                            const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                            if (checkbox) {
                                checkbox.style.background = '#ec4899';
                                checkbox.style.borderColor = '#ec4899';
                                checkbox.style.setProperty('background', '#ec4899', 'important');
                                checkbox.style.setProperty('border-color', '#ec4899', 'important');
                            }
                            if (checkboxIcon) {
                                checkboxIcon.style.display = 'flex';
                                checkboxIcon.style.setProperty('display', 'flex', 'important');
                            }
                        }
                    });
                    updateSelectedServicesCount();
                }
                
                // Modal'ı aç
                const modalElement = document.getElementById('appointmentModal');
                if (modalElement) {
                    const modal = new bootstrap.Modal(modalElement);
                    modal.show();
                } else {
                    console.error('appointmentModal elementi bulunamadı');
                }
            } catch (error) {
                console.error('openAppointmentModal hatası:', error);
                alert('Randevu modalı açılırken bir hata oluştu. Lütfen sayfayı yenileyin.');
            }
        }

        function checkPhone() {
            const phoneInput = document.getElementById('customerPhone');
            const verifyBtn = document.getElementById('verifyPhoneBtn');
            if (!phoneInput || !verifyBtn) {
                alert('Telefon doğrulama alanları bulunamadı. Lütfen sayfayı yenileyin.');
                return;
            }
            const phone = phoneInput.value.trim();
            
            if (!phone) {
                alert('Lütfen telefon numarasını giriniz.');
                return;
            }
            const originalText = verifyBtn.innerHTML;
            verifyBtn.disabled = true;
            verifyBtn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Kontrol Ediliyor...';

            fetch('{{ route("public.appointment-request.send-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    salon_id: salonId,
                    phone: phone
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Sunucu hatası: ' + response.status);
                    });
                }
                return response.json();
            })
            .then(data => {
                verifyBtn.disabled = false;
                verifyBtn.innerHTML = originalText;
                
                if (data.success) {
                    if (data.is_registered) {
                        // Kayıtlı müşteri - Bilgileri otomatik doldur ve OTP adımına geç
                        isRegisteredCustomer = true;
                        customerId = data.customer_id;
                        customerName = data.customer_name || '';
                        
                        // Müşteri bilgilerini otomatik doldur
                        if (data.customer_name) {
                            document.getElementById('customerName').value = data.customer_name;
                        }
                        if (data.customer_surname) {
                            document.getElementById('customerSurname').value = data.customer_surname;
                        }
                        if (data.customer_age) {
                            document.getElementById('customerAge').value = data.customer_age;
                        }
                        
                        document.getElementById('customerInfo').style.display = 'block';
                        document.getElementById('customerInfoText').textContent = 'Kayıtlı müşterisiniz. Bilgileriniz otomatik dolduruldu. Doğrulama kodu gönderildi.';
                        // Step2'yi atla, direkt OTP adımına geç
                        document.getElementById('step1').style.display = 'none';
                        document.getElementById('step2').style.display = 'none';
                        document.getElementById('step3').style.display = 'block';
                        document.getElementById('prevStepBtn').style.display = 'inline-block';
                        document.getElementById('nextStepBtn').style.display = 'inline-block';
                        currentStep = 3;
                        startResendCooldown(60);
                    } else {
                        // Kayıtsız müşteri - bilgi girişi adımına geç
                        isRegisteredCustomer = false;
                        customerId = null;
                        // Form alanlarını temizle
                        document.getElementById('customerName').value = '';
                        document.getElementById('customerSurname').value = '';
                        document.getElementById('customerAge').value = '';
                        document.getElementById('customerInfo').style.display = 'block';
                        document.getElementById('customerInfoText').textContent = 'Yeni müşterisiniz. Lütfen bilgilerinizi tamamlayın.';
                        document.getElementById('step1').style.display = 'none';
                        document.getElementById('step2').style.display = 'block';
                        document.getElementById('prevStepBtn').style.display = 'inline-block';
                        document.getElementById('nextStepBtn').style.display = 'inline-block';
                        currentStep = 2;
                    }
                } else {
                    alert(data.message || 'Telefon kontrolü sırasında bir hata oluştu.');
                }
            })
            .catch(error => {
                verifyBtn.disabled = false;
                verifyBtn.innerHTML = originalText;
                console.error('Error:', error);
                alert(error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.');
            });
        }

        function resendOTP() {
            if (resendOTPCooldown > 0) {
                return;
            }

            const phone = document.getElementById('customerPhone').value;
            let name = '';
            
            if (isRegisteredCustomer) {
                name = customerName || '';
            } else {
                name = document.getElementById('customerName').value;
            }

            const resendBtn = document.getElementById('resendOTPBtn');
            const originalText = resendBtn.innerHTML;
            resendBtn.disabled = true;
            resendBtn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Gönderiliyor...';

            fetch('{{ route("public.appointment-request.send-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    salon_id: salonId,
                    phone: phone,
                    name: name
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Sunucu hatası: ' + response.status);
                    });
                }
                return response.json();
            })
            .then(data => {
                resendBtn.disabled = false;
                resendBtn.innerHTML = originalText;
                
                if (data.success) {
                    alert('Doğrulama kodu tekrar gönderildi.');
                    startResendCooldown(60);
                } else {
                    alert(data.message || 'OTP gönderilirken bir hata oluştu.');
                }
            })
            .catch(error => {
                resendBtn.disabled = false;
                resendBtn.innerHTML = originalText;
                console.error('Error:', error);
                alert(error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.');
            });
        }

        function startResendCooldown(seconds) {
            resendOTPCooldown = seconds;
            const resendBtn = document.getElementById('resendOTPBtn');
            const countdownEl = document.getElementById('resendCountdown');
            const countdownText = document.getElementById('countdownText');
            
            resendBtn.disabled = true;
            countdownEl.style.display = 'block';
            
            if (resendOTPTimer) {
                clearInterval(resendOTPTimer);
            }
            
            resendOTPTimer = setInterval(() => {
                resendOTPCooldown--;
                countdownText.textContent = resendOTPCooldown;
                
                if (resendOTPCooldown <= 0) {
                    clearInterval(resendOTPTimer);
                    resendOTPTimer = null;
                    resendBtn.disabled = false;
                    countdownEl.style.display = 'none';
                }
            }, 1000);
        }

        function nextStep() {
            if (currentStep === 2) {
                if (!document.getElementById('customerName').value || !document.getElementById('customerSurname').value || !document.getElementById('customerAge').value) {
                    alert('Lütfen tüm bilgilerinizi giriniz.');
                    return;
                }
                document.getElementById('step2').style.display = 'none';
                document.getElementById('step3').style.display = 'block';
                document.getElementById('prevStepBtn').style.display = 'inline-block';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                currentStep = 3;
                startResendCooldown(60);
            } else if (currentStep === 3) {
                const otpCode = document.getElementById('otpCode').value;
                if (!otpCode || otpCode.length !== 6) {
                    alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
                    return;
                }
                
                verifyOTP(otpCode).then(verified => {
                    if (verified) {
                        goToStep4();
                    } else {
                        alert('Doğrulama kodu hatalı. Lütfen tekrar deneyin.');
                    }
                });
            } else if (currentStep === 4) {
                // Hizmet seçimi kontrolü (çoklu hizmet)
                const serviceIdsInput = document.getElementById('selectedServiceIds');
                let serviceIdsArray = [];
                
                if (serviceIdsInput && serviceIdsInput.value) {
                    try {
                        serviceIdsArray = JSON.parse(serviceIdsInput.value);
                    } catch (e) {
                        // JSON parse edilemezse, tek hizmet ID'sini kullan
                        const singleServiceId = document.getElementById('selectedServiceId')?.value;
                        if (singleServiceId) {
                            serviceIdsArray = [singleServiceId];
                        }
                    }
                } else {
                    // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                    const singleServiceId = document.getElementById('selectedServiceId')?.value;
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
                
                if (serviceIdsArray.length === 0) {
                    alert('Lütfen en az bir hizmet seçiniz.');
                    return;
                }
                // Hizmet seçildiyse Step 5'e geç (Tarih seçimi)
                if (typeof goToStep5 === 'function') {
                    goToStep5();
                } else {
                    console.error('goToStep5 fonksiyonu bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                }
            } else if (currentStep === 5) {
                // Tarih seçimi kontrolü
                const selectedDate = document.getElementById('selectedDate').value;
                if (!selectedDate) {
                    alert('Lütfen bir tarih seçiniz.');
                    return;
                }
                // Tarih seçildiyse Step 6'ya geç (Saat seçimi)
                if (typeof goToStep6 === 'function') {
                    goToStep6();
                } else {
                    console.error('goToStep6 fonksiyonu bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                }
            }
        }

        function goToStep4() {
            document.getElementById('step3').style.display = 'none';
            document.getElementById('step4').style.display = 'block';
            document.getElementById('nextStepBtn').style.display = 'inline-block';
            document.getElementById('submitBtn').style.display = 'none';
            
            // Referans kodunu Step 4'te göster ve değiştirilebilir yap
            const referralCodeStep4Container = document.getElementById('referralCodeStep4Container');
            const referralCodeStep4Input = document.getElementById('referralCodeStep4');
            const referralCodeInput = document.getElementById('referralCode');
            
            if (referralCodeStep4Container && referralCodeStep4Input) {
                referralCodeStep4Container.style.display = 'block';
                
                // Eğer Step 2'de referans kodu girildiyse, Step 4'e kopyala
                if (referralCodeInput && referralCodeInput.value) {
                    referralCodeStep4Input.value = referralCodeInput.value;
                }
            }
            
            currentStep = 4;
        }

        function goToStep5() {
            try {
                // Çoklu hizmet kontrolü
                const serviceIdsInput = document.getElementById('selectedServiceIds');
                let serviceIdsArray = [];
                
                if (serviceIdsInput && serviceIdsInput.value) {
                    try {
                        serviceIdsArray = JSON.parse(serviceIdsInput.value);
                    } catch (e) {
                        // JSON parse edilemezse, tek hizmet ID'sini kullan
                        const singleServiceId = document.getElementById('selectedServiceId')?.value;
                        if (singleServiceId) {
                            serviceIdsArray = [singleServiceId];
                        }
                    }
                } else {
                    // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                    const singleServiceId = document.getElementById('selectedServiceId')?.value;
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
                
                if (serviceIdsArray.length === 0) {
                    alert('Lütfen en az bir hizmet seçiniz.');
                    return;
                }
                
                // İlk seçilen hizmeti ana hizmet olarak kaydet (geriye dönük uyumluluk için)
                const serviceId = serviceIdsArray[0];
                
                const step4 = document.getElementById('step4');
                const step5 = document.getElementById('step5');
                const step6 = document.getElementById('step6');
                const nextStepBtn = document.getElementById('nextStepBtn');
                const submitBtn = document.getElementById('submitBtn');
                
                if (!step4 || !step5) {
                    console.error('Step 4 veya Step 5 elementi bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                    return;
                }
                
                // Step 4'ü gizle, Step 5'i göster, Step 6'yı gizle
                step4.style.display = 'none';
                step5.style.display = 'block';
                if (step6) step6.style.display = 'none';
                
                // Butonları güncelle
                if (nextStepBtn) nextStepBtn.style.display = 'inline-block';
                if (submitBtn) submitBtn.style.display = 'none';
                
                // Current step'i güncelle
                currentStep = 5;
                
                // 2 haftalık tarih listesini yükle
                if (typeof loadDateList === 'function') {
                    loadDateList();
                } else {
                    console.error('loadDateList fonksiyonu bulunamadı!');
                }
            } catch (error) {
                console.error('goToStep5 hatası:', error);
                alert('Tarih seçimi açılırken bir hata oluştu. Lütfen sayfayı yenileyin.');
            }
        }

        function goToStep6() {
            try {
                const selectedDate = document.getElementById('selectedDate').value;
                if (!selectedDate) {
                    alert('Lütfen bir tarih seçiniz.');
                    return;
                }
                
                const step5 = document.getElementById('step5');
                const step6 = document.getElementById('step6');
                const nextStepBtn = document.getElementById('nextStepBtn');
                const submitBtn = document.getElementById('submitBtn');
                
                if (!step5 || !step6) {
                    console.error('Step 5 veya Step 6 elementi bulunamadı!');
                    alert('Bir hata oluştu. Lütfen sayfayı yenileyin.');
                    return;
                }
                
                // Step 5'i gizle, Step 6'yı göster
                step5.style.display = 'none';
                step6.style.display = 'block';
                
                // Butonları güncelle
                if (nextStepBtn) nextStepBtn.style.display = 'none';
                if (submitBtn) submitBtn.style.display = 'inline-block';
                
                // Current step'i güncelle
                currentStep = 6;
                
                // Seçilen tarih için saatleri yükle
                if (typeof loadTimeSlots === 'function') {
                    loadTimeSlots(selectedDate);
                } else {
                    console.error('loadTimeSlots fonksiyonu bulunamadı!');
                }
                
                // Seçilen tarih için saatleri yükle
                if (typeof loadTimeSlots === 'function') {
                    loadTimeSlots(selectedDate);
                } else {
                    console.error('loadTimeSlots fonksiyonu bulunamadı!');
                }
            } catch (error) {
                console.error('goToStep6 hatası:', error);
                alert('Saat seçimi açılırken bir hata oluştu. Lütfen sayfayı yenileyin.');
            }
        }

        function loadDateList() {
            const dateList = document.getElementById('dateList');
            if (!dateList) return;
            
            dateList.innerHTML = '<div class="col-12 text-center py-3"><div class="spinner-border spinner-border-sm text-primary" role="status"></div></div>';
            
            const today = new Date();
            const dates = [];
            
            // Bugünden başlayarak 14 gün (2 hafta) tarih oluştur
            for (let i = 0; i < 14; i++) {
                const date = new Date(today);
                date.setDate(today.getDate() + i);
                dates.push(date);
            }
            
            let html = '';
            dates.forEach((date, index) => {
                const dateStr = date.toISOString().split('T')[0];
                const dayName = date.toLocaleDateString('tr-TR', { weekday: 'long' });
                const dayNameShort = date.toLocaleDateString('tr-TR', { weekday: 'short' });
                const dayNumber = date.getDate();
                const monthName = date.toLocaleDateString('tr-TR', { month: 'long' });
                const monthNameShort = date.toLocaleDateString('tr-TR', { month: 'short' });
                const isToday = index === 0;
                
                html += `
                    <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-3">
                        <div class="date-option-card ${isToday ? 'today' : ''}" data-date="${dateStr}" onclick="selectDate('${dateStr}')" style="border: 2px solid #e5e7eb; border-radius: 16px; padding: 16px 12px; text-align: center; cursor: pointer; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); background: white; min-height: 100px; display: flex; flex-direction: column; justify-content: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);" onmouseover="if(!this.classList.contains('selected')) { this.style.borderColor='#ec4899'; this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 16px rgba(236, 72, 153, 0.15)'; }" onmouseout="if(!this.classList.contains('selected')) { this.style.borderColor='#e5e7eb'; this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 4px rgba(0,0,0,0.05)'; }">
                            <div style="font-size: 0.7rem; color: #6b7280; margin-bottom: 6px; font-weight: 500; text-transform: capitalize;">
                                <span class="d-none d-sm-inline">${dayName}</span>
                                <span class="d-sm-none">${dayNameShort}</span>
                            </div>
                            <div style="font-size: 1.75rem; font-weight: 700; color: #1f2937; margin-bottom: 4px; line-height: 1.2;">${dayNumber}</div>
                            <div style="font-size: 0.75rem; color: #6b7280; text-transform: capitalize;">
                                <span class="d-none d-sm-inline">${monthName}</span>
                                <span class="d-sm-none">${monthNameShort}</span>
                            </div>
                            ${isToday ? '<div style="font-size: 0.65rem; color: #ec4899; margin-top: 6px; font-weight: 600; padding: 2px 6px; background: #fce7f3; border-radius: 8px; display: inline-block;">Bugün</div>' : ''}
                        </div>
                    </div>
                `;
            });
            
            dateList.innerHTML = html;
        }

        function selectDate(dateStr) {
            document.getElementById('selectedDate').value = dateStr;
            
            // Seçili tarihi görsel olarak işaretle
            document.querySelectorAll('.date-option-card').forEach(card => {
                card.classList.remove('selected');
                card.style.borderColor = '#e5e7eb';
                card.style.background = 'white';
                card.style.boxShadow = '0 2px 4px rgba(0,0,0,0.05)';
                card.style.transform = 'translateY(0)';
            });
            
            const selectedCard = document.querySelector(`[data-date="${dateStr}"]`);
            if (selectedCard) {
                selectedCard.classList.add('selected');
                selectedCard.style.borderColor = '#ec4899';
                selectedCard.style.background = 'linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%)';
                selectedCard.style.boxShadow = '0 8px 20px rgba(236, 72, 153, 0.25)';
                selectedCard.style.transform = 'translateY(-2px)';
            }
            
            // Tarih seçildiğinde saatleri yükleme - Step 6'ya geçildiğinde yüklenecek
        }

        let servicePersonels = [];
        let serviceDuration = 30;

        function loadTimeSlots(dateStr) {
            // Çoklu hizmet seçimi kontrolü
            const serviceIdsInput = document.getElementById('selectedServiceIds');
            let serviceIdsArray = [];
            
            if (serviceIdsInput && serviceIdsInput.value) {
                try {
                    serviceIdsArray = JSON.parse(serviceIdsInput.value);
                } catch (e) {
                    // JSON parse edilemezse, tek hizmet ID'sini kullan
                    const singleServiceId = document.getElementById('selectedServiceId')?.value;
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
            } else {
                // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                const singleServiceId = document.getElementById('selectedServiceId')?.value;
                if (singleServiceId) {
                    serviceIdsArray = [singleServiceId];
                }
            }
            
            if (serviceIdsArray.length === 0) {
                alert('Lütfen önce en az bir hizmet seçiniz.');
                return;
            }
            
            const timeList = document.getElementById('timeList');
            const timeSelectionContainer = document.getElementById('timeSelectionContainer');
            
            if (!timeList || !timeSelectionContainer) return;
            
            timeSelectionContainer.style.display = 'block';
            timeList.innerHTML = '<div class="col-12 text-center py-3"><div class="spinner-border spinner-border-sm text-primary" role="status"></div></div>';
            
            // Çoklu hizmet için service_ids parametresini gönder
            const serviceIdsParam = serviceIdsArray.join(',');
            
            // Müsait saatleri getir
            fetch(`{{ route("public.appointment-request.available-slots-ascii") }}?service_ids=${serviceIdsParam}&salon_id=${salonId}&date=${dateStr}`, {
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                }
            })
            .then(async response => {
                const data = await response.json();
                if (!response.ok || !data.success) {
                    // Validation hatalarını göster
                    let errorMessage = data.message || 'Müsait saatler getirilemedi.';
                    if (data.errors) {
                        const errorMessages = Object.values(data.errors).flat();
                        if (errorMessages.length > 0) {
                            errorMessage = errorMessages.join(', ');
                        }
                    }
                    throw new Error(errorMessage);
                }
                return data;
            })
            .then(data => {
                
                servicePersonels = data.personels || [];
                serviceDuration = data.service_duration || 30;
                
                // 08:00 - 22:00 arası, 30 dakika aralıklarla saatler
                const allSlots = [];
                for (let hour = 8; hour < 22; hour++) {
                    allSlots.push(String(hour).padStart(2, '0') + ':00');
                    allSlots.push(String(hour).padStart(2, '0') + ':30');
                }
                allSlots.push('22:00');
                
                // Müsait saatleri kontrol et
                const availableSlots = data.available_slots || [];
                const slotMap = {};
                availableSlots.forEach(slot => {
                    slotMap[slot.time] = slot.available;
                });
                
                let html = '';
                allSlots.forEach(slot => {
                    const isAvailable = slotMap[slot] !== false; // Eğer slotMap'te yoksa veya true ise müsait
                    const isDisabled = !isAvailable;
                    
                    html += `
                        <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-3">
                            <button type="button" class="time-slot-btn ${isDisabled ? 'disabled' : ''}" 
                                    data-time="${slot}" 
                                    onclick="${isDisabled ? '' : `selectTime('${slot}')`}"
                                    ${isDisabled ? 'disabled' : ''}
                                    style="width: 100%; padding: 14px 8px; border: 2px solid ${isDisabled ? '#e5e7eb' : '#ec4899'}; border-radius: 12px; background: ${isDisabled ? '#f3f4f6' : 'white'}; color: ${isDisabled ? '#9ca3af' : '#ec4899'}; font-weight: 600; font-size: 0.95rem; cursor: ${isDisabled ? 'not-allowed' : 'pointer'}; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); box-shadow: 0 2px 4px rgba(0,0,0,0.05); min-height: 50px; display: flex; align-items: center; justify-content: center;"
                                    onmouseover="${isDisabled ? '' : "if(!this.classList.contains('selected')) { this.style.background='#fce7f3'; this.style.transform='translateY(-3px)'; this.style.boxShadow='0 6px 12px rgba(236, 72, 153, 0.2)'; }"}"
                                    onmouseout="${isDisabled ? '' : "if(!this.classList.contains('selected')) { this.style.background='white'; this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 4px rgba(0,0,0,0.05)'; }"}">
                                <i class="bi bi-clock me-1" style="font-size: 0.85rem;"></i>${slot}
                            </button>
                        </div>
                    `;
                });
                
                timeList.innerHTML = html;
            })
            .catch(error => {
                console.error('Müsait saatler yüklenirken hata:', error);
                timeList.innerHTML = '<div class="col-12"><div class="alert alert-danger">Müsait saatler yüklenirken bir hata oluştu. Lütfen tekrar deneyin.</div></div>';
            });
        }

        function selectTime(time) {
            document.getElementById('selectedTime').value = time;
            
            // Seçili saati görsel olarak işaretle
            document.querySelectorAll('.time-slot-btn').forEach(btn => {
                if (!btn.disabled) {
                    btn.classList.remove('selected');
                    btn.style.background = 'white';
                    btn.style.borderColor = '#ec4899';
                }
            });
            
            const selectedBtn = document.querySelector(`[data-time="${time}"]`);
            if (selectedBtn && !selectedBtn.disabled) {
                selectedBtn.classList.add('selected');
                selectedBtn.style.background = 'linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%)';
                selectedBtn.style.color = '#ec4899';
                selectedBtn.style.borderColor = '#ec4899';
                selectedBtn.style.boxShadow = '0 6px 16px rgba(236, 72, 153, 0.3)';
                selectedBtn.style.transform = 'translateY(-2px)';
            }
        }

        function prevStep() {
            if (currentStep === 2) {
                document.getElementById('step1').style.display = 'block';
                document.getElementById('step2').style.display = 'none';
                document.getElementById('prevStepBtn').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'none';
                document.getElementById('customerInfo').style.display = 'none';
                currentStep = 1;
            } else if (currentStep === 3) {
                if (isRegisteredCustomer) {
                    document.getElementById('step1').style.display = 'block';
                    document.getElementById('step3').style.display = 'none';
                    document.getElementById('prevStepBtn').style.display = 'none';
                    document.getElementById('nextStepBtn').style.display = 'none';
                    document.getElementById('customerInfo').style.display = 'none';
                    currentStep = 1;
                } else {
                    document.getElementById('step2').style.display = 'block';
                    document.getElementById('step3').style.display = 'none';
                    currentStep = 2;
                }
            } else if (currentStep === 4) {
                document.getElementById('step3').style.display = 'block';
                document.getElementById('step4').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                document.getElementById('submitBtn').style.display = 'none';
                currentStep = 3;
            } else if (currentStep === 5) {
                // Step 5'ten Step 4'e dön
                document.getElementById('step4').style.display = 'block';
                document.getElementById('step5').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                document.getElementById('submitBtn').style.display = 'none';
                currentStep = 4;
            } else if (currentStep === 6) {
                // Step 6'dan Step 5'e dön
                document.getElementById('step5').style.display = 'block';
                document.getElementById('step6').style.display = 'none';
                document.getElementById('nextStepBtn').style.display = 'inline-block';
                document.getElementById('submitBtn').style.display = 'none';
                currentStep = 5;
            }
        }

        function verifyOTP(otpCode) {
            const phone = document.getElementById('customerPhone').value;
            if (!phone) {
                console.error('Telefon numarası bulunamadı');
                return Promise.resolve(false);
            }
            
            return fetch('{{ route("public.appointment-request.verify-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json',
                },
                body: JSON.stringify({
                    phone: phone,
                    otp_code: otpCode
                })
            })
            .then(async response => {
                if (!response.ok) {
                    const errorData = await response.json().catch(() => ({ message: 'Sunucu hatası: ' + response.status }));
                    console.error('OTP doğrulama hatası:', errorData);
                    return false;
                }
                return response.json();
            })
            .then(data => {
                if (data && data.success) {
                    return true;
                }
                console.error('OTP doğrulama başarısız:', data);
                return false;
            })
            .catch(error => {
                console.error('OTP doğrulama hatası:', error);
                return false;
            });
        }

        function selectService(serviceId) {
            // Tüm service-option-card elementlerini bul (hem modal içinde hem dışında)
            const allCards = document.querySelectorAll(`[data-service-id="${serviceId}"], [data-service-id="${serviceId.toString()}"]`);
            
            if (allCards.length > 0) {
                // İlk kartı ana kart olarak al
                const selectedCard = allCards[0];
                
                // Checkbox'ı bul
                const checkbox = selectedCard.querySelector('.service-checkbox');
                const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                
                // Çoklu seçim: Tıklanan kartı toggle et
                const isSelected = selectedCard.classList.contains('border-primary');
                
                // Tüm eşleşen kartları güncelle
                allCards.forEach(card => {
                    if (isSelected) {
                        // Seçimi kaldır
                        card.classList.remove('border-primary');
                        const cardCheckbox = card.querySelector('.service-checkbox');
                        const cardCheckboxIcon = cardCheckbox ? cardCheckbox.querySelector('i') : null;
                        if (cardCheckbox) {
                            cardCheckbox.style.background = 'white';
                            cardCheckbox.style.borderColor = '#e5e7eb';
                            cardCheckbox.style.setProperty('background', 'white', 'important');
                            cardCheckbox.style.setProperty('border-color', '#e5e7eb', 'important');
                        }
                        if (cardCheckboxIcon) {
                            cardCheckboxIcon.style.display = 'none';
                        }
                    } else {
                        // Seçimi ekle
                        card.classList.add('border-primary');
                        const cardCheckbox = card.querySelector('.service-checkbox');
                        const cardCheckboxIcon = cardCheckbox ? cardCheckbox.querySelector('i') : null;
                        if (cardCheckbox) {
                            cardCheckbox.style.background = '#ec4899';
                            cardCheckbox.style.borderColor = '#ec4899';
                            cardCheckbox.style.setProperty('background', '#ec4899', 'important');
                            cardCheckbox.style.setProperty('border-color', '#ec4899', 'important');
                        }
                        if (cardCheckboxIcon) {
                            cardCheckboxIcon.style.display = 'flex';
                            cardCheckboxIcon.style.setProperty('display', 'flex', 'important');
                        }
                    }
                });
                
                if (isSelected) {
                    selectedServiceIds = selectedServiceIds.filter(id => id !== serviceId && id !== parseInt(serviceId));
                } else {
                    if (!selectedServiceIds.includes(serviceId) && !selectedServiceIds.includes(parseInt(serviceId))) {
                        selectedServiceIds.push(serviceId);
                    }
                }
                
                // İlk seçilen hizmeti ana hizmet olarak kaydet (geriye dönük uyumluluk için)
                selectedServiceId = selectedServiceIds.length > 0 ? selectedServiceIds[0] : null;
                
                const selectedServiceIdInput = document.getElementById('selectedServiceId');
                if (selectedServiceIdInput) {
                    selectedServiceIdInput.value = selectedServiceId;
                }
                
                const selectedServiceIdsInput = document.getElementById('selectedServiceIds');
                if (selectedServiceIdsInput) {
                    selectedServiceIdsInput.value = JSON.stringify(selectedServiceIds);
                }
                
                // Seçilen hizmet sayısını göster
                updateSelectedServicesCount();
            }
        }
        
        function updateSelectedServicesCount() {
            const count = selectedServiceIds.length;
            const countBadge = document.getElementById('selectedServicesCount');
            if (countBadge) {
                if (count > 0) {
                    countBadge.textContent = `${count} hizmet seçildi`;
                    countBadge.style.display = 'inline-block';
                } else {
                    countBadge.style.display = 'none';
                }
            }
        }

        function switchStepServiceCategory(categoryId) {
            // Tüm sekmelerin active class'ını kaldır
            document.querySelectorAll('.step-category-tab-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Tıklanan sekmenin active class'ını ekle
            const clickedBtn = document.querySelector(`[data-step-category="${categoryId}"]`);
            if (clickedBtn) {
                clickedBtn.classList.add('active');
            }
            
            // Tüm kategori içeriklerini gizle
            document.querySelectorAll('.step-services-category-content').forEach(content => {
                content.style.display = 'none';
            });
            
            // Seçilen kategori içeriğini göster
            const selectedContent = document.getElementById(`stepServicesContent-${categoryId}`);
            if (selectedContent) {
                selectedContent.style.display = 'block';
            }
        }

        function selectServiceAndOpenModal(serviceId) {
            // Önce hizmeti seç - tüm kartları bul
            const allCards = document.querySelectorAll(`[data-service-id="${serviceId}"], [data-service-id="${serviceId.toString()}"]`);
            
            if (allCards.length > 0) {
                const selectedCard = allCards[0];
                if (!selectedCard.classList.contains('border-primary')) {
                    // Tüm eşleşen kartları güncelle
                    allCards.forEach(card => {
                        card.classList.add('border-primary');
                        const checkbox = card.querySelector('.service-checkbox');
                        const checkboxIcon = checkbox ? checkbox.querySelector('i') : null;
                        if (checkbox) {
                            checkbox.style.background = '#ec4899';
                            checkbox.style.borderColor = '#ec4899';
                            checkbox.style.setProperty('background', '#ec4899', 'important');
                            checkbox.style.setProperty('border-color', '#ec4899', 'important');
                        }
                        if (checkboxIcon) {
                            checkboxIcon.style.display = 'flex';
                            checkboxIcon.style.setProperty('display', 'flex', 'important');
                        }
                    });
                    
                    if (!selectedServiceIds.includes(serviceId) && !selectedServiceIds.includes(parseInt(serviceId))) {
                        selectedServiceIds.push(serviceId);
                    }
                    
                    selectedServiceId = selectedServiceIds.length > 0 ? selectedServiceIds[0] : null;
                    
                    const selectedServiceIdInput = document.getElementById('selectedServiceId');
                    if (selectedServiceIdInput) {
                        selectedServiceIdInput.value = selectedServiceId;
                    }
                    
                    const selectedServiceIdsInput = document.getElementById('selectedServiceIds');
                    if (selectedServiceIdsInput) {
                        selectedServiceIdsInput.value = JSON.stringify(selectedServiceIds);
                    }
                    
                    updateSelectedServicesCount();
                }
            }
            
            // Sonra modalı aç ve Step 4'e git
            openAppointmentModal(serviceId);
            setTimeout(() => {
                goToStep4();
            }, 300);
        }

        function toggleRecurringOptions() {
            const enableRecurring = document.getElementById('enableRecurring');
            const recurringOptions = document.getElementById('recurringOptions');
            
            if (enableRecurring && recurringOptions) {
                if (enableRecurring.checked) {
                    recurringOptions.style.display = 'block';
                } else {
                    recurringOptions.style.display = 'none';
                    // Form alanlarını sıfırla
                    document.getElementById('recurring_type').value = '';
                    document.getElementById('day_of_week').value = '';
                    document.getElementById('day_of_month').value = '';
                    document.getElementById('recurring_count').value = '1';
                    document.getElementById('day_of_week_container').style.display = 'none';
                    document.getElementById('day_of_month_container').style.display = 'none';
                }
            }
        }

        function toggleRecurringDayOptions() {
            const recurringType = document.getElementById('recurring_type').value;
            const dayOfWeekContainer = document.getElementById('day_of_week_container');
            const dayOfMonthContainer = document.getElementById('day_of_month_container');
            
            if (recurringType === 'weekly') {
                if (dayOfWeekContainer) dayOfWeekContainer.style.display = 'block';
                if (dayOfMonthContainer) dayOfMonthContainer.style.display = 'none';
                if (document.getElementById('day_of_month')) document.getElementById('day_of_month').value = '';
            } else if (recurringType === 'monthly') {
                if (dayOfWeekContainer) dayOfWeekContainer.style.display = 'none';
                if (dayOfMonthContainer) dayOfMonthContainer.style.display = 'block';
                if (document.getElementById('day_of_week')) document.getElementById('day_of_week').value = '';
            } else {
                if (dayOfWeekContainer) dayOfWeekContainer.style.display = 'none';
                if (dayOfMonthContainer) dayOfMonthContainer.style.display = 'none';
            }
        }

        function initializeAppointmentWizardBindings() {
            if (window.__appointmentWizardBindingsInitialized) {
                return;
            }
            const hasAppointmentUi = !!document.getElementById('appointmentModal');
            const hasTabUi = document.querySelectorAll('.tab-btn').length > 0;
            if (!hasAppointmentUi && !hasTabUi) {
                return;
            }
            window.__appointmentWizardBindingsInitialized = true;

            const bindClick = (id, handler) => {
                const element = document.getElementById(id);
                if (!element || typeof handler !== 'function') return;
                element.onclick = function(event) {
                    event.preventDefault();
                    handler();
                };
            };

            bindClick('verifyPhoneBtn', checkPhone);
            bindClick('resendOTPBtn', resendOTP);
            bindClick('nextStepBtn', nextStep);
            bindClick('prevStepBtn', prevStep);

            document.querySelectorAll('.tab-btn').forEach(btn => {
                const onclickValue = btn.getAttribute('onclick') || '';
                const match = onclickValue.match(/switchTab\('([^']+)'\)/);
                const tabName = btn.getAttribute('data-tab') || (match ? match[1] : null);
                if (!tabName) return;
                btn.setAttribute('data-tab', tabName);
                btn.addEventListener('click', function(event) {
                    event.preventDefault();
                    switchTab(tabName);
                });
            });

            document.querySelectorAll('.category-tab-btn').forEach(btn => {
                const categoryId = btn.getAttribute('data-category');
                if (categoryId === null) return;
                btn.addEventListener('click', function(event) {
                    event.preventDefault();
                    switchServiceCategory(categoryId);
                });
            });

            document.querySelectorAll('.gallery-image-public').forEach(image => {
                image.addEventListener('click', function(event) {
                    event.preventDefault();
                    const imageSrc = image.getAttribute('src') || image.dataset.src;
                    if (imageSrc) {
                        openGalleryModal(imageSrc);
                    }
                });
            });

            const phoneInput = document.getElementById('customerPhone');
            if (phoneInput) {
                phoneInput.addEventListener('keydown', function(event) {
                    if (event.key === 'Enter') {
                        event.preventDefault();
                        checkPhone();
                    }
                });
            }

            const appointmentModal = document.getElementById('appointmentModal');
            const modalRoot = appointmentModal || document;

            modalRoot.querySelectorAll('.service-option-card[data-service-id]').forEach(() => {});
            modalRoot.querySelectorAll('.step-category-tab-btn[data-step-category]').forEach(btn => {
                btn.addEventListener('click', function(event) {
                    event.preventDefault();
                    const categoryId = btn.getAttribute('data-step-category');
                    if (categoryId !== null) {
                        switchStepServiceCategory(categoryId);
                    }
                });
            });

            document.addEventListener('click', function(event) {
                const serviceCard = event.target.closest('.service-option-card[data-service-id]');
                if (serviceCard && modalRoot.contains(serviceCard)) {
                    event.preventDefault();
                    const serviceId = serviceCard.getAttribute('data-service-id');
                    if (serviceId) {
                        selectService(serviceId);
                    }
                    return;
                }

                const dateCard = event.target.closest('.date-option-card[data-date]');
                if (dateCard && modalRoot.contains(dateCard)) {
                    event.preventDefault();
                    const dateValue = dateCard.getAttribute('data-date');
                    if (dateValue) {
                        selectDate(dateValue);
                    }
                    return;
                }

                const timeButton = event.target.closest('.time-slot-btn[data-time]');
                if (timeButton && modalRoot.contains(timeButton) && !timeButton.disabled && !timeButton.classList.contains('disabled')) {
                    event.preventDefault();
                    const timeValue = timeButton.getAttribute('data-time');
                    if (timeValue) {
                        selectTime(timeValue);
                    }
                }
            });

            window.openAppointmentModal = openAppointmentModal;
            window.checkPhone = checkPhone;
            window.resendOTP = resendOTP;
            window.nextStep = nextStep;
            window.prevStep = prevStep;
            window.selectService = selectService;
            window.selectDate = selectDate;
            window.selectTime = selectTime;
        }

        // Hard fallback: sekme gecisini her durumda garanti et
        function forceSwitchTab(tabName) {
            const tabIdMap = {
                services: 'servicesTab',
                gallery: 'galleryTab',
                personels: 'personelsTab',
                ratings: 'ratingsTab'
            };
            document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
                content.style.display = 'none';
            });
            const targetBtn = document.querySelector(`.tab-btn[data-tab="${tabName}"]`) ||
                Array.from(document.querySelectorAll('.tab-btn')).find(btn => (btn.getAttribute('onclick') || '').includes(`switchTab('${tabName}')`));
            if (targetBtn) targetBtn.classList.add('active');
            const targetContent = document.getElementById(tabIdMap[tabName] || `${tabName}Tab`);
            if (targetContent) {
                targetContent.classList.add('active');
                targetContent.style.display = 'block';
            }
        }
        window.switchTab = forceSwitchTab;

        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initializeAppointmentWizardBindings, { once: true });
        } else {
            initializeAppointmentWizardBindings();
        }

        // Ek güvenlik: modal her açıldığında kritik butonları tekrar bağla
        const appointmentModalEl = document.getElementById('appointmentModal');
        if (appointmentModalEl) {
            appointmentModalEl.addEventListener('shown.bs.modal', function() {
                const verifyBtn = document.getElementById('verifyPhoneBtn');
                if (verifyBtn) {
                    verifyBtn.onclick = function(event) {
                        event.preventDefault();
                        if (typeof checkPhone === 'function') checkPhone();
                    };
                }
                const nextBtn = document.getElementById('nextStepBtn');
                if (nextBtn) {
                    nextBtn.onclick = function(event) {
                        event.preventDefault();
                        if (typeof nextStep === 'function') nextStep();
                    };
                }
                const prevBtn = document.getElementById('prevStepBtn');
                if (prevBtn) {
                    prevBtn.onclick = function(event) {
                        event.preventDefault();
                        if (typeof prevStep === 'function') prevStep();
                    };
                }
            });
        }

        // Son güvenlik katmanı: kritik butonlar event delegation ile her zaman çalışsın
        document.addEventListener('click', function(event) {
            const verifyBtn = event.target.closest('#verifyPhoneBtn');
            if (verifyBtn) {
                event.preventDefault();
                if (typeof checkPhone === 'function') checkPhone();
                return;
            }
            const resendBtn = event.target.closest('#resendOTPBtn');
            if (resendBtn) {
                event.preventDefault();
                if (typeof resendOTP === 'function') resendOTP();
                return;
            }
            const nextBtn = event.target.closest('#nextStepBtn');
            if (nextBtn) {
                event.preventDefault();
                if (typeof nextStep === 'function') nextStep();
                return;
            }
            const prevBtn = event.target.closest('#prevStepBtn');
            if (prevBtn) {
                event.preventDefault();
                if (typeof prevStep === 'function') prevStep();
                return;
            }
            const tabBtn = event.target.closest('.tab-btn');
            if (tabBtn) {
                const tabName = tabBtn.getAttribute('data-tab');
                if (tabName) {
                    event.preventDefault();
                    forceSwitchTab(tabName);
                }
                return;
            }
            const catBtn = event.target.closest('.category-tab-btn[data-category]');
            if (catBtn) {
                const categoryId = catBtn.getAttribute('data-category');
                if (categoryId !== null && typeof switchServiceCategory === 'function') {
                    event.preventDefault();
                    switchServiceCategory(categoryId);
                }
            }
        });

        const submitBtnEl = document.getElementById('submitBtn');
        if (submitBtnEl) submitBtnEl.addEventListener('click', function() {
            // Elementleri kontrol et
            const customerPhoneEl = document.getElementById('customerPhone');
            const customerNameEl = document.getElementById('customerName');
            
            // Müşteri bilgileri
            let finalCustomerName = '';
            let finalCustomerSurname = '';
            let finalCustomerAge = null;
            
            if (isRegisteredCustomer) {
                // Kayıtlı müşteri için otomatik doldurulan bilgileri kullan
                finalCustomerName = document.getElementById('customerName')?.value || customerName || '';
                finalCustomerSurname = document.getElementById('customerSurname')?.value || '';
                finalCustomerAge = document.getElementById('customerAge')?.value || null;
                
                if (!finalCustomerName) {
                    alert('Müşteri bilgisi bulunamadı. Lütfen sayfayı yenileyin.');
                    return;
                }
            } else {
                // Kayıtsız müşteri için formdan al
                if (!customerNameEl || !customerNameEl.value) {
                    alert('Lütfen adınızı giriniz.');
                    if (customerNameEl) customerNameEl.focus();
                    return;
                }
                finalCustomerName = customerNameEl.value;
                
                const customerSurnameEl = document.getElementById('customerSurname');
                if (!customerSurnameEl || !customerSurnameEl.value) {
                    alert('Lütfen soyadınızı giriniz.');
                    if (customerSurnameEl) customerSurnameEl.focus();
                    return;
                }
                finalCustomerSurname = customerSurnameEl.value;
                
                const customerAgeEl = document.getElementById('customerAge');
                if (!customerAgeEl || !customerAgeEl.value) {
                    alert('Lütfen yaşınızı giriniz.');
                    if (customerAgeEl) customerAgeEl.focus();
                    return;
                }
                finalCustomerAge = customerAgeEl.value;
            }
            
            if (!customerPhoneEl || !customerPhoneEl.value) {
                alert('Telefon numarası bulunamadı. Lütfen sayfayı yenileyin.');
                return;
            }
            
            // Tarih ve saat kontrolü (Step 5)
            const selectedDate = document.getElementById('selectedDate').value;
            const selectedTime = document.getElementById('selectedTime').value;
            
            if (!selectedDate || !selectedTime) {
                alert('Lütfen tarih ve saat seçiniz.');
                return;
            }
            
            // Tekrarlanan seans bilgilerini kontrol et
            const enableRecurring = document.getElementById('enableRecurring')?.checked || false;
            let recurringData = null;
            
            if (enableRecurring) {
                const recurringType = document.getElementById('recurring_type')?.value;
                const recurringCount = document.getElementById('recurring_count')?.value;
                
                if (!recurringType) {
                    alert('Lütfen tekrarlama tipini seçiniz.');
                    return;
                }
                
                if (!recurringCount || parseInt(recurringCount) < 1 || parseInt(recurringCount) > 24) {
                    alert('Lütfen 1-24 arası bir tekrarlama sayısı giriniz.');
                    return;
                }
                
                if (recurringType === 'weekly') {
                    const dayOfWeek = document.getElementById('day_of_week')?.value;
                    if (!dayOfWeek) {
                        alert('Lütfen haftanın gününü seçiniz.');
                        return;
                    }
                    recurringData = {
                        recurring_type: recurringType,
                        day_of_week: parseInt(dayOfWeek),
                        recurring_count: parseInt(recurringCount)
                    };
                } else if (recurringType === 'monthly') {
                    const dayOfMonth = document.getElementById('day_of_month')?.value;
                    if (!dayOfMonth) {
                        alert('Lütfen ayın gününü seçiniz.');
                        return;
                    }
                    recurringData = {
                        recurring_type: recurringType,
                        day_of_month: parseInt(dayOfMonth),
                        recurring_count: parseInt(recurringCount)
                    };
                }
            }
            
            // Seçilen hizmet ID'lerini al
            const serviceIdsInput = document.getElementById('selectedServiceIds');
            let serviceIdsArray = [];
            if (serviceIdsInput && serviceIdsInput.value) {
                try {
                    serviceIdsArray = JSON.parse(serviceIdsInput.value);
                } catch (e) {
                    // Eğer JSON parse edilemezse, tek hizmet ID'sini kullan
                    const singleServiceId = selectedServiceId || (document.getElementById('selectedServiceId') ? document.getElementById('selectedServiceId').value : null);
                    if (singleServiceId) {
                        serviceIdsArray = [singleServiceId];
                    }
                }
            } else {
                // Eğer serviceIds yoksa, tek hizmet ID'sini kullan
                const singleServiceId = selectedServiceId || (document.getElementById('selectedServiceId') ? document.getElementById('selectedServiceId').value : null);
                if (singleServiceId) {
                    serviceIdsArray = [singleServiceId];
                }
            }
            
            // Referans kodunu al (Step 4'teki varsa onu kullan, yoksa Step 2'deki)
            const referralCodeStep4 = document.getElementById('referralCodeStep4')?.value;
            const referralCodeStep2 = document.getElementById('referralCode')?.value;
            const referralCode = referralCodeStep4 || referralCodeStep2 || null;
            
            const formData = {
                salon_id: salonId,
                service_id: selectedServiceId || (document.getElementById('selectedServiceId') ? document.getElementById('selectedServiceId').value : null), // Geriye dönük uyumluluk için
                service_ids: serviceIdsArray.length > 0 ? serviceIdsArray : null, // Birden fazla hizmet
                name: finalCustomerName,
                phone: customerPhoneEl.value,
                customer_id: customerId || null,
                surname: finalCustomerSurname || null,
                age: finalCustomerAge ? parseInt(finalCustomerAge) : null,
                referral_code: referralCode,
                date: selectedDate,
                time: selectedTime,
                recurring: recurringData
            };

            fetch('{{ route("public.appointment-request.store") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(async response => {
                if (!response.ok) {
                    const errorData = await response.json().catch(() => ({ message: 'Sunucu hatası: ' + response.status }));
                    // Validation hatalarını daha iyi göster
                    if (errorData.errors) {
                        const errorMessages = Object.values(errorData.errors).flat().join('\n');
                        throw new Error(errorMessages);
                    }
                    throw new Error(errorData.message || 'Sunucu hatası: ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    bootstrap.Modal.getInstance(document.getElementById('appointmentModal')).hide();
                    showCustomAlert('Randevu talebiniz başarıyla gönderildi. En kısa sürede size dönüş yapılacaktır.', 'success');
                    setTimeout(() => location.reload(), 2000);
                } else {
                    showCustomAlert(data.message || 'Randevu talebi gönderilirken bir hata oluştu.', 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showCustomAlert(error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.', 'error');
            });
        });

        // Gallery Modal
        function openGalleryModal(imageSrc) {
            const galleryImage = document.getElementById('galleryModalImage');
            const galleryModalEl = document.getElementById('galleryModal');
            if (!galleryImage || !galleryModalEl) {
                return;
            }
            galleryImage.src = imageSrc;
            if (window.bootstrap && window.bootstrap.Modal) {
                const galleryModal = new bootstrap.Modal(galleryModalEl);
                galleryModal.show();
            }
        }

        // Custom Success Popup
        function showCustomAlert(message, type = 'success') {
            // Varsa eski popup'ı kaldır
            const existingPopup = document.getElementById('customAlertPopup');
            if (existingPopup) existingPopup.remove();
            
            const colors = {
                success: { bg: '#10b981', icon: 'bi-check-circle-fill' },
                error: { bg: '#ef4444', icon: 'bi-x-circle-fill' },
                warning: { bg: '#f59e0b', icon: 'bi-exclamation-triangle-fill' },
                info: { bg: '#3b82f6', icon: 'bi-info-circle-fill' }
            };
            
            const config = colors[type] || colors.success;
            
            const popup = document.createElement('div');
            popup.id = 'customAlertPopup';
            popup.style.cssText = 'position: fixed; top: 20px; right: 20px; z-index: 999999; animation: slideInRight 0.3s ease;';
            popup.innerHTML = `
                <div style="background: ${config.bg}; color: white; padding: 20px 24px; border-radius: 16px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); display: flex; align-items: center; gap: 16px; min-width: 300px; max-width: 500px;">
                    <i class="bi ${config.icon}" style="font-size: 28px; flex-shrink: 0;"></i>
                    <div style="flex: 1;">
                        <div style="font-weight: 600; font-size: 16px; margin-bottom: 4px;">${type === 'success' ? 'Başarılı' : type === 'error' ? 'Hata' : type === 'warning' ? 'Uyarı' : 'Bilgi'}</div>
                        <div style="font-size: 14px; opacity: 0.95;">${message}</div>
                    </div>
                    <button type="button" onclick="this.closest('#customAlertPopup').remove()" style="background: rgba(255,255,255,0.2); border: none; color: white; width: 28px; height: 28px; border-radius: 50%; cursor: pointer; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-size: 18px; line-height: 1;">&times;</button>
                </div>
            `;
            
            // CSS animation ekle
            if (!document.getElementById('customAlertStyles')) {
                const style = document.createElement('style');
                style.id = 'customAlertStyles';
                style.textContent = `
                    @keyframes slideInRight {
                        from {
                            transform: translateX(100%);
                            opacity: 0;
                        }
                        to {
                            transform: translateX(0);
                            opacity: 1;
                        }
                    }
                `;
                document.head.appendChild(style);
            }
            
            document.body.appendChild(popup);
            
            // 5 saniye sonra otomatik kapat
            setTimeout(() => {
                if (popup && popup.parentNode) {
                    popup.style.opacity = '0';
                    popup.style.transition = 'opacity 0.3s ease';
                    setTimeout(() => popup.remove(), 300);
                }
            }, 5000);
        }
        
        // Custom Confirm Popup
        function customConfirm(message) {
            return new Promise((resolve) => {
                // Varsa eski popup'ı kaldır
                const existingPopup = document.getElementById('customConfirmPopup');
                if (existingPopup) existingPopup.remove();
                
                const popup = document.createElement('div');
                popup.id = 'customConfirmPopup';
                popup.style.cssText = 'position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 999999; background: rgba(0,0,0,0.5); display: flex; align-items: center; justify-content: center; animation: fadeIn 0.2s ease;';
                popup.innerHTML = `
                    <div style="background: white; border-radius: 16px; padding: 32px; max-width: 400px; width: 90%; box-shadow: 0 20px 60px rgba(0,0,0,0.3); animation: slideUp 0.3s ease;">
                        <div style="text-align: center; margin-bottom: 24px;">
                            <i class="bi bi-question-circle-fill" style="font-size: 48px; color: #3b82f6; margin-bottom: 16px;"></i>
                            <div style="font-size: 18px; font-weight: 600; color: #1f2937; margin-bottom: 8px;">Onay</div>
                            <div style="font-size: 14px; color: #6b7280; line-height: 1.6;">${message || 'Bu işlemi yapmak istediğinize emin misiniz?'}</div>
                        </div>
                        <div style="display: flex; gap: 12px;">
                            <button id="confirmCancelBtn" style="flex: 1; padding: 12px; border: 1px solid #e5e7eb; background: white; color: #6b7280; border-radius: 8px; cursor: pointer; font-weight: 600; transition: all 0.2s;">İptal</button>
                            <button id="confirmOkBtn" style="flex: 1; padding: 12px; border: none; background: #3b82f6; color: white; border-radius: 8px; cursor: pointer; font-weight: 600; transition: all 0.2s;">Onayla</button>
                        </div>
                    </div>
                    <style>
                        @keyframes fadeIn {
                            from { opacity: 0; }
                            to { opacity: 1; }
                        }
                        @keyframes slideUp {
                            from { transform: translateY(20px); opacity: 0; }
                            to { transform: translateY(0); opacity: 1; }
                        }
                        #confirmCancelBtn:hover { background: #f9fafb !important; }
                        #confirmOkBtn:hover { background: #2563eb !important; }
                    </style>
                `;
                
                document.body.appendChild(popup);
                
                const okBtn = popup.querySelector('#confirmOkBtn');
                const cancelBtn = popup.querySelector('#confirmCancelBtn');
                
                const closePopup = (result) => {
                    popup.style.opacity = '0';
                    popup.style.transition = 'opacity 0.2s ease';
                    setTimeout(() => {
                        if (popup && popup.parentNode) {
                            popup.remove();
                        }
                        resolve(result);
                    }, 200);
                };
                
                okBtn.onclick = () => closePopup(true);
                cancelBtn.onclick = () => closePopup(false);
                popup.onclick = (e) => {
                    if (e.target === popup) closePopup(false);
                };
            });
        }
        
        // Browser alert() fonksiyonunu override et - site içi popup kullan
        window.alert = function(message) {
            showCustomAlert(message, 'info');
        };
        
        // Browser confirm() fonksiyonunu override et - site içi popup kullan
        window.confirm = function(message) {
            return customConfirm(message);
        };

        // Appointment wizard v2: rebuilt, isolated and deterministic.
        (function () {
            const modalEl = document.getElementById('appointmentModal');
            if (!modalEl || window.__appointmentWizardV2Ready) return;
            window.__appointmentWizardV2Ready = true;

            const STEPS = [1, 2, 3, 4, 5, 6];
            const TAB_BY_KEY = {
                all: 'all'
            };
            const state = {
                salonId: {{ $salon->id }},
                currentStep: 1,
                isRegistered: false,
                customerId: null,
                selectedServiceIds: [],
                selectedDate: '',
                selectedTime: '',
                resendCooldown: 0,
                resendTimer: null
            };

            function byId(id) {
                return document.getElementById(id);
            }

            function notify(message, type) {
                if (typeof window.showCustomAlert === 'function') {
                    window.showCustomAlert(message, type || 'info');
                    return;
                }
                window.alert(message);
            }

            function setStep(step) {
                state.currentStep = step;
                STEPS.forEach((s) => {
                    const el = byId(`step${s}`);
                    if (el) el.style.display = s === step ? 'block' : 'none';
                });

                const prevBtn = byId('prevStepBtn');
                const nextBtn = byId('nextStepBtn');
                const submitBtn = byId('submitBtn');
                if (prevBtn) prevBtn.style.display = step === 1 ? 'none' : 'inline-block';
                if (nextBtn) nextBtn.style.display = step >= 6 || step === 1 ? 'none' : 'inline-block';
                if (submitBtn) submitBtn.style.display = step === 6 ? 'inline-block' : 'none';
            }

            function resetWizard(serviceId) {
                state.currentStep = 1;
                state.isRegistered = false;
                state.customerId = null;
                state.selectedServiceIds = [];
                state.selectedDate = '';
                state.selectedTime = '';

                const step1Form = byId('step1Form');
                if (step1Form) step1Form.reset();

                ['customerName', 'customerSurname', 'customerAge', 'referralCode', 'referralCodeStep4', 'otpCode'].forEach((id) => {
                    const el = byId(id);
                    if (el) el.value = '';
                });
                const customerInfo = byId('customerInfo');
                if (customerInfo) customerInfo.style.display = 'none';
                const customerInfoText = byId('customerInfoText');
                if (customerInfoText) customerInfoText.textContent = '';

                const selectedServiceId = byId('selectedServiceId');
                const selectedServiceIds = byId('selectedServiceIds');
                if (selectedServiceId) selectedServiceId.value = '';
                if (selectedServiceIds) selectedServiceIds.value = '[]';
                const selectedDate = byId('selectedDate');
                const selectedTime = byId('selectedTime');
                if (selectedDate) selectedDate.value = '';
                if (selectedTime) selectedTime.value = '';

                modalEl.querySelectorAll('.service-option-card').forEach((card) => {
                    card.classList.remove('border-primary');
                    const checkbox = card.querySelector('.service-checkbox');
                    const icon = checkbox ? checkbox.querySelector('i') : null;
                    if (checkbox) {
                        checkbox.style.background = 'white';
                        checkbox.style.borderColor = '#e5e7eb';
                    }
                    if (icon) {
                        icon.style.display = 'none';
                    }
                });
                modalEl.querySelectorAll('.date-option-card').forEach((card) => card.classList.remove('border-primary'));
                modalEl.querySelectorAll('.time-slot-btn').forEach((btn) => btn.classList.remove('btn-primary'));

                updateSelectedServicesCount();
                setStep(1);
                switchStepServiceCategory('all');
                renderDates();

                if (serviceId) {
                    selectService(serviceId);
                }
            }

            function setButtonLoading(buttonId, loadingText) {
                const btn = byId(buttonId);
                if (!btn) return () => {};
                const original = btn.innerHTML;
                btn.disabled = true;
                btn.innerHTML = loadingText;
                return function restore() {
                    btn.disabled = false;
                    btn.innerHTML = original;
                };
            }

            function startResendCooldown(seconds) {
                const resendBtn = byId('resendOTPBtn');
                const countdown = byId('resendCountdown');
                const countdownText = byId('countdownText');
                if (!resendBtn || !countdown || !countdownText) return;
                state.resendCooldown = seconds;
                resendBtn.disabled = true;
                countdown.style.display = 'block';
                countdownText.textContent = String(state.resendCooldown);
                if (state.resendTimer) clearInterval(state.resendTimer);
                state.resendTimer = setInterval(() => {
                    state.resendCooldown -= 1;
                    countdownText.textContent = String(Math.max(0, state.resendCooldown));
                    if (state.resendCooldown <= 0) {
                        clearInterval(state.resendTimer);
                        state.resendTimer = null;
                        resendBtn.disabled = false;
                        countdown.style.display = 'none';
                    }
                }, 1000);
            }

            async function requestOtp(phone, name) {
                const response = await fetch('{{ route("public.appointment-request.send-otp") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        salon_id: state.salonId,
                        phone: phone,
                        name: name || ''
                    })
                });
                const data = await response.json().catch(() => ({}));
                if (!response.ok) {
                    throw new Error(data.message || `Sunucu hatası: ${response.status}`);
                }
                return data;
            }

            async function verifyOtp(otpCode) {
                const phone = (byId('customerPhone')?.value || '').trim();
                const response = await fetch('{{ route("public.appointment-request.verify-otp") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        phone: phone,
                        otp_code: otpCode
                    })
                });
                const data = await response.json().catch(() => ({}));
                if (!response.ok) return false;
                return !!data.success;
            }

            function updateSelectedServicesCount() {
                const badge = byId('selectedServicesCount');
                if (!badge) return;
                const count = state.selectedServiceIds.length;
                if (count > 0) {
                    badge.style.display = 'inline-block';
                    badge.textContent = `${count} hizmet seçildi`;
                } else {
                    badge.style.display = 'none';
                }
                const serviceIdInput = byId('selectedServiceId');
                const serviceIdsInput = byId('selectedServiceIds');
                if (serviceIdInput) serviceIdInput.value = count > 0 ? String(state.selectedServiceIds[0]) : '';
                if (serviceIdsInput) serviceIdsInput.value = JSON.stringify(state.selectedServiceIds);
            }

            function applyServiceCardState(serviceId, selected) {
                modalEl.querySelectorAll(`.service-option-card[data-service-id="${serviceId}"]`).forEach((card) => {
                    card.classList.toggle('border-primary', selected);
                    const checkbox = card.querySelector('.service-checkbox');
                    const icon = checkbox ? checkbox.querySelector('i') : null;
                    if (checkbox) {
                        checkbox.style.background = selected ? '#ec4899' : 'white';
                        checkbox.style.borderColor = selected ? '#ec4899' : '#e5e7eb';
                    }
                    if (icon) icon.style.display = selected ? 'flex' : 'none';
                });
            }

            function selectService(serviceId) {
                const id = Number(serviceId);
                if (!id) return;
                const exists = state.selectedServiceIds.includes(id);
                if (exists) {
                    state.selectedServiceIds = state.selectedServiceIds.filter((x) => x !== id);
                } else {
                    state.selectedServiceIds.push(id);
                }
                applyServiceCardState(id, !exists);
                updateSelectedServicesCount();
            }

            function switchStepServiceCategory(categoryId) {
                const key = String(categoryId);
                modalEl.querySelectorAll('.step-category-tab-btn').forEach((btn) => {
                    btn.classList.toggle('active', String(btn.getAttribute('data-step-category')) === key);
                });
                modalEl.querySelectorAll('.step-services-category-content').forEach((content) => {
                    content.style.display = 'none';
                });
                const target = byId(`stepServicesContent-${key}`);
                if (target) target.style.display = 'block';
            }

            function renderDates() {
                const dateList = byId('dateList');
                if (!dateList) return;
                const names = ['Paz', 'Pzt', 'Sal', 'Car', 'Per', 'Cum', 'Cmt'];
                const today = new Date();
                const rows = [];
                for (let i = 0; i < 14; i += 1) {
                    const d = new Date(today);
                    d.setDate(today.getDate() + i);
                    const iso = d.toISOString().slice(0, 10);
                    rows.push(
                        `<div class="col-md-3 col-6 mb-3">
                            <button type="button" class="date-option-card btn w-100 ${state.selectedDate === iso ? 'border-primary' : ''}" data-date="${iso}" style="border: 1px solid #e5e7eb; border-radius: 10px; background: white;">
                                <div style="font-weight: 600;">${String(d.getDate()).padStart(2, '0')}.${String(d.getMonth() + 1).padStart(2, '0')}</div>
                                <small class="text-muted">${names[d.getDay()]}</small>
                            </button>
                        </div>`
                    );
                }
                dateList.innerHTML = rows.join('');
            }

            function selectDate(dateStr) {
                state.selectedDate = dateStr;
                const selectedDate = byId('selectedDate');
                if (selectedDate) selectedDate.value = dateStr;
                modalEl.querySelectorAll('.date-option-card').forEach((card) => {
                    card.classList.toggle('border-primary', card.getAttribute('data-date') === dateStr);
                });
                loadAvailableSlots(dateStr);
            }

            function selectTime(time) {
                state.selectedTime = time;
                const selectedTime = byId('selectedTime');
                if (selectedTime) selectedTime.value = time;
                modalEl.querySelectorAll('.time-slot-btn').forEach((btn) => {
                    const isActive = btn.getAttribute('data-time') === time;
                    btn.classList.toggle('btn-primary', isActive);
                    btn.classList.toggle('btn-outline-secondary', !isActive && !btn.disabled);
                });
            }

            async function loadAvailableSlots(dateStr) {
                const timeList = byId('timeList');
                if (!timeList) return;
                if (!dateStr || state.selectedServiceIds.length === 0) {
                    timeList.innerHTML = '<div class="col-12"><div class="alert alert-warning">Lutfen once hizmet ve tarih seciniz.</div></div>';
                    return;
                }
                timeList.innerHTML = '<div class="col-12"><div class="alert alert-info">Saatler yukleniyor...</div></div>';

                try {
                    const query = new URLSearchParams({
                        service_ids: state.selectedServiceIds.join(','),
                        salon_id: String(state.salonId),
                        date: dateStr
                    });
                    const response = await fetch(`{{ route("public.appointment-request.available-slots-ascii") }}?${query.toString()}`, {
                        headers: {
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        }
                    });
                    const data = await response.json().catch(() => ({}));
                    if (!response.ok) {
                        throw new Error(data.message || 'Müsait saatler alinamadi.');
                    }

                    const slotsRaw = Array.isArray(data.available_slots) ? data.available_slots : [];
                    const normalized = slotsRaw.map((slot) => {
                        if (typeof slot === 'string') return { time: slot, available: true };
                        return { time: slot.time, available: slot.available !== false };
                    }).filter((slot) => !!slot.time);

                    if (!normalized.length) {
                        timeList.innerHTML = '<div class="col-12"><div class="alert alert-warning">Bu tarih icin uygun saat bulunamadi.</div></div>';
                        return;
                    }

                    normalized.sort((a, b) => String(a.time).localeCompare(String(b.time)));
                    const html = normalized.map((slot) => {
                        const cls = slot.available ? 'btn-outline-secondary' : 'btn-outline-secondary disabled';
                        return `<div class="col-md-3 col-6 mb-2">
                            <button type="button" class="btn w-100 time-slot-btn ${cls}" data-time="${slot.time}" ${slot.available ? '' : 'disabled'}>${slot.time}</button>
                        </div>`;
                    }).join('');
                    timeList.innerHTML = html;
                } catch (error) {
                    timeList.innerHTML = `<div class="col-12"><div class="alert alert-danger">${error.message || 'Saatler alinamadi.'}</div></div>`;
                }
            }

            function getRecurringData() {
                const enabled = byId('enableRecurring')?.checked;
                if (!enabled) return null;
                return {
                    enabled: true,
                    recurring_type: byId('recurring_type')?.value || null,
                    day_of_week: byId('day_of_week')?.value || null,
                    day_of_month: byId('day_of_month')?.value || null,
                    recurring_count: byId('recurring_count')?.value ? parseInt(byId('recurring_count').value, 10) : null
                };
            }

            async function submitAppointment() {
                const phone = (byId('customerPhone')?.value || '').trim();
                if (!phone) return notify('Telefon numarasi zorunlu.', 'warning');
                if (!state.selectedServiceIds.length) return notify('En az bir hizmet secmelisiniz.', 'warning');
                if (!state.selectedDate) return notify('Lutfen tarih seciniz.', 'warning');
                if (!state.selectedTime) return notify('Lutfen saat seciniz.', 'warning');

                let name = (byId('customerName')?.value || '').trim();
                let surname = (byId('customerSurname')?.value || '').trim();
                let age = (byId('customerAge')?.value || '').trim();

                if (!state.isRegistered) {
                    if (!name || !surname || !age) {
                        return notify('Ad, soyad ve yas alanlari zorunludur.', 'warning');
                    }
                }

                const referralCode = (byId('referralCodeStep4')?.value || byId('referralCode')?.value || '').trim() || null;
                const payload = {
                    salon_id: state.salonId,
                    service_id: state.selectedServiceIds[0] || null,
                    service_ids: state.selectedServiceIds,
                    name: name || null,
                    surname: surname || null,
                    age: age ? parseInt(age, 10) : null,
                    phone: phone,
                    customer_id: state.customerId,
                    referral_code: referralCode,
                    date: state.selectedDate,
                    time: state.selectedTime,
                    recurring: getRecurringData()
                };

                const restore = setButtonLoading('submitBtn', '<i class="bi bi-hourglass-split me-1"></i>Gonderiliyor...');
                try {
                    const response = await fetch('{{ route("public.appointment-request.store") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify(payload)
                    });
                    const data = await response.json().catch(() => ({}));
                    if (!response.ok || !data.success) {
                        const errorMessage = data.message || 'Randevu olusturulamadi.';
                        throw new Error(errorMessage);
                    }

                    const modalInstance = window.bootstrap?.Modal?.getOrCreateInstance(modalEl);
                    if (modalInstance) modalInstance.hide();
                    notify('Randevu talebiniz basariyla alindi.', 'success');
                } catch (error) {
                    notify(error.message || 'Randevu talebi gonderilemedi.', 'error');
                } finally {
                    restore();
                }
            }

            async function checkPhone() {
                const phone = (byId('customerPhone')?.value || '').trim();
                if (!phone) return notify('Lutfen telefon numarasi giriniz.', 'warning');
                const restore = setButtonLoading('verifyPhoneBtn', '<i class="bi bi-hourglass-split me-1"></i>Kontrol Ediliyor...');
                try {
                    const data = await requestOtp(phone, byId('customerName')?.value || '');
                    if (!data.success) throw new Error(data.message || 'Telefon kontrolu basarisiz.');

                    const customerInfo = byId('customerInfo');
                    const customerInfoText = byId('customerInfoText');
                    if (customerInfo) customerInfo.style.display = 'block';

                    state.isRegistered = !!data.is_registered;
                    state.customerId = data.customer_id || null;
                    if (state.isRegistered) {
                        if (byId('customerName')) byId('customerName').value = data.customer_name || '';
                        if (byId('customerSurname')) byId('customerSurname').value = data.customer_surname || '';
                        if (byId('customerAge')) byId('customerAge').value = data.customer_age || '';
                        if (customerInfoText) customerInfoText.textContent = 'Kayıtlı müşteri bulundu. OTP doğrulamasına geçiliyor.';
                        setStep(3);
                    } else {
                        if (customerInfoText) customerInfoText.textContent = 'Yeni müşteri. Lütfen bilgilerinizi tamamlayın.';
                        setStep(2);
                    }
                    startResendCooldown(60);
                } catch (error) {
                    notify(error.message || 'Telefon kontrolu sirasinda hata olustu.', 'error');
                } finally {
                    restore();
                }
            }

            async function resendOtp() {
                if (state.resendCooldown > 0) return;
                const phone = (byId('customerPhone')?.value || '').trim();
                if (!phone) return notify('Telefon numarasi eksik.', 'warning');
                const restore = setButtonLoading('resendOTPBtn', '<i class="bi bi-hourglass-split me-1"></i>Gonderiliyor...');
                try {
                    const data = await requestOtp(phone, byId('customerName')?.value || '');
                    if (!data.success) throw new Error(data.message || 'OTP gonderilemedi.');
                    notify('Doğrulama kodu tekrar gönderildi.', 'success');
                    startResendCooldown(60);
                } catch (error) {
                    notify(error.message || 'OTP tekrar gonderilemedi.', 'error');
                } finally {
                    restore();
                }
            }

            async function nextStep() {
                if (state.currentStep === 2) {
                    const name = (byId('customerName')?.value || '').trim();
                    const surname = (byId('customerSurname')?.value || '').trim();
                    const age = (byId('customerAge')?.value || '').trim();
                    if (!name || !surname || !age) return notify('Lutfen ad, soyad ve yas bilgilerinizi doldurun.', 'warning');
                    setStep(3);
                    return;
                }
                if (state.currentStep === 3) {
                    const otpCode = (byId('otpCode')?.value || '').trim();
                    if (otpCode.length !== 6) return notify('Lutfen 6 haneli OTP kodu giriniz.', 'warning');
                    const verified = await verifyOtp(otpCode);
                    if (!verified) return notify('OTP kodu dogrulanamadi.', 'error');
                    const referralContainer = byId('referralCodeStep4Container');
                    if (referralContainer) referralContainer.style.display = 'block';
                    setStep(4);
                    return;
                }
                if (state.currentStep === 4) {
                    if (!state.selectedServiceIds.length) return notify('Lutfen en az bir hizmet seciniz.', 'warning');
                    setStep(5);
                    return;
                }
                if (state.currentStep === 5) {
                    if (!state.selectedDate) return notify('Lutfen bir tarih seciniz.', 'warning');
                    setStep(6);
                    return;
                }
            }

            function prevStep() {
                if (state.currentStep <= 1) return;
                if (state.currentStep === 3 && state.isRegistered) {
                    setStep(1);
                    return;
                }
                setStep(state.currentStep - 1);
            }

            function bindButtons() {
                const verifyBtn = byId('verifyPhoneBtn');
                const resendBtn = byId('resendOTPBtn');
                const nextBtn = byId('nextStepBtn');
                const prevBtn = byId('prevStepBtn');
                const submitBtn = byId('submitBtn');

                if (verifyBtn) verifyBtn.onclick = (event) => { event.preventDefault(); event.stopPropagation(); checkPhone(); };
                if (resendBtn) resendBtn.onclick = (event) => { event.preventDefault(); event.stopPropagation(); resendOtp(); };
                if (nextBtn) nextBtn.onclick = (event) => { event.preventDefault(); event.stopPropagation(); nextStep(); };
                if (prevBtn) prevBtn.onclick = (event) => { event.preventDefault(); event.stopPropagation(); prevStep(); };
                if (submitBtn) submitBtn.onclick = (event) => { event.preventDefault(); event.stopPropagation(); submitAppointment(); };
            }

            modalEl.addEventListener('click', function (event) {
                const categoryBtn = event.target.closest('.step-category-tab-btn[data-step-category]');
                if (categoryBtn && modalEl.contains(categoryBtn)) {
                    event.preventDefault();
                    event.stopPropagation();
                    switchStepServiceCategory(categoryBtn.getAttribute('data-step-category'));
                    return;
                }

                const serviceCard = event.target.closest('.service-option-card[data-service-id]');
                if (serviceCard && modalEl.contains(serviceCard)) {
                    event.preventDefault();
                    event.stopPropagation();
                    selectService(serviceCard.getAttribute('data-service-id'));
                    return;
                }

                const dateCard = event.target.closest('.date-option-card[data-date]');
                if (dateCard && modalEl.contains(dateCard)) {
                    event.preventDefault();
                    event.stopPropagation();
                    selectDate(dateCard.getAttribute('data-date'));
                    return;
                }

                const timeBtn = event.target.closest('.time-slot-btn[data-time]');
                if (timeBtn && modalEl.contains(timeBtn) && !timeBtn.disabled) {
                    event.preventDefault();
                    event.stopPropagation();
                    selectTime(timeBtn.getAttribute('data-time'));
                }
            }, true);

            const phoneInput = byId('customerPhone');
            if (phoneInput) {
                phoneInput.addEventListener('keydown', function (event) {
                    if (event.key === 'Enter') {
                        event.preventDefault();
                        checkPhone();
                    }
                });
            }

            window.openAppointmentModal = function (serviceId) {
                resetWizard(serviceId || null);
                const instance = window.bootstrap?.Modal?.getOrCreateInstance(modalEl);
                if (instance) instance.show();
            };
            window.checkPhone = checkPhone;
            window.resendOTP = resendOtp;
            window.nextStep = nextStep;
            window.prevStep = prevStep;
            window.selectService = selectService;
            window.selectDate = selectDate;
            window.selectTime = selectTime;
            window.switchStepServiceCategory = switchStepServiceCategory;
            window.__appointmentWizardV2Api = {
                checkPhone,
                resendOtp,
                nextStep,
                prevStep,
                submitAppointment
            };

            // Force single-source click handling for critical buttons.
            document.addEventListener('click', function (event) {
                const verifyBtn = event.target.closest('#verifyPhoneBtn');
                if (verifyBtn && modalEl.contains(verifyBtn)) {
                    event.preventDefault();
                    event.stopPropagation();
                    if (typeof event.stopImmediatePropagation === 'function') event.stopImmediatePropagation();
                    checkPhone();
                    return;
                }
                const resendBtn = event.target.closest('#resendOTPBtn');
                if (resendBtn && modalEl.contains(resendBtn)) {
                    event.preventDefault();
                    event.stopPropagation();
                    if (typeof event.stopImmediatePropagation === 'function') event.stopImmediatePropagation();
                    resendOtp();
                    return;
                }
                const nextBtn = event.target.closest('#nextStepBtn');
                if (nextBtn && modalEl.contains(nextBtn)) {
                    event.preventDefault();
                    event.stopPropagation();
                    if (typeof event.stopImmediatePropagation === 'function') event.stopImmediatePropagation();
                    nextStep();
                    return;
                }
                const prevBtn = event.target.closest('#prevStepBtn');
                if (prevBtn && modalEl.contains(prevBtn)) {
                    event.preventDefault();
                    event.stopPropagation();
                    if (typeof event.stopImmediatePropagation === 'function') event.stopImmediatePropagation();
                    prevStep();
                    return;
                }
                const submitBtn = event.target.closest('#submitBtn');
                if (submitBtn && modalEl.contains(submitBtn)) {
                    event.preventDefault();
                    event.stopPropagation();
                    if (typeof event.stopImmediatePropagation === 'function') event.stopImmediatePropagation();
                    submitAppointment();
                }
            }, true);

            bindButtons();
            resetWizard(null);
        })();
    </script>
</body>
</html>
