@extends('layouts.admin')

@section('title', 'Uygulama İndirme Linkleri')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.superadmin.dashboard') }}">Süper Admin</a></li>
    <li class="breadcrumb-item active">Uygulama İndirme Linkleri</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                <i class="bi bi-download"></i> Uygulama İndirme Linkleri
            </h2>
            <p class="text-muted mb-0">Ana sayfadaki uygulama indirme linklerini yönetin</p>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-gear me-2"></i>İndirme Linkleri Ayarları</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.superadmin.app-downloads.update') }}">
                @csrf
                
                <div class="row g-4">
                    <!-- Windows -->
                    <div class="col-12">
                        <div class="card border" style="border-color: #e2e8f0 !important;">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0">
                                        <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-size: 28px;">
                                            <i class="bi bi-windows"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h5 class="mb-1 fw-bold">Windows Uygulaması</h5>
                                        <p class="text-muted mb-0 small">Masaüstü bilgisayarlar için indirme linki</p>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Windows İndirme Linki</label>
                                    <input type="url" 
                                           name="windows_download_url" 
                                           class="form-control @error('windows_download_url') is-invalid @enderror" 
                                           value="{{ old('windows_download_url', $downloadUrls['windows_download_url'] ?? '') }}"
                                           placeholder="https://example.com/download/windows.exe">
                                    <small class="form-text text-muted">
                                        Windows setup dosyasının tam URL'sini girin. Eğer boş bırakılırsa, sistem otomatik olarak storage/app/public/ klasöründeki dosyayı kullanır.
                                    </small>
                                    @error('windows_download_url')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Android -->
                    <div class="col-12">
                        <div class="card border" style="border-color: #e2e8f0 !important;">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0">
                                        <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-size: 28px;">
                                            <i class="bi bi-android2"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h5 class="mb-1 fw-bold">Android Uygulaması</h5>
                                        <p class="text-muted mb-0 small">Android cihazlar için Google Play Store veya APK indirme linki</p>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Android İndirme Linki</label>
                                    <input type="url" 
                                           name="android_download_url" 
                                           class="form-control @error('android_download_url') is-invalid @enderror" 
                                           value="{{ old('android_download_url', $downloadUrls['android_download_url'] ?? '') }}"
                                           placeholder="https://play.google.com/store/apps/details?id=com.salonay.app veya https://example.com/app.apk">
                                    <small class="form-text text-muted">
                                        Google Play Store linki veya doğrudan APK indirme linkini girin. Boş bırakılırsa "Yakında" butonu gösterilir.
                                    </small>
                                    @error('android_download_url')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- iOS -->
                    <div class="col-12">
                        <div class="card border" style="border-color: #e2e8f0 !important;">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0">
                                        <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #1e293b 0%, #475569 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-size: 28px;">
                                            <i class="bi bi-apple"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h5 class="mb-1 fw-bold">iOS Uygulaması</h5>
                                        <p class="text-muted mb-0 small">iPhone ve iPad için App Store indirme linki</p>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-bold">iOS İndirme Linki</label>
                                    <input type="url" 
                                           name="ios_download_url" 
                                           class="form-control @error('ios_download_url') is-invalid @enderror" 
                                           value="{{ old('ios_download_url', $downloadUrls['ios_download_url'] ?? '') }}"
                                           placeholder="https://apps.apple.com/tr/app/salonay/id123456789">
                                    <small class="form-text text-muted">
                                        App Store linkini girin. Boş bırakılırsa "Yakında" butonu gösterilir.
                                    </small>
                                    @error('ios_download_url')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.superadmin.dashboard') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri Dön
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save me-2"></i>Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Bilgi Kartı -->
    <div class="card mt-4 border-info" style="border-width: 2px !important;">
        <div class="card-body">
            <div class="d-flex align-items-start">
                <div class="flex-shrink-0">
                    <i class="bi bi-info-circle text-info" style="font-size: 24px;"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="fw-bold mb-2">Bilgi</h6>
                    <ul class="mb-0 small text-muted">
                        <li>Windows linki boş bırakılırsa, sistem otomatik olarak <code>storage/app/public/Salonay Setup.exe</code> dosyasını kullanır.</li>
                        <li>Android ve iOS linkleri boş bırakılırsa, ana sayfada "Yakında" butonu gösterilir.</li>
                        <li>Linkler geçerli URL formatında olmalıdır (http:// veya https:// ile başlamalı).</li>
                        <li>Değişiklikler kaydedildikten sonra ana sayfada hemen yansır.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

