@extends('layouts.admin')

@section('title', 'Başvurular')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-file-earmark-text"></i> Başvurular</h1>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Şirket Adı</th>
                            <th>İletişim Kişisi</th>
                            <th>E-posta</th>
                            <th>Telefon</th>
                            <th>Durum</th>
                            <th>Tarih</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($applications as $application)
                        <tr>
                            <td>{{ $application->company_name }}</td>
                            <td>{{ $application->contact_person }}</td>
                            <td>{{ $application->email }}</td>
                            <td>{{ $application->phone }}</td>
                            <td>
                                @if($application->status === 'pending')
                                    <span class="badge bg-warning">Bekliyor</span>
                                @elseif($application->status === 'approved')
                                    <span class="badge bg-success">Onaylandı</span>
                                @else
                                    <span class="badge bg-danger">Reddedildi</span>
                                @endif
                            </td>
                            <td>{{ $application->created_at->format('d.m.Y H:i') }}</td>
                            <td>
                                <a href="{{ route('admin.superadmin.applications.show', $application->id) }}" class="btn btn-sm btn-primary">
                                    <i class="bi bi-eye"></i> Detay
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">Henüz başvuru yok</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                {{ $applications->links() }}
            </div>
        </div>
    </div>
</div>
@endsection

